/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.yunxi.dg.base.center.item.eo.ShelfTaskDgEo;
import com.yunxi.dg.base.center.item.service.entity.IShelfSchedulerDgService;
import java.text.SimpleDateFormat;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="shelfSchedulerDgService")
public class ShelfSchedulerDgServiceImpl
implements IShelfSchedulerDgService {
    private static Logger logger = LoggerFactory.getLogger(ShelfSchedulerDgServiceImpl.class);
    @Resource
    private ITaskApi taskApi;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;

    @Override
    public Long createShelfTask(ShelfTaskDgEo shelfTaskDgEo, String bizName, String bizCode, JSONObject params) {
        String format = "ss mm HH dd MM ? yyyy";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String cron = null;
        if (shelfTaskDgEo.getShelfTime() != null) {
            cron = sdf.format(shelfTaskDgEo.getShelfTime());
        }
        shelfTaskDgEo.setId(this.generateId());
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode(bizCode);
        dto.setBizName(bizName);
        if (!params.isEmpty()) {
            dto.setParams(JSON.toJSONString((Object)params));
        }
        dto.setScheduleExpression(cron);
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc("");
        dto.setTaskName(bizName + "(" + shelfTaskDgEo.getId() + ")");
        dto.setInstanceId(shelfTaskDgEo.getInstanceId());
        dto.setTenantId(shelfTaskDgEo.getTenantId());
        RestResponse addResult = this.taskApi.addWithBiz(dto);
        Long taskId = (Long)addResult.getData();
        logger.info("==============\u5f53\u524dtaskId\u662f\uff1a\u53c2\u6570:{}", (Object)taskId);
        this.taskApi.enableById(taskId, "");
        return (Long)addResult.getData();
    }

    private Long generateId() {
        return IdGenrator.getDistributedId();
    }
}

