/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.util;

import com.yunxi.dg.base.center.item.service.util.LatLngDg;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class LocationUtils {
    private static double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(String originLon, String originLat, String destinationLon, String destinationLat) {
        double radLat1 = LocationUtils.rad(Double.parseDouble(originLat));
        double radLat2 = LocationUtils.rad(Double.parseDouble(destinationLat));
        double a = radLat1 - radLat2;
        double b = LocationUtils.rad(Double.parseDouble(originLon)) - LocationUtils.rad(Double.parseDouble(destinationLon));
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS;
        s = (double)Math.round(s * 100.0) / 100.0;
        return s *= 1000.0;
    }

    public static List<LatLngDg> sort(List<LatLngDg> list) {
        double plusX = 0.0;
        double plusY = 0.0;
        for (LatLngDg latLngDg : list) {
            plusX += latLngDg.latitude.doubleValue();
            plusY += latLngDg.longitude.doubleValue();
        }
        LatLngDg center = new LatLngDg(plusX / (double)list.size(), plusY / (double)list.size());
        for (LatLngDg latLngDg : list) {
            latLngDg.setAngle(LocationUtils.getAngle(center.getLatitude(), center.getLongitude(), latLngDg.getLatitude(), latLngDg.getLongitude()));
        }
        List<LatLngDg> list2 = list.stream().sorted(Comparator.comparing(LatLngDg::getAngle)).collect(Collectors.toList());
        return list2;
    }

    public static void main(String[] args) {
        double distance = LocationUtils.getDistance("113.451704", "23.107886", "113.45172", "23.107891");
        System.out.println(distance);
    }

    public static double getAngle(double lat_a, double lng_a, double lat_b, double lng_b) {
        double y = Math.sin(lng_b - lng_a) * Math.cos(lat_b);
        double x = Math.cos(lat_a) * Math.sin(lat_b) - Math.sin(lat_a) * Math.cos(lat_b) * Math.cos(lng_b - lng_a);
        double brng = Math.atan2(y, x);
        if ((brng = Math.toDegrees(brng)) < 0.0) {
            brng += 360.0;
        }
        return brng;
    }
}

