/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.event.localEvent;

import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.data.dto.dto.DictDto;
import com.yunxi.dg.base.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemVersionDgRespDto;
import com.yunxi.dg.base.center.item.event.localEvent.SkuBomMqEvent;
import com.yunxi.dg.base.center.item.service.entity.IItemPushOaAssistService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class SkuBomListener {
    private static final Logger log = LoggerFactory.getLogger(SkuBomListener.class);
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IItemPushOaAssistService itemPushOaAssistService;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={SkuBomMqEvent.class})
    public void skuBomChange(SkuBomMqEvent skuBomMqEvent) {
        DgItemSkuDetailRespDto dgItemSkuDetailRespDto = skuBomMqEvent.getDgItemSkuDetailRespDto();
        if (Objects.isNull(dgItemSkuDetailRespDto)) {
            log.info("dgItemSkuDetailRespDto is null");
        }
        try {
            DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("isPushOa", "yunxi-dg-base-center-item"));
            if (Objects.nonNull(dictDto) && YesNoEnum.YES.getValue().equals(dictDto.getStatus())) {
                List versionDgReqDtoList = dgItemSkuDetailRespDto.getVersionDgReqDtos();
                for (ItemVersionDgRespDto versionDgReqDto : versionDgReqDtoList) {
                    dgItemSkuDetailRespDto.setVersionDgReqDtos((List)Lists.newArrayList((Object[])new ItemVersionDgRespDto[]{versionDgReqDto}));
                    this.itemPushOaAssistService.pushBomToOa(dgItemSkuDetailRespDto);
                }
            }
        }
        catch (Exception e) {
            log.info("Bom\u65b0\u589e\u4e8b\u4ef6\u76d1\u542c\u5f02\u5e38:{}", (Throwable)e);
        }
    }
}

