/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.yunxi.dg.base.center.item.api.brand.IBrandDgApi;
import com.yunxi.dg.base.center.item.dto.request.BrandReqDto;
import com.yunxi.dg.base.center.item.dto.request.BrandStatusReqDto;
import com.yunxi.dg.base.center.item.eo.BrandDgEo;
import com.yunxi.dg.base.center.item.service.entity.IBrandDgService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BrandDgApiImpl
implements IBrandDgApi {
    @Resource
    private IBrandDgService brandDgService;

    public RestResponse<Void> batchRemoveByIds(List<Long> ids) {
        this.brandDgService.removeByIds(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeByCode(List<String> brandCodes) {
        this.brandDgService.removeByCode(brandCodes);
        return RestResponse.VOID;
    }

    public RestResponse<Long> modifyStatus(BrandStatusReqDto brandStatusReqDto) {
        BrandDgEo brandDgEo = BrandDgEo.newInstance();
        brandDgEo.setId(brandStatusReqDto.getId());
        AssertUtils.notNull((Object)brandStatusReqDto.getStatus(), (String)"\u542f\u7528/\u7981\u7528\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
        brandDgEo.setStatus(brandStatusReqDto.getStatus());
        return new RestResponse((Object)this.brandDgService.updateStatus(brandDgEo));
    }

    public RestResponse<Void> batchModifyStatus(BrandStatusReqDto brandStatusReqDto) {
        this.brandDgService.batchUpdateStatus(brandStatusReqDto.getIds(), brandStatusReqDto.getStatus());
        return RestResponse.VOID;
    }

    public RestResponse<Long> addBrand(BrandReqDto requestBrandDto) {
        BrandDgEo brandDgEo = BrandDgEo.newInstance((Map)requestBrandDto.getExtFields());
        requestBrandDto.setId(null);
        DtoHelper.dto2Eo((BaseVo)requestBrandDto, (BaseEo)brandDgEo);
        return new RestResponse((Object)this.brandDgService.addBrand(brandDgEo));
    }

    public RestResponse<Void> modifyBrand(BrandReqDto requestBrandDto) {
        AssertUtils.notNull((Object)requestBrandDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtils.notNull((Object)requestBrandDto.getId(), (String)"\u8bf7\u6c42id\u4e0d\u53ef\u4e3a\u7a7a");
        this.brandDgService.modifyBrand(requestBrandDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> importInsertBatch(List<BrandReqDto> dtos) {
        this.brandDgService.importInsertBatch(dtos);
        return RestResponse.VOID;
    }
}

