/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.convert.entity.ItemCombinationConverter;
import com.yunxi.dg.base.center.item.domain.entity.IItemCombinationDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemRCombinationDomain;
import com.yunxi.dg.base.center.item.dto.entity.BatchOperateDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemCombinationDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemCombinationPageReqDto;
import com.yunxi.dg.base.center.item.dto.request.BatchAddItemReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemCombinationStatusReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemCombinationDetailDto;
import com.yunxi.dg.base.center.item.eo.ItemCombinationEo;
import com.yunxi.dg.base.center.item.eo.ItemRCombinationEo;
import com.yunxi.dg.base.center.item.service.entity.IItemCombinationService;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import com.yunxi.dg.base.center.item.service.util.ConvertDgUtil;
import com.yunxi.dg.base.center.item.service.util.CreateCodeUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemCombinationServiceImpl
extends BaseServiceImpl<ItemCombinationDto, ItemCombinationEo, IItemCombinationDomain>
implements IItemCombinationService {
    private static final Logger log = LoggerFactory.getLogger(ItemCombinationServiceImpl.class);
    @Resource
    private IItemCombinationDomain itemCombinationDomain;
    @Resource
    private IItemRCombinationDomain itemRCombinationDomain;
    @Resource
    private IItemSkuDgService itemSkuDgService;

    public ItemCombinationServiceImpl(IItemCombinationDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ItemCombinationDto, ItemCombinationEo> converter() {
        return ItemCombinationConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> add(ItemCombinationDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        Integer itemNum = 0;
        if (CollectionUtil.isNotEmpty((Collection)dto.getItemIds())) {
            itemNum = dto.getItemIds().size();
        }
        dto.setCode(CreateCodeUtil.getCode());
        dto.setItemNum(itemNum);
        this.checkName(dto);
        ItemCombinationEo itemCombinationEo = (ItemCombinationEo)BeanUtil.copyProperties((Object)dto, ItemCombinationEo.class, (String[])new String[0]);
        this.itemCombinationDomain.insert((BaseEo)itemCombinationEo);
        this.batchAddItemRCombinationEo(dto, itemCombinationEo);
        return new RestResponse((Object)itemCombinationEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modify(ItemCombinationDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getId(), (String)"\u5546\u54c1\u7ec4\u5408id\u4e0d\u53ef\u4e3a\u7a7a!");
        ItemCombinationEo itemCombinationEo = (ItemCombinationEo)this.itemCombinationDomain.selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)itemCombinationEo, (String)"\u5546\u54c1\u7ec4\u5408\u4fe1\u606f\u4e0d\u5b58\u5728!");
        this.checkName(dto);
        ItemCombinationEo updateCombinationEo = (ItemCombinationEo)BeanUtil.copyProperties((Object)dto, ItemCombinationEo.class, (String[])new String[0]);
        updateCombinationEo.setId(itemCombinationEo.getId());
        updateCombinationEo.setCode(null);
        this.itemCombinationDomain.updateSelective((BaseEo)updateCombinationEo);
        this.itemRCombinationDomain.removeCombinationIds(Arrays.asList(itemCombinationEo.getId()));
        Integer type = Objects.nonNull(dto.getType()) ? dto.getType() : 0;
        List<ItemRCombinationEo> insertEos = this.getItemRCombinationEos(dto.getItemIds(), itemCombinationEo.getId(), type);
        if (CollectionUtil.isNotEmpty(insertEos)) {
            this.itemRCombinationDomain.insertBatch(insertEos);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<ItemCombinationDetailDto> queryById(Long id) {
        List eos;
        ItemCombinationEo itemCombinationEo = (ItemCombinationEo)this.itemCombinationDomain.selectByPrimaryKey(id);
        if (Objects.isNull(itemCombinationEo)) {
            return null;
        }
        ItemCombinationDetailDto itemCombinationDto = (ItemCombinationDetailDto)BeanUtil.copyProperties((Object)itemCombinationEo, ItemCombinationDetailDto.class, (String[])new String[0]);
        if (Objects.nonNull(itemCombinationDto)) {
            Map<Long, Integer> itemNumMap = this.getItemNum(Arrays.asList(itemCombinationDto.getId()));
            int itemNum = Objects.nonNull(itemNumMap.get(itemCombinationDto.getId())) ? itemNumMap.get(itemCombinationDto.getId()) : 0;
            itemCombinationDto.setItemNum(Integer.valueOf(itemNum));
        }
        if (CollectionUtil.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)this.itemRCombinationDomain.filter().eq((Object)"combination_id", (Object)itemCombinationEo.getId())).list()))) {
            List itemIds = eos.stream().map(ItemRCombinationEo::getItemId).collect(Collectors.toList());
            ItemQueryDgReqDto itemDgReqDto = new ItemQueryDgReqDto();
            itemDgReqDto.setSkuIds(itemIds);
            List<DgItemSkuPageRespDto> dgItemSkuPageRespDtos = this.itemSkuDgService.queryItemByList(itemDgReqDto);
            itemCombinationDto.setDgItemSkuPageRespDtos(dgItemSkuPageRespDtos);
        }
        return new RestResponse((Object)itemCombinationDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> removeByIds(List<Long> ids) {
        AssertUtils.notEmpty(ids, (String)"\u5220\u9664\u5546\u54c1\u7ec4\u5408,\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        this.itemCombinationDomain.logicDeleteByIds(ids);
        Map map = this.itemRCombinationDomain.groupByCombinationIdCount(ids);
        for (Long id : map.keySet()) {
            Integer count = (Integer)map.get(id);
            if (Objects.isNull(count)) continue;
            AssertUtils.isTrue((count < 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u7ec4\u5408\u5b58\u5728\u5173\u8054sku\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<PageInfo<ItemCombinationDto>> queryByPage(ItemCombinationPageReqDto dto) {
        PageInfo<ItemCombinationDto> pageInfo = new PageInfo<ItemCombinationDto>();
        ItemCombinationEo conditionEo = this.getItemCombinationCondition(dto);
        PageInfo eoPageInfo = this.itemCombinationDomain.selectPage((BaseEo)conditionEo, dto.getPageNum(), dto.getPageSize());
        pageInfo = ConvertDgUtil.convertPage(eoPageInfo, ItemCombinationDto.class);
        if (CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List<Long> ids = pageInfo.getList().stream().map(BaseDto::getId).collect(Collectors.toList());
            Map<Long, Integer> itemNumMap = this.getItemNum(ids);
            for (ItemCombinationDto itemCombinationDto : pageInfo.getList()) {
                int itemNum = Objects.nonNull(itemNumMap.get(itemCombinationDto.getId())) ? itemNumMap.get(itemCombinationDto.getId()) : 0;
                itemCombinationDto.setItemNum(Integer.valueOf(itemNum));
            }
        }
        return new RestResponse(pageInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<BatchOperateDto> changeStatus(ItemCombinationStatusReqDto dto) {
        BatchOperateDto operateDto = new BatchOperateDto();
        Integer failCount = 0;
        Integer successCount = 0;
        Map<Long, ItemCombinationEo> itemCombinationEoMap = this.getItemCombinationEoMap(dto.getIdList());
        for (Long id : dto.getIdList()) {
            ItemCombinationEo itemCombinationEo = itemCombinationEoMap.get(id);
            if (Objects.nonNull(itemCombinationEo) && !Objects.equals(itemCombinationEo.getStatus(), dto.getStatus())) {
                successCount = successCount + 1;
                continue;
            }
            failCount = failCount + 1;
        }
        this.itemCombinationDomain.changeStatus(dto.getIdList(), dto.getStatus());
        operateDto.setSuccessCount(successCount);
        operateDto.setFailCount(failCount);
        return new RestResponse((Object)operateDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> batchAddItem(BatchAddItemReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        if (Objects.isNull(dto.getId()) && Objects.isNull(dto.getCode())) {
            throw new BizException("\u8bf7\u6c42\u7ec4\u5408\u5546\u54c1Id\u6216\u7f16\u7801\u4e3a\u7a7a!");
        }
        Integer type = Objects.nonNull(dto.getType()) ? dto.getType() : 0;
        ItemCombinationEo one = (ItemCombinationEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemCombinationDomain.filter().eq(Objects.nonNull(dto.getId()), (Object)"id", (Object)dto.getId())).eq(Objects.nonNull(dto.getCode()), (Object)"code", (Object)dto.getCode())).one();
        AssertUtils.notNull((Object)one, (String)"\u5546\u54c1\u7ec4\u5408\u4fe1\u606f\u4e0d\u5b58\u5728!");
        List itemIds = dto.getItemIds();
        if (Objects.equals(1, dto.getOperateType())) {
            List<ItemRCombinationEo> insertEos;
            List eos = ((ExtQueryChainWrapper)this.itemRCombinationDomain.filter().in((Object)"item_id", (Collection)itemIds)).list();
            if (CollectionUtil.isNotEmpty((Collection)eos)) {
                Set existItemIds = eos.stream().map(ItemRCombinationEo::getItemId).collect(Collectors.toSet());
                itemIds.removeAll(existItemIds);
            }
            if (CollectionUtil.isNotEmpty(insertEos = this.getItemRCombinationEos(itemIds, one.getId(), type))) {
                this.itemRCombinationDomain.insertBatch(insertEos);
            }
        } else if (Objects.equals(0, dto.getOperateType())) {
            this.itemRCombinationDomain.removeItemIds(new ArrayList(itemIds));
        }
        return RestResponse.VOID;
    }

    private List<ItemRCombinationEo> getItemRCombinationEos(List<Long> itemIds, Long combinationId, Integer type) {
        ArrayList<ItemRCombinationEo> insertEos = new ArrayList<ItemRCombinationEo>();
        if (CollectionUtil.isEmpty(itemIds)) {
            return insertEos;
        }
        HashSet<Long> itemIdList = new HashSet<Long>(itemIds);
        for (Long itemId : itemIdList) {
            ItemRCombinationEo itemRCombinationEo = new ItemRCombinationEo();
            itemRCombinationEo.setCombinationId(combinationId);
            itemRCombinationEo.setItemId(itemId);
            itemRCombinationEo.setType(type);
            insertEos.add(itemRCombinationEo);
        }
        return insertEos;
    }

    private Map<Long, Integer> getItemNum(List<Long> ids) {
        Map<Long, Integer> itemNumMap = new HashMap<Long, Integer>();
        if (CollectionUtil.isNotEmpty(ids)) {
            Map itemNumResult = this.itemRCombinationDomain.groupByCombinationIdCount(ids);
            log.info("\u5546\u54c1\u7ec4\u5408\u5546\u54c1\u6570\u91cf\u67e5\u8be2\u7ed3\u679c=============>{}", (Object)JacksonUtil.toJson((Object)itemNumResult));
            if (Objects.nonNull(itemNumResult) && !itemNumResult.isEmpty()) {
                itemNumMap = itemNumResult;
            }
        }
        return itemNumMap;
    }

    private Map<Long, ItemCombinationEo> getItemCombinationEoMap(List<Long> idList) {
        Map<Long, Object> itemCombinationEoMap = new HashMap<Long, ItemCombinationEo>();
        if (CollectionUtil.isEmpty(idList)) {
            return itemCombinationEoMap;
        }
        List itemCombinationEos = this.itemCombinationDomain.selectByIds(idList);
        if (CollectionUtil.isNotEmpty((Collection)itemCombinationEos)) {
            itemCombinationEoMap = itemCombinationEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        }
        return itemCombinationEoMap;
    }

    private ItemCombinationEo getItemCombinationCondition(ItemCombinationPageReqDto dto) {
        ItemCombinationEo itemCombinationEo = new ItemCombinationEo();
        itemCombinationEo.setDr(0);
        BeanUtil.copyProperties((Object)dto, (Object)itemCombinationEo, (String[])new String[0]);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (Objects.nonNull(dto)) {
            if (CollectionUtil.isNotEmpty((Collection)dto.getIdList())) {
                sqlFilters.add(SqlFilter.in((String)"id", (Object)dto.getIdList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getCodeList())) {
                sqlFilters.add(SqlFilter.in((String)"code", (Object)dto.getCodeList()));
            }
            if (Objects.nonNull(dto.getCode())) {
                itemCombinationEo.setCode(null);
                sqlFilters.add(SqlFilter.like((String)"code", (Object)dto.getCode()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getNameList())) {
                sqlFilters.add(SqlFilter.in((String)"name", (Object)dto.getNameList()));
            }
            if (Objects.nonNull(dto.getName())) {
                itemCombinationEo.setName(null);
                sqlFilters.add(SqlFilter.like((String)"name", (Object)dto.getName()));
            }
            if (Objects.nonNull(dto.getCreateStartTime())) {
                sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)dto.getCreateStartTime()));
            }
            if (Objects.nonNull(dto.getCreateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"create_time", (Object)dto.getCreateEndTime()));
            }
            if (Objects.nonNull(dto.getUpdateStartTime())) {
                sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)dto.getUpdateStartTime()));
            }
            if (Objects.nonNull(dto.getUpdateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"update_time", (Object)dto.getUpdateEndTime()));
            }
        }
        itemCombinationEo.setSqlFilters(sqlFilters);
        itemCombinationEo.setOrderByDesc("id");
        return itemCombinationEo;
    }

    private void checkName(ItemCombinationDto dto) {
        if (Objects.isNull(dto) || Objects.isNull(dto.getName())) {
            return;
        }
        List nameList = ((ExtQueryChainWrapper)this.itemCombinationDomain.filter().eq((Object)"name", (Object)dto.getName())).list();
        if (CollectionUtil.isEmpty((Collection)nameList)) {
            return;
        }
        AssertUtils.isFalse((nameList.size() > 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u7ec4\u5408\u540d\u79f0\u5df2\u91cd\u590d\u5b58\u5728!");
        AssertUtils.isTrue((boolean)Objects.equals(dto.getId(), ((ItemCombinationEo)nameList.get(0)).getId()), (String)"\u5546\u54c1\u7ec4\u5408\u540d\u79f0\u5df2\u5b58\u5728!");
    }

    private void batchAddItemRCombinationEo(ItemCombinationDto dto, ItemCombinationEo itemCombinationEo) {
        if (CollectionUtil.isEmpty((Collection)dto.getItemIds()) || Objects.isNull(itemCombinationEo.getId())) {
            return;
        }
        ArrayList<ItemRCombinationEo> itemRCombinationEos = new ArrayList<ItemRCombinationEo>();
        for (Long itemId : dto.getItemIds()) {
            ItemRCombinationEo itemRCombinationEo = new ItemRCombinationEo();
            itemRCombinationEo.setItemId(itemId);
            itemRCombinationEo.setCombinationId(itemCombinationEo.getId());
            itemRCombinationEo.setType(dto.getType());
            itemRCombinationEos.add(itemRCombinationEo);
        }
        this.itemRCombinationDomain.insertBatch(itemRCombinationEos);
    }
}

