/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.domain.entity.IItemMediasDgDomain;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemMediasDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.service.entity.IItemMediasDgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="itemMediasDgService")
public class ItemMediasDgServiceImpl
implements IItemMediasDgService {
    @Resource
    private IItemMediasDgDomain itemMediasDgDomain;

    @Override
    @Transactional
    public void modifyItemMedias(ItemMediasDgEo itemMediasDgEo) {
        this.itemMediasDgDomain.updateSelective((BaseEo)itemMediasDgEo);
    }

    @Override
    @Transactional
    public void removeItemMedias(ItemMediasDgEo itemMediasDgEo) {
        if (itemMediasDgEo == null) {
            throw new ItemBusinessRuntimeException("itemId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.itemMediasDgDomain.logicDelete((BaseEo)itemMediasDgEo);
    }

    @Override
    @Transactional
    public Long addItemMedias(ItemMediasDgEo itemMediasDgEo) {
        if (itemMediasDgEo == null) {
            throw new ItemBusinessRuntimeException("\u591a\u5a92\u4f53\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.itemMediasDgDomain.insert((BaseEo)itemMediasDgEo);
        return itemMediasDgEo.getId();
    }

    @Override
    @Transactional
    public List<ItemMediasDgEo> queryItemMedias(ItemMediasDgEo itemMediasDgEo) {
        if (itemMediasDgEo == null) {
            throw new ItemBusinessRuntimeException("\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.itemMediasDgDomain.selectList((BaseEo)itemMediasDgEo);
    }

    @Override
    @Transactional
    public void addBatchItemMedias(List<ItemMediasDgEo> itemMediasDgEoList) {
        if (itemMediasDgEoList == null) {
            throw new ItemBusinessRuntimeException("\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.itemMediasDgDomain.insertBatch(itemMediasDgEoList);
    }

    @Override
    @Transactional
    public void removeBatchItemMedias(List<Long> ids) {
        if (ids == null) {
            throw new ItemBusinessRuntimeException("\u5220\u9664\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.itemMediasDgDomain.deleteBatchMedias(ids);
    }

    @Override
    public List<ItemMediasDgRespDto> getMainPicByItemIds(List<Long> itemIds) {
        ArrayList<ItemMediasDgRespDto> itemMediasDgRespDtos = new ArrayList<ItemMediasDgRespDto>();
        HashMap result = new HashMap();
        List itemMediasDgEos = this.itemMediasDgDomain.selectByItemIds(itemIds);
        DtoHelper.eoList2DtoList((Collection)itemMediasDgEos, itemMediasDgRespDtos, ItemMediasDgRespDto.class);
        return itemMediasDgRespDtos;
    }

    @Override
    @Cacheable(value={"ITEM_MEDIA_CACHE"}, key="#itemId", unless="#result== null")
    public List<ItemMediasDgRespDto> queryByItemId(Long itemId) {
        List itemMediasDgEoList = this.itemMediasDgDomain.selectByItemId(itemId);
        ArrayList itemMediasDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemMediasDgEoList, (Collection)itemMediasDtoList, ItemMediasDgRespDto.class);
        return itemMediasDtoList;
    }

    @Override
    public List<ItemMediasDgRespDto> queryByItemIds(List<Long> itemIds) {
        List itemMediasDgEoList = this.itemMediasDgDomain.selectByItemIds(itemIds);
        ArrayList itemMediasDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemMediasDgEoList, (Collection)itemMediasDtoList, ItemMediasDgRespDto.class);
        return itemMediasDtoList;
    }

    @Override
    public void removeItemMediasBySkuIds(Set<Long> ids) {
        this.itemMediasDgDomain.removeItemMediasBySkuIds(ids);
    }

    @Override
    public void removeMediasByItemAndType(List<Long> itemIds, Integer itemType) {
        this.itemMediasDgDomain.removeMediasByItemAndType(itemIds, itemType);
    }

    @Override
    public List<ItemMediasDgRespDto> queryBySkuIds(List<Long> skuIds) {
        ArrayList<ItemMediasDgRespDto> skuMediasDtoList = new ArrayList<ItemMediasDgRespDto>();
        if (CollectionUtil.isNotEmpty(skuIds)) {
            List itemMediasEoList = ((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().in((Object)"sku_id", skuIds)).list();
            DtoHelper.eoList2DtoList((Collection)itemMediasEoList, skuMediasDtoList, ItemMediasDgRespDto.class);
        }
        return skuMediasDtoList;
    }
}

