/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.yunxi.dg.base.center.item.constants.ItemDgItemAttributeEnum;
import com.yunxi.dg.base.center.item.dto.request.ItemBundleDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemChangeApplyDgDto;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemPromotionDgService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemPromotionDgServiceImpl
implements IItemPromotionDgService {
    private static final Logger log = LoggerFactory.getLogger(ItemPromotionDgServiceImpl.class);
    @Resource
    private IItemDgService itemDgService;

    @Override
    public Long addItem(ItemChangeApplyDgDto changeApplyDto) {
        List skus = changeApplyDto.getSkus();
        AssertUtils.notEmpty((Collection)skus, (String)"sku\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.checkBetween((int)skus.size(), (int)1, (int)1);
        ItemBundleDgReqDto skuInfo = (ItemBundleDgReqDto)skus.get(0);
        skuInfo.setIsBatch(YesNoEnum.NO.getValue());
        changeApplyDto.setItemCode(skuInfo.getCode());
        changeApplyDto.setItemName(skuInfo.getName());
        changeApplyDto.setItemAttribute(ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PROMOTION.getType());
        for (ItemBundleDgReqDto changeApplyDtoSkus : changeApplyDto.getSkus()) {
            if (!Objects.nonNull(changeApplyDtoSkus.getSkuItemType())) continue;
            changeApplyDtoSkus.setItemType(changeApplyDtoSkus.getSkuItemType());
        }
        return this.itemDgService.addItem(changeApplyDto);
    }

    @Override
    public Long updateItemInfo(ItemChangeApplyDgDto changeApplyDto) {
        List skus = changeApplyDto.getSkus();
        AssertUtils.notEmpty((Collection)skus, (String)"sku\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.checkBetween((int)skus.size(), (int)1, (int)1);
        ItemBundleDgReqDto skuInfo = (ItemBundleDgReqDto)skus.get(0);
        changeApplyDto.setItemCode(skuInfo.getCode());
        changeApplyDto.setItemName(skuInfo.getName());
        changeApplyDto.setItemAttribute(ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PROMOTION.getType());
        for (ItemBundleDgReqDto changeApplyDtoSkus : changeApplyDto.getSkus()) {
            if (!Objects.nonNull(changeApplyDtoSkus.getSkuItemType())) continue;
            changeApplyDtoSkus.setItemType(changeApplyDtoSkus.getSkuItemType());
        }
        return this.itemDgService.updateItem(changeApplyDto);
    }
}

