/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.excel.ExcelUtils;
import com.dtyunxi.cube.framework.das.ComBaseDas;
import com.dtyunxi.cube.utils.FileUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirPropRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemPropRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IPropGroupDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IPropGroupRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IPropNameDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IPropValueDgDomain;
import com.yunxi.dg.base.center.item.dto.PropNameExceDglDto;
import com.yunxi.dg.base.center.item.dto.request.DirPropRelationDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirPropRelationModifyDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemPropRelationDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.PropGroupDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.PropNameCreateDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.PropNameDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DirPropDgDto;
import com.yunxi.dg.base.center.item.dto.response.DirPropRelationDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemPropRelationDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PropGroupDgDto;
import com.yunxi.dg.base.center.item.dto.response.PropGroupDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PropGroupSearchDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PropNameDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PropNameSearchDgRespDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.DirPropRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemPropRelationDgEo;
import com.yunxi.dg.base.center.item.eo.PropGroupDgEo;
import com.yunxi.dg.base.center.item.eo.PropGroupRelationDgEo;
import com.yunxi.dg.base.center.item.eo.PropNameDgEo;
import com.yunxi.dg.base.center.item.eo.PropValueDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.cache.ClearItemPropDgCache;
import com.yunxi.dg.base.center.item.service.entity.IPropDgService;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="iPropDgService")
public class PropDgServiceImpl
implements IPropDgService {
    private static Logger logger = LoggerFactory.getLogger(PropDgServiceImpl.class);
    @Resource
    private IPropGroupDgDomain propGroupDgDomain;
    @Resource
    private IPropNameDgDomain propNameDgDomain;
    @Resource
    private IPropValueDgDomain propValueDgDomain;
    @Resource
    private IPropGroupRelationDgDomain propGroupRelationDgDomain;
    @Resource
    private IDirPropRelationDgDomain dirPropRelationDgDomain;
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IItemPropRelationDgDomain itemPropRelationDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private ClearItemPropDgCache clearItemPropDgCache;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addProp(PropNameCreateDgReqDto propNameCreateDgReqDto) {
        Integer inputType;
        PropNameDgEo propNameDgEo = new PropNameDgEo();
        DtoHelper.dto2Eo((BaseVo)propNameCreateDgReqDto, (BaseEo)propNameDgEo);
        propNameDgEo.setId(null);
        this.propNameDgDomain.insert((BaseEo)propNameDgEo);
        if (propNameDgEo.getInputType() != null && (inputType = propNameDgEo.getInputType()) == 1) {
            Long id = propNameDgEo.getId();
            this.addPropValue(id, propNameCreateDgReqDto.getPropValueList(), propNameDgEo.getInstanceId(), propNameDgEo.getTenantId(), propNameDgEo.getSellerId());
        }
        return propNameDgEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddProp(List<PropNameCreateDgReqDto> propNameCreateDgReqDtoList) {
        if (CollectionUtils.isEmpty(propNameCreateDgReqDtoList)) {
            throw new ItemBusinessRuntimeException("10002", "\u8bf7\u5b8c\u5584\u5c5e\u6027\u4fe1\u606f");
        }
        for (PropNameCreateDgReqDto dto : propNameCreateDgReqDtoList) {
            this.addProp(dto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyProp(Long propNameId, PropNameDgReqDto propNameDgReqDto) {
        PropNameDgEo propNameDgEo = (PropNameDgEo)this.propNameDgDomain.selectByPrimaryKey(propNameId);
        if (propNameDgEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
        }
        PropNameDgEo updatePropNameDgEo = PropNameDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)propNameDgReqDto, (BaseEo)updatePropNameDgEo);
        updatePropNameDgEo.setId(propNameId);
        this.propNameDgDomain.updateSelective((BaseEo)updatePropNameDgEo);
        PropValueDgEo propValueDgEo = PropValueDgEo.newInstance();
        propValueDgEo.setPropNameId(propNameId);
        List queryList = this.propValueDgDomain.selectList((BaseEo)propValueDgEo);
        if (CollectionUtils.isEmpty((Collection)propNameDgReqDto.getPropValueList())) {
            this.propValueDgDomain.logicDelete((BaseEo)propValueDgEo);
        } else {
            if (queryList.size() != 0) {
                this.propValueDgDomain.logicDelete((BaseEo)propValueDgEo);
            }
            if (propNameDgReqDto.getInputType() == 1) {
                this.addPropValue(propNameId, propNameDgReqDto.getPropValueList(), propNameDgEo.getInstanceId(), propNameDgEo.getTenantId(), propNameDgEo.getSellerId());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPropGroup(Long propGroupId, PropGroupDgReqDto propGroupDgReqDto) {
        PropGroupDgEo propGroupDgEo = PropGroupDgEo.newInstance();
        PropGroupDgEo queryEo = (PropGroupDgEo)this.propGroupDgDomain.selectByPrimaryKey(propGroupId);
        if (null != queryEo) {
            DtoHelper.dto2Eo((BaseVo)propGroupDgReqDto, (BaseEo)propGroupDgEo);
            propGroupDgEo.setId(propGroupId);
            this.validPropGroupName(propGroupDgEo);
            this.propGroupRelationDgDomain.deleteByPropGroupId(propGroupId);
            if (!CollectionUtils.isEmpty((Collection)propGroupDgReqDto.getPropNameDgReqDtos())) {
                List propNameIdList = propGroupDgReqDto.getPropNameDgReqDtos().stream().map(PropNameDgReqDto::getId).distinct().collect(Collectors.toList());
                List propGroupRelationDgEoList = propNameIdList.stream().map(propNameId -> {
                    PropGroupRelationDgEo eo = new PropGroupRelationDgEo();
                    eo.setPropNameId(propNameId);
                    eo.setPropGroupId(propGroupId);
                    eo.setInstanceId(queryEo.getInstanceId());
                    eo.setTenantId(queryEo.getTenantId());
                    eo.setSellerId(queryEo.getSellerId());
                    return eo;
                }).collect(Collectors.toList());
                this.propGroupRelationDgDomain.insertBatch(propGroupRelationDgEoList);
            }
        } else {
            logger.error("\u8be5\u5c5e\u6027\u7ec4\u4e0d\u5b58\u5728");
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg());
        }
        this.propGroupDgDomain.updateSelective((BaseEo)propGroupDgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPropGroup(PropGroupDgReqDto propGroupDgReqDto) {
        PropGroupDgEo propGroupDgEo = PropGroupDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)propGroupDgReqDto, (BaseEo)propGroupDgEo);
        propGroupDgEo.setId(null);
        this.validPropGroupName(propGroupDgEo);
        this.propGroupDgDomain.insert((BaseEo)propGroupDgEo);
        if (!CollectionUtils.isEmpty((Collection)propGroupDgReqDto.getPropNameDgReqDtos())) {
            List<PropNameDgReqDto> propNameDgReqDtos = this.removeRePropName(propGroupDgReqDto.getPropNameDgReqDtos());
            ArrayList<PropGroupRelationDgEo> propGroupRelationDgEoList = new ArrayList<PropGroupRelationDgEo>();
            for (PropNameDgReqDto propNameDgReqDto : propNameDgReqDtos) {
                PropGroupRelationDgEo propGroupRelationDgEo = PropGroupRelationDgEo.newInstance();
                propGroupRelationDgEo.setPropNameId(propNameDgReqDto.getId());
                propGroupRelationDgEo.setPropGroupId(propGroupDgEo.getId());
                propGroupRelationDgEo.setInstanceId(propGroupDgEo.getInstanceId());
                propGroupRelationDgEo.setTenantId(propGroupDgEo.getTenantId());
                propGroupRelationDgEo.setSellerId(propGroupDgEo.getSellerId());
                propGroupRelationDgEoList.add(propGroupRelationDgEo);
            }
            this.propGroupRelationDgDomain.insertBatch(propGroupRelationDgEoList);
        }
        return propGroupDgEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddPropGroup(List<PropGroupDgReqDto> propGroupDgReqDtoList) {
        if (CollectionUtils.isEmpty(propGroupDgReqDtoList)) {
            throw new ItemBusinessRuntimeException("10002", "\u8bf7\u5b8c\u5584\u5c5e\u6027\u7ec4\u4fe1\u606f");
        }
        for (PropGroupDgReqDto dto : propGroupDgReqDtoList) {
            this.addPropGroup(dto);
        }
    }

    private void addPropValue(Long id, List<String> propValues, Long instanceId, Long tenantId, Long sellerId) {
        ArrayList<PropValueDgEo> propValueDgEoList = new ArrayList<PropValueDgEo>();
        for (String name : propValues) {
            PropValueDgEo propValueDgEo = PropValueDgEo.newInstance();
            propValueDgEo.setName(name);
            propValueDgEo.setPropNameId(id);
            propValueDgEo.setInstanceId(instanceId);
            propValueDgEo.setTenantId(tenantId);
            propValueDgEo.setSellerId(sellerId);
            propValueDgEoList.add(propValueDgEo);
        }
        this.propValueDgDomain.insertBatch(propValueDgEoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeProp(Long id) {
        if (!CollectionUtils.isEmpty((Collection)this.propGroupRelationDgDomain.selectByPropNameId(id))) {
            throw new BizException("\u5c5e\u6027\u5df2\u7ecf\u88ab\u5c5e\u6027\u7ec4\u5f15\u7528, \u65e0\u6cd5\u5220\u9664");
        }
        if (!CollectionUtils.isEmpty((Collection)this.dirPropRelationDgDomain.selectByPropNameId(id))) {
            throw new BizException("\u5c5e\u6027\u5df2\u7ecf\u88ab\u7c7b\u76ee\u5f15\u7528, \u65e0\u6cd5\u5220\u9664");
        }
        PropValueDgEo propValueDgEo = PropValueDgEo.newInstance();
        propValueDgEo.setPropNameId(id);
        this.propValueDgDomain.logicDelete((BaseEo)propValueDgEo);
        this.propNameDgDomain.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePropGroup(Long id) {
        PropGroupRelationDgEo propGroupRelationDgEo = PropGroupRelationDgEo.newInstance();
        propGroupRelationDgEo.setPropGroupId(id);
        this.propGroupRelationDgDomain.logicDelete((BaseEo)propGroupRelationDgEo);
        this.propGroupDgDomain.logicDeleteById(id);
        DirPropRelationDgEo dirPropRelationDgEoParam = DirPropRelationDgEo.newInstance();
        dirPropRelationDgEoParam.setPropGroupId(id);
        this.dirPropRelationDgDomain.logicDelete((BaseEo)dirPropRelationDgEoParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addDirPropRelation(List<DirPropRelationDgReqDto> dirPropRelationDgReqDtos) {
        ArrayList dirPropRelationDgEos = new ArrayList();
        DtoHelper.dtoList2EoList(dirPropRelationDgReqDtos, dirPropRelationDgEos, DirPropRelationDgEo.class);
        for (DirPropRelationDgEo eo : dirPropRelationDgEos) {
            if (eo.getDirId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
            }
            DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(eo.getDirId());
            if (dirDgEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR.getCode(), ItemExceptionCode.NON_EXIST_DIR.getMsg());
            }
            if (1 == eo.getPropType()) {
                if (eo.getPropGroupId() == null) {
                    logger.error("PropGroupId is null");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
                }
                PropGroupDgEo propGroupDgEo = (PropGroupDgEo)this.propGroupDgDomain.selectByPrimaryKey(eo.getPropGroupId());
                if (propGroupDgEo == null) {
                    logger.error("\u8be5id\u5bf9\u5e94\u7684\u5c5e\u6027\u7ec4\u4e0d\u5b58\u5728");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg());
                }
                eo.setPropNameId(Long.valueOf(0L));
            } else if (2 == eo.getPropType()) {
                if (eo.getPropNameId() == null) {
                    logger.error("PropNameId is null");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
                }
                PropNameDgEo propNameDgEo = (PropNameDgEo)this.propNameDgDomain.selectByPrimaryKey(eo.getPropNameId());
                if (propNameDgEo == null) {
                    logger.error("\u8be5id\u5bf9\u5e94\u7684\u5c5e\u6027\u540d\u4e0d\u5b58\u5728");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
                }
                eo.setPropGroupId(Long.valueOf(0L));
            } else {
                logger.error("\u5c5e\u6027\u7c7b\u578b\u5fc5\u987b\u4e3a\u5c5e\u6027\u7ec4\u6216\u8005\u5c5e\u6027\u540d");
                throw new ItemBusinessRuntimeException(ItemExceptionCode.PROPTYPE_ERROR.getCode(), ItemExceptionCode.PROPTYPE_ERROR.getMsg());
            }
            eo.setDr(0);
            if (this.dirPropRelationDgDomain.count((BaseEo)eo) != 0) continue;
            this.dirPropRelationDgDomain.insert((BaseEo)eo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDirPropRelation(List<Long> dirIdList) {
        if (CollectionUtils.isEmpty(dirIdList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        for (Long dirId : dirIdList) {
            DirPropRelationDgEo eo = DirPropRelationDgEo.newInstance();
            eo.setDirId(dirId);
            this.dirPropRelationDgDomain.logicDelete((BaseEo)eo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDirPropRelation(Long dirId, List<DirPropRelationDgReqDto> dirPropRelationDgReqDtos) {
        DirPropRelationDgEo eo = DirPropRelationDgEo.newInstance();
        eo.setDirId(dirId);
        if (!CollectionUtils.isEmpty((Collection)this.dirPropRelationDgDomain.selectList((BaseEo)eo))) {
            this.dirPropRelationDgDomain.delete((BaseEo)eo);
        }
        if (!CollectionUtils.isEmpty(dirPropRelationDgReqDtos)) {
            this.addDirPropRelation(dirPropRelationDgReqDtos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDirPropRelation(List<DirPropRelationModifyDgReqDto> dirPropRelationModifyDgReqDtoList) {
        if (CollectionUtils.isEmpty(dirPropRelationModifyDgReqDtoList)) {
            return;
        }
        for (DirPropRelationModifyDgReqDto dirPropRelationModifyDgReqDto : dirPropRelationModifyDgReqDtoList) {
            if (dirPropRelationModifyDgReqDto.getId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
            }
            DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dirPropRelationModifyDgReqDto.getDirId());
            if (dirDgEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
            }
            DirPropRelationDgEo dirPropRelationDgEo = new DirPropRelationDgEo();
            DtoHelper.dto2Eo((BaseVo)dirPropRelationModifyDgReqDto, (BaseEo)dirPropRelationDgEo);
            if (dirPropRelationModifyDgReqDto.getPropType() == 1) {
                if (dirPropRelationModifyDgReqDto.getPropGroupId() == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
                }
                PropGroupDgEo propGroupDgEo = (PropGroupDgEo)this.propGroupDgDomain.selectByPrimaryKey(dirPropRelationModifyDgReqDto.getPropGroupId());
                if (propGroupDgEo == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP);
                }
                dirPropRelationDgEo.setPropNameId(Long.valueOf(0L));
            } else if (dirPropRelationModifyDgReqDto.getPropType() == 2) {
                if (dirPropRelationModifyDgReqDto.getPropNameId() == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
                }
                PropNameDgEo propNameDgEo = (PropNameDgEo)this.propNameDgDomain.selectByPrimaryKey(dirPropRelationModifyDgReqDto.getPropNameId());
                if (propNameDgEo == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME);
                }
                dirPropRelationDgEo.setPropGroupId(Long.valueOf(0L));
            } else {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.PROPTYPE_ERROR);
            }
            this.dirPropRelationDgDomain.updateSelective((BaseEo)dirPropRelationDgEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addPropNameByExcel(MultipartFile file) {
        try {
            InputStream in = file.getInputStream();
            String suffix = FileUtil.getFileExtension((String)file.getOriginalFilename());
            List propNameExceDglDtoList = ExcelUtils.readExcel((InputStream)in, PropNameExceDglDto.class, (int)2, (String)suffix);
            if (CollectionUtils.isEmpty((Collection)propNameExceDglDtoList)) {
                throw new ItemBusinessRuntimeException("\u8868\u683c\u65e0\u6570\u636e");
            }
            ArrayList<PropNameCreateDgReqDto> propNameCreateDgReqDtoList = new ArrayList<PropNameCreateDgReqDto>();
            for (PropNameExceDglDto dto : propNameExceDglDtoList) {
                if (dto.getName() == null) {
                    throw new ItemBusinessRuntimeException("\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (dto.getInputType() != null) {
                    if (dto.getInputType() == 1 && dto.getPropValue() == null) {
                        throw new ItemBusinessRuntimeException("\u7f16\u8f91\u65b9\u5f0f\u4e3a\u591a\u9009\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                } else {
                    throw new ItemBusinessRuntimeException("\u7f16\u8f91\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                PropNameCreateDgReqDto propNameCreateDgReqDto = new PropNameCreateDgReqDto();
                CubeBeanUtils.copyProperties((Object)propNameCreateDgReqDto, (Object)dto, (String[])new String[0]);
                String[] propValues = dto.getPropValue().trim().split(";");
                ArrayList propValueList = new ArrayList();
                Collections.addAll(propValueList, propValues);
                propNameCreateDgReqDto.setPropValueList(propValueList);
                propNameCreateDgReqDtoList.add(propNameCreateDgReqDto);
            }
            this.batchAddProp(propNameCreateDgReqDtoList);
        }
        catch (Exception e) {
            throw new ItemBusinessRuntimeException(e.getMessage() + "\u5bfc\u5165excel\u65b0\u589e\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public void addItemPropRelation(List<ItemPropRelationDgReqDto> itemPropRelationDgReqDtos) {
        if (CollectionUtils.isEmpty(itemPropRelationDgReqDtos)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        for (ItemPropRelationDgReqDto dto : itemPropRelationDgReqDtos) {
            if (this.itemDgDomain.selectByPrimaryKey(dto.getItemId()) == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg() + "ItemId:" + dto.getItemId());
            }
            if (this.propGroupDgDomain.selectByPrimaryKey(dto.getPropGroupId()) == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg() + "PropGroupId:" + dto.getPropGroupId());
            }
            ItemPropRelationDgEo itemPropRelationDgEo = ItemPropRelationDgEo.newInstance();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)itemPropRelationDgEo);
            itemPropRelationDgEo.setId(null);
            this.itemPropRelationDgDomain.insert((BaseEo)itemPropRelationDgEo);
        }
    }

    @Override
    public PropNameDgRespDto queryPropNameById(Long propNameId) {
        PropNameDgEo propNameDgEo = (PropNameDgEo)this.propNameDgDomain.selectByPrimaryKey(propNameId);
        if (propNameDgEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
        }
        List<String> propValues = this.queryPropValue(propNameId);
        PropNameDgRespDto propNameDgRespDto = new PropNameDgRespDto();
        DtoHelper.eo2Dto((BaseEo)propNameDgEo, (BaseVo)propNameDgRespDto);
        List<PropGroupDgDto> propGroupDgDtos = this.queryPropNameRelation(propNameDgEo);
        propNameDgRespDto.setPropGroupDgDtoList(propGroupDgDtos);
        List<DirPropDgDto> dirPropDgDtos = this.getDirPropDtos(propNameId, null);
        propNameDgRespDto.setDirPropDgDtoList(dirPropDgDtos);
        return propNameDgRespDto;
    }

    @Override
    public PropNameSearchDgRespDto queryPropNameByName(String keyword, Integer pageNum, Integer pageSize) {
        pageNum = null == pageNum ? ComBaseDas.DEFAULT_PAGE_NUMBER : pageNum;
        pageSize = null == pageSize ? ComBaseDas.DEFAULT_PAGE_SIZE : pageSize;
        PropNameSearchDgRespDto propNameSearchDgRespDto = new PropNameSearchDgRespDto();
        PropNameDgEo propNameDgEo = PropNameDgEo.newInstance();
        QueryParamDgUtils.columnLike((BaseEo)propNameDgEo, "name", keyword);
        PageInfo propNameEoPageInfo = this.propNameDgDomain.selectPage((BaseEo)propNameDgEo, pageNum, pageSize);
        List propNameDgEoList = propNameEoPageInfo.getList();
        List<PropNameDgRespDto> propNameDgRespDtos = this.getPropNameRespDtos(propNameDgEoList);
        PageInfo propNameRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)propNameRespDtoPageInfo, (Object)propNameEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        propNameRespDtoPageInfo.setList(propNameDgRespDtos);
        propNameSearchDgRespDto.setPageInfo(propNameRespDtoPageInfo);
        return propNameSearchDgRespDto;
    }

    @Override
    public PageInfo<PropNameDgRespDto> queryPropNameByPage(PropNameDgReqDto propNameDgReqDto, Integer pageNum, Integer pageSize) {
        PropNameDgEo propNameDgEo = PropNameDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)propNameDgReqDto, (BaseEo)propNameDgEo);
        List<Object> propNameIds = new ArrayList();
        if (propNameDgReqDto.getDirId() != null) {
            DirPropRelationDgEo dirPropRelationDgEo = DirPropRelationDgEo.newInstance();
            dirPropRelationDgEo.setDirId(propNameDgReqDto.getDirId());
            List dirPropRelationDgEos = this.dirPropRelationDgDomain.selectList((BaseEo)dirPropRelationDgEo);
            if (CollectionUtils.isEmpty((Collection)dirPropRelationDgEos)) {
                return new PageInfo();
            }
            propNameIds = dirPropRelationDgEos.stream().map(DirPropRelationDgEo::getPropNameId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(propNameIds)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(propNameIds, (String)",")));
            propNameDgEo.setSqlFilters(sqlFilters);
        }
        QueryParamDgUtils.columnLike((BaseEo)propNameDgEo, "code", propNameDgEo.getCode());
        QueryParamDgUtils.columnLike((BaseEo)propNameDgEo, "name", propNameDgEo.getName());
        QueryParamDgUtils.fillQueryCreateStartTime(propNameDgReqDto.getCreateBeginTime(), (BaseEo)propNameDgEo, "ge");
        QueryParamDgUtils.fillQueryCreateEndTime(propNameDgReqDto.getCreateEndTime(), (BaseEo)propNameDgEo, "le");
        QueryParamDgUtils.fillQueryUpdateStartTime(propNameDgReqDto.getUpdateBeginTime(), (BaseEo)propNameDgEo, "ge");
        QueryParamDgUtils.fillQueryUpdateEndTime(propNameDgReqDto.getUpdateEndTime(), (BaseEo)propNameDgEo, "le");
        if (StringUtils.isBlank((CharSequence)propNameDgEo.getOrderByDesc())) {
            propNameDgEo.setOrderByDesc("update_time");
        }
        PageInfo propNameEoPageInfo = this.propNameDgDomain.selectPage((BaseEo)propNameDgEo, pageNum, pageSize);
        List propNameDgEoList = propNameEoPageInfo.getList();
        ArrayList propNameDgRespDtos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)propNameDgEoList)) {
            CubeBeanUtils.copyCollection((Collection)propNameDgRespDtos, (Collection)propNameDgEoList, PropNameDgRespDto.class);
            propNameDgRespDtos.parallelStream().forEach(propNameRespDto -> {
                List<String> propValueList = this.queryPropValue(propNameRespDto.getId());
            });
        }
        PageInfo propNameRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)propNameRespDtoPageInfo, (Object)propNameEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        propNameRespDtoPageInfo.setList((List)propNameDgRespDtos);
        return propNameRespDtoPageInfo;
    }

    @Override
    public List<DirPropRelationDgRespDto> queryDirPropRelationById(Long dirId) {
        DirPropRelationDgEo eo = DirPropRelationDgEo.newInstance();
        eo.setDirId(dirId);
        List dirPropRelationDgEos = this.dirPropRelationDgDomain.selectList((BaseEo)eo);
        ArrayList<DirPropRelationDgRespDto> dirPropRelationDgRespDtos = new ArrayList<DirPropRelationDgRespDto>();
        for (DirPropRelationDgEo dirPropRelationDgEo : dirPropRelationDgEos) {
            DirPropRelationDgRespDto dirPropRelationDgRespDto = new DirPropRelationDgRespDto();
            DtoHelper.eo2Dto((BaseEo)dirPropRelationDgEo, (BaseVo)dirPropRelationDgRespDto);
            if (dirPropRelationDgEo.getPropNameId() != 0L) {
                PropNameDgEo propNameDgEo = (PropNameDgEo)this.propNameDgDomain.selectByPrimaryKey(dirPropRelationDgEo.getPropNameId());
                if (propNameDgEo == null) {
                    logger.error("\u67e5\u8be2\u76ee\u5f55\u5c5e\u6027\u5173\u8054\u5bf9\u5e94\u7684\u5c5e\u6027\u540d\u4e0d\u5b58\u5728");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
                }
                PropNameDgRespDto propNameDgRespDto = new PropNameDgRespDto();
                DtoHelper.eo2Dto((BaseEo)propNameDgEo, (BaseVo)propNameDgRespDto);
                dirPropRelationDgRespDto.setPropNameDgRespDto(propNameDgRespDto);
            }
            if (dirPropRelationDgEo.getPropGroupId() != 0L) {
                PropGroupDgEo propGroupDgEo = (PropGroupDgEo)this.propGroupDgDomain.selectByPrimaryKey(dirPropRelationDgEo.getPropGroupId());
                if (propGroupDgEo == null) {
                    logger.error("\u67e5\u8be2\u76ee\u5f55\u5c5e\u6027\u5173\u8054\u5bf9\u5e94\u7684\u5c5e\u6027\u7ec4\u4e0d\u5b58\u5728");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
                }
                PropGroupDgRespDto propGroupDgRespDto = this.queryPropGroupRelation(propGroupDgEo);
                dirPropRelationDgRespDto.setPropGroupDgRespDto(propGroupDgRespDto);
            }
            dirPropRelationDgRespDtos.add(dirPropRelationDgRespDto);
        }
        return dirPropRelationDgRespDtos;
    }

    @Override
    public PropGroupDgRespDto queryPropGroupById(Long propGroupId) {
        PropGroupDgEo propGroupDgEo = (PropGroupDgEo)this.propGroupDgDomain.selectByPrimaryKey(propGroupId);
        if (propGroupDgEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg());
        }
        PropGroupDgRespDto propGroupDgRespDto = this.queryPropGroupRelation(propGroupDgEo);
        List<DirPropDgDto> dirPropDgDtos = this.getDirPropDtos(null, propGroupId);
        propGroupDgRespDto.setDirPropDgDtoList(dirPropDgDtos);
        return propGroupDgRespDto;
    }

    @Override
    public PropGroupSearchDgRespDto queryPropGroupByName(String keyword, Integer pageNum, Integer pageSize) {
        pageNum = null == pageNum ? ComBaseDas.DEFAULT_PAGE_NUMBER : pageNum;
        pageSize = null == pageSize ? ComBaseDas.DEFAULT_PAGE_SIZE : pageSize;
        PropGroupSearchDgRespDto propGroupSearchDgRespDto = new PropGroupSearchDgRespDto();
        PropGroupDgEo propGroupDgEo = PropGroupDgEo.newInstance();
        QueryParamDgUtils.columnLike((BaseEo)propGroupDgEo, "name", keyword);
        PageInfo propGroupEoPageInfo = this.propGroupDgDomain.selectPage((BaseEo)propGroupDgEo, pageNum, pageSize);
        List propGroupDgEoList = propGroupEoPageInfo.getList();
        ArrayList<PropGroupDgRespDto> propGroupDgRespDtoList = new ArrayList<PropGroupDgRespDto>();
        for (PropGroupDgEo eo : propGroupDgEoList) {
            PropGroupDgRespDto propGroupDgRespDto = this.queryPropGroupRelation(eo);
            List<DirPropDgDto> dirPropDgDtos = this.getDirPropDtos(null, eo.getId());
            propGroupDgRespDto.setDirPropDgDtoList(dirPropDgDtos);
            propGroupDgRespDtoList.add(propGroupDgRespDto);
        }
        PageInfo propGroupRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)propGroupRespDtoPageInfo, (Object)propGroupEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        propGroupRespDtoPageInfo.setList(propGroupDgRespDtoList);
        propGroupSearchDgRespDto.setPageInfo(propGroupRespDtoPageInfo);
        return propGroupSearchDgRespDto;
    }

    @Override
    public PageInfo<PropGroupDgRespDto> queryPropGroupByPage(PropGroupDgReqDto propGroupDgReqDto, Integer pageNum, Integer pageSize) {
        PropGroupDgEo propGroupDgEo = PropGroupDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)propGroupDgReqDto, (BaseEo)propGroupDgEo);
        List<Object> propGroupIds = new ArrayList();
        if (propGroupDgReqDto.getDirId() != null) {
            DirPropRelationDgEo dirPropRelationDgEo = DirPropRelationDgEo.newInstance();
            dirPropRelationDgEo.setDirId(propGroupDgReqDto.getDirId());
            List dirPropRelationDgEos = this.dirPropRelationDgDomain.selectList((BaseEo)dirPropRelationDgEo);
            if (CollectionUtils.isEmpty((Collection)dirPropRelationDgEos)) {
                return new PageInfo();
            }
            propGroupIds = dirPropRelationDgEos.stream().map(DirPropRelationDgEo::getPropGroupId).collect(Collectors.toList());
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty(propGroupIds)) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(propGroupIds, (String)",")));
        }
        if (StringUtils.isNotBlank((CharSequence)propGroupDgReqDto.getPropName())) {
            PropNameDgEo propNameDgEoParam = PropNameDgEo.newInstance();
            propNameDgEoParam.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.like((String)"name", (Object)("%" + propGroupDgReqDto.getPropName() + "%"))}));
            List propNameDgEoList = this.propNameDgDomain.selectList((BaseEo)propNameDgEoParam);
            if (!CollectionUtils.isEmpty((Collection)propNameDgEoList)) {
                List propNameIdList = propNameDgEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
                PropGroupRelationDgEo propGroupRelationDgEoParam = PropGroupRelationDgEo.newInstance();
                ArrayList sqlFilters1 = Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"prop_name_id", propNameIdList)});
                propGroupRelationDgEoParam.setSqlFilters((List)sqlFilters1);
                List propGroupRelationDgEoList = this.propGroupRelationDgDomain.selectList((BaseEo)propGroupRelationDgEoParam);
                if (!CollectionUtils.isEmpty((Collection)propGroupRelationDgEoList)) {
                    List propGroupIdList = propGroupRelationDgEoList.stream().map(PropGroupRelationDgEo::getPropGroupId).distinct().collect(Collectors.toList());
                    sqlFilters.add(SqlFilter.in((String)"id", propGroupIdList));
                } else {
                    sqlFilters.add(SqlFilter.in((String)"id", (Object)0L));
                }
            } else {
                sqlFilters.add(SqlFilter.in((String)"id", (Object)0L));
            }
        }
        propGroupDgEo.setSqlFilters(sqlFilters);
        QueryParamDgUtils.columnLike((BaseEo)propGroupDgEo, "code", propGroupDgEo.getCode());
        QueryParamDgUtils.columnLike((BaseEo)propGroupDgEo, "name", propGroupDgEo.getName());
        QueryParamDgUtils.fillQueryCreateStartTime(propGroupDgReqDto.getCreateBeginTime(), (BaseEo)propGroupDgEo, "ge");
        QueryParamDgUtils.fillQueryCreateEndTime(propGroupDgReqDto.getCreateEndTime(), (BaseEo)propGroupDgEo, "le");
        QueryParamDgUtils.fillQueryUpdateStartTime(propGroupDgReqDto.getUpdateBeginTime(), (BaseEo)propGroupDgEo, "ge");
        QueryParamDgUtils.fillQueryUpdateEndTime(propGroupDgReqDto.getUpdateEndTime(), (BaseEo)propGroupDgEo, "le");
        propGroupDgEo.setOrderByDesc("update_time");
        PageInfo propGroupEoPageInfo = this.propGroupDgDomain.selectPage((BaseEo)propGroupDgEo, pageNum, pageSize);
        ArrayList<PropGroupDgRespDto> propGroupDgRespDtoList = new ArrayList<PropGroupDgRespDto>();
        List propGroupDgEoList = propGroupEoPageInfo.getList();
        for (PropGroupDgEo eo : propGroupDgEoList) {
            PropGroupDgRespDto propGroupDgRespDto = this.queryPropGroupRelation(eo);
            List<DirPropDgDto> dirPropDgDtos = this.getDirPropDtos(null, eo.getId());
            propGroupDgRespDto.setDirPropDgDtoList(dirPropDgDtos);
            propGroupDgRespDtoList.add(propGroupDgRespDto);
        }
        PageInfo propGroupRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)propGroupRespDtoPageInfo, (Object)propGroupEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        propGroupRespDtoPageInfo.setList(propGroupDgRespDtoList);
        return propGroupRespDtoPageInfo;
    }

    @Override
    public List<ItemPropRelationDgRespDto> queryItemPropRelation(ItemPropRelationDgReqDto itemPropRelationDgReqDto) {
        ItemPropRelationDgEo itemPropRelationDgEo = ItemPropRelationDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)itemPropRelationDgReqDto, (BaseEo)itemPropRelationDgEo);
        itemPropRelationDgEo.setOrderBy("id");
        List itemPropRelationDgEoList = this.itemPropRelationDgDomain.selectList((BaseEo)itemPropRelationDgEo);
        ArrayList<ItemPropRelationDgRespDto> itemPropRelationDgRespDtoList = new ArrayList<ItemPropRelationDgRespDto>();
        DtoHelper.eoList2DtoList((Collection)itemPropRelationDgEoList, itemPropRelationDgRespDtoList, ItemPropRelationDgRespDto.class);
        return itemPropRelationDgRespDtoList;
    }

    @Override
    @Cacheable(value={"ITEM_PROP_CACHE"}, key="#itemId", unless="#result== null")
    public List<ItemPropRelationDgRespDto> queryByItemId(Long itemId) {
        ItemPropRelationDgReqDto itemPropRelationDgReqDto = new ItemPropRelationDgReqDto();
        itemPropRelationDgReqDto.setItemId(itemId);
        return this.queryItemPropRelation(itemPropRelationDgReqDto);
    }

    public List<PropGroupDgDto> queryPropNameRelation(PropNameDgEo propNameDgEo) {
        PropGroupRelationDgEo propGroupRelationDgEo = PropGroupRelationDgEo.newInstance();
        propGroupRelationDgEo.setPropNameId(propNameDgEo.getId());
        List propGroupRelationDgEos = this.propGroupRelationDgDomain.selectList((BaseEo)propGroupRelationDgEo);
        if (CollectionUtils.isEmpty((Collection)propGroupRelationDgEos)) {
            return new ArrayList<PropGroupDgDto>();
        }
        ArrayList<PropGroupDgDto> propGroupDgDtos = new ArrayList<PropGroupDgDto>();
        for (PropGroupRelationDgEo eo : propGroupRelationDgEos) {
            PropGroupDgEo propGroupDgEo = (PropGroupDgEo)this.propGroupDgDomain.selectByPrimaryKey(eo.getPropGroupId());
            if (propGroupDgEo == null) continue;
            List<DirPropDgDto> dirPropDgDtos = this.getDirPropDtos(null, propGroupDgEo.getId());
            PropGroupDgDto propGroupDgDto = new PropGroupDgDto();
            DtoHelper.eo2Dto((BaseEo)propGroupDgEo, (BaseVo)propGroupDgDto);
            propGroupDgDto.setDirPropDgDtoList(dirPropDgDtos);
            propGroupDgDtos.add(propGroupDgDto);
        }
        return propGroupDgDtos;
    }

    public PropGroupDgRespDto queryPropGroupRelation(PropGroupDgEo propGroupDgEo) {
        List<PropNameDgEo> propNameDgEoList;
        PropGroupDgRespDto propGroupDgRespDto = new PropGroupDgRespDto();
        DtoHelper.eo2Dto((BaseEo)propGroupDgEo, (BaseVo)propGroupDgRespDto);
        List<Object> propNameDgRespDtoList = Lists.newArrayList();
        List propGroupRelationDgEos = this.propGroupRelationDgDomain.selectByPropGroupId(propGroupDgEo.getId());
        if (!CollectionUtils.isEmpty((Collection)propGroupRelationDgEos) && !CollectionUtils.isEmpty(propNameDgEoList = propGroupRelationDgEos.stream().map(propGroupRelationDgEo -> (PropNameDgEo)this.propNameDgDomain.selectByPrimaryKey(propGroupRelationDgEo.getPropNameId())).filter(Objects::nonNull).collect(Collectors.toList()))) {
            propNameDgRespDtoList = this.getPropNameRespDtos(propNameDgEoList);
        }
        propGroupDgRespDto.setPropNameDgRespDtos((List)propNameDgRespDtoList);
        return propGroupDgRespDto;
    }

    public List<String> queryPropValue(Long propNameId) {
        PropValueDgEo propValueDgEo = PropValueDgEo.newInstance();
        propValueDgEo.setPropNameId(propNameId);
        List propValueDgEoList = this.propValueDgDomain.selectList((BaseEo)propValueDgEo);
        Collections.reverse(propValueDgEoList);
        ArrayList<String> propValues = new ArrayList<String>();
        for (PropValueDgEo eo : propValueDgEoList) {
            propValues.add(eo.getName());
        }
        return propValues;
    }

    public List<PropNameDgRespDto> getPropNameRespDtos(List<PropNameDgEo> propNameDgEoList) {
        ArrayList<PropNameDgRespDto> propNameDgRespDtos = new ArrayList<PropNameDgRespDto>();
        for (PropNameDgEo eo : propNameDgEoList) {
            List<String> propValues = this.queryPropValue(eo.getId());
            PropNameDgRespDto propNameDgRespDto = new PropNameDgRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)propNameDgRespDto);
            List<PropGroupDgDto> propGroupDgDtos = this.queryPropNameRelation(eo);
            propNameDgRespDto.setPropGroupDgDtoList(propGroupDgDtos);
            List<DirPropDgDto> dirPropDgDtos = this.getDirPropDtos(eo.getId(), null);
            propNameDgRespDto.setDirPropDgDtoList(dirPropDgDtos);
            propNameDgRespDtos.add(propNameDgRespDto);
        }
        return propNameDgRespDtos;
    }

    private List<DirPropDgDto> getDirPropDtos(Long propNameId, Long propGroupId) {
        DirPropRelationDgEo dirPropRelationDgEo = DirPropRelationDgEo.newInstance();
        if (propNameId != null && propGroupId == null) {
            dirPropRelationDgEo.setPropNameId(propNameId);
        }
        if (propNameId == null && propGroupId != null) {
            dirPropRelationDgEo.setPropGroupId(propGroupId);
        }
        ArrayList<DirPropDgDto> dirPropDgDtos = new ArrayList<DirPropDgDto>();
        for (DirPropRelationDgEo eo : this.dirPropRelationDgDomain.selectList((BaseEo)dirPropRelationDgEo)) {
            DirPropDgDto dirPropDgDto = new DirPropDgDto();
            DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(eo.getDirId());
            if (dirDgEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg());
            }
            dirPropDgDto.setId(eo.getId());
            dirPropDgDto.setDirId(dirDgEo.getId());
            dirPropDgDto.setDirName(dirDgEo.getName());
            dirPropDgDto.setPropType(eo.getPropType());
            dirPropDgDto.setSellerId(eo.getSellerId());
            dirPropDgDtos.add(dirPropDgDto);
        }
        return dirPropDgDtos;
    }

    private void validPropGroupName(PropGroupDgEo propGroupDgEo) {
        if (propGroupDgEo.getName() != null) {
            PropGroupDgEo eo = PropGroupDgEo.newInstance();
            eo.setName(propGroupDgEo.getName());
            if (propGroupDgEo.getSellerId() != null) {
                eo.setSellerId(propGroupDgEo.getSellerId());
            }
            if (propGroupDgEo.getInstanceId() != null) {
                eo.setInstanceId(propGroupDgEo.getInstanceId());
            }
            if (propGroupDgEo.getTenantId() != null) {
                eo.setTenantId(propGroupDgEo.getTenantId());
            }
            if (propGroupDgEo.getId() == null) {
                eo.setDr(0);
                if (this.propGroupDgDomain.count((BaseEo)eo) > 0) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NAME_EXISTS.getCode(), ItemExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
                }
            } else {
                Long propGroupId = propGroupDgEo.getId();
                List propGroupDgEos = this.propGroupDgDomain.selectList((BaseEo)eo);
                if (!CollectionUtils.isEmpty((Collection)propGroupDgEos)) {
                    if (propGroupDgEos.size() == 1) {
                        if (!((PropGroupDgEo)propGroupDgEos.get(0)).getId().equals(propGroupId)) {
                            throw new ItemBusinessRuntimeException(ItemExceptionCode.NAME_EXISTS.getCode(), ItemExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
                        }
                    } else {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.NAME_EXISTS.getCode(), ItemExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
                    }
                }
            }
        }
    }

    private List<PropNameDgReqDto> removeRePropName(List<PropNameDgReqDto> propNameDgReqDtos) {
        HashMap<Long, PropNameDgReqDto> propNameMap = new HashMap<Long, PropNameDgReqDto>();
        for (PropNameDgReqDto propNameDgReqDto : propNameDgReqDtos) {
            propNameMap.put(propNameDgReqDto.getId(), propNameDgReqDto);
        }
        ArrayList<PropNameDgReqDto> resultEos = new ArrayList<PropNameDgReqDto>();
        resultEos.addAll(propNameMap.values());
        return resultEos;
    }

    @Override
    public List<PropNameDgRespDto> queryPropNameListByDirId(Long dirId, Integer usageType) {
        ArrayList propNameDgRespDtoList = Lists.newArrayList();
        List dirPropRelationDgEoList = this.dirPropRelationDgDomain.selectByDirId(dirId, Integer.valueOf(1), usageType);
        if (!CollectionUtils.isEmpty((Collection)dirPropRelationDgEoList)) {
            dirPropRelationDgEoList.forEach(dirPropRelationDgEo -> {
                List propNameDgEoList;
                List propGroupRelationDgEoList = this.propGroupRelationDgDomain.selectByPropGroupId(dirPropRelationDgEo.getPropGroupId());
                if (!CollectionUtils.isEmpty((Collection)propGroupRelationDgEoList) && !CollectionUtils.isEmpty((Collection)(propNameDgEoList = this.propNameDgDomain.selectByIdList(propGroupRelationDgEoList.stream().map(PropGroupRelationDgEo::getPropNameId).distinct().collect(Collectors.toList()))))) {
                    propNameDgEoList.forEach(propNameDgEo -> {
                        PropNameDgRespDto propNameDgRespDto = new PropNameDgRespDto();
                        DtoHelper.eo2Dto((BaseEo)propNameDgEo, (BaseVo)propNameDgRespDto);
                        List<Object> propValueList = Lists.newArrayList();
                        PropValueDgEo propValueDgEoParam = PropValueDgEo.newInstance();
                        propValueDgEoParam.setPropNameId(propNameDgEo.getId());
                        List propValueDgEoList = this.propValueDgDomain.selectList((BaseEo)propValueDgEoParam);
                        if (!CollectionUtils.isEmpty((Collection)propValueDgEoList)) {
                            propValueList = propValueDgEoList.stream().map(PropValueDgEo::getName).collect(Collectors.toList());
                        }
                        propNameDgRespDtoList.add(propNameDgRespDto);
                    });
                }
            });
        }
        return propNameDgRespDtoList;
    }

    @Override
    public List<PropNameDgRespDto> queryPropNameListByItemId(Long itemId) {
        ArrayList propNameDgRespDtoList = Lists.newArrayList();
        List itemPropRelationDgEoList = this.itemPropRelationDgDomain.selectByParam(itemId, null);
        if (!CollectionUtils.isEmpty((Collection)itemPropRelationDgEoList)) {
            List propNameIdList = itemPropRelationDgEoList.stream().filter(itemPropRelationEo -> itemPropRelationEo.getPropNameId() != null).map(ItemPropRelationDgEo::getPropNameId).collect(Collectors.toList());
            List propNameDgEoList = this.propNameDgDomain.selectByIdList(propNameIdList);
            if (!CollectionUtils.isEmpty((Collection)propNameDgEoList)) {
                Map propNameEoMap = propNameDgEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                itemPropRelationDgEoList.forEach(itemPropRelationEo -> {
                    PropNameDgRespDto propNameDgRespDto = new PropNameDgRespDto();
                    PropNameDgEo propNameDgEo = (PropNameDgEo)propNameEoMap.get(itemPropRelationEo.getPropNameId());
                    if (propNameDgEo != null) {
                        CubeBeanUtils.copyProperties((Object)propNameDgRespDto, (Object)propNameDgEo, (String[])new String[0]);
                        propNameDgRespDtoList.add(propNameDgRespDto);
                    }
                });
            }
            Map<Long, List<ItemPropRelationDgEo>> itemPropRelationEoMap = itemPropRelationDgEoList.stream().filter(itemPropRelationEo -> itemPropRelationEo.getPropNameId() != null).collect(Collectors.groupingBy(ItemPropRelationDgEo::getPropNameId));
            propNameDgRespDtoList.forEach(propNameRespDto -> {
                List itemPropRelationDgEoList1 = (List)itemPropRelationEoMap.get(propNameRespDto.getId());
                if (CollectionUtils.isEmpty((Collection)itemPropRelationDgEoList1) || StringUtils.isNotBlank((CharSequence)((ItemPropRelationDgEo)itemPropRelationDgEoList1.get(0)).getPropValue())) {
                    // empty if block
                }
            });
        }
        return propNameDgRespDtoList;
    }
}

