/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.convert.entity.SkuSaleStatisticsDgConverter;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISkuSaleStatisticsDgDomain;
import com.yunxi.dg.base.center.item.dto.entity.SkuSaleStatisticsDgDto;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.center.item.eo.SkuSaleStatisticsDgEo;
import com.yunxi.dg.base.center.item.service.entity.ISkuSaleStatisticsDgService;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SkuSaleStatisticsDgServiceImpl
extends BaseServiceImpl<SkuSaleStatisticsDgDto, SkuSaleStatisticsDgEo, ISkuSaleStatisticsDgDomain>
implements ISkuSaleStatisticsDgService {
    private static final Logger log = LoggerFactory.getLogger(SkuSaleStatisticsDgServiceImpl.class);
    @Resource
    private IShelfDgDomain shelfDgDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;

    public SkuSaleStatisticsDgServiceImpl(ISkuSaleStatisticsDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SkuSaleStatisticsDgDto, SkuSaleStatisticsDgEo> converter() {
        return SkuSaleStatisticsDgConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addShopSkuSaleStatistics(DgBizPerformOrderRespDto dto) {
        DgPerformOrderSnapshotDto snapshotDto = dto.getPerformOrderSnapshotDto();
        Set skuCodeList = dto.getOrderItemLineList().stream().map(DgPerformOrderItemLineDto::getSkuCode).collect(Collectors.toSet());
        List itemSkuDgEoList = this.itemSkuDgDomain.selectItemSkuByCodes((List)Lists.newArrayList(skuCodeList));
        if (CollectionUtil.isEmpty((Collection)itemSkuDgEoList)) {
            log.info("\u67e5\u8be2sku\u4fe1\u606f\u4e3a\u7a7a,sku\u7f16\u7801\u4e3a:{}", (Object)JSONObject.toJSONString(skuCodeList));
        }
        Set skuIds = itemSkuDgEoList.stream().map(BaseEo::getId).collect(Collectors.toSet());
        List shelfDgEos = this.shelfDgDomain.selectBySkuIdsAndShopIds(skuIds, (Set)Sets.newHashSet((Object[])new Long[]{snapshotDto.getShopId()}));
        if (CollectionUtil.isEmpty((Collection)shelfDgEos)) {
            log.info("\u67e5\u8be2\u4e0a\u67b6\u4fe1\u606f\u4e3a\u7a7a,skuId\u96c6\u5408:{},\u5e97\u94faid\u96c6\u5408:{}", (Object)JSONObject.toJSONString(skuIds), (Object)snapshotDto.getShopId());
        }
        Map itemSkuDgEoMap = itemSkuDgEoList.stream().collect(Collectors.toMap(ItemSkuDgEo::getCode, Function.identity(), (v1, v2) -> v1));
        Map<String, BigDecimal> skuCodeToTotalItemNum = dto.getOrderItemLineList().stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getSkuCode, Collectors.reducing(BigDecimal.ZERO, DgPerformOrderItemLineDto::getItemNum, BigDecimal::add)));
        List skuSaleStatisticsDgEos = ((ISkuSaleStatisticsDgDomain)this.domain).queryBySkuIdsAndShopIds(skuIds, (Collection)Sets.newHashSet((Object[])new Long[]{snapshotDto.getShopId()}));
        Map<Object, Object> saleStatisticsDgEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)skuSaleStatisticsDgEos)) {
            saleStatisticsDgEoMap = skuSaleStatisticsDgEos.stream().collect(Collectors.toMap(SkuSaleStatisticsDgEo::getSkuId, Function.identity(), (v1, v2) -> v1));
        }
        ArrayList addStatisticsDgEos = Lists.newArrayList();
        HashMap finalSaleStatisticsDgEoMap = saleStatisticsDgEoMap;
        skuCodeToTotalItemNum.forEach((key, value) -> {
            if (itemSkuDgEoMap.containsKey(key)) {
                ItemSkuDgEo skuDgEo = (ItemSkuDgEo)itemSkuDgEoMap.get(key);
                if (finalSaleStatisticsDgEoMap.containsKey(skuDgEo.getId())) {
                    SkuSaleStatisticsDgEo skuSaleStatisticsDgEo = (SkuSaleStatisticsDgEo)finalSaleStatisticsDgEoMap.get(skuDgEo.getId());
                    ((ISkuSaleStatisticsDgDomain)this.domain).addSalesStatistics(skuSaleStatisticsDgEo, value);
                } else {
                    SkuSaleStatisticsDgEo skuSaleStatisticsDgEo = new SkuSaleStatisticsDgEo();
                    skuSaleStatisticsDgEo.setSkuId(skuDgEo.getId());
                    skuSaleStatisticsDgEo.setSkuCode(skuDgEo.getCode());
                    skuSaleStatisticsDgEo.setItemId(skuDgEo.getItemId());
                    skuSaleStatisticsDgEo.setBizNo(dto.getSaleOrderNo());
                    skuSaleStatisticsDgEo.setShopId(snapshotDto.getShopId());
                    skuSaleStatisticsDgEo.setShopCode(((ShelfDgEo)shelfDgEos.get(0)).getShopCode());
                    skuSaleStatisticsDgEo.setSalesStatistics(value);
                    addStatisticsDgEos.add(skuSaleStatisticsDgEo);
                }
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)addStatisticsDgEos)) {
            ((ISkuSaleStatisticsDgDomain)this.domain).insertBatch((List)addStatisticsDgEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subtractShopSkuSaleStatistics(DgBizPerformOrderRespDto dto) {
        DgPerformOrderSnapshotDto snapshotDto = dto.getPerformOrderSnapshotDto();
        Set skuCodeList = dto.getOrderItemLineList().stream().map(DgPerformOrderItemLineDto::getSkuCode).collect(Collectors.toSet());
        List itemSkuDgEoList = this.itemSkuDgDomain.selectItemSkuByCodes((List)Lists.newArrayList(skuCodeList));
        if (CollectionUtil.isEmpty((Collection)itemSkuDgEoList)) {
            log.info("\u67e5\u8be2sku\u4fe1\u606f\u4e3a\u7a7a,sku\u7f16\u7801\u4e3a:{}", (Object)JSONObject.toJSONString(skuCodeList));
        }
        Set skuIds = itemSkuDgEoList.stream().map(BaseEo::getId).collect(Collectors.toSet());
        List skuSaleStatisticsDgEos = ((ISkuSaleStatisticsDgDomain)this.domain).queryBySkuIdsAndShopIds(skuIds, (Collection)Sets.newHashSet((Object[])new Long[]{snapshotDto.getShopId()}));
        if (CollectionUtil.isNotEmpty((Collection)skuSaleStatisticsDgEos)) {
            Map saleStatisticsDgEoMap = skuSaleStatisticsDgEos.stream().collect(Collectors.toMap(SkuSaleStatisticsDgEo::getSkuId, Function.identity(), (v1, v2) -> v1));
            Map itemSkuDgEoMap = itemSkuDgEoList.stream().collect(Collectors.toMap(ItemSkuDgEo::getCode, Function.identity(), (v1, v2) -> v1));
            Map<String, BigDecimal> skuCodeToTotalItemNum = dto.getOrderItemLineList().stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getSkuCode, Collectors.reducing(BigDecimal.ZERO, DgPerformOrderItemLineDto::getItemNum, BigDecimal::add)));
            skuCodeToTotalItemNum.forEach((key, value) -> {
                ItemSkuDgEo skuDgEo;
                if (itemSkuDgEoMap.containsKey(key) && saleStatisticsDgEoMap.containsKey((skuDgEo = (ItemSkuDgEo)itemSkuDgEoMap.get(key)).getId())) {
                    SkuSaleStatisticsDgEo skuSaleStatisticsDgEo = (SkuSaleStatisticsDgEo)saleStatisticsDgEoMap.get(skuDgEo.getId());
                    ((ISkuSaleStatisticsDgDomain)this.domain).subtractSalesStatistics(skuSaleStatisticsDgEo, value);
                }
            });
        }
    }
}

