/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.event.localEvent;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.item.constants.SkuItemMarketStatusEnum;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISkuMarketRefDgDomain;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.SkuMarketRefDgEo;
import com.yunxi.dg.base.center.item.event.localEvent.SkuMarketStatusMqEvent;
import com.yunxi.dg.base.center.item.service.commons.ReportHelper;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class SkuMarketStatusListener {
    private static final Logger log = LoggerFactory.getLogger(SkuMarketStatusListener.class);
    @Resource
    private ReportHelper reportHelper;
    @Resource
    private IItemSkuDgDomain skuDgDomain;
    @Resource
    private ISkuMarketRefDgDomain skuMarketRefDgDomain;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={SkuMarketStatusMqEvent.class})
    public void marketStatusOn(SkuMarketStatusMqEvent skuMarketStatusMqEvent) {
        log.info("\u76d1\u542csku\u4e0a\u5e02\u4e8b\u4ef6\u6267\u884c  time: " + LocalTime.now());
        List skuMarketRefDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.skuMarketRefDgDomain.filter().in((Object)"sku_id", skuMarketStatusMqEvent.getSkuIds())).in((Object)"shop_id", skuMarketStatusMqEvent.getShopIds())).eq((Object)"market_status", (Object)SkuItemMarketStatusEnum.MARKET_STATUS_OFF.getStatus())).list();
        if (CollectionUtil.isEmpty((Collection)skuMarketRefDgEos)) {
            log.info("sku\u4e0a\u5e02\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        List<BizTagRecordDto> shopSkuTagList = this.reportHelper.getShopSkuTag(skuMarketStatusMqEvent.getSkuIds(), skuMarketStatusMqEvent.getShopIds(), "New_product", true);
        List<BizTagRecordDto> skuTagList = this.reportHelper.getShopSkuTag(skuMarketStatusMqEvent.getSkuIds(), null, "New_product", false);
        Map<Object, Object> skuTagDtoMap = Maps.newHashMap();
        ArrayList skuMarketRefDgEoList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(shopSkuTagList)) {
            Map shopSkuTagDtoMap = shopSkuTagList.stream().collect(Collectors.toMap(s -> s.getRecordLinkId() + "_" + s.getRecordLinkParentId(), Function.identity(), (v1, v2) -> v1));
            for (SkuMarketRefDgEo skuMarketRefDgEo : skuMarketRefDgEos) {
                if (shopSkuTagDtoMap.containsKey(skuMarketRefDgEo.getSkuId() + "_" + skuMarketRefDgEo.getShopId())) continue;
                skuMarketRefDgEoList.add(skuMarketRefDgEo);
            }
        } else {
            skuMarketRefDgEoList.addAll(skuMarketRefDgEos);
        }
        if (CollectionUtil.isNotEmpty(skuTagList)) {
            skuTagDtoMap = skuTagList.stream().collect(Collectors.toMap(BizTagRecordDto::getRecordLinkId, Function.identity(), (v1, v2) -> v1));
        }
        this.reportHelper.addOrDeleteShopTag(null, skuMarketRefDgEoList, SkuMarketRefDgEo::getSkuId, SkuMarketRefDgEo::getShopId, "New_product");
        Set skuIds = skuMarketRefDgEos.stream().map(SkuMarketRefDgEo::getSkuId).collect(Collectors.toSet());
        List itemSkuDgEoList = this.skuDgDomain.selectByIds((List)Lists.newArrayList(skuIds));
        if (CollectionUtil.isEmpty((Collection)itemSkuDgEoList)) {
            log.info("sku\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        ArrayList addSkuTagList = Lists.newArrayList();
        for (ItemSkuDgEo skuDgEo : itemSkuDgEoList) {
            LocalDate localDate;
            if (!Objects.nonNull(skuDgEo.getFirstMarketDate()) || (localDate = skuDgEo.getFirstMarketDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).compareTo(LocalDate.now()) != 0) continue;
            log.info("\u9996\u6b21\u4e0a\u5e02\u65f6\u95f4:{}", (Object)localDate);
            if (skuTagDtoMap.containsKey(skuDgEo.getId())) continue;
            addSkuTagList.add(skuDgEo);
        }
        if (CollectionUtil.isNotEmpty((Collection)addSkuTagList)) {
            this.reportHelper.addOrDeleteShopTag(null, addSkuTagList, BaseEo::getId, null, "New_product");
        }
    }
}

