/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.api.item.IItemDgApi;
import com.yunxi.dg.base.center.item.constants.ItemDgStatus;
import com.yunxi.dg.base.center.item.dto.request.FreightItemReq;
import com.yunxi.dg.base.center.item.dto.request.ItemAuditDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemBatchImportImageReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemBatchUpdateFrontDirReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemBundleDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemChangeApplyDgDto;
import com.yunxi.dg.base.center.item.dto.request.ItemChangeSaleStatusReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemLibDetailDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemLibPublishToShopDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemMarketStatusDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemModifyStatusDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemOffShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemOnShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemPublishDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemRemarkDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStatDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemTagDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfModifyShopAuthDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfTaskUpdateDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShopItemUpdateDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemModifyStatusDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfQueryDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemTagRelationDgEo;
import com.yunxi.dg.base.center.item.service.cache.IItemCacheClearDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemShelfDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemTagDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfDgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ItemDgApiImpl
implements IItemDgApi {
    private Logger logger = LoggerFactory.getLogger(ItemDgApiImpl.class);
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IItemShelfDgService itemShelfDgService;
    @Resource
    private IItemTagDgService itemTagDgService;
    @Autowired
    private IItemSkuDgService itemSkuDgService;
    @Autowired
    private IShelfDgService shelfDgService;
    @Resource
    private List<IItemCacheClearDgService> itemCacheClearDgServices;

    public RestResponse<Void> removeItem(String ids) {
        String[] idList;
        for (String id : idList = ids.split(",")) {
            this.itemDgService.removeItem(Long.valueOf(id));
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeItemShelf(@NotNull String ids) {
        this.shelfDgService.batchRemoveShelf(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> onShelfItem(ItemOnShelfDgReqDto onShelfDgReqDto) {
        this.itemShelfDgService.batchOnShelfItem(onShelfDgReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> offShelfItem(ItemOffShelfDgReqDto itemOffShelfDgReqDto) {
        this.itemShelfDgService.batchOffShelfItem(itemOffShelfDgReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addItemDir(Long itemId, String dirIds, Long shopId, Long channelId) {
        this.itemShelfDgService.addItemDir(itemId, dirIds, shopId, channelId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> deleteDirItemByIds(List<Long> dirItemIdList) {
        this.itemShelfDgService.deleteDirItemByIds(dirItemIdList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> publish(ItemPublishDgReqDto itemPublishDgReqDto) {
        this.itemDgService.publish(itemPublishDgReqDto);
        this.itemCacheClearDgServices.forEach(cacheClearService -> cacheClearService.clear(itemPublishDgReqDto.getItemId()));
        return RestResponse.VOID;
    }

    public RestResponse<Void> audit(ItemAuditDgReqDto itemAuditDgReqDto) {
        this.itemDgService.audit(itemAuditDgReqDto);
        this.itemCacheClearDgServices.forEach(cacheClearService -> cacheClearService.clear(itemAuditDgReqDto.getItemId()));
        return RestResponse.VOID;
    }

    public RestResponse<Void> addItemTag(List<ItemTagDgReqDto> requestItemTags) {
        ArrayList itemTagEos = Lists.newArrayList();
        if (null != requestItemTags) {
            DtoHelper.dtoList2EoList(requestItemTags, (Collection)itemTagEos, ItemTagRelationDgEo.class);
        }
        this.itemTagDgService.relateToItem(itemTagEos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeItemTag(@NotNull Long id, @NotNull String tagIds) {
        String[] tagIdList;
        ArrayList<ItemTagRelationDgEo> itemTagEos = new ArrayList<ItemTagRelationDgEo>();
        for (String tagId : tagIdList = tagIds.split(",")) {
            ItemTagRelationDgEo itemTagEo = ItemTagRelationDgEo.newInstance();
            itemTagEo.setTagId(Long.valueOf(Long.parseLong(tagId)));
            itemTagEo.setItemId(id);
            itemTagEos.add(itemTagEo);
        }
        this.itemTagDgService.removeRelation(itemTagEos);
        return RestResponse.VOID;
    }

    public RestResponse<List<ItemDgRespDto>> checkShoppingCartItemInvalid(List<Long> itemIdList) {
        return new RestResponse(this.itemDgService.queryItemStatus(itemIdList));
    }

    public RestResponse<Void> modifyShelfTask(List<ShelfTaskUpdateDgReqDto> shelfTaskUpdateDgReqDtos) {
        this.itemShelfDgService.modifyShelfTask(shelfTaskUpdateDgReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeShelfTask(List<Long> ids, Long instanceId, Long tenantId) {
        this.itemShelfDgService.removeShelfTask(ids, instanceId, tenantId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addOrModifyItemSalesCount(ItemStatDgReqDto itemStatDgReqDto) {
        this.itemDgService.addOrModifyItemSalesCount(itemStatDgReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<ItemModifyStatusDgRespDto> batchEnable(@RequestBody ItemModifyStatusDgReqDto modifyStatusReqDto) {
        return new RestResponse((Object)this.itemDgService.batchEnable(modifyStatusReqDto));
    }

    public RestResponse<Void> newSyncEs(ShelfQueryDgReqDto shelfQueryDgReqDto) {
        shelfQueryDgReqDto.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
        List<ShelfQueryDgRespDto> selfList = this.shelfDgService.queryShelfList(shelfQueryDgReqDto);
        selfList.forEach(shelfQueryRespDto -> {
            ShelfDgReqDto shelfDgReqDto = new ShelfDgReqDto();
            CubeBeanUtils.copyProperties((Object)shelfDgReqDto, (Object)shelfQueryDgReqDto, (String[])new String[0]);
            this.itemDgService.refreshSyn(shelfDgReqDto);
        });
        return new RestResponse();
    }

    public RestResponse<Void> syncEs() {
        ShelfQueryDgReqDto shelfQueryDgReqDto = new ShelfQueryDgReqDto();
        shelfQueryDgReqDto.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
        List<ShelfQueryDgRespDto> selfList = this.shelfDgService.queryShelfList(shelfQueryDgReqDto);
        selfList.forEach(shelfQueryRespDto -> {
            ShelfDgReqDto shelfDgReqDto = new ShelfDgReqDto();
            CubeBeanUtils.copyProperties((Object)shelfDgReqDto, (Object)shelfQueryDgReqDto, (String[])new String[0]);
            this.itemDgService.refresh(shelfDgReqDto);
        });
        return new RestResponse();
    }

    public RestResponse<Long> addItem(@NotNull ItemChangeApplyDgDto changeApplyDto) {
        if (CollectionUtil.isNotEmpty((Collection)changeApplyDto.getSkus())) {
            for (ItemBundleDgReqDto skus : changeApplyDto.getSkus()) {
                String unit = skus.getUnit();
                skus.setSaleUnit(Objects.nonNull(skus.getSaleUnit()) ? skus.getSaleUnit() : unit);
                skus.setPriceUnit(Objects.nonNull(skus.getPriceUnit()) ? skus.getPriceUnit() : unit);
            }
        }
        return new RestResponse((Object)this.itemDgService.addItem(changeApplyDto));
    }

    public RestResponse<Long> updateItemInfo(@NotNull ItemChangeApplyDgDto changeApplyDto) {
        Long itemId = this.itemDgService.updateItem(changeApplyDto);
        this.itemDgService.pushEsMessage(itemId);
        return new RestResponse((Object)itemId);
    }

    public RestResponse<Void> batchModifyShelfShopAuth(ShelfModifyShopAuthDgReqDto modifyShopAuthReqDto) {
        this.itemShelfDgService.batchModifyShelfShopAuth(modifyShopAuthReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> changeSaleStatus(ItemChangeSaleStatusReqDto reqDto) {
        this.itemDgService.changeSaleStatus(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateItemLibDetail(ItemLibDetailDgReqDto itemDgReqDto) {
        this.itemDgService.updateItemLibDetail(itemDgReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateShopItemDetail(ShopItemUpdateDgReqDto updateDgReqDto) {
        this.itemDgService.updateShopItemDetail(updateDgReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> publishToShop(ItemLibPublishToShopDgReqDto reqDto) {
        this.itemDgService.publishToShop(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> changeMarketStatus(ItemMarketStatusDgReqDto reqDto) {
        this.itemDgService.changeMarketStatus(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchUpdateItemFrontDirInfo(ItemBatchUpdateFrontDirReqDto reqDto) {
        this.itemDgService.batchUpdateItemFrontDirInfo(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<List<String>> batchImportItemImages(ItemBatchImportImageReqDto reqDto) {
        return new RestResponse(this.itemDgService.batchImportItemImages(reqDto));
    }

    public RestResponse<Void> batchItemRemark(ItemRemarkDgReqDto reqDto) {
        this.itemDgService.batchItemRemark(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> importItemInfo(List<ItemChangeApplyDgDto> changeApplyDgDtoList) {
        this.itemDgService.importItemInfo(changeApplyDgDtoList);
        return RestResponse.VOID;
    }

    public RestResponse<Long> initFreightItem(FreightItemReq freightItemReq) {
        return new RestResponse((Object)this.itemDgService.initFreightItem(freightItemReq));
    }
}

