/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl.query;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.api.brand.IBrandDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.BrandPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.BrandDgRespDto;
import com.yunxi.dg.base.center.item.eo.BrandDgEo;
import com.yunxi.dg.base.center.item.service.entity.IBrandDgService;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BrandDgQueryApiImpl
implements IBrandDgQueryApi {
    @Resource
    private IBrandDgService brandDgService;

    public RestResponse<BrandDgRespDto> queryById(Long id) {
        BrandDgRespDto brandDgRespDto = this.brandDgService.selectById(id);
        return new RestResponse((Object)brandDgRespDto);
    }

    public RestResponse<PageInfo<BrandDgRespDto>> queryByPage(BrandPageDgReqDto dto) {
        List<SqlFilter> sqlFilterList;
        BrandDgEo brandDgEo = BrandDgEo.newInstance((Map)dto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)brandDgEo);
        QueryParamDgUtils.fillQueryCreateStartTime(dto.getCreateStartTime(), (BaseEo)brandDgEo);
        QueryParamDgUtils.fillQueryCreateEndTime(dto.getCreateEndTime(), (BaseEo)brandDgEo);
        QueryParamDgUtils.fillQueryUpdateStartTime(dto.getUpdateStartTime(), (BaseEo)brandDgEo);
        QueryParamDgUtils.fillQueryUpdateEndTime(dto.getUpdateEndTime(), (BaseEo)brandDgEo);
        QueryParamDgUtils.columnLike((BaseEo)brandDgEo, "name", brandDgEo.getName());
        if (CollectionUtil.isNotEmpty((Collection)dto.getCodes())) {
            sqlFilterList = brandDgEo.getSqlFilters();
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList<SqlFilter>();
            }
            sqlFilterList.add(SqlFilter.in((String)"code", (Object)dto.getCodes()));
            brandDgEo.setSqlFilters(sqlFilterList);
        } else {
            QueryParamDgUtils.columnLike((BaseEo)brandDgEo, "code", brandDgEo.getCode());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getExternalCodeList())) {
            sqlFilterList = brandDgEo.getSqlFilters();
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList();
            }
            sqlFilterList.add(SqlFilter.in((String)"external_code", (Object)dto.getExternalCodeList()));
            brandDgEo.setSqlFilters(sqlFilterList);
        } else {
            QueryParamDgUtils.columnLike((BaseEo)brandDgEo, "external_code", brandDgEo.getExternalCode());
        }
        if (StringUtils.isBlank((CharSequence)brandDgEo.getOrderByDesc())) {
            brandDgEo.setOrderByDesc("create_time");
        }
        Integer pageNum = Objects.nonNull(dto.getPageNum()) ? dto.getPageNum() : 1;
        Integer pageSize = Objects.nonNull(dto.getPageSize()) ? dto.getPageSize() : 10;
        PageInfo<BrandDgEo> brandEoPageInfo = this.brandDgService.queryBrandByPage(brandDgEo, pageNum, pageSize);
        ArrayList list = Lists.newArrayList();
        PageInfo pageInfo = new PageInfo((List)list);
        DtoHelper.eoList2DtoList((Collection)brandEoPageInfo.getList(), (Collection)list, BrandDgRespDto.class);
        CubeBeanUtils.copyProperties((Object)pageInfo, brandEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList((List)list);
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<List<BrandDgRespDto>> queryList(BrandPageDgReqDto pageDgReqDto) {
        List<BrandDgRespDto> brandDgRespDtoList = this.brandDgService.queryList(pageDgReqDto);
        return new RestResponse(brandDgRespDtoList);
    }

    public RestResponse<List<BrandDgRespDto>> queryByIds(List<Long> brandIds) {
        return new RestResponse(this.brandDgService.queryByIds(brandIds));
    }

    public RestResponse<BrandDgRespDto> queryCode(String code) {
        return new RestResponse((Object)this.brandDgService.queryCode(code));
    }

    public RestResponse<List<BrandDgRespDto>> queryByCodes(List<String> codes) {
        return new RestResponse(this.brandDgService.queryByCodes(codes));
    }
}

