/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl.query;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.api.sku.IItemSkuDgQueryApi;
import com.yunxi.dg.base.center.item.constants.OrganizationConstants;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemRelationSkuDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemShelfSkuSearchDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSkuDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSkuQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSyncReqDto;
import com.yunxi.dg.base.center.item.dto.request.MarketSkuSearchDto;
import com.yunxi.dg.base.center.item.dto.request.ShopItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirShelfItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRelationSkuDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuExtDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuExtListDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.SameModelSkuRespDto;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import com.yunxi.dg.base.center.item.service.util.StringSplitDgUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class IItemSkuDgQueryApiImpl
implements IItemSkuDgQueryApi {
    @Resource
    private IItemSkuDgService itemSkuDgService;

    public RestResponse<List<ItemSkuDgRespDto>> queryBySkuCode(List<String> skuCodes) {
        if (CollectionUtils.isEmpty(skuCodes)) {
            return new RestResponse();
        }
        return new RestResponse(this.itemSkuDgService.queryBySkuCode(skuCodes, true));
    }

    public RestResponse<List<ItemSkuExtDgRespDto>> queryByCargoCode(List<String> cargoCodes) {
        if (CollectionUtils.isEmpty(cargoCodes)) {
            return new RestResponse();
        }
        return new RestResponse(this.itemSkuDgService.queryByCargoCode(cargoCodes));
    }

    public RestResponse<List<ItemSkuExtDgRespDto>> querySkuExtBySkuId(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return new RestResponse();
        }
        return new RestResponse(this.itemSkuDgService.querySkuExtBySkuId(skuIds));
    }

    public RestResponse<List<ItemSkuDgRespDto>> queryBySkuId(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return new RestResponse();
        }
        return new RestResponse(this.itemSkuDgService.queryBySkuId(skuIds));
    }

    public RestResponse<List<ItemSkuExtListDgRespDto>> querySkuExtBySkuCodes(List<String> skuCodes) {
        List<ItemSkuExtListDgRespDto> skuExtDgRespDtos = this.itemSkuDgService.querySkuExtBySkuCodes(skuCodes);
        return new RestResponse(skuExtDgRespDtos);
    }

    public RestResponse<List<ItemSkuDgRespDto>> queryByItemIdList(List<Long> itemId) {
        if (CollectionUtils.isEmpty(itemId)) {
            return new RestResponse();
        }
        return new RestResponse(this.itemSkuDgService.queryByItemIdList(itemId));
    }

    public RestResponse<PageInfo<ItemRelationSkuDgRespDto>> queryItemRelationSku(ItemRelationSkuDgReqDto itemRelationSkuDgReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemSkuDgService.queryItemRelationSku(itemRelationSkuDgReqDto, pageNum, pageSize));
    }

    public RestResponse<List<DirShelfItemDgRespDto>> queryByDirId(Long dirId, String name) {
        return new RestResponse(this.itemSkuDgService.queryByDirId(dirId, name));
    }

    public RestResponse<PageInfo<DirShelfItemDgRespDto>> querySkuPageByDirId(ItemShelfSkuSearchDgReqDto itemShelfSkuSearchDgReqDto) {
        return new RestResponse(this.itemSkuDgService.querySkuPageByDirId(itemShelfSkuSearchDgReqDto));
    }

    public RestResponse<List<ItemSkuDgRespDto>> queryByItemId(Long itemId) {
        return new RestResponse(this.itemSkuDgService.queryByItemId(itemId));
    }

    public RestResponse<List<ItemSkuDgRespDto>> queryDetailByItemIds(List<Long> itemIds) {
        return new RestResponse(this.itemSkuDgService.queryDetailsByItemIds(itemIds));
    }

    public RestResponse<String> updateCostPrice(ItemSkuDgReqDto itemSkuDgReqDto) {
        return new RestResponse((Object)this.itemSkuDgService.updateCostPrice(itemSkuDgReqDto));
    }

    public RestResponse<PageInfo<ItemSkuQueryDgRespDto>> querySkuPage(ItemSkuQueryDgReqDto itemSkuQueryDgReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemSkuDgService.querySkuPage(itemSkuQueryDgReqDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<DgItemSkuPageRespDto>> queryItemListByPage(ItemQueryDgReqDto itemDgReqDto) {
        this.getItemQueryDgReqDto(itemDgReqDto);
        this.addDefaultOrganization(itemDgReqDto);
        return new RestResponse(this.itemSkuDgService.queryItemListByPage(itemDgReqDto));
    }

    public RestResponse<List<DgItemSkuDetailRespDto>> querySkuList(@RequestBody ItemQueryDgReqDto itemDgReqDto) {
        this.getItemQueryDgReqDto(itemDgReqDto);
        this.addDefaultOrganization(itemDgReqDto);
        return new RestResponse(this.itemSkuDgService.querySkuList(itemDgReqDto));
    }

    public RestResponse<DgItemSkuDetailRespDto> getItemSkuDetailById(Long skuId) {
        return new RestResponse((Object)this.itemSkuDgService.getItemSkuDetailById(skuId));
    }

    public RestResponse<PageInfo<DgItemSkuPageRespDto>> queryItemShopListByPage(ShopItemQueryDgReqDto shopItemQueryDgReqDto) {
        this.getShopItemQueryDgReqDto(shopItemQueryDgReqDto);
        return new RestResponse(this.itemSkuDgService.queryItemShopListByPage(shopItemQueryDgReqDto));
    }

    public RestResponse<List<DgItemSkuDetailRespDto>> queryShopSkuList(ShopItemQueryDgReqDto shopItemQueryDgReqDto) {
        this.getShopItemQueryDgReqDto(shopItemQueryDgReqDto);
        return new RestResponse(this.itemSkuDgService.queryShopSkuList(shopItemQueryDgReqDto));
    }

    public RestResponse<PageInfo<DgItemSkuPageRespDto>> queryItemPageByCodes(ItemSyncReqDto reqDto) {
        return new RestResponse(this.itemSkuDgService.queryItemPageByCodes(reqDto));
    }

    public RestResponse<PageInfo<DgItemSkuPageRespDto>> querySimpleItemListByPage(ItemQueryDgReqDto itemDgReqDto) {
        this.getItemQueryDgReqDto(itemDgReqDto);
        this.addDefaultOrganization(itemDgReqDto);
        return new RestResponse(this.itemSkuDgService.querySimpleItemListByPage(itemDgReqDto));
    }

    public RestResponse<List<DgItemSkuPageRespDto>> querySimpleItemList(ItemQueryDgReqDto itemDgReqDto) {
        this.getItemQueryDgReqDto(itemDgReqDto);
        return new RestResponse(this.itemSkuDgService.querySimpleItemList(itemDgReqDto));
    }

    public RestResponse<Long> countSimpleItemList(ItemQueryDgReqDto itemDgReqDto) {
        this.getItemQueryDgReqDto(itemDgReqDto);
        return new RestResponse((Object)this.itemSkuDgService.countSimpleItemList(itemDgReqDto));
    }

    public RestResponse<List<ItemSkuDgRespDto>> querySkusBySkuCode(List<String> skuCodes) {
        return new RestResponse(this.itemSkuDgService.queryBySkuCode(skuCodes, false));
    }

    public RestResponse<List<String>> querySpecModelBySkuCode(List<String> skuCodes) {
        return new RestResponse(this.itemSkuDgService.querySpecModelBySkuCode(skuCodes));
    }

    private void getItemQueryDgReqDto(ItemQueryDgReqDto reqDto) {
        List<String> strings;
        if (Objects.isNull(reqDto)) {
            return;
        }
        if (Objects.nonNull(reqDto.getItemCode()) && (strings = StringSplitDgUtil.splitString(reqDto.getItemCode())).size() > 1) {
            reqDto.setItemCodes(strings);
            reqDto.setItemCode(null);
        }
        if (Objects.nonNull(reqDto.getSkuCode()) && (strings = StringSplitDgUtil.splitString(reqDto.getSkuCode())).size() > 1) {
            reqDto.setSkuCodes(strings);
            reqDto.setSkuCode(null);
        }
        if (Objects.nonNull(reqDto.getKeyCode()) && (strings = StringSplitDgUtil.splitString(reqDto.getKeyCode())).size() > 1) {
            reqDto.setKeyCodes(strings);
            reqDto.setKeyCode(null);
        }
    }

    private void getShopItemQueryDgReqDto(ShopItemQueryDgReqDto reqDto) {
        List<String> strings;
        if (Objects.isNull(reqDto)) {
            return;
        }
        if (Objects.nonNull(reqDto.getItemCode()) && (strings = StringSplitDgUtil.splitString(reqDto.getItemCode())).size() > 1) {
            reqDto.setItemCodes(strings);
            reqDto.setItemCode(null);
        }
        if (Objects.nonNull(reqDto.getSkuCode()) && (strings = StringSplitDgUtil.splitString(reqDto.getSkuCode())).size() > 1) {
            reqDto.setSkuCodes(strings);
            reqDto.setSkuCode(null);
        }
        if (Objects.nonNull(reqDto.getKeyCode()) && (strings = StringSplitDgUtil.splitString(reqDto.getKeyCode())).size() > 1) {
            reqDto.setKeyCodes(strings);
            reqDto.setKeyCode(null);
        }
    }

    private void addDefaultOrganization(ItemQueryDgReqDto pageDto) {
        if (Objects.nonNull(pageDto)) {
            if (CollectionUtil.isNotEmpty((Collection)pageDto.getOrganizationIdList())) {
                pageDto.getOrganizationIdList().add(OrganizationConstants.ITEM_ORGANIZATION_ID);
            }
            if (CollectionUtil.isNotEmpty((Collection)pageDto.getOrganizationCodeList())) {
                pageDto.getOrganizationCodeList().add("000001");
            }
        }
    }

    public RestResponse<PageInfo<DgItemSkuPageRespDto>> queryMarketSkuPage(MarketSkuSearchDto reqDto) {
        return new RestResponse(this.itemSkuDgService.queryMarketSkuPage(reqDto));
    }

    public RestResponse<List<SameModelSkuRespDto>> querySameSpecModelSkus(List<String> skuCodes) {
        return new RestResponse(this.itemSkuDgService.querySameSpecModelSkus(skuCodes));
    }
}

