/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl.query;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.yunxi.dg.base.center.item.api.item.IItemDgQueryApi;
import com.yunxi.dg.base.center.item.constants.OrganizationConstants;
import com.yunxi.dg.base.center.item.dto.request.BranchQueryItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.BundleItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DgItemSkuPlanQueryReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirItemRelativeDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemAllowOrderQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemDetailDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemDirQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemExchangeUnitDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemLibPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSearchDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSearchDgVoReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSearchQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemShelfQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSkuDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfTaskQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShopItemPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.BranchItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.BundleItemDetailDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.BundleItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirItemRelativeQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemAllSuperiorRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemAllowOrderQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemAttributesDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDetailDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDetailInfoDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDgPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDirQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemExchangeUnitDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemOnShelfDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemPriceDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRoundDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSearchDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfCountDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfSkuDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuCodeQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDetailDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuExtDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuListDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuRelDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemStatDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PointsDeductionDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PropNameDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfTaskQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShopItemDgDto;
import com.yunxi.dg.base.center.item.dto.response.ShopItemDgPageRespDto;
import com.yunxi.dg.base.center.item.eo.DirItemRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemAttributesDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemMediasDgEo;
import com.yunxi.dg.base.center.item.eo.ItemPriceDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.ItemTagRelationDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.plugin.EnableCachePlugin;
import com.yunxi.dg.base.center.item.service.entity.IDirDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemAttributesDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemExchangeDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemMediasDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemPriceDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemShelfDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemTagDgService;
import com.yunxi.dg.base.center.item.service.entity.IPropDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfDgService;
import com.yunxi.dg.base.center.item.service.util.StringSplitDgUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemDgQueryApiImpl
implements IItemDgQueryApi {
    private Logger logger = LoggerFactory.getLogger(ItemDgQueryApiImpl.class);
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IItemTagDgService itemTagDgService;
    @Resource
    private IItemAttributesDgService itemAttributesDgService;
    @Resource
    private IItemMediasDgService iItemMediasDgService;
    @Resource
    private IItemSkuDgService iItemSkuDgService;
    @Resource
    private IItemShelfDgService itemShelfDgService;
    @Resource
    private IItemPriceDgService iItemPriceDgService;
    @Resource
    private IDirectoryItemDgService directoryItemDgService;
    @Resource
    private IShelfDgService shelfDgService;
    @Resource
    private IDirDgService dirDgService;
    @Resource
    private IPropDgService propDgService;
    @Resource(name="${project.domain.prefix:dg}ItemExchangeDgService")
    private IItemExchangeDgService itemExchangeDgService;

    public RestResponse<PageInfo<ItemSkuExtDgRespDto>> queryItemLibSkuByPage(ItemDgReqDto itemDgReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemDgService.queryItemLibSkuByPage(itemDgReqDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<ItemOnShelfDgRespDto>> findItemOnSelf(ItemSearchDgVoReqDto searchDgVoReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemDgService.findItemOnSelf(searchDgVoReqDto, pageNum, pageSize));
    }

    public RestResponse<ItemDetailDgRespDto> queryItemDetailByItemId(Long id) {
        return new RestResponse((Object)this.itemDgService.queryItemDetailByItemId(id));
    }

    public RestResponse<BundleItemDetailDgRespDto> queryBundleItemDetailByItemId(Long id) {
        return new RestResponse((Object)this.itemDgService.queryBundleItemDetailByItemId(id));
    }

    public RestResponse<PageInfo<ItemDgPageRespDto>> queryByPage(ItemPageDgReqDto pageDto) {
        this.addDefaultOrganization(pageDto);
        return new RestResponse(this.itemDgService.queryByPage(pageDto));
    }

    public RestResponse<List<ItemDgPageRespDto>> queryByList(ItemPageDgReqDto pageDto) {
        this.addDefaultOrganization(pageDto);
        return new RestResponse(this.itemDgService.queryByList(pageDto));
    }

    public RestResponse<PageInfo<ItemShelfQueryDgRespDto>> queryShelfItemByPage(ItemShelfQueryDgReqDto itemShelfQueryDgReqDto, Integer pageNum, Integer pageSize) {
        PageInfo<ItemShelfQueryDgRespDto> pageInfo = this.shelfDgService.getItemShelfPage(itemShelfQueryDgReqDto, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }

    public RestResponse<PageInfo<ItemShelfQueryDgRespDto>> queryShelfItemByPageByPost(ItemShelfQueryDgReqDto itemShelfQueryDgReqDto, Integer pageNum, Integer pageSize) {
        PageInfo<ItemShelfQueryDgRespDto> pageInfo = this.shelfDgService.getItemShelfPage(itemShelfQueryDgReqDto, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }

    public RestResponse<ItemShelfCountDgRespDto> countShelfItem(ItemShelfQueryDgReqDto itemShelfQueryDgReqDto) {
        if (itemShelfQueryDgReqDto == null) {
            itemShelfQueryDgReqDto = new ItemShelfQueryDgReqDto();
        }
        ItemShelfCountDgRespDto dto = new ItemShelfCountDgRespDto();
        Long onShelfNum = 0L;
        Long offShelfNum = 0L;
        itemShelfQueryDgReqDto.setItemStatus(null);
        itemShelfQueryDgReqDto.setSellOut(null);
        itemShelfQueryDgReqDto.setItemType(itemShelfQueryDgReqDto.getItemType());
        itemShelfQueryDgReqDto.setItemStatus(Integer.valueOf(1));
        ItemShelfQueryDgReqDto onShelfReq = (ItemShelfQueryDgReqDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemShelfQueryDgReqDto), ItemShelfQueryDgReqDto.class);
        CompletableFuture<Long> onShelfNumFuture = CompletableFuture.supplyAsync(() -> this.shelfDgService.newCountItemShelf(onShelfReq));
        itemShelfQueryDgReqDto.setItemStatus(Integer.valueOf(2));
        ItemShelfQueryDgReqDto unShelfReq = (ItemShelfQueryDgReqDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemShelfQueryDgReqDto), ItemShelfQueryDgReqDto.class);
        CompletableFuture<Long> unShelfNumFuture = CompletableFuture.supplyAsync(() -> this.shelfDgService.newCountItemShelf(unShelfReq));
        CompletableFuture.allOf(unShelfNumFuture, onShelfNumFuture);
        try {
            onShelfNum = onShelfNumFuture.get();
            offShelfNum = unShelfNumFuture.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        dto.setTotalNum(Long.valueOf(offShelfNum + onShelfNum));
        dto.setOnShelfNum(onShelfNum);
        dto.setOffShelfNum(offShelfNum);
        return new RestResponse((Object)dto);
    }

    public RestResponse<List<ItemShelfSkuDgRespDto>> queryShelfItemSkuList(Long shopId, Long itemId, Integer busType) {
        return new RestResponse(this.shelfDgService.queryShelfItemSkuList(shopId, itemId, busType));
    }

    public RestResponse<ItemDetailDgRespDto> queryItemDetail(Long id, String field, Long dirId) {
        ItemDetailDgRespDto itemDetailDto = this.itemDgService.queryItemDetail(id, field, dirId);
        return new RestResponse((Object)itemDetailDto);
    }

    public RestResponse<ItemSearchDgRespDto> queryByKeyword(ItemSearchDgReqDto itemSearchDgReqDto) {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        ItemSearchQueryDgReqDto itemSearchQueryDgReqDto = new ItemSearchQueryDgReqDto();
        itemSearchQueryDgReqDto.setKeyword(itemSearchDgReqDto.getKeyword());
        itemSearchQueryDgReqDto.setBrandId(itemSearchDgReqDto.getBrandId());
        itemSearchQueryDgReqDto.setProp(itemSearchDgReqDto.getProp());
        ArrayList dirIds = Lists.newArrayList();
        dirIds.add(itemSearchDgReqDto.getDirId());
        itemSearchQueryDgReqDto.setDirIds((List)dirIds);
        itemSearchQueryDgReqDto.setBusType(itemSearchDgReqDto.getItemType());
        itemSearchQueryDgReqDto.setInstanceId(instanceId);
        itemSearchQueryDgReqDto.setTenantId(tenantId);
        if (StringUtils.isNotEmpty((CharSequence)itemSearchDgReqDto.getLat())) {
            itemSearchQueryDgReqDto.setLat(Double.valueOf(itemSearchDgReqDto.getLat()));
        }
        if (StringUtils.isNotEmpty((CharSequence)itemSearchDgReqDto.getLon())) {
            itemSearchQueryDgReqDto.setLon(Double.valueOf(itemSearchDgReqDto.getLon()));
        }
        ItemSearchDgRespDto itemSearchDgRespDto = this.itemDgService.queryByKeyword(itemSearchQueryDgReqDto, itemSearchDgReqDto.getPageNum(), itemSearchDgReqDto.getPageSize());
        return new RestResponse((Object)itemSearchDgRespDto);
    }

    public RestResponse<ItemSearchDgRespDto> queryByKeyword(ItemSearchQueryDgReqDto queryDgReqDto, Integer pageNum, Integer pageSize) {
        if (Objects.isNull(queryDgReqDto)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        return new RestResponse((Object)this.itemDgService.queryByKeyword(queryDgReqDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<ItemDgPageRespDto>> queryItemByTagId(String ids, Integer pageNum, Integer pageSize) {
        List<ItemTagRelationDgEo> itemTagEos = this.itemTagDgService.queryItemTag(ids, ServiceContext.getContext().getRequestTenantId(), ServiceContext.getContext().getRequestInstanceId());
        PageInfo<ItemDgPageRespDto> pageInfo = new PageInfo<ItemDgPageRespDto>();
        if (CollectionUtils.isEmpty(itemTagEos)) {
            pageInfo.setPageNum(pageNum.intValue());
            pageInfo.setPageSize(pageSize.intValue());
            return new RestResponse((Object)pageInfo);
        }
        List itemIds = itemTagEos.stream().map(ItemTagRelationDgEo::getItemId).collect(Collectors.toList());
        ItemPageDgReqDto pageDto = new ItemPageDgReqDto();
        pageDto.setIds(itemIds);
        pageInfo = this.itemDgService.queryByPage(pageDto);
        return new RestResponse(pageInfo);
    }

    private RequestDto parseFilter(String filter) {
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            return (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RequestDto();
    }

    private ItemDgReqDto parseItemFilter(String filter) {
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            return (ItemDgReqDto)JSON.parseObject((String)filter, ItemDgReqDto.class);
        }
        return new ItemDgReqDto();
    }

    public RestResponse<PageInfo<ItemDgPageRespDto>> queryItemByDirId(String dirIds, Integer pageNum, Integer pageSize, ItemDgReqDto itemDgReqDto) {
        List<Object> dirs = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)dirIds)) {
            long[] longArray = (long[])ConvertUtils.convert((String[])StringUtils.split((String)dirIds, (String)","), Long.TYPE);
            dirs = Longs.asList((long[])longArray);
        }
        dirs = this.directoryItemDgService.convertLinkDir(dirs, itemDgReqDto.getInstanceId(), itemDgReqDto.getTenantId());
        PageInfo<ItemDgPageRespDto> pageInfo = new PageInfo<ItemDgPageRespDto>();
        if (CollectionUtils.isEmpty((Collection)dirs)) {
            pageInfo.setPageNum(pageNum.intValue());
            pageInfo.setPageSize(pageSize.intValue());
            return new RestResponse((Object)pageInfo);
        }
        PageInfo<DirItemRelationDgEo> dirsItemPageInfo = this.itemShelfDgService.queryByDirIds(itemDgReqDto.getTenantId(), itemDgReqDto.getInstanceId(), dirs, pageNum, pageSize);
        List dirsItemsEoList = dirsItemPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)dirsItemsEoList)) {
            pageInfo.setPageSize(pageSize.intValue());
            pageInfo.setPageNum(pageNum.intValue());
            return new RestResponse((Object)pageInfo);
        }
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (DirItemRelationDgEo dirsItemsEo : dirsItemsEoList) {
            itemIds.add(dirsItemsEo.getItemId());
        }
        ItemPageDgReqDto itemDgReq = new ItemPageDgReqDto();
        ItemDgEo example = ItemDgEo.newInstance();
        ArrayList sqlFilters = new ArrayList();
        itemDgReq.setIds(itemIds);
        itemDgReq.setStatus(itemDgReqDto.getStatus());
        itemDgReq.setName(itemDgReqDto.getName());
        itemDgReq.setCode(itemDgReqDto.getCode());
        itemDgReq.setBrandId(itemDgReqDto.getDirId());
        if (StringUtils.isNotBlank((CharSequence)itemDgReqDto.getSkuCode())) {
            ItemSkuDgEo itemSkuDgEo = this.iItemSkuDgService.getBySkuCode(itemDgReqDto.getSkuCode());
            if (null == itemSkuDgEo) {
                return new RestResponse((Object)pageInfo);
            }
            itemDgReq.setId(itemSkuDgEo.getItemId());
        }
        itemDgReq.setYearEnd(itemDgReqDto.getYearEnd());
        itemDgReq.setYearBegin(itemDgReqDto.getYearEnd());
        pageInfo = this.itemDgService.queryByPage(itemDgReq);
        return new RestResponse(pageInfo);
    }

    @EnableCachePlugin
    public RestResponse<ItemSearchDgRespDto> queryItemByDirIdDepth(ItemSearchQueryDgReqDto itemSearchReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse((Object)this.itemDgService.queryItemByDirIdDepth(itemSearchReqDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<ItemAttributesDgRespDto>> queryItemAttrById(Long id, Integer pageNum, Integer pageSize) {
        ItemAttributesDgEo itemAttributesDgEo = ItemAttributesDgEo.newInstance();
        itemAttributesDgEo.setItemId(id);
        PageInfo<ItemAttributesDgEo> pageInfo = this.itemAttributesDgService.queryByPage(itemAttributesDgEo, pageNum, pageSize);
        PageInfo itemAttributesDtoPageInfo = new PageInfo();
        ArrayList itemAttributesDgRespDtos = new ArrayList();
        CubeBeanUtils.copyProperties((Object)itemAttributesDtoPageInfo, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), itemAttributesDgRespDtos, ItemAttributesDgRespDto.class);
        itemAttributesDtoPageInfo.setList(itemAttributesDgRespDtos);
        return new RestResponse((Object)itemAttributesDtoPageInfo);
    }

    public RestResponse<List<ItemSkuDgRespDto>> queryItemSkuByItemId(Long itemId) {
        ItemSkuDgEo itemSkuDgEo = ItemSkuDgEo.newInstance();
        itemSkuDgEo.setItemId(itemId);
        List<ItemSkuDgEo> itemSkuDgEos = this.iItemSkuDgService.queryItemSku(itemSkuDgEo);
        ArrayList list = new ArrayList();
        DtoHelper.eoList2DtoList(itemSkuDgEos, list, ItemSkuDgRespDto.class);
        return new RestResponse(list);
    }

    public RestResponse<List<ItemMediasDgRespDto>> queryItemMediasByItemId(Long itemId) {
        ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance();
        itemMediasDgEo.setOrderBy("id");
        itemMediasDgEo.setItemId(itemId);
        List<ItemMediasDgEo> itemMediasDgEos = this.iItemMediasDgService.queryItemMedias(itemMediasDgEo);
        ArrayList list = new ArrayList();
        DtoHelper.eoList2DtoList(itemMediasDgEos, list, ItemMediasDgRespDto.class);
        return new RestResponse(list);
    }

    public RestResponse<ItemSkuListDgRespDto> queryItemBySkuId(List<Long> skuIds) {
        return new RestResponse((Object)this.itemDgService.queryItemBySkuId(skuIds));
    }

    public RestResponse<List<ItemPriceDgRespDto>> queryItemPriceByItemId(Long id) {
        List<ItemPriceDgEo> itemPriceDgEos = this.iItemPriceDgService.queryItemPriceById(id);
        ArrayList itemPriceDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList(itemPriceDgEos, (Collection)itemPriceDtos, ItemPriceDgRespDto.class);
        return new RestResponse((Object)itemPriceDtos);
    }

    public RestResponse<List<ItemDirQueryDgRespDto>> queryItemDir(ItemDirQueryDgReqDto itemDirQueryDgReqDto) {
        return new RestResponse(this.itemDgService.queryItemDir(itemDirQueryDgReqDto));
    }

    public RestResponse<List<DirItemRelativeQueryDgRespDto>> queryItemDirRelative(DirItemRelativeDgReqDto dirItemReqDto) {
        return new RestResponse(this.itemDgService.queryItemDirRelative(dirItemReqDto));
    }

    public RestResponse<PageInfo<ShelfTaskQueryDgRespDto>> queryShelfTask(ShelfTaskQueryDgReqDto shelfTaskQueryDgReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemDgService.queryShelfTask(shelfTaskQueryDgReqDto, pageNum, pageSize));
    }

    public RestResponse<ItemAllowOrderQueryDgRespDto> checkItemAllowOrder(List<ItemAllowOrderQueryDgReqDto> itemReqDtoList) {
        return new RestResponse((Object)this.itemDgService.checkItemAllowOrder(itemReqDtoList));
    }

    public RestResponse<ItemSkuCodeQueryDgRespDto> querySkuByCode(String codes) {
        List<String> codeList = Arrays.asList(codes.trim().split(","));
        return new RestResponse((Object)this.iItemSkuDgService.querySkuByCode(codeList));
    }

    public RestResponse<List<ItemDgRespDto>> checkShoppingCartItemInvalid(List<Long> itemIdList) {
        return new RestResponse(this.itemDgService.queryItemStatus(itemIdList));
    }

    public RestResponse<ItemStatDgRespDto> queryItemSalesCountByItemId(Long itemId) {
        return new RestResponse((Object)this.itemDgService.queryItemSalesCountByItemId(itemId));
    }

    public RestResponse<List<ItemDgRespDto>> queryByItemIds(String itemIds) {
        String[] ids;
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        for (String id : ids = itemIds.trim().split(",")) {
            itemIdList.add(Long.parseLong(id));
        }
        return new RestResponse(this.itemDgService.queryItems(itemIdList));
    }

    public RestResponse<List<ItemDgRespDto>> queryByItemIdsOnPost(List<String> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return new RestResponse((Object)Lists.newArrayList());
        }
        List<Long> itemIdList = itemIds.stream().filter(Objects::nonNull).map(Long::valueOf).distinct().collect(Collectors.toList());
        return new RestResponse(this.itemDgService.queryItems(itemIdList));
    }

    public RestResponse<List<ItemDgRespDto>> queryNewByItemIds(String itemIds) {
        String[] ids;
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        for (String id : ids = itemIds.trim().split(",")) {
            itemIdList.add(Long.parseLong(id));
        }
        return new RestResponse(this.itemDgService.queryItems(itemIdList));
    }

    public RestResponse<PageInfo<Long>> querySaleOut(ItemDgReqDto itemDto, int page, int size) {
        return new RestResponse(this.itemDgService.querySaleOut(itemDto, page, size));
    }

    public RestResponse<Long> queryCount(ItemDgReqDto itemDto) {
        return new RestResponse((Object)this.itemDgService.queryCount(itemDto));
    }

    public RestResponse<PageInfo<ItemShelfDgRespDto>> queryItemShelf(ShelfDgReqDto shelfDgReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemDgService.queryItemShelf(shelfDgReqDto, pageNum, pageSize));
    }

    public RestResponse<List<Long>> queryItemIds(ItemDgReqDto itemDgReqDto) {
        return new RestResponse(this.itemDgService.queryItemIds(itemDgReqDto));
    }

    public RestResponse<ItemDgRespDto> queryItemAndSku(Long itemId, Long skuId) {
        return new RestResponse((Object)this.itemDgService.queryItemAndSku(itemId, skuId));
    }

    public RestResponse<ItemSkuDetailDgRespDto> getSkuDetail(ItemSkuDgReqDto itemSkuDgReqDto) {
        return new RestResponse((Object)this.iItemSkuDgService.getSkuDetail(itemSkuDgReqDto));
    }

    public RestResponse<BigDecimal> getSkuCostPrice(Long skuId) {
        return new RestResponse((Object)this.iItemSkuDgService.getSkuCostPrice(skuId));
    }

    public RestResponse<Integer> countByFreightTemplateId(Long freightTemplateId) {
        int count = this.itemShelfDgService.countByFreightTemplateId(freightTemplateId);
        return new RestResponse((Object)count);
    }

    public RestResponse<BranchItemDgRespDto> branchQueryItem(BranchQueryItemDgReqDto branchQueryItemDgReqDto) {
        return new RestResponse((Object)this.itemDgService.branchQueryItem(branchQueryItemDgReqDto));
    }

    public RestResponse<List<PointsDeductionDgRespDto>> queryShelfSkuPointsDeduction(List<Long> ids) {
        HashSet<Long> shelfIds = new HashSet<Long>(ids);
        return new RestResponse(this.shelfDgService.queryShelfItemPointsDeduction(shelfIds));
    }

    public RestResponse<List<ShelfQueryDgRespDto>> queryShelfList(ShelfQueryDgReqDto shelfQueryDgReqDto) {
        return new RestResponse(this.shelfDgService.queryShelfList(shelfQueryDgReqDto));
    }

    public RestResponse<List<BundleItemDgRespDto>> queryBundleItemDetail(Long shopId, Long itemId, Integer itemBusType) {
        return new RestResponse(this.itemDgService.queryBundleItemDetail(shopId, itemId, itemBusType));
    }

    public RestResponse<List<ItemSkuDgRespDto>> queryItemSkus(List<Long> skuIds) {
        return new RestResponse(this.iItemSkuDgService.queryBySkuId(skuIds));
    }

    public RestResponse<List<BundleItemDgRespDto>> queryBundleItem(Long itemId) {
        return new RestResponse(this.itemDgService.queryBundleItem(itemId));
    }

    public RestResponse<List<BundleItemDgRespDto>> queryBundleItemList(BundleItemDgReqDto bundleItemDgReqDto) {
        return new RestResponse(this.itemDgService.queryBundleItem(bundleItemDgReqDto));
    }

    public RestResponse<List<PropNameDgRespDto>> queryItemBasePropList(Long itemId) {
        return new RestResponse(this.propDgService.queryPropNameListByItemId(itemId));
    }

    public RestResponse<ItemDgRespDto> queryByItemCode(String itemCode) {
        return new RestResponse((Object)this.itemDgService.queryByItemCode(itemCode));
    }

    public RestResponse<List<ItemAttributesDgRespDto>> queryItemAttrByItemIdList(List<Long> itemIdList) {
        return new RestResponse(this.itemAttributesDgService.queryItemAttrByItemIdList(itemIdList));
    }

    public RestResponse<List<ItemDgRespDto>> queryByItemLongCodes(List<String> itemCodes) {
        return new RestResponse(this.itemDgService.queryByItemLongCodes(itemCodes));
    }

    public RestResponse<List<ItemMediasDgRespDto>> queryItemMediasByItemIds(List<Long> itemIds) {
        return new RestResponse(this.iItemMediasDgService.getMainPicByItemIds(itemIds));
    }

    public RestResponse<List<ItemSkuRelDgRespDto>> queryItemSkuRelByCodes(List<String> itemCodes) {
        return new RestResponse(this.itemDgService.queryItemSkuRelByCodes(itemCodes));
    }

    public RestResponse<List<ItemSkuRelDgRespDto>> queryItemSkuByItemCodes(List<String> itemCodes) {
        return new RestResponse(this.itemDgService.queryItemSkuByItemCodes(itemCodes));
    }

    public RestResponse<List<ItemSkuRelDgRespDto>> queryItemSkuBySkuCodes(List<String> skuCodes) {
        return new RestResponse(this.itemDgService.queryItemSkuBySkuCodes(skuCodes));
    }

    public RestResponse<List<ItemDetailDgRespDto>> listItemDetail(ItemDetailDgReqDto itemDetailDgReqDto) {
        return new RestResponse(this.itemDgService.listItemDetail(itemDetailDgReqDto));
    }

    public RestResponse<PageInfo<ItemSkuDgRespDto>> querySkuPage(DgItemSkuPlanQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        PageInfo<ItemSkuDgRespDto> skuPage = this.itemDgService.querySkuPage(reqDto, pageNum, pageSize);
        return new RestResponse(skuPage);
    }

    public RestResponse<List<ItemSkuDgRespDto>> querySkuList(DgItemSkuPlanQueryReqDto reqDto) {
        List<ItemSkuDgRespDto> skuList = this.itemDgService.querySkuList(reqDto);
        return new RestResponse(skuList);
    }

    public RestResponse<ItemExchangeUnitDgRespDto> exchangeUnit(ItemExchangeUnitDgReqDto reqDto) {
        ItemExchangeUnitDgRespDto respDto = this.itemExchangeDgService.exchangeUnit(reqDto);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<List<ItemExchangeUnitDgRespDto>> batchExchangeUnit(List<ItemExchangeUnitDgReqDto> reqDtos) {
        List<ItemExchangeUnitDgRespDto> respDtos = this.itemExchangeDgService.batchExchangeUnit(reqDtos);
        return new RestResponse(respDtos);
    }

    public RestResponse<List<ItemRoundDgRespDto>> batchRound(List<ItemExchangeUnitDgReqDto> reqDtos) {
        List<ItemRoundDgRespDto> respDtos = this.itemExchangeDgService.batchRound(reqDtos);
        return new RestResponse(respDtos);
    }

    public RestResponse<ItemDetailInfoDgRespDto> queryItemLibDetailById(Long itemId) {
        return new RestResponse((Object)this.itemDgService.queryItemLibDetailById(itemId));
    }

    public RestResponse<PageInfo<ItemDgPageRespDto>> queryItemLibByPage(ItemLibPageDgReqDto pageDto) {
        List<String> strings;
        if (Objects.nonNull(pageDto) && Objects.nonNull(pageDto.getCode()) && (strings = StringSplitDgUtil.splitString(pageDto.getCode())).size() > 1) {
            pageDto.setCodeList(strings);
            pageDto.setCode(null);
        }
        this.addDefaultItemLibOrganization(pageDto);
        return new RestResponse(this.itemDgService.queryItemLibByPage(pageDto));
    }

    public RestResponse<ItemDetailInfoDgRespDto> queryShopItemDetailById(Long id) {
        return new RestResponse((Object)this.itemDgService.queryShopItemDetailById(id));
    }

    public RestResponse<PageInfo<ShopItemDgPageRespDto>> queryShopItemByPage(ShopItemPageDgReqDto pageDto) {
        List<String> strings;
        if (Objects.nonNull(pageDto) && Objects.nonNull(pageDto.getCode()) && (strings = StringSplitDgUtil.splitString(pageDto.getCode())).size() > 1) {
            pageDto.setCodeList(strings);
            pageDto.setCode(null);
        }
        return new RestResponse(this.itemDgService.queryShopItemByPage(pageDto));
    }

    public RestResponse<List<ItemDgRespDto>> queryItemListByItemCodes(List<String> itemCodes) {
        return new RestResponse(this.itemDgService.queryItemListByItemCodes(itemCodes));
    }

    public RestResponse<List<ShopItemDgDto>> listShopItemByIds(List<Long> ids) {
        return new RestResponse(this.itemDgService.listShopItemByIds(ids));
    }

    public RestResponse<List<ItemAllSuperiorRespDto>> allSuperiorNodesByItemIds(List<String> itemCodes) {
        return new RestResponse(this.itemDgService.allSuperiorNodesByItemIds(itemCodes));
    }

    public RestResponse<ItemDetailInfoDgRespDto> queryShopItemDetailByShopIdAndItemId(Long shopId, Long itemId) {
        return new RestResponse((Object)this.itemDgService.queryShopItemDetailByShopIdAndItemId(shopId, itemId));
    }

    private void addDefaultOrganization(ItemPageDgReqDto pageDto) {
        if (Objects.nonNull(pageDto)) {
            if (CollectionUtil.isNotEmpty((Collection)pageDto.getOrganizationIdList())) {
                pageDto.getOrganizationIdList().add(OrganizationConstants.ITEM_ORGANIZATION_ID);
            }
            if (CollectionUtil.isNotEmpty((Collection)pageDto.getOrganizationCodeList())) {
                pageDto.getOrganizationCodeList().add("000001");
            }
        }
    }

    private void addDefaultItemLibOrganization(ItemLibPageDgReqDto pageDto) {
        if (Objects.nonNull(pageDto)) {
            if (CollectionUtil.isNotEmpty((Collection)pageDto.getOrganizationIdList())) {
                pageDto.getOrganizationIdList().add(OrganizationConstants.ITEM_ORGANIZATION_ID);
            }
            if (CollectionUtil.isNotEmpty((Collection)pageDto.getOrganizationCodeList())) {
                pageDto.getOrganizationCodeList().add("000001");
            }
        }
    }

    class Trie {
        private Trie[] chirldern = new Trie[26];
        public boolean isEnd;

        public void insert(String word) {
            int n = word.length();
            Trie node = this;
            for (int i = 0; i < n; ++i) {
                if (node.chirldern[word.charAt(i) - 97] == null) {
                    node.chirldern[word.charAt((int)i) - 97] = new Trie();
                }
                node = node.chirldern[word.charAt(i) - 97];
            }
            node.isEnd = true;
        }

        public boolean match(String word) {
            int n = word.length();
            Trie node = this;
            for (int i = 0; i < n; ++i) {
                if (node.chirldern[word.charAt(i) - 97] == null) {
                    String w = word.substring(i + 1);
                    for (int l = 0; l < 26; ++l) {
                        Trie trie = node.chirldern[l];
                        if (trie == null || !trie.search(w)) continue;
                        return true;
                    }
                    return false;
                }
                node = node.chirldern[word.charAt(i) - 97];
                if (!node.isEnd) continue;
                return false;
            }
            return false;
        }

        public boolean search(String word) {
            int n = word.length();
            Trie node = this;
            for (int i = 0; i < n; ++i) {
                if (node.chirldern[word.charAt(i) - 97] == null) {
                    return false;
                }
                node = node.chirldern[word.charAt(i) - 97];
                if (!node.isEnd) continue;
                return false;
            }
            return true;
        }
    }
}

