/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.eo.ItemBundleRelationDgEo;
import com.yunxi.dg.base.center.item.service.entity.IBundleItemDgService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bundleItemDgService")
public class BundleItemDgServiceImpl
implements IBundleItemDgService {
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int addBundleItemBatch(List<ItemBundleRelationDgEo> bundleItemEos) {
        return this.itemBundleRelationDgDomain.insertBatch(bundleItemEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBundleItem(ItemBundleRelationDgEo bundleItemEo) {
        this.itemBundleRelationDgDomain.insert((BaseEo)bundleItemEo);
        return bundleItemEo.getId();
    }

    @Override
    public void removeById(Long id) {
        this.itemBundleRelationDgDomain.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByItemId(Long itemId) {
        ItemBundleRelationDgEo bundleItemEo = new ItemBundleRelationDgEo();
        bundleItemEo.setItemId(itemId);
        this.itemBundleRelationDgDomain.logicDelete((BaseEo)bundleItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(List<ItemBundleRelationDgEo> bundleItemEos) {
        bundleItemEos.forEach(eo -> this.itemBundleRelationDgDomain.deleteById(eo.getId()));
    }

    @Override
    public void modifyBundleItem(ItemBundleRelationDgEo bundleItemEo) {
        this.itemBundleRelationDgDomain.updateSelective((BaseEo)bundleItemEo);
    }

    @Override
    public ItemBundleRelationDgEo queryById(Long id) {
        return (ItemBundleRelationDgEo)this.itemBundleRelationDgDomain.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<ItemBundleRelationDgEo> queryByPage(ItemBundleRelationDgEo bundleItemEo, Integer pageNum, Integer pageSize) {
        return this.itemBundleRelationDgDomain.selectPage((BaseEo)bundleItemEo, pageNum, pageSize);
    }

    @Override
    public List<ItemBundleRelationDgEo> queryByList(ItemBundleRelationDgEo bundleItemEo) {
        return this.itemBundleRelationDgDomain.selectList((BaseEo)bundleItemEo);
    }
}

