/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.domain.entity.IUnitDgDomain;
import com.yunxi.dg.base.center.item.dto.sync.DgSyncUnitDto;
import com.yunxi.dg.base.center.item.eo.UnitDgEo;
import com.yunxi.dg.base.center.item.service.entity.impl.adapter.AbstractDgSyncUnitServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dgIDgSyncUnitService")
public class DgSyncUnitServiceImpl
extends AbstractDgSyncUnitServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(DgSyncUnitServiceImpl.class);
    @Resource
    private IUnitDgDomain unitDgDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncUnit(DgSyncUnitDto syncUnitDto) {
        super.syncUnit(syncUnitDto);
        List unitDgEos = this.unitDgDomain.queryByUnitDgEos((List)Lists.newArrayList((Object[])new String[]{syncUnitDto.getCode()}));
        if (CollectionUtil.isNotEmpty((Collection)unitDgEos)) {
            UnitDgEo unitDgEo = (UnitDgEo)unitDgEos.get(0);
            BeanUtil.copyProperties((Object)syncUnitDto, (Object)unitDgEo, (String[])new String[]{"id"});
            this.unitDgDomain.update((BaseEo)unitDgEo);
        } else {
            UnitDgEo unitDgEo = new UnitDgEo();
            BeanUtil.copyProperties((Object)syncUnitDto, (Object)unitDgEo, (String[])new String[0]);
            this.unitDgDomain.insert((BaseEo)unitDgEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncUnitBatch(List<DgSyncUnitDto> syncUnitDtoList) {
        super.syncUnitBatch(syncUnitDtoList);
        List codeList = syncUnitDtoList.stream().map(DgSyncUnitDto::getCode).collect(Collectors.toList());
        List unitDgEoList = this.unitDgDomain.queryByUnitDgEos(codeList);
        Map syncUnitDtoMap = unitDgEoList.stream().collect(Collectors.toMap(UnitDgEo::getCode, Function.identity(), (oldValue, newValue) -> newValue));
        ArrayList notExistList = Lists.newArrayList();
        ArrayList existList = Lists.newArrayList();
        syncUnitDtoList.forEach(syncUnitDto -> {
            if (!syncUnitDtoMap.containsKey(syncUnitDto.getCode())) {
                notExistList.add(syncUnitDto);
            } else {
                existList.add(syncUnitDto);
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)notExistList)) {
            List unitDgEos = BeanUtil.copyToList((Collection)notExistList, UnitDgEo.class);
            this.unitDgDomain.insertBatch(unitDgEos);
        }
        if (CollectionUtil.isNotEmpty((Collection)existList)) {
            for (DgSyncUnitDto dgSyncUnitDto : existList) {
                UnitDgEo unitDgEo = (UnitDgEo)syncUnitDtoMap.get(dgSyncUnitDto.getCode());
                BeanUtil.copyProperties((Object)dgSyncUnitDto, (Object)unitDgEo, (String[])new String[]{"id"});
                this.unitDgDomain.updateSelective((BaseEo)unitDgEo);
            }
        }
    }
}

