/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.common.constant.ItemDgConstant;
import com.yunxi.dg.base.center.item.constants.DirSortDgEnum;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirIndexDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirItemRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirPropRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IFrontShopRelationBackDgDomain;
import com.yunxi.dg.base.center.item.dto.request.DirTreeDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectoryDgFilterReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectoryQueryParentReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectorySortUpdateDgDto;
import com.yunxi.dg.base.center.item.dto.request.RootDirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DirIndexDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirParentRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemDgRespDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.DirIndexDgEo;
import com.yunxi.dg.base.center.item.eo.DirItemRelationDgEo;
import com.yunxi.dg.base.center.item.eo.DirRelationDgEo;
import com.yunxi.dg.base.center.item.eo.FrontShopRelationBackDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.plugin.EnableCachePlugin;
import com.yunxi.dg.base.center.item.service.entity.IDirPropRelationDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemDgService;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="directoryItemDgService")
public class DirectoryItemDgServiceImpl
implements IDirectoryItemDgService {
    private Logger logger = LoggerFactory.getLogger(DirectoryItemDgServiceImpl.class);
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IDirIndexDgDomain dirIndexDgDomain;
    @Resource
    private IDirItemRelationDgDomain dirItemRelationDgDomain;
    @Resource
    private IDirRelationDgDomain dirRelationDgDomain;
    @Resource
    private IDirPropRelationDgDomain dirPropRelationDgDomain;
    @Autowired
    private IDirectoryDgService directoryDgService;
    @Resource
    private IFrontShopRelationBackDgDomain frontShopRelationBackDgDomian;
    @Resource
    private IDirPropRelationDgService dirPropRelationDgService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveDirectoryItem(DirDgEo dir, List<Long> links) {
        if (!ItemDgConstant.ROOT_NODE.equals(dir.getParentId()) && dir.getParentId() != null) {
            DirDgEo parent = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dir.getParentId());
            if (null == parent) {
                throw new BizException("\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff0c \u4e0d\u5141\u8bb8\u65b0\u589e");
            }
            dir.setParentName(parent.getName());
            DirDgEo select = new DirDgEo();
            select.setCode(dir.getCode());
            List counts = this.dirDgDomain.selectList((BaseEo)select);
            if (CollectionUtil.isNotEmpty((Collection)counts)) {
                throw new BizException("\u7c7b\u76ee\u7f16\u7801\u5df2\u5b58\u5728");
            }
            Long rootId = parent.getRootId() == 0L ? dir.getParentId() : parent.getRootId();
            this.checkLevel(rootId, parent.getId());
            this.checkDirName(dir, parent.getId());
            dir.setRootId(rootId);
            dir.setLv(parent.getRv());
            dir.setRv(Integer.valueOf(parent.getRv() + 1));
            this.dirDgDomain.updateForInsert(dir);
        } else {
            dir.setLv(Integer.valueOf(1));
            dir.setRv(Integer.valueOf(2));
        }
        DirDgEo directoryItemEo = new DirDgEo();
        directoryItemEo.setParentId(dir.getParentId());
        directoryItemEo.setInstanceId(dir.getInstanceId());
        directoryItemEo.setTenantId(dir.getTenantId());
        directoryItemEo.setDr(0);
        dir.setSort(Integer.valueOf(this.dirDgDomain.count((BaseEo)directoryItemEo)));
        String frontRelationBack = dir.getFrontRelationBack();
        this.dirDgDomain.insert((BaseEo)dir);
        String indexPath = this.getIndexPath(dir);
        if (Objects.nonNull(indexPath)) {
            dir.setIndexPath(indexPath);
            this.dirDgDomain.updateSelective((BaseEo)dir);
        }
        this.insertFrontShopRelationBackDEo(dir, frontRelationBack);
        if (ItemDgConstant.ROOT_NODE.equals(dir.getParentId()) || null == dir.getParentId()) {
            dir.setRootId(dir.getId());
            this.dirDgDomain.updateSelective((BaseEo)dir);
        }
        if (CollectionUtils.isNotEmpty(links)) {
            for (Long linkDirId : links) {
                if (linkDirId == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
                }
                DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(linkDirId);
                if (dirDgEo == null || !dir.getTenantId().equals(dirDgEo.getTenantId())) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
                }
                DirRelationDgEo dirRelationDgEo = new DirRelationDgEo();
                dirRelationDgEo.setDirId(dir.getId());
                dirRelationDgEo.setLinkDirId(linkDirId);
                dirRelationDgEo.setInstanceId(dir.getInstanceId());
                dirRelationDgEo.setTenantId(dir.getTenantId());
                this.dirRelationDgDomain.insert((BaseEo)dirRelationDgEo);
            }
        }
        return dir.getId();
    }

    private String getIndexPath(DirDgEo dir) {
        if (Objects.isNull(dir) || Objects.isNull(dir.getId())) {
            return null;
        }
        if (Objects.isNull(dir.getParentId()) || dir.getParentId() == 0L) {
            return String.valueOf(dir.getId());
        }
        DirDgEo currentParent = (DirDgEo)this.dirDgDomain.selectById((Serializable)dir.getParentId());
        if (Objects.isNull(currentParent)) {
            return String.valueOf(dir.getId());
        }
        if (StrUtil.isBlank((CharSequence)currentParent.getIndexPath())) {
            return dir.getId().toString();
        }
        if (currentParent.getIndexPath().indexOf("null") >= 0) {
            return currentParent.getIndexPath().replace("null,", "") + "," + dir.getId();
        }
        return currentParent.getIndexPath() + "," + dir.getId();
    }

    private int getDirLevel(DirDgEo parent) {
        int level = 0;
        DirDgEo currentParent = parent;
        while (currentParent != null && currentParent.getParentId() != 0L) {
            ++level;
            currentParent = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(currentParent.getParentId());
        }
        return level;
    }

    private void checkDirName(DirDgEo dir, Long parentId) {
        List dirEos = ((ExtQueryChainWrapper)this.dirDgDomain.filter().eq((Object)"parent_id", (Object)parentId)).list();
        for (DirDgEo dirEo : dirEos) {
            if (!Objects.equals(dirEo.getName(), dir.getName()) || Objects.equals(dirEo.getId(), dir.getId())) continue;
            throw new BizException("\u540c\u7ea7\u7c7b\u76ee\u4e0b\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
        }
    }

    private void checkLevel(Long rootId, Long parentId) {
        List<List<DirectoryItemDgRespDto>> lists = this.queryDirLevels(Lists.newArrayList((Object[])new Long[]{parentId}));
        int level = lists.get(0).size() - 1;
        DirIndexDgEo indexDgEo = (DirIndexDgEo)((ExtQueryChainWrapper)this.dirIndexDgDomain.filter().eq((Object)"root_id", (Object)rootId)).one();
        if (Objects.equals("front", indexDgEo.getDirUsage())) {
            if (level >= 4) {
                throw new BizException("\u524d\u53f0\u7c7b\u76ee\u6700\u591a\u6dfb\u52a0\u56db\u7ea7");
            }
        } else if (level >= 4) {
            throw new BizException("\u540e\u53f0\u7c7b\u76ee\u6700\u591a\u6dfb\u52a0\u56db\u7ea7");
        }
    }

    @Override
    public Long saveDirectoryItemList(DirDgEo dir, List<DirDgEo> list) {
        if (!ItemDgConstant.ROOT_NODE.equals(dir.getParentId()) && dir.getParentId() != null) {
            DirDgEo parent = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dir.getParentId());
            if (null == parent) {
                throw new BizException("\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff0c \u4e0d\u5141\u8bb8\u65b0\u589e");
            }
            if (parent.getRootId() == 0L) {
                dir.setRootId(dir.getParentId());
            } else {
                dir.setRootId(parent.getRootId());
            }
            dir.setLv(parent.getRv());
            dir.setRv(Integer.valueOf(parent.getRv() + 1));
            this.dirDgDomain.updateForInsert(dir);
        } else {
            dir.setLv(Integer.valueOf(1));
            dir.setRv(Integer.valueOf(2));
        }
        DirDgEo directoryItemEo = new DirDgEo();
        directoryItemEo.setParentId(dir.getParentId());
        directoryItemEo.setInstanceId(dir.getInstanceId());
        directoryItemEo.setTenantId(dir.getTenantId());
        directoryItemEo.setDr(0);
        dir.setSort(Integer.valueOf(this.dirDgDomain.count((BaseEo)directoryItemEo)));
        String frontRelationBack = dir.getFrontRelationBack();
        this.dirDgDomain.insert((BaseEo)dir);
        this.insertFrontShopRelationBackDEo(dir, frontRelationBack);
        if (ItemDgConstant.ROOT_NODE.equals(dir.getParentId()) || null == dir.getParentId()) {
            dir.setRootId(dir.getId());
            this.dirDgDomain.updateSelective((BaseEo)dir);
        }
        if (CollectionUtils.isEmpty(list)) {
            return dir.getId();
        }
        for (DirDgEo dirDgEo : list) {
            DirRelationDgEo dirRelationDgEo = new DirRelationDgEo();
            dirRelationDgEo.setDirId(dir.getId());
            dirRelationDgEo.setLinkDirId(dirDgEo.getId());
            dirRelationDgEo.setInstanceId(dir.getInstanceId());
            dirRelationDgEo.setTenantId(dir.getTenantId());
            this.dirRelationDgDomain.insert((BaseEo)dirRelationDgEo);
        }
        return dir.getId();
    }

    private void insertFrontShopRelationBackDEo(DirDgEo dir, String frontRelationBack) {
        ArrayList<FrontShopRelationBackDgEo> frontShopRelationBackDgEos = new ArrayList<FrontShopRelationBackDgEo>();
        try {
            if (StringUtils.isNotEmpty((CharSequence)frontRelationBack)) {
                String[] split = frontRelationBack.split(",");
                ArrayList<String> frontIdList = new ArrayList<String>();
                for (int i = 0; i < split.length; ++i) {
                    if (frontIdList.contains(split[i])) continue;
                    frontIdList.add(split[i]);
                }
                if (CollectionUtils.isNotEmpty(frontIdList)) {
                    for (String frontId : frontIdList) {
                        FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
                        frontShopRelationBackDgEo.setBackId(Long.valueOf(frontId));
                        frontShopRelationBackDgEo.setFrontShopId(dir.getId());
                        frontShopRelationBackDgEos.add(frontShopRelationBackDgEo);
                        this.logger.info("\u6253\u5370\u63d2\u5165it_dir:{}", (Object)JSON.toJSONString(frontShopRelationBackDgEos));
                    }
                }
                if (CollectionUtils.isNotEmpty(frontShopRelationBackDgEos)) {
                    this.frontShopRelationBackDgDomian.insertBatch(frontShopRelationBackDgEos);
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u63d2\u5165it_dir\u8868\u5931\u8d25:{}", (Throwable)e);
            throw new BizException("\u63d2\u5165it_dir\u8868\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteDirectoryItem(Long id) {
        if (id == null) {
            throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        DirDgEo example = DirDgEo.newInstance();
        example.setParentId(id);
        List dirDgEos = this.dirDgDomain.selectList((BaseEo)example);
        if (CollectionUtil.isNotEmpty((Collection)dirDgEos)) {
            throw new BizException(ItemExceptionCode.EXIST_DIR_CHILD.getMsg());
        }
        DirDgEo dir = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(id);
        if (dir == null) {
            return;
        }
        this.dirDgDomain.logicDeleteById(id);
        FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
        frontShopRelationBackDgEo.setFrontShopId(id);
        DirIndexDgEo dirIndexDgEo = new DirIndexDgEo();
        dirIndexDgEo.setRootId(id);
        List dirIndexDgEoList = this.dirIndexDgDomain.selectList((BaseEo)dirIndexDgEo);
        if (CollectionUtils.isNotEmpty((Collection)dirIndexDgEoList)) {
            frontShopRelationBackDgEo.setShopId(((DirIndexDgEo)dirIndexDgEoList.get(0)).getShopId());
        }
        this.frontShopRelationBackDgDomian.logicDelete((BaseEo)frontShopRelationBackDgEo);
        FrontShopRelationBackDgEo frontShopRelationBackDgEo1 = new FrontShopRelationBackDgEo();
        frontShopRelationBackDgEo1.setBackId(id);
        this.frontShopRelationBackDgDomian.logicDelete((BaseEo)frontShopRelationBackDgEo1);
        if (!ItemDgConstant.ROOT_NODE.equals(dir.getParentId())) {
            this.dirDgDomain.updateForDelete(dir);
        }
        ArrayList<Long> dirIds = new ArrayList<Long>();
        dirIds.add(id);
        this.dirPropRelationDgService.deleteDirPropRelation(dirIds);
    }

    @Override
    public List<DirDgEo> queryDirectoryItem(DirDgEo dirExample) {
        if (dirExample == null) {
            throw new BizException(ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        return this.dirDgDomain.selectList((BaseEo)dirExample, Integer.valueOf(1), Integer.valueOf(10000));
    }

    @Override
    public PageInfo<DirDgEo> queryDirectoryByPage(DirDgEo directoryItemEo, Integer pageNum, Integer pageSize) {
        if (directoryItemEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        return this.dirDgDomain.selectPage((BaseEo)directoryItemEo, pageNum, pageSize);
    }

    @Override
    public List<DirDgEo> queryByIds(List<Long> ids) {
        DirDgEo dirExample = DirDgEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        dirExample.setSqlFilters(sqlFilters);
        return this.queryDirectoryItem(dirExample);
    }

    @Override
    public List<DirDgEo> queryByParentIds(List<Long> parentId) {
        if (CollectionUtils.isEmpty(parentId)) {
            return null;
        }
        DirDgEo dirExample = DirDgEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"parent_id", (Object)StringUtils.join(parentId, (String)",")));
        dirExample.setSqlFilters(sqlFilters);
        return this.queryDirectoryItem(dirExample);
    }

    @Override
    public List<DirDgEo> queryByName(List<String> nameList, String dirUsage) {
        if (CollectionUtils.isEmpty(nameList)) {
            return null;
        }
        List names = nameList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        DirIndexDgEo dirIndexDgEo = new DirIndexDgEo();
        dirIndexDgEo.setDirUsage(dirUsage);
        List<DirIndexDgEo> dirIndexDgEos = this.queryDirectory(dirIndexDgEo);
        List rootIds = dirIndexDgEos.stream().map(DirIndexDgEo::getRootId).collect(Collectors.toList());
        DirDgEo dirExample = DirDgEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"root_id", (Object)StringUtils.join(rootIds, (String)",")));
        sqlFilters.add(SqlFilter.in((String)"name", (Object)StringUtils.join(names, (String)",")));
        dirExample.setSqlFilters(sqlFilters);
        return this.queryDirectoryItem(dirExample);
    }

    @Override
    public List<DirDgEo> queryByCodes(List<String> codeList, String dirUsage) {
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        List codes = codeList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        DirIndexDgEo dirIndexDgEo = new DirIndexDgEo();
        dirIndexDgEo.setDirUsage(dirUsage);
        List<DirIndexDgEo> dirIndexDgEos = this.queryDirectory(dirIndexDgEo);
        List rootIds = dirIndexDgEos.stream().map(DirIndexDgEo::getRootId).collect(Collectors.toList());
        DirDgEo dirExample = DirDgEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"root_id", (Object)StringUtils.join(rootIds, (String)",")));
        sqlFilters.add(SqlFilter.in((String)"code", codes));
        dirExample.setSqlFilters(sqlFilters);
        return this.queryDirectoryItem(dirExample);
    }

    @Override
    public List<DirectoryItemDgRespDto> queryShopDirList(Long itemId, Long shopId, Integer busType, String dirType) {
        ArrayList directoryItemDgRespDtos = Lists.newArrayList();
        DirItemRelationDgEo dirsItemsEo = DirItemRelationDgEo.newInstance();
        dirsItemsEo.setItemId(itemId);
        dirsItemsEo.setShopId(shopId);
        if (busType != null) {
            dirsItemsEo.setBusType(busType);
        }
        if (StringUtils.isNotEmpty((CharSequence)dirType)) {
            dirsItemsEo.setDirType(dirType);
        }
        dirsItemsEo.setOrderByDesc("id");
        List dataList = this.dirItemRelationDgDomain.selectList((BaseEo)dirsItemsEo);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            dataList.forEach(dirItemRelationEo -> {
                DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dirItemRelationEo.getDirId());
                DirectoryItemDgRespDto directoryItemDgRespDto = new DirectoryItemDgRespDto();
                DtoHelper.eo2Dto((BaseEo)dirDgEo, (BaseVo)directoryItemDgRespDto);
                directoryItemDgRespDtos.add(directoryItemDgRespDto);
            });
        }
        return directoryItemDgRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDirectoryItem(DirDgEo dir, List<Long> linkDirIdList) {
        if (dir == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dir.getId());
        if (dirDgEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
        }
        this.checkDirName(dir, dirDgEo.getParentId());
        String indexPath = this.getIndexPath(dirDgEo);
        dir.setIndexPath(indexPath);
        this.dirDgDomain.updateSelective((BaseEo)dir);
        if (dir.getLink() == null && dirDgEo.getLink() != null) {
            dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dir.getId());
            dirDgEo.setLink(null);
            this.dirDgDomain.update((BaseEo)dirDgEo);
        }
        FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
        frontShopRelationBackDgEo.setFrontShopId(dir.getId());
        frontShopRelationBackDgEo.setShopId(dir.getShopId());
        this.frontShopRelationBackDgDomian.delete((BaseEo)frontShopRelationBackDgEo);
        String frontRelationBack1 = dir.getFrontRelationBack();
        if (StringUtils.isNotEmpty((CharSequence)frontRelationBack1)) {
            String[] split = frontRelationBack1.split(",");
            ArrayList<FrontShopRelationBackDgEo> frontShopRelationBackDgEos = new ArrayList<FrontShopRelationBackDgEo>();
            ArrayList<String> frontIdList = new ArrayList<String>();
            for (int i = 0; i < split.length; ++i) {
                if (frontIdList.contains(split[i])) continue;
                frontIdList.add(split[i]);
            }
            if (CollectionUtils.isNotEmpty(frontIdList)) {
                for (String frontId : frontIdList) {
                    FrontShopRelationBackDgEo frontShopRelationBackDgEo1 = new FrontShopRelationBackDgEo();
                    frontShopRelationBackDgEo1.setFrontShopId(dir.getId());
                    frontShopRelationBackDgEo1.setShopId(dir.getShopId());
                    frontShopRelationBackDgEo1.setBackId(Long.valueOf(frontId));
                    frontShopRelationBackDgEos.add(frontShopRelationBackDgEo1);
                }
            }
            if (CollectionUtils.isNotEmpty(frontShopRelationBackDgEos)) {
                this.frontShopRelationBackDgDomian.insertBatch(frontShopRelationBackDgEos);
            }
        }
        DirRelationDgEo dirRelationDgEo = new DirRelationDgEo();
        dirRelationDgEo.setDirId(dirDgEo.getId());
        dirRelationDgEo.setInstanceId(dirDgEo.getInstanceId());
        dirRelationDgEo.setTenantId(dirDgEo.getTenantId());
        this.dirRelationDgDomain.delete((BaseEo)dirRelationDgEo);
        if (CollectionUtils.isEmpty(linkDirIdList)) {
            return;
        }
        for (Long linkDirId : linkDirIdList) {
            DirDgEo checkDirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(linkDirId);
            if (checkDirDgEo == null || !checkDirDgEo.getTenantId().equals(dirDgEo.getTenantId())) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            dirRelationDgEo = new DirRelationDgEo();
            dirRelationDgEo.setDirId(dirDgEo.getId());
            dirRelationDgEo.setLinkDirId(linkDirId);
            dirRelationDgEo.setInstanceId(dirDgEo.getInstanceId());
            dirRelationDgEo.setTenantId(dirDgEo.getTenantId());
            this.dirRelationDgDomain.insert((BaseEo)dirRelationDgEo);
        }
    }

    @Override
    public List<TreeDto<DirectoryItemDgRespDto>> queryDirByRootIds(List<Long> rootIds, Integer status) {
        ArrayList<TreeDto<DirectoryItemDgRespDto>> trees = new ArrayList<TreeDto<DirectoryItemDgRespDto>>();
        if (CollectionUtils.isEmpty(rootIds)) {
            return null;
        }
        DirDgEo dirDgEo = new DirDgEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(rootIds, (String)",")));
        dirDgEo.setSqlFilters(sqlFilterList);
        dirDgEo.setOrderBy("sort");
        dirDgEo.setStatus(status);
        List dirDgEoList = this.dirDgDomain.selectList((BaseEo)dirDgEo);
        for (DirDgEo eo : dirDgEoList) {
            List<DirDgEo> dirList = this.queryDirByRootId(eo.getId(), status);
            if (!CollectionUtils.isNotEmpty(dirList)) continue;
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList(dirList, dtoList, DirectoryItemDgRespDto.class);
            List tree = TreeDto.createTreeDto(dtoList);
            trees.addAll(tree);
        }
        return trees;
    }

    @Override
    public List<TreeDto<DirectoryItemDgRespDto>> getDirById(Long id, String dirUsage, Integer status, Long shopId) {
        ArrayList<TreeDto<DirectoryItemDgRespDto>> trees = new ArrayList<TreeDto<DirectoryItemDgRespDto>>();
        if (id == null) {
            return null;
        }
        FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
        frontShopRelationBackDgEo.setBackId(id);
        frontShopRelationBackDgEo.setShopId(shopId);
        List select = this.frontShopRelationBackDgDomian.selectList((BaseEo)frontShopRelationBackDgEo);
        List frontOrShopIds = select.stream().map(e -> e.getFrontShopId()).collect(Collectors.toList());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", frontOrShopIds));
        DirDgEo dirDgEo = new DirDgEo();
        dirDgEo.setOrderBy("sort");
        dirDgEo.setStatus(status);
        dirDgEo.setSqlFilters(sqlFilters);
        List dirDgEoList = this.dirDgDomain.selectList((BaseEo)dirDgEo);
        for (DirDgEo eo : dirDgEoList) {
            List<DirDgEo> dirList = this.queryDirByRootId(eo.getId(), status);
            if (!CollectionUtils.isNotEmpty(dirList)) continue;
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList(dirList, dtoList, DirectoryItemDgRespDto.class);
            List tree = TreeDto.createTreeDto(dtoList);
            trees.addAll(tree);
        }
        return trees;
    }

    @Override
    public List<Long> queryListDirById(Long id, String dirUsage) {
        FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
        frontShopRelationBackDgEo.setBackId(id);
        List select = this.frontShopRelationBackDgDomian.selectList((BaseEo)frontShopRelationBackDgEo);
        if (CollectionUtils.isEmpty((Collection)select)) {
            return null;
        }
        if (StringUtils.equals((CharSequence)"shop", (CharSequence)dirUsage)) {
            List<Long> shopIds = select.stream().map(e -> e.getShopId()).collect(Collectors.toList());
            return shopIds;
        }
        if (StringUtils.equals((CharSequence)"front", (CharSequence)dirUsage)) {
            List<Long> frontOrShopIds = select.stream().map(e -> e.getFrontShopId()).collect(Collectors.toList());
            return frontOrShopIds;
        }
        return null;
    }

    @Override
    public void initTree() {
        DirDgEo example = DirDgEo.newInstance();
        example.setOrderBy("sort");
        List roots = this.dirDgDomain.selectList((BaseEo)example);
        List trees = TreeDto.createTreeDto((List)roots);
        for (TreeDto treeDto : trees) {
            this.updateLvRv((TreeDto<DirDgEo>)treeDto, 0);
        }
    }

    private int updateLvRv(TreeDto<DirDgEo> tree, int index) {
        Stack<TreeDto> stack = new Stack<TreeDto>();
        DirDgEo updateEo = DirDgEo.newInstance();
        updateEo.setId(((DirDgEo)tree.getNode()).getId());
        updateEo.setLv(Integer.valueOf(index + 1));
        if (CollectionUtils.isNotEmpty((Collection)tree.getChildren())) {
            for (TreeDto treeDto : tree.getChildren()) {
                stack.push(treeDto);
            }
            int rv = index + 1;
            while (!stack.empty()) {
                tree = (TreeDto)stack.pop();
                if (null == tree) continue;
                if (CollectionUtils.isNotEmpty((Collection)tree.getChildren())) {
                    rv = this.updateLvRv((TreeDto<DirDgEo>)tree, rv) + 1;
                    continue;
                }
                rv = this.updateLvRv((TreeDto<DirDgEo>)tree, rv);
            }
            updateEo.setRv(Integer.valueOf(rv + 1));
            this.dirDgDomain.updateSelective((BaseEo)updateEo);
            return rv;
        }
        updateEo.setRv(Integer.valueOf(index + 2));
        this.dirDgDomain.updateSelective((BaseEo)updateEo);
        return index + 2;
    }

    private List<DirDgEo> queryDirByRootId(Long rootId, Integer status) {
        DirDgEo queryEo = new DirDgEo();
        queryEo.setId(rootId);
        DirDgEo dir = (DirDgEo)this.dirDgDomain.selectOne((BaseEo)queryEo);
        if (null == dir) {
            return null;
        }
        DirDgEo example = DirDgEo.newInstance();
        example.setRootId(dir.getRootId());
        example.setOrderBy("sort");
        example.setStatus(status);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.lt((String)"rv", (Object)dir.getRv()));
        sqlFilters.add(SqlFilter.gt((String)"lv", (Object)dir.getLv()));
        example.setSqlFilters(sqlFilters);
        List dirs = this.dirDgDomain.selectList((BaseEo)example, Integer.valueOf(0), Integer.valueOf(1000));
        dirs.add(dir);
        return dirs;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mergeDir(Long targetId, String sourceIds) {
        if (!NumberUtils.isDigits((String)sourceIds) || sourceIds.contains(String.valueOf(targetId))) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(targetId);
        if (dirDgEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
        }
        dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(Long.valueOf(sourceIds));
        if (dirDgEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
        }
        DirItemRelationDgEo example = DirItemRelationDgEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"dir_id", (Object)sourceIds));
        example.setSqlFilters(sqlFilters);
        List dirsItemsEos = this.dirItemRelationDgDomain.selectList((BaseEo)example);
        ArrayList<DirItemRelationDgEo> insertList = new ArrayList<DirItemRelationDgEo>();
        for (DirItemRelationDgEo dirsItemsEo : dirsItemsEos) {
            DirItemRelationDgEo itemsEo = DirItemRelationDgEo.newInstance();
            CubeBeanUtils.copyProperties((Object)itemsEo, (Object)dirsItemsEo, (String[])new String[0]);
            itemsEo.setDirId(targetId);
            insertList.add(itemsEo);
        }
        this.dirItemRelationDgDomain.insertBatch(insertList);
    }

    @Override
    @EnableCachePlugin
    public List<Long> convertLinkDir(List<Long> dirIds, Long instanceId, Long tenantId) {
        ArrayList<Long> realDirList = new ArrayList<Long>();
        for (Long id : dirIds) {
            DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(id);
            if (dirDgEo == null) continue;
            if (null != dirDgEo.getLink()) {
                realDirList.add(dirDgEo.getLink());
            } else {
                realDirList.add(id);
            }
            DirRelationDgEo dirRelationDgEo = new DirRelationDgEo();
            dirRelationDgEo.setDirId(id);
            List dirRelationDgEoList = this.dirRelationDgDomain.selectList((BaseEo)dirRelationDgEo);
            if (CollectionUtils.isEmpty((Collection)dirRelationDgEoList)) continue;
            for (DirRelationDgEo relationEo : dirRelationDgEoList) {
                realDirList.add(relationEo.getLinkDirId());
            }
        }
        return realDirList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sortDirectory(Long id, DirectorySortUpdateDgDto directorySortUpdateDgDto) {
        if (directorySortUpdateDgDto == null || DirSortDgEnum.getDescByType((String)directorySortUpdateDgDto.getSortType()) == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirDgEo directoryItemEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(id);
        if (directoryItemEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        DirDgEo sameParentItemEo = new DirDgEo();
        sameParentItemEo.setParentId(directoryItemEo.getParentId());
        sameParentItemEo.setOrderBy("sort");
        sameParentItemEo.setInstanceId(directoryItemEo.getInstanceId());
        sameParentItemEo.setTenantId(directoryItemEo.getTenantId());
        List directoryItemEoList = this.dirDgDomain.selectList((BaseEo)sameParentItemEo);
        if (CollectionUtils.isEmpty((Collection)directoryItemEoList) || directoryItemEoList.size() == 1) {
            return;
        }
        if (DirSortDgEnum.BOTTOM.getType().equals(directorySortUpdateDgDto.getSortType())) {
            directoryItemEoList.remove(directoryItemEo);
            directoryItemEoList.add(directoryItemEo);
        } else if (DirSortDgEnum.TOP.getType().equals(directorySortUpdateDgDto.getSortType())) {
            directoryItemEoList.remove(directoryItemEo);
            ArrayList<DirDgEo> newSortList = new ArrayList<DirDgEo>();
            newSortList.add(directoryItemEo);
            newSortList.addAll(directoryItemEoList);
            directoryItemEoList.clear();
            directoryItemEoList.addAll(newSortList);
        } else {
            int count = directoryItemEoList.size();
            for (int i = 0; i < count; ++i) {
                if (!((DirDgEo)directoryItemEoList.get(i)).equals((Object)directoryItemEo)) continue;
                Integer relatedIndex = null;
                if (DirSortDgEnum.INCR.getType().equals(directorySortUpdateDgDto.getSortType()) && i != 0) {
                    relatedIndex = i - 1;
                } else if (DirSortDgEnum.DECR.getType().equals(directorySortUpdateDgDto.getSortType()) && i != count - 1) {
                    relatedIndex = i + 1;
                }
                if (relatedIndex == null) break;
                directoryItemEoList.set(i, directoryItemEoList.get(relatedIndex));
                directoryItemEoList.set(relatedIndex, directoryItemEo);
                break;
            }
        }
        this.updateDirEoSort(directoryItemEoList);
    }

    @Override
    public void compatSortDirectory(Long id, DirectorySortUpdateDgDto directorySortUpdateDgDto) {
        Long targetDirId;
        Long l = targetDirId = Objects.isNull(directorySortUpdateDgDto.getTargetDirId()) ? id : directorySortUpdateDgDto.getTargetDirId();
        if (directorySortUpdateDgDto == null || DirSortDgEnum.getDescByType((String)directorySortUpdateDgDto.getSortType()) == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirDgEo directoryItemEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(id);
        if (directoryItemEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        DirDgEo sameParentItemEo = new DirDgEo();
        sameParentItemEo.setParentId(directoryItemEo.getParentId());
        sameParentItemEo.setOrderBy("sort");
        sameParentItemEo.setInstanceId(directoryItemEo.getInstanceId());
        sameParentItemEo.setTenantId(directoryItemEo.getTenantId());
        List directoryItemEoList = this.dirDgDomain.selectList((BaseEo)sameParentItemEo);
        if (CollectionUtils.isEmpty((Collection)directoryItemEoList) || directoryItemEoList.size() == 1) {
            return;
        }
        if (DirSortDgEnum.BOTTOM.getType().equals(directorySortUpdateDgDto.getSortType())) {
            directoryItemEoList.remove(directoryItemEo);
            directoryItemEoList.add(directoryItemEo);
        } else if (DirSortDgEnum.TOP.getType().equals(directorySortUpdateDgDto.getSortType())) {
            directoryItemEoList.remove(directoryItemEo);
            ArrayList<DirDgEo> newSortList = new ArrayList<DirDgEo>();
            newSortList.add(directoryItemEo);
            newSortList.addAll(directoryItemEoList);
            directoryItemEoList.clear();
            directoryItemEoList.addAll(newSortList);
        } else {
            if (directoryItemEo.getParentId() == 0L) {
                this.sortDirWithSpecParentId(id, directorySortUpdateDgDto, directoryItemEo);
                return;
            }
            int relatedIndex = 0;
            int count = directoryItemEoList.size() - 1;
            for (int i = 0; i < directoryItemEoList.size(); ++i) {
                if (!((DirDgEo)directoryItemEoList.get(i)).getId().equals(targetDirId)) continue;
                if (DirSortDgEnum.INCR.getType().equals(directorySortUpdateDgDto.getSortType())) {
                    relatedIndex = i > 0 ? i - 1 : 0;
                    break;
                }
                if (!DirSortDgEnum.DECR.getType().equals(directorySortUpdateDgDto.getSortType())) break;
                relatedIndex = i < count ? i + 1 : count;
                break;
            }
            directoryItemEoList.remove(directoryItemEo);
            directoryItemEoList.add(relatedIndex, directoryItemEo);
        }
        this.updateDirEoSort(directoryItemEoList);
    }

    public static void main(String[] args) {
        ArrayList<Integer> a = new ArrayList<Integer>();
        a.add(1);
        a.add(2);
        a.add(4, 3);
        for (Integer integer : a) {
            System.out.println(integer);
        }
    }

    @Override
    public List<Long> selectBackNameById(Long id) {
        FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
        frontShopRelationBackDgEo.setFrontShopId(id);
        List frontShopRelationBackDgEoList = this.frontShopRelationBackDgDomian.selectList((BaseEo)frontShopRelationBackDgEo);
        List<Long> backIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)frontShopRelationBackDgEoList)) {
            backIds = frontShopRelationBackDgEoList.stream().map(s -> s.getBackId()).distinct().collect(Collectors.toList());
        }
        return backIds;
    }

    @Override
    public List<Long> queryFontDirIdsByBackId(Long id, String dirUsage, Long shopId) {
        FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
        frontShopRelationBackDgEo.setBackId(id);
        frontShopRelationBackDgEo.setShopId(shopId);
        List select = this.frontShopRelationBackDgDomian.selectList((BaseEo)frontShopRelationBackDgEo);
        if (CollectionUtils.isEmpty((Collection)select)) {
            return null;
        }
        if (StringUtils.equals((CharSequence)"shop", (CharSequence)dirUsage) && shopId != null) {
            List<Long> shopDirIds = select.stream().map(e -> e.getFrontShopId()).collect(Collectors.toList());
            return shopDirIds;
        }
        if (StringUtils.equals((CharSequence)"front", (CharSequence)dirUsage)) {
            List<Long> frontOrShopIds = select.stream().filter(e -> e.getShopId() == null).map(e -> e.getFrontShopId()).collect(Collectors.toList());
            return frontOrShopIds;
        }
        return null;
    }

    private void sortDirWithSpecParentId(Long id, DirectorySortUpdateDgDto directorySortUpdateDgDto, DirDgEo directoryItemEo) {
        DirIndexDgEo indexParam = new DirIndexDgEo();
        indexParam.setRootId(directoryItemEo.getId());
        DirIndexDgEo indexEo = (DirIndexDgEo)this.dirIndexDgDomain.selectOne((BaseEo)indexParam);
        if (indexEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        indexParam.setRootId(null);
        indexParam.setDirUsage(indexEo.getDirUsage());
        indexParam.setInstanceId(indexEo.getInstanceId());
        indexParam.setTenantId(indexEo.getTenantId());
        List indexEoList = this.dirIndexDgDomain.selectList((BaseEo)indexParam);
        if (CollectionUtils.isNotEmpty((Collection)indexEoList)) {
            ArrayList<Long> idsList = new ArrayList<Long>();
            for (DirIndexDgEo directoryEo : indexEoList) {
                idsList.add(directoryEo.getRootId());
            }
            List<DirectoryItemDgRespDto> dirList = this.directoryDgService.queryByIds(idsList, "sort");
            if (CollectionUtils.isNotEmpty(dirList)) {
                for (int i = 0; i < dirList.size(); ++i) {
                    if (!id.equals(dirList.get(i).getId())) continue;
                    DirDgEo sourceDirUpdateEo = new DirDgEo();
                    DirDgEo targetDirUpdateEo = new DirDgEo();
                    sourceDirUpdateEo.setId(id);
                    if (DirSortDgEnum.INCR.getType().equals(directorySortUpdateDgDto.getSortType()) && i != 0) {
                        targetDirUpdateEo.setId(dirList.get(i - 1).getId());
                        sourceDirUpdateEo.setSort(dirList.get(i - 1).getSort());
                        targetDirUpdateEo.setSort(dirList.get(i).getSort());
                    } else if (DirSortDgEnum.DECR.getType().equals(directorySortUpdateDgDto.getSortType()) && i != dirList.size() - 1) {
                        targetDirUpdateEo.setId(dirList.get(i + 1).getId());
                        sourceDirUpdateEo.setSort(dirList.get(i + 1).getSort());
                        targetDirUpdateEo.setSort(dirList.get(i).getSort());
                    }
                    this.dirDgDomain.updateSelective((BaseEo)sourceDirUpdateEo);
                    this.dirDgDomain.updateSelective((BaseEo)targetDirUpdateEo);
                    break;
                }
            }
        }
    }

    private void updateDirEoSort(List<DirDgEo> dirDgEoList) {
        if (CollectionUtils.isEmpty(dirDgEoList)) {
            return;
        }
        int sort = 0;
        for (DirDgEo eo : dirDgEoList) {
            eo.setSort(Integer.valueOf(sort++));
            this.dirDgDomain.update((BaseEo)eo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sortDirectory(DirectorySortUpdateDgDto directorySortUpdateDgDto) {
        Long instanceId = directorySortUpdateDgDto.getInstanceId();
        Long tenantId = directorySortUpdateDgDto.getTenantId();
        if (directorySortUpdateDgDto == null || instanceId == null || tenantId == null || directorySortUpdateDgDto.getSourceDirId() == null || directorySortUpdateDgDto.getTargetDirId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirDgEo sourceDirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(directorySortUpdateDgDto.getSourceDirId());
        if (sourceDirDgEo == null || !instanceId.equals(sourceDirDgEo.getInstanceId()) || !tenantId.equals(sourceDirDgEo.getTenantId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        DirDgEo targetDirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(directorySortUpdateDgDto.getTargetDirId());
        if (targetDirDgEo == null || !instanceId.equals(targetDirDgEo.getInstanceId()) || !tenantId.equals(targetDirDgEo.getTenantId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        if (!sourceDirDgEo.getParentId().equals(targetDirDgEo.getParentId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<DirDgEo> newSortList = new ArrayList<DirDgEo>();
        DirDgEo selectDir = new DirDgEo();
        selectDir.setOrderBy("sort");
        selectDir.setParentId(sourceDirDgEo.getParentId());
        selectDir.setInstanceId(directorySortUpdateDgDto.getInstanceId());
        selectDir.setTenantId(directorySortUpdateDgDto.getTenantId());
        if (DirSortDgEnum.TOP.getType().equalsIgnoreCase(directorySortUpdateDgDto.getSortType()) || DirSortDgEnum.BOTTOM.getType().equalsIgnoreCase(directorySortUpdateDgDto.getSortType())) {
            List sortList = this.dirDgDomain.selectList((BaseEo)selectDir);
            if (CollectionUtils.isNotEmpty((Collection)sortList)) {
                sortList.remove(sourceDirDgEo);
                for (int i = 0; i < sortList.size(); ++i) {
                    if (DirSortDgEnum.TOP.getType().equalsIgnoreCase(directorySortUpdateDgDto.getSortType())) {
                        if (((DirDgEo)sortList.get(i)).getId().equals(targetDirDgEo.getId())) {
                            newSortList.add(sourceDirDgEo);
                        }
                        newSortList.add((DirDgEo)sortList.get(i));
                        continue;
                    }
                    if (!DirSortDgEnum.BOTTOM.getType().equalsIgnoreCase(directorySortUpdateDgDto.getSortType())) continue;
                    newSortList.add((DirDgEo)sortList.get(i));
                    if (!((DirDgEo)sortList.get(i)).getId().equals(targetDirDgEo.getId())) continue;
                    newSortList.add(sourceDirDgEo);
                }
            }
        } else {
            DirDgEo sourceDirUpdateEo = new DirDgEo();
            sourceDirUpdateEo.setId(sourceDirDgEo.getId());
            sourceDirUpdateEo.setSort(targetDirDgEo.getSort());
            DirDgEo targetDirUpdateEo = new DirDgEo();
            targetDirUpdateEo.setId(targetDirDgEo.getId());
            targetDirUpdateEo.setSort(sourceDirDgEo.getSort());
            this.dirDgDomain.updateSelective((BaseEo)sourceDirUpdateEo);
            this.dirDgDomain.updateSelective((BaseEo)targetDirUpdateEo);
            return;
        }
        this.updateDirEoSort(newSortList);
    }

    @Override
    public List<TreeDto<DirIndexDgRespDto>> queryDirTreeDetail(RootDirectoryDgReqDto rootDirectoryDgReqDto) {
        if (rootDirectoryDgReqDto == null || rootDirectoryDgReqDto.getInstanceId() == null || rootDirectoryDgReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        ArrayList<TreeDto<DirIndexDgRespDto>> treeDtoList = new ArrayList<TreeDto<DirIndexDgRespDto>>();
        DirIndexDgEo dirIndexDgEo = DirIndexDgEo.newInstance((Map)rootDirectoryDgReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)rootDirectoryDgReqDto, (BaseEo)dirIndexDgEo);
        QueryParamDgUtils.columnLike((BaseEo)dirIndexDgEo, "name", dirIndexDgEo.getName());
        List dirIndexDgEoList = this.dirIndexDgDomain.selectList((BaseEo)dirIndexDgEo);
        if (CollectionUtils.isEmpty((Collection)dirIndexDgEoList)) {
            return treeDtoList;
        }
        HashSet<Long> rootIdList = new HashSet<Long>();
        for (DirIndexDgEo indexEo : dirIndexDgEoList) {
            rootIdList.add(indexEo.getRootId());
        }
        if (CollectionUtils.isEmpty(rootIdList)) {
            return treeDtoList;
        }
        DirDgEo dirDgEo = new DirDgEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(rootIdList, (String)",")));
        dirDgEo.setSqlFilters(sqlFilterList);
        dirDgEo.setOrderBy("sort");
        List dirDgEoList = this.dirDgDomain.selectList((BaseEo)dirDgEo);
        for (DirDgEo eo : dirDgEoList) {
            for (DirIndexDgEo indexEo : dirIndexDgEoList) {
                if (!eo.getId().equals(indexEo.getRootId())) continue;
                List<DirDgEo> dirList = this.queryDirByRootId(eo.getId(), null);
                ArrayList dtoList = new ArrayList();
                DtoHelper.eoList2DtoList(dirList, dtoList, DirIndexDgRespDto.class);
                List tree = TreeDto.createTreeDto(dtoList);
                DirIndexDgRespDto dirIndexRespDto = (DirIndexDgRespDto)((TreeDto)tree.get(0)).getNode();
                dirIndexRespDto.setIndexId(indexEo.getId());
                dirIndexRespDto.setIndexName(indexEo.getName());
                dirIndexRespDto.setIndexExtension(indexEo.getExtension());
                if (!eo.getParentId().equals(0L) || eo.getCreateTime().getTime() - indexEo.getCreateTime().getTime() < -100L) {
                    dirIndexRespDto.setLink(eo.getId());
                }
                treeDtoList.addAll(tree);
            }
        }
        return treeDtoList;
    }

    private DirDgEo queryDirById(Long id) {
        DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(id);
        if (dirDgEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
        }
        return dirDgEo;
    }

    @Override
    public DirectoryItemDgRespDto queryById(Long id, boolean queryLinks) {
        DirDgEo dirDgEo = this.queryDirById(id);
        DirectoryItemDgRespDto directoryItemDgRespDto = new DirectoryItemDgRespDto();
        if (Objects.isNull(dirDgEo)) {
            return directoryItemDgRespDto;
        }
        DtoHelper.eo2Dto((BaseEo)dirDgEo, (BaseVo)directoryItemDgRespDto);
        DirDgEo parent = Objects.equals(0L, dirDgEo.getParentId()) ? dirDgEo : this.queryDirById(dirDgEo.getParentId());
        directoryItemDgRespDto.setParentCode(parent.getCode());
        directoryItemDgRespDto.setParentName(parent.getName());
        this.getfrontShopRelationBack(directoryItemDgRespDto);
        if (queryLinks) {
            DirRelationDgEo dirRelationDgEo = new DirRelationDgEo();
            dirRelationDgEo.setDirId(dirDgEo.getId());
            dirRelationDgEo.setInstanceId(dirDgEo.getInstanceId());
            dirRelationDgEo.setTenantId(dirDgEo.getTenantId());
            List dirRelationDgEoList = this.dirRelationDgDomain.selectList((BaseEo)dirRelationDgEo);
            ArrayList<Long> linkDirIdList = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty((Collection)dirRelationDgEoList)) {
                for (DirRelationDgEo relationEo : dirRelationDgEoList) {
                    linkDirIdList.add(relationEo.getLinkDirId());
                }
            }
            directoryItemDgRespDto.setLinks(linkDirIdList);
        }
        return directoryItemDgRespDto;
    }

    private void getfrontShopRelationBack(DirectoryItemDgRespDto directoryDto) {
        FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
        frontShopRelationBackDgEo.setFrontShopId(directoryDto.getId());
        List frontShopRelationBackDgEos = this.frontShopRelationBackDgDomian.selectList((BaseEo)frontShopRelationBackDgEo);
        if (CollectionUtil.isNotEmpty((Collection)frontShopRelationBackDgEos)) {
            String frontRelationBack = "";
            for (FrontShopRelationBackDgEo backDgEo : frontShopRelationBackDgEos) {
                frontRelationBack = StringUtils.isNotBlank((CharSequence)frontRelationBack) ? frontRelationBack + "," + backDgEo.getBackId() : String.valueOf(backDgEo.getBackId());
            }
            directoryDto.setFrontRelationBack(frontRelationBack);
        }
    }

    @Override
    @Cacheable(value={"DIR_TREE_CACHE"}, key="#dirTreeDgReqDto.instanceId+'_'+#dirTreeDgReqDto.dirUsage+'_'+#dirTreeDgReqDto.shopId", unless="#result == null")
    public List<TreeDto<DirectoryItemDgRespDto>> queryDirTree(DirTreeDgReqDto dirTreeDgReqDto) {
        DirIndexDgEo example = DirIndexDgEo.newInstance();
        example.setDirUsage(dirTreeDgReqDto.getDirUsage());
        example.setInstanceId(dirTreeDgReqDto.getInstanceId());
        example.setTenantId(dirTreeDgReqDto.getTenantId());
        example.setShopId(dirTreeDgReqDto.getShopId());
        List<DirIndexDgEo> directoryEos = this.directoryDgService.queryDirectory(example);
        ArrayList<Long> idsList = new ArrayList<Long>();
        for (DirIndexDgEo directoryEo : directoryEos) {
            idsList.add(directoryEo.getRootId());
        }
        return this.queryDirByRootIds(idsList, null);
    }

    @Override
    public List<List<DirectoryItemDgRespDto>> queryDirLevels(List<Long> ids) {
        ArrayList<LinkedList<DirectoryItemDgRespDto>> levels = new ArrayList<LinkedList<DirectoryItemDgRespDto>>();
        this.queryWithIds(levels, ids);
        return levels.stream().map(linkedList -> {
            ArrayList arrayList = new ArrayList(linkedList);
            return arrayList;
        }).collect(Collectors.toList());
    }

    private void queryWithIds(List<LinkedList<DirectoryItemDgRespDto>> levels, List<Long> ids) {
        List<DirectoryItemDgRespDto> respDtos = this.queryList(ids);
        if (CollectionUtils.isNotEmpty(respDtos)) {
            if (CollectionUtils.isEmpty(levels)) {
                respDtos.forEach(dirDto -> {
                    LinkedList<DirectoryItemDgRespDto> dirList = new LinkedList<DirectoryItemDgRespDto>();
                    dirList.addFirst((DirectoryItemDgRespDto)dirDto);
                    levels.add(dirList);
                });
            } else {
                Map<Long, DirectoryItemDgRespDto> dirMap = respDtos.stream().collect(Collectors.toMap(DirectoryItemDgRespDto::getId, e -> e));
                levels.forEach(dirDtos -> {
                    Long parentId;
                    if (dirDtos.size() > 0 && dirMap.containsKey(parentId = ((DirectoryItemDgRespDto)dirDtos.getFirst()).getParentId())) {
                        dirDtos.addFirst(dirMap.get(parentId));
                    }
                });
            }
            List<Long> parentIds = respDtos.stream().map(DirectoryItemDgRespDto::getParentId).filter(dirId -> !ItemDgConstant.ROOT_NODE.equals(dirId)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(parentIds)) {
                this.queryWithIds(levels, parentIds);
            }
        }
    }

    @Override
    public List<DirectoryItemDgRespDto> queryList(List<Long> ids) {
        DirDgEo dirDgEo = new DirDgEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", ids));
        List dirDgEos = this.dirDgDomain.selectByIds(ids);
        ArrayList<DirectoryItemDgRespDto> dtos = new ArrayList<DirectoryItemDgRespDto>();
        DtoHelper.eoList2DtoList((Collection)dirDgEos, dtos, DirectoryItemDgRespDto.class);
        return dtos;
    }

    @Override
    public List<DirectoryItemDgRespDto> queryDirByFilter(List<String> filter, Integer type, String dirUsage) {
        List<DirDgEo> dirDgEos;
        ArrayList list = Lists.newArrayList();
        if (type == 1) {
            dirDgEos = this.queryByName(filter, dirUsage);
        } else {
            if (CollectionUtils.isEmpty(filter)) {
                return null;
            }
            List codes = filter.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            DirDgEo dirExample = DirDgEo.newInstance();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            if (Objects.nonNull(dirUsage)) {
                DirIndexDgEo dirIndexDgEo = new DirIndexDgEo();
                dirIndexDgEo.setDirUsage(dirUsage);
                List<DirIndexDgEo> dirIndexDgEos = this.queryDirectory(dirIndexDgEo);
                if (CollectionUtil.isEmpty(dirIndexDgEos)) {
                    return list;
                }
                List rootIds = dirIndexDgEos.stream().map(DirIndexDgEo::getRootId).collect(Collectors.toList());
                sqlFilters.add(SqlFilter.in((String)"root_id", rootIds));
            }
            sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(codes, (String)",")));
            dirExample.setSqlFilters(sqlFilters);
            dirDgEos = this.queryDirectoryItem(dirExample);
        }
        DtoHelper.eoList2DtoList(dirDgEos, (Collection)list, DirectoryItemDgRespDto.class);
        return list;
    }

    @Override
    public List<DirectoryItemDgRespDto> queryDirListByCondition(DirectoryDgFilterReqDto reqDto) {
        ArrayList list = Lists.newArrayList();
        List<Object> rootIds = new ArrayList();
        if (Objects.nonNull(reqDto) && Objects.nonNull(reqDto.getDirUsage())) {
            DirIndexDgEo dirIndexDgEo = new DirIndexDgEo();
            dirIndexDgEo.setDirUsage(reqDto.getDirUsage());
            List<DirIndexDgEo> dirIndexDgEos = this.queryDirectory(dirIndexDgEo);
            if (CollectionUtil.isEmpty(dirIndexDgEos)) {
                return list;
            }
            rootIds = dirIndexDgEos.stream().map(DirIndexDgEo::getRootId).collect(Collectors.toList());
        }
        List dirDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDgDomain.filter().in(CollectionUtil.isNotEmpty(rootIds), (Object)"root_id", rootIds)).in(Objects.nonNull(reqDto) && CollectionUtil.isNotEmpty((Collection)reqDto.getNameList()), (Object)"name", (Collection)reqDto.getNameList())).in(Objects.nonNull(reqDto) && CollectionUtil.isNotEmpty((Collection)reqDto.getCodeList()), (Object)"code", (Collection)reqDto.getCodeList())).list();
        DtoHelper.eoList2DtoList((Collection)dirDgEos, (Collection)list, DirectoryItemDgRespDto.class);
        return list;
    }

    @Override
    public List<DirParentRespDto> queryParentDir(DirectoryQueryParentReqDto reqDto) {
        ArrayList<DirParentRespDto> parentRespDtos = new ArrayList<DirParentRespDto>();
        List dirDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDgDomain.filter().in(CollectionUtil.isNotEmpty((Collection)reqDto.getIdList()), (Object)"id", (Collection)reqDto.getIdList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getCodeList()), (Object)"code", (Collection)reqDto.getCodeList())).list();
        if (CollectionUtil.isEmpty((Collection)dirDgEos)) {
            return parentRespDtos;
        }
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (DirDgEo dirDgEo : dirDgEos) {
            DirParentRespDto parentRespDto = new DirParentRespDto();
            BeanUtil.copyProperties((Object)dirDgEo, (Object)parentRespDto, (String[])new String[0]);
            List<Long> ids = this.getParentIds(dirDgEo.getIndexPath());
            parentIds.addAll(ids);
            parentRespDto.setIndexPathIds(ids);
            parentRespDtos.add(parentRespDto);
        }
        Map<Long, DirRespDto> dirMap = this.getDirMapByIds(parentIds);
        for (DirParentRespDto parentRespDto : parentRespDtos) {
            ArrayList<DirRespDto> dirRespDtoList = new ArrayList<DirRespDto>();
            List indexPathIds = parentRespDto.getIndexPathIds();
            if (CollectionUtil.isEmpty((Collection)indexPathIds)) continue;
            for (Long indexPathId : indexPathIds) {
                if (!Objects.nonNull(dirMap.get(indexPathId))) continue;
                dirRespDtoList.add(dirMap.get(indexPathId));
            }
            parentRespDto.setDirRespDtoList(dirRespDtoList);
        }
        return parentRespDtos;
    }

    private List<Long> getParentIds(String indexPath) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)indexPath)) {
            String[] fruits;
            for (String fruit : fruits = indexPath.split(",")) {
                parentIds.add(Long.valueOf(fruit));
            }
        }
        return parentIds;
    }

    private Map<Long, DirRespDto> getDirMapByIds(List<Long> parentIds) {
        List dirDgEos;
        Map<Long, Object> dirMap = new HashMap<Long, DirRespDto>();
        if (CollectionUtil.isNotEmpty(parentIds) && CollectionUtil.isNotEmpty((Collection)(dirDgEos = this.dirDgDomain.selectByIds(parentIds)))) {
            List dirRespDtos = BeanUtil.copyToList((Collection)dirDgEos, DirRespDto.class);
            dirMap = dirRespDtos.stream().collect(Collectors.toMap(DirRespDto::getId, Function.identity(), (k1, k2) -> k2));
        }
        return dirMap;
    }

    @Override
    public List<DirIndexDgEo> queryDirectory(DirIndexDgEo directoryEo) {
        if (directoryEo == null) {
            throw new BizException(ItemExceptionCode.NON_EXIST_DIR.getCode(), ItemExceptionCode.NON_EXIST_DIR.getMsg());
        }
        return this.dirIndexDgDomain.selectList((BaseEo)directoryEo, Integer.valueOf(1), Integer.valueOf(10000));
    }

    @Override
    public List<TreeDto<DirectoryItemDgRespDto>> queryDirTreeByName(String name, List<Long> rootIds) {
        ArrayList<TreeDto<DirectoryItemDgRespDto>> trees = new ArrayList<TreeDto<DirectoryItemDgRespDto>>();
        if (CollectionUtils.isEmpty(rootIds)) {
            return null;
        }
        DirDgEo dirEo = new DirDgEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"rootId", (Object)StringUtils.join(rootIds, (String)",")));
        sqlFilterList.add(SqlFilter.like((String)"name", (Object)name));
        dirEo.setSqlFilters(sqlFilterList);
        dirEo.setOrderBy("sort");
        dirEo.setStatus(null);
        List dirEoList = this.dirDgDomain.selectList((BaseEo)dirEo);
        for (DirDgEo eo : dirEoList) {
            List<DirDgEo> dirList = this.queryDirByRootId(eo.getId(), null);
            if (!CollectionUtils.isNotEmpty(dirList)) continue;
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList(dirList, dtoList, DirectoryItemDgRespDto.class);
            List tree = TreeDto.createTreeDto(dtoList);
            trees.addAll(tree);
        }
        return trees;
    }
}

