/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.convert.entity.InventoryDisplayRuleDgConverter;
import com.yunxi.dg.base.center.item.domain.entity.IInventoryDisplayRuleDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IRuleInformationDgDomain;
import com.yunxi.dg.base.center.item.dto.entity.InventoryDisplayRuleDgDto;
import com.yunxi.dg.base.center.item.dto.entity.InventoryDisplayRuleDgPageReqDto;
import com.yunxi.dg.base.center.item.dto.request.InventoryDisplayRuleChangeStatusReqDto;
import com.yunxi.dg.base.center.item.dto.request.InventoryDisplayRuleDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.RuleInformationDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.InventoryDisplayRuleDgRespDto;
import com.yunxi.dg.base.center.item.eo.InventoryDisplayRuleDgEo;
import com.yunxi.dg.base.center.item.eo.RuleInformationDgEo;
import com.yunxi.dg.base.center.item.service.entity.IInventoryDisplayRuleDgService;
import com.yunxi.dg.base.center.item.service.util.CommonCodeUtil;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InventoryDisplayRuleDgServiceImpl
extends BaseServiceImpl<InventoryDisplayRuleDgDto, InventoryDisplayRuleDgEo, IInventoryDisplayRuleDgDomain>
implements IInventoryDisplayRuleDgService {
    @Resource
    private CommonCodeUtil commonCodeUtil;
    @Resource
    private IRuleInformationDgDomain iRuleInformationDgDomain;

    public InventoryDisplayRuleDgServiceImpl(IInventoryDisplayRuleDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryDisplayRuleDgDto, InventoryDisplayRuleDgEo> converter() {
        return InventoryDisplayRuleDgConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> insert(InventoryDisplayRuleDgReqDto dto) {
        String ruleName = dto.getRuleName();
        InventoryDisplayRuleDgEo inventoryDisplayRuleDgEo = (InventoryDisplayRuleDgEo)((IInventoryDisplayRuleDgDomain)this.domain).getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryDisplayRuleDgEo.class).eq(InventoryDisplayRuleDgEo::getRuleName, (Object)ruleName)).eq(BaseEo::getDr, (Object)0)).last("limit 1"));
        AssertUtils.isNull((Object)inventoryDisplayRuleDgEo, (String)"\u8be5\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (ObjectUtil.equal((Object)2, (Object)dto.getRangeType())) {
            AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getApplicableRange()), (String)"\u9002\u7528\u8303\u56f4\u4e3a\u6307\u5b9a\uff0c\u8bf7\u586b\u9002\u7528\u8303\u56f4\u503c");
        }
        InventoryDisplayRuleDgEo eo = new InventoryDisplayRuleDgEo();
        eo.setRuleCode(this.commonCodeUtil.genRuleCode());
        eo.setRuleName(dto.getRuleName());
        eo.setRangeType(dto.getRangeType());
        eo.setApplicableRange(dto.getApplicableRange());
        eo.setShopId(dto.getShopId());
        eo.setShopCode(dto.getShopCode());
        eo.setStatus(YesNoEnum.YES.getValue());
        eo.setDataLimitId(dto.getDataLimitId());
        eo.setCreatePerson(dto.getCreatePerson());
        eo.setUpdatePerson(dto.getUpdatePerson());
        ((IInventoryDisplayRuleDgDomain)this.domain).insert((BaseEo)eo);
        Long ruleId = eo.getId();
        this.addRuleInformationDtoList(dto, ruleId);
        return new RestResponse((Object)ruleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<InventoryDisplayRuleDgRespDto> queryDetail(Long id) {
        InventoryDisplayRuleDgEo displayRuleDgEo = (InventoryDisplayRuleDgEo)((ExtQueryChainWrapper)((IInventoryDisplayRuleDgDomain)this.domain).filter().eq((Object)"id", (Object)id)).one();
        InventoryDisplayRuleDgRespDto ruleDgRespDto = new InventoryDisplayRuleDgRespDto();
        ruleDgRespDto.setRuleCode(displayRuleDgEo.getRuleCode());
        ruleDgRespDto.setRuleName(displayRuleDgEo.getRuleName());
        ruleDgRespDto.setRangeType(displayRuleDgEo.getRangeType());
        ruleDgRespDto.setApplicableRange(displayRuleDgEo.getApplicableRange());
        ruleDgRespDto.setDataLimitId(displayRuleDgEo.getDataLimitId());
        ruleDgRespDto.setStatus(displayRuleDgEo.getStatus());
        ruleDgRespDto.setShopCode(displayRuleDgEo.getShopCode());
        ruleDgRespDto.setShopId(displayRuleDgEo.getShopId());
        ruleDgRespDto.setCreatePerson(displayRuleDgEo.getCreatePerson());
        ruleDgRespDto.setUpdatePerson(displayRuleDgEo.getUpdatePerson());
        ruleDgRespDto.setCreateTime(displayRuleDgEo.getCreateTime());
        ruleDgRespDto.setUpdateTime(displayRuleDgEo.getUpdateTime());
        ruleDgRespDto.setId(id);
        List eoList = this.iRuleInformationDgDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RuleInformationDgEo.class).eq(RuleInformationDgEo::getInventoryDisplayRuleId, (Object)id)).eq(BaseEo::getDr, (Object)0));
        List ruleInformationDgReqDtoList = BeanUtil.copyToList((Collection)eoList, RuleInformationDgReqDto.class);
        ruleDgRespDto.setRuleInformationDtoList(ruleInformationDgReqDtoList);
        return new RestResponse((Object)ruleDgRespDto);
    }

    @Override
    public RestResponse<Void> changeStatus(InventoryDisplayRuleChangeStatusReqDto dto) {
        Long id = dto.getId();
        Integer status = dto.getStatus();
        AssertUtils.notNull((Object)status, (String)"\u542f\u7528/\u7981\u7528\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtils.notEmpty((Object)id, (String)"\u5e93\u5b58\u5c55\u793a\u89c4\u5219id\u4e0d\u53ef\u4e3a\u7a7a");
        InventoryDisplayRuleDgEo inventoryDisplayRuleDgEo = (InventoryDisplayRuleDgEo)((IInventoryDisplayRuleDgDomain)this.domain).getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryDisplayRuleDgEo.class).eq(BaseEo::getId, (Object)id)).eq(BaseEo::getDr, (Object)0)).last("limit 1"));
        AssertUtils.isTrue((boolean)Objects.nonNull(inventoryDisplayRuleDgEo), (String)"\u6ca1\u6709\u8be5\u6761\u5e93\u5b58\u5c55\u793a\u89c4\u5219");
        AssertUtils.isTrue((!inventoryDisplayRuleDgEo.getStatus().equals(status) ? 1 : 0) != 0, (String)"\u5f53\u524d\u72b6\u6001\u4e0e\u4fee\u6539\u72b6\u6001\u76f8\u540c\uff0c\u4e0d\u53ef\u4fee\u6539");
        ((IInventoryDisplayRuleDgDomain)this.domain).getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(InventoryDisplayRuleDgEo.class).eq(BaseEo::getId, (Object)id)).eq(BaseEo::getDr, (Object)0)).set(InventoryDisplayRuleDgEo::getStatus, (Object)status));
        return RestResponse.VOID;
    }

    @Override
    public PageInfo<InventoryDisplayRuleDgRespDto> pageQuery(InventoryDisplayRuleDgPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List inventoryDisplayRuleDgEos = ((IInventoryDisplayRuleDgDomain)this.domain).getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryDisplayRuleDgEo.class).eq(Objects.nonNull(dto.getStatus()), InventoryDisplayRuleDgEo::getStatus, (Object)dto.getStatus())).eq(Objects.nonNull(dto.getShopId()), InventoryDisplayRuleDgEo::getShopId, (Object)dto.getShopId())).eq(StringUtils.isNotBlank((CharSequence)dto.getShopCode()), InventoryDisplayRuleDgEo::getShopCode, (Object)dto.getShopCode())).eq(BaseEo::getDr, (Object)0)).orderByDesc(BaseEo::getCreateTime));
        ArrayList respDtoList = new ArrayList();
        inventoryDisplayRuleDgEos.forEach(e -> {
            List eoList = this.iRuleInformationDgDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RuleInformationDgEo.class).eq(RuleInformationDgEo::getInventoryDisplayRuleId, (Object)e.getId())).eq(BaseEo::getDr, (Object)0));
            List ruleInformationDgReqDtoList = BeanUtil.copyToList((Collection)eoList, RuleInformationDgReqDto.class);
            InventoryDisplayRuleDgRespDto respDto = new InventoryDisplayRuleDgRespDto();
            respDto.setRuleInformationDtoList(ruleInformationDgReqDtoList);
            BeanUtil.copyProperties((Object)e, (Object)respDto, (String[])new String[0]);
            respDtoList.add(respDto);
        });
        return new PageInfo(respDtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse update(InventoryDisplayRuleDgReqDto dto) {
        Long id = dto.getId();
        String ruleCode = dto.getRuleCode();
        AssertUtils.notEmpty((Object)id, (String)"\u7f16\u8f91\u5e93\u5b58\u5c55\u793a\u89c4\u5219id\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtils.notEmpty((String)ruleCode, (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        ((IInventoryDisplayRuleDgDomain)this.domain).getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(InventoryDisplayRuleDgEo.class).eq(BaseEo::getId, (Object)id)).eq(InventoryDisplayRuleDgEo::getRuleCode, (Object)ruleCode)).eq(BaseEo::getDr, (Object)0)).set(StringUtils.isNotBlank((CharSequence)dto.getRuleName()), InventoryDisplayRuleDgEo::getRuleName, (Object)dto.getRuleName()).set(Objects.nonNull(dto.getRangeType()), InventoryDisplayRuleDgEo::getRangeType, (Object)dto.getRangeType()).set(StringUtils.isNotBlank((CharSequence)dto.getApplicableRange()), InventoryDisplayRuleDgEo::getApplicableRange, (Object)dto.getApplicableRange()).set(StringUtils.isNotBlank((CharSequence)dto.getShopCode()), InventoryDisplayRuleDgEo::getShopCode, (Object)dto.getShopCode()).set(Objects.nonNull(dto.getShopId()), InventoryDisplayRuleDgEo::getShopId, (Object)dto.getShopId()));
        this.iRuleInformationDgDomain.getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(RuleInformationDgEo.class).eq(RuleInformationDgEo::getInventoryDisplayRuleId, (Object)id)).set(BaseEo::getDr, (Object)1));
        this.addRuleInformationDtoList(dto, id);
        return RestResponse.VOID;
    }

    private void addRuleInformationDtoList(InventoryDisplayRuleDgReqDto dto, Long ruleId) {
        List ruleInformationDtoList = dto.getRuleInformationDtoList();
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)ruleInformationDtoList), (String)"\u81f3\u5c11\u4f20\u4e00\u6761\u89c4\u5219\u4fe1\u606f");
        List<RuleInformationDgReqDto> list = ruleInformationDtoList.stream().sorted(Comparator.comparing(RuleInformationDgReqDto::getSort)).collect(Collectors.toList());
        if (list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                RuleInformationDgReqDto current = (RuleInformationDgReqDto)list.get(i);
                RuleInformationDgReqDto previous = (RuleInformationDgReqDto)list.get(i - 1);
                AssertUtils.isTrue((current.getRuleRangeFrom() > previous.getRuleRangeTo() ? 1 : 0) != 0, (String)"\u53ef\u89c1\u5e93\u5b58\u8bbe\u7f6e\u4e0d\u89c4\u8303");
            }
        }
        ArrayList eoList = new ArrayList();
        list.forEach(e -> {
            RuleInformationDgEo informationDgEo = new RuleInformationDgEo();
            informationDgEo.setInventoryDisplayRuleId(ruleId);
            informationDgEo.setRuleRangeFrom(e.getRuleRangeFrom());
            informationDgEo.setRuleRangeTo(e.getRuleRangeTo());
            informationDgEo.setRuleType(e.getRuleType());
            informationDgEo.setRuleTypeDesc(e.getRuleTypeDesc());
            informationDgEo.setSort(e.getSort());
            informationDgEo.setDataLimitId(e.getDataLimitId());
            informationDgEo.setCreatePerson(e.getCreatePerson());
            informationDgEo.setUpdatePerson(e.getUpdatePerson());
            eoList.add(informationDgEo);
        });
        this.iRuleInformationDgDomain.insertBatch(eoList);
    }

    @Override
    public List<InventoryDisplayRuleDgRespDto> queryList(InventoryDisplayRuleDgDto dto) {
        List inventoryDisplayRuleDgEos = ((IInventoryDisplayRuleDgDomain)this.domain).getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryDisplayRuleDgEo.class).in(InventoryDisplayRuleDgEo::getShopId, (Collection)dto.getShopIds())).eq(InventoryDisplayRuleDgEo::getStatus, (Object)YesNoEnum.YES.getValue())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
        if (CollectionUtil.isEmpty((Collection)inventoryDisplayRuleDgEos)) {
            return null;
        }
        List displayRuleDgRespDtoList = BeanUtil.copyToList((Collection)inventoryDisplayRuleDgEos, InventoryDisplayRuleDgRespDto.class);
        List ids = inventoryDisplayRuleDgEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List ruleInformationDgEoList = this.iRuleInformationDgDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RuleInformationDgEo.class).in(RuleInformationDgEo::getInventoryDisplayRuleId, ids)).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
        if (CollectionUtil.isNotEmpty((Collection)ruleInformationDgEoList)) {
            List informationDgReqDtoList = BeanUtil.copyToList((Collection)ruleInformationDgEoList, RuleInformationDgReqDto.class);
            Map listMap = informationDgReqDtoList.stream().collect(Collectors.groupingBy(RuleInformationDgReqDto::getInventoryDisplayRuleId, Collectors.toList()));
            for (InventoryDisplayRuleDgRespDto inventoryDisplayRuleDgRespDto : displayRuleDgRespDtoList) {
                if (!listMap.containsKey(inventoryDisplayRuleDgRespDto.getId())) continue;
                inventoryDisplayRuleDgRespDto.setRuleInformationDtoList(listMap.get(inventoryDisplayRuleDgRespDto.getId()));
            }
        }
        return displayRuleDgRespDtoList;
    }
}

