/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.convert.entity.ItemClassDgConverter;
import com.yunxi.dg.base.center.item.domain.entity.IItemClassDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.dto.entity.ItemClassDgDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemClassDgPageReqDto;
import com.yunxi.dg.base.center.item.eo.ItemClassDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemClassDgService;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemClassDgServiceImpl
extends BaseServiceImpl<ItemClassDgDto, ItemClassDgEo, IItemClassDgDomain>
implements IItemClassDgService {
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;

    public ItemClassDgServiceImpl(IItemClassDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ItemClassDgDto, ItemClassDgEo> converter() {
        return ItemClassDgConverter.INSTANCE;
    }

    @Override
    public PageInfo<ItemClassDgDto> page(ItemClassDgPageReqDto dto) {
        ItemClassDgEo itemClassDgEo = new ItemClassDgEo();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)itemClassDgEo);
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)dto.getCode()), ItemClassDgEo::getCode, (Object)dto.getCode());
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)dto.getName()), ItemClassDgEo::getName, (Object)dto.getName());
        queryWrapper.eq(Objects.nonNull(dto.getStatus()), ItemClassDgEo::getStatus, (Object)dto.getStatus());
        queryWrapper.in(CollectionUtil.isNotEmpty((Collection)dto.getNameList()), ItemClassDgEo::getName, (Collection)dto.getNameList());
        queryWrapper.eq(BaseEo::getDr, (Object)CommonConstants.Dr.NO);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        Page page = (Page)((IItemClassDgDomain)this.domain).getMapper().selectPage((IPage)new Page((long)dto.getPageNum().intValue(), (long)dto.getPageSize().intValue()), (Wrapper)queryWrapper);
        List records = page.getRecords();
        ArrayList list = new ArrayList(records.size());
        DtoHelper.eoList2DtoList((Collection)records, list, ItemClassDgDto.class);
        PageInfo pageInfo = new PageInfo(list);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItemClass(ItemClassDgDto dto) {
        ItemClassDgEo itemClassDgEo = (ItemClassDgEo)((ExtQueryChainWrapper)((IItemClassDgDomain)this.domain).filter().eq((Object)"name", (Object)dto.getName())).one();
        AssertUtils.isNull((Object)itemClassDgEo, (String)"\u4ea7\u54c1\u5c0f\u7c7b\u5df2\u5b58\u5728", (Object[])new Object[0]);
        ItemClassDgEo classDgEo = (ItemClassDgEo)BeanUtil.copyProperties((Object)dto, ItemClassDgEo.class, (String[])new String[0]);
        classDgEo.setStatus(YesNoEnum.YES.getValue());
        classDgEo.setCode(Integer.valueOf(this.makeCode()).toString());
        ((IItemClassDgDomain)this.domain).insert((BaseEo)classDgEo);
        return classDgEo.getId();
    }

    private int makeCode() {
        String maxCode = ((IItemClassDgDomain)this.domain).getMaxCode();
        int code = StrUtil.isEmpty((CharSequence)maxCode) ? 1 : Integer.valueOf(maxCode) + 1;
        while (Objects.nonNull(((ExtQueryChainWrapper)((IItemClassDgDomain)this.domain).filter().eq((Object)"code", (Object)code)).one())) {
            ++code;
        }
        return code;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateItemClass(ItemClassDgDto dto) {
        ItemClassDgEo itemClassDgEo = this.checkGet(dto.getId());
        ItemClassDgEo itemClassDgEo1 = (ItemClassDgEo)((ExtQueryChainWrapper)((IItemClassDgDomain)this.domain).filter().eq((Object)"name", (Object)dto.getName())).one();
        boolean b = Objects.nonNull(itemClassDgEo1) && !itemClassDgEo.getId().equals(itemClassDgEo1.getId());
        AssertUtils.isFalse((boolean)b, (String)"\u4ea7\u54c1\u5c0f\u7c7b\u5df2\u5b58\u5728");
        itemClassDgEo.setName(dto.getName());
        ((IItemClassDgDomain)this.domain).update((BaseEo)itemClassDgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteItemClass(Long id) {
        ItemClassDgEo itemClassDgEo = this.checkGet(id);
        List itemSkuDgEoList = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().eq((Object)"item_class_code", (Object)itemClassDgEo.getCode())).list();
        AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)itemSkuDgEoList), (String)"\u4ea7\u54c1\u5c0f\u7c7b\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664");
        ((IItemClassDgDomain)this.domain).delete((BaseEo)itemClassDgEo);
    }

    private ItemClassDgEo checkGet(Long id) {
        List itemClassDgEoList = ((IItemClassDgDomain)this.domain).selectByIds((List)Lists.newArrayList((Object[])new Long[]{id}));
        AssertUtils.notEmpty((Collection)itemClassDgEoList, (String)"\u8bf7\u4f20\u6b63\u786e\u7684id");
        return (ItemClassDgEo)itemClassDgEoList.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enable(Long id) {
        ItemClassDgEo itemClassDgEo = this.checkGet(id);
        AssertUtils.isFalse((boolean)YesNoEnum.YES.getValue().equals(itemClassDgEo.getStatus()), (String)"\u53ea\u6709\u7981\u7528\u72b6\u6001\u624d\u80fd\u542f\u7528");
        itemClassDgEo.setStatus(YesNoEnum.YES.getValue());
        ((IItemClassDgDomain)this.domain).update((BaseEo)itemClassDgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void stop(Long id) {
        ItemClassDgEo itemClassDgEo = this.checkGet(id);
        AssertUtils.isFalse((boolean)YesNoEnum.NO.getValue().equals(itemClassDgEo.getStatus()), (String)"\u53ea\u6709\u542f\u7528\u72b6\u6001\u624d\u80fd\u7981\u7528");
        itemClassDgEo.setStatus(YesNoEnum.NO.getValue());
        ((IItemClassDgDomain)this.domain).update((BaseEo)itemClassDgEo);
    }
}

