/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.dtyunxi.cube.commons.constants.OptStatus;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.yunxi.dg.base.center.item.domain.entity.IItemPriceDgDomain;
import com.yunxi.dg.base.center.item.eo.ItemPriceDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.service.entity.IItemPriceDgService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="itemPriceDgService")
public class ItemPriceDgServiceImpl
implements IItemPriceDgService {
    private static Logger logger = LoggerFactory.getLogger(ItemPriceDgServiceImpl.class);
    @Resource
    private IItemPriceDgDomain itemPriceDgDomain;

    @Override
    public Long addItemPrice(ItemPriceDgEo itemPriceDgEo) {
        itemPriceDgEo.setIsActived(OptStatus.DISABLED.getStatus());
        this.itemPriceDgDomain.insert((BaseEo)itemPriceDgEo);
        return itemPriceDgEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchItemPrice(List<ItemPriceDgEo> itemPriceDgEoList) {
        if (CollectionUtils.isEmpty(itemPriceDgEoList)) {
            logger.error("\u5546\u54c1\u4ef7\u683c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ItemBusinessRuntimeException("\u5546\u54c1\u4ef7\u683c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.itemPriceDgDomain.insertBatch(itemPriceDgEoList);
    }

    @Override
    public List<ItemPriceDgEo> queryItemPriceById(Long itemId) {
        ItemPriceDgEo itemPriceDgEo = ItemPriceDgEo.newInstance();
        itemPriceDgEo.setItemId(itemId);
        return this.itemPriceDgDomain.selectList((BaseEo)itemPriceDgEo);
    }

    @Override
    public List<ItemPriceDgEo> queryItemPrice(ItemPriceDgEo eo) {
        return this.itemPriceDgDomain.selectList((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteItemPrice(ItemPriceDgEo itemPriceDgEo) {
        this.itemPriceDgDomain.logicDelete((BaseEo)itemPriceDgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBatchItemPrice(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"sku_id", (Object)StringUtils.join(skuIds, (String)",")));
        ItemPriceDgEo itemPriceDgEo = ItemPriceDgEo.newInstance();
        itemPriceDgEo.setSqlFilters(sqlFilters);
        this.itemPriceDgDomain.logicDelete((BaseEo)itemPriceDgEo);
    }

    @Override
    public void removeItemPriceByItemId(Long itemId) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"item_id", (Object)itemId));
        ItemPriceDgEo itemPriceDgEo = ItemPriceDgEo.newInstance();
        itemPriceDgEo.setSqlFilters(sqlFilters);
        this.itemPriceDgDomain.logicDelete((BaseEo)itemPriceDgEo);
    }
}

