/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemRateDgDomain;
import com.yunxi.dg.base.center.item.dto.request.ItemRateDgQueryReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemRateDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRateDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemRateDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemRateDgService;
import com.yunxi.dg.base.center.item.service.util.BeanConvertUtil;
import com.yunxi.dg.base.center.item.service.util.GenerateCodeUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemRateDgServiceImpl
implements IItemRateDgService {
    private static Logger logger = LoggerFactory.getLogger(ItemRateDgServiceImpl.class);
    @Resource
    private IItemRateDgDomain itemRateDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private GenerateCodeUtil<ItemRateDgEo> generateCodeUtil;
    @Resource
    private ICacheService cacheService;
    @Resource
    protected ILockService lockService;

    @Override
    public Long addItemRate(ItemRateDgReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u7a0e\u7387\u65b0\u589e\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        ItemRateDgEo itemRateDgEo = new ItemRateDgEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)itemRateDgEo);
        this.getRateVerify(reqDto.getName(), reqDto.getId());
        AssertUtils.notNull((Object)reqDto.getCode(), (String)"\u7a0e\u7387\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a!");
        this.getRateCodeVerify(reqDto.getCode());
        this.itemRateDgDomain.insert((BaseEo)itemRateDgEo);
        return itemRateDgEo.getId();
    }

    @Override
    public void modifyItemRate(ItemRateDgReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return;
        }
        this.getRateVerify(reqDto.getName(), reqDto.getId());
        ItemRateDgEo itemRateDgEo = (ItemRateDgEo)this.itemRateDgDomain.selectByPrimaryKey(id);
        if (Objects.isNull(itemRateDgEo)) {
            throw new BizException("\u4e0d\u5b58\u5728\u8be5\u6570\u636e");
        }
        this.getRateVerify(reqDto.getName(), reqDto.getId());
        reqDto.setCode(null);
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)itemRateDgEo);
        this.itemRateDgDomain.updateSelective((BaseEo)itemRateDgEo);
    }

    @Override
    public void removeItemRateById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        ItemRateDgEo itemRateDgEo = (ItemRateDgEo)this.itemRateDgDomain.selectByPrimaryKey(id);
        AssertUtils.notNull((Object)itemRateDgEo, (String)"\u7a0e\u7387\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ItemDgEo itemDgEo = new ItemDgEo();
        itemDgEo.setRateCode(itemRateDgEo.getCode());
        ItemDgEo itemDgEos = (ItemDgEo)this.itemDgDomain.selectOne((BaseEo)itemDgEo);
        if (Objects.nonNull(itemDgEos)) {
            throw new BizException("\u5546\u54c1\u5b58\u5728\u8be5\u7a0e\u7387\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
        }
        this.itemRateDgDomain.logicDeleteById(id);
    }

    @Override
    public ItemRateDgRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            throw new BizException("id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemRateDgEo itemRateDgEo = (ItemRateDgEo)this.itemRateDgDomain.getMapper().selectById((Serializable)id);
        if (Objects.isNull(itemRateDgEo)) {
            throw new BizException("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8be5\u6570\u636e");
        }
        ItemRateDgRespDto respDto = (ItemRateDgRespDto)itemRateDgEo.toDto(ItemRateDgRespDto.class);
        return respDto;
    }

    @Override
    public PageInfo<ItemRateDgRespDto> queryByPage(ItemRateDgQueryReqDto itemRateDgQueryReqDto) {
        PageInfo itemRateDgEoPageInfo = this.itemRateDgDomain.queryByPage(itemRateDgQueryReqDto);
        PageInfo<ItemRateDgRespDto> pageInfo = BeanConvertUtil.convert(itemRateDgEoPageInfo, ItemRateDgRespDto.class);
        return pageInfo;
    }

    @Override
    public List<ItemRateDgRespDto> queryByIds(List<Long> rateIds) {
        List itemRateDgEos = this.itemRateDgDomain.selectByIds(rateIds);
        if (CollUtil.isEmpty((Collection)itemRateDgEos)) {
            return ListUtil.empty();
        }
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemRateDgEos, (Collection)respDtoList, ItemRateDgRespDto.class);
        return respDtoList;
    }

    private void getRateVerify(String name, Long id) {
        List rateDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemRateDgDomain.filter().ne(id != null, (Object)"id", (Object)id)).eq((Object)"name", (Object)name)).list();
        if (CollectionUtil.isEmpty((Collection)rateDgEos)) {
            return;
        }
        AssertUtils.isFalse((Objects.isNull(id) && CollectionUtil.isNotEmpty((Collection)rateDgEos) ? 1 : 0) != 0, (String)"\u5546\u54c1\u7a0e\u7c7b\u540d\u79f0\u5df2\u91cd\u590d\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u65b0\u521b\u5efa");
        AssertUtils.isFalse((Objects.nonNull(id) && CollectionUtil.isNotEmpty((Collection)rateDgEos) ? 1 : 0) != 0, (String)"\u5546\u54c1\u7a0e\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u65b0\u521b\u5efa");
    }

    private void getRateCodeVerify(String code) {
        List rateNameEos = ((ExtQueryChainWrapper)this.itemRateDgDomain.filter().eq((Object)"code", (Object)code)).list();
        if (CollectionUtil.isNotEmpty((Collection)rateNameEos)) {
            throw new BizException("\u5546\u54c1\u7a0e\u7c7b\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u65b0\u521b\u5efa");
        }
    }

    @Override
    public ItemRateDgRespDto queryByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ItemRateDgEo itemRateDgEo = new ItemRateDgEo();
        itemRateDgEo.setCode(code);
        itemRateDgEo = (ItemRateDgEo)this.itemRateDgDomain.selectOne((BaseEo)itemRateDgEo);
        if (itemRateDgEo == null) {
            return null;
        }
        ItemRateDgRespDto respDto = new ItemRateDgRespDto();
        BeanUtils.copyProperties((Object)itemRateDgEo, (Object)respDto);
        return respDto;
    }

    @Override
    public List<ItemRateDgRespDto> queryByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        ItemRateDgEo itemRateDgEo = new ItemRateDgEo();
        itemRateDgEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"code", codes));
        itemRateDgEo.setSqlFilters((List)sqlFilters);
        List itemRateDgEos = this.itemRateDgDomain.selectList((BaseEo)itemRateDgEo);
        ArrayList itemRateDgRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemRateDgEos, (Collection)itemRateDgRespDtos, ItemRateDgRespDto.class);
        return itemRateDgRespDtos;
    }

    @Override
    public List<ItemRateDgRespDto> queryList(ItemRateDgQueryReqDto itemRateDgQueryReqDto) {
        PageInfo<ItemRateDgRespDto> pageInfo;
        ArrayList<ItemRateDgRespDto> list = new ArrayList<ItemRateDgRespDto>();
        int pageNum = 1;
        int pageSize = 100;
        while (true) {
            itemRateDgQueryReqDto.setPageNum(Integer.valueOf(pageNum));
            itemRateDgQueryReqDto.setPageSize(Integer.valueOf(pageSize));
            pageInfo = this.queryByPage(itemRateDgQueryReqDto);
            if (pageInfo.isIsLastPage()) break;
            list.addAll(pageInfo.getList());
            ++pageNum;
        }
        list.addAll(pageInfo.getList());
        return list;
    }

    public static String append(int length, Long number) {
        String f = "%0" + length + 'd';
        return String.format(f, number);
    }

    @Override
    public Map<Long, ItemRateDgRespDto> queryByItemIds(List<Long> itemIds) {
        List<String> rateCodes;
        HashMap<Long, ItemRateDgRespDto> map = new HashMap<Long, ItemRateDgRespDto>();
        if (CollUtil.isEmpty(itemIds)) {
            return map;
        }
        Map<Object, Object> itemRateDgRespDtoMap = Maps.newHashMap();
        List itemDgEos = this.itemDgDomain.selectByIds(itemIds);
        if (CollectionUtils.isNotEmpty((Collection)itemDgEos) && CollectionUtils.isNotEmpty(rateCodes = itemDgEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getRateCode())).map(ItemDgEo::getRateCode).distinct().collect(Collectors.toList()))) {
            itemRateDgRespDtoMap = this.getItemRateDgRespDto(rateCodes);
        }
        HashMap finalItemRateDgRespDtoMap = itemRateDgRespDtoMap;
        itemDgEos.forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getRateCode()) && finalItemRateDgRespDtoMap.containsKey(v.getRateCode())) {
                ItemRateDgRespDto respDto = (ItemRateDgRespDto)finalItemRateDgRespDtoMap.get(v.getRateCode());
                map.put(v.getId(), respDto);
            }
        });
        return map;
    }

    private Map<String, ItemRateDgRespDto> getItemRateDgRespDto(List<String> rateCodes) {
        Map<Object, Object> itemRateDgRespDtoMap = Maps.newHashMap();
        List itemRateDgEos = ((ExtQueryChainWrapper)this.itemRateDgDomain.filter().in((Object)"code", rateCodes)).list();
        if (CollectionUtils.isNotEmpty((Collection)itemRateDgEos)) {
            ArrayList itemRateDgRespDtos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)itemRateDgRespDtos, (Collection)itemRateDgEos, ItemRateDgRespDto.class);
            itemRateDgRespDtoMap = itemRateDgRespDtos.stream().collect(Collectors.toMap(ItemRateDgRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            return itemRateDgRespDtoMap;
        }
        return itemRateDgRespDtoMap;
    }
}

