/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.constants.ItemDgType;
import com.yunxi.dg.base.center.item.constants.ItemTypeDgEnum;
import com.yunxi.dg.base.center.item.dao.vo.DgItemSkuRespVo;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemShopSetDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IRItemShopSetDgDomain;
import com.yunxi.dg.base.center.item.dto.entity.ItemShopSetDgPageReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemShopSetDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.RItemShopSetDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShopSetDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.RItemShopSetDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemBundleRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemShopSetDgEo;
import com.yunxi.dg.base.center.item.eo.RItemShopSetDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemShopSetDgService;
import com.yunxi.dg.base.center.item.service.util.StringSplitDgUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemShopSetDgServiceImpl
extends BaseServiceImpl<ItemShopSetDgReqDto, ItemShopSetDgEo, IItemShopSetDgDomain>
implements IItemShopSetDgService {
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IItemShopSetDgDomain itemShopSetDgDomain;
    @Resource
    private IRItemShopSetDgDomain rItemShopSetDgDomain;

    public ItemShopSetDgServiceImpl(IItemShopSetDgDomain domain) {
        super((IBaseDomain)domain);
    }

    @Override
    @Transactional
    public RestResponse<Long> add(ItemShopSetDgReqDto dto) {
        this.getLeastKey(dto);
        ItemShopSetDgEo shopSetDgEo = new ItemShopSetDgEo();
        List existShopSetDgEos = this.itemShopSetDgDomain.selectByLeastKey(dto.getLeastKey());
        AssertUtils.isTrue((boolean)CollectionUtil.isEmpty((Collection)existShopSetDgEos), (String)"\u8be5\u591a\u7248\u672c\u5546\u54c1\u6700\u5c0f\u4e1a\u52a1\u5355\u5143\u914d\u7f6e\u5df2\u5b58\u5728");
        Map<Long, DgItemSkuRespVo> skuMap = this.getItemSkuVoMap(dto);
        List bundleRelationDgEos = this.itemBundleRelationDgDomain.getListBySkuId(Arrays.asList(dto.getSkuId()));
        this.getItemShopSetDgEo(shopSetDgEo, dto, skuMap);
        shopSetDgEo.setId(null);
        this.itemShopSetDgDomain.insert((BaseEo)shopSetDgEo);
        this.addRItemShopSetDgEos(dto.getRItemShopSetDgReqDtos(), skuMap, shopSetDgEo, bundleRelationDgEos);
        return new RestResponse((Object)shopSetDgEo.getId());
    }

    @Override
    @Transactional
    public RestResponse<Void> updateItemShopSet(ItemShopSetDgReqDto dto) {
        this.getLeastKey(dto);
        ItemShopSetDgEo shopSetDgEo = new ItemShopSetDgEo();
        AssertUtils.notNull((Object)dto.getId(), (String)"\u8bf7\u9009\u62e9\u591a\u7248\u672c\u4f18\u5148\u7ea7\u914d\u7f6e!");
        ItemShopSetDgEo existShopSetDgEo = (ItemShopSetDgEo)this.itemShopSetDgDomain.selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)existShopSetDgEo, (String)"\u591a\u7248\u672c\u7279\u6b8a\u4f18\u5148\u7ea7\u914d\u7f6e\u4e0d\u5b58\u5728!");
        List existShopSetDgEos = this.itemShopSetDgDomain.selectByLeastKey(dto.getLeastKey());
        if (CollectionUtil.isNotEmpty((Collection)existShopSetDgEos)) {
            for (ItemShopSetDgEo setDgEo : existShopSetDgEos) {
                AssertUtils.isTrue((boolean)Objects.equals(setDgEo.getId(), dto.getId()), (String)"\u8be5\u591a\u7248\u672c\u5546\u54c1\u6700\u5c0f\u4e1a\u52a1\u5355\u5143\u914d\u7f6e\u5df2\u5b58\u5728");
            }
        }
        Map<Long, DgItemSkuRespVo> skuMap = this.getItemSkuVoMap(dto);
        List bundleRelationDgEos = this.itemBundleRelationDgDomain.getListBySkuId(Arrays.asList(dto.getSkuId()));
        this.getItemShopSetDgEo(shopSetDgEo, dto, skuMap);
        shopSetDgEo.setId(existShopSetDgEo.getId());
        this.itemShopSetDgDomain.updateSelective((BaseEo)shopSetDgEo);
        this.rItemShopSetDgDomain.removeByShopSetIds(Arrays.asList(existShopSetDgEo.getId()));
        this.addRItemShopSetDgEos(dto.getRItemShopSetDgReqDtos(), skuMap, shopSetDgEo, bundleRelationDgEos);
        return RestResponse.VOID;
    }

    @Override
    @Transactional
    public RestResponse<Void> removeByIds(List<Long> ids) {
        if (CollectionUtil.isNotEmpty(ids)) {
            this.itemShopSetDgDomain.logicDeleteByIds(ids);
            this.rItemShopSetDgDomain.removeByShopSetIds(ids);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<ItemShopSetDgRespDto> queryById(Long id) {
        ItemShopSetDgRespDto shopSetDgRespDto = new ItemShopSetDgRespDto();
        ItemShopSetDgEo shopSetDgEo = (ItemShopSetDgEo)this.itemShopSetDgDomain.selectByPrimaryKey(id);
        BeanUtil.copyProperties((Object)shopSetDgEo, (Object)shopSetDgRespDto, (String[])new String[0]);
        List rItemShopSetDgEos = this.rItemShopSetDgDomain.selectByShopSetIds(Arrays.asList(shopSetDgEo.getId()));
        List rItemShopSetDgReqDtos = BeanUtil.copyToList((Collection)rItemShopSetDgEos, RItemShopSetDgRespDto.class);
        shopSetDgRespDto.setRItemShopSetDgReqDtos(rItemShopSetDgReqDtos);
        return new RestResponse((Object)shopSetDgRespDto);
    }

    @Override
    public RestResponse<PageInfo<ItemShopSetDgRespDto>> queryByPage(ItemShopSetDgPageReqDto dto) {
        PageInfo pageInfo = new PageInfo();
        dto = Objects.nonNull(dto) ? dto : new ItemShopSetDgPageReqDto();
        Integer pageNum = Objects.nonNull(dto.getPageNum()) ? dto.getPageNum() : 1;
        Integer pageSize = Objects.nonNull(dto.getPageSize()) ? dto.getPageSize() : 1;
        this.getSkuParam(dto);
        ItemShopSetDgEo queryParam = this.getQueryParam(dto);
        PageInfo eoPageInfo = this.itemShopSetDgDomain.selectPage((BaseEo)queryParam, pageNum, pageSize);
        if (CollectionUtil.isEmpty((Collection)eoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        BeanUtil.copyProperties((Object)eoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List shopSetDgRespDtos = BeanUtil.copyToList((Collection)eoPageInfo.getList(), ItemShopSetDgRespDto.class);
        List setIds = eoPageInfo.getList().stream().map(BaseEo::getId).collect(Collectors.toList());
        List rItemShopSetDgEos = ((ExtQueryChainWrapper)this.rItemShopSetDgDomain.filter().in((Object)"shop_set_id", setIds)).list();
        if (CollectionUtil.isNotEmpty((Collection)rItemShopSetDgEos)) {
            Map<Long, List<RItemShopSetDgEo>> ritemMap = rItemShopSetDgEos.stream().collect(Collectors.groupingBy(RItemShopSetDgEo::getShopSetId));
            for (ItemShopSetDgRespDto shopSetDgRespDto : shopSetDgRespDtos) {
                List<RItemShopSetDgEo> setDgEos = ritemMap.get(shopSetDgRespDto.getId());
                if (!CollectionUtil.isNotEmpty(setDgEos)) continue;
                shopSetDgRespDto.setRItemShopSetDgReqDtos(BeanUtil.copyToList(setDgEos, RItemShopSetDgRespDto.class));
            }
        }
        pageInfo.setList(shopSetDgRespDtos);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    @Transactional
    public RestResponse<Void> removeByItemIds(List<Long> itemIds) {
        if (CollectionUtil.isEmpty(itemIds)) {
            return RestResponse.VOID;
        }
        List shopSetEos = ((ExtQueryChainWrapper)this.itemShopSetDgDomain.filter().in((Object)"item_id", itemIds)).list();
        if (CollectionUtil.isNotEmpty((Collection)shopSetEos)) {
            List setIds = shopSetEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.itemShopSetDgDomain.logicDeleteByIds(setIds);
            this.rItemShopSetDgDomain.removeByShopSetIds(setIds);
        }
        return RestResponse.VOID;
    }

    private ItemShopSetDgEo getQueryParam(ItemShopSetDgPageReqDto dto) {
        ItemShopSetDgEo shopSetDgEo = new ItemShopSetDgEo();
        shopSetDgEo.setDr(0);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (CollectionUtil.isNotEmpty((Collection)dto.getSkuIdList())) {
            sqlFilterList.add(SqlFilter.in((String)"sku_id", (Object)dto.getSkuIdList()));
        }
        if (Objects.nonNull(dto.getChannelId())) {
            sqlFilterList.add(SqlFilter.eq((String)"channel_id", (Object)dto.getChannelId()));
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getChannelIdList())) {
            sqlFilterList.add(SqlFilter.in((String)"channel_id", (Object)dto.getChannelIdList()));
        }
        if (Objects.nonNull(dto.getChannelCode())) {
            sqlFilterList.add(SqlFilter.like((String)"channel_code", (Object)dto.getChannelCode()));
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getChannelCodeList())) {
            sqlFilterList.add(SqlFilter.in((String)"channel_code", (Object)dto.getChannelCodeList()));
        }
        if (Objects.nonNull(dto.getChannelName())) {
            sqlFilterList.add(SqlFilter.like((String)"channel_name", (Object)dto.getChannelName()));
        }
        if (Objects.nonNull(dto.getShopId())) {
            sqlFilterList.add(SqlFilter.eq((String)"shop_id", (Object)dto.getShopId()));
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getShopIds())) {
            sqlFilterList.add(SqlFilter.in((String)"shop_id", (Object)dto.getShopIds()));
        }
        if (Objects.nonNull(dto.getShopCode())) {
            sqlFilterList.add(SqlFilter.like((String)"shop_code", (Object)dto.getShopCode()));
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getShopCodeList())) {
            sqlFilterList.add(SqlFilter.in((String)"shop_code", (Object)dto.getShopCodeList()));
        }
        if (Objects.nonNull(dto.getShopName())) {
            sqlFilterList.add(SqlFilter.like((String)"shop_name", (Object)dto.getShopName()));
        }
        shopSetDgEo.setSqlFilters(sqlFilterList);
        shopSetDgEo.setOrderByDesc("create_time");
        return shopSetDgEo;
    }

    private void getSkuParam(ItemShopSetDgPageReqDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        if (Objects.nonNull(dto.getSkuCode()) || Objects.nonNull(dto.getSkuName()) || Objects.nonNull(dto.getItemName()) || Objects.nonNull(dto.getItemCode()) || CollectionUtil.isNotEmpty((Collection)dto.getSkuCodes())) {
            List dgItemSkuRespVos;
            ItemQueryDgReqDto itemDgReqDto = new ItemQueryDgReqDto();
            itemDgReqDto.setKeyName(dto.getSkuName());
            itemDgReqDto.setQueryType(ItemTypeDgEnum.MULTIPLE.getType());
            List<String> codes = StringSplitDgUtil.splitString(dto.getSkuCode());
            List<String> itemCodes = StringSplitDgUtil.splitString(dto.getItemCode());
            if (codes.size() > 1) {
                itemDgReqDto.setSkuCodes(codes);
            } else {
                itemDgReqDto.setSkuCode(dto.getSkuCode());
            }
            if (itemCodes.size() > 1) {
                itemDgReqDto.setItemCodes(itemCodes);
            } else {
                itemDgReqDto.setItemCode(dto.getItemCode());
            }
            if (Objects.nonNull(dto.getItemName())) {
                itemDgReqDto.setKeyName(dto.getItemName());
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getSkuCodes())) {
                itemDgReqDto.setSkuCodes(dto.getSkuCodes());
            }
            if (CollectionUtil.isNotEmpty((Collection)(dgItemSkuRespVos = this.itemSkuDgDomain.queryItemSkuList(itemDgReqDto)))) {
                List skuIds = dgItemSkuRespVos.stream().map(DgItemSkuRespVo::getId).collect(Collectors.toList());
                dto.setSkuIdList(skuIds);
            }
        }
    }

    private void getItemShopSetDgEo(ItemShopSetDgEo shopSetDgEo, ItemShopSetDgReqDto dto, Map<Long, DgItemSkuRespVo> skuMap) {
        DgItemSkuRespVo dgItemSkuRespVo = skuMap.get(dto.getSkuId());
        AssertUtils.notEmpty((Object)dgItemSkuRespVo, (String)"\u591a\u7248\u672c\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!");
        AssertUtils.isTrue((boolean)ItemDgType.MULTIPLE.getIndex().equals(dgItemSkuRespVo.getItemType()), (String)"\u975e\u591a\u7248\u672c\u5546\u54c1\u4e0d\u53ef\u64cd\u4f5c!");
        BeanUtil.copyProperties((Object)dto, (Object)shopSetDgEo, (String[])new String[0]);
        shopSetDgEo.setItemId(dgItemSkuRespVo.getItemId());
        shopSetDgEo.setItemName(dgItemSkuRespVo.getItemName());
        shopSetDgEo.setItemCode(dgItemSkuRespVo.getItemCode());
        shopSetDgEo.setSkuCode(dgItemSkuRespVo.getSkuCode());
        shopSetDgEo.setSkuName(dgItemSkuRespVo.getSkuName());
    }

    private Map<Long, DgItemSkuRespVo> getItemSkuVoMap(ItemShopSetDgReqDto dto) {
        List rItemShopSetDgReqDtos = dto.getRItemShopSetDgReqDtos();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        skuIds.add(dto.getSkuId());
        skuIds.addAll(rItemShopSetDgReqDtos.stream().map(RItemShopSetDgReqDto::getSkuId).collect(Collectors.toList()));
        ItemQueryDgReqDto itemDgReqDto = new ItemQueryDgReqDto();
        itemDgReqDto.setSkuIds(skuIds);
        List dgItemSkuRespVos = this.itemSkuDgDomain.queryItemSkuList(itemDgReqDto);
        AssertUtils.notEmpty((Collection)dgItemSkuRespVos, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!");
        Map<Long, DgItemSkuRespVo> skuMap = dgItemSkuRespVos.stream().collect(Collectors.toMap(DgItemSkuRespVo::getId, Function.identity(), (k1, k2) -> k2));
        return skuMap;
    }

    private void addRItemShopSetDgEos(List<RItemShopSetDgReqDto> rItemShopSetDgReqDtos, Map<Long, DgItemSkuRespVo> skuMap, ItemShopSetDgEo shopSetDgEo, List<ItemBundleRelationDgEo> bundleRelationDgEos) {
        Set<Object> bundleSkuIds = new HashSet();
        if (CollectionUtil.isNotEmpty(bundleRelationDgEos)) {
            bundleSkuIds = bundleRelationDgEos.stream().map(ItemBundleRelationDgEo::getSubSkuId).collect(Collectors.toSet());
        }
        ArrayList<RItemShopSetDgEo> rItemShopSetDgEos = new ArrayList<RItemShopSetDgEo>();
        HashSet<Integer> levelSet = new HashSet<Integer>();
        for (RItemShopSetDgReqDto rItemShopSetDgReqDto : rItemShopSetDgReqDtos) {
            DgItemSkuRespVo skuRespVo = skuMap.get(rItemShopSetDgReqDto.getSkuId());
            AssertUtils.notEmpty((Object)skuRespVo, (String)("\u591a\u7248\u672c\u5b50\u5546\u54c1" + rItemShopSetDgReqDto.getSkuId() + "\u4fe1\u606f\u4e0d\u5b58\u5728!"));
            AssertUtils.isFalse((boolean)levelSet.contains(rItemShopSetDgReqDto.getLevel()), (String)"\u51fa\u5e93\u4f18\u5148\u7ea7\u4e0d\u53ef\u91cd\u590d!");
            AssertUtils.isTrue((boolean)bundleSkuIds.contains(rItemShopSetDgReqDto.getSkuId()), (String)(rItemShopSetDgReqDto.getSkuId() + "\u4e0d\u662f\u591a\u7248\u672c\u7684\u5b50\u5546\u54c1"));
            RItemShopSetDgEo rItemShopSetDgEo = new RItemShopSetDgEo();
            BeanUtil.copyProperties((Object)rItemShopSetDgReqDto, (Object)rItemShopSetDgEo, (String[])new String[0]);
            rItemShopSetDgEo.setId(null);
            rItemShopSetDgEo.setShopSetId(shopSetDgEo.getId());
            rItemShopSetDgEo.setSkuName(skuRespVo.getSkuName());
            rItemShopSetDgEo.setSkuCode(skuRespVo.getSkuCode());
            rItemShopSetDgEo.setItemId(skuRespVo.getItemId());
            rItemShopSetDgEo.setItemCode(skuRespVo.getItemCode());
            rItemShopSetDgEo.setItemName(skuRespVo.getItemName());
            rItemShopSetDgEo.setSubType(skuRespVo.getSubType());
            rItemShopSetDgEos.add(rItemShopSetDgEo);
            levelSet.add(rItemShopSetDgReqDto.getLevel());
        }
        this.rItemShopSetDgDomain.insertBatch(rItemShopSetDgEos);
    }

    private void getLeastKey(ItemShopSetDgReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getSkuId(), (String)"\u591a\u7248\u672cskuId\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getChannelCode(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notEmpty((Collection)dto.getRItemShopSetDgReqDtos(), (String)"\u7279\u6b8a\u4f18\u5148\u7ea7\u914d\u7f6e\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a!");
        for (RItemShopSetDgReqDto rItemShopSetDgReqDto : dto.getRItemShopSetDgReqDtos()) {
            AssertUtils.notNull((Object)rItemShopSetDgReqDto.getSkuId(), (String)"\u5546\u54c1skuId\u4e0d\u53ef\u4e3a\u7a7a!");
            AssertUtils.notNull((Object)rItemShopSetDgReqDto.getLevel(), (String)"\u9ed8\u8ba4\u51fa\u5e93\u4f18\u5148\u7ea7\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        String leastKey = "";
        leastKey = leastKey + dto.getSkuId() + dto.getChannelCode();
        leastKey = Objects.nonNull(dto.getShopId()) ? leastKey + dto.getShopId() : leastKey;
        dto.setLeastKey(leastKey);
    }
}

