/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemTagRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.ITagDgDomain;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemTagRelationDgEo;
import com.yunxi.dg.base.center.item.eo.TagDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IItemTagDgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemTagDgServiceImpl
implements IItemTagDgService {
    private static Logger logger = LoggerFactory.getLogger(ItemTagDgServiceImpl.class);
    @Resource
    private IItemTagRelationDgDomain itemTagRelationDgDomain;
    @Resource
    private ITagDgDomain tagDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int addTagBatch(List<TagDgEo> tagDgEos) {
        return this.tagDgDomain.insertBatch(tagDgEos);
    }

    @Override
    public Long addTag(TagDgEo tagDgEo) {
        this.tagDgDomain.insert((BaseEo)tagDgEo);
        return tagDgEo.getId();
    }

    @Override
    public void modifyTag(TagDgEo tagDgEo) {
        if (null == tagDgEo.getId()) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        TagDgEo exists = (TagDgEo)this.tagDgDomain.selectByPrimaryKey(tagDgEo.getId());
        if (exists == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_TAG);
        }
        this.tagDgDomain.updateSelective((BaseEo)tagDgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTag(Long id) {
        this.tagDgDomain.logicDeleteById(id);
        ItemTagRelationDgEo exam = ItemTagRelationDgEo.newInstance();
        exam.setTagId(id);
        List itemTagEos = this.itemTagRelationDgDomain.selectList((BaseEo)exam);
        for (ItemTagRelationDgEo itemTagEo : itemTagEos) {
            this.itemTagRelationDgDomain.logicDeleteById(itemTagEo.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(String ids) {
        String[] idList;
        for (String id : idList = StringUtils.split((String)ids, (String)",")) {
            this.removeTag(Long.valueOf(id));
        }
    }

    @Override
    public void removeByItemId(Long itemId) {
        if (Objects.nonNull(itemId)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.eq((String)"item_id", (Object)itemId));
            TagDgEo tagDgEo = TagDgEo.newInstance();
            tagDgEo.setSqlFilters(sqlFilters);
            this.tagDgDomain.logicDelete((BaseEo)tagDgEo);
        }
    }

    @Override
    public void removeBySkuId(Long skuId) {
        if (Objects.nonNull(skuId)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.eq((String)"sku_id", (Object)skuId));
            TagDgEo tagDgEo = TagDgEo.newInstance();
            tagDgEo.setSqlFilters(sqlFilters);
            this.tagDgDomain.logicDelete((BaseEo)tagDgEo);
        }
    }

    @Override
    public PageInfo<TagDgEo> queryByPage(TagDgEo tagDgEo, Integer pageNumber, Integer pageSize) {
        return this.tagDgDomain.selectPage((BaseEo)tagDgEo, pageNumber, pageSize);
    }

    @Override
    public TagDgEo queryById(Long id) {
        return (TagDgEo)this.tagDgDomain.selectByPrimaryKey(id);
    }

    @Override
    public List<TagDgEo> queryItemTagByItemId(Long itemId) {
        ItemTagRelationDgEo itemTagEo = ItemTagRelationDgEo.newInstance();
        itemTagEo.setItemId(itemId);
        List itemTagEos = this.itemTagRelationDgDomain.selectList((BaseEo)itemTagEo);
        if (CollectionUtils.isEmpty((Collection)itemTagEos)) {
            return Lists.newArrayList();
        }
        List tagIds = itemTagEos.stream().map(ItemTagRelationDgEo::getTagId).collect(Collectors.toList());
        TagDgEo example = TagDgEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(tagIds, (String)",")));
        example.setSqlFilters(sqlFilters);
        return this.tagDgDomain.selectList((BaseEo)example);
    }

    @Override
    public List<ItemTagRelationDgEo> queryItemTag(String tagIds, Long tenantId, Long instanceId) {
        ItemTagRelationDgEo itemTagEo = ItemTagRelationDgEo.newInstance();
        itemTagEo.setOrderBy("id");
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"tag_id", (Object)tagIds));
        itemTagEo.setSqlFilters(filters);
        itemTagEo.setInstanceId(instanceId);
        itemTagEo.setTenantId(tenantId);
        return this.itemTagRelationDgDomain.selectList((BaseEo)itemTagEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void relateToItem(List<ItemTagRelationDgEo> itemTagEos) {
        ArrayList<ItemTagRelationDgEo> insertList = new ArrayList<ItemTagRelationDgEo>();
        for (ItemTagRelationDgEo itemTagEo : itemTagEos) {
            List tagEos = this.itemTagRelationDgDomain.selectList((BaseEo)itemTagEo);
            if (CollectionUtils.isNotEmpty((Collection)tagEos)) continue;
            ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemTagEo.getItemId());
            if (null == itemDgEo) {
                logger.info(ItemExceptionCode.NON_EXIST_ITEM.getCode() + "\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)ItemExceptionCode.NON_EXIST_ITEM.getMsg());
                continue;
            }
            TagDgEo tagDgEo = (TagDgEo)this.tagDgDomain.selectByPrimaryKey(itemTagEo.getTagId());
            if (null == tagDgEo) {
                logger.info(ItemExceptionCode.NON_EXIST_TAG.getCode() + "\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)ItemExceptionCode.NON_EXIST_TAG.getMsg());
                continue;
            }
            insertList.add(itemTagEo);
        }
        this.itemTagRelationDgDomain.insertBatch(insertList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRelation(List<ItemTagRelationDgEo> itemTagEos) {
        for (ItemTagRelationDgEo itemTagEo : itemTagEos) {
            this.itemTagRelationDgDomain.logicDelete((BaseEo)itemTagEo);
        }
    }
}

