/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.constants.UnitTypeDgEnum;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemUnitConversionDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IUnitDgDomain;
import com.yunxi.dg.base.center.item.dto.request.UnitDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.UnitImportDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.UnitPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.center.item.eo.UnitDgEo;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IUnitDgService;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="unitDgService")
public class UnitDgServiceImpl
implements IUnitDgService {
    private static Logger logger = LoggerFactory.getLogger(UnitDgServiceImpl.class);
    @Resource
    private IUnitDgDomain unitDgDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IItemUnitConversionDgDomain itemUnitConversionDgDomain;
    @Resource
    private IContext context;
    @Resource
    protected ILockService lockService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addUnit(UnitDgReqDto reqDto) {
        UnitDgEo unitDgEo = UnitDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)unitDgEo);
        Mutex lock = null;
        this.checkUnitCode(unitDgEo.getCode(), unitDgEo.getInstanceId(), unitDgEo.getTenantId(), null);
        try {
            this.checkUnitCode(unitDgEo.getCode(), unitDgEo.getInstanceId(), unitDgEo.getTenantId(), null);
            lock = this.lockService.lock("ITEM_UNIT_CODE_CACHE_KEY", "ITEM_UNIT_CODE_CACHE_LOCK_KEY", 10, 10, TimeUnit.SECONDS);
            this.unitDgDomain.insert((BaseEo)unitDgEo);
        }
        catch (Exception e) {
            try {
                logger.error("\u5355\u4f4d\u65b0\u589e \u5904\u7406\u5f02\u5e38 {}", (Object)e.getMessage());
                throw new BizException("\u5355\u4f4d\u65b0\u589e\u5931\u8d25");
            }
            catch (Throwable throwable) {
                if (Objects.nonNull(lock)) {
                    this.lockService.unlock(lock);
                }
                throw throwable;
            }
        }
        if (Objects.nonNull(lock)) {
            this.lockService.unlock(lock);
        }
        return unitDgEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyUnit(UnitDgReqDto reqDto) {
        UnitDgEo unitDgEo = (UnitDgEo)this.unitDgDomain.selectByPrimaryKey(reqDto.getId());
        if (unitDgEo == null) {
            throw new BizException(ItemExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        this.checkUnitCode(reqDto.getCode(), unitDgEo.getInstanceId(), unitDgEo.getTenantId(), unitDgEo.getId());
        Mutex lock = null;
        try {
            this.checkUnitCode(reqDto.getCode(), unitDgEo.getInstanceId(), unitDgEo.getTenantId(), unitDgEo.getId());
            lock = this.lockService.lock("ITEM_UNIT_CODE_CACHE_KEY", "ITEM_UNIT_CODE_CACHE_LOCK_KEY", 10, 10, TimeUnit.SECONDS);
            if (!unitDgEo.getCode().equals(reqDto.getCode())) {
                // empty if block
            }
            DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)unitDgEo);
            this.unitDgDomain.updateSelective((BaseEo)unitDgEo);
        }
        catch (Exception e) {
            try {
                logger.error("\u5355\u4f4d\u65b0\u589e \u5904\u7406\u5f02\u5e38 {}", (Object)e.getMessage());
                throw new BizException("\u5355\u4f4d\u65b0\u589e\u5931\u8d25");
            }
            catch (Throwable throwable) {
                if (Objects.nonNull(lock)) {
                    this.lockService.unlock(lock);
                }
                throw throwable;
            }
        }
        if (Objects.nonNull(lock)) {
            this.lockService.unlock(lock);
        }
    }

    @Override
    public void modifyStatus(Long id, Integer status) {
        UnitDgEo unitDgEo = UnitDgEo.newInstance();
        unitDgEo.setId(id);
        unitDgEo.setStatus(status);
        this.unitDgDomain.updateSelective((BaseEo)unitDgEo);
    }

    @Override
    public void removeById(List<Long> ids) {
        List unitDgEos = this.unitDgDomain.selectByIds(ids);
        AssertUtils.notEmpty((Collection)unitDgEos, (String)"\u5355\u4f4d\u4fe1\u606f\u4e0d\u5b58\u5728");
        List unitCodes = unitDgEos.stream().map(UnitDgEo::getCode).collect(Collectors.toList());
        Integer count = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().and(o -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)o.in((Object)"unit", (Collection)unitCodes)).or()).in((Object)"sale_unit", (Collection)unitCodes)).or()).in((Object)"price_unit", (Collection)unitCodes);
        })).count();
        AssertUtils.isTrue((count < 1 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u88ab\u5546\u54c1\u4fe1\u606f\u5f15\u7528\u4e0d\u53ef\u4ee5\u5220\u9664");
        Integer count1 = ((ExtQueryChainWrapper)this.itemUnitConversionDgDomain.filter().and(o -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)o.in((Object)"base_unit", (Collection)unitCodes)).or()).in((Object)"conversion_unit", (Collection)unitCodes);
        })).count();
        AssertUtils.isTrue((count1 < 1 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u88ab\u5546\u54c1\u8f85\u8ba1\u91cf\u5355\u4f4d\u5f15\u7528\u4e0d\u53ef\u4ee5\u5220\u9664");
        this.unitDgDomain.logicDeleteByIds(ids);
    }

    @Override
    public UnitDgRespDto queryById(Long id) {
        UnitDgEo unitDgEo = (UnitDgEo)this.unitDgDomain.selectByPrimaryKey(id);
        UnitDgRespDto unitDgRespDto = new UnitDgRespDto();
        DtoHelper.eo2Dto((BaseEo)unitDgEo, (BaseVo)unitDgRespDto);
        return unitDgRespDto;
    }

    @Override
    public PageInfo<UnitDgRespDto> queryByPage(UnitPageDgReqDto dto) {
        List sqlFilters;
        UnitDgEo unitDgEo = UnitDgEo.newInstance((Map)dto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)unitDgEo);
        QueryParamDgUtils.columnLike((BaseEo)unitDgEo, "code", unitDgEo.getCode());
        QueryParamDgUtils.columnLike((BaseEo)unitDgEo, "external_code", unitDgEo.getExternalCode());
        QueryParamDgUtils.columnLike((BaseEo)unitDgEo, "name", unitDgEo.getName());
        QueryParamDgUtils.fillQueryCreateStartTime(dto.getCreateStartTime(), (BaseEo)unitDgEo);
        QueryParamDgUtils.fillQueryCreateEndTime(dto.getCreateEndTime(), (BaseEo)unitDgEo);
        QueryParamDgUtils.fillQueryUpdateStartTime(dto.getUpdateStartTime(), (BaseEo)unitDgEo);
        QueryParamDgUtils.fillQueryUpdateEndTime(dto.getUpdateEndTime(), (BaseEo)unitDgEo);
        List list = sqlFilters = CollectionUtil.isNotEmpty((Collection)unitDgEo.getSqlFilters()) ? unitDgEo.getSqlFilters() : new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)dto.getCodeList())) {
            sqlFilters.add(SqlFilter.in((String)"code", (Object)dto.getCodeList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getExternalCodeList())) {
            sqlFilters.add(SqlFilter.in((String)"external_code", (Object)dto.getExternalCodeList()));
        }
        unitDgEo.setSqlFilters(sqlFilters);
        if (StringUtils.isBlank((CharSequence)unitDgEo.getOrderByDesc())) {
            unitDgEo.setOrderByDesc("update_time");
        }
        Integer pageNum = Objects.nonNull(dto.getPageNum()) ? dto.getPageNum() : 1;
        Integer pageSize = Objects.nonNull(dto.getPageSize()) ? dto.getPageSize() : 10;
        PageInfo unitEoPageInfo = this.unitDgDomain.selectPage((BaseEo)unitDgEo, pageNum, pageSize);
        ArrayList list2 = Lists.newArrayList();
        PageInfo pageInfo = new PageInfo((List)list2);
        DtoHelper.eoList2DtoList((Collection)unitEoPageInfo.getList(), (Collection)list2, UnitDgRespDto.class);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)unitEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList((List)list2);
        return pageInfo;
    }

    @Override
    public List<UnitDgRespDto> queryList(UnitDgReqDto dto) {
        UnitDgEo unitDgEo = UnitDgEo.newInstance((Map)dto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)unitDgEo);
        unitDgEo.setDr(0);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (Objects.nonNull(dto.getCode())) {
            sqlFilterList.add(SqlFilter.like((String)"code", (Object)dto.getCode()));
        }
        if (Objects.nonNull(dto.getExternalCode())) {
            sqlFilterList.add(SqlFilter.like((String)"external_code", (Object)dto.getExternalCode()));
        }
        if (Objects.nonNull(dto.getName())) {
            sqlFilterList.add(SqlFilter.like((String)"name", (Object)dto.getName()));
        }
        if (Objects.nonNull(dto.getUpdateTimeStart())) {
            sqlFilterList.add(SqlFilter.ge((String)"update_time", (Object)dto.getUpdateTimeStart()));
        }
        if (Objects.nonNull(dto.getUpdateTimeEnd())) {
            sqlFilterList.add(SqlFilter.le((String)"update_time", (Object)dto.getUpdateTimeEnd()));
        }
        if (StringUtils.isBlank((CharSequence)unitDgEo.getOrderByDesc())) {
            unitDgEo.setOrderByDesc("update_time");
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getCodeList())) {
            sqlFilterList.add(SqlFilter.in((String)"code", (Object)dto.getCodeList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getExternalCodeList())) {
            sqlFilterList.add(SqlFilter.in((String)"external_code", (Object)dto.getExternalCodeList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getNameList())) {
            sqlFilterList.add(SqlFilter.in((String)"name", (Object)dto.getNameList()));
        }
        unitDgEo.setSqlFilters(sqlFilterList);
        List unitDgEoList = this.unitDgDomain.selectList((BaseEo)unitDgEo, Integer.valueOf(1), Integer.valueOf(10000));
        ArrayList res = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)unitDgEoList, (Collection)res, UnitDgRespDto.class);
        return res;
    }

    @Override
    public List<UnitDgRespDto> queryByType(String type) {
        UnitDgEo unitDgEo = UnitDgEo.newInstance();
        unitDgEo.setType(type);
        unitDgEo.setStatus(Integer.valueOf(1));
        unitDgEo.setTenantId(this.context.tenantId());
        unitDgEo.setInstanceId(this.context.instanceId());
        List unitDgEos = this.unitDgDomain.selectList((BaseEo)unitDgEo);
        ArrayList<UnitDgRespDto> unitDgRespDtoList = new ArrayList<UnitDgRespDto>();
        DtoHelper.eoList2DtoList((Collection)unitDgEos, unitDgRespDtoList, UnitDgRespDto.class);
        return unitDgRespDtoList;
    }

    @Override
    public List<UnitTypeDgEnum> queryUnitType() {
        List<UnitTypeDgEnum> res = Arrays.stream(UnitTypeDgEnum.values()).collect(Collectors.toList());
        return res;
    }

    @Override
    public List<UnitDgRespDto> queryByIds(List<Long> ids) {
        UnitDgEo unitDgEo = UnitDgEo.newInstance();
        unitDgEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        unitDgEo.setSqlFilters((List)sqlFilters);
        List unitDgEoList = this.unitDgDomain.selectList((BaseEo)unitDgEo);
        ArrayList unitDgRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)unitDgEoList, (Collection)unitDgRespDtoList, UnitDgRespDto.class);
        return unitDgRespDtoList;
    }

    @Override
    public UnitDgRespDto queryByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        UnitDgEo unitDgEo = new UnitDgEo();
        unitDgEo.setCode(code);
        unitDgEo = (UnitDgEo)this.unitDgDomain.selectOne((BaseEo)unitDgEo);
        if (unitDgEo == null) {
            return null;
        }
        UnitDgRespDto unitDgRespDto = new UnitDgRespDto();
        DtoHelper.eo2Dto((BaseEo)unitDgEo, (BaseVo)unitDgRespDto);
        return unitDgRespDto;
    }

    @Override
    public List<UnitDgRespDto> queryByCodes(List<String> codes) {
        if (CollectionUtil.isNotEmpty(codes)) {
            UnitDgEo selectEo = UnitDgEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"code", codes));
            selectEo.setSqlFilters(sqlFilterList);
            List list = this.unitDgDomain.selectList((BaseEo)selectEo, Integer.valueOf(1), Integer.valueOf(codes.size()));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList<UnitDgRespDto> dtos = new ArrayList<UnitDgRespDto>();
                DtoHelper.eoList2DtoList((Collection)list, dtos, UnitDgRespDto.class);
                return dtos;
            }
        }
        return null;
    }

    @Override
    public void batchModifyStatus(List<Long> ids, Integer status) {
        this.unitDgDomain.batchUpdateStatus(ids, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importInsertBatch(UnitImportDgReqDto dto) {
        ArrayList unitDgEos = Lists.newArrayList();
        ArrayList<UnitDgEo> insertUnitDgEos = new ArrayList<UnitDgEo>();
        List unitDgReqDtos = dto.getUnitDgReqDtos();
        if (CollectionUtil.isEmpty((Collection)unitDgReqDtos)) {
            return;
        }
        Map unitDtoMap = unitDgReqDtos.stream().collect(Collectors.toMap(UnitDgReqDto::getCode, Function.identity(), (k1, k2) -> k2));
        DtoHelper.dtoList2EoList(unitDtoMap.values(), (Collection)unitDgEos, UnitDgEo.class);
        ArrayList codeList = Lists.newArrayList(unitDtoMap.keySet());
        Mutex lock = null;
        try {
            lock = this.lockService.lock("ITEM_UNIT_CODE_CACHE_KEY", "ITEM_UNIT_CODE_CACHE_LOCK_KEY", 10, 10, TimeUnit.SECONDS);
            List unitDgEoList = this.unitDgDomain.queryByUnitDgEos((List)codeList);
            Map<Object, Object> unitMap = new HashMap();
            if (CollectionUtil.isNotEmpty((Collection)unitDgEoList)) {
                unitMap = unitDgEoList.stream().collect(Collectors.toMap(UnitDgEo::getCode, Function.identity(), (k1, k2) -> k2));
            }
            for (UnitDgEo unitDgEo : unitDgEos) {
                UnitDgEo dgEo = (UnitDgEo)unitMap.get(unitDgEo.getCode());
                if (Objects.nonNull(dgEo)) {
                    unitDgEo.setId(dgEo.getId());
                    this.unitDgDomain.updateSelective((BaseEo)unitDgEo);
                    continue;
                }
                insertUnitDgEos.add(unitDgEo);
            }
            this.unitDgDomain.insertBatch(insertUnitDgEos);
        }
        catch (Exception e) {
            logger.error("\u5355\u4f4d\u65b0\u589e \u5904\u7406\u5f02\u5e38 {}", (Object)e.getMessage());
            throw new BizException("\u5355\u4f4d\u65b0\u589e\u5931\u8d25");
        }
        finally {
            if (Objects.nonNull(lock)) {
                this.lockService.unlock(lock);
            }
        }
    }

    private void batchCheckUnitCode(List<String> codeList) {
        if (this.unitDgDomain.countCodesExist(codeList) > 0L) {
            throw new BizException(ItemExceptionCode.CODE_EXISTS.getMsg());
        }
    }

    private void checkUnitCode(String code, Long instanceId, Long tenantId, Long id) {
        UnitDgEo unitDgEo = new UnitDgEo();
        unitDgEo.setCode(code);
        unitDgEo.setInstanceId(instanceId);
        unitDgEo.setTenantId(tenantId);
        List unitDgEos = this.unitDgDomain.selectList((BaseEo)unitDgEo);
        if (Objects.isNull(id) && CollectionUtil.isNotEmpty((Collection)unitDgEos) || Objects.nonNull(id) && CollectionUtil.isNotEmpty((Collection)unitDgEos) && !((UnitDgEo)unitDgEos.get(0)).getId().equals(id)) {
            throw new BizException(ItemExceptionCode.CODE_EXISTS.getMsg());
        }
    }
}

