/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.constants.ItemDgItemAttributeEnum;
import com.yunxi.dg.base.center.item.constants.ItemMediaBizTypeEnum;
import com.yunxi.dg.base.center.item.constants.ItemMediaItemTypeEnum;
import com.yunxi.dg.base.center.item.constants.SkuItemMarketStatusEnum;
import com.yunxi.dg.base.center.item.dao.das.ItemSkuDgDas;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemMediasDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISerialCodeDomain;
import com.yunxi.dg.base.center.item.dto.request.AccessoryItemReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemMediasDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSkuStatusDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.AccessoryItemRespDto;
import com.yunxi.dg.base.center.item.dto.response.BatchOptRespDto;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemMediasDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.SerialCodeEo;
import com.yunxi.dg.base.center.item.service.entity.IAccessoryItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemMediasDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccessoryItemDgServiceImpl
implements IAccessoryItemDgService {
    private static final Logger log = LoggerFactory.getLogger(AccessoryItemDgServiceImpl.class);
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Resource
    private ItemSkuDgDas itemSkuDgDas;
    @Resource
    private IItemSkuDgDomain iItemSkuDgDomain;
    @Resource
    private IItemMediasDgDomain itemMediasDgDomain;
    @Resource
    private IItemMediasDgService itemMediasDgService;
    @Resource
    private ISerialCodeDomain serialCodeDomain;
    @Resource
    private IItemDgDomain itemDgDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItem(AccessoryItemRespDto dto) {
        log.info("\u65b0\u589e\u914d\u4ef6\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        ItemDgEo itemDgEo = ItemDgEo.newInstance();
        ItemDgEo oldItemDgEo = this.itemDgDomain.selectByItemCode(dto.getSkuCode());
        AssertUtils.isNull((Object)oldItemDgEo, (String)"\u8be5\u5546\u54c1sku\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (Objects.isNull(oldItemDgEo)) {
            this.initItemEo(dto, itemDgEo);
            this.itemDgDomain.insert((BaseEo)itemDgEo);
        } else {
            itemDgEo = oldItemDgEo;
            this.itemDgDomain.updateSelective((BaseEo)itemDgEo);
        }
        ItemSkuDgEo itemSkuDgEo = new ItemSkuDgEo();
        BeanUtil.copyProperties((Object)dto, (Object)itemSkuDgEo, (String[])new String[0]);
        itemSkuDgEo.setItemId(itemDgEo.getId());
        itemSkuDgEo.setUnit("PCS");
        itemSkuDgEo.setPriceUnit("PCS");
        itemSkuDgEo.setSaleUnit("PCS");
        itemSkuDgEo.setCode(dto.getSkuCode());
        itemSkuDgEo.setName(dto.getSkuName());
        itemSkuDgEo.setRetailPrice(dto.getPrice());
        itemSkuDgEo.setVersion(Long.valueOf(1L));
        itemSkuDgEo.setMarketStatus(SkuItemMarketStatusEnum.MARKET_STATUS_AWAIT.getStatus());
        this.iItemSkuDgDomain.insert((BaseEo)itemSkuDgEo);
        List medias = dto.getMedias();
        if (CollectionUtil.isNotEmpty((Collection)medias)) {
            for (ItemMediasDgReqDto media : medias) {
                Integer fileType = Objects.equals(1, media.getFileType()) ? media.getFileType() : 0;
                media.setFileType(fileType);
                media.setItemType(ItemMediaItemTypeEnum.SKU.getType());
                media.setBizType(ItemMediaBizTypeEnum.MAIN_IMAGE.getType());
            }
        }
        this.addItemMedias(itemDgEo.getId(), medias, itemSkuDgEo);
        return itemSkuDgEo.getId();
    }

    private void addItemMedias(Long itemId, List<ItemMediasDgReqDto> medias, ItemSkuDgEo itemSkuDgEo) {
        ArrayList mediasEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(medias)) {
            for (ItemMediasDgReqDto itemMediasDto : medias) {
                AssertUtils.notNull((Object)itemMediasDto.getPath1(), (String)"\u5546\u54c1sku\u56fe\u7247url\u4e0d\u53ef\u4e3a\u7a7a!");
                ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance((Map)itemMediasDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)itemMediasDto, (BaseEo)itemMediasDgEo);
                itemMediasDgEo.setId(null);
                itemMediasDgEo.setItemId(itemId);
                itemMediasDgEo.setSkuId(itemSkuDgEo.getId());
                if (null != itemSkuDgEo && null != itemSkuDgEo.getId()) {
                    itemMediasDgEo.setSkuId(itemSkuDgEo.getId());
                }
                mediasEos.add(itemMediasDgEo);
            }
        }
        this.itemMediasDgService.addBatchItemMedias(mediasEos);
    }

    private void initItemEo(AccessoryItemRespDto dto, ItemDgEo itemDgEo) {
        Long version = Objects.nonNull(itemDgEo) && Objects.nonNull(itemDgEo.getVersion()) ? itemDgEo.getVersion() : 1L;
        itemDgEo.setCode(dto.getSkuCode());
        itemDgEo.setName(dto.getSkuName());
        itemDgEo.setItemAttribute(ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_MOUNTINGS.getType());
        itemDgEo.setVersion(version);
        itemDgEo.setStatus(dto.getStatus());
        itemDgEo.setType(Integer.valueOf(1));
        itemDgEo.setType(Integer.valueOf(1));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateItem(AccessoryItemRespDto dto) {
        log.info("\u66f4\u65b0\u914d\u4ef6\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)ObjectUtil.isNotNull((Object)dto.getId()), (String)"\u914d\u4ef6\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)this.iItemSkuDgDomain.selectById((Serializable)dto.getId());
        AssertUtils.notNull((Object)itemSkuDgEo, (String)"\u914d\u4ef6\u5546\u54c1\u4e3a\u7a7a");
        List medias = dto.getMedias();
        if (CollectionUtil.isNotEmpty((Collection)medias)) {
            for (ItemMediasDgReqDto media : medias) {
                Integer fileType = Objects.equals(1, media.getFileType()) ? media.getFileType() : 0;
                media.setFileType(fileType);
                media.setItemType(ItemMediaItemTypeEnum.SKU.getType());
                media.setBizType(ItemMediaBizTypeEnum.MAIN_IMAGE.getType());
            }
        }
        HashSet<Long> ids = new HashSet<Long>();
        ids.add(itemSkuDgEo.getId());
        BeanUtil.copyProperties((Object)dto, (Object)itemSkuDgEo, (String[])new String[0]);
        itemSkuDgEo.setCode(dto.getSkuCode());
        itemSkuDgEo.setName(dto.getSkuName());
        itemSkuDgEo.setRetailPrice(dto.getPrice());
        this.iItemSkuDgDomain.update((BaseEo)itemSkuDgEo);
        this.itemMediasDgService.removeItemMediasBySkuIds(ids);
        this.addItemMedias(itemSkuDgEo.getItemId(), medias, itemSkuDgEo);
    }

    @Override
    public void removeItemSku(List<Long> ids) {
        this.itemSkuDgService.removeItemSku(ids);
    }

    @Override
    public BatchOptRespDto batchChangeStatus(ItemSkuStatusDgReqDto skuStatusDgReqDto) {
        return this.itemSkuDgService.batchChangeStatus(skuStatusDgReqDto);
    }

    @Override
    public PageInfo<AccessoryItemRespDto> queryPage(AccessoryItemReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new PageInfo(this.queryList(reqDto));
    }

    @Override
    public List<AccessoryItemRespDto> queryList(AccessoryItemReqDto reqDto) {
        List list = this.iItemSkuDgDomain.queryAccessoryItemList(reqDto);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return list;
        }
        this.setSerialName(list);
        this.setMedias(list);
        return list;
    }

    @Override
    public AccessoryItemRespDto getDetail(Long id) {
        AssertUtils.isTrue((boolean)ObjectUtil.isNotNull((Object)id), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)this.iItemSkuDgDomain.selectById((Serializable)id);
        AssertUtils.notNull((Object)itemSkuDgEo, (String)"\u914d\u4ef6\u5546\u54c1\u4e3a\u7a7a");
        AccessoryItemRespDto respDto = new AccessoryItemRespDto();
        BeanUtil.copyProperties((Object)itemSkuDgEo, (Object)respDto, (String[])new String[0]);
        respDto.setSkuCode(itemSkuDgEo.getCode());
        respDto.setSkuName(itemSkuDgEo.getName());
        respDto.setStatus(itemSkuDgEo.getSubStatus());
        respDto.setBaseUnit(itemSkuDgEo.getUnit());
        respDto.setPrice(itemSkuDgEo.getRetailPrice());
        respDto.setType(ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_MOUNTINGS.getType());
        List<AccessoryItemRespDto> list = Arrays.asList(respDto);
        this.setMainItemInfo(respDto);
        this.setSerialName(list);
        this.setMedias(list);
        return respDto;
    }

    private void setMainItemInfo(AccessoryItemRespDto respDto) {
        if (StringUtils.isBlank((CharSequence)respDto.getMainCode())) {
            this.setDefaultNull(respDto);
            return;
        }
        List mainItemList = this.iItemSkuDgDomain.selectItemSkuByCodes(Arrays.asList(respDto.getMainCode()));
        if (CollectionUtil.isEmpty((Collection)mainItemList)) {
            this.setDefaultNull(respDto);
            return;
        }
        ItemSkuDgEo mainItem = (ItemSkuDgEo)mainItemList.get(0);
        if (ObjectUtil.isNotNull((Object)mainItem)) {
            respDto.setMainName(mainItem.getName());
            respDto.setBrandId(mainItem.getBrandId());
            respDto.setBrand(mainItem.getBrand());
            respDto.setDepartment(mainItem.getDepartment());
            respDto.setDepartmentCode(mainItem.getDepartmentCode());
            respDto.setSerialCode(mainItem.getSerialCode());
            respDto.setSerialId(mainItem.getSerialId());
        }
    }

    private void setDefaultNull(AccessoryItemRespDto respDto) {
        respDto.setMainCode(null);
        respDto.setMainName(null);
        respDto.setBrandId(null);
        respDto.setBrand(null);
        respDto.setDepartment(null);
        respDto.setDepartmentCode(null);
        respDto.setSerialCode(null);
        respDto.setSerialId(null);
    }

    private void setMedias(List<AccessoryItemRespDto> dtoList) {
        List skuIds = dtoList.stream().filter(o -> ObjectUtil.isNotNull((Object)o.getId())).map(BaseDto::getId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(skuIds)) {
            return;
        }
        List itemMediasDgEos = this.itemMediasDgDomain.selectBySkuIds(skuIds);
        if (CollectionUtil.isEmpty((Collection)itemMediasDgEos)) {
            return;
        }
        List medias = BeanUtil.copyToList((Collection)itemMediasDgEos, ItemMediasDgReqDto.class);
        Map<Long, List<ItemMediasDgReqDto>> mediaMap = medias.stream().collect(Collectors.groupingBy(ItemMediasDgReqDto::getSkuId));
        for (AccessoryItemRespDto dto : dtoList) {
            if (!mediaMap.containsKey(dto.getId())) continue;
            dto.setMedias(mediaMap.get(dto.getId()));
        }
    }

    private void setSerialName(List<AccessoryItemRespDto> list) {
        List serialIds = list.stream().filter(e -> Objects.nonNull(e.getSerialId())).map(AccessoryItemRespDto::getSerialId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(serialIds)) {
            return;
        }
        List serialCodeEos = this.serialCodeDomain.selectByIds(serialIds);
        if (CollectionUtil.isEmpty((Collection)serialCodeEos)) {
            return;
        }
        Map serialMap = serialCodeEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        for (AccessoryItemRespDto dto : list) {
            if (!serialMap.containsKey(dto.getSerialId())) continue;
            dto.setSerialName(((SerialCodeEo)serialMap.get(dto.getSerialId())).getName());
        }
    }
}

