/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.constants.OptStatus;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.domain.entity.IBrandDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.dto.request.BrandPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.BrandReqDto;
import com.yunxi.dg.base.center.item.dto.response.BrandDgRespDto;
import com.yunxi.dg.base.center.item.eo.BrandDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IBrandDgService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="brandDgService")
public class BrandDgServiceImpl
implements IBrandDgService {
    @Resource
    private IBrandDgDomain brandDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;

    @Override
    public void importInsertBatch(List<BrandReqDto> dtos) {
        AssertUtils.notEmpty(dtos, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a!");
        ArrayList<BrandDgEo> insertBrandDgEos = new ArrayList<BrandDgEo>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> codes = new ArrayList<String>();
        for (BrandReqDto dto : dtos) {
            names.add(dto.getName());
            codes.add(dto.getCode());
        }
        Map<String, BrandDgEo> brandByCodesMap = this.getBrandByCodes(codes);
        Map<String, BrandDgEo> brandByNamesMap = this.getBrandByNames(names);
        for (BrandReqDto dto : dtos) {
            BrandDgEo brandDgEo = brandByNamesMap.get(dto.getName());
            if (Objects.nonNull(brandDgEo)) {
                AssertUtils.isTrue((boolean)Objects.equals(brandDgEo.getCode(), dto.getCode()), (String)(dto.getName() + "\u54c1\u724c\u540d\u79f0\u5df2\u5b58\u5728"));
            }
            BrandDgEo newBrandDgEo = new BrandDgEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)newBrandDgEo);
            BrandDgEo brandDgEo1 = brandByCodesMap.get(dto.getCode());
            if (Objects.nonNull(brandDgEo1)) {
                newBrandDgEo.setId(brandDgEo1.getId());
                this.brandDgDomain.updateSelective((BaseEo)newBrandDgEo);
                continue;
            }
            insertBrandDgEos.add(newBrandDgEo);
        }
        if (CollectionUtil.isNotEmpty(insertBrandDgEos)) {
            this.brandDgDomain.insertBatch(insertBrandDgEos);
        }
    }

    private Map<String, BrandDgEo> getBrandByNames(List<String> names) {
        Map<String, Object> brandDgEoMap = new HashMap<String, BrandDgEo>();
        List brandDgEos = ((ExtQueryChainWrapper)this.brandDgDomain.filter().in((Object)"name", names)).list();
        if (CollectionUtil.isNotEmpty((Collection)brandDgEos)) {
            brandDgEoMap = brandDgEos.stream().collect(Collectors.toMap(BrandDgEo::getName, Function.identity(), (k1, k2) -> k2));
        }
        return brandDgEoMap;
    }

    private Map<String, BrandDgEo> getBrandByCodes(List<String> codes) {
        Map<String, Object> brandDgEoMap = new HashMap<String, BrandDgEo>();
        List brandDgEos = ((ExtQueryChainWrapper)this.brandDgDomain.filter().in((Object)"code", codes)).list();
        if (CollectionUtil.isNotEmpty((Collection)brandDgEos)) {
            brandDgEoMap = brandDgEos.stream().collect(Collectors.toMap(BrandDgEo::getCode, Function.identity(), (k1, k2) -> k2));
        }
        return brandDgEoMap;
    }

    @Override
    public BrandDgRespDto selectById(Long id) {
        BrandDgEo brandDgEo = (BrandDgEo)((ExtQueryChainWrapper)this.brandDgDomain.filter().eq((Object)"id", (Object)id)).one();
        BrandDgRespDto brandDgRespDto = new BrandDgRespDto();
        if (brandDgEo != null) {
            BeanUtil.copyProperties((Object)brandDgEo, (Object)brandDgRespDto, (String[])new String[0]);
        }
        return brandDgRespDto;
    }

    @Override
    public Long addBrand(BrandDgEo brand) {
        this.checkBrandCode(brand.getCode(), brand.getInstanceId(), brand.getTenantId());
        this.checkBrandName(brand.getName(), brand.getInstanceId(), brand.getTenantId());
        if (null == brand.getStatus()) {
            brand.setStatus(OptStatus.ENABLED.getStatus());
        }
        this.brandDgDomain.insert((BaseEo)brand);
        return brand.getId();
    }

    @Override
    public void removeBrand(Long brandId) {
        List itemDgEoList = this.itemDgDomain.selectByBrandId(brandId);
        if (CollectionUtils.isNotEmpty((Collection)itemDgEoList)) {
            throw new BizException(ItemExceptionCode.BRAND_REFERENCED_BY_ITEM.getCode(), ItemExceptionCode.BRAND_REFERENCED_BY_ITEM.getMsg());
        }
        this.brandDgDomain.logicDeleteById(brandId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateStatus(BrandDgEo brand) {
        this.modifyStatus(brand);
        return brand.getId();
    }

    @Override
    public void batchUpdateStatus(List<Long> ids, Integer status) {
        AssertUtils.notNull((Object)status, (String)"\u542f\u7528/\u7981\u7528\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtils.notEmpty(ids, (String)"\u54c1\u724cids\u4e0d\u53ef\u4e3a\u7a7a");
        this.brandDgDomain.batchUpdateStatus(ids, status);
    }

    @Override
    public PageInfo<BrandDgEo> queryBrandByPage(BrandDgEo brandDgEo, Integer pageNum, Integer pageSize) {
        return this.brandDgDomain.selectPage((BaseEo)brandDgEo, pageNum, pageSize);
    }

    @Override
    public List<BrandDgEo> queryAllBrandByCondition(BrandDgEo brandDgEo) {
        return this.brandDgDomain.selectList((BaseEo)brandDgEo);
    }

    @Override
    public void removeByCode(List<String> brandCodes) {
        BrandDgEo eo = BrandDgEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtil.isNotEmpty(brandCodes)) {
            sqlFilters.add(SqlFilter.in((String)"code", brandCodes));
            eo.setSqlFilters(sqlFilters);
            this.brandDgDomain.logicDelete((BaseEo)eo);
        }
    }

    @Override
    public void removeById(List<Long> ids) {
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(List<Long> ids) {
        for (Long id : ids) {
            this.removeBrand(id);
        }
    }

    @Override
    public void modifyBrand(BrandReqDto requestBrandDto) {
        BrandDgEo brandDgEo = BrandDgEo.newInstance((Map)requestBrandDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)requestBrandDto, (BaseEo)brandDgEo);
        brandDgEo.setCode(null);
        BrandDgEo recordEo = (BrandDgEo)this.brandDgDomain.selectByPrimaryKey(brandDgEo.getId());
        if (recordEo == null) {
            throw new BizException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        if (Objects.nonNull(brandDgEo.getName()) && !recordEo.getName().equals(brandDgEo.getName())) {
            this.checkBrandName(requestBrandDto.getName(), brandDgEo.getInstanceId(), brandDgEo.getTenantId());
        }
        brandDgEo.setId(recordEo.getId());
        this.brandDgDomain.updateSelective((BaseEo)brandDgEo);
    }

    private void checkBrandCode(String code, Long instanceId, Long tenantId) {
        BrandDgEo brandDgEo = new BrandDgEo();
        brandDgEo.setCode(code);
        brandDgEo.setInstanceId(instanceId);
        brandDgEo.setTenantId(tenantId);
        List brandDgEos = this.brandDgDomain.selectList((BaseEo)brandDgEo);
        if (CollectionUtil.isNotEmpty((Collection)brandDgEos)) {
            throw new BizException(ItemExceptionCode.BRAND_CODE_EXISTS.getMsg());
        }
    }

    private void checkBrandName(String name, Long instanceId, Long tenantId) {
        BrandDgEo brandDgEo = new BrandDgEo();
        brandDgEo.setName(name);
        brandDgEo.setInstanceId(instanceId);
        brandDgEo.setTenantId(tenantId);
        List brandDgEos = this.brandDgDomain.selectList((BaseEo)brandDgEo);
        if (CollectionUtil.isNotEmpty((Collection)brandDgEos)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EXIST_BRAND);
        }
    }

    private void modifyStatus(BrandDgEo brand) {
        List brandDgEos;
        AssertUtils.notNull((Object)brand, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)brand.getId(), (String)"\u54c1\u724cid\u4e0d\u53ef\u4e3a\u7a7a!");
        BrandDgEo brandDgEo = (BrandDgEo)this.brandDgDomain.selectByPrimaryKey(brand.getId());
        AssertUtils.notNull((Object)brandDgEo, (String)"\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728!");
        if (Objects.nonNull(brand.getName()) && CollectionUtil.isNotEmpty((Collection)(brandDgEos = ((ExtQueryChainWrapper)this.brandDgDomain.filter().eq((Object)"name", (Object)brand.getName())).list()))) {
            AssertUtils.isTrue((brandDgEos.size() < 2 ? 1 : 0) != 0, (String)"\u54c1\u724c\u540d\u79f0\u5df2\u91cd\u590d\u5b58\u5728!");
            AssertUtils.isTrue((boolean)Objects.equals(((BrandDgEo)brandDgEos.get(0)).getId(), brand.getId()), (String)"\u54c1\u724c\u540d\u79f0\u5df2\u5b58\u5728!");
        }
        this.brandDgDomain.updateSelective((BaseEo)brand);
    }

    @Override
    public List<BrandDgRespDto> queryByIds(List<Long> ids) {
        List brandDgEoList = this.brandDgDomain.selectByIds(ids);
        ArrayList brandDgRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)brandDgEoList, (Collection)brandDgRespDtoList, BrandDgRespDto.class);
        return brandDgRespDtoList;
    }

    @Override
    public BrandDgRespDto queryCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        BrandDgEo brandDgEo = new BrandDgEo();
        brandDgEo.setCode(code);
        brandDgEo = (BrandDgEo)this.brandDgDomain.selectOne((BaseEo)brandDgEo);
        if (brandDgEo == null) {
            return null;
        }
        BrandDgRespDto brandDgRespDto = new BrandDgRespDto();
        BeanUtils.copyProperties((Object)brandDgEo, (Object)brandDgRespDto);
        return brandDgRespDto;
    }

    @Override
    public List<BrandDgRespDto> queryByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        List brandDgEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.brandDgDomain.filter().in((Object)"code", codes)).orderByDesc((Object)"id")).list();
        ArrayList brandDgRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)brandDgEoList, (Collection)brandDgRespDtoList, BrandDgRespDto.class);
        return brandDgRespDtoList;
    }

    @Override
    public List<BrandDgRespDto> queryList(BrandPageDgReqDto pageDgReqDto) {
        BrandPageDgReqDto reqDto = Objects.nonNull(pageDgReqDto) ? pageDgReqDto : new BrandPageDgReqDto();
        List brandDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.brandDgDomain.filter().eq((Object)"dr", (Object)0)).like(Objects.nonNull(reqDto.getName()), (Object)"name", (Object)reqDto.getName())).like(Objects.nonNull(reqDto.getCode()), (Object)"code", (Object)reqDto.getCode())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getCodes()), (Object)"code", (Collection)reqDto.getCodes())).like(Objects.nonNull(reqDto.getExternalCode()), (Object)"external_code", (Object)reqDto.getExternalCode())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getExternalCodeList()), (Object)"external_code", (Collection)reqDto.getExternalCodeList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getNameList()), (Object)"name", (Collection)reqDto.getNameList())).ge(Objects.nonNull(reqDto.getCreateStartTime()), (Object)"create_time", (Object)reqDto.getCreateStartTime())).le(Objects.nonNull(reqDto.getCreateEndTime()), (Object)"create_time", (Object)reqDto.getCreateEndTime())).ge(Objects.nonNull(reqDto.getUpdateStartTime()), (Object)"update_time", (Object)reqDto.getUpdateStartTime())).le(Objects.nonNull(reqDto.getUpdateEndTime()), (Object)"update_time", (Object)reqDto.getUpdateEndTime())).eq(Objects.nonNull(reqDto.getId()), (Object)"id", (Object)reqDto.getId())).eq(Objects.nonNull(reqDto.getStatus()), (Object)"status", (Object)reqDto.getStatus())).eq(Objects.nonNull(reqDto.getOwnerId()), (Object)"owner_id", (Object)reqDto.getOwnerId())).orderByDesc((Object)"create_time")).list();
        List brandDgRespDtoList = BeanUtil.copyToList((Collection)brandDgEos, BrandDgRespDto.class);
        return brandDgRespDtoList;
    }
}

