/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.JacksonUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.common.constant.ItemDgConstant;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirIndexDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IFrontShopRelationBackDgDomain;
import com.yunxi.dg.base.center.item.dto.ItemShopDgDto;
import com.yunxi.dg.base.center.item.dto.request.CommanderInfoMqDgDto;
import com.yunxi.dg.base.center.item.dto.request.DirTreeDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemDgRespDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.DirIndexDgEo;
import com.yunxi.dg.base.center.item.eo.FrontShopRelationBackDgEo;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.apiImpl.DirectoryDgApiImpl;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemShelfDgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirectoryDgServiceImpl
implements IDirectoryDgService {
    private static Logger logger = LoggerFactory.getLogger(DirectoryDgServiceImpl.class);
    @Resource
    private IDirIndexDgDomain dirIndexDgDomain;
    @Resource
    private DirectoryDgApiImpl directoryDgApiImpl;
    @Resource
    private IItemShelfDgService itemShelfDgService;
    @Resource
    private IDirectoryItemDgService directoryItemDgService;
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IDirectoryDgService directoryDgService;
    @Resource
    private IFrontShopRelationBackDgDomain frontShopRelationBackDgDomain;
    @Value(value="${dtyunxi.boc.shop.instanceId:1240276043307355174}")
    private Long bocInstanceId;
    private Map<Long, Long> shopIdMap = new HashMap<Long, Long>();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createDefaultItemShelf(DirIndexDgEo directoryEo) {
        DirIndexDgEo queryDto = DirIndexDgEo.newInstance();
        queryDto.setDirUsage("DEFAULT_SHELF");
        queryDto.setInstanceId(directoryEo.getInstanceId());
        if (CollectionUtils.isNotEmpty((Collection)this.dirIndexDgDomain.selectList((BaseEo)queryDto))) {
            logger.info("\u9ed8\u8ba4\u8d27\u67b6\u5df2\u5b58\u5728\uff0c \u4e0d\u9700\u8981\u521b\u5efa");
            return;
        }
        DirDgEo dirItem = DirDgEo.newInstance();
        dirItem.setParentId(ItemDgConstant.ROOT_NODE);
        dirItem.setName("\u9ed8\u8ba4\u8d27\u67b6");
        dirItem.setCode("DEFAULT_SHELF");
        dirItem.setInstanceId(directoryEo.getInstanceId());
        this.directoryItemDgService.saveDirectoryItem(dirItem, null);
        directoryEo.setDirUsage("DEFAULT_SHELF");
        directoryEo.setRootId(dirItem.getId());
        directoryEo.setName("\u9ed8\u8ba4\u8d27\u67b6");
        directoryEo.setOwnerId(Long.valueOf(0L));
        this.dirIndexDgDomain.insert((BaseEo)directoryEo);
    }

    @Override
    public int saveDirectory(DirIndexDgEo directoryEo) {
        if (directoryEo == null) {
            throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        directoryEo.setId(null);
        return this.dirIndexDgDomain.insert((BaseEo)directoryEo);
    }

    @Override
    public List<DirIndexDgEo> queryDirectory(DirIndexDgEo directoryEo) {
        if (directoryEo == null) {
            throw new BizException(ItemExceptionCode.NON_EXIST_DIR.getCode(), ItemExceptionCode.NON_EXIST_DIR.getMsg());
        }
        return this.dirIndexDgDomain.selectList((BaseEo)directoryEo, Integer.valueOf(1), Integer.valueOf(10000));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDirIndex(Long id) {
        if (id == null) {
            throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        this.dirIndexDgDomain.logicDeleteById(id);
        this.itemShelfDgService.offShelfByDirId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDirectory(DirIndexDgEo directoryEo) {
        if (directoryEo == null) {
            throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        this.dirIndexDgDomain.updateSelective((BaseEo)directoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDirIndexByRootId(Long rootId) {
        if (rootId == null) {
            throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        DirIndexDgEo temp = new DirIndexDgEo();
        temp.setRootId(rootId);
        DirIndexDgEo indexEo = (DirIndexDgEo)this.dirIndexDgDomain.selectOne((BaseEo)temp);
        if (indexEo != null) {
            this.dirIndexDgDomain.logicDeleteById(indexEo.getId());
            this.itemShelfDgService.offShelfByDirId(indexEo.getId());
        }
    }

    @Override
    public DirIndexDgEo queryDefaultItemShelf(Long instanceId) {
        DirIndexDgEo exam = DirIndexDgEo.newInstance();
        exam.setDirUsage("DEFAULT_SHELF");
        exam.setInstanceId(instanceId);
        List dirs = this.dirIndexDgDomain.selectList((BaseEo)exam);
        if (CollectionUtils.isNotEmpty((Collection)dirs)) {
            return (DirIndexDgEo)dirs.get(0);
        }
        DirIndexDgEo createElement = DirIndexDgEo.newInstance();
        createElement.setInstanceId(instanceId);
        this.createDefaultItemShelf(createElement);
        return createElement;
    }

    @Override
    public DirIndexDgEo queryDirectoryById(Long id) {
        return (DirIndexDgEo)this.dirIndexDgDomain.selectByPrimaryKey(id);
    }

    @Override
    public List<DirectoryItemDgRespDto> queryByIds(List<Long> ids, String orderBy) {
        DirDgEo dirDgEo = DirDgEo.newInstance();
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            dirDgEo.setOrderBy("id");
        } else {
            dirDgEo.setOrderBy(orderBy);
        }
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        dirDgEo.setSqlFilters((List)sqlFilters);
        List dirDgEoList = this.dirDgDomain.selectList((BaseEo)dirDgEo);
        ArrayList dirRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)dirDgEoList, (Collection)dirRespDtoList, DirectoryItemDgRespDto.class);
        return dirRespDtoList;
    }

    @Override
    public String initShopDir(List<CommanderInfoMqDgDto> shopList) {
        HashMap shopDirIdMap = new HashMap();
        DirIndexDgEo dirIndexDgEo = new DirIndexDgEo();
        dirIndexDgEo.setDirUsage("front");
        dirIndexDgEo.setInstanceId(this.bocInstanceId);
        List<DirIndexDgEo> directoryEos = this.directoryDgService.queryDirectory(dirIndexDgEo);
        if (CollectionUtils.isEmpty(directoryEos)) {
            logger.info("\u67e5\u8be2\u4e0d\u5230\u524d\u53f0\u7c7b\u76ee");
            return null;
        }
        List rootIdsList = directoryEos.stream().map(DirIndexDgEo::getRootId).collect(Collectors.toList());
        ArrayList itemShopDgDtoList = Lists.newArrayList();
        Map<Long, List<FrontShopRelationBackDgEo>> frontShopMap = null;
        DirDgEo dirDgEo = new DirDgEo();
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.in((String)"root_id", rootIdsList));
        dirDgEo.setSqlFilters((List)sqlFilterList);
        List dirDgEoList = this.dirDgDomain.selectList((BaseEo)dirDgEo);
        if (CollectionUtils.isNotEmpty((Collection)dirDgEoList)) {
            List oldIdsList = dirDgEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
            sqlFilterList = Lists.newArrayList();
            sqlFilterList.add(SqlFilter.in((String)"front_shop_id", oldIdsList));
            frontShopRelationBackDgEo.setSqlFilters((List)sqlFilterList);
            List frontShopRelationBackDgEoList = this.frontShopRelationBackDgDomain.selectList((BaseEo)frontShopRelationBackDgEo);
            if (CollectionUtils.isNotEmpty((Collection)frontShopRelationBackDgEoList)) {
                frontShopMap = frontShopRelationBackDgEoList.stream().collect(Collectors.groupingBy(FrontShopRelationBackDgEo::getFrontShopId));
            }
        }
        DirTreeDgReqDto dirTreeDgReqDto = new DirTreeDgReqDto();
        dirTreeDgReqDto.setInstanceId(this.bocInstanceId);
        dirTreeDgReqDto.setDirUsage("front");
        List<TreeDto<DirectoryItemDgRespDto>> trees = this.directoryItemDgService.queryDirTree(dirTreeDgReqDto);
        logger.info("\u3010\u8fd9\u662f\u4e00\u68f5\u6811\uff1a{}\u3011", (Object)JSON.toJSONString(trees));
        Map<Long, List<FrontShopRelationBackDgEo>> finalFrontShopMap = frontShopMap;
        shopList.forEach(shop -> {
            DirIndexDgEo indexEo = new DirIndexDgEo();
            indexEo.setDirUsage("shop");
            indexEo.setShopId(shop.getShopId());
            indexEo.setSellerId(shop.getSellerId());
            indexEo.setOwnerId(shop.getUserId());
            indexEo.setName("\u5e97\u94fa\u7c7b\u76ee");
            indexEo.setInstanceId(this.bocInstanceId);
            indexEo.setTenantId(Long.valueOf(1L));
            DirDgEo dirData = new DirDgEo();
            dirData.setParentId(Long.valueOf(0L));
            dirData.setName("\u5e97\u94fa\u7c7b\u76ee");
            dirData.setInstanceId(this.bocInstanceId);
            dirData.setTenantId(Long.valueOf(1L));
            Long rootId = this.directoryItemDgService.saveDirectoryItem(dirData, null);
            indexEo.setRootId(rootId);
            this.dirIndexDgDomain.insert((BaseEo)indexEo);
            this.dealWithTree(rootId, indexEo.getShopId(), rootId, trees);
            if (this.shopIdMap != null && finalFrontShopMap != null) {
                ArrayList frontShopRelationBackDgEos = Lists.newArrayList();
                Set frontIdSet = finalFrontShopMap.keySet();
                ArrayList arrayList = Lists.newArrayList(frontIdSet);
                for (Long oldFrontId : arrayList) {
                    List backEoList;
                    Long newShopDirId = this.shopIdMap.get(oldFrontId);
                    if (newShopDirId == null || !CollectionUtils.isNotEmpty((Collection)(backEoList = (List)finalFrontShopMap.get(oldFrontId)))) continue;
                    backEoList.forEach(n -> {
                        FrontShopRelationBackDgEo relationBackEo = new FrontShopRelationBackDgEo();
                        relationBackEo.setFrontShopId(newShopDirId);
                        relationBackEo.setShopId(shop.getShopId());
                        relationBackEo.setBackId(n.getBackId());
                        frontShopRelationBackDgEos.add(relationBackEo);
                        ItemShopDgDto itemShopDgDto = new ItemShopDgDto();
                        itemShopDgDto.setBackDirId(n.getBackId());
                        itemShopDgDto.setShopId(shop.getShopId());
                        itemShopDgDto.setDirId(newShopDirId);
                        itemShopDgDto.setFrontDirId(oldFrontId);
                        itemShopDgDtoList.add(itemShopDgDto);
                    });
                }
                if (CollectionUtils.isNotEmpty((Collection)frontShopRelationBackDgEos)) {
                    this.frontShopRelationBackDgDomain.insertBatch((List)frontShopRelationBackDgEos);
                    shopDirIdMap.put(indexEo.getShopId(), itemShopDgDtoList);
                }
            }
            this.shopIdMap = new HashMap<Long, Long>();
        });
        return JacksonUtil.toJson(shopDirIdMap);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchImportAddDirectory(List<DirectoryDgReqDto> directoryDgReqDtos, String dirUsage) {
        ArrayList<String> parentNameList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        for (DirectoryDgReqDto directoryDgReqDto2 : directoryDgReqDtos) {
            parentNameList.add(directoryDgReqDto2.getParentName());
            nameList.add(directoryDgReqDto2.getName());
        }
        List<DirDgEo> dirDgEos = this.directoryItemDgService.queryByName(parentNameList, dirUsage);
        DirIndexDgEo dirIndexDgEo = new DirIndexDgEo();
        dirIndexDgEo.setDirUsage(dirUsage);
        List<DirIndexDgEo> dirIndexDgEos = this.queryDirectory(dirIndexDgEo);
        Long rootId = dirIndexDgEos.get(0).getRootId();
        Map<String, Long> nameIdMap = dirDgEos.stream().collect(Collectors.toMap(DirDgEo::getName, BaseEo::getId));
        directoryDgReqDtos.forEach(directoryDgReqDto -> {
            if (StringUtils.isNotBlank((CharSequence)directoryDgReqDto.getParentName())) {
                directoryDgReqDto.setParentId((Long)nameIdMap.get(directoryDgReqDto.getParentName()));
            } else {
                directoryDgReqDto.setParentId(rootId);
            }
        });
        Map<String, DirDgEo> dirByNames = this.getDirByNames(nameList, dirUsage);
        for (DirectoryDgReqDto directoryDgReqDto3 : directoryDgReqDtos) {
            DirDgEo dirDgEo = dirByNames.get(directoryDgReqDto3.getName());
            if (Objects.nonNull(dirDgEo) && Objects.equals(dirDgEo.getParentName(), directoryDgReqDto3.getParentName())) {
                directoryDgReqDto3.setId(dirDgEo.getId());
                this.directoryDgApiImpl.modifyDirectory(directoryDgReqDto3);
                continue;
            }
            this.directoryDgApiImpl.addDirectory(directoryDgReqDto3);
        }
    }

    private Map<String, DirDgEo> getDirByNames(List<String> nameList, String dirUsage) {
        List<DirDgEo> dirDgEos;
        Map<String, Object> nameIdMap = new HashMap<String, DirDgEo>();
        if (CollectionUtil.isNotEmpty(nameList) && CollectionUtil.isNotEmpty(dirDgEos = this.directoryItemDgService.queryByName(nameList, dirUsage))) {
            nameIdMap = dirDgEos.stream().collect(Collectors.toMap(DirDgEo::getName, Function.identity(), (k1, k2) -> k2));
        }
        return nameIdMap;
    }

    private void dealWithTree(Long parentId, Long shopId, Long rootId, List<TreeDto<DirectoryItemDgRespDto>> trees) {
        for (TreeDto<DirectoryItemDgRespDto> tree : trees) {
            List children = tree.getChildren();
            DirectoryItemDgRespDto treeNode = (DirectoryItemDgRespDto)tree.getNode();
            if (treeNode.getParentId() != 0L) {
                DirDgEo dir = new DirDgEo();
                BeanUtils.copyProperties((Object)treeNode, (Object)dir);
                dir.setId(null);
                dir.setCreateTime(null);
                dir.setUpdateTime(null);
                dir.setRootId(rootId);
                dir.setShopId(shopId);
                dir.setParentId(parentId);
                dir.setInstanceId(this.bocInstanceId);
                dir.setTenantId(Long.valueOf(1L));
                parentId = this.directoryItemDgService.saveDirectoryItem(dir, null);
                this.shopIdMap.put(treeNode.getId(), parentId);
            }
            if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
            this.dealWithSonTree(parentId, shopId, rootId, children);
        }
    }

    private void dealWithSonTree(Long parentId, Long shopId, Long rootId, List<TreeDto<DirectoryItemDgRespDto>> children) {
        for (int i = 0; i < children.size(); ++i) {
            TreeDto<DirectoryItemDgRespDto> directoryItemRespDtoTreeDto = children.get(i);
            DirectoryItemDgRespDto treeDtoNode = (DirectoryItemDgRespDto)directoryItemRespDtoTreeDto.getNode();
            DirDgEo dirData = new DirDgEo();
            BeanUtils.copyProperties((Object)treeDtoNode, (Object)dirData);
            dirData.setId(null);
            dirData.setRootId(rootId);
            dirData.setShopId(shopId);
            dirData.setParentId(parentId);
            dirData.setCreateTime(null);
            dirData.setInstanceId(this.bocInstanceId);
            dirData.setTenantId(Long.valueOf(1L));
            dirData.setUpdateTime(null);
            Long newParentId = this.directoryItemDgService.saveDirectoryItem(dirData, null);
            this.shopIdMap.put(treeDtoNode.getId(), newParentId);
            if (!CollectionUtils.isNotEmpty((Collection)directoryItemRespDtoTreeDto.getChildren())) continue;
            this.dealWithSonTree(newParentId, shopId, rootId, directoryItemRespDtoTreeDto.getChildren());
        }
    }
}

