/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.common.enums.ItemTypeDg;
import com.yunxi.dg.base.center.item.convert.entity.ItemRelationComparisonDgConverter;
import com.yunxi.dg.base.center.item.dao.vo.ItemSkuPriceDgRespVo;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemRelationComparisonDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.dto.entity.ItemRelationComparisonDgDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemRelationComparisonDgListReqDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemRelationComparisonDgPageReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemRelationComparisonAssociationSkuReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemRelationComparisonDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemRelationComparisonStatusDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemRelationDgListReqDto;
import com.yunxi.dg.base.center.item.dto.response.BundleItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRelationComparisonListRespDto;
import com.yunxi.dg.base.center.item.eo.ItemBundleRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemRelationComparisonDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemRelationComparisonDgService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemRelationComparisonDgServiceImpl
extends BaseServiceImpl<ItemRelationComparisonDgDto, ItemRelationComparisonDgEo, IItemRelationComparisonDgDomain>
implements IItemRelationComparisonDgService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private IItemRelationComparisonDgDomain itemRelationComparisonDgDomain;
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;

    public ItemRelationComparisonDgServiceImpl(IItemRelationComparisonDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ItemRelationComparisonDgDto, ItemRelationComparisonDgEo> converter() {
        return ItemRelationComparisonDgConverter.INSTANCE;
    }

    @Override
    public Integer modifyRelationComparison(ItemRelationComparisonDgDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u7f16\u8f91\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getId(), (String)"\u7f16\u8f91\u5165\u53c2id\u4e0d\u53ef\u4e3a\u7a7a!");
        this.checkItemInfo(dto);
        this.verifyUniqueness(dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getSkuCode()) || StringUtils.isNotBlank((CharSequence)dto.getItemCode())) {
            dto.setRelationState(Integer.valueOf(1));
        }
        return (Integer)this.update((BaseDto)dto).getData();
    }

    @Override
    public Long addRelationComparison(ItemRelationComparisonDgDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u65b0\u589e\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        this.checkItemInfo(dto);
        AssertUtils.notNull((Object)dto.getShopCode(), (String)"\u5173\u8054\u5e97\u94fa\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getChannelName(), (String)"\u6240\u5c5e\u6e20\u9053\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getChannelCode(), (String)"\u6240\u5c5e\u6e20\u9053\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getShopCode(), (String)"\u5173\u8054\u5e97\u94fa\u4e0d\u53ef\u4e3a\u7a7a!");
        this.verifyUniqueness(dto);
        dto.setRelationState(Integer.valueOf(0));
        if (StringUtils.isNotBlank((CharSequence)dto.getSkuCode()) || StringUtils.isNotBlank((CharSequence)dto.getItemCode())) {
            dto.setRelationState(Integer.valueOf(1));
        }
        return (Long)this.insert((BaseDto)dto).getData();
    }

    @Override
    public void batchModifyStatus(ItemRelationComparisonStatusDgReqDto reqDto) {
        ((IItemRelationComparisonDgDomain)this.domain).batchUpdateStatus(reqDto.getIds(), reqDto.getStatus());
    }

    @Override
    public PageInfo<ItemRelationComparisonDgDto> queryRelationComparisonByPage(ItemRelationComparisonDgPageReqDto dto) {
        this.logger.info("queryRelationComparisonByPage:{}", (Object)JacksonUtil.toJson((Object)dto));
        ItemRelationComparisonDgEo itemRelationComparisonDgEo = this.getQueryParam(dto);
        PageInfo itemRelationComparisonDgEoPageInfo = ((IItemRelationComparisonDgDomain)this.domain).selectPage(itemRelationComparisonDgEo, dto.getPageNum(), dto.getPageSize(), false);
        List itemRelationComparisonDgEos = itemRelationComparisonDgEoPageInfo.getList();
        ArrayList itemRelationComparisonDgDtos = Lists.newArrayList();
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)itemRelationComparisonDgEos)) {
            CubeBeanUtils.copyCollection((Collection)itemRelationComparisonDgDtos, (Collection)itemRelationComparisonDgEos, ItemRelationComparisonDgDto.class);
        }
        PageInfo itemRelationComparisonDgDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)itemRelationComparisonDgDtoPageInfo, (Object)itemRelationComparisonDgEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        itemRelationComparisonDgDtoPageInfo.setList((List)itemRelationComparisonDgDtos);
        return itemRelationComparisonDgDtoPageInfo;
    }

    @Override
    public List<ItemRelationComparisonDgDto> queryByList(ItemRelationComparisonDgListReqDto dto) {
        ArrayList itemRelationComparisonDgDtos = Lists.newArrayList();
        if (Objects.isNull(dto) || CollectionUtil.isEmpty((Collection)dto.getChannelItemKeys())) {
            return itemRelationComparisonDgDtos;
        }
        List itemRelationComparisonDgEos = ((ExtQueryChainWrapper)((IItemRelationComparisonDgDomain)this.domain).filter().in((Object)"channel_item_key", (Collection)dto.getChannelItemKeys())).list();
        CubeBeanUtils.copyCollection((Collection)itemRelationComparisonDgDtos, (Collection)itemRelationComparisonDgEos, ItemRelationComparisonDgDto.class);
        return itemRelationComparisonDgDtos;
    }

    private ItemRelationComparisonDgEo getQueryParam(ItemRelationComparisonDgPageReqDto dto) {
        ItemRelationComparisonDgEo itemRelationComparisonDgEo = new ItemRelationComparisonDgEo();
        BeanCopyUtil.copyProperties((Object)dto, (Object)itemRelationComparisonDgEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtil.isNotEmpty((Collection)dto.getChannelCodes())) {
            sqlFilters.add(SqlFilter.in((String)"channel_code", (Object)StringUtils.join((Iterable)dto.getChannelCodes(), (String)",")));
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getShopCodes())) {
            sqlFilters.add(SqlFilter.in((String)"shop_code", (Object)StringUtils.join((Iterable)dto.getShopCodes(), (String)",")));
        }
        this.logger.info("channelItemId:{}", (Object)dto.getChannelItemId());
        if (StringUtils.isNotBlank((CharSequence)dto.getChannelItemId())) {
            sqlFilters.add(SqlFilter.like((String)"channel_item_id", (Object)("%" + dto.getChannelItemId() + "%")));
            itemRelationComparisonDgEo.setChannelItemId(null);
        }
        if (Objects.nonNull(dto.getChannelItemName())) {
            sqlFilters.add(SqlFilter.like((String)"channel_item_name", (Object)("%" + dto.getChannelItemName() + "%")));
            itemRelationComparisonDgEo.setChannelItemName(null);
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getChannelItemKeys())) {
            sqlFilters.add(SqlFilter.in((String)"channel_item_key", (Object)StringUtils.join((Iterable)dto.getChannelItemKeys(), (String)",")));
            itemRelationComparisonDgEo.setChannelItemKey(null);
        }
        if (Objects.nonNull(dto.getChannelItemCode())) {
            sqlFilters.add(SqlFilter.like((String)"channel_item_code", (Object)("%" + dto.getChannelItemCode() + "%")));
            itemRelationComparisonDgEo.setChannelItemCode(null);
        }
        if (Objects.nonNull(dto.getChannelSkuId())) {
            sqlFilters.add(SqlFilter.like((String)"channel_sku_id", (Object)("%" + dto.getChannelSkuId() + "%")));
            itemRelationComparisonDgEo.setChannelSkuId(null);
        }
        if (Objects.nonNull(dto.getChannelSkuCode())) {
            sqlFilters.add(SqlFilter.like((String)"channel_sku_code", (Object)("%" + dto.getChannelSkuCode() + "%")));
            itemRelationComparisonDgEo.setChannelSkuCode(null);
        }
        if (Objects.nonNull(dto.getItemCode())) {
            sqlFilters.add(SqlFilter.like((String)"item_code", (Object)("%" + dto.getItemCode() + "%")));
            itemRelationComparisonDgEo.setItemCode(null);
        }
        if (Objects.nonNull(dto.getSkuCode())) {
            sqlFilters.add(SqlFilter.like((String)"sku_code", (Object)("%" + dto.getSkuCode() + "%")));
            itemRelationComparisonDgEo.setSkuCode(null);
        }
        if (Objects.nonNull(dto.getSkuName())) {
            sqlFilters.add(SqlFilter.like((String)"sku_name", (Object)("%" + dto.getSkuName() + "%")));
            itemRelationComparisonDgEo.setSkuName(null);
        }
        if (Objects.nonNull(dto.getUpdateBeginTime())) {
            sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)dto.getUpdateBeginTime()));
        }
        if (Objects.nonNull(dto.getUpdateEndTime())) {
            sqlFilters.add(SqlFilter.le((String)"update_time", (Object)dto.getUpdateEndTime()));
        }
        if (Objects.nonNull(dto.getCreateBeginTime())) {
            sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)dto.getCreateBeginTime()));
        }
        if (Objects.nonNull(dto.getCreateEndTime())) {
            sqlFilters.add(SqlFilter.le((String)"create_time", (Object)dto.getCreateEndTime()));
        }
        if (StringUtils.isBlank((CharSequence)itemRelationComparisonDgEo.getOrderByDesc())) {
            itemRelationComparisonDgEo.setOrderByDesc("create_time");
            itemRelationComparisonDgEo.setOrderByDesc("id");
        }
        itemRelationComparisonDgEo.setSqlFilters(sqlFilters);
        return itemRelationComparisonDgEo;
    }

    @Override
    public void importInsertBatch(List<ItemRelationComparisonDgReqDto> dtos) {
        ArrayList comparisonDgEos = Lists.newArrayList();
        if (CollectionUtil.isEmpty(dtos)) {
            return;
        }
        CubeBeanUtils.copyCollection((Collection)comparisonDgEos, dtos, ItemRelationComparisonDgEo.class);
        HashSet<String> channelKeys = new HashSet<String>();
        for (int i = comparisonDgEos.size() - 1; i >= 0; --i) {
            ItemRelationComparisonDgEo comparisonDgEo = (ItemRelationComparisonDgEo)comparisonDgEos.get(i);
            AssertUtils.notNull((Object)comparisonDgEo.getShopCode(), (String)"\u5e97\u94fa\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            String channelKey = Objects.nonNull(comparisonDgEo.getChannelItemKey()) ? comparisonDgEo.getChannelItemKey() : (StringUtils.isNotBlank((CharSequence)comparisonDgEo.getChannelSkuCode()) ? comparisonDgEo.getChannelSkuCode() : "") + (StringUtils.isNotBlank((CharSequence)comparisonDgEo.getChannelSkuId()) ? comparisonDgEo.getChannelSkuId() : "") + (StringUtils.isNotBlank((CharSequence)comparisonDgEo.getChannelItemCode()) ? comparisonDgEo.getChannelItemCode() : "") + (StringUtils.isNotBlank((CharSequence)comparisonDgEo.getChannelItemId()) ? comparisonDgEo.getChannelItemId() : "");
            comparisonDgEo.setChannelItemKey(channelKey);
            if (channelKeys.contains(channelKey)) {
                comparisonDgEos.remove(i);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)channelKey)) continue;
            channelKeys.add(channelKey);
        }
        if (CollectionUtil.isNotEmpty(channelKeys)) {
            List comparisonDgEoList = ((IItemRelationComparisonDgDomain)this.domain).selectByChannelKeys(new ArrayList(channelKeys));
            Set<Object> existKeys = new HashSet();
            if (CollectionUtil.isNotEmpty((Collection)comparisonDgEoList)) {
                existKeys = comparisonDgEoList.stream().map(ItemRelationComparisonDgEo::getChannelItemKey).collect(Collectors.toSet());
            }
            for (int i = comparisonDgEos.size() - 1; i >= 0; --i) {
                ItemRelationComparisonDgEo comparisonDgEo = (ItemRelationComparisonDgEo)comparisonDgEos.get(i);
                if (!existKeys.contains(comparisonDgEo.getChannelItemKey())) continue;
                comparisonDgEos.remove(i);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)comparisonDgEos)) {
            ((IItemRelationComparisonDgDomain)this.domain).insertBatch((List)comparisonDgEos);
        }
    }

    @Override
    public void batchDisassociation(List<Long> ids) {
        ((IItemRelationComparisonDgDomain)this.domain).batchDisassociation(ids);
    }

    @Override
    public void association(ItemRelationComparisonAssociationSkuReqDto reqDto) {
        ItemRelationComparisonDgEo itemRelationComparisonDgEo = (ItemRelationComparisonDgEo)((IItemRelationComparisonDgDomain)this.domain).selectByPrimaryKey(reqDto.getId());
        AssertUtils.notNull((Object)itemRelationComparisonDgEo, (String)"\u5bf9\u7167\u5173\u7cfb\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectById((Serializable)reqDto.getSkuId());
        AssertUtils.notNull((Object)itemSkuDgEo, (String)"\u5173\u8054\u5546\u54c1sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectById((Serializable)itemSkuDgEo.getItemId());
        AssertUtils.notNull((Object)itemDgEo, (String)"\u5173\u8054\u5546\u54c1\u4e0d\u53ef\u4e3a\u7a7a!");
        itemRelationComparisonDgEo.setSkuCode(itemSkuDgEo.getCode());
        itemRelationComparisonDgEo.setSkuName(itemSkuDgEo.getName());
        itemRelationComparisonDgEo.setItemCode(itemDgEo.getCode());
        itemRelationComparisonDgEo.setItemName(itemDgEo.getName());
        ItemRelationComparisonDgDto itemRelationComparisonDgDto = new ItemRelationComparisonDgDto();
        CubeBeanUtils.copyProperties((Object)itemRelationComparisonDgDto, (Object)itemRelationComparisonDgEo, (String[])new String[0]);
        this.verifyUniqueness(itemRelationComparisonDgDto);
        itemRelationComparisonDgEo.setRelationState(Integer.valueOf(1));
        ((IItemRelationComparisonDgDomain)this.domain).update((BaseEo)itemRelationComparisonDgEo);
    }

    @Override
    public List<ItemRelationComparisonListRespDto> queryRelationByItemKeysAndShopCode(ItemRelationDgListReqDto reqDto) {
        ArrayList<ItemRelationComparisonListRespDto> retList = new ArrayList<ItemRelationComparisonListRespDto>();
        if (Objects.nonNull(reqDto) && CollectionUtil.isNotEmpty((Collection)reqDto.getChannelItemKeyList())) {
            List itemBundleList;
            List voList = this.itemRelationComparisonDgDomain.queryRelationByItemKeysAndShopCode(reqDto);
            Map<Long, List<ItemBundleRelationDgEo>> sonItemMap = null;
            List commItemIds = voList.stream().filter(i -> Objects.equals(ItemTypeDg.COMB_ITEM.getStatus(), i.getItemType())).map(ItemSkuPriceDgRespVo::getItemId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(commItemIds) && CollectionUtil.isNotEmpty((Collection)(itemBundleList = ((ExtQueryChainWrapper)this.itemBundleRelationDgDomain.filter().in((Object)"item_id", commItemIds)).list()))) {
                sonItemMap = itemBundleList.stream().collect(Collectors.groupingBy(ItemBundleRelationDgEo::getItemId));
            }
            for (ItemSkuPriceDgRespVo vo : voList) {
                ItemRelationComparisonListRespDto dto = new ItemRelationComparisonListRespDto();
                CubeBeanUtils.copyProperties((Object)dto, (Object)vo, (String[])new String[0]);
                if (sonItemMap != null) {
                    List<ItemBundleRelationDgEo> tempList = sonItemMap.get(vo.getItemId());
                    if (CollectionUtils.isNotEmpty(tempList)) {
                        ArrayList bundleReqDtos = new ArrayList();
                        CubeBeanUtils.copyCollection(bundleReqDtos, tempList, BundleItemDgRespDto.class);
                        dto.setBundleReqDtos(bundleReqDtos);
                    }
                } else {
                    this.logger.info("\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u4fe1\u606f:sonItemMap is empty ");
                }
                retList.add(dto);
            }
        } else {
            throw new BizException("\u53c2\u6570\u5f02\u5e38channelSkuCodeList is Empty");
        }
        return retList;
    }

    @Override
    public RestResponse<Void> removeByIds(List<Long> ids) {
        if (CollectionUtil.isNotEmpty(ids)) {
            this.itemRelationComparisonDgDomain.removeByIds(ids);
        }
        return RestResponse.VOID;
    }

    private void verifyUniqueness(ItemRelationComparisonDgDto dto) {
        if (Objects.isNull(dto.getChannelSkuCode()) && Objects.isNull(dto.getChannelSkuId()) && Objects.isNull(dto.getChannelItemCode()) && Objects.isNull(dto.getChannelItemId())) {
            return;
        }
        ItemRelationComparisonDgEo itemRelationComparisonDgEo = new ItemRelationComparisonDgEo();
        String channelItemKey = Objects.nonNull(dto.getChannelItemKey()) ? dto.getChannelItemKey() : (StringUtils.isNotBlank((CharSequence)dto.getChannelSkuCode()) ? dto.getChannelSkuCode() : "") + (StringUtils.isNotBlank((CharSequence)dto.getChannelSkuId()) ? dto.getChannelSkuId() : "") + (StringUtils.isNotBlank((CharSequence)dto.getChannelItemCode()) ? dto.getChannelItemCode() : "") + (StringUtils.isNotBlank((CharSequence)dto.getChannelItemId()) ? dto.getChannelItemId() : "");
        dto.setChannelItemKey(channelItemKey);
        itemRelationComparisonDgEo.setChannelItemKey(channelItemKey);
        itemRelationComparisonDgEo.setDr(0);
        ItemRelationComparisonDgEo comparisonDgEo = (ItemRelationComparisonDgEo)((IItemRelationComparisonDgDomain)this.domain).selectOne((BaseEo)itemRelationComparisonDgEo);
        if (Objects.nonNull(comparisonDgEo) && !Objects.equals(dto.getId(), comparisonDgEo.getId())) {
            throw new BizException("\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
    }

    private void checkItemInfo(ItemRelationComparisonDgDto dto) {
        AssertUtils.notNull((Object)dto.getSkuCode(), (String)"\u5173\u8054\u5546\u54c1\u4e0d\u53ef\u4e3a\u7a7a!");
        ArrayList<String> skuCodes = new ArrayList<String>();
        skuCodes.add(dto.getSkuCode());
        List skuDgEos = this.itemSkuDgDomain.selectItemSkuByCodes(skuCodes);
        AssertUtils.notEmpty((Collection)skuDgEos, (String)"\u5173\u8054\u5546\u54c1sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectById((Serializable)((ItemSkuDgEo)skuDgEos.get(0)).getItemId());
        AssertUtils.notNull((Object)itemDgEo, (String)"\u5173\u8054\u5546\u54c1\u4e0d\u53ef\u4e3a\u7a7a!");
        dto.setSkuCode(((ItemSkuDgEo)skuDgEos.get(0)).getCode());
        dto.setSkuName(((ItemSkuDgEo)skuDgEos.get(0)).getName());
        dto.setItemCode(itemDgEo.getCode());
        dto.setItemName(itemDgEo.getName());
        dto.setSubType(itemDgEo.getSubType());
    }
}

