/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.constants.ItemConstants;
import com.yunxi.dg.base.center.item.convert.entity.SpecificationGroupConverter;
import com.yunxi.dg.base.center.item.domain.entity.ISpecificationGroupDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISpecificationNameDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISpecificationRefGroupDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISpecificationValueDomain;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationGroupDto;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationGroupPageReqDto;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationValueDto;
import com.yunxi.dg.base.center.item.dto.request.SpecificationGroupQuoteReqDto;
import com.yunxi.dg.base.center.item.dto.request.SpecificationGroupReqDto;
import com.yunxi.dg.base.center.item.dto.request.SpecificationGroupStatusReqDto;
import com.yunxi.dg.base.center.item.dto.response.SpecificationGroupDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.SpecificationNameDetailRespDto;
import com.yunxi.dg.base.center.item.eo.SpecificationGroupEo;
import com.yunxi.dg.base.center.item.eo.SpecificationRefGroupEo;
import com.yunxi.dg.base.center.item.service.entity.ISpecificationGroupService;
import com.yunxi.dg.base.center.item.service.util.CodeAppendUtil;
import com.yunxi.dg.base.center.item.service.util.ConvertDgUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpecificationGroupServiceImpl
extends BaseServiceImpl<SpecificationGroupDto, SpecificationGroupEo, ISpecificationGroupDomain>
implements ISpecificationGroupService {
    private static Logger logger = LoggerFactory.getLogger(SpecificationGroupServiceImpl.class);
    @Resource
    private ISpecificationGroupDomain specificationGroupDomain;
    @Resource
    private ISpecificationRefGroupDomain specificationRefGroupDomain;
    @Resource
    private ISpecificationNameDomain specificationNameDomain;
    @Resource
    private ISpecificationValueDomain specificationValueDomain;
    @Resource
    private ICacheService cacheService;
    @Resource
    protected ILockService lockService;

    public SpecificationGroupServiceImpl(ISpecificationGroupDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SpecificationGroupDto, SpecificationGroupEo> converter() {
        return SpecificationGroupConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> add(SpecificationGroupReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getName(), (String)"\u89c4\u683c\u5c5e\u6027\u7ec4\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a!");
        this.getRateVerify(dto.getName(), dto.getId());
        SpecificationGroupEo groupEo = (SpecificationGroupEo)BeanUtil.copyProperties((Object)dto, SpecificationGroupEo.class, (String[])new String[0]);
        Mutex lock = null;
        try {
            SpecificationGroupEo one;
            lock = this.lockService.lock("SPECIFICATION_GROUP_CODE_CACHE_KEY", "SPECIFICATION_GROUP_CODE_CACHE_LOCK_KEY", 10, 10, TimeUnit.SECONDS);
            Integer maxCode = 0;
            Integer cache = (Integer)this.cacheService.getCache("SPECIFICATION_GROUP_CODE_CACHE_KEY", Integer.class);
            maxCode = Objects.nonNull(cache) ? cache : Integer.valueOf(Objects.nonNull(one = (SpecificationGroupEo)this.specificationGroupDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEo::getDr, (Object)0)).orderByDesc(BaseEo::getId)).last("LIMIT 1"))) && Objects.nonNull(one.getCode()) ? Integer.parseInt(one.getCode()) : maxCode);
            groupEo.setCode(CodeAppendUtil.append(4, Long.valueOf(maxCode + 1)));
            this.specificationGroupDomain.insert((BaseEo)groupEo);
            this.cacheService.setCache("ITEM_RATE_CODE_CACHE_KEY", (Object)(maxCode + 1));
        }
        catch (Exception e) {
            throw new BizException(e.getMessage());
        }
        finally {
            if (Objects.nonNull(lock)) {
                this.lockService.unlock(lock);
            }
        }
        this.addSpecificationRefGroupEos(dto.getNameIdList(), groupEo);
        return new RestResponse((Object)groupEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updateSpecificationGroup(SpecificationGroupReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getId(), (String)"id\u4e0d\u53ef\u4e3a\u7a7a!");
        dto.setCode(null);
        this.getRateVerify(dto.getName(), dto.getId());
        SpecificationGroupEo existGroupEo = (SpecificationGroupEo)this.specificationGroupDomain.selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)existGroupEo, (String)"\u89c4\u683c\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728!");
        SpecificationGroupEo groupEo = (SpecificationGroupEo)BeanUtil.copyProperties((Object)dto, SpecificationGroupEo.class, (String[])new String[0]);
        this.specificationGroupDomain.updateSelective((BaseEo)groupEo);
        this.specificationRefGroupDomain.removeByGroupIds(Arrays.asList(groupEo.getId()));
        this.addSpecificationRefGroupEos(dto.getNameIdList(), groupEo);
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> removeByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return RestResponse.VOID;
        }
        List groupEoList = this.specificationGroupDomain.selectByIds(ids);
        AssertUtils.notEmpty((Collection)groupEoList, (String)"\u89c4\u683c\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728!");
        for (SpecificationGroupEo groupEo : groupEoList) {
            AssertUtils.isFalse((boolean)Objects.equals(groupEo.getIsUse(), ItemConstants.IS_USE_YES), (String)(groupEo.getName() + "\u89c4\u683c\u7ec4\u5df2\u88ab\u5f15\u7528,\u4e0d\u53ef\u5220\u9664"));
        }
        this.specificationGroupDomain.removeByIds(ids);
        this.removeRefByGroupIds(ids);
        return RestResponse.VOID;
    }

    private void removeRefByGroupIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        List refGroupEos = ((ExtQueryChainWrapper)this.specificationRefGroupDomain.filter().in((Object)"specification_group_id", ids)).list();
        if (CollectionUtil.isEmpty((Collection)refGroupEos)) {
            return;
        }
        Set nameIdSet = refGroupEos.stream().map(SpecificationRefGroupEo::getSpecificationNameId).collect(Collectors.toSet());
        this.specificationRefGroupDomain.removeByGroupIds(ids);
        List refGroupEoList = ((ExtQueryChainWrapper)this.specificationRefGroupDomain.filter().in((Object)"specification_name_id", nameIdSet)).list();
        Set existNameIdSet = refGroupEoList.stream().map(SpecificationRefGroupEo::getSpecificationNameId).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(existNameIdSet)) {
            nameIdSet.removeAll(existNameIdSet);
        }
        if (CollectionUtil.isNotEmpty(nameIdSet)) {
            this.specificationNameDomain.quoteByNameIds(new ArrayList(nameIdSet), ItemConstants.IS_USE_NO);
        }
    }

    @Override
    public RestResponse<Void> changeStatus(SpecificationGroupStatusReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        this.specificationGroupDomain.changeStatusByIds(dto.getIdList(), dto.getStatus());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<PageInfo<SpecificationGroupDetailRespDto>> queryPage(SpecificationGroupPageReqDto dto) {
        PageInfo<SpecificationGroupDetailRespDto> pageInfo = new PageInfo<SpecificationGroupDetailRespDto>();
        SpecificationGroupEo selectParam = this.getSelectParam(dto);
        PageInfo eoPageInfo = this.specificationGroupDomain.selectPage((BaseEo)selectParam, dto.getPageNum(), dto.getPageSize());
        pageInfo = ConvertDgUtil.convertPage(eoPageInfo, SpecificationGroupDetailRespDto.class);
        this.getSpecificationNameDetail(pageInfo.getList());
        return new RestResponse(pageInfo);
    }

    private void getSpecificationNameDetail(List<SpecificationGroupDetailRespDto> groupDetailRespDtos) {
        if (CollectionUtil.isEmpty(groupDetailRespDtos)) {
            return;
        }
        List groupIds = groupDetailRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
        List refGroupEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.specificationRefGroupDomain.filter().in((Object)"specification_group_id", groupIds)).orderByAsc((Object)"id")).list();
        if (CollectionUtil.isEmpty((Collection)refGroupEos)) {
            return;
        }
        List<Long> nameIds = refGroupEos.stream().map(SpecificationRefGroupEo::getSpecificationNameId).collect(Collectors.toList());
        Map<Long, List<SpecificationRefGroupEo>> refMap = refGroupEos.stream().collect(Collectors.groupingBy(SpecificationRefGroupEo::getSpecificationGroupId));
        List<SpecificationNameDetailRespDto> specificationNameDetailRespDtos = this.getSpecificationNameDetailRespDtos(nameIds);
        Map nameMap = specificationNameDetailRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k2));
        for (SpecificationGroupDetailRespDto groupDetailRespDto : groupDetailRespDtos) {
            List<SpecificationRefGroupEo> refGroupEoList = refMap.get(groupDetailRespDto.getId());
            ArrayList<SpecificationNameDetailRespDto> nameDetailRespDtos = new ArrayList<SpecificationNameDetailRespDto>();
            if (CollectionUtil.isEmpty(refGroupEoList)) {
                return;
            }
            for (SpecificationRefGroupEo specificationRefGroupEo : refGroupEoList) {
                SpecificationNameDetailRespDto specificationNameDetailRespDto = (SpecificationNameDetailRespDto)nameMap.get(specificationRefGroupEo.getSpecificationNameId());
                if (!Objects.nonNull(specificationNameDetailRespDto)) continue;
                nameDetailRespDtos.add(specificationNameDetailRespDto);
            }
            groupDetailRespDto.setSpecificationNameDetailRespDtoList(nameDetailRespDtos);
        }
    }

    @Override
    public RestResponse<SpecificationGroupDetailRespDto> queryById(Long id) {
        SpecificationGroupDetailRespDto detailRespDto = new SpecificationGroupDetailRespDto();
        SpecificationGroupEo groupEo = (SpecificationGroupEo)this.specificationGroupDomain.selectByPrimaryKey(id);
        if (Objects.isNull(groupEo)) {
            return new RestResponse((Object)detailRespDto);
        }
        List refGroupEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.specificationRefGroupDomain.filter().eq((Object)"specification_group_id", (Object)groupEo.getId())).orderByAsc((Object)"id")).list();
        if (CollectionUtil.isEmpty((Collection)refGroupEos)) {
            return new RestResponse((Object)detailRespDto);
        }
        List<Long> nameIds = refGroupEos.stream().map(SpecificationRefGroupEo::getSpecificationNameId).collect(Collectors.toList());
        List<SpecificationNameDetailRespDto> specificationNameDetailRespDtos = this.getSpecificationNameDetailRespDtos(nameIds);
        Map<Object, Object> nameDetailRespDtoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(specificationNameDetailRespDtos)) {
            nameDetailRespDtoMap = specificationNameDetailRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k2));
        }
        ArrayList<SpecificationNameDetailRespDto> nameDetailRespDtoList = new ArrayList<SpecificationNameDetailRespDto>();
        for (SpecificationRefGroupEo specificationRefGroupEo : refGroupEos) {
            SpecificationNameDetailRespDto specificationNameDetailRespDto = (SpecificationNameDetailRespDto)nameDetailRespDtoMap.get(specificationRefGroupEo.getSpecificationNameId());
            if (!Objects.nonNull(specificationNameDetailRespDto)) continue;
            nameDetailRespDtoList.add(specificationNameDetailRespDto);
        }
        BeanUtil.copyProperties((Object)groupEo, (Object)detailRespDto, (String[])new String[0]);
        detailRespDto.setSpecificationNameDetailRespDtoList(nameDetailRespDtoList);
        return new RestResponse((Object)detailRespDto);
    }

    @Override
    public RestResponse<List<SpecificationGroupDetailRespDto>> queryByIds(List<Long> ids) {
        List groupEoList = this.specificationGroupDomain.selectByIds(ids);
        List groupDetailRespDtos = BeanUtil.copyToList((Collection)groupEoList, SpecificationGroupDetailRespDto.class);
        this.getSpecificationGroupDetailRespDtos(groupDetailRespDtos);
        return new RestResponse((Object)groupDetailRespDtos);
    }

    private void getSpecificationGroupDetailRespDtos(List<SpecificationGroupDetailRespDto> groupDetailRespDtos) {
        if (CollectionUtil.isEmpty(groupDetailRespDtos)) {
            return;
        }
        List ids = groupDetailRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
        List refGroupEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.specificationRefGroupDomain.filter().in((Object)"specification_group_id", ids)).orderByAsc((Object)"id")).list();
        if (CollectionUtil.isEmpty((Collection)refGroupEos)) {
            return;
        }
        Map<Long, List<SpecificationRefGroupEo>> refMap = refGroupEos.stream().collect(Collectors.groupingBy(SpecificationRefGroupEo::getSpecificationGroupId));
        List<Long> nameIds = refGroupEos.stream().map(SpecificationRefGroupEo::getSpecificationNameId).collect(Collectors.toList());
        List<SpecificationNameDetailRespDto> specificationNameDetailRespDtos = this.getSpecificationNameDetailRespDtos(nameIds);
        Map<Object, Object> nameDetailRespDtoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(specificationNameDetailRespDtos)) {
            nameDetailRespDtoMap = specificationNameDetailRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k2));
        }
        for (SpecificationGroupDetailRespDto groupDetailRespDto : groupDetailRespDtos) {
            ArrayList<SpecificationNameDetailRespDto> nameDetailRespDtoList = new ArrayList<SpecificationNameDetailRespDto>();
            List<SpecificationRefGroupEo> specificationRefGroupEos = refMap.get(groupDetailRespDto.getId());
            if (CollectionUtil.isEmpty(specificationRefGroupEos)) continue;
            for (SpecificationRefGroupEo specificationRefGroupEo : specificationRefGroupEos) {
                SpecificationNameDetailRespDto specificationNameDetailRespDto = (SpecificationNameDetailRespDto)nameDetailRespDtoMap.get(specificationRefGroupEo.getSpecificationNameId());
                if (!Objects.nonNull(specificationNameDetailRespDto)) continue;
                nameDetailRespDtoList.add(specificationNameDetailRespDto);
            }
            groupDetailRespDto.setSpecificationNameDetailRespDtoList(nameDetailRespDtoList);
        }
    }

    private List<SpecificationNameDetailRespDto> getSpecificationNameDetailRespDtos(List<Long> nameIds) {
        List<Object> specificationNameDetailRespDtos = new ArrayList<SpecificationNameDetailRespDto>();
        List nameEos = this.specificationNameDomain.selectByIds(nameIds);
        if (CollectionUtil.isEmpty((Collection)nameEos)) {
            return specificationNameDetailRespDtos;
        }
        specificationNameDetailRespDtos = BeanUtil.copyToList((Collection)nameEos, SpecificationNameDetailRespDto.class);
        List valueEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.specificationValueDomain.filter().in((Object)"prop_name_id", nameIds)).orderByAsc((Object)"id")).list();
        if (CollectionUtil.isNotEmpty((Collection)valueEos)) {
            List specificationValueDtos = BeanUtil.copyToList((Collection)valueEos, SpecificationValueDto.class);
            Map<Long, List<SpecificationValueDto>> valueMap = specificationValueDtos.stream().collect(Collectors.groupingBy(SpecificationValueDto::getPropNameId));
            for (SpecificationNameDetailRespDto specificationNameDetailRespDto : specificationNameDetailRespDtos) {
                specificationNameDetailRespDto.setSpecificationValueDtoList(valueMap.get(specificationNameDetailRespDto.getId()));
            }
        }
        return specificationNameDetailRespDtos;
    }

    @Override
    public RestResponse<Void> quoteSpecificationGroup(SpecificationGroupQuoteReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        this.specificationGroupDomain.quoteSpecificationGroup(dto.getIdList(), dto.getIsUse());
        return RestResponse.VOID;
    }

    private void getRateVerify(String name, Long id) {
        if (Objects.nonNull(name)) {
            List groupEos = ((ExtQueryChainWrapper)this.specificationGroupDomain.filter().eq((Object)"name", (Object)name)).list();
            if (CollectionUtil.isEmpty((Collection)groupEos)) {
                return;
            }
            AssertUtils.isTrue((groupEos.size() < 2 ? 1 : 0) != 0, (String)"\u89c4\u683c\u7ec4\u540d\u79f0\u5df2\u91cd\u590d\u5b58\u5728");
            AssertUtils.isTrue((boolean)Objects.equals(((SpecificationGroupEo)groupEos.get(0)).getId(), id), (String)"\u89c4\u683c\u7ec4\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }

    private SpecificationGroupEo getSelectParam(SpecificationGroupPageReqDto dto) {
        SpecificationGroupEo groupEo = new SpecificationGroupEo();
        BeanUtil.copyProperties((Object)dto, (Object)groupEo, (String[])new String[0]);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (Objects.nonNull(dto)) {
            if (CollectionUtil.isNotEmpty((Collection)dto.getIdList())) {
                sqlFilters.add(SqlFilter.in((String)"id", (Object)dto.getIdList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getCodeList())) {
                sqlFilters.add(SqlFilter.in((String)"code", (Object)dto.getCodeList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getEntityTypeList())) {
                sqlFilters.add(SqlFilter.in((String)"entity_type", (Object)dto.getEntityTypeList()));
            }
            if (Objects.nonNull(dto.getCode())) {
                groupEo.setCode(null);
                sqlFilters.add(SqlFilter.like((String)"code", (Object)dto.getCode()));
            }
            if (Objects.nonNull(dto.getName())) {
                groupEo.setName(null);
                sqlFilters.add(SqlFilter.like((String)"name", (Object)dto.getName()));
            }
            if (Objects.nonNull(dto.getAlias())) {
                groupEo.setAlias(null);
                sqlFilters.add(SqlFilter.like((String)"alias", (Object)dto.getAlias()));
            }
            if (Objects.nonNull(dto.getCreateStartTime())) {
                sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)dto.getCreateStartTime()));
            }
            if (Objects.nonNull(dto.getCreateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"create_time", (Object)dto.getCreateEndTime()));
            }
            if (Objects.nonNull(dto.getUpdateStartTime())) {
                sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)dto.getUpdateStartTime()));
            }
            if (Objects.nonNull(dto.getUpdateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"update_time", (Object)dto.getUpdateEndTime()));
            }
        }
        groupEo.setSqlFilters(sqlFilters);
        groupEo.setOrderByDesc("id");
        return groupEo;
    }

    private void addSpecificationRefGroupEos(List<Long> nameIds, SpecificationGroupEo groupEo) {
        ArrayList<SpecificationRefGroupEo> refGroupEos;
        if (Objects.equals(groupEo.getIsUse(), 1)) {
            refGroupEos = ((ExtQueryChainWrapper)this.specificationRefGroupDomain.filter().eq((Object)"specification_group_id", (Object)groupEo.getId())).list();
            if (CollectionUtil.isNotEmpty((Collection)refGroupEos)) {
                List existNameIds = refGroupEos.stream().map(SpecificationRefGroupEo::getSpecificationNameId).collect(Collectors.toList());
                nameIds.removeAll(existNameIds);
            }
        } else {
            this.specificationRefGroupDomain.removeByGroupIds(Arrays.asList(groupEo.getId()));
        }
        this.specificationNameDomain.quoteByNameIds(nameIds, ItemConstants.IS_USE_YES);
        if (CollectionUtil.isNotEmpty(nameIds)) {
            refGroupEos = new ArrayList<SpecificationRefGroupEo>();
            for (Long nameId : nameIds) {
                SpecificationRefGroupEo refGroupEo = new SpecificationRefGroupEo();
                refGroupEo.setSpecificationGroupId(groupEo.getId());
                refGroupEo.setSpecificationNameId(nameId);
                refGroupEos.add(refGroupEo);
            }
            if (CollectionUtil.isNotEmpty(refGroupEos)) {
                this.specificationRefGroupDomain.insertBatch(refGroupEos);
            }
        }
    }
}

