/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.event.localEvent;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.center.item.domain.entity.ISerialCodeDomain;
import com.yunxi.dg.base.center.item.dto.entity.SerialCodeDto;
import com.yunxi.dg.base.center.item.eo.SerialCodeEo;
import com.yunxi.dg.base.center.item.event.localEvent.SerialCodeMqEvent;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class SerialCodeMqMqListener {
    private static final Logger log = LoggerFactory.getLogger(SerialCodeMqMqListener.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ISerialCodeDomain serialCodeDomain;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={SerialCodeMqEvent.class})
    public void sendSerialCodeMq(SerialCodeMqEvent serialCodeMqEvent) {
        log.info("\u76d1\u542c\u5546\u54c1\u7cfb\u5217\u4fe1\u606f\u53d8\u66f4\u4e8b\u4ef6\u6d88\u8d39\u6267\u884ctime:{},\u4e8b\u4ef6\u7c7b\u578b:{}", (Object)LocalTime.now(), (Object)serialCodeMqEvent.getType());
        List<SerialCodeEo> serialCodeEoList = serialCodeMqEvent.getSerialCodeEoList();
        if (CollectionUtil.isEmpty(serialCodeEoList)) {
            log.info("\u76d1\u542c\u5546\u54c1\u7cfb\u5217\u4fe1\u606f\u53d8\u66f4\u4e8b\u4ef6\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        List ids = serialCodeEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        List serialCodeEos = this.serialCodeDomain.selectByIds(ids);
        if (CollectionUtil.isEmpty((Collection)serialCodeEos)) {
            log.info("serialCodeEos\u76d1\u542c\u5546\u54c1\u7cfb\u5217\u4fe1\u606f\u53d8\u66f4\u4e8b\u4ef6\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        List serialCodeDtoList = BeanUtil.copyToList((Collection)serialCodeEos, SerialCodeDto.class);
        if ("insert".equals(serialCodeMqEvent.getType())) {
            serialCodeDtoList.forEach(s -> {
                s.setId(null);
                log.info("\u76d1\u542c\u5546\u54c1\u7cfb\u5217\u65b0\u589eid:{}", (Object)s.getId());
            });
        }
        this.commonsMqService.sendSingleMessage("SERIAL_CODE_CHANGE_LOG_TAG_DG", (Object)JacksonUtil.toJson((Object)serialCodeDtoList));
    }
}

