/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.item.api.item.IItemChangeApplyApi;
import com.yunxi.dg.base.center.item.dto.request.ChangeApplyAuditDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemChangeApplyDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.AuditResultDgRespDto;
import com.yunxi.dg.base.center.item.service.cache.IItemCacheClearDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemChangeApplyDgService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ItemChangeApplyApiImpl
implements IItemChangeApplyApi {
    @Resource
    private IItemChangeApplyDgService itemChangeApplyDgService;
    @Autowired
    List<IItemCacheClearDgService> itemCacheClearServiceList;

    public RestResponse<Long> add(ItemChangeApplyDgReqDto itemChangeApplyDgReqDto) {
        return new RestResponse((Object)this.itemChangeApplyDgService.add(itemChangeApplyDgReqDto));
    }

    public RestResponse<Void> commit(Long id) {
        this.itemChangeApplyDgService.commit(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> updateItemChangeApply(ItemChangeApplyDgReqDto itemChangeApplyDgReqDto) {
        return new RestResponse((Object)this.itemChangeApplyDgService.update(itemChangeApplyDgReqDto));
    }

    public RestResponse<AuditResultDgRespDto> audit(ChangeApplyAuditDgReqDto changeApplyAuditDgReqDto) {
        AuditResultDgRespDto audit = this.itemChangeApplyDgService.audit(changeApplyAuditDgReqDto);
        if (audit != null) {
            this.cleanCache(audit.getItemId());
        }
        return new RestResponse((Object)audit);
    }

    private void cleanCache(Long itemId) {
        if (itemId == null) {
            return;
        }
        if (CollectionUtils.isEmpty(this.itemCacheClearServiceList)) {
            return;
        }
        this.itemCacheClearServiceList.forEach(itemChangeApplyService -> itemChangeApplyService.clear(itemId));
    }
}

