/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl.query;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.api.itemStorage.IItemStorageDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.BaseReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageBranchQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageDetailQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.BundleItemStorageDgDto;
import com.yunxi.dg.base.center.item.dto.response.ItemStorageDetailQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemStorageQueryDgRespDto;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IItemStorageDgService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ItemStorageDgQueryApiImpl
implements IItemStorageDgQueryApi {
    @Resource
    private IItemStorageDgService itemStorageDgService;

    public RestResponse<List<ItemStorageQueryDgRespDto>> queryBranchItemStorage(ItemStorageBranchQueryDgReqDto itemStorageBranchQueryDgReqDto) {
        List<ItemStorageQueryDgRespDto> itemStorageQueryDgRespDtos = this.itemStorageDgService.queryBranchItemStorage(itemStorageBranchQueryDgReqDto);
        return new RestResponse(itemStorageQueryDgRespDtos);
    }

    public RestResponse<List<ItemStorageQueryDgRespDto>> queryItemStorage(List<ItemStorageQueryDgReqDto> reqDtoList) {
        if (CollectionUtil.isEmpty(reqDtoList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ItemStorageQueryDgReqDto itemStorageQueryDgReqDto = reqDtoList.get(0);
        Long instanceId = itemStorageQueryDgReqDto.getInstanceId();
        Long tenantId = itemStorageQueryDgReqDto.getTenantId();
        return new RestResponse(this.itemStorageDgService.queryItemStorage(reqDtoList, instanceId, tenantId));
    }

    public RestResponse<PageInfo<ItemStorageDetailQueryDgRespDto>> queryManageItemStorageDetail(ItemStorageDetailQueryDgReqDto itemStorageDetailQueryDgReqDto, Integer pageNum, Integer pageSize) {
        if (itemStorageDetailQueryDgReqDto == null || itemStorageDetailQueryDgReqDto.getInstanceId() == null || itemStorageDetailQueryDgReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        return new RestResponse(this.itemStorageDgService.queryItemStorageDetail(itemStorageDetailQueryDgReqDto, pageNum, pageSize));
    }

    public RestResponse<ItemStorageDetailQueryDgRespDto> queryItemStorageDetail(Long id, BaseReqDto baseReqDto) {
        if (baseReqDto == null || baseReqDto.getInstanceId() == null || baseReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        return new RestResponse((Object)this.itemStorageDgService.queryItemStorageDetail(id, baseReqDto.getInstanceId(), baseReqDto.getTenantId()));
    }

    public RestResponse<List<BundleItemStorageDgDto>> queryBundleItemStorage(Long itemId, Long shopId) {
        List<BundleItemStorageDgDto> bundleItemStorageDgDtoList = this.itemStorageDgService.queryBundleItemStorage(itemId, shopId);
        return new RestResponse(bundleItemStorageDgDtoList);
    }
}

