/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl.query;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.api.tag.IItemTagDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.TagDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.TagDgRespDto;
import com.yunxi.dg.base.center.item.eo.TagDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IItemTagDgService;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ItemTagDgQueryApiImpl
implements IItemTagDgQueryApi {
    @Resource
    private IItemTagDgService itemTagDgService;

    public RestResponse<PageInfo<TagDgRespDto>> queryByPage(TagDgReqDto dto, Integer pageNum, Integer pageSize) {
        TagDgEo tagDgEo = TagDgEo.newInstance((Map)dto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)tagDgEo);
        QueryParamDgUtils.fillQueryCreateStartTime(dto.getCreateBeginTime(), (BaseEo)tagDgEo);
        QueryParamDgUtils.fillQueryCreateEndTime(dto.getCreateEndTime(), (BaseEo)tagDgEo);
        QueryParamDgUtils.fillQueryUpdateStartTime(dto.getUpdateBeginTime(), (BaseEo)tagDgEo);
        QueryParamDgUtils.fillQueryUpdateEndTime(dto.getUpdateEndTime(), (BaseEo)tagDgEo);
        QueryParamDgUtils.columnLike((BaseEo)tagDgEo, "keywords", tagDgEo.getKeywords());
        PageInfo<TagDgEo> tagEoPageInfo = this.itemTagDgService.queryByPage(tagDgEo, pageNum, pageSize);
        PageInfo responseTagDtoPageInfo = new PageInfo();
        ArrayList tagDgRespDtos = new ArrayList();
        CubeBeanUtils.copyProperties((Object)responseTagDtoPageInfo, tagEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)tagEoPageInfo.getList(), tagDgRespDtos, TagDgRespDto.class);
        responseTagDtoPageInfo.setList(tagDgRespDtos);
        return new RestResponse((Object)responseTagDtoPageInfo);
    }

    public RestResponse<TagDgRespDto> queryById(Long id) {
        TagDgEo tagDgEo = this.itemTagDgService.queryById(id);
        if (null == tagDgEo) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_TAG.getCode(), ItemExceptionCode.NON_EXIST_TAG.getMsg());
        }
        TagDgRespDto tagDgRespDto = new TagDgRespDto();
        DtoHelper.eo2Dto((BaseEo)tagDgEo, (BaseVo)tagDgRespDto);
        return new RestResponse((Object)tagDgRespDto);
    }

    public RestResponse<List<TagDgRespDto>> queryItemTagByItemId(Long itemId) {
        List<TagDgEo> tagDgEoList = this.itemTagDgService.queryItemTagByItemId(itemId);
        if (CollectionUtils.isEmpty(tagDgEoList)) {
            return new RestResponse((Object)Lists.newArrayList());
        }
        ArrayList tagDgRespDtos = new ArrayList();
        DtoHelper.eoList2DtoList(tagDgEoList, tagDgRespDtos, TagDgRespDto.class);
        return new RestResponse(tagDgRespDtos);
    }
}

