/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.commons;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import com.yunxi.dg.base.center.report.dto.tag.SearchTagRecordLinkDto;
import com.yunxi.dg.base.center.report.dto.tag.TagRecordLinkInfoDto;
import com.yunxi.dg.base.center.report.dto.tag.TagRecordLinkReqExtDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagRecordApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;

@Component
public class ReportHelper {
    @Resource
    private IReBizTagRecordApiProxy bizTagRecordApiProxy;
    public static final String NEW_PRODUCT = "New_product";
    public static final String OBSOLETE_PRODUCT = "Obsolete_product";
    public static final int PAGE_SIZE = 1000;

    public List<BizTagRecordDto> getShopSkuTag(List<Long> skuIds, List<Long> shopIds, String tagCode, boolean isShopSkuTag) {
        ArrayList list = Lists.newArrayList();
        SearchTagRecordLinkDto reqDto = new SearchTagRecordLinkDto();
        reqDto.setTagCodeList((List)Lists.newArrayList((Object[])new String[]{tagCode}));
        reqDto.setRecordLinkIdList(skuIds);
        reqDto.setRecordLinkParentIdList(shopIds);
        if (isShopSkuTag) {
            reqDto.setRecordSourceModel("SHOP_ITEM");
        } else {
            reqDto.setRecordSourceModel("BASE_ITEM");
        }
        Integer pageNumber = 1;
        while (true) {
            reqDto.setPageSize(Integer.valueOf(1000));
            reqDto.setPageNum(pageNumber);
            PageInfo tagRecordEoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.bizTagRecordApiProxy.findParams(reqDto));
            if (Objects.isNull(tagRecordEoPageInfo) || CollectionUtil.isEmpty((Collection)tagRecordEoPageInfo.getList())) break;
            list.addAll(tagRecordEoPageInfo.getList());
            Integer n = pageNumber;
            Integer n2 = pageNumber = Integer.valueOf(pageNumber + 1);
        }
        return list;
    }

    public <T> void addOrDeleteShopTag(List<Long> bizTagRecordIds, List<T> itemList, Function<T, Long> skuIdExtractor, Function<T, Long> shopIdExtractor, String tagCode) {
        TagRecordLinkInfoDto dto = new TagRecordLinkInfoDto();
        ArrayList<TagRecordLinkReqExtDto> batchAddTagRecordLink = new ArrayList<TagRecordLinkReqExtDto>();
        if (CollectionUtil.isNotEmpty(itemList)) {
            for (T item : itemList) {
                TagRecordLinkReqExtDto tagRecordLinkReqExtDto = new TagRecordLinkReqExtDto();
                tagRecordLinkReqExtDto.setRecordLinkOptType("MANUAL");
                tagRecordLinkReqExtDto.setTagCode(tagCode);
                tagRecordLinkReqExtDto.setRecordLinkId(skuIdExtractor.apply(item));
                if (shopIdExtractor != null) {
                    tagRecordLinkReqExtDto.setRecordLinkParentId(shopIdExtractor.apply(item));
                    tagRecordLinkReqExtDto.setRecordSourceModel("SHOP_ITEM");
                } else {
                    tagRecordLinkReqExtDto.setRecordSourceModel("BASE_ITEM");
                }
                batchAddTagRecordLink.add(tagRecordLinkReqExtDto);
            }
            dto.setBatchAddTagRecordLink(batchAddTagRecordLink);
        }
        if (CollectionUtil.isNotEmpty(bizTagRecordIds)) {
            dto.setBatchDeleteIds(bizTagRecordIds);
        }
        RestResponseHelper.checkOrThrow((RestResponse)this.bizTagRecordApiProxy.batchAddBizTagRecord(dto));
    }
}

