/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.JacksonUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.domain.entity.IBrandDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemRateDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISerialCodeDomain;
import com.yunxi.dg.base.center.item.domain.entity.IUnitDgDomain;
import com.yunxi.dg.base.center.item.dto.request.DgSyncItemSkuInfoDto;
import com.yunxi.dg.base.center.item.dto.sync.DgSyncItemInfoDto;
import com.yunxi.dg.base.center.item.eo.BrandDgEo;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemRateDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.SerialCodeEo;
import com.yunxi.dg.base.center.item.eo.UnitDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemUnitConversionDgService;
import com.yunxi.dg.base.center.item.service.entity.impl.adapter.AbstractDgSyncItemInfoServiceImpl;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dgIDgSyncItemInfoService")
public class DgSyncItemInfoServiceImpl
extends AbstractDgSyncItemInfoServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(DgSyncItemInfoServiceImpl.class);
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private IItemSkuDgDomain iItemSkuDgDomain;
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IBrandDgDomain brandDgDomain;
    @Resource
    private IUnitDgDomain unitDgDomain;
    @Resource
    private IItemRateDgDomain itemRateDgDomain;
    @Resource
    private IItemDgService iItemDgService;
    @Resource
    private IItemUnitConversionDgService itemUnitConversionDgService;
    @Resource
    private ISerialCodeDomain serialCodeDomain;
    @Resource
    private ILockService lockService;
    @Resource
    private DgSyncItemInfoServiceImpl xthis;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void syncItem(DgSyncItemInfoDto itemInfoDto) {
        log.info("\u540c\u6b65\u5546\u54c1syncItem{}", (Object)JSON.toJSONString((Object)itemInfoDto));
        this.verifySyncItemParam(itemInfoDto);
        ItemDgEo itemDgEo = this.itemDgDomain.selectByItemCode(itemInfoDto.getCode());
        ItemRateDgEo itemRateDgEo = new ItemRateDgEo();
        if (Objects.nonNull(itemInfoDto.getItemRate())) {
            itemRateDgEo.setRate(itemInfoDto.getItemRate());
            itemRateDgEo = (ItemRateDgEo)this.itemRateDgDomain.selectOne((BaseEo)itemRateDgEo);
        }
        this.checkSpecificationKey(itemInfoDto.getDgSyncItemSkuInfoDtos(), itemDgEo);
        this.fillItemBrandId(itemInfoDto);
        if (Objects.isNull(itemDgEo)) {
            ItemDgEo dgEo = (ItemDgEo)BeanUtil.toBean((Object)itemInfoDto, ItemDgEo.class);
            this.fillItemDirId(dgEo, itemInfoDto);
            if (Objects.nonNull(itemRateDgEo)) {
                dgEo.setRateCode(itemRateDgEo.getCode());
            }
            this.itemDgDomain.insert((BaseEo)dgEo);
            this.iItemDgService.batchOrganizationAdd(itemInfoDto.getRItemOrganizationDgDtoList(), itemInfoDto.getRItemFactoryList(), dgEo.getId(), dgEo.getCode());
            this.addItemSku(itemInfoDto.getDgSyncItemSkuInfoDtos(), dgEo);
            this.updateSpecificationKeyByItemId(dgEo.getId());
        } else {
            List<String> specificationKeys;
            BeanUtil.copyProperties((Object)itemInfoDto, (Object)itemDgEo, (String[])new String[]{"id"});
            this.fillItemDirId(itemDgEo, itemInfoDto);
            this.modifyItemSku(itemInfoDto.getDgSyncItemSkuInfoDtos(), itemDgEo);
            if (Objects.nonNull(itemRateDgEo)) {
                itemDgEo.setRateCode(itemRateDgEo.getCode());
            }
            if (CollectionUtil.isNotEmpty(specificationKeys = this.getSpecificationKeyByItemId(itemDgEo.getId()))) {
                itemDgEo.setSpecificationKeys(JacksonUtil.toJson(specificationKeys));
            }
            this.itemDgDomain.updateSelective((BaseEo)itemDgEo);
        }
    }

    private void updateSpecificationKeyByItemId(Long itemId) {
        List<String> specificationKeys = this.getSpecificationKeyByItemId(itemId);
        if (CollectionUtil.isNotEmpty(specificationKeys)) {
            ItemDgEo updateEo = new ItemDgEo();
            updateEo.setId(itemId);
            updateEo.setSpecificationKeys(JacksonUtil.toJson(specificationKeys));
            this.itemDgDomain.updateSelective((BaseEo)updateEo);
        }
    }

    private List<String> getSpecificationKeyByItemId(Long itemId) {
        List<String> specificationKeys = new ArrayList<String>();
        List itemSkuDgEos = this.iItemSkuDgDomain.selectByItemId(itemId);
        if (CollectionUtil.isNotEmpty((Collection)itemSkuDgEos)) {
            specificationKeys = itemSkuDgEos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSpecificationKey())).map(ItemSkuDgEo::getSpecificationKey).collect(Collectors.toList());
        }
        return specificationKeys;
    }

    private void verifySyncItemParam(DgSyncItemInfoDto itemInfoDto) {
        AssertUtils.notEmpty((Collection)itemInfoDto.getDgSyncItemSkuInfoDtos(), (String)"sku\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((String)itemInfoDto.getCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)itemInfoDto.getDgSyncItemSkuInfoDtos().stream().anyMatch(sku -> StringUtils.isEmpty((CharSequence)sku.getCode())), (String)"sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)itemInfoDto.getDgSyncItemSkuInfoDtos().stream().anyMatch(sku -> StringUtils.isEmpty((CharSequence)sku.getName())), (String)"sku\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void fillItemBrandId(DgSyncItemInfoDto itemInfoDto) {
        List itemSkuInfoDtoList = itemInfoDto.getDgSyncItemSkuInfoDtos();
        ArrayList<String> brandCodetList = new ArrayList<String>();
        if (CollectionUtil.isEmpty((Collection)itemSkuInfoDtoList)) {
            return;
        }
        List skuBrandCodetList = itemSkuInfoDtoList.stream().filter(e -> Objects.nonNull(e.getBrandCode())).map(DgSyncItemSkuInfoDto::getBrandCode).collect(Collectors.toList());
        if (Objects.nonNull(itemInfoDto.getBrandCode())) {
            brandCodetList.add(itemInfoDto.getBrandCode());
        }
        if (CollectionUtil.isNotEmpty(skuBrandCodetList)) {
            brandCodetList.addAll(skuBrandCodetList);
        }
        if (CollectionUtil.isNotEmpty(brandCodetList)) {
            List brandDgEoList = this.brandDgDomain.queryBrandByCodeList(brandCodetList);
            Map<Object, Object> brandDgEoMap = new HashMap();
            if (CollectionUtil.isNotEmpty((Collection)brandDgEoList)) {
                brandDgEoMap = brandDgEoList.stream().collect(Collectors.toMap(BrandDgEo::getCode, Function.identity(), (k1, k2) -> k2));
            }
            for (DgSyncItemSkuInfoDto itemSkuInfoDto : itemSkuInfoDtoList) {
                BrandDgEo brandDgEo = Objects.nonNull(brandDgEoMap.get(itemSkuInfoDto.getBrandCode())) ? (BrandDgEo)brandDgEoMap.get(itemSkuInfoDto.getBrandCode()) : (BrandDgEo)brandDgEoMap.get(itemInfoDto.getBrandCode());
                if (!Objects.nonNull(brandDgEo)) continue;
                itemSkuInfoDto.setBrand(brandDgEo.getName());
                itemSkuInfoDto.setBrandId(brandDgEo.getId());
                itemSkuInfoDto.setBrandCode(brandDgEo.getCode());
            }
        }
    }

    private void fillItemDirId(ItemDgEo dgEo, DgSyncItemInfoDto itemInfoDto) {
        Optional.ofNullable(itemInfoDto.getDirCode()).ifPresent(dirCode -> {
            List dirDgEoList = this.dirDgDomain.queryDirByCodeList((Collection)Lists.newArrayList((Object[])new String[]{dirCode}));
            if (CollectionUtil.isNotEmpty((Collection)dirDgEoList)) {
                dgEo.setDirId(((DirDgEo)dirDgEoList.get(0)).getId());
                dgEo.setDirName(((DirDgEo)dirDgEoList.get(0)).getName());
            }
        });
    }

    private void addItemSku(List<DgSyncItemSkuInfoDto> itemSkuInfoDtoList, ItemDgEo dgEo) {
        List unitDgEos;
        if (CollectionUtil.isEmpty(itemSkuInfoDtoList)) {
            return;
        }
        ArrayList<String> unitCodeList = new ArrayList<String>();
        HashSet<String> skuCodeSet = new HashSet<String>();
        Map<Object, Object> unitDgEoMap = new HashMap();
        ArrayList<String> serialCodes = new ArrayList<String>();
        for (DgSyncItemSkuInfoDto dgSyncItemSkuInfoDto : itemSkuInfoDtoList) {
            if (StringUtils.isNotBlank((CharSequence)dgSyncItemSkuInfoDto.getSerialCode())) {
                serialCodes.add(dgSyncItemSkuInfoDto.getSerialCode());
            }
            if (Objects.nonNull(dgSyncItemSkuInfoDto.getUnitCode())) {
                unitCodeList.add(dgSyncItemSkuInfoDto.getUnitCode());
            }
            if (!Objects.nonNull(dgSyncItemSkuInfoDto.getCode())) continue;
            AssertUtils.isFalse((boolean)skuCodeSet.contains(dgSyncItemSkuInfoDto.getCode()), (String)"sku\u7f16\u7801\u4e0d\u53ef\u91cd\u590d!");
            skuCodeSet.add(dgSyncItemSkuInfoDto.getCode());
        }
        Map<String, SerialCodeEo> serialCodeEoMap = this.getSerialCodeByCodes(serialCodes);
        this.checkSkuCode(skuCodeSet);
        if (CollectionUtil.isNotEmpty(unitCodeList) && CollectionUtil.isNotEmpty((Collection)(unitDgEos = this.unitDgDomain.queryByUnitDgEos(unitCodeList)))) {
            unitDgEoMap = unitDgEos.stream().collect(Collectors.toMap(UnitDgEo::getCode, Function.identity(), (oldValue, newValue) -> oldValue));
        }
        for (DgSyncItemSkuInfoDto sku : itemSkuInfoDtoList) {
            sku.setItemId(dgEo.getId());
            if (unitDgEoMap.containsKey(sku.getUnit())) {
                sku.setUnit(String.valueOf(((UnitDgEo)unitDgEoMap.get(sku.getUnit())).getCode()));
            }
            ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)BeanUtil.copyProperties((Object)sku, ItemSkuDgEo.class, (String[])new String[0]);
            itemSkuDgEo.setHomeInstall(sku.getHomeInstall());
            itemSkuDgEo.setSpecModel(sku.getSpecModel());
            itemSkuDgEo.setDirId(sku.getDirId());
            itemSkuDgEo.setDirId2(sku.getDirId2());
            itemSkuDgEo.setDirId3(sku.getDirId3());
            itemSkuDgEo.setItemCode(sku.getItemCode());
            itemSkuDgEo.setBarCode(sku.getBarCode());
            itemSkuDgEo.setGrossWeight(sku.getGrossWeight());
            itemSkuDgEo.setGrossWeightUnit(sku.getGrossWeightUnit());
            itemSkuDgEo.setVolume(sku.getVolume());
            itemSkuDgEo.setVolumeUnit(sku.getVolumeUnit());
            itemSkuDgEo.setWeightUnit(sku.getGrossWeightUnit());
            itemSkuDgEo.setNetWeight(sku.getNetWeight());
            itemSkuDgEo.setNetWeightUnit(sku.getNetWeightUnit());
            itemSkuDgEo.setWidth(sku.getWidth());
            itemSkuDgEo.setLength(sku.getLength());
            itemSkuDgEo.setHeight(sku.getHeight());
            itemSkuDgEo.setUnit(sku.getUnit());
            SerialCodeEo serialCodeEo = serialCodeEoMap.get(sku.getSerialCode());
            if (Objects.nonNull(serialCodeEo)) {
                itemSkuDgEo.setSerialId(serialCodeEo.getId());
                itemSkuDgEo.setSerialCode(serialCodeEo.getCode());
            }
            this.iItemSkuDgDomain.insert((BaseEo)itemSkuDgEo);
            this.iItemDgService.addUnitConversions(sku.getItemUnitConversions(), itemSkuDgEo, dgEo.getId(), dgEo.getCode());
        }
    }

    private void checkSpecificationKey(List<DgSyncItemSkuInfoDto> itemSkuInfoDtoList, ItemDgEo itemDgEo) {
        HashSet<String> specificationKeySet = new HashSet<String>();
        if (CollectionUtil.isEmpty(itemSkuInfoDtoList)) {
            return;
        }
        for (DgSyncItemSkuInfoDto itemSkuInfoDto : itemSkuInfoDtoList) {
            if (!Objects.nonNull(itemSkuInfoDto.getSpecificationKey())) continue;
            AssertUtils.isFalse((boolean)specificationKeySet.contains(itemSkuInfoDto.getSpecificationKey()), (String)"\u591a\u89c4\u683c\u7ec4\u5408\u4e0d\u53ef\u91cd\u590d!");
            specificationKeySet.add(itemSkuInfoDto.getSpecificationKey());
        }
        if (CollectionUtil.isEmpty(specificationKeySet) || Objects.isNull(itemDgEo)) {
            return;
        }
        List existSkuEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iItemSkuDgDomain.filter().in((Object)"specification_key", specificationKeySet)).eq((Object)"item_id", (Object)itemDgEo.getId())).list();
        if (CollectionUtil.isNotEmpty((Collection)existSkuEos)) {
            Map skuDgEoMap = existSkuEos.stream().collect(Collectors.toMap(ItemSkuDgEo::getSpecificationKey, Function.identity(), (k1, k2) -> k2));
            for (DgSyncItemSkuInfoDto itemSkuInfoDto : itemSkuInfoDtoList) {
                ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)skuDgEoMap.get(itemSkuInfoDto.getSpecificationKey());
                if (!Objects.nonNull(itemSkuDgEo)) continue;
                AssertUtils.isTrue((boolean)Objects.equals(itemSkuDgEo.getCode(), itemSkuInfoDto.getCode()), (String)(itemSkuInfoDto.getSpecificationKey() + "\u591a\u89c4\u683c\u7ec4\u5408\u5df2\u5b58\u5728!"));
            }
        }
    }

    private void checkSkuCode(Set<String> skuCodeSet) {
        List existSkuEos;
        if (CollectionUtil.isNotEmpty(skuCodeSet) && CollectionUtil.isNotEmpty((Collection)(existSkuEos = ((ExtQueryChainWrapper)this.iItemSkuDgDomain.filter().in((Object)"code", skuCodeSet)).list()))) {
            throw new BizException("sku\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }

    private void modifyItemSku(List<DgSyncItemSkuInfoDto> itemSkuInfoDtoList, ItemDgEo itemDgEo) {
        if (CollectionUtil.isEmpty(itemSkuInfoDtoList)) {
            return;
        }
        ArrayList<DgSyncItemSkuInfoDto> insertSkuInfoDtoList = new ArrayList<DgSyncItemSkuInfoDto>();
        HashMap<String, ItemSkuDgEo> skuInfoEoMap = new HashMap<String, ItemSkuDgEo>();
        List itemSkuDgEos = this.iItemSkuDgDomain.selectByItemId(itemDgEo.getId());
        ArrayList<String> serialCodes = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty((Collection)itemSkuDgEos)) {
            for (ItemSkuDgEo itemSkuDgEo : itemSkuDgEos) {
                skuInfoEoMap.put(itemSkuDgEo.getCode(), itemSkuDgEo);
                if (!StringUtils.isNotBlank((CharSequence)itemSkuDgEo.getSerialCode())) continue;
                serialCodes.add(itemSkuDgEo.getSerialCode());
            }
        }
        Map<String, SerialCodeEo> serialCodeEoMap = this.getSerialCodeByCodes(serialCodes);
        for (DgSyncItemSkuInfoDto itemSkuInfoDto : itemSkuInfoDtoList) {
            ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)skuInfoEoMap.get(itemSkuInfoDto.getCode());
            if (Objects.nonNull(itemSkuDgEo)) {
                ItemSkuDgEo updateSkuEo = new ItemSkuDgEo();
                BeanUtil.copyProperties((Object)itemSkuInfoDto, (Object)updateSkuEo, (String[])new String[0]);
                SerialCodeEo serialCodeEo = serialCodeEoMap.get(itemSkuInfoDto.getSerialCode());
                if (Objects.nonNull(serialCodeEo)) {
                    updateSkuEo.setSerialCode(serialCodeEo.getCode());
                    updateSkuEo.setSerialId(serialCodeEo.getId());
                }
                updateSkuEo.setItemId(itemDgEo.getId());
                updateSkuEo.setId(itemSkuDgEo.getId());
                updateSkuEo.setHomeInstall(itemSkuInfoDto.getHomeInstall());
                updateSkuEo.setSpecModel(itemSkuInfoDto.getSpecModel());
                updateSkuEo.setDirId(itemSkuInfoDto.getDirId());
                updateSkuEo.setDirId2(itemSkuInfoDto.getDirId2());
                updateSkuEo.setDirId3(itemSkuInfoDto.getDirId3());
                updateSkuEo.setItemCode(itemSkuInfoDto.getItemCode());
                updateSkuEo.setGrossWeight(itemSkuInfoDto.getGrossWeight());
                updateSkuEo.setBarCode(itemSkuInfoDto.getBarCode());
                updateSkuEo.setGrossWeightUnit(itemSkuInfoDto.getGrossWeightUnit());
                updateSkuEo.setVolume(itemSkuInfoDto.getVolume());
                updateSkuEo.setVolumeUnit(itemSkuInfoDto.getVolumeUnit());
                updateSkuEo.setWeightUnit(itemSkuInfoDto.getGrossWeightUnit());
                updateSkuEo.setNetWeight(itemSkuInfoDto.getNetWeight());
                updateSkuEo.setNetWeightUnit(itemSkuInfoDto.getNetWeightUnit());
                updateSkuEo.setWidth(itemSkuInfoDto.getWidth());
                updateSkuEo.setLength(itemSkuInfoDto.getLength());
                updateSkuEo.setHeight(itemSkuInfoDto.getHeight());
                updateSkuEo.setUnit(itemSkuInfoDto.getUnit());
                this.iItemSkuDgDomain.updateSelective((BaseEo)updateSkuEo);
                this.itemUnitConversionDgService.logicDeleteBySkuIds(Lists.newArrayList((Object[])new Long[]{itemSkuDgEo.getId()}));
                this.iItemDgService.addUnitConversions(itemSkuInfoDto.getItemUnitConversions(), itemSkuDgEo, itemDgEo.getId(), itemDgEo.getCode());
                continue;
            }
            insertSkuInfoDtoList.add(itemSkuInfoDto);
        }
        if (CollectionUtil.isNotEmpty(insertSkuInfoDtoList)) {
            this.addItemSku(insertSkuInfoDtoList, itemDgEo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncItemBatch(List<DgSyncItemInfoDto> itemInfoDtos) {
        Mutex lock = null;
        for (DgSyncItemInfoDto itemInfoDto : itemInfoDtos) {
            try {
                lock = this.lockService.lock("batchSyncItem", itemInfoDto.getCode(), 10, 30, TimeUnit.SECONDS);
                this.xthis.syncItem(itemInfoDto);
            }
            catch (Exception e) {
                try {
                    log.info("\u5546\u54c1\u540c\u6b65\u5931\u8d25,\u62a5\u9519\u4fe1\u606f\uff1a{}", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (Objects.nonNull(lock)) {
                        this.lockService.unlock(lock);
                    }
                    throw throwable;
                }
                if (!Objects.nonNull(lock)) continue;
                this.lockService.unlock(lock);
                continue;
            }
            if (!Objects.nonNull(lock)) continue;
            this.lockService.unlock(lock);
        }
    }

    private Map<String, SerialCodeEo> getSerialCodeByCodes(List<String> serialCodes) {
        List serialCodeEos;
        Map<String, Object> serialCodeEoMap = new HashMap<String, SerialCodeEo>();
        if (CollectionUtil.isNotEmpty(serialCodes) && CollectionUtil.isNotEmpty((Collection)(serialCodeEos = ((ExtQueryChainWrapper)this.serialCodeDomain.filter().in((Object)"code", serialCodes)).list()))) {
            serialCodeEoMap = serialCodeEos.stream().collect(Collectors.toMap(SerialCodeEo::getCode, Function.identity(), (k1, k2) -> k2));
        }
        return serialCodeEoMap;
    }
}

