/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.constants.PropGroupUsageTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.SpecificationGroupDgEnum;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirPropRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IPropGroupDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IPropGroupRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IPropNameDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IPropValueDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IRDirSpecificationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISpecificationGroupDomain;
import com.yunxi.dg.base.center.item.dto.request.DirSpecificationGroupDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.PropGroupDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DirPropRelationMapRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirPropRelationRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirSpecificationRelationMapRespDto;
import com.yunxi.dg.base.center.item.dto.response.SpecificationGroupDetailRespDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.DirPropRelationDgEo;
import com.yunxi.dg.base.center.item.eo.RDirSpecificationDgEo;
import com.yunxi.dg.base.center.item.service.entity.IDirPropRelationDgService;
import com.yunxi.dg.base.center.item.service.entity.ISpecificationGroupService;
import com.yunxi.dg.base.center.item.service.util.ConvertDgUtil;
import com.yunxi.dg.base.center.prop.api.prop.IPropQueryDgApi;
import com.yunxi.dg.base.center.prop.dto.Schemas.PropGroupQuoteReqDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirPropRelationDgServiceImpl
implements IDirPropRelationDgService {
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IDirPropRelationDgDomain dirPropRelationDgDomain;
    @Resource
    private IRDirSpecificationDgDomain rDirSpecificationDgDomain;
    @Resource
    private ISpecificationGroupDomain specificationGroupDomain;
    @Resource
    private ISpecificationGroupService specificationGroupService;
    @Resource
    private IPropGroupRelationDgDomain propGroupRelationDgDomain;
    @Resource
    private IPropGroupDgDomain propGroupDgDomain;
    @Resource
    private IPropNameDgDomain propNameDgDomain;
    @Resource
    private IPropValueDgDomain propValueDgDomain;
    @Resource
    private IPropQueryDgApi propQueryDgApi;

    @Override
    public List<Long> queryPropGroupIdsByDirId(Long dirId, Integer usage) {
        List dirPropRelationDgEos = this.dirPropRelationDgDomain.selectByDirId(dirId, Integer.valueOf(1), usage);
        return dirPropRelationDgEos.stream().map(DirPropRelationDgEo::getPropGroupId).collect(Collectors.toList());
    }

    @Override
    public List<DirPropRelationMapRespDto> queryPropGroupListByDirIds(List<Long> dirIds) {
        ArrayList<DirPropRelationMapRespDto> dirPropRelations = new ArrayList<DirPropRelationMapRespDto>();
        if (CollectionUtil.isNotEmpty(dirIds)) {
            List dgEos = this.dirPropRelationDgDomain.selectByDirIds(dirIds);
            Map<Long, List<DirPropRelationRespDto>> driMap = ((List)Optional.ofNullable(dgEos).orElse(new ArrayList())).stream().map(e -> (DirPropRelationRespDto)ConvertDgUtil.toBean((Object)e, DirPropRelationRespDto.class)).collect(Collectors.groupingBy(DirPropRelationRespDto::getDirId));
            driMap.entrySet().stream().forEach(e -> dirPropRelations.add(DirPropRelationMapRespDto.builder().driId((Long)e.getKey()).respDtoList((List)e.getValue()).build()));
        }
        return dirPropRelations;
    }

    @Override
    public List<DirSpecificationRelationMapRespDto> querySpecificationGroupByDirIds(List<Long> dirIds) {
        ArrayList<DirSpecificationRelationMapRespDto> mapRespDtos = new ArrayList<DirSpecificationRelationMapRespDto>();
        if (CollectionUtil.isEmpty(dirIds)) {
            return mapRespDtos;
        }
        List dirSpecificationDgEos = this.rDirSpecificationDgDomain.queryByDirIds(dirIds);
        if (CollectionUtil.isEmpty((Collection)dirSpecificationDgEos)) {
            return mapRespDtos;
        }
        List<Long> groupIds = dirSpecificationDgEos.stream().map(RDirSpecificationDgEo::getSpecificationGroupId).collect(Collectors.toList());
        Map<Long, List<RDirSpecificationDgEo>> dirMap = dirSpecificationDgEos.stream().collect(Collectors.groupingBy(RDirSpecificationDgEo::getDirId));
        List groupDetailRespDtos = (List)this.specificationGroupService.queryByIds(groupIds).getData();
        if (CollectionUtil.isEmpty((Collection)groupDetailRespDtos)) {
            return mapRespDtos;
        }
        Map groupMap = groupDetailRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k2));
        for (Long dirId : dirIds) {
            List<RDirSpecificationDgEo> rDirSpecificationDgEos = dirMap.get(dirId);
            if (!CollectionUtil.isNotEmpty(rDirSpecificationDgEos)) continue;
            DirSpecificationRelationMapRespDto relationMapRespDto = new DirSpecificationRelationMapRespDto();
            ArrayList<SpecificationGroupDetailRespDto> respDtoList = new ArrayList<SpecificationGroupDetailRespDto>();
            for (RDirSpecificationDgEo dgEo : rDirSpecificationDgEos) {
                SpecificationGroupDetailRespDto detailRespDto = (SpecificationGroupDetailRespDto)groupMap.get(dgEo.getSpecificationGroupId());
                if (Objects.isNull(detailRespDto)) continue;
                respDtoList.add(detailRespDto);
            }
            relationMapRespDto.setDriId(dirId);
            relationMapRespDto.setRespDtoList(respDtoList);
            mapRespDtos.add(relationMapRespDto);
        }
        return mapRespDtos;
    }

    @Override
    public List<SpecificationGroupDetailRespDto> querySpecificationGroupByDirId(Long dirId) {
        ArrayList<SpecificationGroupDetailRespDto> respDtoList = new ArrayList<SpecificationGroupDetailRespDto>();
        List dirSpecificationDgEos = this.rDirSpecificationDgDomain.queryByDirIds(Arrays.asList(dirId));
        if (CollectionUtil.isEmpty((Collection)dirSpecificationDgEos)) {
            return respDtoList;
        }
        List<Long> groupIds = dirSpecificationDgEos.stream().map(RDirSpecificationDgEo::getSpecificationGroupId).collect(Collectors.toList());
        return (List)this.specificationGroupService.queryByIds(groupIds).getData();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDirPropGroup(Long dirId, List<PropGroupDgReqDto> propGroupDgReqDtos) {
        DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dirId);
        if (dirDgEo == null) {
            throw new BizException("\u7c7b\u76ee\u4e0d\u5b58\u5728");
        }
        HashSet<Long> propGroupIds = new HashSet();
        if (CollectionUtils.isNotEmpty(propGroupDgReqDtos) && CollectionUtils.isNotEmpty(propGroupIds = propGroupDgReqDtos.stream().map(PropGroupDgReqDto::getId).filter(Objects::nonNull).collect(Collectors.toSet()))) {
            this.verifyPropGroup(propGroupIds);
        }
        this.dirPropRelationDgDomain.deleteByDirId(dirId, Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty(propGroupIds)) {
            List dirPropRelationDgEoList = propGroupDgReqDtos.stream().map(propGroupReqDto -> {
                DirPropRelationDgEo dirPropRelationDgEo = new DirPropRelationDgEo();
                dirPropRelationDgEo.setDirId(dirId);
                dirPropRelationDgEo.setPropType(Integer.valueOf(1));
                dirPropRelationDgEo.setPropGroupUsageType(Integer.valueOf(propGroupReqDto.getPropGroupUsageType() == null ? PropGroupUsageTypeDgEnum.base.getCode() : propGroupReqDto.getPropGroupUsageType().intValue()));
                dirPropRelationDgEo.setPropGroupId(propGroupReqDto.getId());
                dirPropRelationDgEo.setTenantId(dirDgEo.getTenantId());
                dirPropRelationDgEo.setInstanceId(dirDgEo.getInstanceId());
                return dirPropRelationDgEo;
            }).collect(Collectors.toList());
            this.dirPropRelationDgDomain.insertBatch(dirPropRelationDgEoList);
        }
        this.quotePropGroup(new ArrayList<Long>(propGroupIds));
    }

    private void verifyPropGroup(Set<Long> propGroupIds) {
        ArrayList<Long> propGroupIdList = new ArrayList<Long>(propGroupIds);
        List propGroupRespDtos = (List)this.propQueryDgApi.batchQueryPropGroupById(propGroupIdList).getData();
        if (CollectionUtils.isEmpty((Collection)propGroupRespDtos)) {
            throw new BizException("\u5c5e\u6027\u7ec4\u4e0d\u5b58\u5728");
        }
    }

    private void quotePropGroup(List<Long> propGroupIds) {
        if (CollectionUtil.isNotEmpty(propGroupIds)) {
            PropGroupQuoteReqDto reqDto = new PropGroupQuoteReqDto();
            reqDto.setIds(propGroupIds);
            reqDto.setIsUse(Integer.valueOf(1));
            this.propQueryDgApi.groupQuoteByIds(reqDto);
        }
    }

    @Override
    public void deleteDirPropRelation(List<Long> dirIds) {
        List dirPropRelationDgEos;
        if (CollectionUtil.isNotEmpty(dirIds) && CollectionUtil.isNotEmpty((Collection)(dirPropRelationDgEos = this.dirPropRelationDgDomain.selectByDirIds(dirIds)))) {
            ArrayList<Long> canalGroupIds = new ArrayList<Long>();
            List groupIds = dirPropRelationDgEos.stream().filter(e -> Objects.nonNull(e.getPropGroupId())).map(DirPropRelationDgEo::getPropGroupId).collect(Collectors.toList());
            this.dirPropRelationDgDomain.removeByDirIds(dirIds);
            List relationDgEos = this.dirPropRelationDgDomain.selectByPropGroupId(groupIds);
            Set groupIdSet = relationDgEos.stream().filter(e -> Objects.nonNull(e.getPropGroupId())).map(DirPropRelationDgEo::getPropGroupId).collect(Collectors.toSet());
            for (Long groupId : groupIds) {
                if (groupIdSet.contains(groupId)) continue;
                canalGroupIds.add(groupId);
            }
            if (CollectionUtil.isNotEmpty(canalGroupIds)) {
                PropGroupQuoteReqDto reqDto = new PropGroupQuoteReqDto();
                reqDto.setIds(canalGroupIds);
                reqDto.setIsUse(Integer.valueOf(0));
                this.propQueryDgApi.groupQuoteByIds(reqDto);
            }
        }
    }

    private void canalQuotePropGroup(List<Long> propGroupIds) {
        if (CollectionUtil.isNotEmpty(propGroupIds)) {
            List relationDgEos = this.dirPropRelationDgDomain.selectByPropGroupId(propGroupIds);
            if (CollectionUtil.isNotEmpty((Collection)relationDgEos)) {
                for (DirPropRelationDgEo relationDgEo : relationDgEos) {
                    propGroupIds.remove(relationDgEo.getPropGroupId());
                }
            }
            if (CollectionUtil.isNotEmpty(propGroupIds)) {
                PropGroupQuoteReqDto reqDto = new PropGroupQuoteReqDto();
                reqDto.setIds(propGroupIds);
                reqDto.setIsUse(Integer.valueOf(0));
                this.propQueryDgApi.groupQuoteByIds(reqDto);
            }
        }
    }

    private void canalQuoteSpecificationGroup(List<Long> propGroupIds) {
        if (CollectionUtil.isNotEmpty(propGroupIds)) {
            List relationDgEos = ((ExtQueryChainWrapper)this.rDirSpecificationDgDomain.filter().in((Object)"specification_group_id", propGroupIds)).list();
            if (CollectionUtil.isNotEmpty((Collection)relationDgEos)) {
                for (RDirSpecificationDgEo relationDgEo : relationDgEos) {
                    propGroupIds.remove(relationDgEo.getSpecificationGroupId());
                }
            }
            if (CollectionUtil.isNotEmpty(propGroupIds)) {
                this.specificationGroupDomain.quoteSpecificationGroup(propGroupIds, Integer.valueOf(SpecificationGroupDgEnum.notUse.getCode()));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addDirPropGroup(Long dirId, Set<Long> propGroupIds) {
        AssertUtils.notNull((Object)dirId, (String)"\u7c7b\u76eeid\u4e0d\u53ef\u4e3a\u7a7a");
        DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dirId);
        if (dirDgEo == null) {
            throw new BizException("\u7c7b\u76ee\u4e0d\u5b58\u5728");
        }
        this.dirPropRelationDgDomain.deleteByDirId(dirId, Integer.valueOf(1));
        if (CollectionUtil.isNotEmpty(propGroupIds)) {
            this.verifyPropGroup(propGroupIds);
            List dirPropRelationDgEoList = propGroupIds.stream().map(propGroupId -> {
                DirPropRelationDgEo dirPropRelationDgEo = new DirPropRelationDgEo();
                dirPropRelationDgEo.setDirId(dirId);
                dirPropRelationDgEo.setPropType(Integer.valueOf(1));
                dirPropRelationDgEo.setPropGroupUsageType(Integer.valueOf(PropGroupUsageTypeDgEnum.base.getCode()));
                dirPropRelationDgEo.setPropGroupId(propGroupId);
                dirPropRelationDgEo.setTenantId(dirDgEo.getTenantId());
                dirPropRelationDgEo.setInstanceId(dirDgEo.getInstanceId());
                return dirPropRelationDgEo;
            }).collect(Collectors.toList());
            this.dirPropRelationDgDomain.insertBatch(dirPropRelationDgEoList);
        }
        this.quotePropGroup(new ArrayList<Long>(propGroupIds));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addDirSpecificationGroup(DirSpecificationGroupDgReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)reqDto.getDirId(), (String)"\u7c7b\u76eeid\u4e0d\u53ef\u4e3a\u7a7a");
        DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(reqDto.getDirId());
        AssertUtils.notNull((Object)dirDgEo, (String)"\u7c7b\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728!");
        this.addRDirSpecification(reqDto.getGroupIdList(), reqDto.getDirId());
    }

    @Override
    public void addRDirSpecification(List<Long> groupIdList, Long dirId) {
        if (CollectionUtil.isEmpty(groupIdList) || Objects.isNull(dirId)) {
            return;
        }
        this.removeSpecificationGroup(dirId, groupIdList);
        if (CollectionUtil.isNotEmpty(groupIdList)) {
            AssertUtils.isTrue((groupIdList.size() < 2 ? 1 : 0) != 0, (String)"\u540c\u4e00\u4e2a\u7c7b\u76ee\u4e0b\u53ea\u53ef\u5173\u8054\u4e00\u4e2a\u89c4\u683c\u5c5e\u6027\u7ec4!");
            ArrayList<RDirSpecificationDgEo> rDirSpecificationDgEos = new ArrayList<RDirSpecificationDgEo>();
            HashSet<Long> existIds = new HashSet<Long>(groupIdList);
            for (Long groupId : existIds) {
                RDirSpecificationDgEo rDirSpecificationDgEo = new RDirSpecificationDgEo();
                rDirSpecificationDgEo.setDirId(dirId);
                rDirSpecificationDgEo.setSpecificationType(Integer.valueOf(1));
                rDirSpecificationDgEo.setSpecificationGroupUsageType(Integer.valueOf(PropGroupUsageTypeDgEnum.base.getCode()));
                rDirSpecificationDgEo.setSpecificationGroupId(groupId);
                rDirSpecificationDgEos.add(rDirSpecificationDgEo);
            }
            this.rDirSpecificationDgDomain.insertBatch(rDirSpecificationDgEos);
            this.specificationGroupDomain.quoteSpecificationGroup(groupIdList, Integer.valueOf(SpecificationGroupDgEnum.isUse.getCode()));
        }
    }

    private void removeSpecificationGroup(Long dirId, List<Long> groupIds) {
        List relationDgEos = ((ExtQueryChainWrapper)this.rDirSpecificationDgDomain.filter().eq((Object)"dir_id", (Object)dirId)).list();
        if (CollectionUtil.isNotEmpty((Collection)relationDgEos)) {
            List<Long> existGroupIds = relationDgEos.stream().map(RDirSpecificationDgEo::getSpecificationGroupId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(groupIds)) {
                existGroupIds.removeAll(groupIds);
            }
            this.canalQuoteSpecificationGroup(existGroupIds);
        }
        this.rDirSpecificationDgDomain.deleteByDirIds(Arrays.asList(dirId));
    }

    @Override
    public void removeDirSpecificationGroup(DirSpecificationGroupDgReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)reqDto.getDirId(), (String)"\u7c7b\u76eeid\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notEmpty((Collection)reqDto.getGroupIdList(), (String)"\u5c5e\u6027\u7ec4ids\u4e0d\u53ef\u4e3a\u7a7a!");
        this.rDirSpecificationDgDomain.removeDirSpecificationGroupByDirIdAndGroupIds(reqDto.getDirId(), reqDto.getGroupIdList());
        this.canalQuoteSpecificationGroup(reqDto.getGroupIdList());
    }

    @Override
    public void updateDirPropGroupUsage(Long dirId, Long propGroupId, Integer usage) {
        DirPropRelationDgEo dirPropRelationDgEo = this.dirPropRelationDgDomain.selectOneByParam(dirId, propGroupId);
        if (dirPropRelationDgEo == null) {
            throw new BizException("\u7c7b\u76ee\u4e0b\u4e0d\u5b58\u5728\u8be5\u5c5e\u6027\u7ec4");
        }
        dirPropRelationDgEo.setPropGroupUsageType(Integer.valueOf(usage != null ? usage.intValue() : PropGroupUsageTypeDgEnum.base.getCode()));
        this.dirPropRelationDgDomain.updateSelective((BaseEo)dirPropRelationDgEo);
    }

    @Override
    public void removeDirPropGroup(Long dirId, Set<Long> propGroupIds) {
        AssertUtils.notNull((Object)dirId, (String)"\u7c7b\u76eeid\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notEmpty(propGroupIds, (String)"\u5c5e\u6027\u7ec4ids\u4e0d\u53ef\u4e3a\u7a7a!");
        this.dirPropRelationDgDomain.removeDirPropGroupByDirIdAndGroupIds(dirId, propGroupIds);
        this.canalQuotePropGroup(new ArrayList<Long>(propGroupIds));
    }

    @Override
    public void updateDirPropGroupSort(Long dirId, Long propGroupId, String action) {
    }

    @Override
    public void copyDirPropGroup(Long sourceDirId, Long targetDirId) {
        List sourceDirPropRelationDgEoList = this.dirPropRelationDgDomain.selectByDirId(sourceDirId, Integer.valueOf(1), null);
        if (CollectionUtils.isNotEmpty((Collection)sourceDirPropRelationDgEoList)) {
            List dirPropRelationDgEoList = this.dirPropRelationDgDomain.selectByDirId(targetDirId, Integer.valueOf(1), null);
            List<Object> propGroupIdList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)dirPropRelationDgEoList)) {
                propGroupIdList = dirPropRelationDgEoList.stream().map(DirPropRelationDgEo::getPropGroupId).distinct().collect(Collectors.toList());
            }
            ArrayList targetDirPropRelationDgEoList = Lists.newArrayList();
            ArrayList finalPropGroupIdList = propGroupIdList;
            sourceDirPropRelationDgEoList.forEach(sourceDirPropRelationDgEo -> {
                if (!finalPropGroupIdList.contains(sourceDirPropRelationDgEo.getPropGroupId())) {
                    DirPropRelationDgEo targetDirPropRelationDgEo = new DirPropRelationDgEo();
                    targetDirPropRelationDgEo.setDirId(targetDirId);
                    targetDirPropRelationDgEo.setPropType(Integer.valueOf(1));
                    targetDirPropRelationDgEo.setPropGroupUsageType(sourceDirPropRelationDgEo.getPropGroupUsageType());
                    targetDirPropRelationDgEo.setPropGroupId(sourceDirPropRelationDgEo.getPropGroupId());
                    targetDirPropRelationDgEo.setSellerId(sourceDirPropRelationDgEo.getSellerId());
                    targetDirPropRelationDgEo.setInstanceId(sourceDirPropRelationDgEo.getInstanceId());
                    targetDirPropRelationDgEo.setTenantId(sourceDirPropRelationDgEo.getTenantId());
                    targetDirPropRelationDgEoList.add(targetDirPropRelationDgEo);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)targetDirPropRelationDgEoList)) {
                this.dirPropRelationDgDomain.insertBatch((List)targetDirPropRelationDgEoList);
            }
        }
    }
}

