/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirIndexDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirItemRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirPropRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IFrontShopRelationBackDgDomain;
import com.yunxi.dg.base.center.item.dto.request.DirTreeDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.RootDirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DirIndexDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirIndexDgTreeDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemTreeDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.DirIndexDgEo;
import com.yunxi.dg.base.center.item.eo.FrontShopRelationBackDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemTreeService;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DirectoryItemTreeServiceImpl
implements IDirectoryItemTreeService {
    private Logger logger = LoggerFactory.getLogger(DirectoryItemTreeServiceImpl.class);
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IDirIndexDgDomain dirIndexDgDomain;
    @Resource
    private IDirItemRelationDgDomain dirItemRelationDgDomain;
    @Resource
    private IDirRelationDgDomain dirRelationDgDomain;
    @Resource
    private IDirPropRelationDgDomain dirPropRelationDgDomain;
    @Autowired
    private IDirectoryDgService directoryDgService;
    @Resource
    private IFrontShopRelationBackDgDomain frontShopRelationBackDgDomian;

    @Override
    @Cacheable(value={"DIR_TREE_CACHE"}, key="#dirTreeDgReqDto.instanceId+'_'+#dirTreeDgReqDto.dirUsage+'_'+#dirTreeDgReqDto.shopId+'_'+#dirTreeDgReqDto.status", unless="#result == null")
    public List<DirectoryItemTreeDto> queryDgDirTree(DirTreeDgReqDto dirTreeDgReqDto) {
        DirIndexDgEo example = DirIndexDgEo.newInstance();
        example.setDirUsage(dirTreeDgReqDto.getDirUsage());
        example.setInstanceId(dirTreeDgReqDto.getInstanceId());
        example.setTenantId(dirTreeDgReqDto.getTenantId());
        example.setShopId(dirTreeDgReqDto.getShopId());
        List<DirIndexDgEo> directoryEos = this.directoryDgService.queryDirectory(example);
        ArrayList<Long> idsList = new ArrayList<Long>();
        for (DirIndexDgEo directoryEo : directoryEos) {
            idsList.add(directoryEo.getRootId());
        }
        return this.queryDirByRootIds(idsList, dirTreeDgReqDto.getStatus());
    }

    @Override
    public List<DirectoryItemTreeDto> queryDirByRootIds(List<Long> rootIds, Integer status) {
        ArrayList<DirectoryItemTreeDto> trees = new ArrayList<DirectoryItemTreeDto>();
        if (CollectionUtils.isEmpty(rootIds)) {
            return null;
        }
        List dirDgEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDgDomain.filter().in((Object)"id", rootIds)).eq(Objects.nonNull(status), (Object)"status", (Object)status)).orderByAsc((Object)"sort")).list();
        for (DirDgEo eo : dirDgEoList) {
            List<DirDgEo> dirList = this.queryDirByRootId(eo.getId(), status);
            if (!CollectionUtils.isNotEmpty(dirList)) continue;
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList(dirList, dtoList, DirectoryItemDgRespDto.class);
            List tree = DirectoryItemTreeDto.createTreeDto(dtoList);
            trees.addAll(tree);
        }
        return trees;
    }

    private List<DirDgEo> queryDirByRootId(Long rootId, Integer status) {
        DirDgEo queryEo = new DirDgEo();
        queryEo.setId(rootId);
        DirDgEo dir = (DirDgEo)this.dirDgDomain.selectOne((BaseEo)queryEo);
        if (null == dir) {
            return null;
        }
        DirDgEo example = DirDgEo.newInstance();
        example.setRootId(dir.getRootId());
        example.setOrderBy("sort");
        example.setStatus(status);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.gt((String)"parent_id", (Object)0));
        example.setSqlFilters(sqlFilters);
        List dirs = this.dirDgDomain.selectList((BaseEo)example, Integer.valueOf(0), Integer.valueOf(1000));
        dirs.add(dir);
        return dirs;
    }

    @Override
    public List<DirectoryItemTreeDto> queryDgDirectoryTreeById(Long id, String dirUsage, Long shopId) {
        return this.getDirById(id, dirUsage, null, shopId);
    }

    public List<DirectoryItemTreeDto> getDirById(Long id, String dirUsage, Integer status, Long shopId) {
        ArrayList<DirectoryItemTreeDto> trees = new ArrayList<DirectoryItemTreeDto>();
        if (id == null) {
            return null;
        }
        FrontShopRelationBackDgEo frontShopRelationBackDgEo = new FrontShopRelationBackDgEo();
        frontShopRelationBackDgEo.setBackId(id);
        frontShopRelationBackDgEo.setShopId(shopId);
        List select = this.frontShopRelationBackDgDomian.selectList((BaseEo)frontShopRelationBackDgEo);
        List frontOrShopIds = select.stream().map(e -> e.getFrontShopId()).collect(Collectors.toList());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", frontOrShopIds));
        DirDgEo dirDgEo = new DirDgEo();
        dirDgEo.setOrderBy("sort");
        dirDgEo.setStatus(status);
        dirDgEo.setSqlFilters(sqlFilters);
        List dirDgEoList = this.dirDgDomain.selectList((BaseEo)dirDgEo);
        for (DirDgEo eo : dirDgEoList) {
            List<DirDgEo> dirList = this.queryDirByRootId(eo.getId(), status);
            if (!CollectionUtils.isNotEmpty(dirList)) continue;
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList(dirList, dtoList, DirectoryItemDgRespDto.class);
            List tree = DirectoryItemTreeDto.createTreeDto(dtoList);
            trees.addAll(tree);
        }
        return trees;
    }

    @Override
    public List<DirectoryItemTreeDto> queryDgDirTreeByName(String name, List<Long> rootIds) {
        ArrayList<DirectoryItemTreeDto> trees = new ArrayList<DirectoryItemTreeDto>();
        if (CollectionUtils.isEmpty(rootIds)) {
            return null;
        }
        DirDgEo dirEo = new DirDgEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"rootId", (Object)StringUtils.join(rootIds, (String)",")));
        sqlFilterList.add(SqlFilter.like((String)"name", (Object)name));
        dirEo.setSqlFilters(sqlFilterList);
        dirEo.setOrderBy("sort");
        dirEo.setStatus(null);
        List dirEoList = this.dirDgDomain.selectList((BaseEo)dirEo);
        for (DirDgEo eo : dirEoList) {
            List<DirDgEo> dirList = this.queryDirByRootId(eo.getId(), null);
            if (!CollectionUtils.isNotEmpty(dirList)) continue;
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList(dirList, dtoList, DirectoryItemDgRespDto.class);
            List tree = DirectoryItemTreeDto.createTreeDto(dtoList);
            trees.addAll(tree);
        }
        return trees;
    }

    @Override
    public List<DirIndexDgTreeDto> queryDgDirTreeDetail(RootDirectoryDgReqDto rootDirectoryDgReqDto) {
        if (rootDirectoryDgReqDto == null || rootDirectoryDgReqDto.getInstanceId() == null || rootDirectoryDgReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        ArrayList<DirIndexDgTreeDto> treeDtoList = new ArrayList<DirIndexDgTreeDto>();
        DirIndexDgEo dirIndexDgEo = DirIndexDgEo.newInstance((Map)rootDirectoryDgReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)rootDirectoryDgReqDto, (BaseEo)dirIndexDgEo);
        QueryParamDgUtils.columnLike((BaseEo)dirIndexDgEo, "name", dirIndexDgEo.getName());
        List dirIndexDgEoList = this.dirIndexDgDomain.selectList((BaseEo)dirIndexDgEo);
        if (CollectionUtils.isEmpty((Collection)dirIndexDgEoList)) {
            return treeDtoList;
        }
        HashSet<Long> rootIdList = new HashSet<Long>();
        for (DirIndexDgEo indexEo : dirIndexDgEoList) {
            rootIdList.add(indexEo.getRootId());
        }
        if (CollectionUtils.isEmpty(rootIdList)) {
            return treeDtoList;
        }
        DirDgEo dirDgEo = new DirDgEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(rootIdList, (String)",")));
        dirDgEo.setSqlFilters(sqlFilterList);
        dirDgEo.setOrderBy("sort");
        List dirDgEoList = this.dirDgDomain.selectList((BaseEo)dirDgEo);
        for (DirDgEo eo : dirDgEoList) {
            for (DirIndexDgEo indexEo : dirIndexDgEoList) {
                if (!eo.getId().equals(indexEo.getRootId())) continue;
                List<DirDgEo> dirList = this.queryDirByRootId(eo.getId(), null);
                ArrayList dtoList = new ArrayList();
                DtoHelper.eoList2DtoList(dirList, dtoList, DirIndexDgRespDto.class);
                List tree = DirIndexDgTreeDto.createTreeDto(dtoList);
                DirIndexDgRespDto dirIndexRespDto = ((DirIndexDgTreeDto)tree.get(0)).getNode();
                dirIndexRespDto.setIndexId(indexEo.getId());
                dirIndexRespDto.setIndexName(indexEo.getName());
                dirIndexRespDto.setIndexExtension(indexEo.getExtension());
                if (!eo.getParentId().equals(0L) || eo.getCreateTime().getTime() - indexEo.getCreateTime().getTime() < -100L) {
                    dirIndexRespDto.setLink(eo.getId());
                }
                treeDtoList.addAll(tree);
            }
        }
        return treeDtoList;
    }
}

