/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.common.constant.ItemStatus;
import com.yunxi.dg.base.center.item.common.enums.ItemTypeDg;
import com.yunxi.dg.base.center.item.constants.ItemBusTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.ItemDgStatus;
import com.yunxi.dg.base.center.item.dao.vo.ShelfDgQueryReqVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfItemDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfItemSkuDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfListDgRespVo;
import com.yunxi.dg.base.center.item.domain.entity.IDirItemRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemMediasDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemPriceDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemStorageDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfPointsDeductionDgDomain;
import com.yunxi.dg.base.center.item.dto.request.DirItemRelativeDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemShelfQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemShelfQueryReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DirItemRelativeQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemAttributesDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemBundlesDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemPriceDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfSkuDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PointsDeductionDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfIntegralDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfListRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfQueryDgRespDto;
import com.yunxi.dg.base.center.item.eo.DirItemRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemBundleRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemMediasDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.ItemStorageDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfPointsDeductionDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IDirDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemAttributesDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSearchDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfCacheDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfIntegralDgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IIShelfDgServiceImpl
implements IShelfDgService {
    private static final Logger logger = LoggerFactory.getLogger(IIShelfDgServiceImpl.class);
    @Resource
    private IShelfDgDomain shelfDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;
    @Autowired(required=false)
    private IShelfIntegralDgService shelfIntegralDgService;
    @Resource
    private IItemMediasDgDomain itemMediasDgDomain;
    @Resource
    private IItemPriceDgDomain itemPriceDgDomain;
    public static final String SHELF_ITEM = "SHELF_ITEM";
    @Resource
    private IDirDgService dirDgService;
    @Resource
    private IShelfPointsDeductionDgDomain shelfPointsDeductionDgDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IItemStorageDgDomain itemStorageDgDomain;
    @Autowired
    private IShelfCacheDgService shelfCacheDgService;
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IDirItemRelationDgDomain dirItemRelationDgDomain;
    @Resource
    private IItemSearchDgService itemSearchDgService;
    @Resource
    private IItemAttributesDgService itemAttributesDgService;

    @Override
    public PageInfo<ItemShelfQueryDgRespDto> getItemShelfPage(ItemShelfQueryDgReqDto itemShelfQueryDgReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        LinkedList dtoList = Lists.newLinkedList();
        ShelfItemDgVo shelfItemDgVo = new ShelfItemDgVo();
        CubeBeanUtils.copyProperties((Object)shelfItemDgVo, (Object)itemShelfQueryDgReqDto, (String[])new String[0]);
        if (itemShelfQueryDgReqDto.getGroupBy() == null) {
            shelfItemDgVo.setGroupBy(Integer.valueOf(1));
        }
        if (ItemDgStatus.ITEM_SALE_OUT.getStatus().equals(itemShelfQueryDgReqDto.getItemStatus())) {
            shelfItemDgVo.setSellOut(Boolean.valueOf(true));
            shelfItemDgVo.setItemStatus(null);
        }
        if ((pageInfo = this.shelfDgDomain.selectSelfItemByPage(shelfItemDgVo, pageNum, pageSize)) != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List voList = pageInfo.getList();
            CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)voList, ItemShelfQueryDgRespDto.class);
            List<Long> shopIdList = dtoList.stream().map(ItemShelfQueryDgRespDto::getShopId).distinct().collect(Collectors.toList());
            List<Long> itemIdList = dtoList.stream().map(ItemShelfQueryDgRespDto::getItemId).distinct().collect(Collectors.toList());
            Integer busType = itemShelfQueryDgReqDto.getBusType();
            Map<String, List<ItemShelfSkuDgRespDto>> itemShelfSkuRespDtoMap = this.queryItemShelfSkuMap(shopIdList, itemIdList, busType);
            Map<Object, Object> itemMediaMap = Maps.newHashMap();
            List itemMediasDgEoList = this.itemMediasDgDomain.selectByItemIds(itemIdList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemMediasDgEoList)) {
                itemMediaMap = itemMediasDgEoList.stream().collect(Collectors.groupingBy(ItemMediasDgEo::getItemId));
            }
            HashMap finalItemMediaMap = itemMediaMap;
            HashSet brandIds = Sets.newHashSet();
            HashSet dirIds = Sets.newHashSet();
            for (ItemShelfQueryDgRespDto itemShelfQueryDgRespDto : dtoList) {
                if (Objects.nonNull(itemShelfQueryDgRespDto.getBrandId())) {
                    brandIds.add(itemShelfQueryDgRespDto.getBrandId());
                }
                dirIds.add(itemShelfQueryDgRespDto.getDirId());
            }
            List<ItemAttributesDgRespDto> itemAttributesDgRespDtos = this.itemAttributesDgService.queryItemAttrByItemIdList(itemIdList);
            HashMap<Long, List> dirListMap = new HashMap<Long, List>();
            for (ItemAttributesDgRespDto itemAttributesDgRespDto : itemAttributesDgRespDtos) {
                JSONObject jsonObject = JSON.parseObject((String)itemAttributesDgRespDto.getAttrs());
                JSONArray backDirListJson = jsonObject.getJSONArray("backDirList");
                List backDirList = backDirListJson.toJavaList(Long.class);
                dirListMap.put(itemAttributesDgRespDto.getItemId(), backDirList);
                dirIds.addAll(backDirList);
            }
            Map<Long, String> brandMap = this.itemDgService.getBrandMapByBrandIds(Lists.newArrayList((Iterable)brandIds));
            Map<Long, String> dirMap = this.itemDgService.getDirMapByDirIds(Lists.newArrayList((Iterable)dirIds));
            List<Long> itemIds = dtoList.stream().map(ItemShelfQueryDgRespDto::getItemId).collect(Collectors.toList());
            List<Long> shopIds = dtoList.stream().map(ItemShelfQueryDgRespDto::getShopId).collect(Collectors.toList());
            List<Integer> busTypes = dtoList.stream().map(ItemShelfQueryDgRespDto::getBusType).distinct().collect(Collectors.toList());
            Map<String, List<DirItemRelativeQueryDgRespDto>> dirRelativeMap = this.itemDgService.queryItemDirRelativeBatch(itemIds, shopIds, busTypes).stream().collect(Collectors.groupingBy(o -> "" + o.getItemId() + o.getShopId() + o.getBusType()));
            dtoList.forEach(dto -> {
                Map<String, List<DirItemRelativeQueryDgRespDto>> itemFrontDirMap;
                List<DirItemRelativeQueryDgRespDto> itemFrontDirList;
                List itemMediasDgEos = (List)finalItemMediaMap.get(dto.getItemId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemMediasDgEos)) {
                    dto.setImgPath(((ItemMediasDgEo)itemMediasDgEos.get(0)).getPath1());
                }
                DirItemRelativeDgReqDto dirItemRelativeDgReqDto = new DirItemRelativeDgReqDto();
                dirItemRelativeDgReqDto.setDirType("front");
                dirItemRelativeDgReqDto.setItemId(dto.getItemId());
                dirItemRelativeDgReqDto.setShopId(dto.getShopId());
                dirItemRelativeDgReqDto.setBusType(dto.getBusType());
                List dirItemRelativeQueryDgRespDtos = (List)dirRelativeMap.get("" + dto.getItemId() + dto.getShopId() + dto.getBusType());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirItemRelativeQueryDgRespDtos) && org.apache.commons.collections.CollectionUtils.isNotEmpty(itemFrontDirList = (itemFrontDirMap = dirItemRelativeQueryDgRespDtos.stream().collect(Collectors.groupingBy(dirItemRelativeQueryRespDto -> dirItemRelativeQueryRespDto.getShopId() + dirItemRelativeQueryRespDto.getItemId() + ""))).get(dto.getShopId() + dto.getItemId() + ""))) {
                    dto.setFrontDirIdList(itemFrontDirList.stream().map(DirItemRelativeQueryDgRespDto::getDirId).distinct().collect(Collectors.toList()));
                    dto.setFrontDirNameList(itemFrontDirList.stream().map(DirItemRelativeQueryDgRespDto::getDirName).distinct().collect(Collectors.toList()));
                }
                List skuList = (List)itemShelfSkuRespDtoMap.get("" + dto.getShopId() + dto.getItemId());
                dto.setSkuList(skuList);
                if (Objects.nonNull(dto.getBrandId())) {
                    String brand = (String)brandMap.get(dto.getBrandId());
                    dto.setBrand(brand);
                }
                dto.setDirName((String)dirMap.get(dto.getDirId()));
                List dirIdList = (List)dirListMap.get(dto.getItemId());
                dto.setDirIdList(dirIdList);
                ArrayList<String> dirNameList = new ArrayList<String>();
                dto.setDirNameList(dirNameList);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirIdList)) {
                    for (Long dirId : dirIdList) {
                        String dirName = (String)dirMap.get(dirId);
                        dirNameList.add(dirName);
                    }
                }
            });
        }
        PageInfo resultPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)resultPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        resultPageInfo.setList((List)dtoList);
        return resultPageInfo;
    }

    static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    @Override
    public List<ItemShelfSkuDgRespDto> queryShelfItemSkuList(Long shopId, Long itemId, Integer busType) {
        ArrayList itemShelfSkuDgRespDtoList = Lists.newArrayList();
        List list = this.shelfDgDomain.selectSelfItemSkuList(shopId, itemId, busType);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            CubeBeanUtils.copyCollection((Collection)itemShelfSkuDgRespDtoList, (Collection)list, ItemShelfSkuDgRespDto.class);
            List skuIds = list.stream().map(ShelfItemSkuDgVo::getId).collect(Collectors.toList());
            List itemPriceDgEoList = this.itemPriceDgDomain.selectBySkuIds(skuIds);
            ArrayList itemPriceDgRespDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemPriceDgEoList, (Collection)itemPriceDgRespDtoList, ItemPriceDgRespDto.class);
            Map group = itemPriceDgRespDtoList.stream().collect(Collectors.groupingBy(ItemPriceDgRespDto::getSkuId, Collectors.toList()));
            itemShelfSkuDgRespDtoList.forEach(sku -> sku.setItemPriceList((List)group.get(sku.getId())));
        }
        List<ItemShelfSkuDgRespDto> collect = itemShelfSkuDgRespDtoList.stream().filter(itemShelfSkuRespDto -> itemShelfSkuRespDto.getId() != null).filter(IIShelfDgServiceImpl.distinctByKey(itemShelfSkuRespDto -> itemShelfSkuRespDto.getId())).collect(Collectors.toList());
        return collect;
    }

    private Map<String, List<ItemShelfSkuDgRespDto>> queryItemShelfSkuMap(List<Long> shopIdList, List<Long> itemIdList, Integer busType) {
        Map<Object, Object> itemShelfSkuMap = Maps.newHashMap();
        List shelfDgEoList = this.shelfDgDomain.selectByParam(shopIdList, itemIdList, null, busType);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfDgEoList)) {
            List itemPriceDgEoList;
            List itemStorageDgEoList;
            List<ItemShelfSkuDgRespDto> itemShelfSkuDgRespDtoList = shelfDgEoList.stream().map(shelfEo -> {
                ItemShelfSkuDgRespDto itemShelfSkuDgRespDto = new ItemShelfSkuDgRespDto();
                itemShelfSkuDgRespDto.setShopId(shelfEo.getShopId());
                itemShelfSkuDgRespDto.setItemId(shelfEo.getItemId());
                itemShelfSkuDgRespDto.setId(shelfEo.getSkuId());
                itemShelfSkuDgRespDto.setPrice(shelfEo.getPrice());
                return itemShelfSkuDgRespDto;
            }).collect(Collectors.toList());
            List skuIdList = shelfDgEoList.stream().map(ShelfDgEo::getSkuId).distinct().collect(Collectors.toList());
            List itemSkuDgEoList = this.itemSkuDgDomain.selectItemSkuByIds(skuIdList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkuDgEoList)) {
                Map itemSkuEoMap = itemSkuDgEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                itemShelfSkuDgRespDtoList.forEach(itemShelfSkuRespDto -> {
                    ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)itemSkuEoMap.get(itemShelfSkuRespDto.getId());
                    if (itemSkuDgEo != null) {
                        itemShelfSkuRespDto.setCode(itemSkuDgEo.getCode());
                        itemShelfSkuRespDto.setName(itemSkuDgEo.getName());
                        itemShelfSkuRespDto.setCspuid(itemSkuDgEo.getCspuid());
                        itemShelfSkuRespDto.setAttr(itemSkuDgEo.getAttr());
                        itemShelfSkuRespDto.setCargoCode(itemSkuDgEo.getCargoCode());
                    }
                });
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(itemStorageDgEoList = this.itemStorageDgDomain.selectByParam(shopIdList, itemIdList, skuIdList)))) {
                Map<String, List<ItemStorageDgEo>> itemStorageEoMap = itemStorageDgEoList.stream().filter(itemStorageEo -> itemStorageEo.getShopId() != null && itemStorageEo.getItemId() != null && itemStorageEo.getSkuId() != null).collect(Collectors.groupingBy(itemStorageEo -> "" + itemStorageEo.getShopId() + itemStorageEo.getItemId() + itemStorageEo.getSkuId()));
                itemShelfSkuDgRespDtoList.forEach(itemShelfSkuRespDto -> {
                    List itemStorageDgEos = (List)itemStorageEoMap.get("" + itemShelfSkuRespDto.getShopId() + itemShelfSkuRespDto.getItemId() + itemShelfSkuRespDto.getId());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemStorageDgEos)) {
                        itemShelfSkuRespDto.setBalance(((ItemStorageDgEo)itemStorageDgEos.get(0)).getBalance());
                    }
                });
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(itemPriceDgEoList = this.itemPriceDgDomain.selectBySkuIds(skuIdList)))) {
                ArrayList itemPriceDgRespDtoList = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)itemPriceDgEoList, (Collection)itemPriceDgRespDtoList, ItemPriceDgRespDto.class);
                Map itemPriceRespDtoMap = itemPriceDgRespDtoList.stream().collect(Collectors.groupingBy(ItemPriceDgRespDto::getSkuId, Collectors.toList()));
                itemShelfSkuDgRespDtoList.forEach(itemShelfSkuRespDto -> itemShelfSkuRespDto.setItemPriceList((List)itemPriceRespDtoMap.get(itemShelfSkuRespDto.getId())));
            }
            itemShelfSkuMap = itemShelfSkuDgRespDtoList.stream().collect(Collectors.groupingBy(itemShelfSkuRespDto -> "" + itemShelfSkuRespDto.getShopId() + itemShelfSkuRespDto.getItemId()));
        }
        return itemShelfSkuMap;
    }

    @Override
    public Long countItemShelf(ItemShelfQueryDgReqDto itemShelfQueryDgReqDto) {
        ShelfItemDgVo shelfItemDgVo = new ShelfItemDgVo();
        CubeBeanUtils.copyProperties((Object)shelfItemDgVo, (Object)itemShelfQueryDgReqDto, (String[])new String[0]);
        if (ItemDgStatus.ITEM_SALE_OUT.getStatus().equals(itemShelfQueryDgReqDto.getItemStatus())) {
            shelfItemDgVo.setSellOut(Boolean.valueOf(true));
            shelfItemDgVo.setItemStatus(null);
        }
        return this.shelfDgDomain.selectSelfItemCount(shelfItemDgVo);
    }

    @Override
    @Cacheable(value={"SHELF_ITEM"}, key="#itemShelfQueryReqDto.shopId+'_'+#itemShelfQueryReqDto.skuId+'_'+#itemShelfQueryReqDto.busType", unless="#result == null")
    public ItemShelfDgRespDto queryItemShelf(ShelfDgReqDto itemShelfQueryReqDto) {
        ShelfDgEo shelfDgEo = new ShelfDgEo();
        shelfDgEo.setSkuId(itemShelfQueryReqDto.getSkuId());
        shelfDgEo.setShopId(itemShelfQueryReqDto.getShopId());
        shelfDgEo.setBusType(itemShelfQueryReqDto.getBusType());
        List select = this.shelfDgDomain.selectList((BaseEo)shelfDgEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)select)) {
            ItemShelfDgRespDto itemShelfSkuRespDto = new ItemShelfDgRespDto();
            ShelfDgEo shelf = (ShelfDgEo)select.get(0);
            BeanUtils.copyProperties((Object)shelf, (Object)itemShelfSkuRespDto);
            if (shelf.getBusType() != null && shelf.getBusType().equals(ItemBusTypeDgEnum.INTEGRAL.getType()) && null != this.shelfIntegralDgService) {
                ShelfIntegralDgRespDto shelfIntegralDgRespDto = this.shelfIntegralDgService.queryByShelfId(shelf.getId());
                itemShelfSkuRespDto.setShelfIntegral(shelfIntegralDgRespDto);
            }
            return itemShelfSkuRespDto;
        }
        return null;
    }

    @Override
    public void clearItemShelfCache(ShelfDgReqDto itemShelfQueryReqDto) {
        this.shelfCacheDgService.clearItemShelfCache(itemShelfQueryReqDto);
    }

    @Override
    public void removeItemShelf(Long id) {
        ShelfDgEo shelfDgEo = (ShelfDgEo)this.shelfDgDomain.selectByPrimaryKey(id);
        if (Objects.isNull(shelfDgEo)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
        this.shelfDgDomain.logicDelete((BaseEo)shelfDgEo);
        List offDirItems = this.dirItemRelationDgDomain.selectByParam(shelfDgEo.getShopId(), shelfDgEo.getItemId());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)offDirItems)) {
            offDirItems.forEach(dirItemRelationEo -> this.dirItemRelationDgDomain.logicDeleteById(dirItemRelationEo.getId()));
            logger.info("\u540c\u6b65\u5220\u9664ES\u4e2d\u7684\u4e0a\u67b6\u4fe1\u606f: shelfId={}", (Object)id);
            Map<String, DirItemRelationDgEo> offDirItemMap = offDirItems.stream().collect(Collectors.toMap(dirItem -> dirItem.getItemId().toString() + dirItem.getShopId(), e -> e, (e1, e2) -> e1));
            offDirItemMap.forEach((k, dirItem) -> this.itemSearchDgService.index(dirItem.getSellerId(), dirItem.getItemId(), shelfDgEo.getBusType(), "OFF_SHELF"));
        }
    }

    @Override
    public void batchRemoveShelf(String ids) {
        String[] idList;
        for (String id : idList = ids.split(",")) {
            this.removeItemShelf(Long.valueOf(id));
        }
    }

    @Override
    public List<PointsDeductionDgRespDto> queryShelfItemPointsDeduction(Set<Long> shelfIds) {
        ArrayList list = Lists.newArrayList();
        ShelfPointsDeductionDgEo paramEo = ShelfPointsDeductionDgEo.newInstance();
        ArrayList sqlFilterList = Lists.newArrayList();
        SqlFilter sqlFilter = SqlFilter.in((String)"shelfId", shelfIds);
        sqlFilterList.add(sqlFilter);
        paramEo.setSqlFilters((List)sqlFilterList);
        List shelfPointsDeductionDgEos = this.shelfPointsDeductionDgDomain.selectList((BaseEo)paramEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfPointsDeductionDgEos)) {
            DtoHelper.eoList2DtoList((Collection)shelfPointsDeductionDgEos, (Collection)list, PointsDeductionDgRespDto.class);
        }
        return list;
    }

    @Override
    public List<ShelfQueryDgRespDto> queryShelfList(ShelfQueryDgReqDto shelfQueryDgReqDto) {
        ArrayList list = Lists.newArrayList();
        List shelfDgEoList = this.shelfDgDomain.queryList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Objects.nonNull(shelfQueryDgReqDto.getId()), BaseEo::getId, (Object)shelfQueryDgReqDto.getId())).eq(Objects.nonNull(shelfQueryDgReqDto.getBusType()), ShelfDgEo::getBusType, (Object)shelfQueryDgReqDto.getBusType())).eq(Objects.nonNull(shelfQueryDgReqDto.getItemId()), ShelfDgEo::getItemId, (Object)shelfQueryDgReqDto.getItemId())).eq(Objects.nonNull(shelfQueryDgReqDto.getShopId()), ShelfDgEo::getShopId, (Object)shelfQueryDgReqDto.getShopId())).eq(Objects.nonNull(shelfQueryDgReqDto.getSkuId()), ShelfDgEo::getSkuId, (Object)shelfQueryDgReqDto.getSkuId())).eq(Objects.nonNull(shelfQueryDgReqDto.getStatus()), ShelfDgEo::getStatus, (Object)shelfQueryDgReqDto.getStatus())).in(CollectionUtil.isNotEmpty((Collection)shelfQueryDgReqDto.getItemIds()), ShelfDgEo::getItemId, (Collection)shelfQueryDgReqDto.getItemIds())).in(CollectionUtil.isNotEmpty((Collection)shelfQueryDgReqDto.getShopIds()), ShelfDgEo::getShopId, (Collection)shelfQueryDgReqDto.getShopIds())).in(CollectionUtil.isNotEmpty((Collection)shelfQueryDgReqDto.getSkuIds()), ShelfDgEo::getSkuId, (Collection)shelfQueryDgReqDto.getSkuIds())).eq(BaseEo::getDr, (Object)0));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfDgEoList)) {
            DtoHelper.eoList2DtoList((Collection)shelfDgEoList, (Collection)list, ShelfQueryDgRespDto.class);
        }
        return list;
    }

    @Override
    @Cacheable(value={"ITEM_SHELF_CACHE"}, key="#itemId", unless="#result== null")
    public List<ItemShelfDgRespDto> queryByItemId(Long itemId) {
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        shelfDgEo.setItemId(itemId);
        List shelfDgEos = this.shelfDgDomain.selectList((BaseEo)shelfDgEo);
        ArrayList shelfRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfRespDtos, (Collection)shelfDgEos, ItemShelfDgRespDto.class);
        return shelfRespDtos;
    }

    @Override
    public Long newCountItemShelf(ItemShelfQueryDgReqDto itemShelfQueryDgReqDto) {
        ShelfItemDgVo shelfItemDgVo = new ShelfItemDgVo();
        CubeBeanUtils.copyProperties((Object)shelfItemDgVo, (Object)itemShelfQueryDgReqDto, (String[])new String[0]);
        return this.shelfDgDomain.newSelectSelfItemCount(shelfItemDgVo);
    }

    @Override
    public PageInfo<ShelfListRespDto> queryShelfByPage(ItemShelfQueryReqDto queryReqDto) {
        PageInfo shelfPageInfo = new PageInfo();
        ShelfDgQueryReqVo reqVo = new ShelfDgQueryReqVo();
        CubeBeanUtils.copyProperties((Object)reqVo, (Object)queryReqDto, (String[])new String[0]);
        List<Object> dirIdList = new ArrayList();
        if (Objects.nonNull(queryReqDto.getDirId())) {
            dirIdList = this.dirDgService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{queryReqDto.getDirId()}), null, null);
            reqVo.setDirIds(dirIdList);
        }
        List<Object> dirPrefixIdList = new ArrayList();
        if (Objects.nonNull(queryReqDto.getDirId())) {
            dirPrefixIdList = this.dirDgService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{queryReqDto.getDirPrefixId()}), null, null);
            reqVo.setDirPrefixIds(dirIdList);
        }
        PageInfo shelfListRespVoPageInfo = this.shelfDgDomain.queryShelfPage(reqVo, queryReqDto.getPageNum(), queryReqDto.getPageSize());
        CubeBeanUtils.copyProperties((Object)shelfPageInfo, (Object)shelfListRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (!CollectionUtils.isEmpty((Collection)shelfListRespVoPageInfo.getList())) {
            List<Long> itemIds = null;
            if (Objects.nonNull(queryReqDto.getActivitySearch()) && queryReqDto.getActivitySearch().booleanValue()) {
                itemIds = shelfListRespVoPageInfo.getList().stream().filter(i -> ItemTypeDg.COMB_ITEM.getStatus() == i.getItemType() || ItemTypeDg.GENERAL_ITEM.getStatus() == i.getItemType()).map(ShelfListDgRespVo::getItemId).collect(Collectors.toList());
                logger.info("ActivitySearch==true\uff0c\u8fc7\u6ee4\u51fa\u5546\u54c1\u3001\u7ec4\u5408\u5546\u54c1\u3001\u8d60\u54c1\u8fd93\u79cd\u7c7b\u578b\u7684itemId\uff1a{}", (Object)JSON.toJSONString(itemIds));
            } else {
                itemIds = shelfListRespVoPageInfo.getList().stream().filter(i -> ItemTypeDg.COMB_ITEM.getStatus() == i.getItemType()).map(ShelfListDgRespVo::getItemId).collect(Collectors.toList());
                logger.info("ActivitySearch==false\uff0c\u53ea\u8fc7\u6ee4\u51fa\u7ec4\u5408\u5546\u54c1\u7c7b\u578b\u7684itemId\uff1a{}", (Object)JSON.toJSONString(itemIds));
            }
            List<ItemBundlesDetailRespDto> bundlesDetailRespDtos = this.queryBundles(itemIds);
            Map<Long, List<ItemBundlesDetailRespDto>> detailRespDtoMap = bundlesDetailRespDtos.stream().collect(Collectors.groupingBy(ItemBundlesDetailRespDto::getItemId));
            List shelfListRespDtoList = shelfListRespVoPageInfo.getList().stream().map(v -> {
                ShelfListRespDto respDto = new ShelfListRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
                if (!CollectionUtils.isEmpty((Map)detailRespDtoMap)) {
                    respDto.setBundlesDetailRespDtos((List)detailRespDtoMap.get(v.getItemId()));
                }
                return respDto;
            }).collect(Collectors.toList());
            shelfPageInfo.setList(shelfListRespDtoList);
        }
        return shelfPageInfo;
    }

    @Override
    public PageInfo<ShelfItemDgRespDto> queryShelfPage(ShelfItemDgReqDto queryReqDto) {
        PageInfo pageInfo = new PageInfo();
        ItemDgEo itemDgEo = new ItemDgEo();
        this.getItemQueryParam(itemDgEo, queryReqDto);
        PageInfo itemDgEoPageInfo = this.itemDgDomain.selectPage((BaseEo)itemDgEo, queryReqDto.getPageNum(), queryReqDto.getPageSize());
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)itemDgEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<ShelfItemDgRespDto> shelfItemDgRespDtos = this.getShelfItemDgRespDtos(itemDgEoPageInfo.getList());
        pageInfo.setList(shelfItemDgRespDtos);
        return pageInfo;
    }

    @Override
    public List<ItemShelfDgRespDto> queryHomepageList(Integer type) {
        ArrayList result = Lists.newArrayList();
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        if (ObjectUtil.isNotEmpty((Object)type)) {
            sqlFilters.add(SqlFilter.like((String)"home_page_display", (Object)("%" + type + "%")));
            shelfDgEo.setHomePageDisplay(null);
        }
        shelfDgEo.setSqlFilters((List)sqlFilters);
        List shelfDgEoList = this.shelfDgDomain.selectList((BaseEo)shelfDgEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfDgEoList)) {
            DtoHelper.eoList2DtoList((Collection)shelfDgEoList, (Collection)result, ItemShelfDgRespDto.class);
        }
        return result;
    }

    private List<ShelfItemDgRespDto> getShelfItemDgRespDtos(List<ItemDgEo> itemDgEos) {
        ArrayList<ShelfItemDgRespDto> shelfItemDgRespDtos = new ArrayList<ShelfItemDgRespDto>();
        if (CollectionUtil.isEmpty(itemDgEos)) {
            return shelfItemDgRespDtos;
        }
        DtoHelper.eoList2DtoList(itemDgEos, shelfItemDgRespDtos, ShelfItemDgRespDto.class);
        List itemIds = itemDgEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List shelfDgEos = this.shelfDgDomain.selectByItemIds(itemIds, ItemStatus.ON_LINE.getStatus());
        if (CollectionUtil.isNotEmpty((Collection)shelfDgEos)) {
            Map<Long, List<ShelfDgEo>> shelfMap = shelfDgEos.stream().collect(Collectors.groupingBy(ShelfDgEo::getItemId));
            for (ShelfItemDgRespDto shelfItemDgRespDto : shelfItemDgRespDtos) {
                List<ShelfDgEo> shelfDgEoList = shelfMap.get(shelfItemDgRespDto.getId());
                ArrayList<Long> channelIds = new ArrayList<Long>();
                ArrayList<String> channelCodes = new ArrayList<String>();
                ArrayList<String> channelNames = new ArrayList<String>();
                if (CollectionUtil.isNotEmpty(shelfDgEoList)) {
                    for (ShelfDgEo shelfDgEo : shelfDgEoList) {
                        channelIds.add(shelfDgEo.getChannelId());
                        channelCodes.add(shelfDgEo.getChannelCode());
                        channelNames.add(shelfDgEo.getChannelName());
                    }
                }
                shelfItemDgRespDto.setChannelIds(channelIds.stream().distinct().collect(Collectors.toList()));
                shelfItemDgRespDto.setChannelCodes(channelCodes.stream().distinct().collect(Collectors.toList()));
                shelfItemDgRespDto.setChannelNames(channelNames.stream().distinct().collect(Collectors.toList()));
            }
        }
        return shelfItemDgRespDtos;
    }

    private List<ItemBundlesDetailRespDto> queryBundles(List<Long> itemIds) {
        ArrayList detailRespDtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty(itemIds)) {
            return detailRespDtos;
        }
        List bundleEos = this.itemBundleRelationDgDomain.selectByItemIdsList(itemIds);
        Map<Long, List<ItemBundleRelationDgEo>> itemBundleEoMap = bundleEos.stream().collect(Collectors.groupingBy(ItemBundleRelationDgEo::getItemId));
        Map itemEoMap = null;
        if (!CollectionUtils.isEmpty((Collection)bundleEos)) {
            List subItemIds = bundleEos.stream().map(ItemBundleRelationDgEo::getSubItemId).collect(Collectors.toList());
            List itemEoList = this.itemDgDomain.selectByIds(subItemIds);
            itemEoMap = itemEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        }
        Map finalItemEoMap = itemEoMap;
        itemBundleEoMap.forEach((k, v) -> v.forEach(i -> {
            ItemBundlesDetailRespDto detailRespDto = new ItemBundlesDetailRespDto();
            detailRespDto.setId(i.getId());
            detailRespDto.setItemId(k);
            detailRespDto.setSubItemId(i.getSubItemId());
            if (!CollectionUtils.isEmpty((Map)finalItemEoMap) && null != finalItemEoMap.get(i.getSubItemId())) {
                detailRespDto.setSubItemCode(((ItemDgEo)finalItemEoMap.get(i.getSubItemId())).getCode());
                detailRespDto.setSubItemName(((ItemDgEo)finalItemEoMap.get(i.getSubItemId())).getName());
                detailRespDto.setNum(i.getNum());
                detailRespDtos.add(detailRespDto);
            }
        }));
        return detailRespDtos;
    }

    private void getItemQueryParam(ItemDgEo itemDgEo, ShelfItemDgReqDto queryReqDto) {
        CubeBeanUtils.copyProperties((Object)itemDgEo, (Object)queryReqDto, (String[])new String[0]);
        if (Objects.nonNull(queryReqDto)) {
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            if (Objects.nonNull(queryReqDto.getItemId())) {
                itemDgEo.setId(queryReqDto.getItemId());
            }
            if (CollectionUtil.isNotEmpty((Collection)queryReqDto.getItemIds())) {
                itemDgEo.setId(null);
                sqlFilterList.add(SqlFilter.in((String)"id", (Object)queryReqDto.getItemIds()));
            }
            if (Objects.nonNull(queryReqDto.getItemCode())) {
                itemDgEo.setCode(null);
                sqlFilterList.add(SqlFilter.like((String)"code", (Object)("%" + queryReqDto.getItemCode() + "%")));
            }
            if (CollectionUtil.isNotEmpty((Collection)queryReqDto.getItemCodes())) {
                itemDgEo.setCode(null);
                sqlFilterList.add(SqlFilter.in((String)"code", (Object)queryReqDto.getItemCodes()));
            }
            if (Objects.nonNull(queryReqDto.getItemName())) {
                itemDgEo.setName(null);
                sqlFilterList.add(SqlFilter.like((String)"name", (Object)("%" + queryReqDto.getItemName() + "%")));
            }
            if (Objects.nonNull(queryReqDto.getDirPrefixName())) {
                itemDgEo.setDirPrefixName(null);
                sqlFilterList.add(SqlFilter.like((String)"dir_prefix_name", (Object)("%" + queryReqDto.getDirPrefixName() + "%")));
            }
            if (Objects.nonNull(queryReqDto.getDirName())) {
                itemDgEo.setDirName(null);
                sqlFilterList.add(SqlFilter.like((String)"dir_name", (Object)("%" + queryReqDto.getItemName() + "%")));
            }
            if (CollectionUtil.isNotEmpty((Collection)queryReqDto.getTypes())) {
                sqlFilterList.add(SqlFilter.in((String)"type", (Object)queryReqDto.getTypes()));
            }
            if (Objects.nonNull(queryReqDto.getUpdateBeginTime())) {
                sqlFilterList.add(SqlFilter.ge((String)"update_time", (Object)queryReqDto.getUpdateBeginTime()));
            }
            if (Objects.nonNull(queryReqDto.getUpdateEndTime())) {
                sqlFilterList.add(SqlFilter.le((String)"update_time", (Object)queryReqDto.getUpdateEndTime()));
            }
            if (Objects.nonNull(queryReqDto.getCreateBeginTime())) {
                sqlFilterList.add(SqlFilter.ge((String)"create_time", (Object)queryReqDto.getCreateBeginTime()));
            }
            if (Objects.nonNull(queryReqDto.getCreateEndTime())) {
                sqlFilterList.add(SqlFilter.le((String)"create_time", (Object)queryReqDto.getCreateEndTime()));
            }
            List<Object> dirIdList = new ArrayList();
            if (Objects.nonNull(queryReqDto.getDirId())) {
                dirIdList = this.dirDgService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{queryReqDto.getDirId()}), null, null);
            }
            if (CollectionUtil.isNotEmpty(dirIdList)) {
                itemDgEo.setDirId(null);
                sqlFilterList.add(SqlFilter.in((String)"dir_id", dirIdList));
            }
            List<Object> dirPrefixIdList = new ArrayList();
            if (Objects.nonNull(queryReqDto.getDirPrefixId())) {
                dirPrefixIdList = this.dirDgService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{queryReqDto.getDirPrefixId()}), null, null);
            }
            if (CollectionUtil.isNotEmpty(dirPrefixIdList)) {
                itemDgEo.setDirPrefixId(null);
                sqlFilterList.add(SqlFilter.in((String)"dir_prefix_id", dirIdList));
            }
        }
    }
}

