/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.item.constants.ItemDgItemAttributeEnum;
import com.yunxi.dg.base.center.item.constants.ItemVersionOaAuditStatusEnum;
import com.yunxi.dg.base.center.item.constants.ItemVersionStatusEnum;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemVersionDgDomain;
import com.yunxi.dg.base.center.item.dto.entity.ItemVersionDgDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemVersionDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.ItemVersionDgEo;
import com.yunxi.dg.base.center.item.event.localEvent.ItemVersionMqEvent;
import com.yunxi.dg.base.center.item.service.entity.IItemPushOaAssistService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.rpc.third.audit.IPushThirdAuditActionApi;
import com.yunxi.dg.base.commons.rpc.third.audit.PushThirdAuditBo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IItemPushOaAssistServiceImpl
implements IItemPushOaAssistService {
    private static final Logger log = LoggerFactory.getLogger(IItemPushOaAssistServiceImpl.class);
    @Resource
    private IPushThirdAuditActionApi pushThirdAuditActionApi;
    @Resource
    private IContext context;
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private IItemVersionDgDomain itemVersionDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    public static final String APPROVE_PASS = "\u5ba1\u6279\u901a\u8fc7";
    public static final String APPROVE_REJECT = "\u5ba1\u6279\u9a73\u56de";
    public static final String APPROVE_REVOCATION = "\u5ba1\u6279\u64a4\u56de";

    @Override
    public Boolean pushBomToOa(DgItemSkuDetailRespDto skuDetailRespDto) {
        PushThirdAuditBo.PushThirdAuditBoBuilder builder = PushThirdAuditBo.builder();
        builder.orderType("bom_form_audit");
        builder.businessOrderId(skuDetailRespDto.getId());
        builder.businessOrderNo(((ItemVersionDgRespDto)skuDetailRespDto.getVersionDgReqDtos().get(0)).getId().toString());
        builder.userCode(this.context.userName());
        builder.userName(this.context.userName());
        HashMap map = Maps.newHashMap();
        map.put("skuDetailRespDto", JSON.toJSONString((Object)skuDetailRespDto));
        builder.extendedFieldMap((Map)map);
        log.info("[bom\u63a8\u9001OA]\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)skuDetailRespDto));
        return (Boolean)RestResponseHelper.extractData((RestResponse)this.pushThirdAuditActionApi.thirdAudit(builder.build()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bomOaAuditCallBack(PushThirdAuditBo pushThirdAuditBo, String auditStatus) {
        Long skuId = pushThirdAuditBo.getBusinessOrderId();
        Long versionId = Long.valueOf(pushThirdAuditBo.getBusinessOrderNo());
        ItemSkuDgEo skuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectById((Serializable)skuId);
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(skuDgEo.getItemId());
        ItemVersionDgEo itemVersionDgEo = (ItemVersionDgEo)this.itemVersionDgDomain.selectById((Serializable)versionId);
        if (Objects.isNull(itemVersionDgEo)) {
            log.info("\u65e0\u6cd5\u627e\u5230\u5546\u54c1\u7ec4\u88c5\u7248\u672c\u6570\u636e");
            return;
        }
        if (ItemVersionStatusEnum.ENABLE_STATUS.getType().equals(itemVersionDgEo.getStatus())) {
            log.info("\u5df2\u7ecf\u662f\u542f\u7528\u72b6\u6001,\u65e0\u9700\u5728\u6267\u884c");
            return;
        }
        ArrayList itemVersionDgDtoList = Lists.newArrayList();
        if (APPROVE_PASS.equals(auditStatus)) {
            List itemVersionDgEoList;
            itemVersionDgEo.setOaAuditStatus(ItemVersionOaAuditStatusEnum.PASS_STATUS.getType());
            itemVersionDgEo.setPeriodStartTime(new Date());
            itemVersionDgEo.setStatus(ItemVersionStatusEnum.ENABLE_STATUS.getType());
            if (ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PRODUCT.getType().equals(itemDgEo.getItemAttribute())) {
                ItemVersionDgDto itemVersionDgDto = new ItemVersionDgDto();
                itemVersionDgDto.setSkuId(itemVersionDgEo.getSkuId());
                itemVersionDgDto.setId(versionId);
                itemVersionDgDtoList.add(itemVersionDgDto);
            }
            if (CollectionUtil.isNotEmpty((Collection)(itemVersionDgEoList = this.itemVersionDgDomain.queryEnableStatusAndSkuId(itemVersionDgEo.getSkuId())))) {
                Set itemIds = itemVersionDgEoList.stream().map(ItemVersionDgEo::getItemId).collect(Collectors.toSet());
                List itemDgEos = this.itemDgDomain.selectByIds((List)Lists.newArrayList(itemIds));
                Map itemDgEoMap = itemDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                for (ItemVersionDgEo versionDgEo : itemVersionDgEoList) {
                    versionDgEo.setStatus(ItemVersionStatusEnum.STOP_STATUS.getType());
                    versionDgEo.setPeriodEndTime(new Date());
                    if (itemDgEoMap.containsKey(versionDgEo.getItemId())) {
                        ItemDgEo item = (ItemDgEo)itemDgEoMap.get(versionDgEo.getItemId());
                        if (ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PRODUCT.getType().equals(item.getItemAttribute())) {
                            ItemVersionDgDto itemVersionDgDto = new ItemVersionDgDto();
                            itemVersionDgDto.setSkuId(versionDgEo.getSkuId());
                            itemVersionDgDto.setId(versionDgEo.getId());
                            itemVersionDgDtoList.add(itemVersionDgDto);
                        }
                    }
                    this.itemVersionDgDomain.update((BaseEo)versionDgEo);
                }
            }
        }
        if (APPROVE_REJECT.equals(auditStatus) || APPROVE_REVOCATION.equals(auditStatus)) {
            itemVersionDgEo.setOaAuditStatus(ItemVersionOaAuditStatusEnum.FAIL_STATUS.getType());
            itemVersionDgEo.setStatus(YesNoEnum.NO.getValue());
        }
        this.itemVersionDgDomain.update((BaseEo)itemVersionDgEo);
        if (CollectionUtil.isNotEmpty((Collection)itemVersionDgDtoList)) {
            this.applicationContext.publishEvent((Object)new ItemVersionMqEvent(itemVersionDgDtoList));
        }
    }
}

