/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.constants.ItemChangeApplyDgStatus;
import com.yunxi.dg.base.center.item.constants.ItemDgStatus;
import com.yunxi.dg.base.center.item.constants.ItemDgType;
import com.yunxi.dg.base.center.item.domain.entity.IItemAuditDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemChangeApplyDgDomain;
import com.yunxi.dg.base.center.item.dto.request.ChangeApplyAuditDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemChangeApplyDgDto;
import com.yunxi.dg.base.center.item.dto.request.ItemChangeApplyDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.AuditResultDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemChangeApplyDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemAuditDgEo;
import com.yunxi.dg.base.center.item.eo.ItemChangeApplyDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemChangeApplyDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemVersionDgService;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iItemChangeApplyDgService")
public class ItemChangeApplyDgServiceImpl
implements IItemChangeApplyDgService {
    private static Logger logger = LoggerFactory.getLogger(ItemChangeApplyDgServiceImpl.class);
    @Resource
    private IItemChangeApplyDgDomain itemChangeApplyDgDomain;
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IItemAuditDgDomain itemAuditDgDomain;
    @Resource
    private IItemVersionDgService itemVersionDgService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(ItemChangeApplyDgReqDto changeApplyDto) {
        ItemChangeApplyDgEo itemChangeApplyDgEo = this.getItemChangeApplyEo(changeApplyDto);
        this.itemChangeApplyDgDomain.insert((BaseEo)itemChangeApplyDgEo);
        return itemChangeApplyDgEo.getId();
    }

    @Override
    public void commit(Long id) {
        ItemChangeApplyDgEo itemChangeApplyDgEo = new ItemChangeApplyDgEo();
        itemChangeApplyDgEo.setId(id);
        itemChangeApplyDgEo.setStatus(ItemChangeApplyDgStatus.AUDITING.getStatus());
        this.itemChangeApplyDgDomain.updateSelective((BaseEo)itemChangeApplyDgEo);
    }

    @Override
    public Long update(ItemChangeApplyDgReqDto itemChangeApplyDgReqDto) {
        if (null == itemChangeApplyDgReqDto.getId()) {
            throw new BizException("\u7533\u8bf7\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemChangeApplyDgEo itemChangeApplyDgEo = this.getItemChangeApplyEo(itemChangeApplyDgReqDto);
        itemChangeApplyDgEo.setId(itemChangeApplyDgReqDto.getId());
        itemChangeApplyDgEo.setUpdateTime(new Date());
        this.itemChangeApplyDgDomain.updateSelective((BaseEo)itemChangeApplyDgEo);
        return itemChangeApplyDgEo.getId();
    }

    private ItemChangeApplyDgEo getItemChangeApplyEo(ItemChangeApplyDgReqDto itemChangeApplyDgReqDto) {
        if (StringUtils.isEmpty((CharSequence)itemChangeApplyDgReqDto.getItemName())) {
            throw new BizException("\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)itemChangeApplyDgReqDto.getCode())) {
            itemChangeApplyDgReqDto.setCode(UUID.randomUUID().toString());
        }
        this.itemDgService.validSkuCode(itemChangeApplyDgReqDto.getItemChangeApplyDgDto(), itemChangeApplyDgReqDto.getTenantId());
        ItemChangeApplyDgEo itemChangeApplyDgEo = ItemChangeApplyDgEo.newInstance((Map)itemChangeApplyDgReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)itemChangeApplyDgReqDto, (BaseEo)itemChangeApplyDgEo);
        itemChangeApplyDgReqDto.getItemChangeApplyDgDto().setInstanceId(itemChangeApplyDgReqDto.getInstanceId());
        itemChangeApplyDgReqDto.getItemChangeApplyDgDto().setTenantId(itemChangeApplyDgReqDto.getTenantId());
        itemChangeApplyDgEo.setId(null);
        itemChangeApplyDgEo.setContent(JSON.toJSONString((Object)itemChangeApplyDgReqDto.getItemChangeApplyDgDto()));
        return itemChangeApplyDgEo;
    }

    @Override
    public AuditResultDgRespDto audit(ChangeApplyAuditDgReqDto changeApplyAuditDgReqDto) {
        long itemId = 0L;
        if (ItemChangeApplyDgStatus.AUDIT_SUCCESS.getStatus().equals(changeApplyAuditDgReqDto.getStatus())) {
            ItemChangeApplyDgEo itemChangeApplyDgEo = (ItemChangeApplyDgEo)this.itemChangeApplyDgDomain.selectByPrimaryKey(changeApplyAuditDgReqDto.getChangeApplyId());
            ItemChangeApplyDgDto itemChangeApplyDgDto = (ItemChangeApplyDgDto)JSON.parseObject((String)itemChangeApplyDgEo.getContent(), ItemChangeApplyDgDto.class);
            CubeBeanUtils.copyProperties((Object)itemChangeApplyDgEo, (Object)itemChangeApplyDgDto, (String[])new String[0]);
            itemChangeApplyDgDto.setSellerId(itemChangeApplyDgEo.getSellerId());
            itemChangeApplyDgDto.setShopId(itemChangeApplyDgEo.getShopId());
            itemChangeApplyDgDto.setOwnerId(itemChangeApplyDgEo.getOwnerId());
            if (itemChangeApplyDgEo.getItemId() != null) {
                itemChangeApplyDgDto.setItemId(itemChangeApplyDgEo.getItemId());
            }
            if (itemChangeApplyDgDto.getItemId() != null) {
                itemId = itemChangeApplyDgDto.getItemId();
                this.itemDgService.updateItem(itemChangeApplyDgDto);
            } else {
                if (itemChangeApplyDgDto.getItemStatus() == null && itemChangeApplyDgDto.getType() != null) {
                    List<Integer> itemTypeIndexList = Arrays.asList(ItemDgType.GENERAL.getIndex(), ItemDgType.VIRTUAL.getIndex(), ItemDgType.BUNDLE.getIndex());
                    itemChangeApplyDgDto.setItemStatus(itemTypeIndexList.contains(itemChangeApplyDgDto.getType()) ? ItemDgStatus.ITEM_DRAFT.getStatus() : ItemDgStatus.PRODUCT_WAIT_PUBLISHED.getStatus());
                }
                itemId = this.itemDgService.addItem(itemChangeApplyDgDto);
            }
        }
        ItemChangeApplyDgReqDto changeApply = new ItemChangeApplyDgReqDto();
        changeApply.setId(changeApplyAuditDgReqDto.getChangeApplyId());
        changeApply.setStatus(changeApplyAuditDgReqDto.getStatus());
        changeApply.setInstanceId(changeApplyAuditDgReqDto.getInstanceId());
        changeApply.setTenantId(changeApplyAuditDgReqDto.getTenantId());
        changeApply.setItemId(Long.valueOf(itemId));
        this.update(changeApply, itemId);
        AuditResultDgRespDto auditResultDgRespDto = new AuditResultDgRespDto();
        auditResultDgRespDto.setItemId(Long.valueOf(itemId));
        return auditResultDgRespDto;
    }

    private Long update(ItemChangeApplyDgReqDto changeApply, long itemId) {
        if (null == changeApply) {
            throw new BizException("\u7533\u8bf7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemChangeApplyDgEo itemChangeApplyDgEo = ItemChangeApplyDgEo.newInstance((Map)changeApply.getExtFields());
        if (itemId > 0L) {
            itemChangeApplyDgEo.setItemId(Long.valueOf(itemId));
        }
        DtoHelper.dto2Eo((BaseVo)changeApply, (BaseEo)itemChangeApplyDgEo);
        this.itemChangeApplyDgDomain.updateSelective((BaseEo)itemChangeApplyDgEo);
        return itemChangeApplyDgEo.getId();
    }

    @Override
    public ItemChangeApplyDgRespDto getById(Long id, ItemChangeApplyDgReqDto itemChangeApplyDgReqDto, Long tenantId, Long instanceId) {
        if (null == id) {
            logger.error("\u7248\u672cId\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BizException("\u7248\u672cId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemChangeApplyDgEo itemChangeApplyDgEo = (ItemChangeApplyDgEo)this.itemChangeApplyDgDomain.selectByPrimaryKey(id);
        if (null == itemChangeApplyDgEo) {
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e");
        }
        ItemChangeApplyDgRespDto itemVersionDto = new ItemChangeApplyDgRespDto();
        DtoHelper.eo2Dto((BaseEo)itemChangeApplyDgEo, (BaseVo)itemVersionDto);
        ItemChangeApplyDgDto itemChangeApplyDgDto = (ItemChangeApplyDgDto)JSON.parseObject((String)itemChangeApplyDgEo.getContent(), ItemChangeApplyDgDto.class);
        itemVersionDto.setItemChangeApplyDgDto(itemChangeApplyDgDto);
        this.queryAuditDetail(itemVersionDto);
        return itemVersionDto;
    }

    @Override
    public PageInfo<ItemChangeApplyDgRespDto> queryByPage(ItemChangeApplyDgReqDto dto, Integer pageNum, Integer pageSize) {
        ItemChangeApplyDgEo itemChangeApplyDgEo = ItemChangeApplyDgEo.newInstance((Map)dto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)itemChangeApplyDgEo);
        QueryParamDgUtils.fillQueryCreateStartTime(dto.getCreateBeginTime(), (BaseEo)itemChangeApplyDgEo);
        QueryParamDgUtils.fillQueryCreateEndTime(dto.getCreateEndTime(), (BaseEo)itemChangeApplyDgEo);
        QueryParamDgUtils.fillQueryUpdateStartTime(dto.getUpdateBeginTime(), (BaseEo)itemChangeApplyDgEo);
        QueryParamDgUtils.fillQueryUpdateEndTime(dto.getUpdateEndTime(), (BaseEo)itemChangeApplyDgEo);
        if (dto.getStatus() == null && dto.getNeStatus() != null) {
            ArrayList<SqlFilter> sqlFilterList = itemChangeApplyDgEo.getSqlFilters();
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList<SqlFilter>();
            }
            sqlFilterList.add(SqlFilter.ne((String)"status", (Object)dto.getNeStatus()));
            itemChangeApplyDgEo.setSqlFilters(sqlFilterList);
        }
        PageInfo pageInfo = this.itemChangeApplyDgDomain.selectPage((BaseEo)itemChangeApplyDgEo, pageNum, pageSize);
        PageInfo itemChangeApplyRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)itemChangeApplyRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList itemChangeApplyDgRespDtos = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), itemChangeApplyDgRespDtos, ItemChangeApplyDgRespDto.class);
        block0: for (ItemChangeApplyDgRespDto itemChangeApplyDgRespDto : itemChangeApplyDgRespDtos) {
            for (ItemChangeApplyDgEo itemChange : pageInfo.getList()) {
                if (!itemChangeApplyDgRespDto.getId().equals(itemChange.getId())) continue;
                itemChangeApplyDgRespDto.setItemChangeApplyDgDto((ItemChangeApplyDgDto)JSON.parseObject((String)itemChange.getContent(), ItemChangeApplyDgDto.class));
                continue block0;
            }
        }
        ArrayList<Long> snapshotIdList = new ArrayList<Long>();
        for (ItemChangeApplyDgRespDto itemChangeApplyDgRespDto : itemChangeApplyDgRespDtos) {
            if (!ItemChangeApplyDgStatus.AUDITING.getStatus().equals(itemChangeApplyDgRespDto.getStatus()) && !ItemChangeApplyDgStatus.DRAFT.getStatus().equals(itemChangeApplyDgRespDto.getStatus())) {
                this.queryAuditDetail(itemChangeApplyDgRespDto);
            }
            snapshotIdList.add(itemChangeApplyDgRespDto.getSnapshotId());
        }
        itemChangeApplyRespDtoPageInfo.setList(itemChangeApplyDgRespDtos);
        return itemChangeApplyRespDtoPageInfo;
    }

    private void queryAuditDetail(ItemChangeApplyDgRespDto itemChangeApplyDgRespDto) {
        ItemAuditDgEo itemAuditDgEo = new ItemAuditDgEo();
        itemAuditDgEo.setVersionId(itemChangeApplyDgRespDto.getId());
        itemAuditDgEo.setInstanceId(itemChangeApplyDgRespDto.getInstanceId());
        itemAuditDgEo.setTenantId(itemChangeApplyDgRespDto.getTenantId());
        PageInfo last = this.itemAuditDgDomain.selectPage((BaseEo)itemAuditDgEo, Integer.valueOf(1), Integer.valueOf(1));
        if (last == null || CollectionUtils.isEmpty((Collection)last.getList())) {
            return;
        }
        itemAuditDgEo = (ItemAuditDgEo)last.getList().get(0);
        itemChangeApplyDgRespDto.setResult(itemAuditDgEo.getResult());
        itemChangeApplyDgRespDto.setAuditDesc(itemAuditDgEo.getAuditDesc());
        itemChangeApplyDgRespDto.setAuditPerson(itemAuditDgEo.getAuditPerson());
        itemChangeApplyDgRespDto.setAuditTime(itemAuditDgEo.getCreateTime());
        itemChangeApplyDgRespDto.setAuditPersonName(itemAuditDgEo.getAuditPersonName());
    }
}

