/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.common.constant.ItemDgConstant;
import com.yunxi.dg.base.center.item.common.enums.ItemSkuOperationTypeEnum;
import com.yunxi.dg.base.center.item.common.enums.ItemTypeDg;
import com.yunxi.dg.base.center.item.constants.ItemBizTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.ItemBusTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.ItemConstants;
import com.yunxi.dg.base.center.item.constants.ItemDgItemAttributeEnum;
import com.yunxi.dg.base.center.item.constants.ItemDgStatus;
import com.yunxi.dg.base.center.item.constants.ItemDgType;
import com.yunxi.dg.base.center.item.constants.ItemMediaBizTypeEnum;
import com.yunxi.dg.base.center.item.constants.ItemMediaItemTypeEnum;
import com.yunxi.dg.base.center.item.constants.ItemPriceDgEnum;
import com.yunxi.dg.base.center.item.constants.PropInputTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.ShelfStatusDgEnum;
import com.yunxi.dg.base.center.item.constants.ShelfTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.SkuItemMarketStatusEnum;
import com.yunxi.dg.base.center.item.dao.doc.ItemDgDoc;
import com.yunxi.dg.base.center.item.dao.doc.ItemSkuDgDoc;
import com.yunxi.dg.base.center.item.dao.vo.ItemDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ItemSearchDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ItemSkuConditionDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfItemDgVo;
import com.yunxi.dg.base.center.item.domain.entity.IBrandDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirItemRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemAttributesDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemMediasDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemPriceDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemPropRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemShopDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuSnapshotDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemTagRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemUnitConversionDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IRItemOrganizationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISerialCodeDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfTaskDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IStatDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IUnitDgDomain;
import com.yunxi.dg.base.center.item.dto.entity.ItemShopDgDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionDgDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionRelationDgDto;
import com.yunxi.dg.base.center.item.dto.entity.RItemOrganizationDgDto;
import com.yunxi.dg.base.center.item.dto.request.BranchQueryItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.BundleItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DgItemSkuPlanQueryReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirItemRelativeDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.FreightItemEsDto;
import com.yunxi.dg.base.center.item.dto.request.FreightItemReq;
import com.yunxi.dg.base.center.item.dto.request.ItemAllowOrderQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemAuditDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemBatchImportImageImageReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemBatchImportImageReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemBatchUpdateFrontDirReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemBundleDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemChangeApplyDgDto;
import com.yunxi.dg.base.center.item.dto.request.ItemChangeSaleStatusReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemDetailDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemDirQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemExchangeUnitDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemLibDetailDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemLibPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemLibPublishToShopDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemLibSkuDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemMarketStatusDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemMediasDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemModifyStatusDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemOffShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemOnShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemPriceDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemPropGroupDgDto;
import com.yunxi.dg.base.center.item.dto.request.ItemPropNameDgDto;
import com.yunxi.dg.base.center.item.dto.request.ItemPropRelationDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemPublishDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemRemarkDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSearchDgVoReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSearchQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSkuDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStatDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageBranchQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemUnitConversionDgGroupDto;
import com.yunxi.dg.base.center.item.dto.request.MarketSkuDto;
import com.yunxi.dg.base.center.item.dto.request.OffShelfItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfItemInfoDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfTaskQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShopItemPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShopItemUpdateDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.AllowOrderTimeDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.BranchItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.BundleItemDetailDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.BundleItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirItemRelativeQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirsItemsDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemAllSuperiorRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemAllowOrderDetailQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemAllowOrderQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemAttributesDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDetailBaseInfoDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDetailDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDetailInfoDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDgPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDirQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemExchangeUnitDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemModifyStatusDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemOnShelfDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemPriceDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemPropRelationDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRoundDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSearchDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuExtDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuInfoDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuListDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuRelDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemStatDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemStorageQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfIntegralDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfTaskDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfTaskQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShopItemDgDto;
import com.yunxi.dg.base.center.item.dto.response.ShopItemDgPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.center.item.eo.BrandDgEo;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.DirItemRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemAttributesDgEo;
import com.yunxi.dg.base.center.item.eo.ItemBundleRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemMediasDgEo;
import com.yunxi.dg.base.center.item.eo.ItemPriceDgEo;
import com.yunxi.dg.base.center.item.eo.ItemPropRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemShopDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuSnapshotDgEo;
import com.yunxi.dg.base.center.item.eo.ItemTagRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemUnitConversionDgEo;
import com.yunxi.dg.base.center.item.eo.RItemOrganizationDgEo;
import com.yunxi.dg.base.center.item.eo.SerialCodeEo;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfTaskDgEo;
import com.yunxi.dg.base.center.item.eo.StatDgEo;
import com.yunxi.dg.base.center.item.eo.UnitDgEo;
import com.yunxi.dg.base.center.item.event.ItemFreightProducer;
import com.yunxi.dg.base.center.item.event.ItemShelfDgProducer;
import com.yunxi.dg.base.center.item.event.localEvent.SendItemSkuMqEvent;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IBundleItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirItemRelationDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemAttributesDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemAuditDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemCycleBuyDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemMediasDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemPriceDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSearchDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemShelfDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemStorageDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemTagDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemUnitConversionDgService;
import com.yunxi.dg.base.center.item.service.entity.IPropDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfIntegralDgService;
import com.yunxi.dg.base.center.item.service.entity.IUnitDgService;
import com.yunxi.dg.base.center.item.service.util.BeanConvertUtil;
import com.yunxi.dg.base.center.item.service.util.ConvertDgUtil;
import com.yunxi.dg.base.center.price.proxy.query.IDgBasePriceItemQueryApiProxy;
import com.yunxi.dg.base.center.prop.proxy.prop.IPropQueryApiProxy;
import com.yunxi.dg.base.center.shop.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.shop.proxy.query.IDgTobShopQueryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="itemDgService")
public class ItemDgServiceImpl
implements IItemDgService {
    private static Logger logger = LoggerFactory.getLogger(ItemDgServiceImpl.class);
    @Resource
    private IItemDgDomain itemDgDomain;
    @Autowired(required=false)
    private IShelfIntegralDgService shelfIntegralDgService;
    @Resource
    private IItemPriceDgService itemPriceDgService;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IItemAttributesDgService itemAttributesDgService;
    @Resource
    private IItemMediasDgService itemMediasDgService;
    @Resource
    private IBundleItemDgService bundleItemDgService;
    @Resource
    private IItemTagDgService itemTagDgService;
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Resource
    private IItemAttributesDgDomain itemAttributesDgDomain;
    @Resource
    private IItemMediasDgDomain itemMediasDgDomain;
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IItemPriceDgDomain itemPriceDgDomain;
    @Resource
    private IDirItemRelationDgDomain dirItemRelationDgDomain;
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;
    @Resource
    private IItemTagRelationDgDomain itemTagRelationDgDomain;
    @Resource
    private IShelfTaskDgDomain shelfTaskDgDomain;
    @Resource
    private IPropDgService propDgService;
    @Resource
    private IItemPropRelationDgDomain itemPropRelationDgDomain;
    @Resource
    private IItemSearchDgService itemSearchDgService;
    @Resource
    private IStatDgDomain statDgDomain;
    @Resource
    private IItemAuditDgService iItemAuditDgService;
    @Resource
    private IItemShelfDgService itemShelfDgService;
    @Resource
    private IShelfDgDomain shelfDgDomain;
    @Resource
    private IBrandDgDomain brandDgDomain;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDirDgService dirDgService;
    @Resource
    private IItemStorageDgService itemStorageDgService;
    @Resource
    private IShelfDgService shelfDgService;
    @Autowired(required=false)
    private IItemCycleBuyDgService itemCycleBuyDgService;
    @Resource
    private IItemUnitConversionDgService itemUnitConversionDgService;
    @Resource
    private IItemUnitConversionDgDomain itemUnitConversionDgDomain;
    @Resource
    private IUnitDgService unitDgService;
    @Value(value="${item.dir.page.limit:50}")
    private Integer limit;
    @Resource
    private IDirItemRelationDgService dirItemRelationDgService;
    @Resource
    private IPropQueryApiProxy propQueryApiProxy;
    @Resource
    private IItemSkuSnapshotDgDomain iItemSkuSnapshotDgDomain;
    @Resource
    private IItemSkuSnapshotDgDomain itemSkuSnapshotDgDomain;
    @Resource
    private IItemShopDgDomain itemShopDgDomain;
    @Resource
    private IUnitDgDomain unitDgDomain;
    @Resource
    private IDgShopQueryApiProxy dgShopQueryApiProxy;
    @Resource
    private IDgTobShopQueryApiProxy dgTobShopQueryApiProxy;
    @Resource
    private ItemShelfDgProducer itemShelfDgProducer;
    @Resource
    private IRItemOrganizationDgDomain rItemOrganizationDgDomain;
    @Resource
    private IDgBasePriceItemQueryApiProxy dgBasePriceItemQueryApiProxy;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private ISerialCodeDomain serialCodeDomain;
    public static final String CACHE_ITEM_SHELF_PREFIX = "center_item_shelf";
    public static final String CACHE_ITEM_PRODUCT_DETAIL_PREFIX = "center_item_product_detail";
    @Resource
    private ItemFreightProducer itemFreightProducer;
    @Value(value="${huieryun.searchindexbuilder.item.usrdata:true}")
    private boolean usrData;
    @Value(value="${project.item.unit.conversion:on}")
    private String unitConversion;

    @Override
    public PageInfo<ItemSkuExtDgRespDto> queryItemLibSkuByPage(ItemDgReqDto itemDgReqDto, Integer pageNum, Integer pageSize) {
        ItemSkuConditionDgVo itemSkuConditionDgVo = new ItemSkuConditionDgVo();
        CubeBeanUtils.copyProperties((Object)itemSkuConditionDgVo, (Object)itemDgReqDto, (String[])new String[0]);
        itemSkuConditionDgVo.setItemCode(itemDgReqDto.getCode());
        itemSkuConditionDgVo.setItemName(itemDgReqDto.getName());
        if (null != itemDgReqDto.getBizType() && ItemBizTypeDgEnum.ITEM_LIB.getType().equals(itemDgReqDto.getBizType())) {
            itemSkuConditionDgVo.setSellerId(Long.valueOf(0L));
        }
        PageInfo itemSkuPageInfo = this.itemSkuDgDomain.queryItemSkuPageByCondition(itemSkuConditionDgVo, pageNum, pageSize);
        ArrayList itemSkuDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemSkuDtoList, (Collection)itemSkuPageInfo.getList(), ItemSkuExtDgRespDto.class);
        PageInfo dtoPageInfo = new PageInfo((List)itemSkuDtoList);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)itemSkuPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        HashSet itemIds = Sets.newHashSet();
        HashSet brandIds = Sets.newHashSet();
        HashSet dirIds = Sets.newHashSet();
        HashSet unitIds = Sets.newHashSet();
        ArrayList skuIdList = Lists.newArrayList();
        for (ItemSkuExtDgRespDto sku : itemSkuDtoList) {
            sku.setId(sku.getSkuId());
            sku.setCode(sku.getSkuCode());
            sku.setSkuDesc(sku.getAttr());
            itemIds.add(sku.getItemId());
            skuIdList.add(sku.getSkuId());
            if (Objects.nonNull(sku.getBrandId())) {
                brandIds.add(sku.getBrandId());
            }
            if (Objects.nonNull(sku.getUnit())) {
                unitIds.add(sku.getUnit());
            }
            dirIds.add(sku.getDirId());
        }
        Map<Long, List<ItemPriceDgRespDto>> itemSkuPriceMap = this.itemSkuDgService.getItemSkuPriceMapBySkuIds(skuIdList);
        Map<Long, List<String>> itemImgPathsMap = this.getItemImgPathsMapByItemIds(Lists.newArrayList((Iterable)itemIds));
        Map<Long, String> brandMap = this.getBrandMapByBrandIds(Lists.newArrayList((Iterable)brandIds));
        Map<Long, String> dirMap = this.getDirMapByDirIds(Lists.newArrayList((Iterable)dirIds));
        Map<String, String> unitMap = this.getUnitMapByUnitIds(Lists.newArrayList((Iterable)unitIds));
        for (ItemSkuExtDgRespDto itemSkuDto : itemSkuDtoList) {
            itemSkuDto.setItemPriceList(itemSkuPriceMap.get(itemSkuDto.getId()));
            BigDecimal itemPrice = this.getItemSkuPrice(itemSkuPriceMap.get(itemSkuDto.getId()));
            itemSkuDto.setItemPrice(itemPrice);
            if (Objects.nonNull(itemSkuDto.getBrandId())) {
                itemSkuDto.setBrandName(brandMap.get(itemSkuDto.getBrandId()));
            }
            if (Objects.nonNull(itemSkuDto.getUnit())) {
                itemSkuDto.setUnit(unitMap.get(itemSkuDto.getUnit()));
            }
            itemSkuDto.setDirName(dirMap.get(itemSkuDto.getDirId()));
            List<String> imgPathsList = itemImgPathsMap.get(itemSkuDto.getItemId());
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(imgPathsList)) continue;
            itemSkuDto.setImgPath(imgPathsList.get(0));
        }
        return dtoPageInfo;
    }

    private BigDecimal getItemSkuPrice(List<ItemPriceDgRespDto> itemPriceDgRespDtos) {
        BigDecimal itemPrice = BigDecimal.ZERO;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemPriceDgRespDtos)) {
            for (ItemPriceDgRespDto priceRespDto : itemPriceDgRespDtos) {
                if (!"RETAIL_PRICE".equalsIgnoreCase(priceRespDto.getPriceType())) continue;
                itemPrice = priceRespDto.getPrice();
                break;
            }
        }
        return itemPrice;
    }

    private Map<String, String> getUnitMapByUnitIds(ArrayList<String> unitIds) {
        List<Long> ids;
        List<UnitDgRespDto> respDtoList;
        HashedMap unitMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(unitIds) && org.apache.commons.collections.CollectionUtils.isNotEmpty(respDtoList = this.unitDgService.queryByIds(ids = unitIds.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e)).map(e -> Long.valueOf(e)).collect(Collectors.toList())))) {
            for (UnitDgRespDto unitDto : respDtoList) {
                unitMap.put("" + unitDto.getId(), unitDto.getName());
            }
        }
        return unitMap;
    }

    @Override
    public Map<Long, String> getBrandMapByBrandIds(List<Long> brandIds) {
        Object brandMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(brandIds)) {
            BrandDgEo brandDgEo = BrandDgEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", brandIds));
            brandDgEo.setSqlFilters(sqlFilterList);
            List brands = this.brandDgDomain.selectList((BaseEo)brandDgEo, Integer.valueOf(1), Integer.valueOf(brandIds.size()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)brands)) {
                brandMap = brands.stream().collect(Collectors.toMap(BaseEo::getId, BrandDgEo::getName));
            }
        }
        return brandMap;
    }

    @Override
    public Map<Long, String> getDirMapByDirIds(List<Long> dirIds) {
        Object dirMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dirIds)) {
            DirDgEo dirDgEo = DirDgEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", dirIds));
            dirDgEo.setSqlFilters(sqlFilterList);
            List dirs = this.dirDgDomain.selectList((BaseEo)dirDgEo, Integer.valueOf(1), Integer.valueOf(dirIds.size()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirs)) {
                dirMap = dirs.stream().collect(Collectors.toMap(BaseEo::getId, DirDgEo::getName));
            }
        }
        return dirMap;
    }

    private Map<Long, List<String>> getItemImgPathsMapByItemIds(List<Long> itemIds) {
        List itemMediasDgEoList = this.itemMediasDgDomain.selectByItemIds(itemIds);
        HashMap imgPathsMap = Maps.newHashMap();
        for (ItemMediasDgEo itemMediasDgEo : itemMediasDgEoList) {
            List imgPathsList = (List)imgPathsMap.get(itemMediasDgEo.getItemId());
            imgPathsList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)imgPathsList) ? Lists.newArrayList() : imgPathsList;
            imgPathsList.add(itemMediasDgEo.getPath1());
            imgPathsMap.put(itemMediasDgEo.getItemId(), imgPathsList);
        }
        return imgPathsMap;
    }

    @Override
    public PageInfo<ItemOnShelfDgRespDto> findItemOnSelf(ItemSearchDgVoReqDto searchDgVoReqDto, Integer pageNum, Integer pageSize) {
        List<ItemDgVo> itemEoList;
        List<Long> dirIdList;
        ItemSearchDgVo itemSearchDgVo = (ItemSearchDgVo)BeanUtil.copyProperties((Object)searchDgVoReqDto, ItemSearchDgVo.class, (String[])new String[0]);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSearchDgVo.getDirIds())) {
            dirIdList = this.dirDgService.getLinkAndChildDirIdList(itemSearchDgVo.getDirIds(), itemSearchDgVo.getInstanceId(), itemSearchDgVo.getTenantId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(dirIdList)) {
                return null;
            }
            itemSearchDgVo.setDirIds(dirIdList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSearchDgVo.getBackDirIds())) {
            dirIdList = this.dirDgService.getLinkAndChildDirIdList(itemSearchDgVo.getBackDirIds(), itemSearchDgVo.getInstanceId(), itemSearchDgVo.getTenantId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(dirIdList)) {
                return null;
            }
            itemSearchDgVo.setBackDirIds(dirIdList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSearchDgVo.getDirIds())) {
            List<Long> childDirIdList = this.dirDgService.getChildDirIdList(itemSearchDgVo.getDirIds(), itemSearchDgVo.getInstanceId(), itemSearchDgVo.getTenantId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(childDirIdList)) {
                return null;
            }
            itemSearchDgVo.setBackDirIds(childDirIdList);
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchDgVo.getCode())) {
            String code = itemSearchDgVo.getCode();
            String[] values = code.split("[,\\s]+");
            List<String> codes = Arrays.asList(values);
            if (codes.size() > 1000) {
                throw new BizException("\u6700\u591a\u53ef\u6279\u91cf\u67e5\u8be21000\u4e2a");
            }
            if (codes.size() == 1) {
                itemSearchDgVo.setCode(codes.get(0));
            } else {
                itemSearchDgVo.setCodes(codes);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemEoList = this.pageItemOnSelf(itemSearchDgVo))) {
            ArrayList<ItemOnShelfDgRespDto> managementBlockRespDtos = new ArrayList<ItemOnShelfDgRespDto>();
            Set itemIds = itemEoList.stream().map(ItemDgVo::getItemId).collect(Collectors.toSet());
            List dirItemRelationDgEos = this.dirItemRelationDgDomain.selectByItemIdsAndDirType((List)Lists.newArrayList(itemIds), "back");
            Map groupDirItemEo = dirItemRelationDgEos.stream().collect(Collectors.groupingBy(DirItemRelationDgEo::getItemId, Collectors.toList()));
            HashSet allDirIdSet = Sets.newHashSet();
            HashMap<Long, ArrayList> backDirIdsMap = new HashMap<Long, ArrayList>();
            for (Map.Entry groupDirItemEntry : groupDirItemEo.entrySet()) {
                Long key = groupDirItemEntry.getKey();
                List value = groupDirItemEntry.getValue();
                HashSet backDirIdSet = Sets.newHashSet();
                for (DirItemRelationDgEo dirItemRelationDgEo : value) {
                    backDirIdSet.add(dirItemRelationDgEo.getDirId());
                }
                allDirIdSet.addAll(backDirIdSet);
                backDirIdsMap.put(key, Lists.newArrayList((Iterable)backDirIdSet));
            }
            List backDirDgEos = this.dirDgDomain.selectByIds((List)Lists.newArrayList((Iterable)allDirIdSet));
            Map<Long, String> backDirNameMap = backDirDgEos.stream().collect(Collectors.toMap(BaseEo::getId, DirDgEo::getName, (e1, e2) -> e1));
            List skuIds = itemEoList.stream().filter(bean -> null != bean.getSkuId()).map(ItemDgVo::getSkuId).collect(Collectors.toList());
            List itemPriceDgEos = this.itemPriceDgDomain.selectBySkuIds(skuIds);
            Map group = itemPriceDgEos.stream().collect(Collectors.groupingBy(ItemPriceDgEo::getSkuId, Collectors.toList()));
            List collectDirId = itemEoList.stream().filter(bean -> null != bean.getDirId()).map(ItemDgVo::getDirId).collect(Collectors.toList());
            List dirDgEos = this.dirDgDomain.selectByIds(collectDirId);
            Map groupDirEo = dirDgEos.stream().collect(Collectors.groupingBy(BaseEo::getId, Collectors.toList()));
            for (ItemDgVo itemDgVo : itemEoList) {
                List backDirIds;
                ItemOnShelfDgRespDto newOne = new ItemOnShelfDgRespDto();
                BeanUtils.copyProperties((Object)itemDgVo, (Object)newOne);
                newOne.setPath(this.getMainPic(itemDgVo.getItemId()));
                newOne.setShopId(itemDgVo.getShopId());
                newOne.setItemSubType(itemDgVo.getItemSubType());
                managementBlockRespDtos.add(newOne);
                List itemPriceDgEos1 = group.get(itemDgVo.getSkuId());
                List selectDirDgEo = groupDirEo.get(itemDgVo.getDirId());
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(itemPriceDgEos1)) {
                    Map collect = itemPriceDgEos1.stream().collect(Collectors.groupingBy(ItemPriceDgEo::getPriceType, Collectors.toList()));
                    ShelfDgEo selectItem = new ShelfDgEo();
                    selectItem.setOrderByDesc("updateTime");
                    selectItem.setSkuId(itemDgVo.getSkuId());
                    selectItem.setStatus(Integer.valueOf(1));
                    selectItem.setShopId(itemSearchDgVo.getShopId());
                    selectItem.setDr(0);
                    List shelfDgEos = this.shelfDgDomain.selectList((BaseEo)selectItem);
                    List price = collect.get("PRICE");
                    newOne.setRetailPrice(org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shelfDgEos) ? null : ((ShelfDgEo)shelfDgEos.get(0)).getPrice());
                    newOne.setSellPrice(org.apache.commons.collections.CollectionUtils.isEmpty(price) ? null : ((ItemPriceDgEo)price.get(0)).getPrice());
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(selectDirDgEo)) {
                    newOne.setDirName(((DirDgEo)selectDirDgEo.get(0)).getName());
                }
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(backDirIds = (List)backDirIdsMap.get(itemDgVo.getItemId())))) continue;
                newOne.setDirId((Long)backDirIds.get(0));
                ArrayList backDirNames = Lists.newArrayList();
                for (Long backDirId : backDirIds) {
                    String backDirName = backDirNameMap.get(backDirId);
                    backDirNames.add(backDirName);
                }
                newOne.setDirName((String)backDirNames.get(0));
            }
            PageInfo result = new PageInfo();
            CubeBeanUtils.copyProperties((Object)result, (Object)new PageInfo(itemEoList), (String[])new String[]{"list", "navigatepageNums"});
            result.setList(managementBlockRespDtos);
            return result;
        }
        return new PageInfo();
    }

    private String getMainPic(Long itemId) {
        List itemMediasDgEoList = this.itemMediasDgDomain.selectByItemId(itemId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemMediasDgEoList)) {
            return ((ItemMediasDgEo)itemMediasDgEoList.get(0)).getPath1();
        }
        return null;
    }

    private List<ItemDgVo> pageItemOnSelf(ItemSearchDgVo searchVo) {
        PageHelper.startPage((int)(searchVo.getPageNum() == null ? 1 : searchVo.getPageNum()), (int)(searchVo.getPageSize() == null ? 10 : searchVo.getPageSize()));
        return this.itemDgDomain.pageItemOnSelf(searchVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItem(ItemChangeApplyDgDto changeApply) {
        AssertUtils.notNull((Object)changeApply, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtils.notNull((Object)changeApply.getItemCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a!");
        this.validSkuCode(changeApply, changeApply.getTenantId());
        if (Objects.nonNull(changeApply.getDirCode()) || Objects.nonNull(changeApply.getDirId())) {
            DirDgEo dirDgEo = (DirDgEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDgDomain.filter().eq(Objects.nonNull(changeApply.getDirCode()), (Object)"code", (Object)changeApply.getDirCode())).eq(Objects.nonNull(changeApply.getDirId()), (Object)"id", (Object)changeApply.getDirId())).one();
            AssertUtils.notNull((Object)dirDgEo, (String)"\u7c7b\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728");
            changeApply.setDirId(dirDgEo.getId());
            changeApply.setDirName(dirDgEo.getName());
        }
        ItemDgEo itemDgEo = ItemDgEo.newInstance();
        ItemDgEo oldItemDgEo = this.itemDgDomain.selectByItemCode(changeApply.getItemCode());
        this.validSkuSpecificationKey(changeApply, oldItemDgEo);
        if (Objects.isNull(oldItemDgEo)) {
            this.initItemEo(changeApply, itemDgEo);
            this.itemDgDomain.insert((BaseEo)itemDgEo);
            changeApply.setItemId(itemDgEo.getId());
            this.batchOrganizationAdd(changeApply.getRItemOrganizationDgDtoList(), changeApply.getRItemFactoryList(), itemDgEo.getId(), itemDgEo.getCode());
        } else {
            AssertUtils.isFalse((boolean)ItemDgType.BUNDLE.getIndex().equals(oldItemDgEo.getType()), (String)"\u7ec4\u5408\u5546\u54c1\u7f16\u7801\u5df2\u5b58\u5728");
            AssertUtils.isFalse((boolean)ItemDgType.MULTIPLE.getIndex().equals(oldItemDgEo.getType()), (String)"\u591a\u7248\u672c\u5546\u54c1\u7f16\u7801\u5df2\u5b58\u5728");
            itemDgEo = oldItemDgEo;
            itemDgEo.setRateCode(changeApply.getRateCode());
            this.itemDgDomain.updateSelective((BaseEo)itemDgEo);
        }
        this.addItemAssociateAttr(itemDgEo.getType(), changeApply, itemDgEo.getId(), itemDgEo.getCode(), itemDgEo.getItemAttribute());
        if (Objects.nonNull(changeApply.getSpuMedias())) {
            this.addItemspuMedias(itemDgEo.getId(), changeApply.getSpuMedias());
        }
        if (Objects.nonNull(changeApply.getImage())) {
            this.addItemImage(itemDgEo.getId(), changeApply.getImage());
        }
        if (Objects.nonNull(changeApply.getMediaDetailList())) {
            this.addItemDetailImage(itemDgEo.getId(), changeApply.getMediaDetailList());
        }
        ItemDgEo updateEo = new ItemDgEo();
        updateEo.setId(itemDgEo.getId());
        this.modifyItem(updateEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)changeApply.getSkus())) {
            logger.info("\u76d1\u542c\u5546\u54c1sku\u4fe1\u606f\u53d8\u66f4\u4e8b\u4ef6\u53d1\u5e03=================");
            List<Long> skuIds = changeApply.getSkus().stream().filter(e -> Objects.nonNull(e.getId())).map(ItemSkuDgReqDto::getId).collect(Collectors.toList());
            this.applicationContext.publishEvent((Object)new SendItemSkuMqEvent(skuIds, ItemSkuOperationTypeEnum.ADD));
        }
        this.insertItemSkuSnapshot(changeApply);
        return itemDgEo.getId();
    }

    @Override
    public void audit(ItemAuditDgReqDto itemAuditDgReqDto) {
        this.iItemAuditDgService.saveAuditItem(itemAuditDgReqDto);
        ItemDgEo item = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemAuditDgReqDto.getItemId());
        if (Objects.isNull(item)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
        ItemDgEo itemDgEo = ItemDgEo.newInstance();
        itemDgEo.setStatus(itemAuditDgReqDto.getStatus());
        itemDgEo.setId(itemAuditDgReqDto.getItemId());
        itemDgEo.setName(item.getName());
        itemDgEo.setDisplayName(item.getDisplayName());
        itemDgEo.setReturnType(item.getReturnType());
        itemDgEo.setInstanceId(item.getInstanceId());
        itemDgEo.setType(item.getType());
        this.itemDgDomain.updateSelective((BaseEo)itemDgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateItem(ItemChangeApplyDgDto changeApply) {
        logger.info("==================================>\u7f16\u8f91\u5546\u54c1\u5165\u53c2{}", (Object)JacksonUtil.toJson((Object)changeApply));
        AssertUtils.notNull((Object)changeApply, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        logger.info("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)changeApply));
        AssertUtils.notNull((Object)changeApply.getItemId(), (String)"\u5546\u54c1id\u4e0d\u53ef\u4e3a\u7a7a!");
        ItemDgEo itemDgEo = ItemDgEo.newInstance();
        ItemDgEo exist = (ItemDgEo)this.itemDgDomain.selectById((Serializable)changeApply.getItemId());
        AssertUtils.notNull((Object)exist, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (Objects.nonNull(changeApply.getDirCode()) || Objects.nonNull(changeApply.getDirId())) {
            DirDgEo dirDgEo = (DirDgEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDgDomain.filter().eq(Objects.nonNull(changeApply.getDirCode()), (Object)"code", (Object)changeApply.getDirCode())).eq(Objects.nonNull(changeApply.getDirId()), (Object)"id", (Object)changeApply.getDirId())).one();
            AssertUtils.notNull((Object)dirDgEo, (String)"\u7c7b\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728");
            changeApply.setDirId(dirDgEo.getId());
            changeApply.setDirName(dirDgEo.getName());
        }
        this.validSkuCode(changeApply, changeApply.getTenantId());
        Integer type = changeApply.getType();
        this.initItemEo(changeApply, itemDgEo);
        itemDgEo.setId(exist.getId());
        itemDgEo.setCode(exist.getCode());
        this.dealChangeExtension(changeApply, itemDgEo);
        if (Objects.isNull(changeApply.getRateCode())) {
            itemDgEo.setRateCode("");
        }
        this.validSkuSpecificationKey(changeApply, itemDgEo);
        this.batchOrganizationAdd(changeApply.getRItemOrganizationDgDtoList(), changeApply.getRItemFactoryList(), itemDgEo.getId(), itemDgEo.getCode());
        this.removeItemAssociateAttr(exist.getId(), type, changeApply);
        this.addItemAssociateAttr(type, changeApply, exist.getId(), exist.getCode(), changeApply.getItemAttribute());
        this.addItemImage(itemDgEo.getId(), changeApply.getImage());
        this.addItemspuMedias(itemDgEo.getId(), changeApply.getSpuMedias());
        this.addItemDetailImage(itemDgEo.getId(), changeApply.getMediaDetailList());
        this.modifyItem(itemDgEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)changeApply.getSkus())) {
            logger.info("\u76d1\u542c\u5546\u54c1sku\u4fe1\u606f\u53d8\u66f4\u4e8b\u4ef6\u53d1\u5e03=================");
            List<Long> skuIds = changeApply.getSkus().stream().filter(e -> Objects.nonNull(e.getId())).map(ItemSkuDgReqDto::getId).collect(Collectors.toList());
            this.applicationContext.publishEvent((Object)new SendItemSkuMqEvent(skuIds, ItemSkuOperationTypeEnum.UPDATE));
        }
        this.insertItemSkuSnapshot(changeApply);
        return exist.getId();
    }

    @Override
    public void pushEsMessage(Long itemId) {
        List itemShopDgEos = ((ExtQueryChainWrapper)this.itemShopDgDomain.filter().eq((Object)"item_id", (Object)itemId)).list();
        if (CollectionUtil.isNotEmpty((Collection)itemShopDgEos)) {
            Set<Long> itemShopIds = itemShopDgEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
            this.itemShelfDgProducer.sendMqItemShopEsMessage(itemShopIds, "UPDATE");
        }
    }

    @Override
    public void changeMarketStatus(ItemMarketStatusDgReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        this.itemDgDomain.changeMarketStatus(reqDto.getIdList(), reqDto.getMarketStatus());
    }

    @Override
    public void batchOrganizationAdd(List<RItemOrganizationDgDto> rItemOrganizationDgDtoList, List<RItemOrganizationDgDto> rItemFactoryList, Long itemId, String itemCode) {
        RItemOrganizationDgEo rItemOrganizationDgEo;
        ArrayList<RItemOrganizationDgEo> rItemOrganizationDgEos = new ArrayList<RItemOrganizationDgEo>();
        this.rItemOrganizationDgDomain.removeByItemIds(Arrays.asList(itemId));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(rItemOrganizationDgDtoList)) {
            for (RItemOrganizationDgDto rItemOrganizationDgDto : rItemOrganizationDgDtoList) {
                rItemOrganizationDgEo = new RItemOrganizationDgEo();
                BeanUtil.copyProperties((Object)rItemOrganizationDgDto, (Object)rItemOrganizationDgEo, (String[])new String[0]);
                rItemOrganizationDgEo.setItemId(itemId);
                rItemOrganizationDgEo.setOrganizationType(ItemConstants.ITEM_ORGANIZATION_TYPE_SALE);
                rItemOrganizationDgEo.setItemCode(itemCode);
                rItemOrganizationDgEo.setId(null);
                rItemOrganizationDgEos.add(rItemOrganizationDgEo);
            }
        } else {
            RItemOrganizationDgEo rItemOrganizationDgEo2 = new RItemOrganizationDgEo();
            rItemOrganizationDgEo2.setItemId(itemId);
            rItemOrganizationDgEo2.setOrganizationName("\u5168\u5c40\u6240\u6709");
            rItemOrganizationDgEo2.setOrganizationCode("000001");
            rItemOrganizationDgEo2.setOrganizationId(Long.valueOf(-1L));
            rItemOrganizationDgEo2.setOrganizationType(ItemConstants.ITEM_ORGANIZATION_TYPE_SALE);
            rItemOrganizationDgEo2.setItemCode(itemCode);
            rItemOrganizationDgEo2.setId(null);
            rItemOrganizationDgEos.add(rItemOrganizationDgEo2);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(rItemFactoryList)) {
            logger.info("==================================>\u5de5\u5382\u7ec4\u7ec7\u6570\u91cf{}", (Object)rItemFactoryList.size());
            for (RItemOrganizationDgDto rItemOrganizationDgDto : rItemFactoryList) {
                rItemOrganizationDgEo = new RItemOrganizationDgEo();
                BeanUtil.copyProperties((Object)rItemOrganizationDgDto, (Object)rItemOrganizationDgEo, (String[])new String[0]);
                rItemOrganizationDgEo.setItemId(itemId);
                rItemOrganizationDgEo.setOrganizationType(ItemConstants.ITEM_ORGANIZATION_TYPE_FACTORY);
                rItemOrganizationDgEo.setItemCode(itemCode);
                rItemOrganizationDgEo.setId(null);
                rItemOrganizationDgEos.add(rItemOrganizationDgEo);
            }
        }
        if (CollectionUtil.isNotEmpty(rItemOrganizationDgEos)) {
            this.rItemOrganizationDgDomain.insertBatch(rItemOrganizationDgEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchItemRemark(ItemRemarkDgReqDto reqDto) {
        AssertUtils.notEmpty((Object)reqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a!");
        ItemDgEo itemDgEo = new ItemDgEo();
        itemDgEo.setId(reqDto.getId());
        String remark = Objects.isNull(reqDto.getRemark()) ? " " : reqDto.getRemark();
        itemDgEo.setRemark(remark);
        this.itemDgDomain.updateSelective((BaseEo)itemDgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSendMqBySkuCodes(List<String> skuCodes, String actionType) {
        logger.info("\u6839\u636esku\u7f16\u7801\u6279\u91cf\u53d1\u9001mq\u5f00\u59cb skuCodes: {}, actionType: {}", skuCodes, (Object)actionType);
        List list = new ArrayList();
        list = CollectionUtil.isEmpty(skuCodes) ? ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().select(new String[]{"id"}).eq((Object)"create_person", (Object)"system")).list() : ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().select(new String[]{"id"}).in((Object)"code", skuCodes)).eq((Object)"create_person", (Object)"system")).list();
        List<Long> skuIds = list.stream().map(BaseEo::getId).collect(Collectors.toList());
        ItemSkuOperationTypeEnum itemSkuOperationTypeEnum = StringUtils.isBlank((CharSequence)actionType) ? ItemSkuOperationTypeEnum.ADD : ItemSkuOperationTypeEnum.UPDATE;
        this.applicationContext.publishEvent((Object)new SendItemSkuMqEvent(skuIds, itemSkuOperationTypeEnum));
        logger.info("\u6839\u636esku\u7f16\u7801\u6279\u91cf\u53d1\u9001mq\u7ed3\u675f");
    }

    private void dealChangeExtension(ItemChangeApplyDgDto changeApply, ItemDgEo itemDgEo) {
        if (StringUtils.isNotBlank((CharSequence)changeApply.getExtension())) {
            if (StringUtils.isBlank((CharSequence)itemDgEo.getExtension())) {
                itemDgEo.setExtension(changeApply.getExtension());
            } else {
                try {
                    JSONObject itemMap = JSON.parseObject((String)itemDgEo.getExtension());
                    JSONObject versionMap = JSON.parseObject((String)changeApply.getExtension());
                    itemMap.putAll(versionMap);
                    itemDgEo.setExtension(JSON.toJSONString((Object)itemMap));
                }
                catch (Exception e) {
                    logger.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ItemDgEo queryById(Long id) {
        return (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatusBatch(List<Long> itemIds, Integer status) {
        this.itemDgDomain.updateStatusByIds(itemIds, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItem(ItemDgEo itemDgEo) {
        List list = this.itemDgDomain.selectList((BaseEo)itemDgEo);
        for (ItemDgEo item : list) {
            this.removeItem(item.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItem(Long id) {
        ItemDgEo eo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(id);
        if (null != eo) {
            if (eo.getStatus() == 2) {
                throw new ItemBusinessRuntimeException(id + "\u5bf9\u5e94\u7684\u5546\u54c1\u8bf7\u5148\u4e0b\u67b6");
            }
            if (ItemDgType.BUNDLE.getIndex().equals(eo.getType())) {
                ItemBundleRelationDgEo bundleItemEo = new ItemBundleRelationDgEo();
                bundleItemEo.setItemId(id);
                this.itemBundleRelationDgDomain.logicDelete((BaseEo)bundleItemEo);
            }
            ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance();
            itemMediasDgEo.setItemId(id);
            this.itemMediasDgDomain.logicDelete((BaseEo)itemMediasDgEo);
            ItemPriceDgEo priceEo = ItemPriceDgEo.newInstance();
            priceEo.setItemId(id);
            this.itemPriceDgDomain.logicDelete((BaseEo)priceEo);
            ItemAttributesDgEo itemAttributesDgEo = ItemAttributesDgEo.newInstance();
            itemAttributesDgEo.setItemId(id);
            this.itemAttributesDgDomain.logicDelete((BaseEo)itemAttributesDgEo);
            ItemSkuDgEo itemSkuDgEo = ItemSkuDgEo.newInstance();
            itemSkuDgEo.setItemId(id);
            this.itemSkuDgDomain.logicDelete((BaseEo)itemSkuDgEo);
            this.itemDgDomain.logicDelete((BaseEo)eo);
            ItemTagRelationDgEo itemTagEo = new ItemTagRelationDgEo();
            itemTagEo.setItemId(id);
            this.itemTagRelationDgDomain.logicDelete((BaseEo)itemTagEo);
            ItemPropRelationDgEo itemPropRelationDgEo = ItemPropRelationDgEo.newInstance();
            itemPropRelationDgEo.setItemId(id);
            this.itemPropRelationDgDomain.logicDelete((BaseEo)itemPropRelationDgEo);
        }
    }

    @Override
    @Transactional
    public void updateItem(ItemDgEo itemDgEo) {
        this.itemDgDomain.updateSelective((BaseEo)itemDgEo);
    }

    @Override
    public void publish(ItemPublishDgReqDto itemPublishDgReqDto) {
        if (Objects.isNull(itemPublishDgReqDto)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        if (Objects.isNull(itemPublishDgReqDto.getItemId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        ItemDgEo item = this.queryById(itemPublishDgReqDto.getItemId());
        if (item == null) {
            return;
        }
        ItemDgEo itemDgEo = new ItemDgEo();
        itemDgEo.setId(itemPublishDgReqDto.getItemId());
        if (item.getType().equals(ItemDgType.GENERAL.getIndex())) {
            itemDgEo.setStatus(ItemDgStatus.ITEM_AUDITING.getStatus());
        } else {
            itemDgEo.setStatus(ItemDgStatus.ITEM_AUDITING.getStatus());
        }
        this.itemDgDomain.updateSelective((BaseEo)itemDgEo);
    }

    @Override
    public List<ItemDgEo> queryItems(ItemDgEo itemDgEo) {
        if (itemDgEo != null) {
            return this.itemDgDomain.selectList((BaseEo)itemDgEo);
        }
        return new ArrayList<ItemDgEo>();
    }

    @Override
    public PageInfo<ItemDgPageRespDto> queryByPage(ItemPageDgReqDto pageDto) {
        this.getQueryParam(pageDto);
        PageInfo eoPageInfo = this.itemDgDomain.queryByConditionPage(pageDto);
        PageInfo<ItemDgPageRespDto> pageInfo = ConvertDgUtil.convertPage(eoPageInfo, ItemDgPageRespDto.class);
        this.setDirNameTree(pageInfo.getList());
        this.setRItemOrganization(pageInfo.getList());
        return pageInfo;
    }

    @Override
    public List<ItemDgPageRespDto> queryByList(ItemPageDgReqDto pageDto) {
        this.getQueryParam(pageDto);
        List eoList = this.itemDgDomain.queryByConditionList(pageDto);
        List itemDgPageRespDtos = BeanUtil.copyToList((Collection)eoList, ItemDgPageRespDto.class);
        this.setDirNameTree(itemDgPageRespDtos);
        this.setRItemOrganization(itemDgPageRespDtos);
        return itemDgPageRespDtos;
    }

    private void setRItemOrganization(List<ItemDgPageRespDto> itemList) {
        if (CollectionUtil.isEmpty(itemList)) {
            return;
        }
        List itemIds = itemList.stream().map(ItemDgPageRespDto::getId).collect(Collectors.toList());
        List organizationDgEos = ((ExtQueryChainWrapper)this.rItemOrganizationDgDomain.filter().in((Object)"item_id", itemIds)).list();
        if (CollectionUtil.isNotEmpty((Collection)organizationDgEos)) {
            ArrayList<RItemOrganizationDgDto> rItemOrganizationDgDtos = new ArrayList<RItemOrganizationDgDto>();
            for (RItemOrganizationDgEo organizationDgEo : organizationDgEos) {
                RItemOrganizationDgDto organizationDgDto = new RItemOrganizationDgDto();
                BeanUtil.copyProperties((Object)organizationDgEo, (Object)organizationDgDto, (String[])new String[0]);
                organizationDgDto.setOrganizationType(Objects.nonNull(organizationDgEo.getOrganizationType()) ? organizationDgEo.getOrganizationType() : ItemConstants.ITEM_ORGANIZATION_TYPE_SALE);
                rItemOrganizationDgDtos.add(organizationDgDto);
            }
            Map<Long, List<RItemOrganizationDgDto>> organizationMap = rItemOrganizationDgDtos.stream().collect(Collectors.groupingBy(RItemOrganizationDgDto::getItemId));
            for (ItemDgPageRespDto itemDgPageRespDto : itemList) {
                List<RItemOrganizationDgDto> organizationDgDtos = organizationMap.get(itemDgPageRespDto.getId());
                if (org.apache.commons.collections.CollectionUtils.isEmpty(organizationDgDtos)) continue;
                Map<Integer, List<RItemOrganizationDgDto>> typeMap = organizationDgDtos.stream().collect(Collectors.groupingBy(RItemOrganizationDgDto::getOrganizationType));
                itemDgPageRespDto.setRItemOrganizationDgDtoList(typeMap.get(ItemConstants.ITEM_ORGANIZATION_TYPE_SALE));
                itemDgPageRespDto.setRItemFactoryList(typeMap.get(ItemConstants.ITEM_ORGANIZATION_TYPE_FACTORY));
            }
        }
    }

    private void setDirNameTree(List<ItemDgPageRespDto> skuList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuList)) {
            return;
        }
        Set ids = skuList.stream().map(ItemDgPageRespDto::getDirId).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(ids)) {
            Map<Long, List<DirDgEo>> parentByChildDriIds = this.dirDgService.getParentByChildDriIds(Lists.newArrayList(ids));
            skuList.forEach(e -> this.joinDirName((ItemDgPageRespDto)e, parentByChildDriIds));
        }
        Set dirPrefixIds = skuList.stream().map(ItemDgPageRespDto::getDirPrefixId).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(ids)) {
            Map<Long, List<DirDgEo>> dirPrefixIdEos = this.dirDgService.getParentByChildDriIds(Lists.newArrayList(dirPrefixIds));
            skuList.forEach(e -> this.joinPreDirName((ItemDgPageRespDto)e, dirPrefixIdEos));
        }
    }

    private void joinDirName(ItemDgPageRespDto dto, Map<Long, List<DirDgEo>> parentByChildDriIds) {
        List<DirDgEo> dirDgEos = parentByChildDriIds.get(dto.getDirId());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dirDgEos)) {
            return;
        }
        dto.setDirList(ConvertDgUtil.copyToList(dirDgEos, DirRespDto.class));
        dto.setDirName(this.makeDirName(dirDgEos));
    }

    private void joinPreDirName(ItemDgPageRespDto dto, Map<Long, List<DirDgEo>> parentByChildDriIds) {
        List<DirDgEo> dirDgEos = parentByChildDriIds.get(dto.getDirId());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dirDgEos)) {
            return;
        }
        dto.setDirPrefixList(ConvertDgUtil.copyToList(dirDgEos, DirRespDto.class));
        dto.setDirPrefixName(this.makeDirName(dirDgEos));
    }

    private String makeDirName(List<DirDgEo> dirList) {
        if (CollectionUtil.isEmpty(dirList)) {
            return null;
        }
        String result = dirList.stream().map(DirDgEo::getName).collect(Collectors.joining("/"));
        return result;
    }

    private void getQueryParam(ItemPageDgReqDto pageDto) {
        List<Long> childDirIdList;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getDirIdList())) {
            childDirIdList = this.dirDgService.getChildDirIdList(pageDto.getDirIdList(), pageDto.getInstanceId(), pageDto.getTenantId());
            pageDto.setDirIdList(childDirIdList);
        }
        if (pageDto.getDirId() != null) {
            childDirIdList = this.dirDgService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{pageDto.getDirId()}), pageDto.getInstanceId(), pageDto.getTenantId());
            pageDto.setDirIdList(childDirIdList);
        }
        if (CollectionUtil.isNotEmpty((Collection)pageDto.getDirPrefixIdList())) {
            childDirIdList = this.dirDgService.getChildDirIdList(Lists.newArrayList((Iterable)pageDto.getDirPrefixIdList()), pageDto.getInstanceId(), pageDto.getTenantId());
            pageDto.setDirPrefixIdList(childDirIdList);
        }
    }

    private LambdaQueryWrapper<ItemDgEo> buildQueryItemDgCondition(ItemPageDgReqDto pageDto) {
        ItemDgEo itemDgEo = (ItemDgEo)ConvertDgUtil.toBean((Object)pageDto, ItemDgEo.class);
        itemDgEo.setDr(0);
        itemDgEo.setCode(null);
        itemDgEo.setName(null);
        itemDgEo.setDirId(null);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)itemDgEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getIds())) {
            queryWrapper.in(BaseEo::getId, (Collection)pageDto.getIds());
        }
        if (StrUtil.isNotBlank((CharSequence)pageDto.getCode())) {
            queryWrapper.like(ItemDgEo::getCode, (Object)("%" + pageDto.getCode() + "%"));
        }
        if (CollectionUtil.isNotEmpty((Collection)pageDto.getCodeList())) {
            queryWrapper.in(ItemDgEo::getCode, (Collection)pageDto.getCodeList());
        }
        if (StrUtil.isNotBlank((CharSequence)pageDto.getName())) {
            queryWrapper.like(ItemDgEo::getName, (Object)("%" + pageDto.getName() + "%"));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getOrganizationIdList())) {
            queryWrapper.in(ItemDgEo::getOrganizationId, (Collection)pageDto.getOrganizationIdList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getShopIds())) {
            queryWrapper.in(ItemDgEo::getShopId, (Collection)pageDto.getShopIds());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getStatusList())) {
            queryWrapper.in(ItemDgEo::getStatus, (Collection)pageDto.getStatusList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getItemAttributeList())) {
            queryWrapper.in(ItemDgEo::getItemAttribute, (Collection)pageDto.getItemAttributeList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getSubTypeList())) {
            queryWrapper.in(ItemDgEo::getSubType, (Collection)pageDto.getSubTypeList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getTypeList())) {
            queryWrapper.in(ItemDgEo::getType, (Collection)pageDto.getTypeList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getDirIdList())) {
            queryWrapper.in(ItemDgEo::getDirId, this.dirDgService.getChildDirIdList(pageDto.getDirIdList(), pageDto.getInstanceId(), pageDto.getTenantId()));
        }
        if (pageDto.getDirId() != null) {
            queryWrapper.in(ItemDgEo::getDirId, this.dirDgService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{pageDto.getDirId()}), pageDto.getInstanceId(), pageDto.getTenantId()));
        }
        if (CollectionUtil.isNotEmpty((Collection)pageDto.getDirPrefixIdList())) {
            queryWrapper.in(ItemDgEo::getDirPrefixId, this.dirDgService.getChildDirIdList(Lists.newArrayList((Iterable)pageDto.getDirPrefixIdList()), pageDto.getInstanceId(), pageDto.getTenantId()));
        }
        if (null != pageDto.getYearEnd()) {
            queryWrapper.le(ItemDgEo::getYear, (Object)pageDto.getYearEnd());
        }
        if (null != pageDto.getYearBegin()) {
            queryWrapper.ge(ItemDgEo::getYear, (Object)pageDto.getYearBegin());
        }
        if (StringUtils.isNotBlank((CharSequence)pageDto.getKeyword())) {
            StringBuilder sql = new StringBuilder();
            sql.append(" ( ");
            sql.append("code like '%" + pageDto.getKeyword() + "%' or name like '%" + pageDto.getKeyword() + "%'");
            sql.append(")");
            queryWrapper.apply(sql.toString(), new Object[0]);
        }
        queryWrapper.orderByDesc((Object[])new SFunction[]{BaseEo::getCreateTime, BaseEo::getId});
        return queryWrapper;
    }

    private void setBackDirList(List<ItemDgRespDto> itemDgRespDtoList, List<Long> itemIds) {
        List<ItemAttributesDgRespDto> itemAttributesDgRespDtos = this.itemAttributesDgService.queryItemAttrByItemIdList(itemIds);
        HashMap<Long, List> dirListMap = new HashMap<Long, List>();
        HashSet dirList = Sets.newHashSet();
        for (ItemAttributesDgRespDto itemAttributesDgRespDto : itemAttributesDgRespDtos) {
            JSONObject jsonObject = JSON.parseObject((String)itemAttributesDgRespDto.getAttrs());
            JSONArray backDirListJson = jsonObject.getJSONArray("backDirList");
            List backDirList = backDirListJson.toJavaList(Long.class);
            dirListMap.put(itemAttributesDgRespDto.getItemId(), backDirList);
            dirList.addAll(backDirList);
        }
        Map<Object, Object> dirMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirList)) {
            DirDgEo dirDgEo = DirDgEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)dirList));
            dirDgEo.setSqlFilters(sqlFilterList);
            List dirs = this.dirDgDomain.selectList((BaseEo)dirDgEo, Integer.valueOf(1), Integer.valueOf(dirList.size()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirs)) {
                dirMap = dirs.stream().collect(Collectors.toMap(BaseEo::getId, DirDgEo::getName));
            }
        }
        for (ItemDgRespDto itemDgRespDto : itemDgRespDtoList) {
            List dirIdList = (List)dirListMap.get(itemDgRespDto.getId());
            itemDgRespDto.setDirIdList(dirIdList);
            ArrayList<String> dirNameList = new ArrayList<String>();
            itemDgRespDto.setDirNameList(dirNameList);
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirIdList)) continue;
            for (Long dirId : dirIdList) {
                String dirName = (String)dirMap.get(dirId);
                dirNameList.add(dirName);
            }
        }
    }

    public void setDirsItemsByItemIds(List<ItemDgRespDto> itemDgRespDtoList, List<Long> itemIds) {
        List dirsItemsEoList = this.dirItemRelationDgDomain.selectByItemIds(itemIds);
        ArrayList dirsItemsDgRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)dirsItemsEoList, (Collection)dirsItemsDgRespDtoList, DirsItemsDgRespDto.class);
        HashMap dirsItemsMap = Maps.newHashMap();
        for (DirsItemsDgRespDto dirsItemsDgRespDto : dirsItemsDgRespDtoList) {
            List mapDirsItemsList = (List)dirsItemsMap.get(dirsItemsDgRespDto.getItemId());
            mapDirsItemsList = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)mapDirsItemsList) ? mapDirsItemsList : Lists.newArrayList();
            mapDirsItemsList.add(dirsItemsDgRespDto);
            dirsItemsMap.put(dirsItemsDgRespDto.getItemId(), mapDirsItemsList);
        }
        for (ItemDgRespDto itemDgRespDto : itemDgRespDtoList) {
            itemDgRespDto.setDirsItemsList((List)dirsItemsMap.get(itemDgRespDto.getId()));
        }
    }

    public void setShelfTasksByItemId(List<ItemDgRespDto> itemDgRespDtoList, List<Long> itemIds) {
        List shelfTaskDgEoList = this.shelfTaskDgDomain.selectByItemIds(itemIds);
        ArrayList shelfTaskDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)shelfTaskDgEoList, (Collection)shelfTaskDtoList, ShelfTaskDgRespDto.class);
        HashMap shelfTasksMap = Maps.newHashMap();
        for (ShelfTaskDgRespDto shelfTaskDto : shelfTaskDtoList) {
            List map = (List)shelfTasksMap.get(shelfTaskDto.getItemId());
            map = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)map) ? map : Lists.newArrayList();
            map.add(shelfTaskDto);
            shelfTasksMap.put(shelfTaskDto.getItemId(), map);
        }
        for (ItemDgRespDto dto : itemDgRespDtoList) {
            dto.setShelfTaskDgRespDtoList((List)shelfTasksMap.get(dto.getId()));
        }
    }

    @Override
    public ItemDetailDgRespDto queryItemDetail(Long itemId, String field, Long dirId) {
        List shopDirIdList;
        ItemDetailDgRespDto itemDetailDto = new ItemDetailDgRespDto();
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemId);
        if (itemDgEo == null) {
            return itemDetailDto;
        }
        List<ItemPropRelationDgRespDto> itemPropRelationDgRespDtos = this.propDgService.queryByItemId(itemId);
        itemDetailDto.setItemPropRelationDgRespDtos(itemPropRelationDgRespDtos);
        String propGroupInfo = itemDgEo.getPropGroupInfo();
        if (StringUtils.isNotBlank((CharSequence)propGroupInfo)) {
            List propGroupDtoList = JSON.parseArray((String)propGroupInfo, ItemPropGroupDgDto.class);
            itemDetailDto.setPropGroupDtoList(propGroupDtoList);
        }
        ItemDgRespDto itemDto = new ItemDgRespDto();
        DtoHelper.eo2Dto((BaseEo)itemDgEo, (BaseVo)itemDto);
        if (StringUtils.isBlank((CharSequence)field)) {
            itemDetailDto.setItem(itemDto);
            return itemDetailDto;
        }
        if (field.contains("sku")) {
            this.setItemSkuByItemIds(Lists.newArrayList((Object[])new ItemDgRespDto[]{itemDto}), Lists.newArrayList((Object[])new Long[]{itemDgEo.getId()}));
            itemDetailDto.setItemSkuList(itemDto.getItemSkuList());
            itemDto.setItemSkuList(null);
        }
        if (field.contains("attributes")) {
            List<ItemAttributesDgRespDto> itemAttributesDtoList = this.itemAttributesDgService.queryByItemId(itemId);
            itemDetailDto.setItemAttributesList(itemAttributesDtoList);
        }
        if (field.contains("medias")) {
            List<ItemMediasDgRespDto> itemMediasDtoList = this.itemMediasDgService.queryByItemId(itemId);
            itemDetailDto.setItemMediasList(itemMediasDtoList);
        }
        DirItemRelationDgEo eo = DirItemRelationDgEo.newInstance();
        eo.setItemId(itemId);
        if (dirId != null) {
            eo.setOrderBy("id");
            eo.setDirId(dirId);
        }
        List<DirsItemsDgRespDto> dirsItemsDgRespDtos = this.dirItemRelationDgService.queryList(itemId);
        itemDetailDto.setDirsItemsList(dirsItemsDgRespDtos);
        itemDetailDto.setItem(itemDto);
        if (StringUtils.isNotBlank((CharSequence)itemDgEo.getSaleChannel())) {
            itemDetailDto.setSaleChannels(Arrays.asList(itemDgEo.getSaleChannel().split("-")));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shopDirIdList = dirsItemsDgRespDtos.stream().filter(dirsItemsRespDto -> Objects.equals("shop", dirsItemsRespDto.getDirType())).map(DirsItemsDgRespDto::getDirId).collect(Collectors.toList()))) {
            DirDgEo dirDgEo = DirDgEo.newInstance();
            dirDgEo.setId((Long)shopDirIdList.get(0));
            dirDgEo = (DirDgEo)this.dirDgDomain.selectOne((BaseEo)dirDgEo);
            itemDetailDto.setShopDirId(dirDgEo.getId());
            itemDetailDto.setShopDirName(dirDgEo.getName());
        }
        return itemDetailDto;
    }

    @Override
    public ItemDgDoc queryItemDoc(Long id) {
        ItemDgDoc itemDoc = new ItemDgDoc();
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(id);
        CubeBeanUtils.copyProperties((Object)itemDoc, (Object)itemDgEo, (String[])new String[0]);
        ItemAttributesDgEo attributesEo = ItemAttributesDgEo.newInstance();
        attributesEo.setItemId(id);
        List attributesEos = this.itemAttributesDgDomain.selectList((BaseEo)attributesEo);
        itemDoc.setAttributesEos(attributesEos);
        List<ItemSkuDgDoc> itemSkuDto = this.itemSkuDgService.queryItemSku(id);
        itemDoc.setItemSkuDtos(itemSkuDto);
        return itemDoc;
    }

    @Override
    public ItemSearchDgRespDto queryByKeyword(ItemSearchQueryDgReqDto itemSearchQueryDgReqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u67e5\u8be2\u5546\u54c1ES\u7684\u8bf7\u6c42\u53c2\u6570: {}", (Object)itemSearchQueryDgReqDto);
        ItemSearchDgRespDto itemSearchDto = this.itemSearchDgService.query(itemSearchQueryDgReqDto, pageNum, pageSize);
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5546\u54c1ES\u7684\u54cd\u5e94\u7ed3\u679c: {}", (Object)itemSearchDto);
        }
        if (itemSearchQueryDgReqDto.getSearch().booleanValue()) {
            this.fillAttributeAndDirItem(itemSearchDto);
        }
        return itemSearchDto;
    }

    @Override
    public ItemSearchDgRespDto queryByKeywordNew(ItemSearchQueryDgReqDto itemSearchQueryDgReqDto, Integer pageNum, Integer pageSize) {
        if (this.usrData) {
            if (pageSize > this.limit) {
                pageSize = this.limit;
            }
            return this.queryByKeyword(itemSearchQueryDgReqDto, pageNum, pageSize);
        }
        return this.searchShelfDataByDb(itemSearchQueryDgReqDto, pageNum, pageSize);
    }

    private ItemSearchDgRespDto searchShelfDataByDb(ItemSearchQueryDgReqDto itemSearchQueryDgReqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u7684\u5546\u54c1\u4e0a\u67b6\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)itemSearchQueryDgReqDto));
        ItemSearchDgRespDto itemSearchDto = new ItemSearchDgRespDto();
        PageInfo pageInfo = this.itemDgDomain.selectByKeyword(itemSearchQueryDgReqDto.getKeyword(), itemSearchQueryDgReqDto.getItemType(), itemSearchQueryDgReqDto.getDirIds(), itemSearchQueryDgReqDto.getBrandId(), itemSearchQueryDgReqDto.getItemIds(), null, itemSearchQueryDgReqDto.getSellerId(), itemSearchQueryDgReqDto.getShopId(), itemSearchQueryDgReqDto.getShopIds(), null, null, pageNum, pageSize, itemSearchQueryDgReqDto.getInstanceId(), itemSearchQueryDgReqDto.getTenantId(), itemSearchQueryDgReqDto.getSubType(), itemSearchQueryDgReqDto.getSubTypeList(), itemSearchQueryDgReqDto.getBusType(), itemSearchQueryDgReqDto.getStatus());
        List shelfItemDgVoList = pageInfo.getList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shelfItemDgVoList)) {
            return itemSearchDto;
        }
        List<ItemDgRespDto> itemDgRespDtoList = this.transferItemRespDto(shelfItemDgVoList, null);
        Map<Long, List<ItemShelfDgRespDto>> shelfMap = shelfItemDgVoList.stream().map(vo -> {
            ItemShelfDgRespDto itemShelfDgRespDto = new ItemShelfDgRespDto();
            itemShelfDgRespDto.setItemId(vo.getItemId());
            itemShelfDgRespDto.setSkuId(vo.getSkuId());
            itemShelfDgRespDto.setShopId(vo.getShopId());
            itemShelfDgRespDto.setPrice(vo.getPrice());
            itemShelfDgRespDto.setStatus(vo.getStatus());
            itemShelfDgRespDto.setSellerId(vo.getSellerId());
            itemShelfDgRespDto.setBusType(vo.getBusType());
            itemShelfDgRespDto.setDistribution(vo.getDistribution());
            return itemShelfDgRespDto;
        }).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(ItemShelfDgRespDto::getItemId));
        for (ItemDgRespDto itemDgRespDto : itemDgRespDtoList) {
            itemDgRespDto.setItemShelfInfoList(shelfMap.get(itemDgRespDto.getItemId()));
            itemDgRespDto.setShopId(itemSearchQueryDgReqDto.getShopId());
        }
        PageInfo rePageInfo = itemSearchDto.getPageInfo();
        if (rePageInfo == null || rePageInfo.getList() == null || rePageInfo.getList().size() == 0) {
            logger.debug("\u67e5\u8be2\u4e0b\u67b6\u5546\u54c1\u54cd\u5e94\u7ed3\u679c: {}", (Object)JSON.toJSONString(itemDgRespDtoList));
            PageInfo itemRespDtoPageInfo = new PageInfo();
            itemRespDtoPageInfo.setTotal((long)itemDgRespDtoList.size());
            itemRespDtoPageInfo.setList(itemDgRespDtoList);
            itemSearchDto.setPageInfo(itemRespDtoPageInfo);
        } else {
            rePageInfo.setTotal(rePageInfo.getTotal() + (long)itemDgRespDtoList.size());
            rePageInfo.getList().addAll(itemDgRespDtoList);
            itemSearchDto.setPageInfo(rePageInfo);
        }
        logger.debug("\u67e5\u8be2\u5546\u54c1\u54cd\u5e94\u7ed3\u679c: {}", (Object)JSON.toJSONString((Object)itemSearchDto));
        return itemSearchDto;
    }

    public List<ItemDgRespDto> transferItemRespDto(List<ShelfItemDgVo> shelfItemDgVoList, Long sellerId) {
        List<ItemDgRespDto> itemDgRespDtoList = shelfItemDgVoList.stream().map(vo -> {
            ItemDgRespDto itemDgRespDto = new ItemDgRespDto();
            BeanUtils.copyProperties((Object)vo, (Object)itemDgRespDto);
            itemDgRespDto.setName(vo.getItemName());
            itemDgRespDto.setCode(vo.getItemCode());
            return itemDgRespDto;
        }).collect(Collectors.toList());
        List<Long> itemIdList = shelfItemDgVoList.stream().map(ShelfItemDgVo::getItemId).collect(Collectors.toList());
        this.setItemSkuByItemIds(itemDgRespDtoList, itemIdList);
        this.setItemMediasByItemIds(itemDgRespDtoList, itemIdList);
        DirItemRelationDgEo dirItemRelationDgEo = new DirItemRelationDgEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        dirItemRelationDgEo.setSellerId(sellerId);
        sqlFilterList.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIdList, (String)",")));
        dirItemRelationDgEo.setSqlFilters(sqlFilterList);
        List dirItemRelationDgEoList = this.dirItemRelationDgDomain.selectList((BaseEo)dirItemRelationDgEo);
        ArrayList dirsItemsList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)dirItemRelationDgEoList, dirsItemsList, DirsItemsDgRespDto.class);
        Map<Long, List<DirsItemsDgRespDto>> group = dirsItemsList.stream().collect(Collectors.groupingBy(DirsItemsDgRespDto::getItemId));
        itemDgRespDtoList.forEach(itemRespDto -> {
            if (group.containsKey(itemRespDto.getId())) {
                itemRespDto.setDirsItemsList((List)group.get(itemRespDto.getItemId()));
            }
        });
        return itemDgRespDtoList;
    }

    @Override
    public List<ItemDgRespDto> queryItemRespDto(List<ItemDgEo> itemDgEoList, Long sellerId) {
        ArrayList<ItemDgRespDto> itemDgRespDtoList = new ArrayList<ItemDgRespDto>();
        DtoHelper.eoList2DtoList(itemDgEoList, itemDgRespDtoList, ItemDgRespDto.class);
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        for (ItemDgEo itemDgEo : itemDgEoList) {
            itemIdList.add(itemDgEo.getId());
        }
        this.setItemSkuByItemIds(itemDgRespDtoList, itemIdList);
        this.setItemMediasByItemIds(itemDgRespDtoList, itemIdList);
        DirItemRelationDgEo dirItemRelationDgEo = new DirItemRelationDgEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        dirItemRelationDgEo.setSellerId(sellerId);
        sqlFilterList.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIdList, (String)",")));
        dirItemRelationDgEo.setSqlFilters(sqlFilterList);
        List dirItemRelationDgEoList = this.dirItemRelationDgDomain.selectList((BaseEo)dirItemRelationDgEo);
        ArrayList dirsItemsList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)dirItemRelationDgEoList, dirsItemsList, DirsItemsDgRespDto.class);
        Map<Long, List<DirsItemsDgRespDto>> group = dirsItemsList.stream().collect(Collectors.groupingBy(DirsItemsDgRespDto::getItemId));
        itemDgRespDtoList.forEach(itemRespDto -> {
            if (group.containsKey(itemRespDto.getId())) {
                itemRespDto.setDirsItemsList((List)group.get(itemRespDto.getId()));
                itemRespDto.setShopId(itemRespDto.getShopId());
            }
        });
        return itemDgRespDtoList;
    }

    @Override
    public void addOrModifyItemSalesCount(ItemStatDgReqDto itemStatDgReqDto) {
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemStatDgReqDto.getItemId());
        if (itemDgEo == null) {
            throw new BizException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        StatDgEo statDgEo = new StatDgEo();
        statDgEo.setItemId(itemStatDgReqDto.getItemId());
        statDgEo.setInstanceId(itemStatDgReqDto.getInstanceId());
        statDgEo.setTenantId(itemStatDgReqDto.getTenantId());
        StatDgEo selectEo = (StatDgEo)this.statDgDomain.selectOne((BaseEo)statDgEo);
        if (selectEo == null) {
            statDgEo.setSalesCount(itemStatDgReqDto.getSalesCount());
            this.statDgDomain.insert((BaseEo)statDgEo);
        } else {
            Long oldCount = Optional.ofNullable(selectEo.getSalesCount()).orElse(0L);
            Long addCount = Optional.ofNullable(itemStatDgReqDto.getSalesCount()).orElse(0L);
            statDgEo = new StatDgEo();
            statDgEo.setId(selectEo.getId());
            statDgEo.setSalesCount(Long.valueOf(oldCount + addCount));
            this.statDgDomain.updateSelective((BaseEo)statDgEo);
        }
    }

    @Override
    public ItemStatDgRespDto queryItemSalesCountByItemId(Long itemId) {
        StatDgEo statDgEo = new StatDgEo();
        statDgEo.setItemId(itemId);
        statDgEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        statDgEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        statDgEo = (StatDgEo)this.statDgDomain.selectOne((BaseEo)statDgEo);
        ItemStatDgRespDto itemStatDgRespDto = new ItemStatDgRespDto();
        if (statDgEo == null) {
            return itemStatDgRespDto;
        }
        DtoHelper.eo2Dto((BaseEo)statDgEo, (BaseVo)itemStatDgRespDto);
        return itemStatDgRespDto;
    }

    private void fillAttributeAndDirItem(ItemSearchDgRespDto itemSearchDgRespDto) {
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        if (null == itemSearchDgRespDto.getPageInfo()) {
            return;
        }
        List itemDgRespDtoList = itemSearchDgRespDto.getPageInfo().getList();
        for (ItemDgRespDto itemDgRespDto : itemDgRespDtoList) {
            itemIdList.add(itemDgRespDto.getId());
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemIdList)) {
            return;
        }
        ItemSkuDgEo query = ItemSkuDgEo.newInstance();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"item_id", itemIdList));
        query.setSqlFilters(filters);
        List itemSkuDgEos = this.itemSkuDgDomain.selectList((BaseEo)query);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkuDgEos)) {
            Map<Long, ItemSkuDgEo> skuEoMap = itemSkuDgEos.stream().collect(Collectors.toMap(BaseEo::getId, itemSkuEo -> itemSkuEo));
            itemDgRespDtoList.forEach(itemRespDto -> itemRespDto.getItemSkuList().forEach(itemSkuRespDto -> {
                if (skuEoMap.containsKey(itemSkuRespDto.getId())) {
                    ItemSkuDgEo skuEo = (ItemSkuDgEo)skuEoMap.get(itemSkuRespDto.getId());
                    itemSkuRespDto.setAddPriceMax(skuEo.getAddPriceMax());
                    itemSkuRespDto.setAddPriceMin(skuEo.getAddPriceMin());
                    itemSkuRespDto.setAddPriceMode(skuEo.getAddPriceMode());
                    itemSkuRespDto.setAddPriceStatus(skuEo.getAddPriceStatus());
                }
            }));
        }
        List itemAttributesDgEoList = this.itemAttributesDgDomain.selectByItemIds(itemIdList);
        ArrayList<Long> dirIdList = new ArrayList<Long>();
        HashMap<Long, Long> itemIdDirIdMap = new HashMap<Long, Long>();
        List dirItemRelationDgEoList = this.dirItemRelationDgDomain.selectByItemIds(itemIdList);
        for (DirItemRelationDgEo dirItemRelationDgEo : dirItemRelationDgEoList) {
            if (dirItemRelationDgEo.getDirId() == null || dirIdList.contains(dirItemRelationDgEo.getDirId())) continue;
            dirIdList.add(dirItemRelationDgEo.getDirId());
            if (!Objects.nonNull(dirItemRelationDgEo.getShopId())) continue;
            itemIdDirIdMap.put(dirItemRelationDgEo.getItemId(), dirItemRelationDgEo.getDirId());
        }
        List dirDgEoList = this.dirDgDomain.selectByIds(dirIdList);
        ArrayList itemAttributesDgRespDtoList = new ArrayList();
        ArrayList directoryItemDgRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)itemAttributesDgEoList, itemAttributesDgRespDtoList, ItemAttributesDgRespDto.class);
        DtoHelper.eoList2DtoList((Collection)dirDgEoList, directoryItemDgRespDtoList, DirectoryItemDgRespDto.class);
        itemSearchDgRespDto.setAttributesList(itemAttributesDgRespDtoList);
        itemSearchDgRespDto.setDirectoryItemList(directoryItemDgRespDtoList);
        Map<Long, String> dirIdNameMap = null;
        try {
            dirIdNameMap = directoryItemDgRespDtoList.stream().collect(Collectors.toMap(DirectoryItemDgRespDto::getId, DirectoryItemDgRespDto::getName));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (CollectionUtils.isEmpty(dirIdNameMap)) {
            return;
        }
        Map<Long, String> dirIdNameMap2 = dirIdNameMap;
        itemSearchDgRespDto.getPageInfo().getList().forEach(itemRespDto -> {
            Long dirId;
            if (itemIdDirIdMap.containsKey(itemRespDto.getId()) && Objects.nonNull(dirId = (Long)itemIdDirIdMap.get(itemRespDto.getId()))) {
                itemRespDto.setShopDirId(dirId);
                String shopDirName = (String)dirIdNameMap2.get(dirId);
                itemRespDto.setShopDirName(shopDirName);
            }
        });
    }

    public void setItemMediasByItemIds(List<ItemDgRespDto> itemDtoList, List<Long> itemIds) {
        List itemMediasDgEoList = this.itemMediasDgDomain.selectByItemIds(itemIds);
        ArrayList mediasDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemMediasDgEoList, (Collection)mediasDtoList, ItemMediasDgRespDto.class);
        Map<Long, List<ItemMediasDgRespDto>> itemMediasMap = this.getItemMediasMapByItemIds(mediasDtoList);
        for (ItemDgRespDto itemDto : itemDtoList) {
            itemDto.setItemMediasList(itemMediasMap.get(itemDto.getId()));
        }
    }

    private Map<Long, List<ItemMediasDgRespDto>> getItemMediasMapByItemIds(List<ItemMediasDgRespDto> mediasDtoList) {
        HashMap itemMediasMap = Maps.newHashMap();
        for (ItemMediasDgRespDto itemMediasDto : mediasDtoList) {
            List mapItemMediasList = (List)itemMediasMap.get(itemMediasDto.getItemId());
            mapItemMediasList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)mapItemMediasList) ? Lists.newArrayList() : mapItemMediasList;
            mapItemMediasList.add(itemMediasDto);
            itemMediasMap.put(itemMediasDto.getItemId(), mapItemMediasList);
        }
        return itemMediasMap;
    }

    public void setItemSkuByItemIds(List<ItemDgRespDto> itemDtoList, List<Long> itemIds) {
        Map<Long, List<ItemSkuDgRespDto>> skuMap = this.getItemSkuDtoMap(this.itemSkuDgService.queryDetailsByItemIds(itemIds));
        for (ItemDgRespDto itemDto : itemDtoList) {
            itemDto.setItemSkuList(skuMap.get(itemDto.getId()));
        }
    }

    public Map<Long, List<ItemSkuDgRespDto>> getItemSkuDtoMap(List<ItemSkuDgRespDto> skuDtoList) {
        return skuDtoList.stream().collect(Collectors.groupingBy(ItemSkuDgRespDto::getItemId));
    }

    @Override
    public List<ItemDgEo> queryItemByIds(List<Long> ids) {
        return this.itemDgDomain.selectByIds(ids);
    }

    @Override
    public ItemSkuListDgRespDto queryItemBySkuId(List<Long> skuIds) {
        ItemSkuListDgRespDto dto = new ItemSkuListDgRespDto();
        List<ItemSkuDgEo> itemSkuDgEoList = this.getItemSkuRepDtoList(skuIds, dto);
        this.getItemRespDtoList(dto, itemSkuDgEoList);
        return dto;
    }

    @Override
    public List<ItemDgRespDto> queryItemStatus(List<Long> itemIdList) {
        List itemDgEos = this.itemDgDomain.selectByIds(itemIdList);
        ArrayList<ItemDgEo> itemsInvalidEos = new ArrayList<ItemDgEo>();
        for (ItemDgEo eo : itemDgEos) {
            Integer intStatus = eo.getStatus();
            if (intStatus != 2) continue;
            itemsInvalidEos.add(eo);
        }
        ArrayList<ItemDgRespDto> itemDgRespDtoList = new ArrayList<ItemDgRespDto>();
        DtoHelper.eoList2DtoList(itemsInvalidEos, itemDgRespDtoList, ItemDgRespDto.class);
        return itemDgRespDtoList;
    }

    @Override
    public List<DirItemRelativeQueryDgRespDto> queryItemDirRelative(DirItemRelativeDgReqDto dirItemReqDto) {
        List list;
        DirItemRelationDgEo dirItemRelationDgEo = DirItemRelationDgEo.newInstance();
        BeanUtils.copyProperties((Object)dirItemReqDto, (Object)dirItemRelationDgEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirItemReqDto.getDirIds())) {
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"dirId", (Object)dirItemReqDto.getDirIds()));
            dirItemRelationDgEo.setSqlFilters((List)sqlFilters);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(list = this.dirItemRelationDgDomain.selectList((BaseEo)dirItemRelationDgEo)))) {
            List dirIdList = list.stream().map(DirItemRelationDgEo::getDirId).distinct().collect(Collectors.toList());
            Map<Object, Object> dirMap = Maps.newHashMap();
            List dirDgEoList = this.dirDgDomain.selectByIds(dirIdList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirDgEoList)) {
                dirMap = dirDgEoList.stream().collect(Collectors.toMap(BaseEo::getId, DirDgEo::getName));
            }
            HashMap finalDirMap = dirMap;
            return list.stream().map(dirItemRelation -> {
                DirItemRelativeQueryDgRespDto itemDirQueryRespDto = new DirItemRelativeQueryDgRespDto();
                BeanUtils.copyProperties((Object)dirItemRelation, (Object)itemDirQueryRespDto);
                if (finalDirMap.get(dirItemRelation.getDirId()) != null) {
                    itemDirQueryRespDto.setDirName((String)finalDirMap.get(dirItemRelation.getDirId()));
                }
                return itemDirQueryRespDto;
            }).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<DirItemRelativeQueryDgRespDto> queryItemDirRelativeBatch(DirItemRelativeDgReqDto dirItemReqDto) {
        List list;
        DirItemRelationDgEo dirItemRelationDgEo = DirItemRelationDgEo.newInstance();
        BeanUtils.copyProperties((Object)dirItemReqDto, (Object)dirItemRelationDgEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirItemReqDto.getDirIds())) {
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"dirId", (Object)dirItemReqDto.getDirIds()));
            dirItemRelationDgEo.setSqlFilters((List)sqlFilters);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(list = this.dirItemRelationDgDomain.selectList((BaseEo)dirItemRelationDgEo)))) {
            List dirIdList = list.stream().map(DirItemRelationDgEo::getDirId).distinct().collect(Collectors.toList());
            Map<Object, Object> dirMap = Maps.newHashMap();
            List dirDgEoList = this.dirDgDomain.selectByIds(dirIdList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirDgEoList)) {
                dirMap = dirDgEoList.stream().collect(Collectors.toMap(BaseEo::getId, DirDgEo::getName));
            }
            HashMap finalDirMap = dirMap;
            return list.stream().map(dirItemRelation -> {
                DirItemRelativeQueryDgRespDto itemDirQueryRespDto = new DirItemRelativeQueryDgRespDto();
                BeanUtils.copyProperties((Object)dirItemRelation, (Object)itemDirQueryRespDto);
                if (finalDirMap.get(dirItemRelation.getDirId()) != null) {
                    itemDirQueryRespDto.setDirName((String)finalDirMap.get(dirItemRelation.getDirId()));
                }
                return itemDirQueryRespDto;
            }).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<ItemDirQueryDgRespDto> queryItemDir(ItemDirQueryDgReqDto itemDirQueryDgReqDto) {
        ArrayList<Long> dirIdList;
        if (itemDirQueryDgReqDto == null || itemDirQueryDgReqDto.getInstanceId() == null || itemDirQueryDgReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemDirQueryDgRespDto> list = new ArrayList<ItemDirQueryDgRespDto>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemDirQueryDgReqDto.getItemIdList())) {
            return list;
        }
        for (Long itemId : itemDirQueryDgReqDto.getItemIdList()) {
            ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemId);
            if (itemDgEo == null || !itemDirQueryDgReqDto.getInstanceId().equals(itemDgEo.getInstanceId()) || !itemDirQueryDgReqDto.getTenantId().equals(itemDgEo.getTenantId())) continue;
            ItemDirQueryDgRespDto itemDirQueryDgRespDto = new ItemDirQueryDgRespDto();
            itemDirQueryDgRespDto.setItemId(itemId);
            dirIdList = this.queryParentDataList(itemDgEo.getDirId());
            itemDirQueryDgRespDto.setDirList(dirIdList);
            list.add(itemDirQueryDgRespDto);
        }
        for (ItemDirQueryDgRespDto itemDirQueryDgRespDto : list) {
            DirItemRelationDgEo dirItemRelationDgEo = new DirItemRelationDgEo();
            dirItemRelationDgEo.setItemId(itemDirQueryDgRespDto.getItemId());
            dirItemRelationDgEo.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
            dirItemRelationDgEo.setInstanceId(itemDirQueryDgReqDto.getInstanceId());
            dirItemRelationDgEo.setTenantId(itemDirQueryDgReqDto.getTenantId());
            List dirItemRelationDgEoList = this.dirItemRelationDgDomain.selectList((BaseEo)dirItemRelationDgEo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dirItemRelationDgEoList)) continue;
            dirIdList = itemDirQueryDgRespDto.getDirList();
            if (dirIdList == null) {
                dirIdList = new ArrayList<Long>();
            }
            for (DirItemRelationDgEo relationEo : dirItemRelationDgEoList) {
                dirIdList.addAll(this.queryParentDataList(relationEo.getDirId()));
            }
            LinkedHashSet repeat = new LinkedHashSet(dirIdList);
            dirIdList.clear();
            dirIdList.addAll(repeat);
            itemDirQueryDgRespDto.setDirList(dirIdList);
        }
        return list;
    }

    @Override
    public ItemSearchDgRespDto queryItemByDirIdDepth(ItemSearchQueryDgReqDto itemSearchReqDto, Integer pageNum, Integer pageSize) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSearchReqDto.getDirIds())) {
            List<Long> dirIdList = this.dirDgService.getLinkAndChildDirIdList(itemSearchReqDto.getDirIds(), itemSearchReqDto.getInstanceId(), itemSearchReqDto.getTenantId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(dirIdList)) {
                return null;
            }
            itemSearchReqDto.setDirIds(dirIdList);
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchReqDto.getKeyword())) {
            List itemIds = this.itemDgDomain.queryItemIdByKeywordAndItemIds(itemSearchReqDto.getKeyword(), itemSearchReqDto.getItemIds());
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemIds)) {
                return new ItemSearchDgRespDto();
            }
            itemSearchReqDto.setItemIds(itemIds);
            itemSearchReqDto.setKeyword(null);
        }
        return this.queryByKeywordNew(itemSearchReqDto, pageNum, pageSize);
    }

    @Override
    public PageInfo<ShelfTaskQueryDgRespDto> queryShelfTask(ShelfTaskQueryDgReqDto shelfTaskQueryDgReqDto, Integer pageNum, Integer pageSize) {
        List<SqlFilter> sqlFilterList;
        if (shelfTaskQueryDgReqDto == null || shelfTaskQueryDgReqDto.getInstanceId() == null || shelfTaskQueryDgReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ShelfTaskDgEo shelfTaskDgEo = new ShelfTaskDgEo();
        DtoHelper.dto2Eo((BaseVo)shelfTaskQueryDgReqDto, (BaseEo)shelfTaskDgEo);
        if (StringUtils.isNotBlank((CharSequence)shelfTaskQueryDgReqDto.getStartTime())) {
            sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.ge((String)"shelf_time", (Object)shelfTaskQueryDgReqDto.getStartTime()));
            shelfTaskDgEo.setSqlFilters(sqlFilterList);
        }
        if (StringUtils.isNotBlank((CharSequence)shelfTaskQueryDgReqDto.getEndTime())) {
            sqlFilterList = shelfTaskDgEo.getSqlFilters();
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList();
            }
            sqlFilterList.add(SqlFilter.le((String)"shelf_time", (Object)shelfTaskQueryDgReqDto.getEndTime()));
            shelfTaskDgEo.setSqlFilters(sqlFilterList);
        }
        PageInfo itemTimingRespDtoPageInfo = new PageInfo();
        PageInfo shelfTaskEoPageInfo = this.shelfTaskDgDomain.selectPage((BaseEo)shelfTaskDgEo, pageNum, pageSize);
        List shelfTaskDgEoList = shelfTaskEoPageInfo.getList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shelfTaskDgEoList)) {
            itemTimingRespDtoPageInfo.setPageNum(pageNum.intValue());
            itemTimingRespDtoPageInfo.setPageSize(pageSize.intValue());
            return itemTimingRespDtoPageInfo;
        }
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        ArrayList<ShelfTaskQueryDgRespDto> itemTimingRespDtoList = new ArrayList<ShelfTaskQueryDgRespDto>();
        for (ShelfTaskDgEo taskEo : shelfTaskDgEoList) {
            itemIdList.add(taskEo.getItemId());
            ShelfTaskQueryDgRespDto itemTimingRespDto = new ShelfTaskQueryDgRespDto();
            DtoHelper.eo2Dto((BaseEo)taskEo, (BaseVo)itemTimingRespDto);
            itemTimingRespDtoList.add(itemTimingRespDto);
        }
        ItemDgEo itemDgEo = new ItemDgEo();
        ArrayList<SqlFilter> sqlFilterList2 = new ArrayList<SqlFilter>();
        sqlFilterList2.add(SqlFilter.in((String)"id", (Object)StringUtils.join(itemIdList, (String)",")));
        itemDgEo.setSqlFilters(sqlFilterList2);
        List itemDgEoList = this.itemDgDomain.selectList((BaseEo)itemDgEo);
        block1: for (ItemDgEo eo : itemDgEoList) {
            for (ShelfTaskQueryDgRespDto dto : itemTimingRespDtoList) {
                if (!eo.getId().equals(dto.getItemId())) continue;
                dto.setItemName(eo.getName());
                continue block1;
            }
        }
        CubeBeanUtils.copyProperties((Object)itemTimingRespDtoPageInfo, (Object)shelfTaskEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        itemTimingRespDtoPageInfo.setList(itemTimingRespDtoList);
        return itemTimingRespDtoPageInfo;
    }

    @Override
    public ItemAllowOrderQueryDgRespDto checkItemAllowOrder(List<ItemAllowOrderQueryDgReqDto> itemAllowOrderReqDtoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemAllowOrderReqDtoList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        itemAllowOrderReqDtoList.stream().forEach(dto -> {
            if (dto.getInstanceId() == null || dto.getTenantId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
        });
        ArrayList<ItemAllowOrderDetailQueryDgRespDto> itemAllowOrderDetailRespDtoList = new ArrayList<ItemAllowOrderDetailQueryDgRespDto>();
        for (ItemAllowOrderQueryDgReqDto itemAllowOrderReqDto : itemAllowOrderReqDtoList) {
            itemAllowOrderDetailRespDtoList.addAll(this.checkItemAllowOrder(itemAllowOrderReqDto));
        }
        ItemAllowOrderQueryDgRespDto itemAllowOrderRespDto = new ItemAllowOrderQueryDgRespDto();
        itemAllowOrderRespDto.setAllAllowOrder(Boolean.valueOf(true));
        for (ItemAllowOrderDetailQueryDgRespDto itemAllowOrderDetailRespDto : itemAllowOrderDetailRespDtoList) {
            if (itemAllowOrderDetailRespDto.getAllowOrder().booleanValue()) continue;
            itemAllowOrderRespDto.setAllAllowOrder(Boolean.valueOf(false));
            break;
        }
        return itemAllowOrderRespDto;
    }

    private List<ItemAllowOrderDetailQueryDgRespDto> checkItemAllowOrder(ItemAllowOrderQueryDgReqDto itemAllowOrderReqDto) {
        ArrayList<ItemAllowOrderDetailQueryDgRespDto> itemAllowOrderDetailRespDtoList = new ArrayList<ItemAllowOrderDetailQueryDgRespDto>();
        DirItemRelationDgEo dirItemRelationDgEo = new DirItemRelationDgEo();
        DtoHelper.dto2Eo((BaseVo)itemAllowOrderReqDto, (BaseEo)dirItemRelationDgEo);
        List dirItemRelationDgEoList = this.dirItemRelationDgDomain.selectList((BaseEo)dirItemRelationDgEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirItemRelationDgEoList)) {
            Date now = new Date();
            for (DirItemRelationDgEo relationEo : dirItemRelationDgEoList) {
                List allowOrderTimeDtoList;
                ItemAllowOrderDetailQueryDgRespDto itemAllowOrderDetailRespDto = new ItemAllowOrderDetailQueryDgRespDto();
                DtoHelper.eo2Dto((BaseEo)relationEo, (BaseVo)itemAllowOrderDetailRespDto);
                itemAllowOrderDetailRespDto.setAllowOrder(Boolean.valueOf(true));
                if (StringUtils.isNotBlank((CharSequence)relationEo.getAllowOrderTime()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(allowOrderTimeDtoList = JSON.parseArray((String)relationEo.getAllowOrderTime(), AllowOrderTimeDgRespDto.class)))) {
                    itemAllowOrderDetailRespDto.setAllowOrderTimeDgRespDtoList(allowOrderTimeDtoList);
                    Boolean allowOrder = false;
                    for (AllowOrderTimeDgRespDto allowOrderTimeDto : allowOrderTimeDtoList) {
                        if (!now.after(allowOrderTimeDto.getStartTime()) || !now.before(allowOrderTimeDto.getEndTime())) continue;
                        allowOrder = true;
                        break;
                    }
                    itemAllowOrderDetailRespDto.setAllowOrder(allowOrder);
                }
                itemAllowOrderDetailRespDtoList.add(itemAllowOrderDetailRespDto);
            }
        }
        return itemAllowOrderDetailRespDtoList;
    }

    private List<Long> queryParentDataList(Long dirId) {
        ArrayList<Long> dirIdList;
        block2: {
            dirIdList = new ArrayList<Long>();
            if (dirId == null) {
                return dirIdList;
            }
            DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dirId);
            if (dirDgEo == null) break block2;
            do {
                dirIdList.add(dirDgEo.getId());
            } while (!dirDgEo.getParentId().equals(0L) && (dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dirDgEo.getParentId())) != null);
        }
        return dirIdList;
    }

    private List<ItemSkuDgEo> getItemSkuRepDtoList(List<Long> skuIds, ItemSkuListDgRespDto dto) {
        ArrayList skuRepDtos = Lists.newArrayList();
        List<ItemSkuDgEo> itemSkuDgEoList = this.itemSkuDgService.queryItemSkuByIds(skuIds);
        DtoHelper.eoList2DtoList(itemSkuDgEoList, (Collection)skuRepDtos, ItemSkuDgRespDto.class);
        dto.setItemSkuDgRespDtos((List)skuRepDtos);
        return itemSkuDgEoList;
    }

    private void getItemRespDtoList(ItemSkuListDgRespDto dto, List<ItemSkuDgEo> itemSkuDgEoList) {
        List<Object> itemDgEos = null;
        ArrayList itemIds = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuDgEoList)) {
            for (ItemSkuDgEo skuEo : itemSkuDgEoList) {
                itemIds.add(skuEo.getItemId());
            }
        }
        itemDgEos = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemIds) ? this.queryItemByIds(itemIds) : Lists.newArrayList();
        ArrayList itemDgRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemDgEos, (Collection)itemDgRespDtos, ItemDgRespDto.class);
        dto.setItemDgRespDtos((List)itemDgRespDtos);
    }

    private void addItemAssociateAttr(Integer type, ItemChangeApplyDgDto publishItemDto, Long itemId, String itemCode, Integer itemAttribute) {
        List skus = publishItemDto.getSkus();
        HashMap<Long, Long> skuIds = new HashMap<Long, Long>();
        HashMap<String, ItemSkuDgEo> skuDgEoMap = new HashMap<String, ItemSkuDgEo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)skus)) {
            boolean isMulti = skus.size() > 1;
            for (ItemBundleDgReqDto itemBundleDto : skus) {
                ItemSkuDgEo itemSkuDgEo = ItemSkuDgEo.newInstance();
                if (Objects.nonNull(itemBundleDto.getId())) {
                    this.updateItemSku(itemId, itemBundleDto, itemSkuDgEo);
                    this.removeItemAssociateAttrBySkuId(itemBundleDto.getId(), type);
                } else {
                    this.addItemSku(itemId, itemBundleDto, itemSkuDgEo, isMulti, itemAttribute);
                }
                skuDgEoMap.put(itemSkuDgEo.getCode(), itemSkuDgEo);
                skuIds.put(itemSkuDgEo.getId(), itemBundleDto.getShelfAmount());
                this.addItemInventoryRel(itemSkuDgEo, itemBundleDto.getInventoryOrganizationList());
                this.addItemBundle(itemId, type, itemBundleDto, itemSkuDgEo);
                List medias = itemBundleDto.getMedias();
                if (CollectionUtil.isNotEmpty((Collection)medias)) {
                    for (ItemMediasDgReqDto media : medias) {
                        Integer fileType = Objects.equals(1, media.getFileType()) ? media.getFileType() : 0;
                        media.setFileType(fileType);
                        media.setItemType(ItemMediaItemTypeEnum.SKU.getType());
                        media.setBizType(ItemMediaBizTypeEnum.MAIN_IMAGE.getType());
                    }
                }
                this.addItemMedias(itemId, medias, itemSkuDgEo);
                this.addUnitConversions(itemBundleDto.getItemUnitConversions(), itemSkuDgEo, itemId, itemCode);
            }
        }
    }

    private void addItemInventoryRel(ItemSkuDgEo itemSkuDgEo, List<RItemOrganizationDgDto> inventoryOrganizationList) {
        this.rItemOrganizationDgDomain.removeBySkuIds(Collections.singletonList(itemSkuDgEo.getId()));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(inventoryOrganizationList)) {
            return;
        }
        ArrayList<RItemOrganizationDgEo> list = new ArrayList<RItemOrganizationDgEo>();
        for (RItemOrganizationDgDto organizationDgDto : inventoryOrganizationList) {
            RItemOrganizationDgEo organizationDgEo = new RItemOrganizationDgEo();
            organizationDgEo.setOrganizationId(organizationDgDto.getOrganizationId());
            organizationDgEo.setOrganizationCode(organizationDgDto.getOrganizationCode());
            organizationDgEo.setOrganizationName(organizationDgDto.getOrganizationName());
            organizationDgEo.setOrganizationType(ItemConstants.ITEM_ORGANIZATION_TYPE_INVENTORY);
            organizationDgEo.setSkuId(itemSkuDgEo.getId());
            organizationDgEo.setSkuCode(itemSkuDgEo.getCode());
            list.add(organizationDgEo);
        }
        this.rItemOrganizationDgDomain.insertBatch(list);
    }

    @Override
    public void addUnitConversions(List<ItemUnitConversionDgDto> itemUnitConversions, ItemSkuDgEo itemSkuDgEo, Long itemId, String itemCode) {
        if (CollectionUtil.isEmpty(itemUnitConversions) && Objects.isNull(itemSkuDgEo.getSaleUnit()) && Objects.isNull(itemSkuDgEo.getPriceUnit()) && Objects.isNull(itemSkuDgEo.getUnit())) {
            return;
        }
        ArrayList<ItemUnitConversionDgDto> unitConversions = new ArrayList<ItemUnitConversionDgDto>();
        HashSet<String> defaultOrders = new HashSet<String>();
        HashSet<String> unitSet = new HashSet<String>();
        logger.info("\u65b0\u589e\u8f85\u8ba1\u91cf\u5355\u4f4d=================>{}", (Object)JSON.toJSONString(itemUnitConversions));
        if (CollectionUtil.isNotEmpty(itemUnitConversions)) {
            for (ItemUnitConversionDgDto itemUnitConversion : itemUnitConversions) {
                AssertUtils.isFalse((boolean)unitSet.contains(itemUnitConversion.getConversionUnit()), (String)(itemUnitConversion.getConversionUnit() + "\u8f85\u8ba1\u91cf\u5355\u4f4d\u4e0d\u53ef\u91cd\u590d!"));
                if (StringUtils.isNotBlank((CharSequence)itemUnitConversion.getDefaultOrders())) {
                    String[] split = itemUnitConversion.getDefaultOrders().split(",");
                    for (int i = 0; i < split.length; ++i) {
                        AssertUtils.isFalse((boolean)defaultOrders.contains(split[i]), (String)(itemUnitConversion.getDefaultOrders() + "\u4e1a\u52a1\u5355\u9ed8\u8ba4\u7a7a\u95f4\u4e0d\u53ef\u91cd\u590d"));
                        defaultOrders.add(split[i]);
                    }
                }
                unitSet.add(itemUnitConversion.getConversionUnit());
                itemUnitConversion.setItemId(itemId);
                itemUnitConversion.setId(null);
                itemUnitConversion.setItemCode(itemCode);
                itemUnitConversion.setSkuId(itemSkuDgEo.getId());
                itemUnitConversion.setSkuCode(itemSkuDgEo.getCode());
                unitConversions.add(itemUnitConversion);
            }
        }
        if (Objects.nonNull(itemSkuDgEo.getSaleUnit()) && !unitSet.contains(itemSkuDgEo.getSaleUnit())) {
            unitConversions.add(this.fillItemUnitConversionDgDto(itemSkuDgEo, itemSkuDgEo.getSaleUnit(), itemCode, unitSet));
        }
        if (Objects.nonNull(itemSkuDgEo.getPriceUnit()) && !unitSet.contains(itemSkuDgEo.getPriceUnit())) {
            unitConversions.add(this.fillItemUnitConversionDgDto(itemSkuDgEo, itemSkuDgEo.getPriceUnit(), itemCode, unitSet));
        }
        if (Objects.nonNull(itemSkuDgEo.getUnit()) && !unitSet.contains(itemSkuDgEo.getUnit())) {
            unitConversions.add(this.fillItemUnitConversionDgDto(itemSkuDgEo, itemSkuDgEo.getUnit(), itemCode, unitSet));
        }
        this.itemUnitConversionDgService.insertItemUnitConversion(unitConversions);
    }

    private ItemUnitConversionDgDto fillItemUnitConversionDgDto(ItemSkuDgEo itemSkuDgEo, String unit, String itemCode, Set<String> unitSet) {
        ItemUnitConversionDgDto itemUnitConversionDgDto = new ItemUnitConversionDgDto();
        itemUnitConversionDgDto.setItemCode(itemCode);
        itemUnitConversionDgDto.setItemId(itemSkuDgEo.getItemId());
        itemUnitConversionDgDto.setSkuId(itemSkuDgEo.getId());
        itemUnitConversionDgDto.setSkuCode(itemSkuDgEo.getCode());
        itemUnitConversionDgDto.setBaseUnit(itemSkuDgEo.getUnit());
        itemUnitConversionDgDto.setBaseUnitNum(BigDecimal.ONE);
        itemUnitConversionDgDto.setConversionUnit(unit);
        itemUnitConversionDgDto.setConversionNum(BigDecimal.ONE);
        AtomicReference volume = new AtomicReference();
        Optional.ofNullable(itemSkuDgEo.getWidth()).ifPresent(width -> Optional.ofNullable(itemSkuDgEo.getHeight()).ifPresent(height -> Optional.ofNullable(itemSkuDgEo.getLength()).ifPresent(length -> volume.set(width.multiply((BigDecimal)height).multiply((BigDecimal)length)))));
        itemUnitConversionDgDto.setVolume(Objects.isNull(itemSkuDgEo.getVolume()) ? (Objects.nonNull(volume) ? (BigDecimal)volume.get() : null) : itemSkuDgEo.getVolume());
        itemUnitConversionDgDto.setVolumeUnit(itemSkuDgEo.getVolumeUnit());
        itemUnitConversionDgDto.setGrossWeight(itemSkuDgEo.getGrossWeight());
        itemUnitConversionDgDto.setNetWeight(itemSkuDgEo.getNetWeight());
        itemUnitConversionDgDto.setWeightUnit(itemSkuDgEo.getWeightUnit());
        itemUnitConversionDgDto.setLength(itemSkuDgEo.getLength());
        itemUnitConversionDgDto.setHeight(itemSkuDgEo.getHeight());
        itemUnitConversionDgDto.setWidth(itemSkuDgEo.getWidth());
        itemUnitConversionDgDto.setSizeUnit(itemSkuDgEo.getSizeUnit());
        itemUnitConversionDgDto.setId(null);
        unitSet.add(unit);
        return itemUnitConversionDgDto;
    }

    private void createUnitConversions(List<ItemUnitConversionDgGroupDto> unitConversionGroups, Map<String, ItemSkuDgEo> skuDgEoMap, Long itemId, String itemCode) {
        if (CollUtil.isEmpty(unitConversionGroups) || Objects.isNull(skuDgEoMap) || skuDgEoMap.isEmpty()) {
            return;
        }
        for (ItemUnitConversionDgGroupDto unitConversionGroup : unitConversionGroups) {
            List itemUnitConversionRelations = unitConversionGroup.getItemUnitConversionRelations();
            List itemUnitConversions = unitConversionGroup.getItemUnitConversions();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemUnitConversionRelations) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemUnitConversions)) continue;
            for (ItemUnitConversionDgDto itemUnitConversion : itemUnitConversions) {
                itemUnitConversion.setItemId(itemId);
                itemUnitConversion.setItemCode(itemCode);
            }
            for (int i = itemUnitConversionRelations.size() - 1; i >= 0; --i) {
                ItemUnitConversionRelationDgDto itemUnitConversionRelation = (ItemUnitConversionRelationDgDto)itemUnitConversionRelations.get(i);
                ItemSkuDgEo itemSkuDgEo = skuDgEoMap.get(itemUnitConversionRelation.getSkuCode());
                if (Objects.nonNull(itemSkuDgEo)) {
                    itemUnitConversionRelation.setItemCode(itemCode);
                    itemUnitConversionRelation.setItemId(itemId);
                    itemUnitConversionRelation.setSkuId(itemSkuDgEo.getId());
                    itemUnitConversionRelation.setSkuName(itemSkuDgEo.getName());
                    itemUnitConversionRelation.setSkuCode(itemSkuDgEo.getCode());
                } else {
                    itemUnitConversionRelations.remove(i);
                }
                skuDgEoMap.remove(itemUnitConversionRelation.getSkuCode());
            }
        }
        if (skuDgEoMap.size() > 0) {
            ArrayList<String> skuCodes = new ArrayList<String>(skuDgEoMap.keySet());
            ArrayList<ItemUnitConversionRelationDgDto> relations = new ArrayList<ItemUnitConversionRelationDgDto>();
            for (String skuCode : skuCodes) {
                ItemUnitConversionRelationDgDto relation = new ItemUnitConversionRelationDgDto();
                ItemSkuDgEo itemSkuDgEo = skuDgEoMap.get(skuCode);
                if (!Objects.nonNull(itemSkuDgEo)) continue;
                relation.setItemCode(itemCode);
                relation.setItemId(itemId);
                relation.setSkuId(itemSkuDgEo.getId());
                relation.setSkuName(itemSkuDgEo.getName());
                relation.setSkuCode(itemSkuDgEo.getCode());
                relations.add(relation);
            }
            List conversionRelations = unitConversionGroups.get(0).getItemUnitConversionRelations();
            conversionRelations = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)conversionRelations) ? new ArrayList() : conversionRelations;
            conversionRelations.addAll(relations);
        }
        this.itemUnitConversionDgService.addItemUnitConversion(unitConversionGroups);
    }

    private void saveItemProp(Long itemId, ItemSkuDgEo itemSkuDgEo, List<ItemPropGroupDgDto> itemPropGroupDgDtoList) {
        this.itemPropRelationDgDomain.logicDeleteByItemId(itemId, itemSkuDgEo.getId());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemPropGroupDgDtoList)) {
            ArrayList itemPropRelationDgEoList = Lists.newArrayList();
            itemPropGroupDgDtoList.forEach(itemPropGroupDgDto -> {
                List itemPropNameDgDtoList = itemPropGroupDgDto.getPropNameDtoList();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemPropNameDgDtoList)) {
                    for (ItemPropNameDgDto itemPropNameDgDto : itemPropNameDgDtoList) {
                        ItemPropRelationDgEo itemPropRelationDgEo = ItemPropRelationDgEo.newInstance();
                        itemPropRelationDgEo.setSkuId(itemSkuDgEo.getId());
                        itemPropRelationDgEo.setItemId(itemId);
                        itemPropRelationDgEo.setPropGroupId(itemPropGroupDgDto.getId());
                        itemPropRelationDgEo.setPropNameId(itemPropNameDgDto.getId());
                        List choose = itemPropNameDgDto.getChoose();
                        List propValueList = itemPropNameDgDto.getPropValueList();
                        if (PropInputTypeDgEnum.SELECT.getCode() == itemPropNameDgDto.getInputType().intValue() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)choose) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)propValueList) && propValueList.size() >= choose.size()) {
                            String choosePropValue = choose.stream().map(propValueList::get).collect(Collectors.joining(","));
                            itemPropRelationDgEo.setPropValue(choosePropValue);
                        }
                        if (PropInputTypeDgEnum.INPUT.getCode() == itemPropNameDgDto.getInputType().intValue()) {
                            itemPropRelationDgEo.setPropValue(itemPropNameDgDto.getInputValue());
                        }
                        if (!StringUtils.isNotBlank((CharSequence)itemPropRelationDgEo.getPropValue())) continue;
                        itemPropRelationDgEoList.add(itemPropRelationDgEo);
                    }
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemPropRelationDgEoList)) {
                this.itemPropRelationDgDomain.insertBatch((List)itemPropRelationDgEoList);
            }
        }
    }

    private void addItemSku(Long itemId, ItemBundleDgReqDto itemBundleDto, ItemSkuDgEo itemSkuDgEo, boolean isMulti, Integer itemAttribute) {
        DtoHelper.dto2Eo((BaseVo)itemBundleDto, (BaseEo)itemSkuDgEo);
        itemSkuDgEo.setItemId(itemId);
        if (StringUtils.isEmpty((CharSequence)itemSkuDgEo.getCode()) && !isMulti) {
            ItemDgEo itemDgEo = ItemDgEo.newInstance();
            itemDgEo.setId(itemId);
            ItemDgEo item = (ItemDgEo)this.itemDgDomain.selectOne((BaseEo)itemDgEo);
            if (item != null) {
                itemSkuDgEo.setCode(item.getCode());
                String skuName = StringUtils.isEmpty((CharSequence)itemSkuDgEo.getName()) ? item.getName() : itemSkuDgEo.getName();
                itemSkuDgEo.setName(skuName);
                itemSkuDgEo.setOrganizationId(item.getOrganizationId());
                itemSkuDgEo.setOrganizationName(item.getOrganizationName());
            }
        }
        logger.info("\u6253\u5370\u63d2\u5165it_item_sku\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)itemSkuDgEo));
        itemSkuDgEo.setVersion(Long.valueOf(1L));
        itemSkuDgEo.setMarketStatus(SkuItemMarketStatusEnum.MARKET_STATUS_AWAIT.getStatus());
        if (Objects.nonNull(itemAttribute) && ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PROMOTION.getType().equals(itemAttribute)) {
            itemSkuDgEo.setPurchaseChannel("common");
        }
        Long skuId = this.itemSkuDgService.saveSku(itemSkuDgEo);
        itemBundleDto.setId(skuId);
    }

    private void updateItemSku(Long itemId, ItemBundleDgReqDto itemBundleDto, ItemSkuDgEo itemSkuDgEo) {
        ItemSkuDgEo existItemSkuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectByPrimaryKey(itemBundleDto.getId());
        AssertUtils.notNull((Object)existItemSkuDgEo, (String)(itemBundleDto.getId() + "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728"));
        DtoHelper.dto2Eo((BaseVo)itemBundleDto, (BaseEo)itemSkuDgEo);
        itemSkuDgEo.setOriginalCode(StrUtil.isNotEmpty((CharSequence)itemBundleDto.getOriginalCode()) ? itemBundleDto.getOriginalCode() : "");
        itemSkuDgEo.setOriginalName(StrUtil.isNotEmpty((CharSequence)itemBundleDto.getOriginalName()) ? itemBundleDto.getOriginalName() : "");
        itemSkuDgEo.setItemClassCode(StrUtil.isNotEmpty((CharSequence)itemBundleDto.getItemClassCode()) ? itemBundleDto.getItemClassCode() : "");
        itemSkuDgEo.setItemClassName(StrUtil.isNotEmpty((CharSequence)itemBundleDto.getItemClassName()) ? itemBundleDto.getItemClassName() : "");
        itemSkuDgEo.setItemId(itemId);
        itemSkuDgEo.setId(existItemSkuDgEo.getId());
        itemSkuDgEo.setCode(existItemSkuDgEo.getCode());
        itemSkuDgEo.setVersion(Long.valueOf(Objects.isNull(existItemSkuDgEo.getVersion()) ? 1L : existItemSkuDgEo.getVersion() + 1L));
        this.itemSkuDgService.modifySku(itemSkuDgEo);
        itemBundleDto.setId(itemSkuDgEo.getId());
        BeanUtil.copyProperties((Object)itemSkuDgEo, (Object)existItemSkuDgEo, (String[])new String[0]);
    }

    private void addItemPrice(ItemBundleDgReqDto itemBundleDto, ItemSkuDgEo itemSkuDgEo) {
        List itemPriceDtoList = itemBundleDto.getPrices();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemPriceDtoList)) {
            ArrayList itemPriceDgEos = Lists.newArrayList();
            for (ItemPriceDgReqDto dto : itemPriceDtoList) {
                ItemPriceDgEo itemPriceDgEo = ItemPriceDgEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)itemPriceDgEo);
                itemPriceDgEo.setId(null);
                itemPriceDgEo.setSkuId(itemSkuDgEo.getId());
                itemPriceDgEo.setItemId(itemSkuDgEo.getItemId());
                itemPriceDgEos.add(itemPriceDgEo);
            }
            this.itemPriceDgService.addBatchItemPrice(itemPriceDgEos);
        }
    }

    private void addItemBundle(Long itemId, Integer type, ItemBundleDgReqDto itemBundleDto, ItemSkuDgEo itemSkuDgEo) {
        if (ItemDgType.BUNDLE.getIndex().equals(type) || ItemDgType.MULTIPLE.getIndex().equals(type)) {
            List bundleItemDtos = itemBundleDto.getBundleItemDtos();
            AssertUtils.notEmpty((Collection)bundleItemDtos, (String)"\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)bundleItemDtos)) {
                ArrayList bundleItemEos = Lists.newArrayList();
                ArrayList<Long> subSkuIds = new ArrayList<Long>();
                for (BundleItemDgReqDto bundleItemDto : bundleItemDtos) {
                    AssertUtils.notEmpty((Object)bundleItemDto.getSubSkuId(), (String)"\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u4fe1\u606fid\u4e0d\u53ef\u4e3a\u7a7a");
                    subSkuIds.add(bundleItemDto.getSubSkuId());
                }
                ItemQueryDgReqDto itemDgReqDto = new ItemQueryDgReqDto();
                itemDgReqDto.setSkuIds(subSkuIds);
                List<DgItemSkuDetailRespDto> skuDetailRespDtos = this.itemSkuDgService.querySkuList(itemDgReqDto);
                AssertUtils.notEmpty(skuDetailRespDtos, (String)"\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
                Map skuMap = skuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getId, Function.identity(), (k1, k2) -> k2));
                HashSet<Long> skuIds = new HashSet<Long>();
                HashSet<Integer> levels = new HashSet<Integer>();
                for (BundleItemDgReqDto bundleItemDto : bundleItemDtos) {
                    AssertUtils.isFalse((boolean)skuIds.contains(bundleItemDto.getSubSkuId()), (String)"\u5b50\u5546\u54c1sku\u4e0d\u53ef\u91cd\u590d!");
                    if (ItemDgType.MULTIPLE.getIndex().equals(type)) {
                        AssertUtils.notNull((Object)bundleItemDto.getLevel(), (String)"\u9ed8\u8ba4\u51fa\u5e93\u4f18\u5148\u7ea7\u4e0d\u53ef\u4e3a\u7a7a!");
                        AssertUtils.isFalse((boolean)levels.contains(bundleItemDto.getLevel()), (String)"\u9ed8\u8ba4\u51fa\u5e93\u4f18\u5148\u7ea7\u4e0d\u53ef\u91cd\u590d!");
                        levels.add(bundleItemDto.getLevel());
                    }
                    DgItemSkuDetailRespDto detailRespDto = (DgItemSkuDetailRespDto)skuMap.get(bundleItemDto.getSubSkuId());
                    AssertUtils.notNull((Object)detailRespDto, (String)(bundleItemDto.getSubSkuId() + "\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728"));
                    ItemBundleRelationDgEo bundleItemEo = ItemBundleRelationDgEo.newInstance((Map)bundleItemDto.getExtFields());
                    DtoHelper.dto2Eo((BaseVo)bundleItemDto, (BaseEo)bundleItemEo);
                    bundleItemEo.setId(null);
                    bundleItemEo.setItemId(itemId);
                    bundleItemEo.setSkuId(itemSkuDgEo.getId());
                    bundleItemEo.setSubItemId(detailRespDto.getItemId());
                    bundleItemEo.setSubType(detailRespDto.getSubType());
                    bundleItemEo.setSubSkuId(detailRespDto.getId());
                    skuIds.add(bundleItemDto.getSubSkuId());
                    bundleItemEos.add(bundleItemEo);
                }
                this.bundleItemDgService.addBundleItemBatch(bundleItemEos);
            }
        }
    }

    private void addItemMedias(Long itemId, List<ItemMediasDgReqDto> medias, ItemSkuDgEo itemSkuDgEo) {
        ArrayList mediasEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(medias)) {
            for (ItemMediasDgReqDto itemMediasDto : medias) {
                AssertUtils.notNull((Object)itemMediasDto.getPath1(), (String)"\u5546\u54c1sku\u56fe\u7247url\u4e0d\u53ef\u4e3a\u7a7a!");
                ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance((Map)itemMediasDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)itemMediasDto, (BaseEo)itemMediasDgEo);
                itemMediasDgEo.setId(null);
                itemMediasDgEo.setItemId(itemId);
                itemMediasDgEo.setSkuId(itemSkuDgEo.getId());
                if (null != itemSkuDgEo && null != itemSkuDgEo.getId()) {
                    itemMediasDgEo.setSkuId(itemSkuDgEo.getId());
                }
                mediasEos.add(itemMediasDgEo);
            }
        }
        this.itemMediasDgService.addBatchItemMedias(mediasEos);
    }

    private void addItemspuMedias(Long itemId, List<ItemMediasDgReqDto> spuMedias) {
        ArrayList mediasEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(spuMedias)) {
            for (ItemMediasDgReqDto itemMediasDto : spuMedias) {
                AssertUtils.notNull((Object)itemMediasDto.getPath1(), (String)"\u5546\u54c1\u4e3b\u89c6\u9891url\u4e0d\u53ef\u4e3a\u7a7a!");
                ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance((Map)itemMediasDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)itemMediasDto, (BaseEo)itemMediasDgEo);
                itemMediasDgEo.setId(null);
                itemMediasDgEo.setItemId(itemId);
                itemMediasDgEo.setSkuId(null);
                itemMediasDgEo.setItemType(ItemMediaItemTypeEnum.SPU.getType());
                itemMediasDgEo.setFileType(Integer.valueOf(1));
                itemMediasDgEo.setBizType(ItemMediaBizTypeEnum.MAIN_VIDEO.getType());
                mediasEos.add(itemMediasDgEo);
            }
            this.itemMediasDgService.addBatchItemMedias(mediasEos);
        }
    }

    private void addItemImage(Long itemId, List<ItemMediasDgReqDto> image) {
        ArrayList mediasEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(image)) {
            for (ItemMediasDgReqDto itemMediasDto : image) {
                AssertUtils.notNull((Object)itemMediasDto.getPath1(), (String)"SPU\u4e3b\u56feurl\u4e0d\u53ef\u4e3a\u7a7a!");
                ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance((Map)itemMediasDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)itemMediasDto, (BaseEo)itemMediasDgEo);
                itemMediasDgEo.setId(null);
                itemMediasDgEo.setItemId(itemId);
                itemMediasDgEo.setSkuId(null);
                itemMediasDgEo.setItemType(ItemMediaItemTypeEnum.SPU.getType());
                itemMediasDgEo.setFileType(Integer.valueOf(0));
                itemMediasDgEo.setBizType(ItemMediaBizTypeEnum.MAIN_IMAGE.getType());
                mediasEos.add(itemMediasDgEo);
            }
            this.itemMediasDgService.addBatchItemMedias(mediasEos);
        }
    }

    private void addItemDetailImage(Long itemId, List<ItemMediasDgReqDto> image) {
        ArrayList mediasEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(image)) {
            for (ItemMediasDgReqDto itemMediasDto : image) {
                AssertUtils.notNull((Object)itemMediasDto.getPath1(), (String)"SPU\u8be6\u60c5\u4e3b\u56feurl\u4e0d\u53ef\u4e3a\u7a7a!");
                ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance((Map)itemMediasDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)itemMediasDto, (BaseEo)itemMediasDgEo);
                itemMediasDgEo.setId(null);
                itemMediasDgEo.setItemId(itemId);
                itemMediasDgEo.setSkuId(null);
                itemMediasDgEo.setItemType(ItemMediaItemTypeEnum.SPU.getType());
                itemMediasDgEo.setFileType(Integer.valueOf(0));
                itemMediasDgEo.setBizType(ItemMediaBizTypeEnum.DETAIL_IMAGE.getType());
                mediasEos.add(itemMediasDgEo);
            }
            this.itemMediasDgService.addBatchItemMedias(mediasEos);
        }
    }

    private void addItemTags(Long itemId, List<Long> tags, ItemSkuDgEo itemSkuDgEo) {
        ArrayList itemTagEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tags)) {
            for (Long tag : tags) {
                ItemTagRelationDgEo itemTagEo = ItemTagRelationDgEo.newInstance();
                itemTagEo.setTagId(tag);
                itemTagEo.setItemId(itemId);
                if (null != itemSkuDgEo && null != itemSkuDgEo.getId()) {
                    itemTagEo.setSkuId(itemSkuDgEo.getId());
                }
                itemTagEos.add(itemTagEo);
            }
            this.itemTagDgService.relateToItem(itemTagEos);
        }
    }

    private void addItemPropRelation(List<ItemPropRelationDgReqDto> itemPropRelationDgReqDtos, Long sellerId, Long itemId, Long skuId) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemPropRelationDgReqDtos)) {
            ArrayList<ItemPropRelationDgReqDto> dtos = new ArrayList<ItemPropRelationDgReqDto>();
            List propGroupIds = itemPropRelationDgReqDtos.stream().map(ItemPropRelationDgReqDto::getPropGroupId).collect(Collectors.toList());
            List groupRespDtos = (List)this.propQueryApiProxy.batchQueryPropGroupById(propGroupIds).getData();
            AssertUtils.notEmpty((Collection)groupRespDtos, (String)ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), (Object[])new Object[]{ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg()});
            Map groupRespDtoMap = groupRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k2));
            for (ItemPropRelationDgReqDto dto : itemPropRelationDgReqDtos) {
                AssertUtils.notNull(groupRespDtoMap.get(dto.getPropGroupId()), (String)ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), (Object[])new Object[]{ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg()});
                dto.setItemId(itemId);
                dto.setSkuId(skuId);
                dto.setSellerId(sellerId);
                dtos.add(dto);
            }
            this.propDgService.addItemPropRelation(dtos);
        }
    }

    private void initItemEo(ItemChangeApplyDgDto changeApply, ItemDgEo itemDgEo) {
        Long version = Objects.nonNull(itemDgEo) && Objects.nonNull(itemDgEo.getVersion()) ? itemDgEo.getVersion() : 1L;
        DtoHelper.dto2Eo((BaseVo)changeApply, (BaseEo)itemDgEo);
        itemDgEo.setName(changeApply.getItemName());
        itemDgEo.setStatus(changeApply.getItemStatus());
        itemDgEo.setCode(changeApply.getItemCode());
        itemDgEo.setDisplayName(changeApply.getDisplayName());
        itemDgEo.setDetail(changeApply.getDetail());
        itemDgEo.setDirId(changeApply.getDirId());
        itemDgEo.setType(changeApply.getType());
        itemDgEo.setIsAfterSale(changeApply.getIsAfterSale());
        itemDgEo.setDirName(changeApply.getDirName());
        itemDgEo.setVitrual(changeApply.getVirtual());
        itemDgEo.setSellerId(changeApply.getSellerId());
        itemDgEo.setShopId(changeApply.getShopId());
        itemDgEo.setLongCode(changeApply.getLongCode());
        itemDgEo.setInstanceId(changeApply.getInstanceId());
        itemDgEo.setTenantId(changeApply.getTenantId());
        itemDgEo.setGiftBox(changeApply.getGiftBox());
        itemDgEo.setItemAttribute(changeApply.getItemAttribute());
        itemDgEo.setProductStage(changeApply.getProductStage());
        if (CollectionUtil.isNotEmpty((Collection)changeApply.getSkus()) && Objects.isNull(itemDgEo.getOrganizationId())) {
            itemDgEo.setOrganizationId(((ItemBundleDgReqDto)changeApply.getSkus().get(0)).getOrganizationId());
            itemDgEo.setOrganizationName(((ItemBundleDgReqDto)changeApply.getSkus().get(0)).getOrganizationName());
        } else {
            itemDgEo.setOrganizationId(changeApply.getOrganizationId());
            itemDgEo.setOrganizationName(changeApply.getOrganizationName());
        }
        itemDgEo.setStorage(changeApply.getStorage());
        itemDgEo.setVersion(Long.valueOf(version + 1L));
    }

    private void removeItemAssociateAttr(Long itemId, Integer type, ItemChangeApplyDgDto changeApply) {
        if (ItemDgType.BUNDLE.getIndex().equals(type) || ItemDgType.MULTIPLE.getIndex().equals(type)) {
            this.bundleItemDgService.removeByItemId(itemId);
        }
        this.itemAttributesDgService.removeByItemId(itemId);
        Set<Long> ids = changeApply.getSkus().stream().map(ItemSkuDgReqDto::getId).collect(Collectors.toSet());
        this.itemMediasDgService.removeItemMediasBySkuIds(ids);
        this.itemMediasDgService.removeMediasByItemAndType(Arrays.asList(itemId), ItemMediaItemTypeEnum.SPU.getType());
        this.itemPriceDgService.removeBatchItemPrice(Lists.newArrayList(ids));
        logger.info("\u5220\u9664\u8f85\u8ba1\u91cf\u5355\u4f4d===============>{}", ids);
        this.itemUnitConversionDgService.logicDeleteBySkuIds(Lists.newArrayList(ids));
    }

    private void removeItemAssociateAttrBySkuId(Long skuId, Integer type) {
        ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance();
        itemMediasDgEo.setSkuId(skuId);
        this.itemMediasDgService.removeItemMedias(itemMediasDgEo);
        this.itemAttributesDgService.removeByItemId(skuId);
        if (ItemDgType.BUNDLE.getIndex().equals(type)) {
            this.bundleItemDgService.removeByItemId(skuId);
        }
        ArrayList<Long> skuIds = new ArrayList<Long>();
        skuIds.add(skuId);
        this.itemPriceDgService.removeBatchItemPrice(skuIds);
        this.itemUnitConversionDgService.logicDeleteBySkuIds(skuIds);
        this.itemTagDgService.removeBySkuId(skuId);
    }

    @Override
    public void validSkuCode(ItemChangeApplyDgDto itemChangeApplyDgDto, Long tenantId) {
        Set skuCodeSet;
        if (itemChangeApplyDgDto != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemChangeApplyDgDto.getSkus()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(skuCodeSet = itemChangeApplyDgDto.getSkus().stream().filter(itemBundleReqDto -> StringUtils.isNotBlank((CharSequence)itemBundleReqDto.getCode())).map(ItemSkuDgReqDto::getCode).collect(Collectors.toSet()))) {
            if (skuCodeSet.size() != itemChangeApplyDgDto.getSkus().size()) {
                throw new BizException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg());
            }
            List itemSkuDgEos = this.itemSkuDgDomain.selectItemSkuByCodes(new ArrayList(skuCodeSet));
            if (CollectionUtil.isEmpty((Collection)itemSkuDgEos)) {
                return;
            }
            Map skuDgEoMap = itemSkuDgEos.stream().collect(Collectors.toMap(ItemSkuDgEo::getCode, Function.identity(), (k1, k2) -> k2));
            for (ItemBundleDgReqDto itemBundleDgReqDto : itemChangeApplyDgDto.getSkus()) {
                ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)skuDgEoMap.get(itemBundleDgReqDto.getCode());
                if (itemSkuDgEo == null || !Objects.isNull(itemBundleDgReqDto.getId()) && Objects.equals(itemSkuDgEo.getId(), itemBundleDgReqDto.getId())) continue;
                throw new BizException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg() + itemBundleDgReqDto.getCode());
            }
        }
    }

    private void modifyItem(ItemDgEo itemDgEo) {
        if (Objects.isNull(itemDgEo) || Objects.isNull(itemDgEo.getId())) {
            return;
        }
        List itemSkuDgEos = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().eq((Object)"item_id", (Object)itemDgEo.getId())).list();
        if (CollectionUtil.isEmpty((Collection)itemSkuDgEos)) {
            return;
        }
        Set specificationKeys = itemSkuDgEos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSpecificationKey())).map(ItemSkuDgEo::getSpecificationKey).collect(Collectors.toSet());
        String keyS = " ";
        if (CollectionUtil.isNotEmpty(specificationKeys)) {
            keyS = JacksonUtil.toJson(specificationKeys);
        }
        itemDgEo.setSpecificationKeys(keyS);
        this.itemDgDomain.updateSelective((BaseEo)itemDgEo);
    }

    public Set<String> validSkuSpecificationKey(ItemChangeApplyDgDto itemChangeApplyDgDto, ItemDgEo itemDgEo) {
        HashSet<String> specificationKeySet = new HashSet<String>();
        if (itemChangeApplyDgDto != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemChangeApplyDgDto.getSkus())) {
            for (ItemBundleDgReqDto skus : itemChangeApplyDgDto.getSkus()) {
                AssertUtils.isFalse((Objects.nonNull(skus.getSpecificationGroupInfo()) && Objects.isNull(skus.getSpecificationKey()) ? 1 : 0) != 0, (String)"\u5df2\u9009\u62e9\u89c4\u683c,\u89c4\u683ckey\u4e0d\u53ef\u4e3a\u7a7a!");
                if (StringUtils.isBlank((CharSequence)skus.getSpecificationKey())) continue;
                AssertUtils.isFalse((boolean)specificationKeySet.contains(skus.getSpecificationKey()), (String)"\u9009\u62e9\u89c4\u683c\u5b58\u5728\u91cd\u590d!");
                specificationKeySet.add(skus.getSpecificationKey());
            }
            if (Objects.isNull(itemDgEo) || Objects.isNull(itemDgEo.getId()) || CollectionUtil.isEmpty(specificationKeySet)) {
                return specificationKeySet;
            }
            List itemSkuDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().eq((Object)"item_id", (Object)itemDgEo.getId())).in((Object)"specification_key", specificationKeySet)).list();
            if (CollectionUtil.isEmpty((Collection)itemSkuDgEos)) {
                return specificationKeySet;
            }
            Map skuDgEoMap = itemSkuDgEos.stream().collect(Collectors.toMap(ItemSkuDgEo::getSpecificationKey, Function.identity(), (k1, k2) -> k2));
            for (ItemBundleDgReqDto itemBundleDgReqDto : itemChangeApplyDgDto.getSkus()) {
                ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)skuDgEoMap.get(itemBundleDgReqDto.getSpecificationKey());
                if (itemSkuDgEo == null || !Objects.isNull(itemBundleDgReqDto.getId()) && Objects.equals(itemSkuDgEo.getId(), itemBundleDgReqDto.getId())) continue;
                throw new BizException(ItemExceptionCode.SPECIFICATION_KEY_EXISTS.getCode(), ItemExceptionCode.SPECIFICATION_KEY_EXISTS.getMsg());
            }
        }
        return specificationKeySet;
    }

    public Set<String> validSaleSkuSpecificationKey(List<ItemLibSkuDgReqDto> skuList, ItemDgEo itemDgEo) {
        HashSet<String> specificationKeySet = new HashSet<String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuList)) {
            for (ItemLibSkuDgReqDto skus : skuList) {
                AssertUtils.isFalse((Objects.nonNull(skus.getSpecificationGroupInfo()) && Objects.isNull(skus.getSpecificationKey()) ? 1 : 0) != 0, (String)"\u5df2\u9009\u62e9\u89c4\u683c,\u89c4\u683ckey\u4e0d\u53ef\u4e3a\u7a7a!");
                if (StringUtils.isBlank((CharSequence)skus.getSpecificationKey())) continue;
                AssertUtils.isFalse((boolean)specificationKeySet.contains(skus.getSpecificationKey()), (String)"\u9009\u62e9\u89c4\u683c\u5b58\u5728\u91cd\u590d!");
                specificationKeySet.add(skus.getSpecificationKey());
            }
            if (Objects.isNull(itemDgEo) || Objects.isNull(itemDgEo.getId()) || CollectionUtil.isEmpty(specificationKeySet)) {
                return specificationKeySet;
            }
            List itemSkuDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().eq((Object)"item_id", (Object)itemDgEo.getId())).in((Object)"specification_key", specificationKeySet)).list();
            if (CollectionUtil.isEmpty((Collection)itemSkuDgEos)) {
                return specificationKeySet;
            }
            Map skuDgEoMap = itemSkuDgEos.stream().collect(Collectors.toMap(ItemSkuDgEo::getSpecificationKey, Function.identity(), (k1, k2) -> k2));
            for (ItemLibSkuDgReqDto itemBundleDgReqDto : skuList) {
                ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)skuDgEoMap.get(itemBundleDgReqDto.getSpecificationKey());
                if (itemSkuDgEo == null || !Objects.isNull(itemBundleDgReqDto.getId()) && Objects.equals(itemSkuDgEo.getId(), itemBundleDgReqDto.getId())) continue;
                throw new BizException(ItemExceptionCode.SPECIFICATION_KEY_EXISTS.getCode(), ItemExceptionCode.SPECIFICATION_KEY_EXISTS.getMsg() + itemBundleDgReqDto.getSpecificationKey());
            }
        }
        return specificationKeySet;
    }

    @Override
    public List<ItemDgRespDto> queryItems(List<Long> ids) {
        List itemDgEoList = this.itemDgDomain.selectByIds(ids);
        ArrayList itemDgRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemDgEoList, (Collection)itemDgRespDtoList, ItemDgRespDto.class);
        return itemDgRespDtoList;
    }

    @Override
    public PageInfo<Long> querySaleOut(ItemDgReqDto itemReq, int page, int size) {
        ItemDgEo query = ItemDgEo.newInstance();
        CubeBeanUtils.copyProperties((Object)query, (Object)itemReq, (String[])new String[0]);
        List<Object> dirIdList = new ArrayList();
        if (Objects.nonNull(query.getDirId())) {
            dirIdList = this.dirDgService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{query.getDirId()}), null, null);
        }
        return this.itemDgDomain.querySaleOut(query, page, size, dirIdList);
    }

    @Override
    public ItemModifyStatusDgRespDto batchEnable(ItemModifyStatusDgReqDto reqDto) {
        ItemModifyStatusDgRespDto respDto = new ItemModifyStatusDgRespDto();
        ArrayList<Long> successIds = new ArrayList<Long>();
        ArrayList<Long> failIds = new ArrayList<Long>();
        int successCount = 0;
        int failCount = 0;
        List itemDgEos = this.itemDgDomain.selectByIds(reqDto.getIds());
        if (CollectionUtil.isEmpty((Collection)itemDgEos)) {
            respDto.setFailIds(reqDto.getIds());
            respDto.setFailCount(reqDto.getIds().size());
            return respDto;
        }
        Map itemMap = itemDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        for (Long id : reqDto.getIds()) {
            ItemDgEo itemDgEo = (ItemDgEo)itemMap.get(id);
            if (Objects.isNull(itemDgEo) || Objects.equals(itemDgEo.getSubStatus(), reqDto.getSubStatus())) {
                failIds.add(id);
                ++failCount;
                continue;
            }
            successIds.add(id);
            ++successCount;
        }
        if (CollectionUtil.isNotEmpty(successIds)) {
            this.itemDgDomain.updateSubStatusByIds(successIds, reqDto.getSubStatus());
        }
        respDto.setFailCount(failCount);
        respDto.setFailIds(failIds);
        respDto.setSuccessIds(successIds);
        respDto.setSuccessCount(successCount);
        return respDto;
    }

    @Override
    public Long queryCount(ItemDgReqDto itemDto) {
        ItemDgEo itemDgEo = new ItemDgEo();
        DtoHelper.dto2Eo((BaseVo)itemDto, (BaseEo)itemDgEo);
        itemDgEo.setDr(0);
        return this.itemDgDomain.count((BaseEo)itemDgEo);
    }

    @Override
    public PageInfo<ItemShelfDgRespDto> queryItemShelf(ShelfDgReqDto shelfDgReqDto, Integer pageNum, Integer pageSize) {
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfDgReqDto, (BaseEo)shelfDgEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfDgReqDto.getSkuIds())) {
            sqlFilters.add(SqlFilter.in((String)"skuId", (Object)shelfDgReqDto.getSkuIds()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfDgReqDto.getShopIds())) {
            sqlFilters.add(SqlFilter.in((String)"shopId", (Object)shelfDgReqDto.getShopIds()));
        }
        PageInfo pageInfo = this.shelfDgDomain.selectPage((BaseEo)shelfDgEo, pageNum, pageSize);
        ArrayList shelfRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)shelfRespDtoList, ItemShelfDgRespDto.class);
        PageInfo resultPage = new PageInfo((List)shelfRespDtoList);
        CubeBeanUtils.copyProperties((Object)resultPage, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && shelfDgReqDto.getBusType() != null && shelfDgReqDto.getBusType().equals(ItemBusTypeDgEnum.INTEGRAL.getType()) && null != this.shelfIntegralDgService) {
            for (ItemShelfDgRespDto itemShelfDgRespDto : shelfRespDtoList) {
                ShelfIntegralDgRespDto shelfIntegralDgRespDto = this.shelfIntegralDgService.queryByShelfId(itemShelfDgRespDto.getId());
                itemShelfDgRespDto.setShelfIntegral(shelfIntegralDgRespDto);
            }
        }
        return resultPage;
    }

    private ItemShelfDgRespDto queryOneItemShelfCache(ShelfDgReqDto shelfDgReqDto) {
        String key = "ItemShelf:" + shelfDgReqDto.getItemId() + shelfDgReqDto.getShopId() + shelfDgReqDto.getSkuId() + shelfDgReqDto.getBusType() + shelfDgReqDto.getItemType();
        return (ItemShelfDgRespDto)this.cacheService.getCache(key, ItemShelfDgRespDto.class);
    }

    private void addOneItemShelfCache(ShelfDgReqDto shelfDgReqDto, ItemShelfDgRespDto itemShelfDgRespDto) {
        String key = "ItemShelf:" + shelfDgReqDto.getItemId() + shelfDgReqDto.getShopId() + shelfDgReqDto.getSkuId() + shelfDgReqDto.getBusType() + shelfDgReqDto.getItemType();
        this.cacheService.add(key, (Object)itemShelfDgRespDto, 60);
    }

    @Override
    public ItemShelfDgRespDto queryOneItemShelf(ShelfDgReqDto shelfDgReqDto) {
        ItemShelfDgRespDto itemShelfDgRespDto1 = this.queryOneItemShelfCache(shelfDgReqDto);
        if (itemShelfDgRespDto1 != null) {
            return itemShelfDgRespDto1;
        }
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfDgReqDto, (BaseEo)shelfDgEo);
        ShelfDgEo result = (ShelfDgEo)this.shelfDgDomain.selectOne((BaseEo)shelfDgEo);
        if (result == null) {
            return null;
        }
        ItemShelfDgRespDto itemShelfDgRespDto = new ItemShelfDgRespDto();
        BeanUtils.copyProperties((Object)result, (Object)itemShelfDgRespDto);
        if (shelfDgReqDto.getBusType() != null && shelfDgReqDto.getBusType().equals(ItemBusTypeDgEnum.INTEGRAL.getType())) {
            ShelfIntegralDgRespDto shelfIntegralDgRespDto = Objects.nonNull(this.shelfIntegralDgService) ? this.shelfIntegralDgService.queryByShelfId(result.getId()) : new ShelfIntegralDgRespDto();
            itemShelfDgRespDto.setShelfIntegral(shelfIntegralDgRespDto);
        }
        this.addOneItemShelfCache(shelfDgReqDto, itemShelfDgRespDto);
        return itemShelfDgRespDto;
    }

    @Override
    @CacheEvict(value={"center_item_shelf"}, key="#itemId+'_'+#shopId+'_'+skuId+'_'+#busType+'_'+#itemType")
    public void clearOneItemShelf(ShelfDgReqDto shelfDgReqDto) {
    }

    @Override
    public List<ItemShelfDgRespDto> queryItemShelfList(ShelfDgReqDto shelfDgReqDto) {
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfDgReqDto, (BaseEo)shelfDgEo);
        List list = this.shelfDgDomain.selectList((BaseEo)shelfDgEo);
        return this.getItemShelfRespDto(list);
    }

    @Override
    public List<Long> queryItemIds(ItemDgReqDto itemDgReqDto) {
        ArrayList itemIds = Lists.newArrayList();
        ItemDgEo itemDgEo = new ItemDgEo();
        DtoHelper.dto2Eo((BaseVo)itemDgReqDto, (BaseEo)itemDgEo);
        PageInfo pageInfo = this.itemDgDomain.selectPage((BaseEo)itemDgEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return itemIds;
        }
        itemIds.addAll(pageInfo.getList().stream().map(BaseEo::getId).collect(Collectors.toList()));
        for (int pageNum = 2; pageNum <= pageInfo.getPages(); ++pageNum) {
            pageInfo = this.itemDgDomain.selectPage((BaseEo)itemDgEo, Integer.valueOf(pageNum), Integer.valueOf(1000));
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
            itemIds.addAll(pageInfo.getList().stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        return itemIds;
    }

    @Override
    public ItemDgRespDto queryItemAndSku(Long itemId, Long skuId) {
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemId);
        if (null == itemDgEo) {
            return null;
        }
        ItemDgRespDto itemDgRespDto = new ItemDgRespDto();
        DtoHelper.eo2Dto((BaseEo)itemDgEo, (BaseVo)itemDgRespDto);
        ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectByPrimaryKey(skuId);
        if (null == itemSkuDgEo) {
            return itemDgRespDto;
        }
        ItemSkuDgRespDto itemSkuDgRespDto = new ItemSkuDgRespDto();
        DtoHelper.eo2Dto((BaseEo)itemSkuDgEo, (BaseVo)itemSkuDgRespDto);
        itemDgRespDto.setItemSkuList((List)Lists.newArrayList((Object[])new ItemSkuDgRespDto[]{itemSkuDgRespDto}));
        return itemDgRespDto;
    }

    @Override
    public BranchItemDgRespDto branchQueryItem(BranchQueryItemDgReqDto branchQueryItemDgReqDto) {
        BranchItemDgRespDto branchItemDgRespDto = new BranchItemDgRespDto();
        ArrayList<ItemDetailDgRespDto> itemDetailDgRespDtos = new ArrayList<ItemDetailDgRespDto>();
        ArrayList<ItemShelfDgRespDto> itemShelfDgRespDtos = new ArrayList<ItemShelfDgRespDto>();
        for (ShelfDgReqDto shelfDgReqDto : branchQueryItemDgReqDto.getShelfItemList()) {
            ItemDetailDgRespDto itemDetailDgRespDto = this.queryItemDetail(shelfDgReqDto.getItemId(), "attributes,sku,medias", null);
            itemDetailDgRespDtos.add(itemDetailDgRespDto);
            ItemShelfDgRespDto itemShelfDgRespDto = this.shelfDgService.queryItemShelf(shelfDgReqDto);
            if (null == itemShelfDgRespDto) continue;
            itemShelfDgRespDtos.add(itemShelfDgRespDto);
        }
        branchItemDgRespDto.setItemShelfList(itemShelfDgRespDtos);
        branchItemDgRespDto.setItemDetailList(itemDetailDgRespDtos);
        return branchItemDgRespDto;
    }

    @Override
    public ItemDetailBaseInfoDgRespDto queryItemDetail(long itemId, long shopId) {
        ItemSearchQueryDgReqDto queryReqDto = new ItemSearchQueryDgReqDto();
        queryReqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        queryReqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        queryReqDto.setItemIds((List)Lists.newArrayList((Object[])new Long[]{itemId}));
        ItemSearchDgRespDto searchRespDto = this.queryByKeyword(queryReqDto, 1, 1);
        if (null == searchRespDto || null == searchRespDto.getPageInfo() || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)searchRespDto.getPageInfo().getList())) {
            return null;
        }
        ItemDgRespDto itemDgRespDto = (ItemDgRespDto)searchRespDto.getPageInfo().getList().get(0);
        ItemDetailBaseInfoDgRespDto itemBaseInfo = new ItemDetailBaseInfoDgRespDto();
        CubeBeanUtils.copyProperties((Object)itemBaseInfo, (Object)itemDgRespDto, (String[])new String[0]);
        itemBaseInfo.setItemMediasList(itemDgRespDto.getItemMediasList());
        itemBaseInfo.setSaleCount(itemDgRespDto.getSalesCount());
        itemBaseInfo.setAttrs(((ItemAttributesDgRespDto)searchRespDto.getAttributesList().get(0)).getAttrs());
        this.filterOnSelfSkuAndModify(itemBaseInfo, itemDgRespDto, shopId);
        return itemBaseInfo;
    }

    private void filterOnSelfSkuAndModify(ItemDetailBaseInfoDgRespDto itemBaseInfo, ItemDgRespDto itemDgRespDto, long shopId) {
        long itemId = itemBaseInfo.getId();
        ShelfDgReqDto shelfDgReqDto = new ShelfDgReqDto();
        shelfDgReqDto.setItemId(Long.valueOf(itemId));
        if (shopId > 0L) {
            shelfDgReqDto.setShopId(Long.valueOf(shopId));
        }
        shelfDgReqDto.setStatus(Integer.valueOf(1));
        List<ItemShelfDgRespDto> itemShelfDgRespDtos = this.queryItemShelfList(shelfDgReqDto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemShelfDgRespDtos)) {
            logger.error("\u65e0\u4e0a\u67b6\u4fe1\u606f{}\uff0c{}", (Object)itemId, (Object)shopId);
            return;
        }
        ArrayList itemSkuList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemSkuList, (Collection)itemDgRespDto.getItemSkuList(), ItemSkuInfoDgRespDto.class);
        boolean hasCycleBuy = itemShelfDgRespDtos.parallelStream().anyMatch(t -> Objects.equals(t.getType(), ShelfTypeDgEnum.PERIOD.getType()));
        if (hasCycleBuy && null != this.itemCycleBuyDgService) {
            itemBaseInfo.setCycleBuyByShopItem(this.itemCycleBuyDgService.getCycleBuyByShopItem(shopId, itemId));
        }
        Map<Long, ItemShelfDgRespDto> itemShelfRespDtoMap = itemShelfDgRespDtos.stream().collect(Collectors.toMap(ItemShelfDgRespDto::getSkuId, itemShelfRespDto -> itemShelfRespDto, (e1, e2) -> e1));
        itemBaseInfo.setItemSkuList(itemSkuList.stream().filter(itemSkuInfoDgRespDto -> itemShelfRespDtoMap.get(itemSkuInfoDgRespDto.getId()) != null).peek(itemSkuInfoDgRespDto -> {
            ItemShelfDgRespDto itemShelfDgRespDto = (ItemShelfDgRespDto)itemShelfRespDtoMap.get(itemSkuInfoDgRespDto.getId());
            itemSkuInfoDgRespDto.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkuInfoDgRespDto.getItemPriceList())) {
                for (ItemPriceDgRespDto itemPriceDgRespDto : itemSkuInfoDgRespDto.getItemPriceList()) {
                    if (!ItemPriceDgEnum.SALE_PRICE.getType().equals(itemPriceDgRespDto.getPriceType())) continue;
                    itemPriceDgRespDto.setPrice(itemShelfDgRespDto.getPrice());
                }
            }
        }).collect(Collectors.toList()));
    }

    @Override
    public List<DirsItemsDgRespDto> queryDirsItems(Long shopId, Long itemId) {
        DirItemRelationDgEo dirItemRelationDgEo = DirItemRelationDgEo.newInstance();
        dirItemRelationDgEo.setShopId(shopId);
        dirItemRelationDgEo.setItemId(itemId);
        List dirsItemsEoList = this.dirItemRelationDgDomain.selectList((BaseEo)dirItemRelationDgEo);
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)dirsItemsEoList, (Collection)list, DirsItemsDgRespDto.class);
        return list;
    }

    @Override
    public PageInfo<ItemShelfDgRespDto> queryItemShelfByPage(ShelfDgReqDto shelfDgReqDto, Integer pageNum, Integer pageSize) {
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfDgReqDto, (BaseEo)shelfDgEo);
        PageInfo pageInfo = this.shelfDgDomain.selectPage((BaseEo)shelfDgEo, pageNum, pageSize);
        List<ItemShelfDgRespDto> shelfRespDtoList = this.getItemShelfRespDto(pageInfo.getList());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(shelfRespDtoList);
        return dtoPageInfo;
    }

    private List<ItemShelfDgRespDto> getItemShelfRespDto(List<ShelfDgEo> shelfDgEos) {
        ArrayList shelfRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList(shelfDgEos, (Collection)shelfRespDtoList, ItemShelfDgRespDto.class);
        Map<Integer, List<ItemShelfDgRespDto>> group = shelfRespDtoList.stream().collect(Collectors.groupingBy(ItemShelfDgRespDto::getBusType));
        if (group.containsKey(ItemBusTypeDgEnum.INTEGRAL.getType())) {
            List<Object> shelfIntegralDgRespDtos;
            List<Long> shelfIds = group.get(ItemBusTypeDgEnum.INTEGRAL.getType()).stream().map(ItemShelfDgRespDto::getId).collect(Collectors.toList());
            List<Object> list = shelfIntegralDgRespDtos = Objects.nonNull(this.shelfIntegralDgService) ? this.shelfIntegralDgService.queryByShelfId(shelfIds) : new ArrayList();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shelfIntegralDgRespDtos)) {
                Map<Long, List<ShelfIntegralDgRespDto>> map = shelfIntegralDgRespDtos.stream().collect(Collectors.groupingBy(ShelfIntegralDgRespDto::getShelfId));
                for (ItemShelfDgRespDto itemShelfDgRespDto : shelfRespDtoList) {
                    if (!map.containsKey(itemShelfDgRespDto.getId())) continue;
                    itemShelfDgRespDto.setShelfIntegral(map.get(itemShelfDgRespDto.getId()).get(0));
                }
            }
        }
        return shelfRespDtoList;
    }

    @Override
    public void refresh(ShelfDgReqDto shelfDgReqDto) {
        if (null == shelfDgReqDto.getItemId() && null == shelfDgReqDto.getShopId()) {
            logger.info("\u5546\u54c1id\u548c\u5e97\u94faid\u4e0d\u540c\u65f6\u4e3a\u7a7a,\u4e0d\u66f4\u5546\u54c1es\u6570\u636e");
        }
        int itemTotalNum = 0;
        int pageNum = 1;
        int pageSize = 1000;
        shelfDgReqDto.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
        PageInfo<ItemShelfDgRespDto> pageInfo = this.queryItemShelfByPage(shelfDgReqDto, pageNum, pageSize);
        while (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            Map<String, List<ItemShelfDgRespDto>> group = pageInfo.getList().stream().collect(Collectors.groupingBy(shelfRespDto -> "" + shelfRespDto.getSellerId() + shelfRespDto.getItemId() + shelfRespDto.getBusType()));
            for (List<ItemShelfDgRespDto> shelfRespDtos : group.values()) {
                ItemShelfDgRespDto shelfRespDto2 = shelfRespDtos.get(0);
                this.itemSearchDgService.index(shelfRespDto2.getSellerId(), shelfRespDto2.getItemId(), shelfRespDto2.getBusType(), "ON_SHELF");
                ++itemTotalNum;
            }
            pageInfo = this.queryItemShelfByPage(shelfDgReqDto, ++pageNum, pageSize);
        }
        logger.info("\u66f4\u65b0\u5546\u54c1ES\u6570\u636e\uff0c\u53c2\u6570shelfReqDto={},\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)shelfDgReqDto), (Object)itemTotalNum);
    }

    @Override
    public void refreshSyn(ShelfDgReqDto shelfDgReqDto) {
        if (null == shelfDgReqDto.getItemId() && null == shelfDgReqDto.getShopId()) {
            logger.info("\u5546\u54c1id\u548c\u5e97\u94faid\u4e0d\u540c\u65f6\u4e3a\u7a7a,\u4e0d\u66f4\u5546\u54c1es\u6570\u636e");
        }
        int itemTotalNum = 0;
        int pageNum = 1;
        int pageSize = 1000;
        shelfDgReqDto.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
        PageInfo<ItemShelfDgRespDto> pageInfo = this.queryItemShelfByPage(shelfDgReqDto, pageNum, pageSize);
        while (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List itemShelfDgRespDtos = pageInfo.getList();
            Map<Integer, Map<Long, List<ItemShelfDgRespDto>>> dataMap = itemShelfDgRespDtos.stream().collect(Collectors.groupingBy(ItemShelfDgRespDto::getBusType, Collectors.mapping(o -> o, Collectors.groupingBy(ItemShelfDgRespDto::getSellerId))));
            dataMap.forEach((k, v) -> v.forEach((key, val) -> this.itemSearchDgService.refreshIndexBatch(this.transferDto(itemShelfDgRespDtos), (Integer)k, "ON_SHELF")));
            itemTotalNum += itemShelfDgRespDtos.size();
            pageInfo = this.queryItemShelfByPage(shelfDgReqDto, ++pageNum, pageSize);
        }
        logger.info("\u66f4\u65b0\u5546\u54c1ES\u6570\u636e\uff0c\u53c2\u6570shelfReqDto={},\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)shelfDgReqDto), (Object)itemTotalNum);
    }

    private List<DirItemRelationDgEo> transferDto(List<ItemShelfDgRespDto> itemShelfDgRespDtos) {
        return itemShelfDgRespDtos.stream().map(shelf -> {
            DirItemRelationDgEo relationEo = new DirItemRelationDgEo();
            relationEo.setSellerId(shelf.getSellerId());
            relationEo.setShopId(shelf.getShopId());
            relationEo.setItemId(shelf.getItemId());
            relationEo.setBusType(shelf.getBusType());
            return relationEo;
        }).collect(Collectors.toList());
    }

    @Override
    public void refreshES(ShelfDgReqDto shelfDgReqDto) {
        if (null == shelfDgReqDto.getItemId() && null == shelfDgReqDto.getShopId()) {
            logger.info("\u5546\u54c1id\u548c\u5e97\u94faid\u4e0d\u540c\u65f6\u4e3a\u7a7a,\u4e0d\u66f4\u5546\u54c1es\u6570\u636e");
        }
        int itemTotalNum = 0;
        int pageNum = 1;
        int pageSize = 1000;
        PageInfo<ItemShelfDgRespDto> pageInfo = this.queryItemShelfByPage(shelfDgReqDto, pageNum, pageSize);
        while (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            Map<String, List<ItemShelfDgRespDto>> group = pageInfo.getList().stream().collect(Collectors.groupingBy(shelfRespDto -> shelfRespDto.getShopId().toString() + shelfRespDto.getItemId() + shelfRespDto.getBusType()));
            for (List<ItemShelfDgRespDto> shelfRespDtos : group.values()) {
                ItemShelfDgRespDto shelfRespDto2 = shelfRespDtos.get(0);
                this.itemSearchDgService.index(shelfRespDto2.getSellerId(), shelfRespDto2.getItemId(), shelfRespDto2.getBusType(), "ON_SHELF");
                ++itemTotalNum;
            }
            pageInfo = this.queryItemShelfByPage(shelfDgReqDto, ++pageNum, pageSize);
        }
        logger.info("\u66f4\u65b0\u5546\u54c1ES\u6570\u636e\uff0c\u53c2\u6570shelfReqDto={},\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)shelfDgReqDto), (Object)itemTotalNum);
    }

    @Override
    public List<ItemBundleRelationDgEo> queryBundleItemList(Long shopId, Long skuId) {
        ItemBundleRelationDgEo param = new ItemBundleRelationDgEo();
        param.setSkuId(skuId);
        return this.itemBundleRelationDgDomain.selectList((BaseEo)param);
    }

    @Override
    public List<BundleItemDgRespDto> queryBundleItemDetail(Long shopId, Long itemId, Integer itemBusType) {
        ItemBundleRelationDgEo param = new ItemBundleRelationDgEo();
        param.setItemId(itemId);
        List bundleRelationEos = this.itemBundleRelationDgDomain.selectList((BaseEo)param);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)bundleRelationEos)) {
            return Collections.emptyList();
        }
        List<Long> subItemIds = bundleRelationEos.stream().map(ItemBundleRelationDgEo::getSubItemId).collect(Collectors.toList());
        List subSkuIds = bundleRelationEos.stream().map(ItemBundleRelationDgEo::getSubSkuId).collect(Collectors.toList());
        ShelfQueryDgReqDto queryReqDto = new ShelfQueryDgReqDto();
        queryReqDto.setItemIds(subItemIds);
        queryReqDto.setShopId(shopId);
        queryReqDto.setBusType(itemBusType);
        List<ShelfQueryDgRespDto> shelfQueryDgRespDtos = this.shelfDgService.queryShelfList(queryReqDto);
        Map<String, ShelfQueryDgRespDto> shelfMap = shelfQueryDgRespDtos.stream().collect(Collectors.toMap(shelf -> shelf.getShopId() + shelf.getSkuId().toString(), e -> e, (e1, e2) -> e1));
        List shelfDgReqDtos = subSkuIds.stream().map(skuId -> {
            ShelfDgReqDto shelfDgReqDto = new ShelfDgReqDto();
            shelfDgReqDto.setShopId(shopId);
            shelfDgReqDto.setSkuId(skuId);
            return shelfDgReqDto;
        }).collect(Collectors.toList());
        ItemStorageBranchQueryDgReqDto batchReqDto = new ItemStorageBranchQueryDgReqDto();
        batchReqDto.setShelfList(shelfDgReqDtos);
        List<ItemStorageQueryDgRespDto> storageRespDtos = this.itemStorageDgService.queryBranchItemStorage(batchReqDto);
        Map<String, ItemStorageQueryDgRespDto> storageMap = storageRespDtos.stream().collect(Collectors.toMap(storage -> storage.getShopId() + storage.getSkuId().toString(), e -> e, (e1, e2) -> e1));
        ArrayList bundleItems = Lists.newArrayList();
        List<ItemSkuDgRespDto> itemSkuList = this.itemSkuDgService.queryByItemId(itemId);
        Map<Long, ItemSkuDgRespDto> skuEoMap = itemSkuList.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getId, e -> e, (e1, e2) -> e1));
        List<ItemDgEo> subItemDgEos = this.queryItemByIds(subItemIds);
        Map<Long, ItemDgEo> itemEoMap = subItemDgEos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
        for (ItemBundleRelationDgEo bundleItem : bundleRelationEos) {
            String subShopItem = shopId + bundleItem.getSubSkuId().toString();
            BundleItemDgRespDto bundleItemDgRespDto = new BundleItemDgRespDto();
            CubeBeanUtils.copyProperties((Object)bundleItemDgRespDto, (Object)bundleItem, (String[])new String[0]);
            if (itemEoMap.containsKey(bundleItem.getSubItemId())) {
                bundleItemDgRespDto.setSubItemName(itemEoMap.get(bundleItem.getSubItemId()).getName());
            }
            if (shelfMap.containsKey(subShopItem)) {
                ShelfQueryDgRespDto shelfQueryDgRespDto = shelfMap.get(subShopItem);
                bundleItemDgRespDto.setRetailPrice(shelfQueryDgRespDto.getPrice());
                bundleItemDgRespDto.setShelfStatus(shelfQueryDgRespDto.getStatus());
            }
            if (storageMap.containsKey(subShopItem)) {
                bundleItemDgRespDto.setStorage(storageMap.get(subShopItem).getAvaNum());
            }
            if (skuEoMap.containsKey(bundleItem.getSubSkuId())) {
                ItemSkuDgRespDto sku = skuEoMap.get(bundleItem.getSubSkuId());
                bundleItemDgRespDto.setAttr(sku.getAttr());
                bundleItemDgRespDto.setBarCode(sku.getBarCode());
                bundleItemDgRespDto.setCargoCode(sku.getCargoCode());
                bundleItemDgRespDto.setSubSkuCode(sku.getCode());
                BigDecimal price = sku.getItemPriceList().stream().filter(priceDto -> "PRICE".equals(priceDto.getPriceType())).map(ItemPriceDgRespDto::getPrice).findFirst().orElse(BigDecimal.ZERO);
                bundleItemDgRespDto.setPrice(price);
            }
            bundleItems.add(bundleItemDgRespDto);
        }
        return bundleItems;
    }

    @Override
    public List<BundleItemDgRespDto> queryBundleItem(Long itemId) {
        ItemBundleRelationDgEo param = new ItemBundleRelationDgEo();
        param.setItemId(itemId);
        List itemBundleRelationDgEos = this.itemBundleRelationDgDomain.selectList((BaseEo)param);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)itemBundleRelationDgEos, BundleItemDgRespDto.class);
        return list;
    }

    @Override
    public List<BundleItemDgRespDto> queryBundleItem(BundleItemDgReqDto bundleItemDgReqDto) {
        ItemBundleRelationDgEo param = new ItemBundleRelationDgEo();
        DtoHelper.dto2Eo((BaseVo)bundleItemDgReqDto, (BaseEo)param);
        List itemBundleRelationDgEos = this.itemBundleRelationDgDomain.selectList((BaseEo)param);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)itemBundleRelationDgEos, BundleItemDgRespDto.class);
        return list;
    }

    @Override
    public ItemDgRespDto queryByItemCode(String itemCode) {
        ItemDgEo itemDgEoSelect = new ItemDgEo();
        itemDgEoSelect.setCode(itemCode);
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectOne((BaseEo)itemDgEoSelect);
        ItemDgRespDto itemDgRespDto = new ItemDgRespDto();
        DtoHelper.eo2Dto((BaseEo)itemDgEo, (BaseVo)itemDgRespDto);
        return itemDgRespDto;
    }

    @Override
    public List<ItemDgRespDto> queryByItemLongCodes(List<String> itemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            return null;
        }
        return this.itemDgDomain.queryByItemLongCodes(itemCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyItem(ItemDgReqDto itemDgReqDto) {
        if (itemDgReqDto.getId() == null) {
            logger.info("\u5546\u54c1id\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u66f4\u65b0");
            return;
        }
        ItemDgEo itemDgEo = new ItemDgEo();
        DtoHelper.dto2Eo((BaseVo)itemDgReqDto, (BaseEo)itemDgEo);
        itemDgEo.setId(itemDgReqDto.getId());
        itemDgEo.setOrganizationId(itemDgReqDto.getOrganizationId());
        this.itemDgDomain.updateSelective((BaseEo)itemDgEo);
        if (StringUtils.isNotEmpty((CharSequence)itemDgReqDto.getAttrs())) {
            this.itemAttributesDgService.removeByItemId(itemDgReqDto.getId());
            String attrs = itemDgReqDto.getAttrs();
            ItemAttributesDgEo itemAttributesDgEo = new ItemAttributesDgEo();
            itemAttributesDgEo.setItemId(itemDgReqDto.getId());
            itemAttributesDgEo.setAttrs(attrs);
            this.itemAttributesDgService.addProp(itemAttributesDgEo);
        }
    }

    @Override
    public List<DirItemRelativeQueryDgRespDto> queryItemDirRelativeBatch(List<Long> itemIds, List<Long> shopIds, List<Integer> busTypes) {
        List list = this.dirItemRelationDgDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DirItemRelationDgEo::getItemId, itemIds)).in(DirItemRelationDgEo::getShopId, shopIds)).in(DirItemRelationDgEo::getBusType, busTypes)).eq(BaseEo::getDr, (Object)0)).eq(DirItemRelationDgEo::getDirType, (Object)"front"));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            List dirIdList = list.stream().map(DirItemRelationDgEo::getDirId).distinct().collect(Collectors.toList());
            Map<Object, Object> dirMap = Maps.newHashMap();
            List dirDgEoList = this.dirDgDomain.selectByIds(dirIdList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirDgEoList)) {
                dirMap = dirDgEoList.stream().collect(Collectors.toMap(BaseEo::getId, DirDgEo::getName));
            }
            HashMap finalDirMap = dirMap;
            return list.stream().map(dirItemRelation -> {
                DirItemRelativeQueryDgRespDto itemDirQueryRespDto = new DirItemRelativeQueryDgRespDto();
                BeanUtils.copyProperties((Object)dirItemRelation, (Object)itemDirQueryRespDto);
                if (finalDirMap.get(dirItemRelation.getDirId()) != null) {
                    itemDirQueryRespDto.setDirName((String)finalDirMap.get(dirItemRelation.getDirId()));
                }
                return itemDirQueryRespDto;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItemSkuRelDgRespDto> queryItemSkuRelByCodes(List<String> itemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.itemDgDomain.queryItemSkuRelByCodes(itemCodes);
    }

    @Override
    public List<ItemSkuRelDgRespDto> queryItemSkuByItemCodes(List<String> itemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.itemDgDomain.queryItemSkuByItemCodes(itemCodes);
    }

    @Override
    public List<ItemSkuRelDgRespDto> queryItemSkuBySkuCodes(List<String> skuCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuCodes)) {
            throw new BizException("sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.itemDgDomain.queryItemSkuBySkuCodes(skuCodes);
    }

    @Override
    public BundleItemDetailDgRespDto queryBundleItemDetailByItemId(Long id) {
        BundleItemDetailDgRespDto bundleItemDetailDgRespDto = new BundleItemDetailDgRespDto();
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(id);
        ItemDgRespDto itemDto = new ItemDgRespDto();
        if (ObjectUtils.isNotEmpty((Object)itemDgEo)) {
            return bundleItemDetailDgRespDto;
        }
        DtoHelper.eo2Dto((BaseEo)itemDgEo, (BaseVo)itemDto);
        String mainPic = this.getMainPic(id);
        itemDto.setMainPic(mainPic);
        bundleItemDetailDgRespDto.setItem(itemDto);
        List<ItemAttributesDgRespDto> itemAttributesDgRespDtos = this.itemAttributesDgService.queryByItemId(id);
        bundleItemDetailDgRespDto.setItemAttributesList(itemAttributesDgRespDtos);
        List itemBundleRelationDgEos = this.itemBundleRelationDgDomain.getListByItemId(id);
        List<Long> subSkuIds = itemBundleRelationDgEos.stream().map(ItemBundleRelationDgEo::getSubSkuId).collect(Collectors.toList());
        List<ItemSkuDgRespDto> itemSkuDgRespDtos = this.itemSkuDgService.queryItemSkuList(subSkuIds);
        Map<Long, ItemSkuDgRespDto> skuMap = itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getId, e -> e, (e1, e2) -> e1));
        ArrayList bundleItemDgRespDtos = new ArrayList();
        CubeBeanUtils.copyCollection(bundleItemDgRespDtos, (Collection)itemBundleRelationDgEos, BundleItemDgRespDto.class);
        bundleItemDgRespDtos.forEach(bundleItemDgRespDto -> bundleItemDgRespDto.setSubItemName(((ItemSkuDgRespDto)skuMap.get(bundleItemDgRespDto.getSubSkuId())).getName()));
        bundleItemDetailDgRespDto.setBundleItemDtos(bundleItemDgRespDtos);
        return bundleItemDetailDgRespDto;
    }

    @Override
    public ItemDetailDgRespDto queryDetailById(Long id) {
        logger.info("\u67e5\u8be2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f itemDetailReqDto : {}", (Object)id);
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(id);
        if (Objects.isNull(itemDgEo)) {
            return null;
        }
        ItemDetailDgRespDto itemDetailDto = new ItemDetailDgRespDto();
        ItemDgRespDto itemDto = new ItemDgRespDto();
        List<ItemPropRelationDgRespDto> itemPropRelationDgRespDtos = this.propDgService.queryByItemId(itemDgEo.getId());
        itemDetailDto.setItemPropRelationDgRespDtos(itemPropRelationDgRespDtos);
        String propGroupInfo = itemDgEo.getPropGroupInfo();
        if (StringUtils.isNotBlank((CharSequence)propGroupInfo)) {
            List propGroupDtoList = JSON.parseArray((String)propGroupInfo, ItemPropGroupDgDto.class);
            itemDetailDto.setPropGroupDtoList(propGroupDtoList);
        }
        BeanUtil.copyProperties((Object)itemDgEo, (Object)itemDto, (String[])new String[0]);
        itemDto.setItemId(itemDgEo.getId());
        itemDetailDto = new ItemDetailDgRespDto();
        itemDetailDto.setItem(itemDto);
        itemDetailDto.setItemSkuList(this.itemSkuDgService.queryByItemId(itemDgEo.getId()));
        List<ItemAttributesDgRespDto> attributesDgRespDtos = this.itemAttributesDgService.queryByItemId(itemDgEo.getId());
        itemDetailDto.setItemAttributesList(attributesDgRespDtos);
        List<ItemMediasDgRespDto> itemMediasList = this.itemMediasDgService.queryByItemId(itemDgEo.getId());
        itemDetailDto.setItemMediasList(itemMediasList);
        List<DirsItemsDgRespDto> dirsItemsDgRespDtos = this.dirItemRelationDgService.queryList(itemDetailDto.getItem().getItemId());
        if (CollectionUtil.isNotEmpty(dirsItemsDgRespDtos)) {
            List shopDirIdList;
            itemDetailDto.setDirsItemsList(dirsItemsDgRespDtos);
            if (StringUtils.isNotBlank((CharSequence)itemDetailDto.getItem().getSaleChannel())) {
                itemDetailDto.setSaleChannels(Arrays.asList(itemDetailDto.getItem().getSaleChannel().split("-")));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shopDirIdList = dirsItemsDgRespDtos.stream().filter(dirsItemsRespDto -> Objects.equals("shop", dirsItemsRespDto.getDirType())).map(DirsItemsDgRespDto::getDirId).collect(Collectors.toList()))) {
                DirDgEo dirDgEo = DirDgEo.newInstance();
                dirDgEo.setId((Long)shopDirIdList.get(0));
                dirDgEo = (DirDgEo)this.dirDgDomain.selectOne((BaseEo)dirDgEo);
                itemDetailDto.setShopDirId(dirDgEo.getId());
                itemDetailDto.setShopDirName(dirDgEo.getName());
            }
        }
        List<ItemUnitConversionDgGroupDto> unitConversionDgGroupDtos = this.itemUnitConversionDgService.queryUnitConversionsByItemCode(itemDgEo.getCode());
        itemDetailDto.setItemUnitConversionDgGroupDtoList(unitConversionDgGroupDtos);
        logger.info("\u67e5\u8be2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u8fd4\u56de ItemDetailRespDto : {}", (Object)itemDetailDto);
        return itemDetailDto;
    }

    @Override
    public ItemExchangeUnitDgRespDto exchangeUnit(ItemExchangeUnitDgReqDto reqDto) {
        ItemSkuDgEo skuDgEo = (ItemSkuDgEo)((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().eq((Object)"code", (Object)reqDto.getSkuCode())).one();
        AssertUtils.notNull((Object)skuDgEo, (String)"sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ItemDgEo itemDgEo = (ItemDgEo)((ExtQueryChainWrapper)this.itemDgDomain.filter().eq((Object)"id", (Object)skuDgEo.getItemId())).one();
        HashMap<String, ItemUnitConversionDgDto> unitMap = new HashMap<String, ItemUnitConversionDgDto>();
        this.getUnitMap(reqDto, itemDgEo, skuDgEo, unitMap);
        return this.getexchangeUnitResp(reqDto, unitMap, skuDgEo, itemDgEo);
    }

    private void getUnitMap(ItemExchangeUnitDgReqDto reqDto, ItemDgEo itemDgEo, ItemSkuDgEo skuDgEo, Map<String, ItemUnitConversionDgDto> unitMap) {
        if ("close".equals(this.unitConversion)) {
            unitMap.putAll(this.getDefaultUnitList(reqDto));
        } else {
            ItemUnitConversionDgDto currentUnit = new ItemUnitConversionDgDto();
            currentUnit.setBaseUnit(skuDgEo.getUnit());
            currentUnit.setBaseUnitNum(BigDecimal.ONE);
            currentUnit.setConversionUnit(skuDgEo.getUnit());
            currentUnit.setConversionNum(BigDecimal.ONE);
            unitMap.put(skuDgEo.getUnit(), currentUnit);
            if (Objects.nonNull(reqDto.getVersions())) {
                this.getItemShot(reqDto, itemDgEo, skuDgEo, unitMap);
            } else {
                this.getUnitList(skuDgEo.getId(), unitMap);
            }
        }
    }

    private void getItemShot(ItemExchangeUnitDgReqDto reqDto, ItemDgEo itemDgEo, ItemSkuDgEo skuDgEo, Map<String, ItemUnitConversionDgDto> unitMap) {
        ArrayList<String> keyWords = new ArrayList<String>();
        keyWords.add(skuDgEo.getId().toString() + reqDto.getVersions());
        List snapshotDgEos = this.itemSkuSnapshotDgDomain.queryListByKeyWords(keyWords);
        AssertUtils.notEmpty((Collection)snapshotDgEos, (String)"\u8be5\u7248\u672c\u5feb\u7167\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ItemSkuSnapshotDgEo itemSkuSnapshotDgEo = (ItemSkuSnapshotDgEo)snapshotDgEos.get(0);
        JSONObject jsonToMap = JSONObject.parseObject((String)itemSkuSnapshotDgEo.getContent());
        itemDgEo = (ItemDgEo)jsonToMap.get("item");
        DgItemSkuDetailRespDto skuDetail = (DgItemSkuDetailRespDto)jsonToMap.get("sku");
        BeanUtil.copyProperties((Object)skuDetail, (Object)skuDgEo, (String[])new String[0]);
        skuDgEo.setId(skuDetail.getId());
        skuDgEo.setCode(skuDetail.getSkuCode());
        skuDgEo.setName(skuDetail.getSkuName());
        skuDgEo.setDisplayName(skuDetail.getSkuDisplayName());
        List unitConvertList = skuDetail.getUnitConvertList();
        if (CollectionUtil.isEmpty((Collection)unitConvertList)) {
            return;
        }
        unitMap = unitConvertList.stream().collect(Collectors.toMap(ItemUnitConversionDgDto::getConversionUnit, Function.identity(), (k1, k2) -> k2));
    }

    @Override
    public List<ItemExchangeUnitDgRespDto> batchExchangeUnit(List<ItemExchangeUnitDgReqDto> reqDtos) {
        AssertUtils.notEmpty(reqDtos, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a!");
        ArrayList<ItemExchangeUnitDgRespDto> unitDgRespDtos = new ArrayList<ItemExchangeUnitDgRespDto>();
        List skuCodes = reqDtos.stream().map(ItemExchangeUnitDgReqDto::getSkuCode).collect(Collectors.toList());
        AssertUtils.notEmpty(skuCodes, (String)"skuCode\u5217\u8868\u4e0d\u53ef\u4e3a\u7a7a!");
        List skuDgEos = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"code", skuCodes)).list();
        AssertUtils.notEmpty((Collection)skuDgEos, (String)"\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ArrayList<Long> itemIds = new ArrayList<Long>();
        HashMap<String, ItemSkuDgEo> skuEoMap = new HashMap<String, ItemSkuDgEo>();
        for (ItemSkuDgEo skuDgEo : skuDgEos) {
            skuEoMap.put(skuDgEo.getCode(), skuDgEo);
            itemIds.add(skuDgEo.getItemId());
        }
        reqDtos.stream().filter(r -> Objects.isNull(r.getTargetUnit())).forEach(req -> req.setTargetUnit(((ItemSkuDgEo)skuEoMap.get(req.getSkuCode())).getUnit()));
        List itemEos = ((ExtQueryChainWrapper)this.itemDgDomain.filter().in((Object)"id", itemIds)).list();
        AssertUtils.notEmpty((Collection)itemEos, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!");
        Map itemEoMap = itemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (key1, key2) -> key2));
        for (ItemExchangeUnitDgReqDto reqDto : reqDtos) {
            ItemSkuDgEo skuDgEo = (ItemSkuDgEo)skuEoMap.get(reqDto.getSkuCode());
            AssertUtils.notNull((Object)skuDgEo, (String)"sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
            HashMap<String, ItemUnitConversionDgDto> unitMap = new HashMap<String, ItemUnitConversionDgDto>();
            ItemDgEo itemDgEo = Objects.nonNull(itemEoMap.get(skuDgEo.getItemId())) ? (ItemDgEo)itemEoMap.get(skuDgEo.getItemId()) : new ItemDgEo();
            this.getUnitMap(reqDto, itemDgEo, skuDgEo, unitMap);
            unitDgRespDtos.add(this.getexchangeUnitResp(reqDto, unitMap, skuDgEo, itemDgEo));
        }
        return unitDgRespDtos;
    }

    @Override
    public PageInfo<ItemSkuDgRespDto> querySkuPage(DgItemSkuPlanQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        ArrayList<ItemSkuDgRespDto> skuDgRespDtos = new ArrayList<ItemSkuDgRespDto>();
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)reqDto, (String[])new String[]{"pageNum", "pageSize"}));
        PageInfo itemSkuDgEoPage = this.itemSkuDgDomain.querySkuPageByPlan(reqDto, pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)itemSkuDgEoPage, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)itemSkuDgEoPage.getList(), skuDgRespDtos, ItemSkuDgRespDto.class);
        this.getItemSkuDgRespDto(skuDgRespDtos);
        pageInfo.setList(skuDgRespDtos);
        return pageInfo;
    }

    @Override
    public List<ItemSkuDgRespDto> querySkuList(DgItemSkuPlanQueryReqDto reqDto) {
        ArrayList<ItemSkuDgRespDto> skuDgRespDtos = new ArrayList<ItemSkuDgRespDto>();
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in(CollectionUtil.isNotEmpty((Collection)reqDto.getSkuIds()), (Object)"id", (Collection)reqDto.getSkuIds())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList()), (Object)"code", (Collection)reqDto.getSkuCodeList())).like(Objects.nonNull(reqDto.getSkuCode()), (Object)"code", (Object)reqDto.getSkuCode())).like(Objects.nonNull(reqDto.getName()), (Object)"name", (Object)reqDto.getName())).list();
        DtoHelper.eoList2DtoList((Collection)list, skuDgRespDtos, ItemSkuDgRespDto.class);
        this.getItemSkuDgRespDto(skuDgRespDtos);
        return skuDgRespDtos;
    }

    @Override
    public List<ItemRoundDgRespDto> batchRound(List<ItemExchangeUnitDgReqDto> reqDtos) {
        return null;
    }

    @Override
    public ItemDetailDgRespDto queryItemDetailByItemId(Long id) {
        ItemDetailDgRespDto itemDetailDto = new ItemDetailDgRespDto();
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(id);
        if (ObjectUtils.isNotEmpty((Object)itemDgEo)) {
            return itemDetailDto;
        }
        List<ItemAttributesDgRespDto> itemAttributesDgRespDtos = this.itemAttributesDgService.queryByItemId(id);
        itemDetailDto.setItemAttributesList(itemAttributesDgRespDtos);
        ItemDgRespDto itemDto = new ItemDgRespDto();
        DtoHelper.eo2Dto((BaseEo)itemDgEo, (BaseVo)itemDto);
        this.setItemSkuByItemIds(Lists.newArrayList((Object[])new ItemDgRespDto[]{itemDto}), Lists.newArrayList((Object[])new Long[]{itemDgEo.getId()}));
        itemDto.setItemSkuList(null);
        String mainPic = this.getMainPic(id);
        itemDto.setMainPic(mainPic);
        ItemUnitConversionRelationDgDto item = new ItemUnitConversionRelationDgDto();
        item.setItemId(id);
        List<ItemUnitConversionDgGroupDto> itemUnitConversionDgGroupDtos = this.itemUnitConversionDgService.queryUnitConversionsByItem(item);
        itemDetailDto.setItemUnitConversionDgGroupDtoList(itemUnitConversionDgGroupDtos);
        itemDetailDto.setItem(itemDto);
        if (ItemTypeDg.COMB_ITEM.getStatus().equals(itemDgEo.getType())) {
            List itemBundleRelationDgEos = this.itemBundleRelationDgDomain.getListByItemId(id);
            List<Long> subSkuIds = itemBundleRelationDgEos.stream().map(ItemBundleRelationDgEo::getSubSkuId).collect(Collectors.toList());
            List<ItemSkuDgRespDto> itemSkuDgRespDtos = this.itemSkuDgService.queryItemSkuList(subSkuIds);
            Map<Long, ItemSkuDgRespDto> skuMap = itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getId, e -> e, (e1, e2) -> e1));
            ArrayList bundleItemDgRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(bundleItemDgRespDtos, (Collection)itemBundleRelationDgEos, BundleItemDgRespDto.class);
            bundleItemDgRespDtos.forEach(bundleItemDgRespDto -> bundleItemDgRespDto.setSubItemName(((ItemSkuDgRespDto)skuMap.get(bundleItemDgRespDto.getSubSkuId())).getName()));
            itemDetailDto.setBundleItemDtos(bundleItemDgRespDtos);
        }
        return itemDetailDto;
    }

    @Override
    public List<ItemDetailDgRespDto> listItemDetail(ItemDetailDgReqDto itemDetailDgReqDto) {
        logger.info("\u67e5\u8be2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5217\u8868 itemDetailReqDto : {}", (Object)itemDetailDgReqDto);
        List itemList = this.itemDgDomain.selectByIds(itemDetailDgReqDto.getItemIds());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemList)) {
            return Collections.emptyList();
        }
        ArrayList itemDetailList = Lists.newArrayList();
        ItemDgRespDto itemDto = new ItemDgRespDto();
        for (ItemDgEo itemDgEo : itemList) {
            ItemDetailDgRespDto itemDetailDto = new ItemDetailDgRespDto();
            List<ItemPropRelationDgRespDto> itemPropRelationDgRespDtos = this.propDgService.queryByItemId(itemDgEo.getId());
            itemDetailDto.setItemPropRelationDgRespDtos(itemPropRelationDgRespDtos);
            String propGroupInfo = itemDgEo.getPropGroupInfo();
            if (StringUtils.isNotBlank((CharSequence)propGroupInfo)) {
                List propGroupDtoList = JSON.parseArray((String)propGroupInfo, ItemPropGroupDgDto.class);
                itemDetailDto.setPropGroupDtoList(propGroupDtoList);
            }
            BeanUtil.copyProperties((Object)itemDgEo, (Object)itemDto, (String[])new String[0]);
            itemDto.setItemId(itemDgEo.getId());
            itemDetailDto.setItem(itemDto);
            itemDetailList.add(itemDetailDto);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemDetailDgReqDto.getFields())) {
            return itemDetailList;
        }
        for (String field : itemDetailDgReqDto.getFields()) {
            if (field.contains("sku")) {
                this.setItemSku(itemDetailList, itemDetailDgReqDto.getItemIds());
            }
            if (field.contains("attributes")) {
                this.setItemAttributes(itemDetailList, itemDetailDgReqDto.getItemIds());
            }
            if (!field.contains("medias")) continue;
            this.setItemMedias(itemDetailList, itemDetailDgReqDto.getItemIds());
        }
        for (ItemDetailDgRespDto itemDetailDto : itemDetailList) {
            List shopDirIdList;
            List<DirsItemsDgRespDto> dirsItemsDgRespDtos = this.dirItemRelationDgService.queryList(itemDetailDto.getItem().getItemId());
            itemDetailDto.setDirsItemsList(dirsItemsDgRespDtos);
            if (StringUtils.isNotBlank((CharSequence)itemDetailDto.getItem().getSaleChannel())) {
                itemDetailDto.setSaleChannels(Arrays.asList(itemDetailDto.getItem().getSaleChannel().split("-")));
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(shopDirIdList = dirsItemsDgRespDtos.stream().filter(dirsItemsRespDto -> Objects.equals("shop", dirsItemsRespDto.getDirType())).map(DirsItemsDgRespDto::getDirId).collect(Collectors.toList()))) continue;
            DirDgEo dirDgEo = DirDgEo.newInstance();
            dirDgEo.setId((Long)shopDirIdList.get(0));
            dirDgEo = (DirDgEo)this.dirDgDomain.selectOne((BaseEo)dirDgEo);
            itemDetailDto.setShopDirId(dirDgEo.getId());
            itemDetailDto.setShopDirName(dirDgEo.getName());
        }
        logger.info("\u67e5\u8be2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u8fd4\u56de ItemDetailRespDto : {}", (Object)itemDetailList);
        return itemDetailList;
    }

    @Override
    public void changeSaleStatus(ItemChangeSaleStatusReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getIds(), (String)"\u5bfc\u5165ID\u5217\u8868\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getIsSale(), (String)"\u662f\u5426\u5bfc\u5165\u9500\u552e\u5546\u54c1\u5e93\u4e3a\u7a7a");
        this.itemDgDomain.updateIsSaleStatusByIds(reqDto.getIds(), reqDto.getIsSale());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateItemLibDetail(ItemLibDetailDgReqDto itemDgReqDto) {
        AssertUtils.notNull((Object)itemDgReqDto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a");
        List<ItemMediasDgReqDto> mediaList = this.getMediaList(itemDgReqDto.getMediaMainList(), itemDgReqDto.getMediaDetailList(), itemDgReqDto.getMediaVideoList());
        Long itemId = itemDgReqDto.getId();
        AssertUtils.notNull((Object)itemId, (String)"\u5546\u54c1ID\u4e0d\u53ef\u4e3a\u7a7a");
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemId);
        AssertUtils.notNull((Object)itemDgEo, (String)"\u9500\u552e\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (Objects.isNull(itemDgEo.getDirPrefixId())) {
            AssertUtils.notNull((Object)itemDgReqDto.getDirPrefixId(), (String)"\u524d\u53f0\u7c7b\u76ee\u4e0d\u53ef\u4e3a\u7a7a");
        } else {
            ArrayList<Long> dirPrefixIds = new ArrayList<Long>();
            dirPrefixIds.add(itemDgReqDto.getDirPrefixId());
            Map<Long, List<DirDgEo>> parentByChildDriIds = this.dirDgService.getParentByChildDriIds(dirPrefixIds);
            List<DirDgEo> dirDgEos = parentByChildDriIds.get(itemDgReqDto.getDirPrefixId());
            AssertUtils.notEmpty(dirDgEos, (String)"\u524d\u53f0\u7c7b\u76ee\u4e0d\u5b58\u5728");
            for (DirDgEo dirDgEo : dirDgEos) {
                if (!itemDgReqDto.getDirPrefixId().equals(dirDgEo.getId())) continue;
                itemDgReqDto.setDirPrefixName(dirDgEo.getName());
            }
            itemDgReqDto.setDirPrefixLevel(String.valueOf(dirDgEos.size()));
        }
        AssertUtils.isTrue((boolean)ItemConstants.IS_SALE.equals(itemDgEo.getIsSale()), (String)"\u6b64\u5546\u54c1\u975e\u9500\u552e\u5546\u54c1");
        this.updateMediasList(itemId, mediaList);
        this.validSaleSkuSpecificationKey(itemDgReqDto.getSkuList(), itemDgEo);
        List skuList = itemDgReqDto.getSkuList();
        Integer isComplete = ItemConstants.IS_COMPLETE;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)skuList)) {
            ArrayList<Long> updateIds = new ArrayList<Long>();
            for (ItemLibSkuDgReqDto skuDgReqDto : skuList) {
                AssertUtils.notNull((Object)skuDgReqDto.getId(), (String)"\u7f16\u8f91sku\u4fe1\u606fskuId\u4e0d\u53ef\u4e3a\u7a7a!");
                updateIds.add(skuDgReqDto.getId());
            }
            Map<Long, ItemSkuDgEo> skuMap = this.getSkuMapByIds(updateIds, itemId);
            Map<Long, List<ItemMediasDgEo>> skuMediasEoMap = this.getSkuMediasEoMap(updateIds);
            for (ItemLibSkuDgReqDto skuDgReqDto : skuList) {
                ItemSkuDgEo itemSkuDgEo = skuMap.get(skuDgReqDto.getId());
                AssertUtils.notNull((Object)itemSkuDgEo, (String)"sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
                BeanUtil.copyProperties((Object)skuDgReqDto, (Object)itemSkuDgEo, (String[])new String[0]);
                this.itemSkuDgDomain.updateSelective((BaseEo)itemSkuDgEo);
                if (!Objects.isNull(itemSkuDgEo.getPackageNum()) && !Objects.isNull(itemSkuDgEo.getLength()) && !Objects.isNull(itemSkuDgEo.getHeight()) && !Objects.isNull(itemSkuDgEo.getWidth()) && !Objects.isNull(itemSkuDgEo.getSizeUnit()) && !Objects.isNull(itemSkuDgEo.getVolume()) && !Objects.isNull(itemSkuDgEo.getVolumeUnit()) && !CollectionUtil.isEmpty((Collection)skuMediasEoMap.get(itemSkuDgEo.getId()))) continue;
                isComplete = ItemConstants.NON_COMPLETE;
            }
            this.updateSkuMedia(itemDgReqDto.getSkuList());
        }
        this.updateSaleItem(itemDgReqDto, isComplete);
    }

    private Map<Long, List<ItemMediasDgEo>> getSkuMediasEoMap(List<Long> skuIds) {
        Map<Long, List<ItemMediasDgEo>> skuMediasMap = new HashMap<Long, List<ItemMediasDgEo>>();
        if (CollectionUtil.isEmpty(skuIds)) {
            return skuMediasMap;
        }
        List list = ((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().in((Object)"sku_id", skuIds)).list();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return skuMediasMap;
        }
        skuMediasMap = list.stream().collect(Collectors.groupingBy(ItemMediasDgEo::getSkuId));
        return skuMediasMap;
    }

    private Map<Long, ItemSkuDgEo> getSkuMapByIds(List<Long> skuIds, Long itemId) {
        Map<Long, Object> skuMap = new HashMap<Long, ItemSkuDgEo>();
        if (CollectionUtil.isEmpty(skuIds)) {
            return skuMap;
        }
        List updateEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"id", skuIds)).eq((Object)"item_id", (Object)itemId)).list();
        if (CollectionUtil.isEmpty((Collection)updateEos)) {
            return skuMap;
        }
        skuMap = updateEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        return skuMap;
    }

    private void updateSaleItem(ItemLibDetailDgReqDto itemDgReqDto, Integer isComplete) {
        Set specificationKeySet;
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().eq((Object)"item_id", (Object)itemDgReqDto.getId())).eq((Object)"biz_type", (Object)ItemMediaBizTypeEnum.MAIN_IMAGE.getType())).eq((Object)"item_type", (Object)ItemMediaItemTypeEnum.SPU.getType())).list();
        if (CollectionUtil.isEmpty((Collection)list)) {
            isComplete = ItemConstants.NON_COMPLETE;
        }
        ItemDgEo updateEo = new ItemDgEo();
        DtoHelper.dto2Eo((BaseVo)itemDgReqDto, (BaseEo)updateEo);
        updateEo.setIsComplete(isComplete);
        List skuDgEos = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().eq((Object)"item_id", (Object)itemDgReqDto.getId())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)skuDgEos) && org.apache.commons.collections.CollectionUtils.isNotEmpty(specificationKeySet = skuDgEos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSpecificationKey())).map(ItemSkuDgEo::getSpecificationKey).collect(Collectors.toSet()))) {
            updateEo.setSpecificationKeys(JacksonUtil.toJson(specificationKeySet));
        }
        this.itemDgDomain.updateSelective((BaseEo)updateEo);
    }

    private void updateSkuMedia(List<ItemLibSkuDgReqDto> skuList) {
        ArrayList eoList = Lists.newArrayList();
        ArrayList updateSkuIds = Lists.newArrayList();
        if (CollectionUtil.isEmpty(skuList)) {
            return;
        }
        List skuIds = skuList.stream().map(ItemLibSkuDgReqDto::getId).collect(Collectors.toList());
        List skuEoList = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"id", skuIds)).list();
        Map skuIdEoMap = skuEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (a, b) -> a));
        for (ItemLibSkuDgReqDto itemLibSkuDgReqDto : skuList) {
            ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)skuIdEoMap.get(itemLibSkuDgReqDto.getId());
            AssertUtils.notNull((Object)itemSkuDgEo, (String)(itemLibSkuDgReqDto.getId() + "\u6b64\u5546\u54c1\u89c4\u683c\u4e0d\u5b58\u5728"));
            updateSkuIds.add(itemSkuDgEo.getId());
            if (!Objects.nonNull(itemLibSkuDgReqDto.getUrl())) continue;
            ItemMediasDgEo eo = new ItemMediasDgEo();
            eo.setItemId(itemSkuDgEo.getItemId());
            eo.setSkuId(itemSkuDgEo.getId());
            eo.setPath1(itemLibSkuDgReqDto.getUrl());
            eo.setSort(Integer.valueOf(0));
            eo.setFileType(Integer.valueOf(0));
            String name = Objects.nonNull(itemLibSkuDgReqDto.getFileName()) ? itemLibSkuDgReqDto.getFileName() : itemSkuDgEo.getCode();
            eo.setName(name);
            eo.setBizType(ItemMediaBizTypeEnum.MAIN_IMAGE.getType());
            eo.setItemType(ItemMediaItemTypeEnum.SKU.getType());
            eoList.add(eo);
        }
        if (CollectionUtil.isNotEmpty((Collection)updateSkuIds)) {
            List deleteMediaEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().in((Object)"sku_id", (Collection)updateSkuIds)).eq((Object)"item_type", (Object)ItemMediaItemTypeEnum.SKU.getType())).list();
            if (CollectionUtil.isNotEmpty((Collection)deleteMediaEos)) {
                List deleteIds = deleteMediaEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.itemMediasDgDomain.logicDeleteByIds(deleteIds);
            }
            if (CollectionUtil.isNotEmpty((Collection)eoList)) {
                this.itemMediasDgDomain.insertBatch((List)eoList);
            }
        }
    }

    @Override
    public void updateShopItemDetail(ShopItemUpdateDgReqDto updateDgReqDto) {
        List<ItemMediasDgReqDto> mediaList = this.getMediaList(updateDgReqDto.getMediaMainList(), updateDgReqDto.getMediaDetailList(), updateDgReqDto.getMediaVideoList());
        AssertUtils.notNull((Object)updateDgReqDto.getId(), (String)"\u5e97\u94fa\u5546\u54c1id\u4e0d\u53ef\u4e3a\u7a7a");
        long count = updateDgReqDto.getSkuList().stream().filter(e -> Objects.equals(1, e.getDefaultShelf())).count();
        AssertUtils.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u540c\u4e00SPU\u4e0b\uff0c\u81f3\u5c11\u987b\u6709\u4e00\u4e2aSKU\u4e0a\u67b6");
        ItemShopDgEo itemShopDgEo = (ItemShopDgEo)this.itemShopDgDomain.selectById((Serializable)updateDgReqDto.getId());
        AssertUtils.notNull((Object)itemShopDgEo, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728!");
        Long itemId = itemShopDgEo.getItemId();
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemId);
        AssertUtils.notNull((Object)itemDgEo, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (Objects.isNull(itemDgEo.getDirPrefixId())) {
            AssertUtils.notNull((Object)updateDgReqDto.getDirPrefixId(), (String)"\u524d\u53f0\u7c7b\u76ee\u4e0d\u53ef\u4e3a\u7a7a");
        } else {
            ArrayList<Long> dirPrefixIds = new ArrayList<Long>();
            dirPrefixIds.add(updateDgReqDto.getDirPrefixId());
            Map<Long, List<DirDgEo>> parentByChildDriIds = this.dirDgService.getParentByChildDriIds(dirPrefixIds);
            List<DirDgEo> dirDgEos = parentByChildDriIds.get(updateDgReqDto.getDirPrefixId());
            AssertUtils.notEmpty(dirDgEos, (String)"\u524d\u53f0\u7c7b\u76ee\u4e0d\u5b58\u5728");
            for (DirDgEo dirDgEo : dirDgEos) {
                if (!updateDgReqDto.getDirPrefixId().equals(dirDgEo.getId())) continue;
                updateDgReqDto.setDirPrefixName(dirDgEo.getName());
            }
            updateDgReqDto.setDirPrefixLevel(String.valueOf(dirDgEos.size()));
        }
        AssertUtils.isTrue((boolean)ItemConstants.IS_SALE.equals(itemDgEo.getIsSale()), (String)"\u6b64\u5546\u54c1\u975e\u9500\u552e\u5546\u54c1");
        ItemDgEo updateEo = new ItemDgEo();
        DtoHelper.dto2Eo((BaseVo)updateDgReqDto, (BaseEo)updateEo);
        updateEo.setIsComplete(ItemConstants.IS_COMPLETE);
        updateEo.setId(itemDgEo.getId());
        if (Objects.nonNull(updateDgReqDto.getStockDisplay())) {
            itemShopDgEo.setStockDisplay(updateDgReqDto.getStockDisplay());
            this.itemShopDgDomain.updateSelective((BaseEo)itemShopDgEo);
            updateEo.setStockDisplay(null);
        }
        this.itemDgDomain.updateSelective((BaseEo)updateEo);
        this.updateMediasList(itemId, mediaList);
        List skuList = updateDgReqDto.getSkuList();
        this.updateSkuMedia(skuList);
        DgShopRespDto dgShopRespDto = (DgShopRespDto)this.dgShopQueryApiProxy.getShopDetailById(itemShopDgEo.getShopId()).getData();
        AssertUtils.notNull((Object)dgShopRespDto, (String)"\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map<Long, ShelfDgEo> shelfMap = this.getShelfList(itemId, itemShopDgEo.getShopId());
        this.insertShelf(skuList, dgShopRespDto, itemDgEo, shelfMap, itemShopDgEo);
    }

    private List<ItemMediasDgReqDto> getMediaList(List<ItemMediasDgReqDto> mediaMainList, List<ItemMediasDgReqDto> mediaDetailList, List<ItemMediasDgReqDto> mediaVideoList) {
        Integer fileType;
        ItemMediasDgReqDto itemMediasDgReqDto;
        int i;
        ArrayList<ItemMediasDgReqDto> mediaList = new ArrayList<ItemMediasDgReqDto>();
        if (CollectionUtil.isNotEmpty(mediaMainList)) {
            AssertUtils.isFalse((mediaMainList.size() > 9 ? 1 : 0) != 0, (String)"\u5546\u54c1\u4e3b\u56fe\u4e0d\u80fd\u8d85\u8fc79\u5f20");
            for (i = 0; i < mediaMainList.size(); ++i) {
                itemMediasDgReqDto = mediaMainList.get(i);
                itemMediasDgReqDto.setSort(Integer.valueOf(i));
                fileType = Objects.equals(1, itemMediasDgReqDto.getFileType()) ? itemMediasDgReqDto.getFileType() : 0;
                itemMediasDgReqDto.setFileType(fileType);
                itemMediasDgReqDto.setItemType(ItemMediaItemTypeEnum.SPU.getType());
                itemMediasDgReqDto.setBizType(ItemMediaBizTypeEnum.MAIN_IMAGE.getType());
                mediaList.add(itemMediasDgReqDto);
            }
        }
        if (CollectionUtil.isNotEmpty(mediaDetailList)) {
            AssertUtils.isFalse((mediaDetailList.size() > 9 ? 1 : 0) != 0, (String)"\u5546\u54c1\u8be6\u60c5\u56fe\u4e0d\u80fd\u8d85\u8fc79\u5f20");
            for (i = 0; i < mediaDetailList.size(); ++i) {
                itemMediasDgReqDto = mediaDetailList.get(i);
                itemMediasDgReqDto.setSort(Integer.valueOf(i));
                fileType = Objects.equals(1, itemMediasDgReqDto.getFileType()) ? itemMediasDgReqDto.getFileType() : 0;
                itemMediasDgReqDto.setFileType(fileType);
                itemMediasDgReqDto.setItemType(ItemMediaItemTypeEnum.SPU.getType());
                itemMediasDgReqDto.setBizType(ItemMediaBizTypeEnum.DETAIL_IMAGE.getType());
                mediaList.add(itemMediasDgReqDto);
            }
        }
        if (CollectionUtil.isNotEmpty(mediaVideoList)) {
            AssertUtils.isFalse((mediaVideoList.size() > 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u4e3b\u89c6\u9891\u4e0d\u80fd\u8d85\u8fc71\u4e2a");
            ItemMediasDgReqDto itemMediasDgReqDto2 = mediaVideoList.get(0);
            itemMediasDgReqDto2.setSort(Integer.valueOf(0));
            Integer fileType2 = Objects.equals(1, itemMediasDgReqDto2.getFileType()) ? itemMediasDgReqDto2.getFileType() : 0;
            itemMediasDgReqDto2.setFileType(fileType2);
            itemMediasDgReqDto2.setItemType(ItemMediaItemTypeEnum.SPU.getType());
            itemMediasDgReqDto2.setBizType(ItemMediaBizTypeEnum.MAIN_VIDEO.getType());
            mediaList.add(itemMediasDgReqDto2);
        }
        return mediaList;
    }

    private Map<Long, ShelfDgEo> getShelfList(Long itemId, Long shopId) {
        Map<Long, Object> shelfMap = new HashMap<Long, ShelfDgEo>();
        List shelfDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shelfDgDomain.filter().eq((Object)"shop_id", (Object)shopId)).eq((Object)"item_id", (Object)itemId)).list();
        if (CollectionUtil.isNotEmpty((Collection)shelfDgEos)) {
            shelfMap = shelfDgEos.stream().collect(Collectors.toMap(ShelfDgEo::getSkuId, Function.identity(), (k1, k2) -> k2));
        }
        return shelfMap;
    }

    private void insertShelf(List<ItemLibSkuDgReqDto> shopItemSkuList, DgShopRespDto dgShopRespDto, ItemDgEo itemDgEo, Map<Long, ShelfDgEo> shelfMap, ItemShopDgEo itemShopDgEo) {
        for (ItemLibSkuDgReqDto skuDgReqDto : shopItemSkuList) {
            ShelfDgEo shelfDgEo = shelfMap.get(skuDgReqDto.getId());
            AssertUtils.notNull((Object)skuDgReqDto.getDefaultShelf(), (String)"sku\u9ed8\u8ba4\u4e0a\u67b6\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
            if (ShelfStatusDgEnum.ON_SHELF.getCode() == skuDgReqDto.getDefaultShelf().intValue()) {
                if (Objects.isNull(shelfDgEo)) {
                    ItemSkuDgEo skuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectByPrimaryKey(skuDgReqDto.getId());
                    AssertUtils.notNull((Object)skuDgEo, (String)(skuDgEo.getId() + "sku\u4fe1\u606f\u4e0d\u5b58\u5728"));
                    ShelfDgEo shelfEo = this.getShelfDgEo(dgShopRespDto, itemDgEo, itemShopDgEo, skuDgEo.getId(), skuDgReqDto.getLimitMin());
                    this.shelfDgDomain.insert((BaseEo)shelfEo);
                    continue;
                }
                if (!Objects.nonNull(skuDgReqDto.getLimitMin())) continue;
                shelfDgEo.setLimitMin(skuDgReqDto.getLimitMin());
                this.shelfDgDomain.updateSelective((BaseEo)shelfDgEo);
                continue;
            }
            if (!Objects.nonNull(shelfDgEo)) continue;
            this.shelfDgDomain.logicDeleteById(shelfDgEo.getId());
        }
    }

    private ShelfDgEo getShelfDgEo(DgShopRespDto dgShopRespDto, ItemDgEo itemDgEo, ItemShopDgEo itemShopDgEo, Long skuId, Integer limitMin) {
        ShelfDgEo shelfEo = new ShelfDgEo();
        shelfEo.setShopId(dgShopRespDto.getId());
        shelfEo.setShopCode(dgShopRespDto.getStoreCode());
        shelfEo.setChannelId(dgShopRespDto.getChannelId());
        shelfEo.setChannelCode(dgShopRespDto.getChannelCode());
        shelfEo.setChannelName(dgShopRespDto.getChannelName());
        shelfEo.setType(itemDgEo.getType());
        shelfEo.setVersionId(itemDgEo.getVersion());
        shelfEo.setItemId(itemDgEo.getId());
        shelfEo.setSkuId(skuId);
        shelfEo.setStatus(itemShopDgEo.getStatus());
        shelfEo.setItemType(itemDgEo.getType());
        shelfEo.setBusType(itemDgEo.getBusType());
        shelfEo.setOrganizationId(itemDgEo.getOrganizationId());
        shelfEo.setOrganizationName(itemDgEo.getOrganizationName());
        shelfEo.setStockDisplay(itemShopDgEo.getStockDisplay());
        shelfEo.setLimitMin(limitMin);
        return shelfEo;
    }

    @Override
    public ItemDetailInfoDgRespDto queryItemLibDetailById(Long itemId) {
        ItemDetailInfoDgRespDto respDto = new ItemDetailInfoDgRespDto();
        ItemDgEo itemEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemId);
        if (Objects.isNull(itemEo)) {
            return null;
        }
        BeanUtil.copyProperties((Object)itemEo, (Object)respDto, (String[])new String[0]);
        if (respDto.getDirId() != null) {
            List dirEos = this.dirDgDomain.getParentByChildDriId(respDto.getDirId());
            List dirList = BeanUtil.copyToList((Collection)dirEos, DirRespDto.class);
            respDto.setDirName(this.makeDirName(dirEos));
            respDto.setDirList(dirList);
        }
        if (respDto.getDirPrefixId() != null) {
            List dirPrefixEos = this.dirDgDomain.getParentByChildDriId(respDto.getDirPrefixId());
            respDto.setDirPrefixName(this.makeDirName(dirPrefixEos));
            List prefixDirList = BeanUtil.copyToList((Collection)dirPrefixEos, DirRespDto.class);
            respDto.setPrefixDirList(prefixDirList);
        }
        List shopDgEos = ((ExtQueryChainWrapper)this.itemShopDgDomain.filter().eq((Object)"item_id", (Object)itemId)).list();
        ArrayList<ShopItemDgDto> shopDgDtoList = new ArrayList<ShopItemDgDto>();
        DtoHelper.eoList2DtoList((Collection)shopDgEos, shopDgDtoList, ShopItemDgDto.class);
        this.setShopName(shopDgDtoList);
        respDto.setItemShopDgDtoList(shopDgDtoList);
        List itemSkuEos = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().eq((Object)"item_id", (Object)itemId)).list();
        ArrayList skuDgRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemSkuEos, (Collection)skuDgRespDtos, ItemSkuDgRespDto.class);
        this.getSerialName(skuDgRespDtos);
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<String> unitCode = new ArrayList<String>();
        for (ItemSkuDgEo itemSkuEo : itemSkuEos) {
            skuIds.add(itemSkuEo.getId());
            if (Objects.nonNull(itemSkuEo.getSaleUnit())) {
                unitCode.add(itemSkuEo.getSaleUnit());
            }
            if (Objects.nonNull(itemSkuEo.getUnit())) {
                unitCode.add(itemSkuEo.getUnit());
            }
            if (!Objects.nonNull(itemSkuEo.getPriceUnit())) continue;
            unitCode.add(itemSkuEo.getPriceUnit());
        }
        Map<String, UnitDgEo> unitMap = this.getUnitMap(unitCode);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuIds)) {
            List unitConversionDgEos = ((ExtQueryChainWrapper)this.itemUnitConversionDgDomain.filter().in((Object)"sku_id", skuIds)).list();
            Object unitConversionMap = new HashedMap();
            if (CollectionUtil.isNotEmpty((Collection)unitConversionDgEos)) {
                unitConversionMap = unitConversionDgEos.stream().collect(Collectors.groupingBy(ItemUnitConversionDgEo::getSkuId));
            }
            List skuMediasEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().in((Object)"sku_id", skuIds)).eq((Object)"item_type", (Object)ItemMediaItemTypeEnum.SKU.getType())).eq((Object)"biz_type", (Object)ItemMediaBizTypeEnum.MAIN_IMAGE.getType())).list();
            Map skuMediaMap = skuMediasEos.stream().collect(Collectors.toMap(ItemMediasDgEo::getSkuId, Function.identity(), (a, b) -> a));
            for (ItemSkuDgRespDto dto : skuDgRespDtos) {
                ItemMediasDgEo itemMediasDgEo = (ItemMediasDgEo)skuMediaMap.get(dto.getId());
                if (itemMediasDgEo != null) {
                    ItemMediasDgRespDto mediasDgRespDto = new ItemMediasDgRespDto();
                    DtoHelper.eo2Dto((BaseEo)itemMediasDgEo, (BaseVo)mediasDgRespDto);
                    dto.setMedias(Collections.singletonList(mediasDgRespDto));
                }
                if (Objects.nonNull(unitMap.get(dto.getSaleUnit()))) {
                    dto.setSaleUnitName(unitMap.get(dto.getSaleUnit()).getName());
                }
                if (Objects.nonNull(unitMap.get(dto.getUnit()))) {
                    dto.setUnitName(unitMap.get(dto.getUnit()).getName());
                }
                if (!Objects.nonNull(unitMap.get(dto.getPriceUnit()))) continue;
                dto.setPriceUnitName(unitMap.get(dto.getPriceUnit()).getName());
            }
        }
        respDto.setSkuList((List)skuDgRespDtos);
        this.getSpuMedia(respDto, itemId);
        List rItemOrganizationDgEos = this.rItemOrganizationDgDomain.selectByItemId(itemId);
        if (CollectionUtil.isNotEmpty((Collection)rItemOrganizationDgEos)) {
            ArrayList<RItemOrganizationDgDto> rItemOrganizationDgDtos = new ArrayList<RItemOrganizationDgDto>();
            for (RItemOrganizationDgEo organizationDgEo : rItemOrganizationDgEos) {
                RItemOrganizationDgDto organizationDgDto = new RItemOrganizationDgDto();
                BeanUtil.copyProperties((Object)organizationDgEo, (Object)organizationDgDto, (String[])new String[0]);
                organizationDgDto.setOrganizationType(Objects.nonNull(organizationDgEo.getOrganizationType()) ? organizationDgEo.getOrganizationType() : ItemConstants.ITEM_ORGANIZATION_TYPE_SALE);
                rItemOrganizationDgDtos.add(organizationDgDto);
            }
            Map<Integer, List<RItemOrganizationDgDto>> organizationMap = rItemOrganizationDgDtos.stream().collect(Collectors.groupingBy(RItemOrganizationDgDto::getOrganizationType));
            respDto.setRItemOrganizationDgDtoList(organizationMap.get(ItemConstants.ITEM_ORGANIZATION_TYPE_SALE));
            respDto.setRItemFactoryList(organizationMap.get(ItemConstants.ITEM_ORGANIZATION_TYPE_FACTORY));
        }
        return respDto;
    }

    private void getSerialName(List<ItemSkuDgRespDto> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List serialIds = list.stream().filter(e -> Objects.nonNull(e.getSerialId())).map(ItemSkuDgRespDto::getSerialId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(serialIds)) {
            return;
        }
        List serialCodeEos = this.serialCodeDomain.selectByIds(serialIds);
        if (CollectionUtil.isEmpty((Collection)serialCodeEos)) {
            return;
        }
        Map serialMap = serialCodeEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        for (ItemSkuDgRespDto dgItemSkuRespDto : list) {
            SerialCodeEo serialCodeEo = (SerialCodeEo)serialMap.get(dgItemSkuRespDto.getSerialId());
            if (!Objects.nonNull(serialCodeEo)) continue;
            dgItemSkuRespDto.setSerialName(serialCodeEo.getName());
        }
    }

    private void setShopName(List<ShopItemDgDto> shopDgDtoList) {
        if (CollectionUtil.isEmpty(shopDgDtoList)) {
            return;
        }
        List<Long> shopIds = shopDgDtoList.stream().map(ShopItemDgDto::getShopId).collect(Collectors.toList());
        Map<Long, DgShopRespDto> shopInfo = this.getShopInfo(shopIds);
        for (ShopItemDgDto shopItemDgDto : shopDgDtoList) {
            DgShopRespDto dgShopRespDto = shopInfo.get(shopItemDgDto.getShopId());
            if (!Objects.nonNull(dgShopRespDto)) continue;
            shopItemDgDto.setShopName(dgShopRespDto.getStoreName());
        }
    }

    private Map<String, UnitDgEo> getUnitMap(List<String> unitCodes) {
        List unitDgEoList;
        Object unitMap = new HashedMap();
        if (CollectionUtil.isNotEmpty(unitCodes) && CollectionUtil.isNotEmpty((Collection)(unitDgEoList = ((ExtQueryChainWrapper)this.unitDgDomain.filter().in((Object)"code", unitCodes)).list()))) {
            unitMap = unitDgEoList.stream().collect(Collectors.toMap(UnitDgEo::getCode, Function.identity(), (k1, k2) -> k2));
        }
        return unitMap;
    }

    private void getSpuMedia(ItemDetailInfoDgRespDto respDto, Long itemId) {
        List itemMediasEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().eq((Object)"item_id", (Object)itemId)).eq((Object)"item_type", (Object)ItemMediaItemTypeEnum.SPU.getType())).list();
        if (CollectionUtil.isNotEmpty((Collection)itemMediasEos)) {
            ArrayList mediasDgRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemMediasEos, (Collection)mediasDgRespDtos, ItemMediasDgRespDto.class);
            Map<Integer, List<ItemMediasDgRespDto>> mediaMap = mediasDgRespDtos.stream().collect(Collectors.groupingBy(ItemMediasDgRespDto::getBizType));
            List<ItemMediasDgRespDto> mainMediasDgRespDtos = mediaMap.get(ItemMediaBizTypeEnum.MAIN_IMAGE.getType());
            List<ItemMediasDgRespDto> detailMediasDgRespDtos = mediaMap.get(ItemMediaBizTypeEnum.DETAIL_IMAGE.getType());
            List<ItemMediasDgRespDto> mainVideoList = mediaMap.get(ItemMediaBizTypeEnum.MAIN_VIDEO.getType());
            if (CollectionUtil.isNotEmpty(mainMediasDgRespDtos)) {
                respDto.setMediaMainList(mainMediasDgRespDtos.stream().sorted(Comparator.comparing(ItemMediasDgRespDto::getSort)).collect(Collectors.toList()));
            }
            if (CollectionUtil.isNotEmpty(detailMediasDgRespDtos)) {
                respDto.setMediaDetailList(detailMediasDgRespDtos.stream().sorted(Comparator.comparing(ItemMediasDgRespDto::getSort)).collect(Collectors.toList()));
            }
            if (CollectionUtil.isNotEmpty(mainVideoList)) {
                respDto.setMediaVideoList(mainVideoList.stream().sorted(Comparator.comparing(ItemMediasDgRespDto::getSort)).collect(Collectors.toList()));
            }
        }
    }

    private void getUnitConversion(ItemSkuDgRespDto dto, Map<Long, List<ItemUnitConversionDgEo>> unitConversionMap) {
        dto.setVolume(null);
        dto.setVolumeUnit(null);
        dto.setGrossWeight(null);
        dto.setNetWeight(null);
        dto.setWeightUnit(null);
        dto.setLength(null);
        dto.setHeight(null);
        dto.setWidth(null);
        dto.setSizeUnit(null);
        List<ItemUnitConversionDgEo> itemUnitConversionDgEos = unitConversionMap.get(dto.getId());
        if (Objects.nonNull(dto.getSaleUnit()) && CollectionUtil.isNotEmpty(itemUnitConversionDgEos)) {
            for (ItemUnitConversionDgEo conversionDgEo : itemUnitConversionDgEos) {
                if (!Objects.equals(conversionDgEo.getConversionUnit(), dto.getSaleUnit())) continue;
                dto.setVolume(conversionDgEo.getVolume());
                dto.setVolumeUnit(conversionDgEo.getVolumeUnit());
                dto.setGrossWeight(conversionDgEo.getGrossWeight());
                dto.setNetWeight(conversionDgEo.getNetWeight());
                dto.setWeightUnit(conversionDgEo.getWeightUnit());
                dto.setLength(conversionDgEo.getLength());
                dto.setHeight(conversionDgEo.getHeight());
                dto.setWidth(conversionDgEo.getWidth());
                dto.setSizeUnit(conversionDgEo.getSizeUnit());
                break;
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateItemFrontDirInfo(ItemBatchUpdateFrontDirReqDto reqDto) {
        ItemDgEo updateEo = new ItemDgEo();
        updateEo.setDirPrefixId(reqDto.getDirPrefixId());
        ArrayList<Long> dirPrefixIds = new ArrayList<Long>();
        dirPrefixIds.add(reqDto.getDirPrefixId());
        Map<Long, List<DirDgEo>> parentByChildDriIds = this.dirDgService.getParentByChildDriIds(dirPrefixIds);
        List<DirDgEo> dirDgEos = parentByChildDriIds.get(reqDto.getDirPrefixId());
        AssertUtils.notEmpty(dirDgEos, (String)"\u524d\u53f0\u7c7b\u76ee\u4e0d\u5b58\u5728");
        for (DirDgEo dirDgEo : dirDgEos) {
            if (!reqDto.getDirPrefixId().equals(dirDgEo.getId())) continue;
            updateEo.setDirPrefixName(dirDgEo.getName());
        }
        updateEo.setDirPrefixLevel(String.valueOf(dirDgEos.size()));
        this.itemDgDomain.getMapper().update((Object)updateEo, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, (Collection)reqDto.getIds()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void publishToShop(ItemLibPublishToShopDgReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getShopIds(), (String)"\u53d1\u5e03\u5e97\u94fa\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)reqDto.getItemIds(), (String)"\u53d1\u5e03\u5546\u54c1\u4e0d\u53ef\u4e3a\u7a7a");
        List itemDgEoList = this.itemDgDomain.selectByIds(reqDto.getItemIds());
        AssertUtils.notEmpty((Collection)itemDgEoList, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        HashMap<Long, ItemDgEo> itemEoMap = new HashMap<Long, ItemDgEo>();
        for (ItemDgEo itemDgEo : itemDgEoList) {
            AssertUtils.isTrue((boolean)Objects.equals(1, itemDgEo.getMarketStatus()), (String)(itemDgEo.getName() + "\u5546\u54c1\u4fe1\u606f\u4e3a\u9000\u5e02\u72b6\u6001,\u4e0d\u53ef\u53d1\u5e03\u81f3\u5e97\u94fa!"));
            itemEoMap.put(itemDgEo.getId(), itemDgEo);
        }
        List itemShopDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemShopDgDomain.filter().in((Object)"item_id", (Collection)reqDto.getItemIds())).in((Object)"shop_id", (Collection)reqDto.getShopIds())).list();
        List itemSkuDgEos = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"item_id", (Collection)reqDto.getItemIds())).list();
        AssertUtils.notEmpty((Collection)itemSkuDgEos, (String)"\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map<Long, List<ItemSkuDgEo>> skuEoMap = itemSkuDgEos.stream().collect(Collectors.groupingBy(ItemSkuDgEo::getItemId));
        Object itemShopMap = new HashedMap();
        if (CollectionUtil.isNotEmpty((Collection)itemShopDgEos)) {
            itemShopMap = itemShopDgEos.stream().collect(Collectors.groupingBy(ItemShopDgEo::getItemId, Collectors.mapping(ItemShopDgEo::getShopId, Collectors.toList())));
        }
        Map<Long, DgShopRespDto> shopMap = this.getShopInfo(reqDto.getShopIds());
        ArrayList insertItemShopDgEos = Lists.newArrayList();
        ArrayList insertShelfDgEos = Lists.newArrayList();
        List shopIds = reqDto.getShopIds();
        for (Long itemId : reqDto.getItemIds()) {
            ArrayList<Long> publishShopIds = new ArrayList<Long>();
            publishShopIds.addAll(shopIds);
            ItemDgEo itemDgEo = (ItemDgEo)itemEoMap.get(itemId);
            AssertUtils.notNull((Object)itemDgEo, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            List<ItemSkuDgEo> itemSkuDgEoList = skuEoMap.get(itemId);
            AssertUtils.notEmpty(itemSkuDgEoList, (String)(itemDgEo.getName() + "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728"));
            if (!Objects.equals(itemDgEo.getIsSale(), 1) || !Objects.equals(itemDgEo.getIsComplete(), 1)) {
                throw new BizException(itemDgEo.getName() + "\u6b64\u5546\u54c1\u672a\u5bfc\u5165\u5230\u5546\u54c1\u5e93\u6216\u672a\u5b8c\u5584");
            }
            List itemShopIds = (List)itemShopMap.get(itemId);
            if (CollectionUtil.isNotEmpty((Collection)itemShopIds)) {
                publishShopIds.removeAll(itemShopIds);
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(publishShopIds)) continue;
            this.getItemShopAndShelf(itemDgEo, itemSkuDgEoList, publishShopIds, shopMap, insertItemShopDgEos, insertShelfDgEos);
        }
        this.itemShopDgDomain.insertBatch((List)insertItemShopDgEos);
        this.shelfDgDomain.insertBatch((List)insertShelfDgEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> batchImportItemImages(ItemBatchImportImageReqDto reqDto) {
        List<Object> mediaEos = new ArrayList();
        ArrayList errorMsgs = Lists.newArrayList();
        switch (reqDto.getImageType()) {
            case 1: {
                mediaEos = this.createSpuImageMediaEoList(reqDto.getImages(), ItemMediaBizTypeEnum.MAIN_IMAGE.getType(), errorMsgs);
                break;
            }
            case 2: {
                mediaEos = this.createSkuMainImageMediaEoList(reqDto.getImages(), errorMsgs);
                break;
            }
            case 3: {
                mediaEos = this.createSpuImageMediaEoList(reqDto.getImages(), ItemMediaBizTypeEnum.DETAIL_IMAGE.getType(), errorMsgs);
                break;
            }
            default: {
                throw new BizException("\u672a\u77e5\u5bfc\u5165\u56fe\u7247\u7c7b\u578b");
            }
        }
        if (CollectionUtil.isNotEmpty(mediaEos)) {
            this.itemMediasDgDomain.insertBatch(mediaEos);
        }
        return errorMsgs;
    }

    @Override
    public PageInfo<ItemDgPageRespDto> queryItemLibByPage(ItemLibPageDgReqDto pageDto) {
        List<Long> dirIdList;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageDto.getShopIds())) {
            List itemShopDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemShopDgDomain.filter().in((Object)"shop_id", (Collection)pageDto.getShopIds())).in(CollectionUtil.isNotEmpty((Collection)pageDto.getIds()), (Object)"item_id", (Collection)pageDto.getIds())).select(new String[]{"DISTINCT item_id"}).list();
            if (CollectionUtil.isEmpty((Collection)itemShopDgEos)) {
                return new PageInfo();
            }
            List ids = itemShopDgEos.stream().map(ItemShopDgEo::getItemId).collect(Collectors.toList());
            pageDto.setIds(ids);
            pageDto.setShopIds(null);
        }
        if (CollectionUtil.isNotEmpty((Collection)pageDto.getDirIdList())) {
            dirIdList = this.dirDgService.getChildDirIdList(pageDto.getDirIdList(), pageDto.getInstanceId(), pageDto.getTenantId());
            if (CollectionUtil.isEmpty(dirIdList)) {
                return new PageInfo();
            }
            pageDto.setDirIdList(dirIdList);
        }
        if (CollectionUtil.isNotEmpty((Collection)pageDto.getDirPrefixIdList())) {
            dirIdList = this.dirDgService.getChildDirIdList(pageDto.getDirPrefixIdList(), pageDto.getInstanceId(), pageDto.getTenantId());
            if (CollectionUtil.isEmpty(dirIdList)) {
                return new PageInfo();
            }
            pageDto.setDirPrefixIdList(dirIdList);
        }
        ItemPageDgReqDto queryPageDto = (ItemPageDgReqDto)BeanUtil.copyProperties((Object)pageDto, ItemPageDgReqDto.class, (String[])new String[0]);
        queryPageDto.setIsSale(Integer.valueOf(1));
        PageInfo eoPageInfo = this.itemDgDomain.queryByConditionPage(queryPageDto);
        PageInfo<ItemDgPageRespDto> pageInfo = ConvertDgUtil.convertPage(eoPageInfo, ItemDgPageRespDto.class);
        this.fillItemLib(pageInfo.getList());
        this.setRItemOrganization(pageInfo.getList());
        return pageInfo;
    }

    @Override
    public ItemDetailInfoDgRespDto queryShopItemDetailById(Long id) {
        List rItemOrganizationDgEos;
        Map<Long, DgShopRespDto> shopMap;
        DgShopRespDto dgShopRespDto;
        ItemShopDgEo itemShopDgEo = (ItemShopDgEo)this.itemShopDgDomain.selectByPrimaryKey(id);
        AssertUtils.notNull((Object)itemShopDgEo, (String)"\u672a\u627e\u5230\u5e97\u94fa\u5546\u54c1");
        AssertUtils.notNull((Object)itemShopDgEo.getItemId(), (String)"\u9500\u552e\u5546\u54c1ID\u83b7\u53d6\u5931\u8d25");
        ItemDetailInfoDgRespDto itemLibDto = this.queryItemLibDetailById(itemShopDgEo.getItemId());
        if (Objects.isNull(itemLibDto)) {
            return itemLibDto;
        }
        itemLibDto.setStockDisplay(itemShopDgEo.getStockDisplay());
        itemLibDto.setStatus(itemShopDgEo.getStatus());
        if (Objects.nonNull(itemShopDgEo.getShopId()) && Objects.nonNull(dgShopRespDto = (shopMap = this.getShopInfo(Arrays.asList(itemShopDgEo.getShopId()))).get(itemShopDgEo.getShopId()))) {
            itemLibDto.setShopId(itemShopDgEo.getShopId());
            itemLibDto.setShopName(dgShopRespDto.getStoreName());
        }
        List shelfDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shelfDgDomain.filter().eq((Object)"item_id", (Object)itemShopDgEo.getItemId())).eq((Object)"shop_id", (Object)itemShopDgEo.getShopId())).list();
        Map shelfMap = shelfDgEos.stream().collect(Collectors.toMap(ShelfDgEo::getSkuId, Function.identity(), (k1, k2) -> k2));
        if (CollectionUtil.isNotEmpty((Collection)itemLibDto.getSkuList())) {
            this.setItemBundle(itemLibDto.getSkuList(), itemLibDto.getType());
            for (ItemSkuDgRespDto dto : itemLibDto.getSkuList()) {
                ShelfDgEo shelfDgEo = (ShelfDgEo)shelfMap.get(dto.getId());
                if (Objects.nonNull(shelfDgEo)) {
                    dto.setDefaultShelf(Integer.valueOf(1));
                    dto.setLimitMin(shelfDgEo.getLimitMin());
                    continue;
                }
                dto.setDefaultShelf(Integer.valueOf(0));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(rItemOrganizationDgEos = this.rItemOrganizationDgDomain.selectByItemId(itemShopDgEo.getItemId())))) {
            ArrayList<RItemOrganizationDgDto> rItemOrganizationDgDtos = new ArrayList<RItemOrganizationDgDto>();
            for (RItemOrganizationDgEo organizationDgEo : rItemOrganizationDgEos) {
                RItemOrganizationDgDto organizationDgDto = new RItemOrganizationDgDto();
                BeanUtil.copyProperties((Object)organizationDgEo, (Object)organizationDgDto, (String[])new String[0]);
                organizationDgDto.setOrganizationType(Objects.nonNull(organizationDgEo.getOrganizationType()) ? organizationDgEo.getOrganizationType() : ItemConstants.ITEM_ORGANIZATION_TYPE_SALE);
                rItemOrganizationDgDtos.add(organizationDgDto);
            }
            Map<Integer, List<RItemOrganizationDgDto>> organizationMap = rItemOrganizationDgDtos.stream().collect(Collectors.groupingBy(RItemOrganizationDgDto::getOrganizationType));
            itemLibDto.setRItemOrganizationDgDtoList(organizationMap.get(ItemConstants.ITEM_ORGANIZATION_TYPE_SALE));
            itemLibDto.setRItemFactoryList(organizationMap.get(ItemConstants.ITEM_ORGANIZATION_TYPE_FACTORY));
        }
        return itemLibDto;
    }

    @Override
    public PageInfo<ShopItemDgPageRespDto> queryShopItemByPage(ShopItemPageDgReqDto pageDto) {
        pageDto.setDirIdList(CollectionUtil.isNotEmpty((Collection)pageDto.getDirIdList()) ? this.dirDgService.getChildDirIdList(pageDto.getDirIdList(), pageDto.getInstanceId(), pageDto.getTenantId()) : null);
        pageDto.setDirPrefixIdList(CollectionUtil.isNotEmpty((Collection)pageDto.getDirPrefixIdList()) ? this.dirDgService.getChildDirIdList(pageDto.getDirPrefixIdList(), pageDto.getInstanceId(), pageDto.getTenantId()) : null);
        PageInfo pageInfo = this.itemShopDgDomain.queryShopItemByPage(pageDto);
        Set<Object> itemIds = Sets.newHashSet();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List itemMediasDgEos;
            List itemMediasDgRespDtoList;
            HashSet dirIds = Sets.newHashSet();
            itemIds = pageInfo.getList().stream().map(ShopItemDgPageRespDto::getItemId).collect(Collectors.toSet());
            List itemSkuDgEos = this.itemSkuDgDomain.selectByItemIds((List)Lists.newArrayList((Iterable)itemIds));
            Map skuListMap = itemSkuDgEos.stream().collect(Collectors.groupingBy(ItemSkuDgEo::getItemId, Collectors.toList()));
            List rItemOrganizationDgEos = this.rItemOrganizationDgDomain.selectByItemIds((List)Lists.newArrayList((Iterable)itemIds));
            Map rItemOrganizationDgMap = rItemOrganizationDgEos.stream().collect(Collectors.groupingBy(RItemOrganizationDgEo::getItemId, Collectors.toList()));
            ArrayList<Long> shopIds = new ArrayList<Long>();
            for (ShopItemDgPageRespDto shopItemDgPageRespDto : pageInfo.getList()) {
                if (Objects.nonNull(shopItemDgPageRespDto.getShopId())) {
                    shopIds.add(shopItemDgPageRespDto.getShopId());
                }
                if (shopItemDgPageRespDto.getDirId() != null) {
                    dirIds.add(shopItemDgPageRespDto.getDirId());
                }
                if (shopItemDgPageRespDto.getDirPrefixId() != null) {
                    dirIds.add(shopItemDgPageRespDto.getDirPrefixId());
                }
                if (skuListMap.containsKey(shopItemDgPageRespDto.getItemId())) {
                    List skuDgEoList = skuListMap.get(shopItemDgPageRespDto.getItemId());
                    List itemSkuDgRespDtos = BeanUtil.copyToList(skuDgEoList, ItemSkuDgRespDto.class);
                    shopItemDgPageRespDto.setItemSkuList(itemSkuDgRespDtos);
                }
                if (!rItemOrganizationDgMap.containsKey(shopItemDgPageRespDto.getItemId())) continue;
                List rItemOrganizationDgEoList = rItemOrganizationDgMap.get(shopItemDgPageRespDto.getItemId());
                List rItemOrganizationDgDtos = BeanUtil.copyToList(rItemOrganizationDgEoList, RItemOrganizationDgDto.class);
                shopItemDgPageRespDto.setRItemOrganizationDgDtoList(rItemOrganizationDgDtos);
            }
            Map<Object, Object> itemMediasListMap = Maps.newHashMap();
            if (pageDto.isFillSpuImgList() && CollUtil.isNotEmpty((Collection)(itemMediasDgRespDtoList = BeanUtil.copyToList((Collection)(itemMediasDgEos = this.itemMediasDgDomain.getSpuMainImgByItemIds((Collection)itemIds)), ItemMediasDgRespDto.class)))) {
                itemMediasListMap = itemMediasDgRespDtoList.stream().collect(Collectors.groupingBy(ItemMediasDgRespDto::getItemId, Collectors.toList()));
            }
            Map<Long, List<DirDgEo>> parentDirIdMap = this.dirDgService.getParentByChildDriIds(Lists.newArrayList((Iterable)dirIds));
            Map<Long, DgShopRespDto> shopMap = this.getShopInfo(shopIds);
            for (ShopItemDgPageRespDto shopItemDgPageRespDto : pageInfo.getList()) {
                DgShopRespDto dgShopRespDto;
                if (shopItemDgPageRespDto.getDirId() != null) {
                    List<DirDgEo> dirDgEos = parentDirIdMap.get(shopItemDgPageRespDto.getDirId());
                    shopItemDgPageRespDto.setDirName(this.makeDirName(dirDgEos));
                    shopItemDgPageRespDto.setDirList(ConvertDgUtil.copyToList(dirDgEos, DirRespDto.class));
                }
                if (Objects.nonNull(dgShopRespDto = shopMap.get(shopItemDgPageRespDto.getShopId()))) {
                    shopItemDgPageRespDto.setShopName(dgShopRespDto.getStoreName());
                }
                if (shopItemDgPageRespDto.getDirPrefixId() != null) {
                    List<DirDgEo> dirPrefixDgEos = parentDirIdMap.get(shopItemDgPageRespDto.getDirPrefixId());
                    shopItemDgPageRespDto.setDirPrefixName(this.makeDirName(dirPrefixDgEos));
                    shopItemDgPageRespDto.setDirPrefixList(ConvertDgUtil.copyToList(dirPrefixDgEos, DirRespDto.class));
                }
                if (!pageDto.isFillSpuImgList() || !itemMediasListMap.containsKey(shopItemDgPageRespDto.getItemId())) continue;
                List itemMediasDgRespDtoList2 = (List)itemMediasListMap.get(shopItemDgPageRespDto.getItemId());
                shopItemDgPageRespDto.setMediaMainList(itemMediasDgRespDtoList2);
            }
        }
        return pageInfo;
    }

    private void setItemBundle(List<ItemSkuDgRespDto> skuDtoList, Integer itemType) {
        if (CollectionUtil.isEmpty(skuDtoList) || ItemDgType.GENERAL.getIndex().equals(itemType)) {
            return;
        }
        List itemBundleRelationDgEoList = this.itemBundleRelationDgDomain.getListBySkuId(skuDtoList.stream().map(ItemSkuDgRespDto::getId).collect(Collectors.toList()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemBundleRelationDgEoList)) {
            Map<Long, List<ItemBundleRelationDgEo>> bundleItemRelationMap = itemBundleRelationDgEoList.stream().collect(Collectors.groupingBy(ItemBundleRelationDgEo::getSkuId));
            skuDtoList.forEach(skuDto -> {
                List<Object> bundleItemDgRespDtoList = Lists.newLinkedList();
                List itemBundleRelationDgEos = (List)bundleItemRelationMap.get(skuDto.getId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemBundleRelationDgEos)) {
                    List subSkuIdList = itemBundleRelationDgEos.stream().map(ItemBundleRelationDgEo::getSubSkuId).distinct().collect(Collectors.toList());
                    Map<Long, ItemSkuDgEo> subItemSkuEoMap = this.itemSkuDgDomain.selectItemSkuByIds(subSkuIdList).stream().collect(Collectors.toMap(BaseEo::getId, eo -> eo));
                    bundleItemDgRespDtoList = itemBundleRelationDgEos.stream().map(itemBundleRelationEo -> {
                        ItemSkuDgEo subItemSkuDgEo = (ItemSkuDgEo)subItemSkuEoMap.get(itemBundleRelationEo.getSubSkuId());
                        BundleItemDgRespDto bundleItemDgRespDto = new BundleItemDgRespDto();
                        bundleItemDgRespDto.setId(itemBundleRelationEo.getId());
                        bundleItemDgRespDto.setItemId(itemBundleRelationEo.getItemId());
                        bundleItemDgRespDto.setSubItemId(itemBundleRelationEo.getSubItemId());
                        ItemDgEo subItemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemBundleRelationEo.getSubItemId());
                        if (subItemDgEo != null) {
                            bundleItemDgRespDto.setSubItemName(subItemDgEo.getName());
                        }
                        bundleItemDgRespDto.setSkuId(itemBundleRelationEo.getSkuId());
                        bundleItemDgRespDto.setSubSkuId(itemBundleRelationEo.getSubSkuId());
                        if (subItemSkuDgEo != null) {
                            bundleItemDgRespDto.setSubSkuCode(subItemSkuDgEo.getCode());
                            bundleItemDgRespDto.setCargoCode(subItemSkuDgEo.getCargoCode());
                            bundleItemDgRespDto.setBarCode(subItemSkuDgEo.getBarCode());
                            bundleItemDgRespDto.setSafetyStock(subItemSkuDgEo.getSafetyStock());
                            bundleItemDgRespDto.setShelfAmount(subItemSkuDgEo.getShelfAmount());
                        }
                        bundleItemDgRespDto.setNum(itemBundleRelationEo.getNum());
                        return bundleItemDgRespDto;
                    }).collect(Collectors.toList());
                }
                skuDto.setBundleItemList((List)bundleItemDgRespDtoList);
            });
        }
    }

    private void getItemShopAndShelf(ItemDgEo itemDgEo, List<ItemSkuDgEo> itemSkuDgEoList, List<Long> shopIds, Map<Long, DgShopRespDto> shopMap, List<ItemShopDgEo> insertItemShopDgEos, List<ShelfDgEo> insertShelfDgEos) {
        AssertUtils.notNull((Object)itemDgEo.getStockDisplay(), (String)"\u5e93\u5b58\u663e\u793a\u672a\u5b8c\u5584,\u8bf7\u5148\u5b8c\u5584\u9500\u552e\u5546\u54c1\u4fe1\u606f");
        Map<Long, Integer> skuMap = itemSkuDgEoList.stream().collect(Collectors.toMap(BaseEo::getId, ItemSkuDgEo::getLimitMin, (a, b) -> a));
        Set<Long> skuIds = skuMap.keySet();
        HashSet<Long> shopIdList = new HashSet<Long>(shopIds);
        for (Long shopId : shopIdList) {
            ItemShopDgEo itemShopEo = new ItemShopDgEo();
            itemShopEo.setItemCode(itemDgEo.getCode());
            itemShopEo.setItemId(itemDgEo.getId());
            itemShopEo.setStockDisplay(itemDgEo.getStockDisplay());
            itemShopEo.setShopId(shopId);
            itemShopEo.setStatus(Integer.valueOf(ShelfStatusDgEnum.OFF_SHELF.getCode()));
            DgShopRespDto dgShopRespDto = shopMap.get(shopId);
            AssertUtils.notNull((Object)dgShopRespDto, (String)(shopId + "\u5e97\u94fa\u4e0d\u5b58\u5728"));
            itemShopEo.setShopName(dgShopRespDto.getStoreName());
            itemShopEo.setShopCode(dgShopRespDto.getStoreCode());
            insertItemShopDgEos.add(itemShopEo);
            for (Long skuId : skuIds) {
                ShelfDgEo shelfDgEo = this.getShelfDgEo(dgShopRespDto, itemDgEo, itemShopEo, skuId, skuMap.get(skuId));
                insertShelfDgEos.add(shelfDgEo);
            }
        }
    }

    private Map<Long, DgShopRespDto> getShopInfo(List<Long> shopIds) {
        Map<Long, Object> shopMap = new HashMap<Long, DgShopRespDto>();
        if (CollectionUtil.isEmpty(shopIds)) {
            return shopMap;
        }
        DgShopQueryReqDto shopQueryReqDto = new DgShopQueryReqDto();
        shopQueryReqDto.setIdList(shopIds);
        List shopToBBaseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgTobShopQueryApiProxy.queryListShop(shopQueryReqDto));
        shopMap = Optional.ofNullable(shopToBBaseRespDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k2));
        return shopMap;
    }

    private void updateMediasList(Long itemId, List<ItemMediasDgReqDto> mediaList) {
        if (CollectionUtil.isNotEmpty(mediaList)) {
            List removeIds = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().eq((Object)"item_id", (Object)itemId)).eq((Object)"item_type", (Object)ItemMediaItemTypeEnum.SPU.getType())).select(new String[]{"id"}).list().stream().map(BaseEo::getId).collect(Collectors.toList());
            ArrayList insertMediaReqDtos = Lists.newArrayList();
            for (ItemMediasDgReqDto reqDto : mediaList) {
                reqDto.setItemType(ItemMediaItemTypeEnum.SPU.getType());
                reqDto.setItemId(itemId);
                reqDto.setId(null);
                insertMediaReqDtos.add(reqDto);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(removeIds)) {
                this.itemMediasDgDomain.logicDeleteByIds(removeIds);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)insertMediaReqDtos)) {
                ArrayList insertMediaEos = Lists.newArrayList();
                DtoHelper.dtoList2EoList((Collection)insertMediaReqDtos, (Collection)insertMediaEos, ItemMediasDgEo.class);
                this.itemMediasDgDomain.insertBatch((List)insertMediaEos);
            }
        }
    }

    private void fillItemLib(List<ItemDgPageRespDto> list) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return;
        }
        this.setDirNameTree(list);
        List itemIds = list.stream().map(ItemDgPageRespDto::getId).collect(Collectors.toList());
        List itemShopDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemShopDgDomain.filter().in((Object)"item_id", itemIds)).orderByDesc((Object[])new String[]{"create_time", "id"})).list();
        List shopItemDgDtos = BeanUtil.copyToList((Collection)itemShopDgEos, ShopItemDgDto.class);
        this.setShopName(shopItemDgDtos);
        if (CollectionUtil.isNotEmpty((Collection)shopItemDgDtos)) {
            Map<Long, List<ShopItemDgDto>> itemShopMap = shopItemDgDtos.stream().collect(Collectors.groupingBy(ShopItemDgDto::getItemId));
            for (ItemDgPageRespDto itemDgPageRespDto : list) {
                List<ShopItemDgDto> itemShopDgDtoList = itemShopMap.get(itemDgPageRespDto.getId());
                if (!CollectionUtil.isNotEmpty(itemShopDgDtoList)) continue;
                itemDgPageRespDto.setItemShopDgDtoList(itemShopDgDtoList);
                String shopName = itemShopDgDtoList.stream().map(ShopItemDgDto::getShopName).collect(Collectors.joining(","));
                itemDgPageRespDto.setShopName(shopName);
            }
        }
    }

    private List<ItemMediasDgEo> createSpuImageMediaEoList(List<ItemBatchImportImageImageReqDto> images, Integer bizType, List<String> errorMsgs) {
        ArrayList eoList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(images)) {
            return eoList;
        }
        HashSet spuCodes = Sets.newHashSet();
        HashMap<String, String> imageMap = new HashMap<String, String>();
        for (ItemBatchImportImageImageReqDto image : images) {
            String fileName2 = image.getFileName();
            if (fileName2.contains("-") && fileName2.contains(".")) {
                imageMap.put(fileName2, image.getUrl());
                continue;
            }
            errorMsgs.add(fileName2 + "\u6587\u4ef6\u547d\u540d\u4e0d\u89c4\u8303!");
        }
        imageMap.forEach((fileName, url) -> {
            if (StringUtils.isBlank((CharSequence)url)) {
                errorMsgs.add(fileName + "\u6587\u4ef6URL\u4e3a\u7a7a");
                return;
            }
            String spuCode = fileName.substring(0, fileName.indexOf("-"));
            spuCodes.add(spuCode);
        });
        AssertUtils.notEmpty((Collection)spuCodes, (String)StringUtils.join(errorMsgs, (String)","));
        List itemList = ((ExtQueryChainWrapper)this.itemDgDomain.filter().in((Object)"code", (Collection)spuCodes)).select(new String[]{"id", "code"}).list();
        Map<String, Long> itemCodeIdMap = itemList.stream().collect(Collectors.toMap(ItemDgEo::getCode, BaseEo::getId, (a, b) -> a));
        imageMap.forEach((fileName, url) -> {
            if (StringUtils.isBlank((CharSequence)url)) {
                return;
            }
            String[] split = fileName.split("-");
            if (split.length != 2) {
                errorMsgs.add(fileName + "\u6587\u4ef6\u540d\u683c\u5f0f\u9519\u8bef");
                return;
            }
            String spuCode = split[0];
            String sort = split[1].substring(0, split[1].lastIndexOf("."));
            if (!StringUtils.isNumeric((CharSequence)sort)) {
                errorMsgs.add(fileName + "\u6587\u4ef6\u540d\u683c\u5f0f\u9519\u8bef");
                return;
            }
            if (Integer.valueOf(sort) > 9) {
                errorMsgs.add(fileName + "\u56fe\u7247\u547d\u540d\u6392\u5e8f\u4e0d\u80fd\u8d85\u8fc79\u5f20");
                return;
            }
            Long itemId = (Long)itemCodeIdMap.get(spuCode);
            if (itemId == null) {
                errorMsgs.add(fileName + "\u6587\u4ef6\uff0c\u672a\u627e\u5230SPU\u7f16\u7801\u4e3a" + spuCode + "\u7684\u5546\u54c1");
                return;
            }
            ItemMediasDgEo eo = new ItemMediasDgEo();
            eo.setItemId(itemId);
            eo.setPath1(url);
            eo.setFileType(Integer.valueOf(0));
            eo.setSort(Integer.valueOf(sort));
            eo.setBizType(bizType);
            eo.setItemType(ItemMediaItemTypeEnum.SPU.getType());
            eoList.add(eo);
        });
        AssertUtils.notEmpty((Collection)eoList, (String)"\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a!");
        List itemIds = eoList.stream().map(ItemMediasDgEo::getItemId).collect(Collectors.toList());
        AssertUtils.notEmpty(itemIds, (String)"\u5546\u54c1id\u5217\u8868\u4e3a\u7a7a!");
        List deleteMediaEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().in((Object)"item_id", itemIds)).eq((Object)"file_type", (Object)0)).eq((Object)"biz_type", (Object)bizType)).eq((Object)"item_type", (Object)ItemMediaItemTypeEnum.SPU.getType())).list();
        List<Object> deleteIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)deleteMediaEos)) {
            deleteIds = deleteMediaEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deleteIds)) {
            this.itemMediasDgDomain.logicDeleteByIds(deleteIds);
        }
        return eoList;
    }

    private List<ItemMediasDgEo> createSkuMainImageMediaEoList(List<ItemBatchImportImageImageReqDto> images, List<String> errorMsgs) {
        ArrayList eoList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(images)) {
            return eoList;
        }
        HashSet skuCodes = Sets.newHashSet();
        Map<String, String> imageMap = images.stream().collect(Collectors.toMap(ItemBatchImportImageImageReqDto::getFileName, ItemBatchImportImageImageReqDto::getUrl, (a, b) -> a));
        imageMap.forEach((fileName, url) -> {
            if (StringUtils.isBlank((CharSequence)url)) {
                errorMsgs.add(fileName + "\u6587\u4ef6URL\u4e3a\u7a7a");
                return;
            }
            String skuCode = fileName.substring(0, fileName.lastIndexOf("."));
            skuCodes.add(skuCode);
        });
        AssertUtils.notEmpty((Collection)skuCodes, (String)StringUtils.join(errorMsgs, (String)","));
        List skuList = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"code", (Collection)skuCodes)).list();
        Map skuCodeEoMap = skuList.stream().collect(Collectors.toMap(ItemSkuDgEo::getCode, Function.identity(), (a, b) -> a));
        ArrayList skuIds = Lists.newArrayList();
        imageMap.forEach((fileName, url) -> {
            if (StringUtils.isBlank((CharSequence)url)) {
                return;
            }
            String skuCode = fileName.substring(0, fileName.lastIndexOf("."));
            ItemSkuDgEo skuEo = (ItemSkuDgEo)skuCodeEoMap.get(skuCode);
            if (skuEo == null || StringUtils.isBlank((CharSequence)skuCode)) {
                errorMsgs.add(fileName + "\u6587\u4ef6\uff0c\u672a\u627e\u5230SKU\u7f16\u7801\u4e3a" + skuCode + "\u7684\u5546\u54c1");
                return;
            }
            ItemMediasDgEo eo = new ItemMediasDgEo();
            eo.setItemId(skuEo.getItemId());
            eo.setSkuId(skuEo.getId());
            eo.setPath1(url);
            eo.setFileType(Integer.valueOf(0));
            eo.setBizType(ItemMediaBizTypeEnum.MAIN_IMAGE.getType());
            eo.setItemType(ItemMediaItemTypeEnum.SKU.getType());
            eoList.add(eo);
            skuIds.add(skuEo.getId());
        });
        AssertUtils.notEmpty((Collection)skuIds, (String)"\u56fe\u7247\u547d\u540d\u672a\u627e\u5230\u5546\u54c1\u89c4\u683c\u4fe1\u606f");
        List deleteMediaEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().in((Object)"sku_id", (Collection)skuIds)).eq((Object)"item_type", (Object)ItemMediaItemTypeEnum.SKU.getType())).list();
        List<Object> deleteIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)deleteMediaEos)) {
            deleteIds = deleteMediaEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deleteIds)) {
            this.itemMediasDgDomain.logicDeleteByIds(deleteIds);
        }
        return eoList;
    }

    private void setItemSku(List<ItemDetailDgRespDto> itemDetailList, List<Long> itemIds) {
        Map<Long, List<ItemSkuDgRespDto>> skuMap = this.getItemSkuDtoMap(this.itemSkuDgService.queryDetailsByItemIds(itemIds));
        for (ItemDetailDgRespDto itemDetail : itemDetailList) {
            itemDetail.setItemSkuList(skuMap.get(itemDetail.getItem().getId()));
        }
    }

    private void getItemSkuDgRespDto(List<ItemSkuDgRespDto> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List<Long> skuIds = list.stream().map(ItemSkuDgRespDto::getId).distinct().collect(Collectors.toList());
        List itemMediasDgEos = ((ExtQueryChainWrapper)this.itemMediasDgDomain.filter().in((Object)"sku_id", skuIds)).list();
        Map<Object, Object> mediasDgEoMap = new HashMap();
        HashMap<Long, List<ItemUnitConversionDgDto>> itemUnitConversion = new HashMap<Long, List<ItemUnitConversionDgDto>>();
        if (CollectionUtil.isNotEmpty((Collection)itemMediasDgEos)) {
            ArrayList itemMediasDgRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(itemMediasDgRespDtos, (Collection)itemMediasDgEos, ItemMediasDgRespDto.class);
            mediasDgEoMap = itemMediasDgRespDtos.stream().filter(e -> Objects.nonNull(e.getSkuId())).collect(Collectors.groupingBy(ItemMediasDgRespDto::getSkuId));
        }
        this.getItemUnitConversions(skuIds, itemUnitConversion);
        for (ItemSkuDgRespDto itemSkuDgRespDto : list) {
            itemSkuDgRespDto.setMedias((List)mediasDgEoMap.get(itemSkuDgRespDto.getId()));
            itemSkuDgRespDto.setItemUnitConversionDgDtos((List)itemUnitConversion.get(itemSkuDgRespDto.getId()));
        }
    }

    private void getItemUnitConversions(List<Long> skuIds, Map<Long, List<ItemUnitConversionDgDto>> itemUnitConversion) {
        if (CollectionUtil.isEmpty(skuIds)) {
            return;
        }
        if ("close".equals(this.unitConversion)) {
            List<ItemUnitConversionDgDto> defaultItemUnitConversions = this.getDefaultItemUnitConversions();
            for (Long skuId : skuIds) {
                itemUnitConversion.put(skuId, defaultItemUnitConversions);
            }
        } else {
            List itemUnitConversionDgEos = this.itemUnitConversionDgDomain.selectBySkuIds(skuIds);
            if (CollectionUtil.isEmpty((Collection)itemUnitConversionDgEos)) {
                return;
            }
            Map<Long, List<ItemUnitConversionDgEo>> map = itemUnitConversionDgEos.stream().filter(e -> Objects.nonNull(e.getSkuId())).collect(Collectors.groupingBy(ItemUnitConversionDgEo::getSkuId));
            for (Long skuId : skuIds) {
                ArrayList unitConversionDgDtos = new ArrayList();
                List<ItemUnitConversionDgEo> unitConversionDgEos = map.get(skuId);
                CubeBeanUtils.copyCollection(unitConversionDgDtos, unitConversionDgEos, ItemUnitConversionDgDto.class);
                itemUnitConversion.put(skuId, unitConversionDgDtos);
            }
        }
    }

    private List<ItemUnitConversionDgDto> getDefaultItemUnitConversions() {
        ArrayList itemUnitConversionDgDtos = Lists.newArrayList();
        ItemUnitConversionDgDto unitConversionDgDto = new ItemUnitConversionDgDto();
        unitConversionDgDto.setConversionNum(ItemDgConstant.ITEM_UNIT_CONVERSION_DEFAULT_NUM);
        unitConversionDgDto.setConversionUnit("\u9ed8\u8ba4\u5355\u4f4d");
        itemUnitConversionDgDtos.add(unitConversionDgDto);
        return itemUnitConversionDgDtos;
    }

    private void setItemAttributes(List<ItemDetailDgRespDto> itemDetailList, List<Long> itemIds) {
        List<ItemAttributesDgEo> itemAttributesList = this.itemAttributesDgService.queryByItemIds(itemIds);
        ItemAttributesDgRespDto itemAttributesDgRespDto = null;
        for (ItemDetailDgRespDto itemDetail : itemDetailList) {
            itemDetail.setItemAttributesList((List)Lists.newArrayList());
            for (ItemAttributesDgEo itemAttribute : itemAttributesList) {
                if (!Objects.equals(itemDetail.getItem().getId(), itemAttribute.getItemId())) continue;
                itemAttributesDgRespDto = new ItemAttributesDgRespDto();
                BeanUtil.copyProperties((Object)itemAttribute, (Object)itemAttributesDgRespDto, (String[])new String[0]);
                itemDetail.getItemAttributesList().add(itemAttributesDgRespDto);
            }
        }
    }

    private Map<String, ItemUnitConversionDgDto> getDefaultUnitList(ItemExchangeUnitDgReqDto reqDto) {
        HashMap<String, ItemUnitConversionDgDto> unitMap = new HashMap<String, ItemUnitConversionDgDto>();
        ItemUnitConversionDgDto currentUnit = new ItemUnitConversionDgDto();
        currentUnit.setConversionUnit(reqDto.getCurrentUnit());
        currentUnit.setConversionNum(BigDecimal.ONE);
        unitMap.put(currentUnit.getConversionUnit(), currentUnit);
        return unitMap;
    }

    private void getUnitList(Long skuId, Map<String, ItemUnitConversionDgDto> unitMap) {
        ArrayList<Long> skuIds = new ArrayList<Long>();
        skuIds.add(skuId);
        List itemUnitConversionDgEos = this.itemUnitConversionDgDomain.selectBySkuIds(skuIds);
        if (CollectionUtil.isNotEmpty((Collection)itemUnitConversionDgEos)) {
            for (ItemUnitConversionDgEo itemUnitConversionDgEo : itemUnitConversionDgEos) {
                ItemUnitConversionDgDto currentUnit = new ItemUnitConversionDgDto();
                BeanUtil.copyProperties((Object)itemUnitConversionDgEo, (Object)currentUnit, (String[])new String[0]);
                unitMap.put(currentUnit.getConversionUnit(), currentUnit);
            }
        }
    }

    private ItemExchangeUnitDgRespDto getexchangeUnitResp(ItemExchangeUnitDgReqDto reqDto, Map<String, ItemUnitConversionDgDto> unitMap, ItemSkuDgEo skuDgEo, ItemDgEo itemDgEo) {
        String targetUnit = Objects.nonNull(reqDto.getTargetUnit()) ? reqDto.getTargetUnit() : reqDto.getCurrentUnit();
        ItemExchangeUnitDgRespDto exchangeUnitDgRespDto = new ItemExchangeUnitDgRespDto();
        ItemUnitConversionDgDto unitConversionDgDto = unitMap.get(reqDto.getCurrentUnit());
        ItemUnitConversionDgDto targetConversionDgDto = unitMap.get(reqDto.getTargetUnit());
        AssertUtils.notNull((Object)unitConversionDgDto, (String)(reqDto.getSkuCode() + "\u6362\u7b97\u5355\u4f4d\u4fe1\u606f\u4e0d\u5b58\u5728" + JSON.toJSONString(unitMap)));
        BigDecimal currentBase = Objects.nonNull(unitConversionDgDto.getBaseUnitNum()) ? unitConversionDgDto.getBaseUnitNum() : BigDecimal.ONE;
        BigDecimal currentConversionNum = Objects.nonNull(unitConversionDgDto.getConversionNum()) ? unitConversionDgDto.getConversionNum() : BigDecimal.ONE;
        BigDecimal baseNum = Objects.nonNull(unitConversionDgDto.getConversionNum()) ? reqDto.getCurrentNum().multiply(currentConversionNum).divide(currentBase, 6, 1) : BigDecimal.ZERO;
        BigDecimal costPrice = Objects.nonNull(skuDgEo.getCostPrice()) ? skuDgEo.getCostPrice() : BigDecimal.ZERO;
        BigDecimal retailPrice = Objects.nonNull(skuDgEo.getRetailPrice()) ? skuDgEo.getRetailPrice() : BigDecimal.ZERO;
        BigDecimal volume = Objects.nonNull(skuDgEo.getVolume()) ? skuDgEo.getVolume() : BigDecimal.ZERO;
        BigDecimal grossWeight = Objects.nonNull(skuDgEo.getGrossWeight()) ? skuDgEo.getGrossWeight() : BigDecimal.ZERO;
        BigDecimal netWeight = Objects.nonNull(skuDgEo.getNetWeight()) ? skuDgEo.getNetWeight() : BigDecimal.ZERO;
        costPrice = baseNum.multiply(costPrice);
        retailPrice = baseNum.multiply(retailPrice);
        volume = baseNum.multiply(volume);
        grossWeight = baseNum.multiply(grossWeight);
        netWeight = baseNum.multiply(netWeight);
        exchangeUnitDgRespDto.setCode(skuDgEo.getCode());
        exchangeUnitDgRespDto.setCurrentUnit(reqDto.getCurrentUnit());
        exchangeUnitDgRespDto.setCurrentNum(reqDto.getCurrentNum());
        exchangeUnitDgRespDto.setName(skuDgEo.getName());
        exchangeUnitDgRespDto.setItemId(skuDgEo.getItemId());
        exchangeUnitDgRespDto.setItemCode(itemDgEo.getCode());
        exchangeUnitDgRespDto.setItemName(itemDgEo.getName());
        exchangeUnitDgRespDto.setDisplayName(itemDgEo.getDisplayName());
        exchangeUnitDgRespDto.setCostPrice(costPrice);
        exchangeUnitDgRespDto.setGrossWeight(grossWeight);
        exchangeUnitDgRespDto.setGrossWeightUnit(skuDgEo.getGrossWeightUnit());
        exchangeUnitDgRespDto.setNetWeight(netWeight);
        exchangeUnitDgRespDto.setNetWeightUnit(skuDgEo.getNetWeightUnit());
        exchangeUnitDgRespDto.setVolume(volume);
        exchangeUnitDgRespDto.setVolumeUnit(skuDgEo.getVolumeUnit());
        exchangeUnitDgRespDto.setRetailPrice(retailPrice);
        exchangeUnitDgRespDto.setLineNo(reqDto.getLineNo());
        if (Objects.nonNull(targetConversionDgDto)) {
            BigDecimal targetBase = Objects.nonNull(targetConversionDgDto.getBaseUnitNum()) ? targetConversionDgDto.getBaseUnitNum() : BigDecimal.ONE;
            BigDecimal targetConversionNum = Objects.nonNull(targetConversionDgDto.getConversionNum()) ? targetConversionDgDto.getConversionNum() : BigDecimal.ONE;
            exchangeUnitDgRespDto.setTargetUnit(targetUnit);
            exchangeUnitDgRespDto.setTargetNum(baseNum.divide(targetConversionNum, 6, 1).multiply(targetBase));
        }
        return exchangeUnitDgRespDto;
    }

    private void setItemMedias(List<ItemDetailDgRespDto> itemDetailList, List<Long> itemIds) {
        List<ItemMediasDgRespDto> itemMediasList = this.itemMediasDgService.queryByItemIds(itemIds);
        for (ItemDetailDgRespDto itemDetail : itemDetailList) {
            itemDetail.setItemMediasList((List)Lists.newArrayList());
            for (ItemMediasDgRespDto itemMedia : itemMediasList) {
                if (!Objects.equals(itemDetail.getItem().getId(), itemMedia.getItemId())) continue;
                itemDetail.getItemMediasList().add(itemMedia);
            }
        }
    }

    private void insertItemSkuSnapshot(ItemChangeApplyDgDto changeApply) {
        HashMap<String, Object> snapshotMap = new HashMap<String, Object>();
        snapshotMap.put("item", this.itemDgDomain.selectById((Serializable)changeApply.getItemId()));
        ItemSkuSnapshotDgEo snapshotDgEo = new ItemSkuSnapshotDgEo();
        snapshotDgEo.setItemCode(changeApply.getItemCode());
        snapshotDgEo.setItemId(changeApply.getItemId());
        for (ItemBundleDgReqDto skus : changeApply.getSkus()) {
            DgItemSkuDetailRespDto itemSkuDetailRespDto = this.itemSkuDgService.getItemSkuDetailById(skus.getId());
            AssertUtils.notNull((Object)itemSkuDetailRespDto, (String)"\u65b0\u589e\u5546\u54c1\u5feb\u7167,sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
            snapshotMap.put("sku", itemSkuDetailRespDto);
            snapshotDgEo.setSkuCode(skus.getCode());
            snapshotDgEo.setSkuId(skus.getId());
            snapshotDgEo.setKeyWord(skus.getId().toString() + itemSkuDetailRespDto.getVersion());
            snapshotDgEo.setContent(JSON.toJSONString(snapshotMap));
            snapshotDgEo.setVersions(Integer.valueOf(itemSkuDetailRespDto.getVersion().intValue()));
            this.iItemSkuSnapshotDgDomain.insert((BaseEo)snapshotDgEo);
        }
    }

    private List<DgItemSkuDetailRespDto> listSkuDetailBySkuIds(Long skuIds) {
        ItemQueryDgReqDto dto = new ItemQueryDgReqDto();
        dto.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{skuIds}));
        List<DgItemSkuDetailRespDto> detail = this.itemSkuDgService.querySkuList(dto);
        return detail;
    }

    @Override
    public List<ItemDgRespDto> queryItemListByItemCodes(List<String> itemCodes) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemDgDomain.filter().orderByDesc((Object)"id");
        sqlFilters.in((Object)"code", itemCodes);
        List eoList = sqlFilters.list();
        List<Object> dtoList = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eoList)) {
            List dirIds = eoList.stream().map(ItemDgEo::getDirId).distinct().collect(Collectors.toList());
            Map<Object, Object> dirDgEoMap = Maps.newHashMap();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dirIds)) {
                List dirDgEos = ((ExtQueryChainWrapper)this.dirDgDomain.filter().in((Object)"id", dirIds)).list();
                dirDgEoMap = dirDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
            }
            HashMap finalDirDgEoMap = dirDgEoMap;
            dtoList = eoList.stream().map(v -> {
                ItemDgRespDto respDto = new ItemDgRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
                if (finalDirDgEoMap.containsKey(v.getDirId())) {
                    DirDgEo dgEo = (DirDgEo)finalDirDgEoMap.get(v.getDirId());
                    respDto.setDirId(v.getDirId());
                    respDto.setDirName(dgEo.getName());
                    respDto.setItemId(v.getId());
                }
                return respDto;
            }).collect(Collectors.toList());
        }
        return dtoList;
    }

    @Override
    public List<ShopItemDgDto> listShopItemByIds(List<Long> ids) {
        List itemShopDgEos = this.itemShopDgDomain.selectByIds(ids);
        return BeanConvertUtil.copyToList((Collection)itemShopDgEos, ShopItemDgDto.class);
    }

    @Override
    public List<ItemAllSuperiorRespDto> allSuperiorNodesByItemIds(List<String> itemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            return null;
        }
        List itemDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemDgDomain.filter().in((Object)"code", itemCodes)).eq((Object)"dr", (Object)0)).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemDgEos)) {
            return null;
        }
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)itemDgEos, ItemAllSuperiorRespDto.class);
        ArrayList result = Lists.newArrayList();
        List oneDirDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDgDomain.filter().eq((Object)"dr", (Object)0)).eq((Object)"parent_id", (Object)1335378778777943050L)).list();
        List twoDirDgEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)oneDirDgEos)) {
            for (DirDgEo oneDirDgEo : oneDirDgEos) {
                String s = oneDirDgEo.getId().toString();
                result.add(s);
            }
            twoDirDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDgDomain.filter().eq((Object)"dr", (Object)0)).in((Object)"parent_id", (Collection)oneDirDgEos.stream().map(BaseEo::getId).collect(Collectors.toList()))).list();
        }
        List threeDirDgEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)twoDirDgEos)) {
            for (DirDgEo twoDirDgEo : twoDirDgEos) {
                String s = twoDirDgEo.getParentId().toString().concat(",").concat(twoDirDgEo.getId().toString());
                result.add(s);
            }
            threeDirDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDgDomain.filter().eq((Object)"dr", (Object)0)).in((Object)"parent_id", (Collection)twoDirDgEos.stream().map(BaseEo::getId).collect(Collectors.toList()))).list();
        }
        List fourDirDgEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)threeDirDgEos)) {
            for (DirDgEo threeDirDgEo : threeDirDgEos) {
                for (DirDgEo twoDirDgEo : twoDirDgEos) {
                    if (!twoDirDgEo.getId().equals(threeDirDgEo.getParentId())) continue;
                    String s = twoDirDgEo.getParentId().toString().concat(",").concat(twoDirDgEo.getId().toString()).concat(",").concat(threeDirDgEo.getId().toString());
                    result.add(s);
                }
            }
            fourDirDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDgDomain.filter().eq((Object)"dr", (Object)0)).in((Object)"parent_id", (Collection)threeDirDgEos.stream().map(BaseEo::getId).collect(Collectors.toList()))).list();
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)fourDirDgEos)) {
            for (DirDgEo fourDirDgEo : fourDirDgEos) {
                for (DirDgEo threeDirDgEo : threeDirDgEos) {
                    if (!threeDirDgEo.getId().equals(fourDirDgEo.getParentId())) continue;
                    for (DirDgEo twoDirDgEo : twoDirDgEos) {
                        if (!twoDirDgEo.getId().equals(threeDirDgEo.getParentId())) continue;
                        String s = twoDirDgEo.getParentId().toString().concat(",").concat(twoDirDgEo.getId().toString()).concat(",").concat(threeDirDgEo.getId().toString()).concat(",").concat(fourDirDgEo.getId().toString());
                        result.add(s);
                    }
                }
            }
        }
        logger.info("\u5c06\u6811\u6574\u4e2a\u5e73\u94fa\u5f00\uff0c\u83b7\u53d6\u5230\u7684\u6240\u6709\u4ece\u6839\u8282\u70b9\u5230\u672b\u7ea7\u8282\u70b9\u7684\u8282\u70b9\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)result));
        for (ItemAllSuperiorRespDto respDto : respDtos) {
            for (String key : result) {
                if (!Objects.nonNull(respDto.getDirId()) || !key.contains(respDto.getDirId().toString())) continue;
                respDto.setNodeIds(key);
            }
        }
        logger.info("\u8fd4\u56de\u7684\u5546\u54c1\u5173\u8054\u7684\u6240\u6709\u4e0a\u7ea7\u8282\u70b9\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)respDtos));
        return respDtos;
    }

    @Override
    public ItemDetailInfoDgRespDto queryShopItemDetailByShopIdAndItemId(Long shopId, Long itemId) {
        ItemShopDgEo itemShopDgEo = (ItemShopDgEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemShopDgDomain.filter().eq((Object)"item_id", (Object)itemId)).eq((Object)"shop_id", (Object)shopId)).one();
        if (Objects.isNull(itemShopDgEo)) {
            return null;
        }
        return this.queryShopItemDetailById(itemShopDgEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importItemInfo(List<ItemChangeApplyDgDto> changeApplyDgDtoList) {
        for (ItemChangeApplyDgDto itemChangeApplyDgDto : changeApplyDgDtoList) {
            this.addItem(itemChangeApplyDgDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long initFreightItem(FreightItemReq freightItemReq) {
        ItemDgEo itemDgEo = this.itemDgDomain.selectByItemCode("YF00000001");
        List shopRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgTobShopQueryApiProxy.queryListShop(new DgShopQueryReqDto()));
        if (freightItemReq.getFreightItemFlag().booleanValue()) {
            if (Objects.nonNull(itemDgEo)) {
                List<Long> shopIds = this.filterShopId(itemDgEo.getId());
                if (CollUtil.isEmpty(shopIds)) {
                    logger.info("\u8fd0\u8d39\u5546\u54c1\u5e97\u94fa\u6570\u636e\u4e3a\u7a7a,\u5546\u54c1\u540d\u79f0:{}", (Object)itemDgEo.getName());
                    return itemDgEo.getId();
                }
                ItemOnShelfDgReqDto onShelfDgReqDto = new ItemOnShelfDgReqDto();
                ArrayList shelfItemInfoDgReqDtoList = Lists.newArrayList();
                for (DgShopRespDto dgShopRespDto : shopRespDtoList) {
                    if (!shopIds.contains(dgShopRespDto.getId())) continue;
                    ShelfItemInfoDgReqDto shelfItemInfoDgReqDto = new ShelfItemInfoDgReqDto();
                    shelfItemInfoDgReqDto.setShopId(dgShopRespDto.getId());
                    shelfItemInfoDgReqDto.setItemId(itemDgEo.getId());
                    shelfItemInfoDgReqDtoList.add(shelfItemInfoDgReqDto);
                }
                onShelfDgReqDto.setShelfItemInfoDgReqDtos((List)shelfItemInfoDgReqDtoList);
                FreightItemEsDto freightItemEsDto = new FreightItemEsDto();
                freightItemEsDto.setType("2");
                freightItemEsDto.setMessage(JSONObject.toJSONString((Object)onShelfDgReqDto));
                this.itemFreightProducer.sendItemFreightMessage(freightItemEsDto);
                return itemDgEo.getId();
            }
            ItemChangeApplyDgDto changeApplyDgDto = this.fillItemChangeApplyDgDto();
            Long itemId = this.addItem(changeApplyDgDto);
            List itemSkuDgEoList = this.itemSkuDgDomain.selectByItemId(itemId);
            MarketSkuDto marketSkuDto = new MarketSkuDto();
            marketSkuDto.setSkuIdList((List)Lists.newArrayList((Object[])new Long[]{((ItemSkuDgEo)itemSkuDgEoList.get(0)).getId()}));
            ArrayList itemShopDgDtoList = Lists.newArrayList();
            for (DgShopRespDto dgShopRespDto : shopRespDtoList) {
                ItemShopDgDto itemShopDgDto = new ItemShopDgDto();
                itemShopDgDto.setShopId(dgShopRespDto.getId());
                itemShopDgDto.setShopName(dgShopRespDto.getStoreName());
                itemShopDgDto.setShopCode(dgShopRespDto.getStoreCode());
                itemShopDgDtoList.add(itemShopDgDto);
            }
            marketSkuDto.setItemShopDgDtoList((List)itemShopDgDtoList);
            FreightItemEsDto freightItemEsDto = new FreightItemEsDto();
            freightItemEsDto.setType("1");
            freightItemEsDto.setMessage(JSONObject.toJSONString((Object)marketSkuDto));
            this.itemFreightProducer.sendItemFreightMessage(freightItemEsDto);
            return itemId;
        }
        if (Objects.isNull(itemDgEo)) {
            logger.info("\u67e5\u8be2\u4e0d\u5230\u8fd0\u8d39\u5546\u54c1,\u8fd0\u8d39\u5f00\u5173:{}", (Object)freightItemReq.getFreightItemFlag());
            return null;
        }
        this.batchOffItem(shopRespDtoList, itemDgEo);
        return itemDgEo.getId();
    }

    private List<Long> filterShopId(Long itemId) {
        List itemShopDgEoList = this.itemShopDgDomain.queryByItemId(itemId);
        if (CollUtil.isEmpty((Collection)itemShopDgEoList)) {
            return null;
        }
        return itemShopDgEoList.stream().map(ItemShopDgEo::getShopId).collect(Collectors.toList());
    }

    private void batchOffItem(List<DgShopRespDto> shopRespDtoList, ItemDgEo itemDgEo) {
        ItemOffShelfDgReqDto offShelfDgReqDto = new ItemOffShelfDgReqDto();
        ArrayList offShelfItemDgReqDtoList = Lists.newArrayList();
        List<Long> shopIds = this.filterShopId(itemDgEo.getId());
        if (CollUtil.isEmpty(shopIds)) {
            logger.info("\u4e0b\u67b6\u8fd0\u8d39\u5546\u54c1\u5e97\u94fa\u6570\u636e\u4e3a\u7a7a,\u5546\u54c1\u540d\u79f0:{}", (Object)itemDgEo.getName());
            return;
        }
        for (DgShopRespDto dgShopRespDto : shopRespDtoList) {
            if (!shopIds.contains(dgShopRespDto.getId())) continue;
            OffShelfItemDgReqDto shelfItemDgReqDto = new OffShelfItemDgReqDto();
            shelfItemDgReqDto.setItemId(itemDgEo.getId());
            shelfItemDgReqDto.setShopId(dgShopRespDto.getId());
            offShelfItemDgReqDtoList.add(shelfItemDgReqDto);
        }
        offShelfDgReqDto.setOffShelfItemDgReqDtos((List)offShelfItemDgReqDtoList);
        FreightItemEsDto freightItemEsDto = new FreightItemEsDto();
        freightItemEsDto.setType("3");
        freightItemEsDto.setMessage(JSONObject.toJSONString((Object)offShelfDgReqDto));
        this.itemFreightProducer.sendItemFreightMessage(freightItemEsDto);
    }

    private ItemChangeApplyDgDto fillItemChangeApplyDgDto() {
        ItemChangeApplyDgDto changeApply = new ItemChangeApplyDgDto();
        changeApply.setItemCode("YF00000001");
        changeApply.setItemName("\u8865\u8fd0\u8d39\u5dee\u4ef7\u4e13\u7528-\u4e0d\u53c2\u4e0e\u8425\u9500");
        changeApply.setItemAttribute(ItemDgItemAttributeEnum.ITEM_FREIGHT.getType());
        changeApply.setSubType(Integer.valueOf(2));
        changeApply.setDirId(Long.valueOf(1335378778777943050L));
        changeApply.setDirName("\u540e\u53f0\u6839\u7c7b\u76ee");
        ItemBundleDgReqDto itemBundleDgReqDto = new ItemBundleDgReqDto();
        itemBundleDgReqDto.setCode("YF00000001");
        itemBundleDgReqDto.setName("\u8865\u8fd0\u8d39\u5dee\u4ef7\u4e13\u7528-\u4e0d\u53c2\u4e0e\u8425\u9500");
        itemBundleDgReqDto.setUnit("pcs");
        itemBundleDgReqDto.setRetailPrice(BigDecimal.ONE);
        itemBundleDgReqDto.setMoreBar(YesNoEnum.NO.getValue());
        itemBundleDgReqDto.setEliminate(YesNoEnum.NO.getValue());
        itemBundleDgReqDto.setPriceUnit("pcs");
        itemBundleDgReqDto.setSaleUnit("ge");
        ItemUnitConversionDgDto unitConversionDgDto = new ItemUnitConversionDgDto();
        unitConversionDgDto.setConversionUnit("pcs");
        unitConversionDgDto.setSizeUnit("mm");
        unitConversionDgDto.setVolumeUnit("m\u00b3");
        unitConversionDgDto.setWeightUnit("kg");
        unitConversionDgDto.setBaseUnit("pcs");
        unitConversionDgDto.setBaseUnitNum(BigDecimal.ONE);
        unitConversionDgDto.setConversionNum(BigDecimal.ONE);
        ItemUnitConversionDgDto unitConversionDgDto2 = new ItemUnitConversionDgDto();
        unitConversionDgDto2.setConversionUnit("ge");
        unitConversionDgDto2.setSizeUnit("mm");
        unitConversionDgDto2.setVolumeUnit("m\u00b3");
        unitConversionDgDto2.setWeightUnit("kg");
        unitConversionDgDto2.setBaseUnit("pcs");
        unitConversionDgDto2.setBaseUnitNum(BigDecimal.ONE);
        unitConversionDgDto2.setConversionNum(BigDecimal.ONE);
        ArrayList itemUnitConversionDgDtoList = Lists.newArrayList((Object[])new ItemUnitConversionDgDto[]{unitConversionDgDto, unitConversionDgDto2});
        itemBundleDgReqDto.setItemUnitConversions((List)itemUnitConversionDgDtoList);
        ArrayList skus = Lists.newArrayList((Object[])new ItemBundleDgReqDto[]{itemBundleDgReqDto});
        changeApply.setSkus((List)skus);
        return changeApply;
    }
}

