/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.api.IIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.ShapeType;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.GeoShapeFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.QueryFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.GeoDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.constants.ShelfStatusDgEnum;
import com.yunxi.dg.base.center.item.dao.vo.ItemSearchIndexMessageDgVo;
import com.yunxi.dg.base.center.item.domain.entity.IDirItemRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemAttributesDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IStatDgDomain;
import com.yunxi.dg.base.center.item.dto.DistributionFeeDgDto;
import com.yunxi.dg.base.center.item.dto.ItemMessageDg;
import com.yunxi.dg.base.center.item.dto.request.ItemSearchQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.CoordinateDgDto;
import com.yunxi.dg.base.center.item.dto.response.ItemAttributesDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSearchDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShopDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.LocationDgDto;
import com.yunxi.dg.base.center.item.dto.response.TemplateRegionDgRespDto;
import com.yunxi.dg.base.center.item.eo.DirItemRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemAttributesDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.center.item.eo.StatDgEo;
import com.yunxi.dg.base.center.item.event.ItemShelfDgProducer;
import com.yunxi.dg.base.center.item.service.entity.IDistributionSetDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSearchDgService;
import com.yunxi.dg.base.center.item.service.util.ConvertDgUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;

@Component
@MQDesc(tag="ITEM_SEARCH_INDEX_DG")
public class ItemSearchDgServiceImpl
implements IItemSearchDgService,
IMessageProcessor {
    private Logger logger = LoggerFactory.getLogger(ItemSearchDgServiceImpl.class);
    @Value(value="${huieryun.searchindexbuilder.indexname.prefix}")
    private String INDEX_ITEM;
    @Value(value="${cube.global.profile:dev}")
    private String globalProfile;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Autowired(required=false)
    private IDistributionSetDgService distributionSetDgService;
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IStatDgDomain statDgDomain;
    @Resource
    private IShelfDgDomain shelfDgDomain;
    @Resource
    private IItemAttributesDgDomain itemAttributesDgDomain;
    @Resource
    private IDirItemRelationDgDomain dirItemRelationDgDomain;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource(name="restSearchExtDgService")
    private IOpenSearchService openSearchService;
    @Resource
    private ISearchIndexService searchIndexService;
    @Resource
    private IIndicesAdminService indicesAdminService;
    @Resource
    private IShopApi shopApi;
    @Resource
    private ItemShelfDgProducer itemShelfDgProducer;
    @Value(value="${huieryun.searchindexbuilder.item.indexname:item_search}")
    private String indexName;
    @Value(value="${huieryun.searchindexbuilder.item.indextype:item_search}")
    private String indexType;

    @Deprecated
    public void initIndex() {
        if (this.indicesAdminService.existsIndex(new String[]{this.getIndexName()})) {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15{}\u5df2\u5b58\u5728\uff0c\u4e0d\u518d\u8fdb\u884c\u81ea\u52a8\u521b\u5efa=====", (Object)this.getIndexName());
        }
        String mapping = null;
        try {
            File jsonFile = ResourceUtils.getFile((String)"classpath:item_index_mapping.json");
            mapping = FileUtils.readFileToString((File)jsonFile, (String)"utf-8");
        }
        catch (Exception e) {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
        }
        this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15\u6587\u4ef6\u5185\u5bb9 {}", (Object)mapping);
        if (StringUtils.isBlank((CharSequence)mapping)) {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15mapping\u4e3a\u7a7a\uff0c\u81ea\u52a8\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u521d\u59cb\u5316es\u76f8\u5173\u64cd\u4f5c=====", (Object)this.getIndexName());
            return;
        }
        try {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15{}\u81ea\u52a8\u521b\u5efa\u6210\u529f=====", (Object)this.getIndexName());
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15{}\u81ea\u52a8\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
        try {
            this.indicesAdminService.putMapping(this.getIndexName() + "ws", "item_search", mapping.toString());
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15mapping\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }

    private String getIndexName() {
        return this.INDEX_ITEM + "_" + "item_search";
    }

    @Override
    public void index(long sellerId, long itemId, int busType, String operation) {
        this.logger.info("\u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5230ES,sellerId:{},itemId:{},busType:{},operation:{}", new Object[]{sellerId, itemId, busType, operation});
        this.index(sellerId, itemId, busType, operation, 0);
    }

    @Override
    public void indexSyn(long sellerId, long itemId, int busType, String operation) {
        this.logger.info("\u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5230ES,sellerId:{},itemId:{},busType:{},operation:{}", new Object[]{sellerId, itemId, busType, operation});
        this.indexSyn(sellerId, itemId, busType, operation, 0);
    }

    private void index(Long sellerId, Long itemId, Integer busType, String operation, int retry) {
        if (retry > 3) {
            this.logger.error("\u7d22\u5f15\u91cd\u590d\u6784\u5efa\u8d85\u8fc73\u6b21\uff0c\u5546\u54c1ID\u4e3a:{}\u8bf7\u68c0\u67e5", (Object)itemId);
            return;
        }
        ItemSearchIndexMessageDgVo itemSearchIndexMessageDgVo = new ItemSearchIndexMessageDgVo(sellerId.longValue(), itemId.longValue(), busType.intValue(), operation, Integer.valueOf(retry));
        itemSearchIndexMessageDgVo.setMessageId(this.generateId());
        this.refreshIndex(itemSearchIndexMessageDgVo);
        this.logger.info("\u5f00\u59cb\u53d1\u9001es\u540c\u6b65\u6d88\u606f\uff0cmessage:{}", (Object)JSON.toJSONString((Object)itemSearchIndexMessageDgVo));
        this.commonsMqService.sendSingleMessage("ITEM_SEARCH_INDEX_DG", (Object)JSON.toJSONString((Object)itemSearchIndexMessageDgVo));
    }

    private void indexSyn(Long sellerId, Long itemId, Integer busType, String operation, int retry) {
        if (retry > 3) {
            this.logger.error("\u7d22\u5f15\u91cd\u590d\u6784\u5efa\u8d85\u8fc73\u6b21\uff0c\u5546\u54c1ID\u4e3a:{}\u8bf7\u68c0\u67e5", (Object)itemId);
            return;
        }
        ItemSearchIndexMessageDgVo itemSearchIndexMessageDgVo = new ItemSearchIndexMessageDgVo(sellerId.longValue(), itemId.longValue(), busType.intValue(), operation, Integer.valueOf(retry));
        this.refreshIndex(itemSearchIndexMessageDgVo);
    }

    @Override
    public ItemSearchDgRespDto query(ItemSearchQueryDgReqDto itemSearchQueryDgReqDto, Integer pageNum, Integer pageSize) {
        if (itemSearchQueryDgReqDto.getType() == null) {
            itemSearchQueryDgReqDto.setType(itemSearchQueryDgReqDto.getItemType());
        }
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setPage(pageNum.intValue());
        osSearchVo.setPageSize(pageSize.intValue());
        if (itemSearchQueryDgReqDto.getTenantId() != null) {
            osSearchVo.addEqualFilter("tenantId", String.valueOf(itemSearchQueryDgReqDto.getTenantId()));
        }
        if (itemSearchQueryDgReqDto.getInstanceId() != null) {
            osSearchVo.addEqualFilter("instanceId", String.valueOf(itemSearchQueryDgReqDto.getInstanceId()));
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryDgReqDto.getKeyword())) {
            QueryFieldVo queryFieldVo = QueryFieldVo.query((String)itemSearchQueryDgReqDto.getKeyword(), (String[])new String[]{"name", "displayName", "brand", "code"});
            queryFieldVo.setEscape(true);
            osSearchVo.addQueries(new QueryFieldVo[]{queryFieldVo});
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryDgReqDto.getItemCode())) {
            osSearchVo.addEqualFilter("code", itemSearchQueryDgReqDto.getItemCode());
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryDgReqDto.getItemSkuCode())) {
            osSearchVo.addEqualFilter("itemSkuList.code", itemSearchQueryDgReqDto.getItemSkuCode());
        }
        if (itemSearchQueryDgReqDto.getBackDirId() != null) {
            osSearchVo.addEqualFilter("dirId", String.valueOf(itemSearchQueryDgReqDto.getBackDirId()));
        }
        if (itemSearchQueryDgReqDto.getType() != null) {
            osSearchVo.addEqualFilter("type", String.valueOf(itemSearchQueryDgReqDto.getType()));
        }
        if (Objects.nonNull(itemSearchQueryDgReqDto.getSubType())) {
            osSearchVo.addEqualFilter("subType", String.valueOf(itemSearchQueryDgReqDto.getSubType()));
        }
        if (CollUtil.isNotEmpty((Collection)itemSearchQueryDgReqDto.getSubTypeList())) {
            osSearchVo.addInFilter("subType", ConvertDgUtil.convert2Array(itemSearchQueryDgReqDto.getSubTypeList()));
        }
        if (itemSearchQueryDgReqDto.getType() == null && itemSearchQueryDgReqDto.getNeType() != null) {
            osSearchVo.addNonEqualFilter("type", String.valueOf(itemSearchQueryDgReqDto.getType()));
        }
        if (CollectionUtils.isEmpty((Collection)itemSearchQueryDgReqDto.getBusTypeList())) {
            if (itemSearchQueryDgReqDto.getBusType() != null) {
                osSearchVo.addEqualFilter("busType", String.valueOf(itemSearchQueryDgReqDto.getBusType()));
            }
        } else {
            String[] buyTypes = ConvertDgUtil.convert2Array(itemSearchQueryDgReqDto.getBusTypeList());
            osSearchVo.addInFilter("busType", buyTypes);
        }
        if (itemSearchQueryDgReqDto.getBrandId() != null) {
            osSearchVo.addEqualFilter("brandId", String.valueOf(itemSearchQueryDgReqDto.getBrandId()));
        }
        if (itemSearchQueryDgReqDto.getStatus() != null) {
            osSearchVo.addInFilter("itemShelfInfoList.status", new String[]{String.valueOf(itemSearchQueryDgReqDto.getStatus())});
        }
        if (itemSearchQueryDgReqDto.getStatus() == null && BooleanUtils.isTrue((Boolean)itemSearchQueryDgReqDto.getIsOffShelf())) {
            osSearchVo.addInFilter("itemShelfInfoList.status", new String[]{String.valueOf(ShelfStatusDgEnum.ON_SHELF.getCode())});
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryDgReqDto.getInBrandIds())) {
            String[] inBrandIds = ConvertDgUtil.convert2Array(itemSearchQueryDgReqDto.getInBrandIds());
            String[] compound = FilterFieldVo.compound((LogicalSymbol)LogicalSymbol.AND);
            FilterFieldVo in = FilterFieldVo.in((String)"brandId", (String[])inBrandIds);
            in.setLogicalSymbol(LogicalSymbol.OR);
            FilterFieldVo equal = FilterFieldVo.equal((String)"brandId", (String)"0");
            equal.setLogicalSymbol(LogicalSymbol.OR);
            compound.addSubFilterFieldVos(new FilterFieldVo[]{in, equal});
            osSearchVo.addFilters(new FilterFieldVo[]{compound});
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryDgReqDto.getItemIds())) {
            String[] itemIds = ConvertDgUtil.convert2Array(itemSearchQueryDgReqDto.getItemIds());
            osSearchVo.addInFilter("dirsItemsList.itemId", itemIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryDgReqDto.getInItemIds())) {
            String[] inItemIds = ConvertDgUtil.convert2Array(itemSearchQueryDgReqDto.getInItemIds());
            osSearchVo.addInFilter("dirsItemsList.itemId", inItemIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryDgReqDto.getOutItemIds())) {
            String[] outInItemIds = ConvertDgUtil.convert2Array(itemSearchQueryDgReqDto.getOutItemIds());
            osSearchVo.addNonInFilter("dirsItemsList.itemId", outInItemIds);
        }
        if (itemSearchQueryDgReqDto.getSellerId() != null) {
            String sellerId = String.valueOf(itemSearchQueryDgReqDto.getSellerId());
            osSearchVo.addEqualFilter("dirsItemsList.sellerId", sellerId);
        }
        if (itemSearchQueryDgReqDto.getShopId() != null) {
            String shopId = String.valueOf(itemSearchQueryDgReqDto.getShopId());
            osSearchVo.addEqualFilter("itemShopList.shopId", shopId);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryDgReqDto.getShopIds())) {
            String[] shopIds = ConvertDgUtil.convert2Array(itemSearchQueryDgReqDto.getShopIds());
            osSearchVo.addInFilter("itemShopList.shopId", shopIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryDgReqDto.getDirIds())) {
            String[] dirIds = ConvertDgUtil.convert2Array(itemSearchQueryDgReqDto.getDirIds());
            osSearchVo.addInFilter("dirsItemsList.dirId", dirIds);
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryDgReqDto.getProp())) {
            String[] props;
            for (String prop : props = itemSearchQueryDgReqDto.getProp().split(";")) {
                String[] searchData = prop.split(":");
                osSearchVo.addInFilter("searchAttr.searchAttr.name", searchData);
            }
        }
        if (itemSearchQueryDgReqDto.getLat() != null && itemSearchQueryDgReqDto.getLon() != null) {
            GeoShapeFieldVo.PointType pointType = new GeoShapeFieldVo.PointType(itemSearchQueryDgReqDto.getLat().doubleValue(), itemSearchQueryDgReqDto.getLon().doubleValue());
            GeoShapeFieldVo geoShapeFieldVo = new GeoShapeFieldVo("itemShopList.templateRegionList", ShapeType.POINT, pointType);
            osSearchVo.addGeoShapeQuery(new GeoShapeFieldVo[]{geoShapeFieldVo});
        }
        if (itemSearchQueryDgReqDto.getMinPrice() != null || itemSearchQueryDgReqDto.getMaxPrice() != null) {
            if (itemSearchQueryDgReqDto.getMinPrice() != null && itemSearchQueryDgReqDto.getMaxPrice() != null) {
                osSearchVo.addRangeFilter("minPrice", String.valueOf(itemSearchQueryDgReqDto.getMinPrice()), String.valueOf(itemSearchQueryDgReqDto.getMaxPrice()));
            } else {
                osSearchVo.addRangeFilter("minPrice", String.valueOf(itemSearchQueryDgReqDto.getMinPrice()), String.valueOf(itemSearchQueryDgReqDto.getMaxPrice()), LogicalSymbol.OR);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryDgReqDto.getOrderByDesc())) {
            if ("sales".equalsIgnoreCase(itemSearchQueryDgReqDto.getOrderByDesc())) {
                osSearchVo.addSort("salesCount");
            } else if ("price".equalsIgnoreCase(itemSearchQueryDgReqDto.getOrderByDesc())) {
                osSearchVo.addSort("minPrice");
            } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryDgReqDto.getOrderByDesc())) {
                osSearchVo.addSort("itemShelfInfoList.shelfTime");
            } else if ("code".equalsIgnoreCase(itemSearchQueryDgReqDto.getOrderByDesc())) {
                osSearchVo.addSort("code");
            }
        } else if (StringUtils.isNotBlank((CharSequence)itemSearchQueryDgReqDto.getOrderBy())) {
            if ("sales".equalsIgnoreCase(itemSearchQueryDgReqDto.getOrderBy())) {
                osSearchVo.addSort("salesCount", SortOrder.ASC);
            } else if ("price".equalsIgnoreCase(itemSearchQueryDgReqDto.getOrderBy())) {
                osSearchVo.addSort("minPrice", SortOrder.ASC);
            } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryDgReqDto.getOrderBy())) {
                osSearchVo.addSort("itemShelfInfoList.shelfTime", SortOrder.ASC);
            } else if ("code".equalsIgnoreCase(itemSearchQueryDgReqDto.getOrderBy())) {
                osSearchVo.addSort("code", SortOrder.ASC);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryDgReqDto.getUpdateBeginTime()) && StringUtils.isNotBlank((CharSequence)itemSearchQueryDgReqDto.getUpdateEndTime())) {
            osSearchVo.addRangeFilter("updateTime", itemSearchQueryDgReqDto.getUpdateBeginTime(), itemSearchQueryDgReqDto.getUpdateEndTime());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5546\u54c1\u641c\u7d22\u53c2\u6570osSearchVo={}", (Object)JSON.toJSONString((Object)osSearchVo));
        }
        SearchResultVo searchResultVo = this.search(osSearchVo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5546\u54c1\u641c\u7d22\u7ed3\u679csearchResultVo={}", (Object)JSON.toJSONString((Object)searchResultVo));
        }
        ItemSearchDgRespDto itemSearchDgRespDto = new ItemSearchDgRespDto();
        if (searchResultVo == null) {
            return itemSearchDgRespDto;
        }
        List itemDgRespDtoList = searchResultVo.getDocValues(docValue -> (ItemDgRespDto)BeanUtil.mapToBean((Map)docValue, ItemDgRespDto.class, (boolean)true));
        this.handleItemShop(itemDgRespDtoList, itemSearchDgRespDto, itemSearchQueryDgReqDto);
        itemDgRespDtoList = itemDgRespDtoList.stream().filter(itemRespDto -> null != itemRespDto.getShopId()).peek(itemRespDto -> {
            try {
                this.setShelfType((ItemDgRespDto)itemRespDto);
                this.setMinDistributionInfo((ItemDgRespDto)itemRespDto, itemSearchQueryDgReqDto.getDistribType());
            }
            catch (Exception e) {
                this.logger.info("\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            }
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setSize(itemDgRespDtoList.size());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setList(itemDgRespDtoList);
        itemSearchDgRespDto.setPageInfo(pageInfo);
        return itemSearchDgRespDto;
    }

    private void handleItemShop(List<ItemDgRespDto> itemDgRespDtoList, ItemSearchDgRespDto searchRespDto, ItemSearchQueryDgReqDto searchQueryReqDto) {
        if (null != searchQueryReqDto.getShopId()) {
            itemDgRespDtoList.forEach(itemRespDto -> itemRespDto.setShopId(searchQueryReqDto.getShopId()));
            return;
        }
        if (searchQueryReqDto.getLat() != null && searchQueryReqDto.getLon() != null) {
            List<ItemShopDgRespDto> rangeShopList = this.getRangeShopList(searchQueryReqDto.getLon(), searchQueryReqDto.getLat());
            if (!CollectionUtils.isEmpty(rangeShopList)) {
                searchRespDto.setRangeShopList(rangeShopList.stream().map(ItemShopDgRespDto::getShopId).collect(Collectors.toList()));
            }
            itemDgRespDtoList.forEach(itemRespDto -> this.setMiniDistantShop((ItemDgRespDto)itemRespDto, rangeShopList));
        } else {
            itemDgRespDtoList.forEach(itemRespDto -> itemRespDto.setShopId(((ItemShopDgRespDto)itemRespDto.getItemShopList().get(0)).getShopId()));
        }
    }

    private void setMinDistributionInfo(ItemDgRespDto itemDgRespDto, Integer distribType) {
        if (!CollectionUtils.isEmpty((Collection)itemDgRespDto.getItemShelfInfoList())) {
            List shelfRespDtos = itemDgRespDto.getItemShelfInfoList().stream().filter(shelfDto -> shelfDto.getShopId().equals(itemDgRespDto.getShopId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(shelfRespDtos)) {
                if (Integer.valueOf(1).equals(((ItemShelfDgRespDto)shelfRespDtos.get(0)).getDistribution())) {
                    itemDgRespDto.setDistribution(Integer.valueOf(1));
                    if (!CollectionUtils.isEmpty((Collection)itemDgRespDto.getDistributionFeeList())) {
                        if (distribType != null) {
                            ArrayList targetDistributionFeeDgDtos = Lists.newArrayList();
                            for (DistributionFeeDgDto distributionFeeDgDto : itemDgRespDto.getDistributionFeeList()) {
                                if (!distribType.equals(distributionFeeDgDto.getDistribType())) continue;
                                targetDistributionFeeDgDtos.add(distributionFeeDgDto);
                            }
                            if (distribType.equals(2) && CollectionUtils.isEmpty((Collection)targetDistributionFeeDgDtos)) {
                                this.logger.info("\u5f53\u524d\u67e5\u8be2\u7528\u6237\u4e3a\u52a0\u4ef7\u5206\u9500\u5458\uff0c\u5f53\u524d\u5546\u54c1\u52a0\u4ef7\u9884\u4f30\u4f63\u91d1\u4e3a\u7a7a\uff0citemId={}, shopId={},distribType: {}", new Object[]{itemDgRespDto.getItemId(), itemDgRespDto.getShopId(), distribType});
                                return;
                            }
                        }
                        BigDecimal min = itemDgRespDto.getDistributionFeeList().stream().filter(feeDto -> feeDto.getShopId() != null && feeDto.getShopId().equals(itemDgRespDto.getShopId())).map(DistributionFeeDgDto::getAmount).sorted().findFirst().orElse(BigDecimal.ZERO);
                        itemDgRespDto.setDistributionFee(min);
                    } else {
                        this.logger.info("\u5546\u54c1\u5206\u9500\u4f63\u91d1\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemDgRespDto.getItemId(), (Object)itemDgRespDto.getShopId());
                    }
                }
            } else {
                this.logger.info("\u5546\u54c1\u4e0a\u67b6\u8bb0\u5f55\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemDgRespDto.getItemId(), (Object)itemDgRespDto.getShopId());
            }
        }
    }

    private Long getMiniDistanceShopId(Map<Long, List<ItemShopDgRespDto>> shopRespDtoMap, List<ItemShopDgRespDto> sortShopList) {
        for (ItemShopDgRespDto itemShopDgRespDto : sortShopList) {
            if (shopRespDtoMap.get(itemShopDgRespDto.getShopId()) == null) continue;
            return itemShopDgRespDto.getShopId();
        }
        return null;
    }

    private Long getShippingShopId(List<ItemShopDgRespDto> itemShopList) {
        for (ItemShopDgRespDto itemShopDgRespDto : itemShopList) {
            if (itemShopDgRespDto.getBusinessType() == null || !itemShopDgRespDto.getBusinessType().equals(1)) continue;
            return itemShopDgRespDto.getShopId();
        }
        return null;
    }

    private List<ItemShopDgRespDto> getRangeShopList(Double lon, Double lat) {
        List shopEsDtos = (List)this.shopApi.queryRangeShopListByGeo(String.valueOf(lat), String.valueOf(lon), Boolean.valueOf(true)).getData();
        if (CollectionUtils.isEmpty((Collection)shopEsDtos)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList shopRespDtos = Lists.newArrayList();
        shopEsDtos.forEach(shopEsDto -> {
            ItemShopDgRespDto itemShopDgRespDto = new ItemShopDgRespDto();
            CubeBeanUtils.copyProperties((Object)itemShopDgRespDto, (Object)shopEsDto, (String[])new String[]{"location", "templateRegionList"});
            if (!CollectionUtils.isEmpty((Collection)shopEsDto.getLocation())) {
                ArrayList location = Lists.newArrayList();
                shopEsDto.getLocation().forEach(locationDto -> {
                    LocationDgDto respDto = new LocationDgDto();
                    respDto.setLat(locationDto.getLat());
                    respDto.setLon(locationDto.getLon());
                });
                itemShopDgRespDto.setLocation((List)location);
            }
            if (!CollectionUtils.isEmpty((Collection)shopEsDto.getTemplateRegionList())) {
                ArrayList templateRegionList = Lists.newArrayList();
                shopEsDto.getTemplateRegionList().forEach(templateRegionRespDto -> {
                    TemplateRegionDgRespDto regionRespDto = new TemplateRegionDgRespDto();
                    regionRespDto.setCoordinates(templateRegionRespDto.getCoordinates());
                    regionRespDto.setType(templateRegionRespDto.getType());
                    regionRespDto.setWarehouseId(templateRegionRespDto.getWarehouseId());
                    templateRegionList.add(regionRespDto);
                });
                itemShopDgRespDto.setTemplateRegionList((List)templateRegionList);
            }
            shopRespDtos.add(itemShopDgRespDto);
        });
        return shopRespDtos;
    }

    private Long getShopId(List<ItemShopDgRespDto> itemShopList, Map<Long, List<ItemShopDgRespDto>> shopRespDtoMap, List<ItemShopDgRespDto> sortShop) {
        Long miniDistanceShopId = null;
        if (!CollectionUtils.isEmpty(sortShop)) {
            miniDistanceShopId = this.getMiniDistanceShopId(shopRespDtoMap, sortShop);
        }
        if (miniDistanceShopId == null) {
            return this.getShippingShopId(itemShopList);
        }
        return miniDistanceShopId;
    }

    private void setMiniDistantShop(ItemDgRespDto itemDgRespDto, List<ItemShopDgRespDto> sortShopList) {
        List itemShopList = itemDgRespDto.getItemShopList();
        Map<Long, List<ItemShopDgRespDto>> shopRespDtoMap = itemShopList.stream().collect(Collectors.groupingBy(ItemShopDgRespDto::getShopId));
        itemDgRespDto.setShopId(this.getShopId(itemShopList, shopRespDtoMap, sortShopList));
    }

    private void setShelfType(ItemDgRespDto itemDgRespDto) {
        List<ItemShopDgRespDto> itemShopDgRespDtos;
        Map<Long, List<ItemShopDgRespDto>> shopRespDtoMap = itemDgRespDto.getItemShopList().stream().collect(Collectors.groupingBy(ItemShopDgRespDto::getShopId));
        if (itemDgRespDto.getShopId() != null && !CollectionUtils.isEmpty(itemShopDgRespDtos = shopRespDtoMap.get(itemDgRespDto.getShopId()))) {
            itemDgRespDto.setShelfType(itemShopDgRespDtos.get(0).getShelfType());
        }
    }

    @Override
    public void sync() {
        this.logger.info("\u5546\u54c1\u6570\u636e\u5168\u91cf\u540c\u6b65\u8d5e\u672a\u5b9e\u73b0=====");
    }

    @Override
    public MessageResponse process(Object object) {
        if (object == null) {
            this.logger.error("\u63a5\u53d7\u5230\u7a7a\u7684MQ\u6d88\u606f");
            return MessageResponse.SUCCESS;
        }
        try {
            ItemSearchIndexMessageDgVo itemSearchIndexMessageDgVo = (ItemSearchIndexMessageDgVo)JSON.parseObject((String)object.toString(), ItemSearchIndexMessageDgVo.class);
            this.logger.info("\u5f00\u59cb\u5904\u7406es\u540c\u6b65\u6d88\u606f\uff0cmessageId\uff1a{}", (Object)itemSearchIndexMessageDgVo.getMessageId());
            switch (itemSearchIndexMessageDgVo.getOperation()) {
                case "ON_SHELF": {
                    this.refreshIndex(itemSearchIndexMessageDgVo);
                    break;
                }
                case "OFF_SHELF": {
                    this.refreshIndex(itemSearchIndexMessageDgVo);
                    break;
                }
                case "SALES_COUNT": {
                    this.refreshIndex(itemSearchIndexMessageDgVo);
                    break;
                }
                default: {
                    this.logger.error("\u672a\u77e5\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b:{}", (Object)JSON.toJSONString((Object)itemSearchIndexMessageDgVo));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u540c\u6b65\u5230es\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private List<ItemShopDgRespDto> getShopList(Set<Long> shopIds, List<ItemShelfDgRespDto> itemShelfDgRespDtos) {
        Map<Long, List<ItemShelfDgRespDto>> shopItemShelfMap = itemShelfDgRespDtos.stream().collect(Collectors.groupingBy(ItemShelfDgRespDto::getShopId));
        ArrayList<ItemShopDgRespDto> itemShopList = new ArrayList<ItemShopDgRespDto>();
        for (Long shopId : shopIds) {
            GeoDto geoDto;
            ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryById(shopId.longValue(), new String[0]));
            ItemShopDgRespDto itemShopDgRespDto = new ItemShopDgRespDto();
            itemShopDgRespDto.setShopId(shopId);
            itemShopDgRespDto.setBusinessType(shopDto.getBusinessType());
            List<ItemShelfDgRespDto> shopItemSelfList = shopItemShelfMap.get(shopId);
            if (!CollectionUtils.isEmpty(shopItemSelfList)) {
                Integer type = shopItemSelfList.get(0).getType();
                itemShopDgRespDto.setShelfType(type);
            }
            if (itemShopDgRespDto.getBusinessType() == null) {
                itemShopDgRespDto.setBusinessType(Integer.valueOf(shopDto.getType().intValue()));
            }
            ArrayList<LocationDgDto> locationDgDtos = new ArrayList<LocationDgDto>();
            if (2 == itemShopDgRespDto.getBusinessType()) {
                geoDto = this.getShopDeliveryGeo(shopDto);
            } else {
                geoDto = new GeoDto();
                geoDto.setLongitude("-99.140625");
                geoDto.setLatitude("-40.044438");
            }
            if (null != geoDto) {
                LocationDgDto locationDgDto = new LocationDgDto();
                locationDgDto.setLon(Double.valueOf(geoDto.getLongitude()));
                locationDgDto.setLat(Double.valueOf(geoDto.getLatitude()));
                locationDgDtos.add(locationDgDto);
            }
            itemShopDgRespDto.setLocation(locationDgDtos);
            List<TemplateRegionDgRespDto> templateRegionList = 2 == itemShopDgRespDto.getBusinessType() ? this.getTemplateRegionRespDtoList(shopDto) : this.getRegionShippingList();
            itemShopDgRespDto.setTemplateRegionList(templateRegionList);
            itemShopList.add(itemShopDgRespDto);
        }
        return itemShopList;
    }

    private void createOrUpdateIndexGroupBySeller(ItemSearchIndexMessageDgVo itemSearchIndexMessageDgVo, ItemDgEo itemDgEo, List<ItemShelfDgRespDto> itemShelfDgRespDtos) {
        Long sellerId = itemSearchIndexMessageDgVo.getSellerId();
        this.logger.info("\u5546\u5bb6-\u5546\u54c1-\u4e1a\u52a1\u7c7b\u578b\u7ef4\u5ea6\u6784\u5efaES\u5546\u54c1\u6570\u636esellerId:{}\uff0citemId:{}, busType:{}", new Object[]{sellerId, itemSearchIndexMessageDgVo.getItemId(), itemSearchIndexMessageDgVo.getBusType()});
        List<ItemDgRespDto> itemDgRespDtoList = this.itemDgService.queryItemRespDto(Lists.newArrayList((Object[])new ItemDgEo[]{itemDgEo}), sellerId);
        if (CollectionUtils.isEmpty(itemDgRespDtoList)) {
            this.logger.error("\u6784\u5efa\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1ID:{}\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)itemSearchIndexMessageDgVo.getItemId());
            return;
        }
        ItemDgRespDto itemDgRespDto = itemDgRespDtoList.get(0);
        itemDgRespDto.setItemShelfInfoList(itemShelfDgRespDtos);
        this.buildSaleCount(itemDgRespDto);
        this.buildSearchAttr(itemDgRespDto);
        this.buildPrice(itemDgRespDto, itemShelfDgRespDtos);
        Set<Long> itemShopIdSet = itemShelfDgRespDtos.stream().map(ItemShelfDgRespDto::getShopId).collect(Collectors.toSet());
        itemDgRespDto.setItemShopList(this.getShopList(itemShopIdSet, itemShelfDgRespDtos));
        itemDgRespDto.setType(itemShelfDgRespDtos.get(0).getItemType());
        itemDgRespDto.setBusType(itemShelfDgRespDtos.get(0).getBusType());
        itemDgRespDto.setItemId(itemDgRespDto.getId());
        String groupKey = this.getIndexDocId(itemSearchIndexMessageDgVo.getSellerId(), itemSearchIndexMessageDgVo.getItemId(), itemSearchIndexMessageDgVo.getBusType());
        itemDgRespDto.setGroupKey(groupKey);
        if (null != this.distributionSetDgService) {
            List<DistributionFeeDgDto> feeDtos = this.distributionSetDgService.calculateFee(itemShelfDgRespDtos);
            itemDgRespDto.setDistributionFeeList(feeDtos);
        }
        this.logger.info("\u6784\u9020\u5546\u54c1es\u53c2\u6570itemRespDto={}", JSON.toJSON((Object)itemDgRespDto));
        try {
            long totalSize;
            OSSearchVo osSearchVo = new OSSearchVo();
            osSearchVo.addEqualFilter("id", itemDgRespDto.getGroupKey());
            SearchResultVo searchResultVo = this.search(osSearchVo);
            long l = totalSize = searchResultVo == null ? 0L : searchResultVo.getTotalSize();
            if (totalSize == 0L) {
                this.create(itemDgRespDto);
            } else {
                this.update(itemDgRespDto);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u540c\u6b65\u5230ES\u51fa\u73b0\u5f02\u5e38,\u5e76\u4e14\u91cd\u65b0\u53d1\u9001MQ", (Throwable)e);
            this.index(itemSearchIndexMessageDgVo.getSellerId(), itemSearchIndexMessageDgVo.getItemId(), itemSearchIndexMessageDgVo.getBusType(), itemSearchIndexMessageDgVo.getOperation(), itemSearchIndexMessageDgVo.getRetry() + 1);
        }
    }

    private SearchResultVo search(OSSearchVo osSearchVo) {
        osSearchVo.setIndexName(this.INDEX_ITEM + "_" + this.indexName);
        osSearchVo.setTypeName(this.indexType);
        return this.openSearchService.search(osSearchVo);
    }

    private void buildPrice(ItemDgRespDto itemDgRespDto, List<ItemShelfDgRespDto> itemShelfDtos) {
        BigDecimal max = BigDecimal.ZERO;
        BigDecimal min = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(itemShelfDtos)) {
            List priceList = itemShelfDtos.stream().map(ItemShelfDgRespDto::getPrice).collect(Collectors.toList());
            max = (BigDecimal)priceList.stream().max(BigDecimal::compareTo).get();
            min = (BigDecimal)priceList.stream().min(BigDecimal::compareTo).get();
        }
        itemDgRespDto.setMinPrice(Double.valueOf(min.doubleValue()));
        itemDgRespDto.setMaxPrice(Double.valueOf(max.doubleValue()));
    }

    private void buildSaleCount(ItemDgRespDto itemDgRespDto) {
        StatDgEo statDgEo = new StatDgEo();
        statDgEo.setItemId(itemDgRespDto.getId());
        List statDgEoList = this.statDgDomain.selectList((BaseEo)statDgEo);
        long salesCount = 0L;
        if (!CollectionUtils.isEmpty((Collection)statDgEoList)) {
            salesCount = statDgEoList.stream().mapToLong(StatDgEo::getSalesCount).sum();
        }
        itemDgRespDto.setSalesCount(Long.valueOf(salesCount));
    }

    private void buildSearchAttr(ItemDgRespDto itemDgRespDto) {
        ItemAttributesDgEo itemAttributesDgEo = new ItemAttributesDgEo();
        itemAttributesDgEo.setItemId(itemDgRespDto.getId());
        itemAttributesDgEo = (ItemAttributesDgEo)this.itemAttributesDgDomain.selectOne((BaseEo)itemAttributesDgEo);
        ItemAttributesDgRespDto attributesDgRespDto = new ItemAttributesDgRespDto();
        DtoHelper.eo2Dto((BaseEo)itemAttributesDgEo, (BaseVo)attributesDgRespDto);
        itemDgRespDto.setAttributesDgRespDto(attributesDgRespDto);
        if (itemAttributesDgEo != null) {
            String searchAttr = itemAttributesDgEo.getSearchAttrs();
            itemDgRespDto.setSearchAttr(searchAttr);
        }
    }

    @Override
    public String getIndexDocId(Long sellerId, Long itemId, Integer busType) {
        return String.valueOf(sellerId) + itemId + busType;
    }

    private void refreshIndex(ItemSearchIndexMessageDgVo itemSearchIndexMessageDgVo) {
        this.logger.info("\u6839\u636e\u6d88\u606f\u5237\u65b0\u5546\u54c1\u7d22\u5f15ItemSearchIndexMessageVo\uff1a{}", JSON.toJSON((Object)itemSearchIndexMessageDgVo));
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemSearchIndexMessageDgVo.getItemId());
        if (null == itemDgEo) {
            this.logger.info("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728itemId\uff1a{}", (Object)itemSearchIndexMessageDgVo.getItemId());
            return;
        }
        ShelfDgReqDto shelfDgReqDto = new ShelfDgReqDto();
        shelfDgReqDto.setItemId(itemSearchIndexMessageDgVo.getItemId());
        shelfDgReqDto.setSellerId(itemSearchIndexMessageDgVo.getSellerId());
        shelfDgReqDto.setBusType(Integer.valueOf(itemSearchIndexMessageDgVo.getBusType()));
        List<ItemShelfDgRespDto> itemShelfDgRespDtos = this.itemDgService.queryItemShelfList(shelfDgReqDto);
        if (!CollectionUtils.isEmpty(itemShelfDgRespDtos)) {
            this.logger.info("\u67e5\u8be2\u5230\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)itemShelfDgRespDtos.size());
            Map<Long, List<ItemShelfDgRespDto>> sellerMap = itemShelfDgRespDtos.stream().collect(Collectors.groupingBy(ItemShelfDgRespDto::getSellerId));
            for (Long sellerId : sellerMap.keySet()) {
                List<ItemShelfDgRespDto> itemShelfList = sellerMap.get(sellerId);
                Map<Integer, List<ItemShelfDgRespDto>> bizTypeMap = itemShelfList.stream().collect(Collectors.groupingBy(ItemShelfDgRespDto::getBusType));
                for (Integer bizType : bizTypeMap.keySet()) {
                    this.createOrUpdateIndexGroupBySeller(itemSearchIndexMessageDgVo, itemDgEo, bizTypeMap.get(bizType));
                }
            }
        } else {
            this.logger.info("\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u4e0a\u67b6\u8bb0\u5f55");
            this.deleteByIndexId(this.getIndexDocId(itemSearchIndexMessageDgVo.getSellerId(), itemSearchIndexMessageDgVo.getItemId(), itemSearchIndexMessageDgVo.getBusType()));
        }
    }

    private List<TemplateRegionDgRespDto> getRegionShippingList() {
        List coordinateDgDtoList;
        ArrayList<TemplateRegionDgRespDto> templateRegionList = new ArrayList<TemplateRegionDgRespDto>();
        TemplateRegionDgRespDto templateRegionDgRespDto = new TemplateRegionDgRespDto();
        templateRegionDgRespDto.setWarehouseId(Long.valueOf(0L));
        templateRegionDgRespDto.setType("polygon");
        String geo = "[{\"lng\":62.929688,\"lat\":55.279115},{\"lng\":137.812500,\"lat\":57.704147},{\"lng\":136.582031,\"lat\":17.978733},{\"lng\":62.578125,\"lat\":19.145168},{\"lng\":62.929688,\"lat\":55.279115}]";
        if (StringUtils.isNotBlank((CharSequence)geo) && !CollectionUtils.isEmpty((Collection)(coordinateDgDtoList = JSON.parseArray((String)geo, CoordinateDgDto.class)))) {
            ArrayList list1 = new ArrayList();
            ArrayList list2 = new ArrayList();
            for (CoordinateDgDto coordinateDgDto : coordinateDgDtoList) {
                ArrayList<Double> list3 = new ArrayList<Double>();
                list3.add(coordinateDgDto.getLng());
                list3.add(coordinateDgDto.getLat());
                list2.add(list3);
            }
            list1.add(list2);
            templateRegionDgRespDto.setCoordinates(list1);
        }
        templateRegionList.add(templateRegionDgRespDto);
        return templateRegionList;
    }

    private GeoDto getShopDeliveryGeo(ShopDto shopDto) {
        ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
        GeoDto geoDto = null;
        if (shopDeliveryDto != null) {
            String[] geo = StringUtils.split((String)shopDeliveryDto.getGeo(), (String)",");
            geoDto = new GeoDto();
            geoDto.setLongitude(geo[0]);
            geoDto.setLatitude(geo[1]);
        }
        return geoDto;
    }

    private List<TemplateRegionDgRespDto> getTemplateRegionRespDtoList(ShopDto shopDto) {
        List geoList;
        String geoFence;
        ArrayList templateRegionDgRespDtoList = Lists.newArrayList();
        ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
        if (shopDeliveryDto != null && StringUtils.isNotBlank((CharSequence)(geoFence = shopDeliveryDto.getGeoFence())) && org.apache.commons.collections.CollectionUtils.isNotEmpty(geoList = Stream.of(StringUtils.split((String)geoFence, (String)";")).map(geo -> {
            String[] geoPoints = StringUtils.split((String)geo, (String)",");
            if (geoPoints != null && geoPoints.length > 1) {
                return new CoordinateDgDto(Double.valueOf(Double.parseDouble(geoPoints[0])), Double.valueOf(Double.parseDouble(geoPoints[1])));
            }
            return null;
        }).collect(Collectors.toList()))) {
            CoordinateDgDto startPoint = (CoordinateDgDto)geoList.get(0);
            CoordinateDgDto endPoint = (CoordinateDgDto)geoList.get(geoList.size() - 1);
            if (startPoint.getLng().compareTo(endPoint.getLng()) != 0 || startPoint.getLat().compareTo(endPoint.getLat()) != 0) {
                geoList.add(startPoint);
            }
            ArrayList geoFenceList = new ArrayList();
            for (CoordinateDgDto coordinateDgDto : geoList) {
                ArrayList<Double> pointsList = new ArrayList<Double>();
                pointsList.add(coordinateDgDto.getLng());
                pointsList.add(coordinateDgDto.getLat());
                geoFenceList.add(pointsList);
            }
            ArrayList coordinates = new ArrayList();
            coordinates.add(geoFenceList);
            templateRegionDgRespDtoList.add(new TemplateRegionDgRespDto(coordinates));
        }
        return templateRegionDgRespDtoList;
    }

    private void create(ItemDgRespDto itemDgRespDto) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(String.valueOf(itemDgRespDto.getGroupKey()));
        Map describe = CustomBeanUtils.describe((Object)itemDgRespDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u65b0\u589e\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.addData(indexDocumentVo);
    }

    private void createBatch(List<ItemDgRespDto> itemDgRespDtos) {
        if (CollectionUtils.isEmpty(itemDgRespDtos)) {
            return;
        }
        IndexDocumentVo indexDocumentVo = this.buildIndexData(itemDgRespDtos);
        this.logger.info("\u65b0\u589e\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.addData(indexDocumentVo);
    }

    private void updateBatch(List<ItemDgRespDto> itemDgRespDtos) {
        if (CollectionUtils.isEmpty(itemDgRespDtos)) {
            return;
        }
        IndexDocumentVo indexDocumentVo = this.buildIndexData(itemDgRespDtos);
        this.logger.info("\u66f4\u65b0\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.updateData(indexDocumentVo);
    }

    private IndexDocumentVo buildIndexData(List<ItemDgRespDto> itemDgRespDtos) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        indexDocumentVo.setContents(itemDgRespDtos.stream().map(itemRespDto -> {
            IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
            indexDocContentVo.setIndexId(String.valueOf(itemRespDto.getGroupKey()));
            Map describe = CustomBeanUtils.describe((Object)itemRespDto);
            indexDocContentVo.setDocValueMap(describe);
            return indexDocContentVo;
        }).collect(Collectors.toList()));
        return indexDocumentVo;
    }

    private void update(ItemDgRespDto itemDgRespDto) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(String.valueOf(itemDgRespDto.getGroupKey()));
        Map describe = CustomBeanUtils.describe((Object)itemDgRespDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u66f4\u65b0\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.updateData(indexDocumentVo);
    }

    private void deleteByIndexId(String indexId) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(indexId);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u6839\u636eindexId\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.deleteData(indexDocumentVo);
    }

    private Long generateId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = IdGenrator.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }

    private IndexDocumentVo newInstance() {
        return new IndexDocumentVo(this.INDEX_ITEM + "_" + this.indexName, this.indexType);
    }

    @Override
    @Async
    public void asyncSendMqForOff(Integer busType, List<DirItemRelationDgEo> offDirItems) {
        Map<String, DirItemRelationDgEo> offDirItemMap = offDirItems.stream().collect(Collectors.toMap(dirItem -> dirItem.getItemId().toString() + dirItem.getShopId(), e -> e, (e1, e2) -> e1));
        offDirItemMap.forEach((k, dirItem) -> {
            ItemMessageDg itemMessageDg = new ItemMessageDg(dirItem.getItemId(), dirItem.getShopId(), Integer.valueOf(0));
            this.itemShelfDgProducer.sendMqMessage(itemMessageDg);
            this.index(dirItem.getSellerId(), dirItem.getItemId(), busType, "OFF_SHELF");
        });
    }

    @Override
    @Async
    public void asyncSendMqForOn(Integer busType, List<DirItemRelationDgEo> shelfDirItems) {
        shelfDirItems.forEach(dirItem -> {
            this.index(dirItem.getSellerId(), dirItem.getItemId(), busType, "ON_SHELF");
            ItemMessageDg message = new ItemMessageDg(dirItem.getItemId(), dirItem.getShopId(), Integer.valueOf(1));
            this.itemShelfDgProducer.sendMqMessage(message);
        });
    }

    @Override
    @Async
    public void asyncSendMqForOnTob(Integer busType, List<DirItemRelationDgEo> onDirItems) {
        Map<String, DirItemRelationDgEo> onDirItemMap = onDirItems.stream().collect(Collectors.toMap(dirItem -> dirItem.getItemId().toString() + dirItem.getShopId(), e -> e, (e1, e2) -> e1));
        onDirItemMap.forEach((k, dirItem) -> {
            ItemMessageDg itemMessageDg = new ItemMessageDg(dirItem.getItemId(), dirItem.getShopId(), Integer.valueOf(1));
            this.itemShelfDgProducer.sendMqMessage(itemMessageDg);
            this.index(dirItem.getSellerId(), dirItem.getItemId(), busType, "ON_SHELF");
        });
    }

    @Override
    public void asyncItemIndex(Integer busType, List<DirItemRelationDgEo> shelfDirItems) {
        this.refreshIndexBatch(shelfDirItems, busType, "ON_SHELF");
    }

    @Override
    public void syncEsOff(Integer busType, List<DirItemRelationDgEo> offDirItems) {
        this.refreshIndexBatch(offDirItems, busType, "OFF_SHELF");
    }

    @Override
    public void refreshIndexBatch(final List<DirItemRelationDgEo> shelfDirItems, Integer busType, String onShelf) {
        final Map attachments = ServiceContext.getContext().getAttachments();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    attachments.forEach((k, v) -> ServiceContext.getContext().set(k, v));
                    ItemSearchDgServiceImpl.this.refreshIndexBatchCommitAfter(shelfDirItems);
                }
            });
        } else {
            this.refreshIndexBatchCommitAfter(shelfDirItems);
        }
    }

    private void refreshIndexBatchCommitAfter(List<DirItemRelationDgEo> shelfDirItems) {
        List itemIds = shelfDirItems.stream().map(DirItemRelationDgEo::getItemId).collect(Collectors.toList());
        this.logger.info("\u6839\u636e\u5237\u65b0\u5546\u54c1\u7d22\u5f15ItemSearchIndexMessageVo\uff1a{}", (Object)JSON.toJSONString(itemIds));
        List itemDgEos = this.itemDgDomain.selectByIds(itemIds);
        if (CollectionUtils.isEmpty((Collection)itemDgEos)) {
            return;
        }
        this.sellerIdHandler(shelfDirItems);
        List itemShelfRespDtos = this.shelfDgDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ShelfDgEo::getItemId, itemIds)).in(ShelfDgEo::getSellerId, (Collection)shelfDirItems.stream().map(DirItemRelationDgEo::getSellerId).distinct().collect(Collectors.toList()))).eq(BaseEo::getDr, (Object)0)).in(ShelfDgEo::getBusType, (Collection)itemDgEos.stream().map(ItemDgEo::getBusType).distinct().collect(Collectors.toList())));
        Set containIds = itemShelfRespDtos.stream().map(shelf -> this.getIndexDocId(shelf.getSellerId(), shelf.getItemId(), shelf.getBusType())).collect(Collectors.toSet());
        List<String> deleteIndexIds = shelfDirItems.stream().map(dirItem -> this.getIndexDocId(dirItem.getSellerId(), dirItem.getItemId(), dirItem.getBusType())).filter(key -> !containIds.contains(key)).distinct().collect(Collectors.toList());
        this.refreshIndexBatchHandler(deleteIndexIds, itemDgEos, itemShelfRespDtos);
    }

    @Override
    public void refreshIndexBatchHandler(List<String> deleteIndexIds, List<ItemDgEo> itemDgEos, List<ShelfDgEo> itemShelfRespDtos) {
        if (!CollectionUtils.isEmpty(itemShelfRespDtos)) {
            this.logger.info("\u67e5\u8be2\u5230\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)itemShelfRespDtos.size());
            this.createOrUpdateIndexSyn(itemShelfRespDtos, itemDgEos);
        }
    }

    private void sellerIdHandler(List<DirItemRelationDgEo> shelfDirItems) {
        Set complementShopIds = shelfDirItems.stream().filter(d -> Objects.isNull(d.getSellerId())).map(DirItemRelationDgEo::getShopId).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(complementShopIds)) {
            Map<Long, Long> shopMap = ((List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseListByIds(complementShopIds))).stream().collect(Collectors.toMap(ShopBaseDto::getId, ShopBaseDto::getSellerId));
            shelfDirItems.stream().filter(d -> Objects.isNull(d.getSellerId())).forEach(d -> d.setSellerId(Optional.ofNullable(shopMap.get(d.getShopId())).orElse(d.getShopId())));
        }
    }

    private void deleteByIndexIds(List<String> indexIds) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        indexDocumentVo.setContents(indexIds.stream().map(indexId -> {
            IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
            indexDocContentVo.setIndexId(indexId);
            return indexDocContentVo;
        }).collect(Collectors.toList()));
        this.logger.info("\u6839\u636eindexId\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.deleteData(indexDocumentVo);
    }

    private void createOrUpdateIndexSyn(List<ShelfDgEo> shelfDgEos, List<ItemDgEo> itemDgEos) {
        if (CollectionUtils.isEmpty(shelfDgEos) || CollectionUtils.isEmpty(itemDgEos)) {
            return;
        }
        Map itemMap = itemDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map<Long, List<ItemShelfDgRespDto>> sellerMap = shelfDgEos.stream().map(shelf -> {
            ItemShelfDgRespDto itemShelfDgRespDto = new ItemShelfDgRespDto();
            BeanUtils.copyProperties((Object)shelf, (Object)itemShelfDgRespDto);
            return itemShelfDgRespDto;
        }).collect(Collectors.groupingBy(ItemShelfDgRespDto::getSellerId));
        sellerMap.forEach((sellerId, itemShelfRespDtos) -> {
            List<ItemDgEo> sellerItems = itemShelfRespDtos.stream().map(shelf -> (ItemDgEo)itemMap.get(shelf.getItemId())).distinct().collect(Collectors.toList());
            List<ItemDgRespDto> itemRespList = this.itemDgService.queryItemRespDto(sellerItems, (Long)sellerId);
            if (CollectionUtils.isEmpty(itemRespList)) {
                this.logger.error("\u6784\u5efa\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1ID:{}\u4fe1\u606f\u4e0d\u5b58\u5728", itemRespList.stream().map(ItemDgRespDto::getItemId).collect(Collectors.toList()));
                return;
            }
            Map<Long, List<ItemShelfDgRespDto>> shelfMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfDgRespDto::getItemId));
            for (ItemDgRespDto itemDgRespDto : itemRespList) {
                itemDgRespDto.setItemShelfInfoList(shelfMap.get(itemDgRespDto.getId()));
            }
            List<Long> itemIds = itemRespList.stream().map(ItemDgRespDto::getId).collect(Collectors.toList());
            this.buildSaleCounts(itemRespList);
            this.buildSearchAttrs(itemRespList, itemIds);
            this.buildPrices(itemRespList, shelfMap);
            Set itemShopIdSet = itemShelfRespDtos.stream().map(ItemShelfDgRespDto::getShopId).collect(Collectors.toSet());
            Map shopMap = ((List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(itemShopIdSet))).stream().collect(Collectors.toMap(ShopDto::getId, Function.identity()));
            itemRespList.forEach(itemRespDto -> {
                List inlineItemShelfDgRespDtos = (List)shelfMap.get(itemRespDto.getId());
                List<ShopDto> shopDtos = inlineItemShelfDgRespDtos.stream().map(itemShelfRespDto -> (ShopDto)shopMap.get(itemShelfRespDto.getShopId())).filter(Objects::nonNull).collect(Collectors.toList());
                itemRespDto.setItemShopList(this.getShopListNew(shopDtos, inlineItemShelfDgRespDtos));
                itemRespDto.setType(((ItemShelfDgRespDto)inlineItemShelfDgRespDtos.get(0)).getItemType());
                itemRespDto.setBusType(((ItemShelfDgRespDto)inlineItemShelfDgRespDtos.get(0)).getBusType());
                itemRespDto.setItemId(itemRespDto.getId());
                String groupKey = this.getIndexDocId((Long)sellerId, itemRespDto.getId(), ((ItemShelfDgRespDto)inlineItemShelfDgRespDtos.get(0)).getBusType());
                itemRespDto.setGroupKey(groupKey);
            });
            try {
                this.deleteByIndexIds(itemRespList.stream().map(ItemDgRespDto::getGroupKey).distinct().collect(Collectors.toList()));
                this.createBatch(itemRespList);
                this.logger.info("\u66f4\u65b0\u7d22\u5f15, \u65b0\u589e\u6570\u91cf{}", (Object)itemRespList.size());
            }
            catch (Exception e) {
                this.logger.error("\u5546\u54c1\u540c\u6b65\u5230ES\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        });
    }

    private void buildSearchAttrs(List<ItemDgRespDto> itemRespList, List<Long> itemIds) {
        Map dataMap = this.itemAttributesDgDomain.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(ItemAttributesDgEo::getItemId, itemIds)).stream().collect(Collectors.toMap(ItemAttributesDgEo::getItemId, Function.identity(), (o, o1) -> o));
        itemRespList.forEach(item -> {
            ItemAttributesDgEo itemAttributesDgEo = (ItemAttributesDgEo)dataMap.get(item.getId());
            ItemAttributesDgRespDto attributesDgRespDto = new ItemAttributesDgRespDto();
            DtoHelper.eo2Dto((BaseEo)itemAttributesDgEo, (BaseVo)attributesDgRespDto);
            item.setAttributesDgRespDto(attributesDgRespDto);
            if (itemAttributesDgEo != null) {
                String searchAttr = itemAttributesDgEo.getSearchAttrs();
                item.setSearchAttr(searchAttr);
            }
        });
    }

    private void buildPrices(List<ItemDgRespDto> itemDgRespDtos, Map<Long, List<ItemShelfDgRespDto>> shelfMap) {
        itemDgRespDtos.forEach(itemRespDto -> {
            BigDecimal max = BigDecimal.ZERO;
            BigDecimal min = BigDecimal.ZERO;
            List itemShelfDtos = (List)shelfMap.get(itemRespDto.getId());
            if (!CollectionUtils.isEmpty((Collection)itemShelfDtos)) {
                List priceList = itemShelfDtos.stream().map(ItemShelfDgRespDto::getPrice).collect(Collectors.toList());
                max = (BigDecimal)priceList.stream().max(BigDecimal::compareTo).get();
                min = (BigDecimal)priceList.stream().min(BigDecimal::compareTo).get();
            }
            itemRespDto.setMinPrice(Double.valueOf(min.doubleValue()));
            itemRespDto.setMaxPrice(Double.valueOf(max.doubleValue()));
        });
    }

    private void buildSaleCounts(List<ItemDgRespDto> itemDgRespDtos) {
        List statDgEoList = this.statDgDomain.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(StatDgEo::getItemId, (Collection)itemDgRespDtos.stream().map(ItemDgRespDto::getId).collect(Collectors.toList())));
        Map<Long, List<StatDgEo>> map = statDgEoList.stream().collect(Collectors.groupingBy(StatDgEo::getItemId));
        itemDgRespDtos.forEach(resp -> {
            List statDgEos = (List)map.get(resp.getId());
            if (!CollectionUtils.isEmpty((Collection)statDgEos)) {
                resp.setSalesCount(Long.valueOf(statDgEoList.stream().mapToLong(StatDgEo::getSalesCount).sum()));
            }
        });
    }

    private List<ItemShopDgRespDto> getShopListNew(List<ShopDto> shops, List<ItemShelfDgRespDto> itemShelfDgRespDtos) {
        Map<Long, List<ItemShelfDgRespDto>> shopItemShelfMap = itemShelfDgRespDtos.stream().collect(Collectors.groupingBy(ItemShelfDgRespDto::getShopId));
        ArrayList<ItemShopDgRespDto> itemShopList = new ArrayList<ItemShopDgRespDto>();
        for (ShopDto shop : shops) {
            ItemShopDgRespDto itemShopDgRespDto = new ItemShopDgRespDto();
            itemShopDgRespDto.setShopId(shop.getId());
            itemShopDgRespDto.setBusinessType(shop.getBusinessType());
            List<ItemShelfDgRespDto> shopItemSelfList = shopItemShelfMap.get(shop.getId());
            if (!CollectionUtils.isEmpty(shopItemSelfList)) {
                Integer type = shopItemSelfList.get(0).getType();
                itemShopDgRespDto.setShelfType(type);
            }
            if (itemShopDgRespDto.getBusinessType() == null) {
                itemShopDgRespDto.setBusinessType(Integer.valueOf(shop.getType().intValue()));
            }
            itemShopList.add(itemShopDgRespDto);
        }
        return itemShopList;
    }
}

