/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.IdGenrator;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.convert.entity.ItemUnitConversionDgConverter;
import com.yunxi.dg.base.center.item.domain.entity.IItemUnitConversionDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemUnitConversionRelationDgDomain;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionDgDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionDgPageReqDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionRelationDgDto;
import com.yunxi.dg.base.center.item.dto.request.ItemUnitConversionDgGroupDto;
import com.yunxi.dg.base.center.item.eo.ItemUnitConversionDgEo;
import com.yunxi.dg.base.center.item.eo.ItemUnitConversionRelationDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemUnitConversionDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemUnitConversionRelationDgService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemUnitConversionDgServiceImpl
extends BaseServiceImpl<ItemUnitConversionDgDto, ItemUnitConversionDgEo, IItemUnitConversionDgDomain>
implements IItemUnitConversionDgService {
    private static Logger logger = LoggerFactory.getLogger(ItemUnitConversionDgServiceImpl.class);
    private static final String GROUP_TYPE = "GC";
    @Resource
    private IItemUnitConversionDgDomain itemUnitConversionDgDomain;
    @Resource
    private IItemUnitConversionRelationDgDomain itemUnitConversionRelationDgDomain;
    @Resource
    private IItemUnitConversionRelationDgService itemUnitConversionRelationDgService;

    public ItemUnitConversionDgServiceImpl(IItemUnitConversionDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ItemUnitConversionDgDto, ItemUnitConversionDgEo> converter() {
        return ItemUnitConversionDgConverter.INSTANCE;
    }

    @Override
    public List<ItemUnitConversionDgDto> queryUnitConversionListByGroupCode(String groupCode) {
        Assertions.assertThat((String)groupCode).isNotBlank();
        ItemUnitConversionDgEo itemUnitConversionDgEo = new ItemUnitConversionDgEo();
        itemUnitConversionDgEo.setGroupCode(groupCode);
        List itemUnitConversionDgEos = this.itemUnitConversionDgDomain.selectList((BaseEo)itemUnitConversionDgEo);
        Assertions.assertThat((List)itemUnitConversionDgEos).isNotEmpty();
        ArrayList<ItemUnitConversionDgDto> itemUnitConversionDgDtos = new ArrayList<ItemUnitConversionDgDto>();
        CubeBeanUtils.copyCollection(itemUnitConversionDgDtos, (Collection)itemUnitConversionDgEos, ItemUnitConversionDgDto.class);
        return itemUnitConversionDgDtos;
    }

    @Override
    public void addItemUnitConversion(List<ItemUnitConversionDgGroupDto> itemUnitConversionRelationDgDtos) {
        this.logicDeleteByItemId(((ItemUnitConversionRelationDgDto)itemUnitConversionRelationDgDtos.get(0).getItemUnitConversionRelations().get(0)).getItemId());
        ArrayList conversionDgDtos = new ArrayList();
        ArrayList conversionRelationDgDtos = new ArrayList();
        itemUnitConversionRelationDgDtos.forEach(unitConversionGroupDgReqDto -> {
            List itemUnitConversionDgDtos = unitConversionGroupDgReqDto.getItemUnitConversions();
            String groupCode = GROUP_TYPE + IdGenrator.getDistributedId();
            itemUnitConversionDgDtos.forEach(itemUnitConversionDgDto -> itemUnitConversionDgDto.setGroupCode(groupCode));
            conversionDgDtos.addAll(itemUnitConversionDgDtos);
            List itemSkuDgDtos = unitConversionGroupDgReqDto.getItemUnitConversionRelations();
            List unitRDtos = itemSkuDgDtos.stream().map(skuDgDto -> {
                ItemUnitConversionRelationDgDto unitRDto = new ItemUnitConversionRelationDgDto();
                unitRDto.setSkuCode(skuDgDto.getSkuCode());
                unitRDto.setItemId(skuDgDto.getItemId());
                unitRDto.setItemCode(skuDgDto.getItemCode());
                unitRDto.setSkuId(skuDgDto.getSkuId());
                unitRDto.setSkuName(skuDgDto.getSkuName());
                unitRDto.setGroupCode(groupCode);
                return unitRDto;
            }).collect(Collectors.toList());
            conversionRelationDgDtos.addAll(unitRDtos);
        });
        this.insertBatch(conversionDgDtos);
        ArrayList itemUnitConversionRelationDgEos = new ArrayList();
        CubeBeanUtils.copyCollection(itemUnitConversionRelationDgEos, conversionRelationDgDtos, ItemUnitConversionRelationDgEo.class);
        this.itemUnitConversionRelationDgDomain.insertBatch(itemUnitConversionRelationDgEos);
    }

    @Override
    public void insertItemUnitConversion(List<ItemUnitConversionDgDto> itemUnitConversions) {
        if (CollectionUtil.isEmpty(itemUnitConversions)) {
            return;
        }
        String groupCode = GROUP_TYPE + IdGenrator.getDistributedId();
        for (ItemUnitConversionDgDto itemUnitConversion : itemUnitConversions) {
            itemUnitConversion.setGroupCode(groupCode);
        }
        this.insertBatch(itemUnitConversions);
    }

    @Override
    public List<ItemUnitConversionDgGroupDto> queryUnitConversionsByItem(ItemUnitConversionRelationDgDto itemSkuDto) {
        List<ItemUnitConversionRelationDgDto> itemUnitConversionRelationDgDtos = this.itemUnitConversionRelationDgService.queryUnitConversionRListByItem(itemSkuDto);
        Map<String, List<ItemUnitConversionRelationDgDto>> groupCodeMap = itemUnitConversionRelationDgDtos.stream().collect(Collectors.groupingBy(ItemUnitConversionRelationDgDto::getGroupCode));
        ArrayList<ItemUnitConversionDgGroupDto> itemUnitConversionDgGroupDtos = new ArrayList<ItemUnitConversionDgGroupDto>();
        groupCodeMap.keySet().forEach(groupCode -> {
            ItemUnitConversionDgGroupDto itemUnitConversionDgGroupDto = new ItemUnitConversionDgGroupDto();
            List<ItemUnitConversionDgDto> itemUnitConversionDgDtos = this.queryUnitConversionListByGroupCode((String)groupCode);
            itemUnitConversionDgGroupDto.setItemUnitConversions(itemUnitConversionDgDtos);
            List itemUnitConversionRDgDtos = (List)groupCodeMap.get(groupCode);
            List skuDgDtos = itemUnitConversionRDgDtos.stream().map(unitRDto -> {
                ItemUnitConversionRelationDgDto unitConversionItemSkuDgDto = new ItemUnitConversionRelationDgDto();
                unitConversionItemSkuDgDto.setSkuCode(unitRDto.getSkuCode());
                unitConversionItemSkuDgDto.setSkuId(unitRDto.getSkuId());
                unitConversionItemSkuDgDto.setSkuName(unitRDto.getSkuName());
                return unitConversionItemSkuDgDto;
            }).collect(Collectors.toList());
            itemUnitConversionDgGroupDto.setItemUnitConversionRelations(skuDgDtos);
            itemUnitConversionDgGroupDtos.add(itemUnitConversionDgGroupDto);
        });
        return itemUnitConversionDgGroupDtos;
    }

    @Override
    public List<ItemUnitConversionDgGroupDto> queryUnitConversionsByItemCode(String itemCode) {
        ArrayList<ItemUnitConversionDgGroupDto> groupDtos = new ArrayList<ItemUnitConversionDgGroupDto>();
        ItemUnitConversionDgEo unitConversionDgEo = new ItemUnitConversionDgEo();
        unitConversionDgEo.setItemCode(itemCode);
        List itemUnitConversionDgEos = this.itemUnitConversionDgDomain.selectList((BaseEo)unitConversionDgEo);
        if (CollectionUtil.isEmpty((Collection)itemUnitConversionDgEos)) {
            return groupDtos;
        }
        Map<String, List<ItemUnitConversionDgEo>> conversionDgEoMap = itemUnitConversionDgEos.stream().collect(Collectors.groupingBy(ItemUnitConversionDgEo::getGroupCode));
        ArrayList<String> groupCodes = new ArrayList<String>(conversionDgEoMap.keySet());
        List<ItemUnitConversionRelationDgDto> relationDgDtos = this.itemUnitConversionRelationDgService.queryListByGroupCode(groupCodes);
        Map<String, List<ItemUnitConversionRelationDgDto>> relationDgDtosMap = relationDgDtos.stream().collect(Collectors.groupingBy(ItemUnitConversionRelationDgDto::getGroupCode));
        conversionDgEoMap.forEach((key, value) -> {
            List itemUnitConversionDgDtos = this.converter().toDtoList(value);
            List relationDgDtosList = (List)relationDgDtosMap.get(key);
            ItemUnitConversionDgGroupDto conversionDgGroupDto = new ItemUnitConversionDgGroupDto();
            conversionDgGroupDto.setItemUnitConversions(itemUnitConversionDgDtos);
            conversionDgGroupDto.setItemUnitConversionRelations(relationDgDtosList);
            groupDtos.add(conversionDgGroupDto);
        });
        return groupDtos;
    }

    @Override
    public void logicDeleteByGroupCodes(List<String> groupCodes) {
        this.itemUnitConversionDgDomain.logicDeleteByGroupCodes(groupCodes);
    }

    @Override
    public void logicDeleteBySkuIds(List<Long> skuIds) {
        this.itemUnitConversionDgDomain.removeItemUnitConversionBySkuIds(skuIds);
        logger.info("\u5220\u9664\u8f85\u8ba1\u91cf\u5355\u4f4d\u5b8c\u6210===============>{}", skuIds);
    }

    @Override
    public PageInfo<ItemUnitConversionDgDto> queryUnitConversionsByPage(ItemUnitConversionDgPageReqDto reqDto) {
        PageInfo respPageInfo = new PageInfo();
        ItemUnitConversionDgEo queryEo = new ItemUnitConversionDgEo();
        BeanUtil.copyProperties((Object)reqDto, (Object)queryEo, (String[])new String[0]);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            sqlFilterList.add(SqlFilter.in((String)"sku_code", (Object)reqDto.getSkuCodeList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuIdList())) {
            sqlFilterList.add(SqlFilter.in((String)"sku_id", (Object)reqDto.getSkuIdList()));
        }
        PageInfo pageInfo = this.itemUnitConversionDgDomain.selectPage((BaseEo)queryEo, reqDto.getPageNum(), reqDto.getPageSize());
        BeanUtil.copyProperties((Object)pageInfo, (Object)respPageInfo, (String[])new String[0]);
        if (CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List itemUnitConversionDgDtos = BeanUtil.copyToList((Collection)pageInfo.getList(), ItemUnitConversionDgDto.class);
            respPageInfo.setList(itemUnitConversionDgDtos);
        }
        return respPageInfo;
    }

    @Override
    public List<ItemUnitConversionDgDto> queryUnitConversionsByList(ItemUnitConversionDgPageReqDto reqDto) {
        List<Object> conversionDgDtos = new ArrayList<ItemUnitConversionDgDto>();
        List unitConversionDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemUnitConversionDgDomain.filter().eq((Object)"dr", (Object)0)).eq(Objects.nonNull(reqDto.getItemId()), (Object)"item_id", (Object)reqDto.getItemId())).like(Objects.nonNull(reqDto.getItemCode()), (Object)"item_code", (Object)reqDto.getItemCode())).eq(Objects.nonNull(reqDto.getDefaultOrders()), (Object)"default_orders", (Object)reqDto.getDefaultOrders())).like(Objects.nonNull(reqDto.getSkuCode()), (Object)"sku_code", (Object)reqDto.getSkuCode())).eq(Objects.nonNull(reqDto.getSkuId()), (Object)"sku_id", (Object)reqDto.getSkuId())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList()), (Object)"sku_code", (Collection)reqDto.getSkuCodeList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getSkuIdList()), (Object)"sku_id", (Collection)reqDto.getSkuIdList())).like(Objects.nonNull(reqDto.getGroupCode()), (Object)"group_code", (Object)reqDto.getGroupCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)unitConversionDgEos)) {
            conversionDgDtos = BeanUtil.copyToList((Collection)unitConversionDgEos, ItemUnitConversionDgDto.class);
        }
        return conversionDgDtos;
    }

    private void logicDeleteByItemId(Long itemId) {
        ItemUnitConversionRelationDgEo itemUnitConversionRelationDgEo = new ItemUnitConversionRelationDgEo();
        itemUnitConversionRelationDgEo.setItemId(itemId);
        this.itemUnitConversionRelationDgDomain.logicDelete((BaseEo)itemUnitConversionRelationDgEo);
        ItemUnitConversionDgEo itemUnitConversionDgEo = new ItemUnitConversionDgEo();
        itemUnitConversionDgEo.setItemId(itemId);
        this.itemUnitConversionDgDomain.logicDelete((BaseEo)itemUnitConversionDgEo);
    }
}

