/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.constants.ItemConstants;
import com.yunxi.dg.base.center.item.convert.entity.SpecificationNameConverter;
import com.yunxi.dg.base.center.item.domain.entity.ISpecificationNameDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISpecificationValueDomain;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationNameDto;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationNamePageReqDto;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationValueDto;
import com.yunxi.dg.base.center.item.dto.request.SpecificationNameReqDto;
import com.yunxi.dg.base.center.item.dto.response.SpecificationNameDetailRespDto;
import com.yunxi.dg.base.center.item.eo.SpecificationNameEo;
import com.yunxi.dg.base.center.item.service.entity.ISpecificationNameService;
import com.yunxi.dg.base.center.item.service.util.ConvertDgUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpecificationNameServiceImpl
extends BaseServiceImpl<SpecificationNameDto, SpecificationNameEo, ISpecificationNameDomain>
implements ISpecificationNameService {
    @Resource
    private ISpecificationNameDomain specificationNameDomain;
    @Resource
    private ISpecificationValueDomain specificationValueDomain;

    public SpecificationNameServiceImpl(ISpecificationNameDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SpecificationNameDto, SpecificationNameEo> converter() {
        return SpecificationNameConverter.INSTANCE;
    }

    @Override
    public RestResponse<Long> add(SpecificationNameReqDto dto) {
        SpecificationNameEo nameEo = new SpecificationNameEo();
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        BeanUtil.copyProperties((Object)dto, (Object)nameEo, (String[])new String[0]);
        nameEo.setId(null);
        this.getNameVerify(dto.getName(), dto.getId());
        this.getCodeVerify(dto.getCode());
        this.specificationNameDomain.insert((BaseEo)nameEo);
        return new RestResponse((Object)nameEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> batchAdd(List<SpecificationNameReqDto> dtos) {
        if (CollectionUtil.isEmpty(dtos)) {
            return RestResponse.VOID;
        }
        HashSet<String> codeList = new HashSet<String>();
        HashSet<String> nameList = new HashSet<String>();
        for (SpecificationNameReqDto dto : dtos) {
            AssertUtils.isFalse((boolean)codeList.contains(dto.getCode()), (String)(dto.getCode() + "\u89c4\u683c\u9879\u7f16\u7801\u91cd\u590d"));
            AssertUtils.isFalse((boolean)nameList.contains(dto.getName()), (String)(dto.getName() + "\u89c4\u683c\u9879\u540d\u79f0\u7f16\u7801\u91cd\u590d"));
            codeList.add(dto.getCode());
            nameList.add(dto.getName());
        }
        Map<String, SpecificationNameEo> codeMap = this.getMapByCodeList(codeList);
        Map<String, SpecificationNameEo> nameMap = this.getMapByNameList(nameList);
        ArrayList<SpecificationNameEo> insertList = new ArrayList<SpecificationNameEo>();
        ArrayList<SpecificationNameEo> updateList = new ArrayList<SpecificationNameEo>();
        for (SpecificationNameReqDto dto : dtos) {
            SpecificationNameEo nameEo = nameMap.get(dto.getName());
            if (Objects.nonNull(nameEo)) {
                AssertUtils.isTrue((boolean)Objects.equals(dto.getCode(), nameEo.getCode()), (String)(dto.getName() + "\u89c4\u683c\u9879\u540d\u79f0\u5df2\u5b58\u5728!"));
            }
            SpecificationNameEo specificationNameEo = (SpecificationNameEo)BeanUtil.copyProperties((Object)dto, SpecificationNameEo.class, (String[])new String[0]);
            SpecificationNameEo codeEo = codeMap.get(dto.getCode());
            if (Objects.nonNull(codeEo)) {
                specificationNameEo.setId(codeEo.getId());
                updateList.add(specificationNameEo);
                continue;
            }
            insertList.add(specificationNameEo);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            for (SpecificationNameEo specificationNameEo : updateList) {
                this.specificationNameDomain.updateSelective((BaseEo)specificationNameEo);
            }
        }
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.specificationNameDomain.insertBatch(insertList);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateSpecificationName(SpecificationNameReqDto dto) {
        SpecificationNameEo nameEo = new SpecificationNameEo();
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getId(), (String)"\u8bf7\u6c42Id\u4e0d\u53ef\u4e3a\u7a7a!");
        SpecificationNameEo specificationNameEo = (SpecificationNameEo)this.specificationNameDomain.selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)specificationNameEo, (String)"\u89c4\u683c\u9879\u4fe1\u606f\u4e0d\u5b58\u5728!");
        BeanUtil.copyProperties((Object)dto, (Object)nameEo, (String[])new String[0]);
        this.getNameVerify(dto.getName(), dto.getId());
        nameEo.setCode(null);
        this.specificationNameDomain.updateSelective((BaseEo)nameEo);
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> removeByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return RestResponse.VOID;
        }
        List specificationNameEos = this.specificationNameDomain.selectByIds(ids);
        AssertUtils.notEmpty((Collection)specificationNameEos, (String)"\u89c4\u683c\u9879\u4fe1\u606f\u4e0d\u5b58\u5728!");
        for (SpecificationNameEo specificationNameEo : specificationNameEos) {
            AssertUtils.isFalse((boolean)Objects.equals(specificationNameEo.getIsUse(), ItemConstants.IS_USE_YES), (String)(specificationNameEo.getName() + "\u89c4\u683c\u9879\u5df2\u88ab\u5f15\u7528,\u4e0d\u53ef\u5220\u9664"));
        }
        this.specificationNameDomain.removeByIds(ids);
        this.specificationValueDomain.removeByNameIds(ids);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<SpecificationNameDetailRespDto> queryById(Long id) {
        SpecificationNameDetailRespDto nameDetailRespDto = new SpecificationNameDetailRespDto();
        SpecificationNameEo specificationNameEo = (SpecificationNameEo)this.specificationNameDomain.selectByPrimaryKey(id);
        if (Objects.isNull(specificationNameEo)) {
            return new RestResponse((Object)nameDetailRespDto);
        }
        BeanUtil.copyProperties((Object)specificationNameEo, (Object)nameDetailRespDto, (String[])new String[0]);
        List valueEos = ((ExtQueryChainWrapper)this.specificationValueDomain.filter().eq((Object)"prop_name_id", (Object)specificationNameEo.getId())).list();
        List specificationValueDtos = BeanUtil.copyToList((Collection)valueEos, SpecificationValueDto.class);
        nameDetailRespDto.setSpecificationValueDtoList(specificationValueDtos);
        return new RestResponse((Object)nameDetailRespDto);
    }

    @Override
    public RestResponse<PageInfo<SpecificationNameDetailRespDto>> queryPage(SpecificationNamePageReqDto dto) {
        PageInfo<SpecificationNameDetailRespDto> pageInfo = new PageInfo<SpecificationNameDetailRespDto>();
        SpecificationNameEo selectParam = this.getSelectParam(dto);
        PageInfo eoPageInfo = this.specificationNameDomain.selectPage((BaseEo)selectParam, dto.getPageNum(), dto.getPageSize());
        pageInfo = ConvertDgUtil.convertPage(eoPageInfo, SpecificationNameDetailRespDto.class);
        this.getSpecificationNameDetail(pageInfo.getList());
        return new RestResponse(pageInfo);
    }

    private void getSpecificationNameDetail(List<SpecificationNameDetailRespDto> nameDetailRespDtos) {
        if (CollectionUtil.isNotEmpty(nameDetailRespDtos)) {
            List nameIds = nameDetailRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
            List valueEos = ((ExtQueryChainWrapper)this.specificationValueDomain.filter().in((Object)"prop_name_id", nameIds)).list();
            if (CollectionUtil.isEmpty((Collection)valueEos)) {
                return;
            }
            List specificationValueDtos = BeanUtil.copyToList((Collection)valueEos, SpecificationValueDto.class);
            Map<Long, List<SpecificationValueDto>> valueMap = specificationValueDtos.stream().collect(Collectors.groupingBy(SpecificationValueDto::getPropNameId));
            for (SpecificationNameDetailRespDto nameDetailRespDto : nameDetailRespDtos) {
                nameDetailRespDto.setSpecificationValueDtoList(valueMap.get(nameDetailRespDto.getId()));
            }
        }
    }

    private Map<String, SpecificationNameEo> getMapByCodeList(Set<String> codeList) {
        Map<String, Object> codeMap = new HashMap<String, SpecificationNameEo>();
        if (CollectionUtil.isEmpty(codeList)) {
            return codeMap;
        }
        List codeEos = ((ExtQueryChainWrapper)this.specificationNameDomain.filter().in((Object)"code", codeList)).list();
        if (CollectionUtil.isNotEmpty((Collection)codeEos)) {
            codeMap = codeEos.stream().collect(Collectors.toMap(SpecificationNameEo::getCode, Function.identity(), (k1, k2) -> k2));
        }
        return codeMap;
    }

    private Map<String, SpecificationNameEo> getMapByNameList(Set<String> nameList) {
        Map<String, Object> nameEoMapMap = new HashMap<String, SpecificationNameEo>();
        if (CollectionUtil.isEmpty(nameList)) {
            return nameEoMapMap;
        }
        List codeEos = ((ExtQueryChainWrapper)this.specificationNameDomain.filter().in((Object)"name", nameList)).list();
        if (CollectionUtil.isNotEmpty((Collection)codeEos)) {
            nameEoMapMap = codeEos.stream().collect(Collectors.toMap(SpecificationNameEo::getCode, Function.identity(), (k1, k2) -> k2));
        }
        return nameEoMapMap;
    }

    private SpecificationNameEo getSelectParam(SpecificationNamePageReqDto dto) {
        SpecificationNameEo nameEo = new SpecificationNameEo();
        BeanUtil.copyProperties((Object)dto, (Object)nameEo, (String[])new String[0]);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (Objects.nonNull(dto)) {
            if (CollectionUtil.isNotEmpty((Collection)dto.getIdList())) {
                sqlFilters.add(SqlFilter.in((String)"id", (Object)dto.getIdList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getCodeList())) {
                sqlFilters.add(SqlFilter.in((String)"code", (Object)dto.getCodeList()));
            }
            if (Objects.nonNull(dto.getCode())) {
                nameEo.setCode(null);
                sqlFilters.add(SqlFilter.like((String)"code", (Object)dto.getCode()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getNameList())) {
                sqlFilters.add(SqlFilter.in((String)"name", (Object)dto.getNameList()));
            }
            if (Objects.nonNull(dto.getName())) {
                nameEo.setName(null);
                sqlFilters.add(SqlFilter.like((String)"name", (Object)dto.getName()));
            }
            if (Objects.nonNull(dto.getCreateStartTime())) {
                sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)dto.getCreateStartTime()));
            }
            if (Objects.nonNull(dto.getCreateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"create_time", (Object)dto.getCreateEndTime()));
            }
            if (Objects.nonNull(dto.getUpdateStartTime())) {
                sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)dto.getUpdateStartTime()));
            }
            if (Objects.nonNull(dto.getUpdateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"update_time", (Object)dto.getUpdateEndTime()));
            }
        }
        nameEo.setSqlFilters(sqlFilters);
        nameEo.setOrderByDesc("id");
        return nameEo;
    }

    private void getNameVerify(String name, Long id) {
        if (Objects.nonNull(name)) {
            List nameEos = ((ExtQueryChainWrapper)this.specificationNameDomain.filter().eq((Object)"name", (Object)name)).list();
            if (CollectionUtil.isEmpty((Collection)nameEos)) {
                return;
            }
            AssertUtils.isTrue((nameEos.size() < 2 ? 1 : 0) != 0, (String)"\u89c4\u683c\u9879\u540d\u79f0\u5df2\u91cd\u590d\u5b58\u5728");
            AssertUtils.isTrue((boolean)Objects.equals(((SpecificationNameEo)nameEos.get(0)).getId(), id), (String)("\u89c4\u683c\u9879\u540d\u79f0<" + name + ">\u5df2\u5b58\u5728"));
        }
    }

    private void getCodeVerify(String code) {
        if (Objects.nonNull(code)) {
            List codeEos = ((ExtQueryChainWrapper)this.specificationNameDomain.filter().eq((Object)"code", (Object)code)).list();
            AssertUtils.isTrue((boolean)CollectionUtil.isEmpty((Collection)codeEos), (String)"\u89c4\u683c\u9879\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }
}

