/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.convert.entity.SpecificationValueConverter;
import com.yunxi.dg.base.center.item.domain.entity.ISpecificationNameDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISpecificationValueDomain;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationValueDto;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationValuePageReqDto;
import com.yunxi.dg.base.center.item.dto.request.SpecificationValueReqDto;
import com.yunxi.dg.base.center.item.eo.SpecificationNameEo;
import com.yunxi.dg.base.center.item.eo.SpecificationValueEo;
import com.yunxi.dg.base.center.item.service.entity.ISpecificationValueService;
import com.yunxi.dg.base.center.item.service.util.ConvertDgUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpecificationValueServiceImpl
extends BaseServiceImpl<SpecificationValueDto, SpecificationValueEo, ISpecificationValueDomain>
implements ISpecificationValueService {
    @Resource
    private ISpecificationValueDomain specificationValueDomain;
    @Resource
    private ISpecificationNameDomain specificationNameDomain;

    public SpecificationValueServiceImpl(ISpecificationValueDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SpecificationValueDto, SpecificationValueEo> converter() {
        return SpecificationValueConverter.INSTANCE;
    }

    @Override
    public RestResponse<Long> add(SpecificationValueReqDto dto) {
        SpecificationValueEo valueEo = new SpecificationValueEo();
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.isTrue((Objects.nonNull(dto.getPropNameCode()) || Objects.nonNull(dto.getPropNameId()) ? 1 : 0) != 0, (String)"\u672a\u6307\u5b9a\u89c4\u683c\u9879!");
        List nameList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.specificationNameDomain.filter().eq(Objects.nonNull(dto.getPropNameCode()), (Object)"code", (Object)dto.getPropNameCode())).eq(Objects.nonNull(dto.getPropNameId()), (Object)"id", (Object)dto.getPropNameId())).list();
        AssertUtils.notEmpty((Collection)nameList, (String)"\u89c4\u683c\u9879\u4e0d\u5b58\u5728!");
        BeanUtil.copyProperties((Object)dto, (Object)valueEo, (String[])new String[0]);
        this.getNameVerify(dto.getName(), dto.getId(), dto.getPropNameId());
        this.getCodeVerify(dto.getCode(), dto.getPropNameId());
        valueEo.setId(null);
        valueEo.setLeastKey(valueEo.getPropNameId() + valueEo.getName());
        valueEo.setPropNameId(((SpecificationNameEo)nameList.get(0)).getId());
        this.specificationValueDomain.insert((BaseEo)valueEo);
        return new RestResponse((Object)valueEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> addBatch(List<SpecificationValueReqDto> dtos) {
        HashMap<String, Object> valueEoMap = new HashMap<String, Object>();
        HashSet<String> leastKeySet = new HashSet<String>();
        HashSet<String> nameCodeSet = new HashSet<String>();
        for (SpecificationValueReqDto dto : dtos) {
            AssertUtils.notNull((Object)dto.getPropNameCode(), (String)"\u672a\u6307\u5b9a\u89c4\u683c\u9879!");
            nameCodeSet.add(dto.getPropNameCode());
            String leastKey = dto.getPropNameId() + dto.getName();
            AssertUtils.isFalse((boolean)leastKeySet.contains(leastKey), (String)(dto.getPropNameId() + "\u540c\u4e00\u89c4\u683c\u9879\u7684\u89c4\u683c\u503c\u540d\u79f0\u5df2\u91cd\u590d: " + dto.getName()));
            dto.setLeastKey(leastKey);
            leastKeySet.add(leastKey);
        }
        List nameEos = ((ExtQueryChainWrapper)this.specificationNameDomain.filter().in((Object)"code", nameCodeSet)).list();
        AssertUtils.notEmpty((Collection)nameEos, (String)"\u89c4\u683c\u9879\u4fe1\u606f\u4e0d\u5b58\u5728!");
        Map nameMap = nameEos.stream().collect(Collectors.toMap(SpecificationNameEo::getCode, Function.identity(), (k1, k2) -> k2));
        for (SpecificationValueReqDto dto : dtos) {
            SpecificationNameEo nameEo = (SpecificationNameEo)nameMap.get(dto.getPropNameCode());
            AssertUtils.notNull((Object)nameEo, (String)(dto.getPropNameCode() + "\u5173\u8054\u7684\u89c4\u683c\u9879\u4e0d\u5b58\u5728!"));
            dto.setPropNameId(nameEo.getId());
            valueEoMap.put(dto.getCode(), BeanUtil.copyProperties((Object)dto, SpecificationValueEo.class, (String[])new String[0]));
        }
        Set<String> codeSet = valueEoMap.keySet();
        Map<String, SpecificationValueEo> codeMap = this.getMapByCodeSet(codeSet);
        Map<String, SpecificationValueEo> leastKeyMap = this.getMapByLeastKeySet(leastKeySet);
        ArrayList<SpecificationValueEo> insertList = new ArrayList<SpecificationValueEo>();
        ArrayList<SpecificationValueEo> updateList = new ArrayList<SpecificationValueEo>();
        for (SpecificationValueEo value : valueEoMap.values()) {
            SpecificationValueEo valueCodeEo;
            SpecificationValueEo valueEo = leastKeyMap.get(value.getLeastKey());
            if (Objects.nonNull(valueEo)) {
                AssertUtils.isTrue((boolean)Objects.equals(valueEo.getCode(), value.getCode()), (String)(valueEo.getPropNameId() + "\u540c\u4e00\u89c4\u683c\u9879\u7684\u89c4\u683c\u503c\u540d\u79f0\u5df2\u5b58\u5728: " + valueEo.getName()));
            }
            if (Objects.nonNull(valueCodeEo = codeMap.get(value.getCode()))) {
                value.setId(valueCodeEo.getId());
                updateList.add(value);
                continue;
            }
            insertList.add(value);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            for (SpecificationValueEo valueEo : updateList) {
                this.specificationValueDomain.updateSelective((BaseEo)valueEo);
            }
        }
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.specificationValueDomain.insertBatch(insertList);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateSpecificationValue(SpecificationValueReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getId(), (String)"id\u4e0d\u53ef\u4e3a\u7a7a!");
        SpecificationValueEo valueEo = (SpecificationValueEo)this.specificationValueDomain.selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)valueEo, (String)"\u89c4\u683c\u503c\u4fe1\u606f\u4e0d\u5b58\u5728!");
        this.getNameVerify(dto.getName(), dto.getId(), valueEo.getPropNameId());
        BeanUtil.copyProperties((Object)dto, (Object)valueEo, (String[])new String[0]);
        if (Objects.nonNull(dto.getName())) {
            valueEo.setLeastKey(valueEo.getPropNameId() + dto.getName());
        }
        valueEo.setPropNameId(null);
        valueEo.setCode(null);
        this.specificationValueDomain.updateSelective((BaseEo)valueEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeByIds(List<Long> ids) {
        if (CollectionUtil.isNotEmpty(ids)) {
            this.specificationValueDomain.logicDeleteByIds(ids);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<SpecificationValueDto> queryById(Long id) {
        SpecificationValueDto specificationValueDto = new SpecificationValueDto();
        SpecificationValueEo specificationValueEo = (SpecificationValueEo)this.specificationValueDomain.selectByPrimaryKey(id);
        BeanUtil.copyProperties((Object)specificationValueDto, (Object)specificationValueEo, (String[])new String[0]);
        return new RestResponse((Object)specificationValueDto);
    }

    @Override
    public RestResponse<PageInfo<SpecificationValueDto>> queryPage(SpecificationValuePageReqDto dto) {
        PageInfo<SpecificationValueDto> pageInfo = new PageInfo<SpecificationValueDto>();
        SpecificationValueEo selectParam = this.getSelectParam(dto);
        PageInfo eoPageInfo = this.specificationValueDomain.selectPage((BaseEo)selectParam, dto.getPageNum(), dto.getPageSize());
        pageInfo = ConvertDgUtil.convertPage(eoPageInfo, SpecificationValueDto.class);
        return new RestResponse(pageInfo);
    }

    private SpecificationValueEo getSelectParam(SpecificationValuePageReqDto dto) {
        SpecificationValueEo valueEo = new SpecificationValueEo();
        BeanUtil.copyProperties((Object)dto, (Object)valueEo, (String[])new String[0]);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (Objects.nonNull(dto)) {
            if (CollectionUtil.isNotEmpty((Collection)dto.getIdList())) {
                sqlFilters.add(SqlFilter.in((String)"id", (Object)dto.getIdList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getCodeList())) {
                sqlFilters.add(SqlFilter.in((String)"code", (Object)dto.getCodeList()));
            }
            if (Objects.nonNull(dto.getCode())) {
                valueEo.setCode(null);
                sqlFilters.add(SqlFilter.like((String)"code", (Object)dto.getCode()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getExternalCodeList())) {
                sqlFilters.add(SqlFilter.in((String)"external_code", (Object)dto.getExternalCodeList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getLeastKeyList())) {
                sqlFilters.add(SqlFilter.in((String)"least_key", (Object)dto.getLeastKeyList()));
            }
            if (Objects.nonNull(dto.getExternalCode())) {
                valueEo.setCode(null);
                sqlFilters.add(SqlFilter.like((String)"external_code", (Object)dto.getExternalCode()));
            }
            if (Objects.nonNull(dto.getName())) {
                valueEo.setName(null);
                sqlFilters.add(SqlFilter.like((String)"name", (Object)dto.getName()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getNameList())) {
                sqlFilters.add(SqlFilter.in((String)"name", (Object)dto.getNameList()));
            }
            if (Objects.nonNull(dto.getCreateBeginTime())) {
                sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)dto.getCreateBeginTime()));
            }
            if (Objects.nonNull(dto.getCreateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"create_time", (Object)dto.getCreateEndTime()));
            }
            if (Objects.nonNull(dto.getUpdateBeginTime())) {
                sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)dto.getUpdateBeginTime()));
            }
            if (Objects.nonNull(dto.getUpdateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"update_time", (Object)dto.getUpdateEndTime()));
            }
        }
        valueEo.setSqlFilters(sqlFilters);
        valueEo.setOrderByDesc("id");
        return valueEo;
    }

    private void getCodeVerify(String code, Long nameId) {
        if (Objects.nonNull(code)) {
            List codeEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.specificationValueDomain.filter().eq((Object)"prop_name_id", (Object)nameId)).eq((Object)"code", (Object)code)).list();
            AssertUtils.isTrue((boolean)CollectionUtil.isEmpty((Collection)codeEos), (String)"\u89c4\u683c\u503c\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }

    private void getNameVerify(String name, Long id, Long nameId) {
        if (Objects.nonNull(name)) {
            List nameEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.specificationValueDomain.filter().eq((Object)"prop_name_id", (Object)nameId)).eq((Object)"name", (Object)name)).list();
            if (CollectionUtil.isEmpty((Collection)nameEos)) {
                return;
            }
            AssertUtils.isTrue((nameEos.size() < 2 ? 1 : 0) != 0, (String)"\u89c4\u683c\u503c\u540d\u79f0\u5df2\u91cd\u590d\u5b58\u5728");
            AssertUtils.isTrue((boolean)Objects.equals(((SpecificationValueEo)nameEos.get(0)).getId(), id), (String)"\u89c4\u683c\u503c\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }

    private Map<String, SpecificationValueEo> getMapByCodeSet(Set<String> codeSet) {
        Map<String, Object> valueEoMap = new HashMap<String, SpecificationValueEo>();
        if (CollectionUtil.isEmpty(codeSet)) {
            return valueEoMap;
        }
        List codeEos = ((ExtQueryChainWrapper)this.specificationValueDomain.filter().in((Object)"code", codeSet)).list();
        if (CollectionUtil.isNotEmpty((Collection)codeEos)) {
            valueEoMap = codeEos.stream().collect(Collectors.toMap(SpecificationValueEo::getCode, Function.identity(), (k1, k2) -> k2));
        }
        return valueEoMap;
    }

    private Map<String, SpecificationValueEo> getMapByLeastKeySet(Set<String> leastKeySet) {
        Map<String, Object> valueEoMap = new HashMap<String, SpecificationValueEo>();
        if (CollectionUtil.isEmpty(leastKeySet)) {
            return valueEoMap;
        }
        List codeEos = ((ExtQueryChainWrapper)this.specificationValueDomain.filter().in((Object)"least_key", leastKeySet)).list();
        if (CollectionUtil.isNotEmpty((Collection)codeEos)) {
            valueEoMap = codeEos.stream().collect(Collectors.toMap(SpecificationValueEo::getCode, Function.identity(), (k1, k2) -> k2));
        }
        return valueEoMap;
    }
}

