/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.util;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParamDgUtils {
    private static final Logger logger = LoggerFactory.getLogger(QueryParamDgUtils.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String CREATE_TIME = "createTime";
    private static final String UPDATE_TIME = "updateTime";

    public static void fillQueryCreateStartTime(String timeFormat, BaseEo baseEo) {
        if (QueryParamDgUtils.checkTimeFormat(timeFormat)) {
            baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), CREATE_TIME, SqlFilter.Operator.gt, timeFormat));
        }
    }

    public static void fillQueryCreateStartTime(String timeFormat, BaseEo baseEo, String operator) {
        if (QueryParamDgUtils.checkTimeFormat(timeFormat)) {
            if (operator.equals("gt")) {
                baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), CREATE_TIME, SqlFilter.Operator.gt, timeFormat));
            }
            if (operator.equals("ge")) {
                baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), CREATE_TIME, SqlFilter.Operator.ge, timeFormat));
            }
        }
    }

    public static void fillQueryCreateEndTime(String timeFormat, BaseEo baseEo) {
        if (QueryParamDgUtils.checkTimeFormat(timeFormat)) {
            int timeLength = 10;
            if (timeFormat.trim().length() == timeLength) {
                timeFormat = timeFormat + " 23:59:59";
            }
            baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), CREATE_TIME, SqlFilter.Operator.lt, timeFormat));
        }
    }

    public static void fillQueryCreateEndTime(String timeFormat, BaseEo baseEo, String operator) {
        if (QueryParamDgUtils.checkTimeFormat(timeFormat)) {
            int timeLength = 10;
            if (timeFormat.trim().length() == timeLength) {
                timeFormat = timeFormat + " 23:59:59";
            }
            if (operator.equals("lt")) {
                baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), CREATE_TIME, SqlFilter.Operator.lt, timeFormat));
            }
            if (operator.equals("le")) {
                baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), CREATE_TIME, SqlFilter.Operator.le, timeFormat));
            }
        }
    }

    public static void fillQueryUpdateTime(String startTime, String endTime, BaseEo baseEo) {
        int timeLength = 10;
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            if (startTime.trim().length() == timeLength) {
                startTime = startTime.trim() + " 23:59:59";
            }
            baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), UPDATE_TIME, SqlFilter.Operator.ge, startTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            if (endTime.trim().length() == timeLength) {
                endTime = endTime.trim() + " 23:59:59";
            }
            baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), UPDATE_TIME, SqlFilter.Operator.ge, startTime));
        }
    }

    public static void fillQueryUpdateStartTime(String timeFormat, BaseEo baseEo) {
        if (QueryParamDgUtils.checkTimeFormat(timeFormat)) {
            baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), UPDATE_TIME, SqlFilter.Operator.gt, timeFormat));
        }
    }

    public static void fillQueryUpdateStartTime(String timeFormat, BaseEo baseEo, String operator) {
        if (QueryParamDgUtils.checkTimeFormat(timeFormat)) {
            if (operator.equals("gt")) {
                baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), UPDATE_TIME, SqlFilter.Operator.gt, timeFormat));
            }
            if (operator.equals("ge")) {
                baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), UPDATE_TIME, SqlFilter.Operator.ge, timeFormat));
            }
        }
    }

    public static void fillQueryUpdateEndTime(String timeFormat, BaseEo baseEo) {
        if (QueryParamDgUtils.checkTimeFormat(timeFormat)) {
            int timeLength = 10;
            if (timeFormat.trim().length() == timeLength) {
                timeFormat = timeFormat + " 23:59:59";
            }
            baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), UPDATE_TIME, SqlFilter.Operator.lt, timeFormat));
        }
    }

    public static void fillQueryUpdateEndTime(String timeFormat, BaseEo baseEo, String operator) {
        if (QueryParamDgUtils.checkTimeFormat(timeFormat)) {
            int timeLength = 10;
            if (timeFormat.trim().length() == timeLength) {
                timeFormat = timeFormat + " 23:59:59";
            }
            if (operator.equals("lt")) {
                baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), UPDATE_TIME, SqlFilter.Operator.lt, timeFormat));
            }
            if (operator.equals("le")) {
                baseEo.setSqlFilters(QueryParamDgUtils.fillQueryParam(baseEo.getSqlFilters(), UPDATE_TIME, SqlFilter.Operator.le, timeFormat));
            }
        }
    }

    public static void columnLike(BaseEo baseEo, String column, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        ArrayList<SqlFilter> sqlFilterList = baseEo.getSqlFilters();
        if (sqlFilterList == null) {
            sqlFilterList = new ArrayList<SqlFilter>();
        }
        sqlFilterList.add(SqlFilter.like((String)column, (Object)("%" + value.replaceAll("#", "") + "%")));
        baseEo.setSqlFilters(sqlFilterList);
        try {
            Field field = baseEo.getClass().getDeclaredField(column);
            if (field != null) {
                field.setAccessible(true);
                field.set(baseEo, null);
            }
        }
        catch (Exception e) {
            try {
                Field field = baseEo.getClass().getSuperclass().getDeclaredField(column);
                if (field != null) {
                    field.setAccessible(true);
                    field.set(baseEo, null);
                }
            }
            catch (Exception e1) {
                logger.error(e.getMessage(), (Throwable)e1);
                throw new ItemBusinessRuntimeException(e1.getMessage());
            }
        }
    }

    private static boolean checkTimeFormat(String timeFormat) {
        boolean result = false;
        if (StringUtils.isBlank((CharSequence)timeFormat)) {
            return result;
        }
        return true;
    }

    private static List<SqlFilter> fillQueryParam(List<SqlFilter> sqlFilters, String paramName, SqlFilter.Operator operator, String timeFormat) {
        if (sqlFilters == null) {
            sqlFilters = new ArrayList<SqlFilter>();
        }
        if (operator.equals((Object)SqlFilter.Operator.gt)) {
            sqlFilters.add(SqlFilter.gt((String)paramName, (Object)timeFormat));
        } else if (operator.equals((Object)SqlFilter.Operator.ge)) {
            sqlFilters.add(SqlFilter.ge((String)paramName, (Object)timeFormat));
        } else if (operator.equals((Object)SqlFilter.Operator.lt)) {
            sqlFilters.add(SqlFilter.lt((String)paramName, (Object)timeFormat));
        } else if (operator.equals((Object)SqlFilter.Operator.le)) {
            sqlFilters.add(SqlFilter.le((String)paramName, (Object)timeFormat));
        }
        return sqlFilters;
    }
}

