/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeDgUtils {
    private static Logger logger = LoggerFactory.getLogger(SerializeDgUtils.class);

    public static <T> String serialize(T obj, Class clazz) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.register(clazz, (Serializer)new JavaSerializer());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        kryo.writeClassAndObject(output, obj);
        output.flush();
        output.close();
        byte[] b = baos.toByteArray();
        try {
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return new String(new Base64().encode(b));
    }

    public static <T> T deserialize(String obj, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.register(clazz, (Serializer)new JavaSerializer());
        ByteArrayInputStream bais = new ByteArrayInputStream(new Base64().decode(obj.getBytes()));
        Input input = new Input((InputStream)bais);
        return (T)kryo.readClassAndObject(input);
    }
}

