/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.dao.common.select;

import com.yunxi.dg.base.center.pulldata.dao.common.select.SelectGeneric;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartJoinSelectGeneric
extends SelectGeneric {
    private static final Logger log = LoggerFactory.getLogger(MultipartJoinSelectGeneric.class);
    private boolean leftJoinFlag = false;
    private List<String> leftJoinOns;

    public MultipartJoinSelectGeneric(String tableName, String alias) {
        super(tableName, alias);
        super.setUseMultipart(true);
    }

    @Override
    public void end() {
        super.end();
        if (this.leftJoinFlag && CollectionUtils.isEmpty(this.leftJoinOns)) {
            throw new RuntimeException("\u5728\u4f7f\u7528left join \u65f6\uff0c\u8bf7\u586b\u5199on\u6761\u4ef6\uff01");
        }
    }

    @Override
    public SelectGeneric groupBy(String field) {
        super.groupBy(field);
        return this;
    }

    @Override
    public SelectGeneric orderBy(String field, String orderType) {
        super.orderBy(field, orderType);
        return this;
    }

    public MultipartJoinSelectGeneric addLeftJoin(String tableName, String alias, String on) {
        this.leftJoinFlag = true;
        super.addTableName(tableName);
        super.addAlias(alias, tableName);
        if (CollectionUtils.isEmpty(this.leftJoinOns)) {
            this.leftJoinOns = new ArrayList<String>();
        }
        this.leftJoinOns.add(on);
        return this;
    }

    public boolean isLeftJoinFlag() {
        return this.leftJoinFlag;
    }

    public List<String> getLeftJoinOns() {
        return this.leftJoinOns;
    }

    public void setLeftJoinFlag(boolean leftJoinFlag) {
        this.leftJoinFlag = leftJoinFlag;
    }

    public void setLeftJoinOns(List<String> leftJoinOns) {
        this.leftJoinOns = leftJoinOns;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipartJoinSelectGeneric)) {
            return false;
        }
        MultipartJoinSelectGeneric other = (MultipartJoinSelectGeneric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLeftJoinFlag() != other.isLeftJoinFlag()) {
            return false;
        }
        List<String> this$leftJoinOns = this.getLeftJoinOns();
        List<String> other$leftJoinOns = other.getLeftJoinOns();
        return !(this$leftJoinOns == null ? other$leftJoinOns != null : !((Object)this$leftJoinOns).equals(other$leftJoinOns));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultipartJoinSelectGeneric;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLeftJoinFlag() ? 79 : 97);
        List<String> $leftJoinOns = this.getLeftJoinOns();
        result = result * 59 + ($leftJoinOns == null ? 43 : ((Object)$leftJoinOns).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MultipartJoinSelectGeneric(leftJoinFlag=" + this.isLeftJoinFlag() + ", leftJoinOns=" + this.getLeftJoinOns() + ")";
    }
}

