/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.constants;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum ErpInventoryTypeEnum {
    CC("CC", "\u6b8b\u54c1", "un_qualified"),
    ZP("ZP", "\u53ef\u7528", "qualified"),
    QC("QC", "\u5f85\u68c0", "wait_inspection"),
    DJ("DJ", "\u51bb\u7ed3", "freeze"),
    KCZT01_SYS("KCZT01_SYS", "\u53ef\u7528", "qualified"),
    KCZT05_SYS("KCZT05_SYS", "\u5728\u9014", null),
    KCZT002("KCZT002", "\u53ef\u7528", "qualified"),
    KCZT001("KCZT001", "\u53ef\u7528", "qualified");

    private String code;
    private String desc;
    private String property;
    public static final Map<String, ErpInventoryTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private ErpInventoryTypeEnum(String code, String desc, String property) {
        this.code = code;
        this.desc = desc;
        this.property = property;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static ErpInventoryTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public static String getDesc(String index) {
        for (ErpInventoryTypeEnum inventoryTypeEnum : ErpInventoryTypeEnum.values()) {
            if (!inventoryTypeEnum.getCode().equals(index)) continue;
            return inventoryTypeEnum.getDesc();
        }
        return null;
    }

    public static String getCode(String index) {
        for (ErpInventoryTypeEnum inventoryTypeEnum : ErpInventoryTypeEnum.values()) {
            if (!inventoryTypeEnum.getDesc().equals(index)) continue;
            return inventoryTypeEnum.getCode();
        }
        return null;
    }

    public static ErpInventoryTypeEnum getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Arrays.asList(ErpInventoryTypeEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }

    public static String getInventoryProperties(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (ErpInventoryTypeEnum inventoryTypeEnum : ErpInventoryTypeEnum.values()) {
            if (!inventoryTypeEnum.getCode().equals(code)) continue;
            return inventoryTypeEnum.property;
        }
        return code;
    }

    static {
        CODE_LOOKUP = Arrays.stream(ErpInventoryTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(ErpInventoryTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

