/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.service.component.comparator;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.yunxi.dg.base.center.pulldata.constants.DifferenceReasonEnum;
import com.yunxi.dg.base.center.pulldata.constants.DifferenceResultStatusEnum;
import com.yunxi.dg.base.center.pulldata.dao.common.select.SelectGeneric;
import com.yunxi.dg.base.center.pulldata.dao.das.common.ISelectGenericDas;
import com.yunxi.dg.base.center.pulldata.dto.entity.PmsInventoryPostDetailDto;
import com.yunxi.dg.base.center.pulldata.dto.entity.ReconciliationDifferenceDto;
import com.yunxi.dg.base.center.pulldata.dto.entity.ThreeInventoryPostDetailDto;
import com.yunxi.dg.base.center.pulldata.service.component.KeyCenter;
import com.yunxi.dg.base.center.pulldata.service.component.context.InventoryDocumentCompareContext;
import com.yunxi.dg.base.center.pulldata.service.component.key.KeyAssemblyStrategy;
import com.yunxi.dg.base.center.pulldata.service.component.key.impl.DefaultKeyAssemblyStrategy;
import com.yunxi.dg.base.center.pulldata.service.component.key.impl.DefaultThreeKeyAssemblyStrategy;
import com.yunxi.dg.base.center.pulldata.service.component.refresher.DataInserter;
import com.yunxi.dg.base.center.pulldata.service.entity.IReconciliationDifferenceService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InventoryDocumentComparator {
    private static final Logger log = LoggerFactory.getLogger(InventoryDocumentComparator.class);
    @Resource
    private IReconciliationDifferenceService reconciliationDifferenceService;
    @Resource
    private ISelectGenericDas selectGenericDas;
    @Resource
    private DataInserter dataInserter;

    public void compare(InventoryDocumentCompareContext context) {
        List<PmsInventoryPostDetailDto> list = this.merge(this.loadInventoryPostDetails(context.getPmsGeneric(), PmsInventoryPostDetailDto.class), context.getKeyAssemblyStrategyList());
        List<ThreeInventoryPostDetailDto> list3 = this.merge3(this.loadInventoryPostDetails(context.getThreeGeneric(), ThreeInventoryPostDetailDto.class), context.getThreeKeyAssemblyStrategyList());
        this.doCompare(context, list, list3);
    }

    private void doCompare(InventoryDocumentCompareContext context, List<PmsInventoryPostDetailDto> pmsInventoryList, List<ThreeInventoryPostDetailDto> threeInventoryList) {
        log.info("[\u5e93\u5b58\u5355\u636e\u6bd4\u5bf9]\u5f00\u59cb\u5bf9\u6bd4--,pmsInventoryList\u6761\u6570\uff1a{}\uff0cthreeInventoryList\u6761\u6570\uff1a{}", (Object)pmsInventoryList.size(), (Object)threeInventoryList.size());
        if (Objects.equals("WMS", context.getTargetObject()) || CollectionUtils.isNotEmpty(threeInventoryList) && Objects.equals("WMS", ((ThreeInventoryPostDetailDto)threeInventoryList.get(0)).getSource())) {
            List orderNos = pmsInventoryList.stream().filter(e -> StringUtils.isNotEmpty((String)e.getExtension())).map(e -> {
                String extension = (String)this.getExtensionData(e.getExtension(), "extension");
                Integer earlyProductOutbound = Optional.ofNullable((Integer)this.getExtensionData(extension, "earlyProductOutbound")).orElse(0);
                Integer closeOrderOutbound = Optional.ofNullable((Integer)this.getExtensionData(extension, "closeOrderOutbound")).orElse(0);
                if (1 == earlyProductOutbound || 1 == closeOrderOutbound) {
                    return e.getResultOrderNo();
                }
                return null;
            }).distinct().collect(Collectors.toList());
            pmsInventoryList = pmsInventoryList.stream().filter(e -> !orderNos.contains(e.getResultOrderNo())).collect(Collectors.toList());
            threeInventoryList = threeInventoryList.stream().filter(e -> !orderNos.contains(e.getOrderNo())).collect(Collectors.toList());
            log.info("[\u5e93\u5b58\u5355\u636e\u6bd4\u5bf9]wms\u6765\u6e90\uff0c\u8fc7\u6ee4\u540epmsInventoryList\u6761\u6570\uff1a{}\uff0cthreeInventoryList\u6761\u6570\uff1a{}", (Object)pmsInventoryList.size(), (Object)threeInventoryList.size());
        }
        Map<String, List<ThreeInventoryPostDetailDto>> key2ThreeInventoryPostDetailMap = threeInventoryList.stream().collect(Collectors.groupingBy(x -> KeyCenter.genKey(x.getMatchKey(), "", x.getInventoryProperty(), x.getSkuCode())));
        int threeNoRecordNum = 0;
        int pmsNoRecordNum = 0;
        int compareNum = 0;
        List<Object> result = new ArrayList<ReconciliationDifferenceDto>();
        for (PmsInventoryPostDetailDto pmsInventoryPostDetailDto : pmsInventoryList) {
            String detailKey = KeyCenter.genKey(pmsInventoryPostDetailDto.getMatchKey(), "", pmsInventoryPostDetailDto.getInventoryProperty(), pmsInventoryPostDetailDto.getSkuCode());
            List<ThreeInventoryPostDetailDto> threeDetailDtos = key2ThreeInventoryPostDetailMap.get(detailKey);
            if (CollectionUtils.isNotEmpty(threeDetailDtos)) {
                for (ThreeInventoryPostDetailDto threeDetailDto : threeDetailDtos) {
                    AddResult addResult = new AddResult(context, key2ThreeInventoryPostDetailMap, threeNoRecordNum, compareNum, result, pmsInventoryPostDetailDto, detailKey, threeDetailDto).invoke();
                    threeNoRecordNum = addResult.getThreeNoRecordNum();
                    compareNum = addResult.getCompareNum();
                }
                continue;
            }
            AddResult addResult = new AddResult(context, key2ThreeInventoryPostDetailMap, threeNoRecordNum, compareNum, result, pmsInventoryPostDetailDto, detailKey, null).invoke();
            threeNoRecordNum = addResult.getThreeNoRecordNum();
            compareNum = addResult.getCompareNum();
        }
        pmsNoRecordNum = key2ThreeInventoryPostDetailMap.size();
        for (String string : key2ThreeInventoryPostDetailMap.keySet()) {
            List<ThreeInventoryPostDetailDto> threeDetailDtos = key2ThreeInventoryPostDetailMap.get(string);
            if (CollectionUtils.isNotEmpty(threeDetailDtos)) {
                for (ThreeInventoryPostDetailDto detailDto : threeDetailDtos) {
                    this.addResult(context, result, detailDto);
                }
                continue;
            }
            this.addResult(context, result, null);
        }
        ReconciliationDifferenceDto differenceDto = new ReconciliationDifferenceDto();
        differenceDto.setReconciliationTime(context.getReconciliationTime());
        differenceDto.setSource(context.getTargetObject());
        this.reconciliationDifferenceService.deleteReconciliationDifference(differenceDto);
        if (CollectionUtils.isNotEmpty(result)) {
            result = result.stream().filter(ld -> {
                if (!"U9".equals(ld.getSource()) || StringUtils.isBlank((String)ld.getRelevanceBizNo()) || !ld.getRelevanceBizNo().startsWith("DD")) {
                    log.info("\u5355\u636e\u5bf9\u8d26\u4e0d\u8fc7\u6ee4\u5355\u636e {} {}", (Object)ld.getRelevanceBizNo(), (Object)ld.getSource());
                    return true;
                }
                log.info("\u548cU9\u5bf9\u8d26\u7684\u65f6\u5019\u8fc7\u6ee4DD\u5f00\u5934\u7684\u5355\u636e {} {}", (Object)ld.getRelevanceBizNo(), (Object)ld.getSource());
                return false;
            }).collect(Collectors.toList());
            this.dataInserter.doBatchInsert(this.reconciliationDifferenceService, result);
        }
        log.info("[\u5e93\u5b58\u5355\u636e\u6bd4\u5bf9]\u6b63\u5e38\u6bd4\u5bf9\u8bb0\u5f55\uff1a{}", (Object)compareNum);
        log.info("[\u5e93\u5b58\u5355\u636e\u6bd4\u5bf9]\u4e2d\u53f0\u65e0\u6b64\u8bb0\u5f55\uff1a{}", (Object)pmsNoRecordNum);
        log.info("[\u5e93\u5b58\u5355\u636e\u6bd4\u5bf9]\u4e09\u65b9{}\u65e0\u6b64\u8bb0\u5f55\uff1a{}", (Object)context.getTargetObject(), (Object)threeNoRecordNum);
    }

    private void addResult(InventoryDocumentCompareContext context, List<ReconciliationDifferenceDto> result, ThreeInventoryPostDetailDto detailDto) {
        ReconciliationDifferenceDto differenceEo = this.buildReconciliationDifferenceEo(null, detailDto);
        differenceEo.setReconciliationTime(context.getReconciliationTime());
        differenceEo.setSource(context.getTargetObject());
        differenceEo.setResult(String.valueOf(DifferenceResultStatusEnum.INCONSISTENT.getValue()));
        differenceEo.setDifferenceReason(String.valueOf(DifferenceReasonEnum.PMS_NO_RECORD.getValue()));
        differenceEo.setDifferenceNum(BigDecimalUtils.subtract((BigDecimal)BigDecimal.ZERO, (BigDecimal)differenceEo.getOsQuantity()));
        result.add(differenceEo);
    }

    public ReconciliationDifferenceDto buildReconciliationDifferenceEo(PmsInventoryPostDetailDto detailDto, ThreeInventoryPostDetailDto threeDetailDto) {
        ReconciliationDifferenceDto differenceEo = new ReconciliationDifferenceDto();
        if (threeDetailDto != null) {
            differenceEo.setOsOrderNo(threeDetailDto.getOsBizNo());
            differenceEo.setOsOrderType(threeDetailDto.getOsBizTypeStr());
            differenceEo.setOsBatch(threeDetailDto.getBatch());
            differenceEo.setOsWarehouseCode(threeDetailDto.getWarehouseCode());
            differenceEo.setOsWarehouseName(threeDetailDto.getWarehouseName());
            differenceEo.setLogicWarehouseCode(threeDetailDto.getWarehouseCode());
            differenceEo.setLogicWarehouseName(threeDetailDto.getWarehouseName());
            differenceEo.setOsBatch(threeDetailDto.getBatch());
            differenceEo.setSkuCode(threeDetailDto.getSkuCode());
            differenceEo.setSkuName(threeDetailDto.getSkuName());
            differenceEo.setOsQuantity(threeDetailDto.getQuantity());
            differenceEo.setOsStatus(threeDetailDto.getInventoryProperty());
        }
        if (detailDto != null) {
            differenceEo.setOrderType(detailDto.getOrderType());
            differenceEo.setOrderStatus(detailDto.getRelevanceOrderStatus());
            differenceEo.setResultOrderNo(detailDto.getResultOrderNo());
            differenceEo.setRelevanceBizNo(detailDto.getRelevanceBizNo());
            differenceEo.setRelevanceOrderType(detailDto.getRelevanceOrderType());
            differenceEo.setRelevanceBizType(detailDto.getRelevanceBizType());
            differenceEo.setLogicWarehouseCode(detailDto.getLogicWarehouseCode());
            differenceEo.setLogicWarehouseName(detailDto.getLogicWarehouseName());
            differenceEo.setSkuCode(detailDto.getSkuCode());
            differenceEo.setSkuName(detailDto.getSkuName());
            differenceEo.setZtQuantity(detailDto.getQuantity());
            differenceEo.setZtBatch(detailDto.getBatch());
            differenceEo.setZtStatus(detailDto.getInventoryProperty());
            if (StringUtils.isEmpty((String)differenceEo.getOsOrderNo())) {
                String orderNo = StrUtil.nullToDefault((CharSequence)detailDto.getMatchOrderNo(), (String)detailDto.getResultOrderNo());
                differenceEo.setOsOrderNo(orderNo);
            }
        }
        return differenceEo;
    }

    public <T> List<T> loadInventoryPostDetails(SelectGeneric generic, Class<T> tClass) {
        log.info("[\u5e93\u5b58\u5355\u636e\u6bd4\u5bf9]\u5f00\u59cb\u62c9\u53d6\u6570\u636e\u5e93\u6570\u636e");
        PageHelper.startPage((int)1, (int)1000);
        log.info("generic:{}", (Object)JSON.toJSONString((Object)generic));
        Page page = this.selectGenericDas.queryPage(generic);
        List results = BeanUtil.copyToList((Collection)page.getResult(), tClass);
        int pages = page.getPages();
        log.info("[\u5e93\u5b58\u5355\u636e\u6bd4\u5bf9]\u62c9\u53d6\u6570\u636e\u5e93\u6570\u636e\u603b\u6570\uff1a{}", (Object)(pages * 1000));
        int cur = 1;
        while (cur++ < pages) {
            PageHelper.startPage((int)cur, (int)1000);
            page = this.selectGenericDas.queryPage(generic);
            results.addAll(BeanUtil.copyToList((Collection)page.getResult(), tClass));
        }
        log.info("[\u5e93\u5b58\u5355\u636e\u6bd4\u5bf9]\u62c9\u53d6\u6570\u636e\u5e93\u6570\u636e\u7ed3\u675f");
        return results;
    }

    public List<PmsInventoryPostDetailDto> merge(List<PmsInventoryPostDetailDto> details, List<KeyAssemblyStrategy> keyAssemblyStrategyList) {
        log.info("\u548c\u4e91\u9500\u62c9\u53d6\u5230\u6570\u636e\u6761\u6570\uff1a{}", (Object)details.size());
        HashMap<String, Object> keyAssemblyStrategySelector = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(keyAssemblyStrategyList)) {
            keyAssemblyStrategySelector.putAll(keyAssemblyStrategyList.stream().collect(Collectors.toMap(KeyAssemblyStrategy::type, Function.identity(), (k1, k2) -> k1)));
        }
        HashMap<String, BigDecimal> key2TotalQuantityMap = new HashMap<String, BigDecimal>();
        for (PmsInventoryPostDetailDto detail : details) {
            KeyAssemblyStrategy keyAssemblyStrategy = keyAssemblyStrategySelector.getOrDefault(detail.getRelevanceOrderType(), new DefaultKeyAssemblyStrategy());
            detail.setMatchKey(keyAssemblyStrategy.assembleKey(detail));
            String key = this.genKey(detail);
            key2TotalQuantityMap.merge(key, detail.getQuantity(), BigDecimal::add);
        }
        ArrayList<PmsInventoryPostDetailDto> results = new ArrayList<PmsInventoryPostDetailDto>();
        HashSet<String> keySet = new HashSet<String>();
        for (PmsInventoryPostDetailDto detail : details) {
            String key = this.genKey(detail);
            if (!keySet.add(key)) {
                detail = null;
                continue;
            }
            detail.setQuantity(key2TotalQuantityMap.getOrDefault(key, BigDecimal.ZERO));
            if (BigDecimalUtils.eqZero((BigDecimal)detail.getQuantity()).booleanValue()) continue;
            results.add(detail);
        }
        return results;
    }

    private Object getExtensionData(String str, String key) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        Map map = (Map)JSON.parseObject((String)str, Map.class);
        return map.get(key);
    }

    public List<ThreeInventoryPostDetailDto> merge3(List<ThreeInventoryPostDetailDto> details, List<KeyAssemblyStrategy> keyAssemblyStrategyList) {
        log.info("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u62c9\u53d6\u5230\u6570\u636e\u6761\u6570\uff1a{}", (Object)details.size());
        HashMap<String, Object> keyAssemblyStrategySelector = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(keyAssemblyStrategyList)) {
            keyAssemblyStrategySelector.putAll(keyAssemblyStrategyList.stream().collect(Collectors.toMap(KeyAssemblyStrategy::type, Function.identity(), (k1, k2) -> k1)));
        }
        HashMap<String, BigDecimal> key2TotalQuantityMap = new HashMap<String, BigDecimal>();
        for (ThreeInventoryPostDetailDto detail : details) {
            KeyAssemblyStrategy keyAssemblyStrategy = keyAssemblyStrategySelector.getOrDefault(detail.getOsOrderType(), new DefaultThreeKeyAssemblyStrategy());
            detail.setMatchKey(keyAssemblyStrategy.assembleKey(detail));
            String key = this.genKey(detail);
            key2TotalQuantityMap.merge(key, detail.getQuantity(), BigDecimal::add);
        }
        ArrayList<ThreeInventoryPostDetailDto> results = new ArrayList<ThreeInventoryPostDetailDto>();
        HashSet<String> keySet = new HashSet<String>();
        for (ThreeInventoryPostDetailDto detail : details) {
            String key = this.genKey(detail);
            if (!keySet.add(key)) {
                detail = null;
                continue;
            }
            detail.setQuantity(key2TotalQuantityMap.getOrDefault(key, BigDecimal.ZERO));
            if (BigDecimalUtils.eqZero((BigDecimal)detail.getQuantity()).booleanValue()) continue;
            results.add(detail);
        }
        return results;
    }

    public String genKey(PmsInventoryPostDetailDto detail) {
        return String.join((CharSequence)"__", detail.getMatchKey(), detail.getLogicWarehouseCode(), detail.getInventoryProperty(), detail.getSkuCode());
    }

    public String genKey(ThreeInventoryPostDetailDto detail) {
        return String.join((CharSequence)"__", detail.getMatchKey(), detail.getWarehouseCode(), detail.getInventoryProperty(), detail.getSkuCode());
    }

    private class AddResult {
        private InventoryDocumentCompareContext context;
        private Map<String, List<ThreeInventoryPostDetailDto>> key2ThreeInventoryPostDetailMap;
        private int threeNoRecordNum;
        private int compareNum;
        private List<ReconciliationDifferenceDto> result;
        private PmsInventoryPostDetailDto detailDto;
        private String detailKey;
        private ThreeInventoryPostDetailDto threeDetailDto;

        public AddResult(InventoryDocumentCompareContext context, Map<String, List<ThreeInventoryPostDetailDto>> key2ThreeInventoryPostDetailMap, int threeNoRecordNum, int compareNum, List<ReconciliationDifferenceDto> result, PmsInventoryPostDetailDto detailDto, String detailKey, ThreeInventoryPostDetailDto threeDetailDto) {
            this.context = context;
            this.key2ThreeInventoryPostDetailMap = key2ThreeInventoryPostDetailMap;
            this.threeNoRecordNum = threeNoRecordNum;
            this.compareNum = compareNum;
            this.result = result;
            this.detailDto = detailDto;
            this.detailKey = detailKey;
            this.threeDetailDto = threeDetailDto;
        }

        public int getThreeNoRecordNum() {
            return this.threeNoRecordNum;
        }

        public int getCompareNum() {
            return this.compareNum;
        }

        public PmsInventoryPostDetailDto getDetailDto() {
            return this.detailDto;
        }

        public List<ReconciliationDifferenceDto> getResult() {
            return this.result;
        }

        public AddResult invoke() {
            ReconciliationDifferenceDto differenceEo = InventoryDocumentComparator.this.buildReconciliationDifferenceEo(this.detailDto, this.threeDetailDto);
            differenceEo.setReconciliationTime(this.context.getReconciliationTime());
            differenceEo.setSource(this.context.getTargetObject());
            String difference = String.valueOf(DifferenceResultStatusEnum.INCONSISTENT.getValue());
            String differenceReason = String.valueOf(DifferenceReasonEnum.OS_NO_RECORD.getValue());
            BigDecimal osQuantity = BigDecimal.ZERO;
            if (this.threeDetailDto != null) {
                ++this.compareNum;
                differenceReason = difference = String.valueOf(Math.abs(this.detailDto.getQuantity().compareTo(this.threeDetailDto.getQuantity())));
                osQuantity = this.threeDetailDto.getQuantity();
                this.key2ThreeInventoryPostDetailMap.remove(this.detailKey);
            } else {
                ++this.threeNoRecordNum;
            }
            differenceEo.setResult(difference);
            differenceEo.setDifferenceReason(differenceReason);
            differenceEo.setDifferenceNum(BigDecimalUtils.subtract((BigDecimal)this.detailDto.getQuantity(), (BigDecimal)osQuantity));
            this.result.add(differenceEo);
            return this;
        }
    }
}

